package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.MovimientosDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Movimientos;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * MovimientosServiceImpl  
 * 
 *  
 */

@Service(value = "movimientosService")
public class MovimientosServiceImpl implements MovimientosService {

	@Autowired
	private MovimientosDao movimientosDao;

	/**
	 * Inserts a single row in the Movimientos table.
	 * 
	 * @param movimientos
	 *            Movimientos
	 * @return Movimientos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Movimientos add(Movimientos movimientos) {
		movimientos.setSfcodigo(Y41bUIDGenerator.getInstance().generateId(
				Y41bConstantes.PK_SIZE));
		return this.movimientosDao.add(movimientos);
	}

	/**
	 * Updates a single row in the Movimientos table.
	 * 
	 * @param movimientos
	 *            Movimientos
	 * @return Movimientos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Movimientos update(Movimientos movimientos) {
		return this.movimientosDao.update(movimientos);
	}

	/**
	 * Finds a single row in the Movimientos table.
	 * 
	 * @param movimientos
	 *            Movimientos
	 * @return Movimientos
	 */
	public Movimientos find(Movimientos movimientos) {
		return (Movimientos) this.movimientosDao.find(movimientos);
	}

	/**
	 * Finds a List of rows in the Movimientos table.
	 * 
	 * @param movimientos
	 *            Movimientos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Movimientos> findAll(Movimientos movimientos,
			Pagination pagination) {
		return (List<Movimientos>) this.movimientosDao.findAll(movimientos,
				pagination);
	}

	/**
	 * Counts rows in the Movimientos table.
	 * 
	 * @param movimientos
	 *            Movimientos
	 * @return Long
	 */
	public Long findAllCount(Movimientos movimientos) {
		return this.movimientosDao.findAllCount(movimientos);
	}

	/**
	 * Finds rows in the Movimientos table using like.
	 * 
	 * @param movimientos
	 *            Movimientos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Movimientos> findAllLike(Movimientos movimientos,
			Pagination pagination, Boolean startsWith) {
		return (List<Movimientos>) this.movimientosDao.findAllLike(movimientos,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Movimientos table using like.
	 * 
	 * @param movimientos
	 *            Movimientos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Movimientos movimientos, Boolean startsWith) {
		return this.movimientosDao.findAllLikeCount(movimientos, startsWith);
	}

	/**
	 * Deletes a single row in the Movimientos table.
	 * 
	 * @param movimientos
	 *            Movimientos
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Movimientos movimientos) {
		this.movimientosDao.remove(movimientos);
	}

	/**
	 * Deletes multiple rows in the Movimientos table.
	 * 
	 * @param movimientosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Movimientos> movimientosList) {
		for (Movimientos movimientosAux : movimientosList) {
			this.movimientosDao.remove(movimientosAux);
		}
	}

}
