package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.MotivosSolcolaboracionDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.MotivosSolcolaboracion;

/**
 * MotivosSolcolaboracionServiceImpl  
 *  
 */

@Service(value = "motivosSolcolaboracionService")
public class MotivosSolcolaboracionServiceImpl implements MotivosSolcolaboracionService {

	@Autowired
	private MotivosSolcolaboracionDao motivosSolcolaboracionDao;

	/**
	 * Inserts a single row in the MotivosSolcolaboracion table.
	 *
	 * @param motivosSolcolaboracion MotivosSolcolaboracion
	 * @return MotivosSolcolaboracion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public MotivosSolcolaboracion add(MotivosSolcolaboracion motivosSolcolaboracion) {
		return this.motivosSolcolaboracionDao.add(motivosSolcolaboracion);
	}

	/**
	 * Updates a single row in the MotivosSolcolaboracion table.
	 *
	 * @param motivosSolcolaboracion MotivosSolcolaboracion
	 * @return MotivosSolcolaboracion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public MotivosSolcolaboracion update(MotivosSolcolaboracion motivosSolcolaboracion) {
		return this.motivosSolcolaboracionDao.update(motivosSolcolaboracion);
	 }

	/**
	 * Finds a single row in the MotivosSolcolaboracion table.
	 *
	 * @param motivosSolcolaboracion MotivosSolcolaboracion
	 * @return MotivosSolcolaboracion
	 */
	public MotivosSolcolaboracion find(MotivosSolcolaboracion motivosSolcolaboracion) {
		return (MotivosSolcolaboracion) this.motivosSolcolaboracionDao.find(motivosSolcolaboracion);
	}

	/**
	 * Finds a List of rows in the MotivosSolcolaboracion table.
	 *
	 * @param motivosSolcolaboracion MotivosSolcolaboracion
	 * @param pagination Pagination
	 * @return List
	 */
	public List<MotivosSolcolaboracion> findAll(MotivosSolcolaboracion motivosSolcolaboracion, Pagination pagination) {
		return (List<MotivosSolcolaboracion>) this.motivosSolcolaboracionDao.findAll(motivosSolcolaboracion, pagination);
	}
    
	/**
	 * Counts rows in the MotivosSolcolaboracion table.
	 *
	 * @param motivosSolcolaboracion MotivosSolcolaboracion
	 * @return Long
	 */
	public Long findAllCount(MotivosSolcolaboracion motivosSolcolaboracion) {        
		return  this.motivosSolcolaboracionDao.findAllCount(motivosSolcolaboracion);
	}

	/**
	 * Finds rows in the MotivosSolcolaboracion table using like.
	 *
	 * @param motivosSolcolaboracion MotivosSolcolaboracion
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<MotivosSolcolaboracion> findAllLike(MotivosSolcolaboracion motivosSolcolaboracion, Pagination pagination, Boolean startsWith) {
		return (List<MotivosSolcolaboracion>) this.motivosSolcolaboracionDao.findAllLike(motivosSolcolaboracion, pagination, startsWith);
	}

	/**
	 * Counts rows in the MotivosSolcolaboracion table using like.
	 *
	 * @param motivosSolcolaboracion MotivosSolcolaboracion
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(MotivosSolcolaboracion motivosSolcolaboracion, Boolean startsWith) {
		return this.motivosSolcolaboracionDao.findAllLikeCount(motivosSolcolaboracion, startsWith);
	}
	    
	/**
	 * Deletes a single row in the MotivosSolcolaboracion table.
	 *
	 * @param motivosSolcolaboracion MotivosSolcolaboracion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(MotivosSolcolaboracion motivosSolcolaboracion) {
		this.motivosSolcolaboracionDao.remove(motivosSolcolaboracion);
	}
	
	/**
	 * Deletes multiple rows in the MotivosSolcolaboracion table.
	 *
	 * @param motivosSolcolaboracionList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<MotivosSolcolaboracion> motivosSolcolaboracionList) {
		for (MotivosSolcolaboracion  motivosSolcolaboracionAux:motivosSolcolaboracionList) {
			this.motivosSolcolaboracionDao.remove(motivosSolcolaboracionAux);
		}
	}
	
}

