package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.ProdAgrupado;
import com.ejie.y41b.model.Producto;

/**
 * * MotivoService  
 * 
 *  
 */

public interface MotivoService {

	/**
	 * Inserts a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	Motivo add(Motivo motivo);

	/**
	 * Inserts a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param codMotivoAlta
	 *            String
	 * @return Motivo
	 */
	public Motivo addMotivo(Motivo motivo, String codMotivoAlta);

	/**
	 * Updates a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	Motivo update(Motivo motivo);

	/**
	 * Updates a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	public Motivo updateFechaBaja(Motivo motivo);

	/**
	 * Updates a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	public Motivo updateMotivo(Motivo motivo);

	/**
	 * Finds a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	Motivo find(Motivo motivo);

	/**
	 * Finds a List of rows in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Motivo> findAll(Motivo motivo, Pagination pagination);

	/**
	 * Counts rows in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Long
	 */
	Long findAllCount(Motivo motivo);

	/**
	 * Finds rows in the Motivo table using like.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Motivo> findAllLike(Motivo motivo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Motivo table using like.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Motivo motivo, Boolean startsWith);

	/**
	 * Deletes a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return
	 */
	void remove(Motivo motivo);

	/**
	 * Deletes a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return
	 */
	public void removeMotivo(Motivo motivo);

	/**
	 * Deletes multiple rows in the Motivo table.
	 * 
	 * @param motivoList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Motivo> motivoList);

	/**
	 * Inserts a single row in the ProdMotivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	Motivo addProdMotivo(Motivo motivo);

	/**
	 * Deletes a single row in the ProdMotivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 */
	void removeProdMotivo(Motivo motivo);

	/**
	 * Find a single row in the findProdMotivo Many To Many relationship.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param prodagrupado
	 *            ProdAgrupado
	 * @param pagination
	 *            Pagination
	 * @return Motivo
	 */
	Motivo findProdMotivo(Motivo motivo, ProdAgrupado prodagrupado,
			Pagination pagination);

	/**
	 * Counts rows in the ProdMotivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param prodagrupado
	 *            ProdAgrupado
	 * @return List
	 */
	Long findProdMotivoCount(Motivo motivo, ProdAgrupado prodagrupado);

	/**
	 * Finds a List of rows in the Motivo table of Producto.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Motivo> findAllMotivoProducto(Producto producto, Pagination pagination);

	/**
	 * Finds a List of rows in the Motivo table of Producto.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Motivo> findAllMotivoProductoAlta(Producto producto,
			Pagination pagination);

}
