package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.MetodopagoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Metodopago;

/**
 * MetodopagoServiceImpl  
 * 
 *  
 */

@Service(value = "metodopagoService")
public class MetodopagoServiceImpl implements MetodopagoService {

	@Autowired()
	private MetodopagoDao metodopagoDao;

	/**
	 * Inserts a single row in the Metodopago table.
	 * 
	 * @param metodopago
	 *            Metodopago
	 * @return Metodopago
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Metodopago add(Metodopago metodopago) {
		return this.metodopagoDao.add(metodopago);
	}

	/**
	 * Updates a single row in the Metodopago table.
	 * 
	 * @param metodopago
	 *            Metodopago
	 * @return Metodopago
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Metodopago update(Metodopago metodopago) {
		return this.metodopagoDao.update(metodopago);
	}

	/**
	 * Finds a single row in the Metodopago table.
	 * 
	 * @param metodopago
	 *            Metodopago
	 * @return Metodopago
	 */
	public Metodopago find(Metodopago metodopago) {
		return (Metodopago) this.metodopagoDao.find(metodopago);
	}

	/**
	 * Finds a List of rows in the Metodopago table.
	 * 
	 * @param metodopago
	 *            Metodopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Metodopago> findAll(Metodopago metodopago, Pagination pagination) {
		return (List<Metodopago>) this.metodopagoDao.findAll(metodopago,
				pagination);
	}

	/**
	 * Counts rows in the Metodopago table.
	 * 
	 * @param metodopago
	 *            Metodopago
	 * @return Long
	 */
	public Long findAllCount(Metodopago metodopago) {
		return this.metodopagoDao.findAllCount(metodopago);
	}

	/**
	 * Finds rows in the Metodopago table using like.
	 * 
	 * @param metodopago
	 *            Metodopago
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Metodopago> findAllLike(Metodopago metodopago,
			Pagination pagination, Boolean startsWith) {
		return (List<Metodopago>) this.metodopagoDao.findAllLike(metodopago,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Metodopago table using like.
	 * 
	 * @param metodopago
	 *            Metodopago
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Metodopago metodopago, Boolean startsWith) {
		return this.metodopagoDao.findAllLikeCount(metodopago, startsWith);
	}

	/**
	 * Deletes a single row in the Metodopago table.
	 * 
	 * @param metodopago
	 *            Metodopago
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Metodopago metodopago) {
		this.metodopagoDao.remove(metodopago);
	}

	/**
	 * Deletes multiple rows in the Metodopago table.
	 * 
	 * @param metodopagoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Metodopago> metodopagoList) {
		for (Metodopago metodopagoAux : metodopagoList) {
			this.metodopagoDao.remove(metodopagoAux);
		}
	}

}
