package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.MensajecolaDao;
import com.ejie.y41b.model.Mensajecola;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * MensajecolaServiceImpl  
 * 
 *  
 */

@Service(value = "mensajecolaService")
public class MensajecolaServiceImpl implements MensajecolaService {

	@Autowired
	private MensajecolaDao mensajecolaDao;

	/**
	 * Inserts a single row in the Mensajecola table.
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 * @return Mensajecola
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public Mensajecola add(Mensajecola mensajecola) {
		mensajecola.setSwcodmensaje(Y41bUIDGenerator.getInstance().generateId(
				Y41bConstantes.PK_SIZE));
		if (mensajecola.getSwfecrecepcion() == null) {
			mensajecola.setSwfecrecepcion(Y41bUtils.obtenerFechaHoy());
		}

		return this.mensajecolaDao.add(mensajecola);
	}

	/**
	 * Updates a single row in the Mensajecola table.
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 * @return Mensajecola
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Mensajecola update(Mensajecola mensajecola) {
		return this.mensajecolaDao.update(mensajecola);
	}

	/**
	 * Finds a single row in the Mensajecola table.
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 * @return Mensajecola
	 */
	public Mensajecola find(Mensajecola mensajecola) {
		return (Mensajecola) this.mensajecolaDao.find(mensajecola);
	}

	/**
	 * Finds a List of rows in the Mensajecola table.
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Mensajecola> findAll(Mensajecola mensajecola,
			Pagination pagination) {
		return (List<Mensajecola>) this.mensajecolaDao.findAll(mensajecola,
				pagination);
	}

	/**
	 * Counts rows in the Mensajecola table.
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 * @return Long
	 */
	public Long findAllCount(Mensajecola mensajecola) {
		return this.mensajecolaDao.findAllCount(mensajecola);
	}

	/**
	 * Finds rows in the Mensajecola table using like.
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Mensajecola> findAllLike(Mensajecola mensajecola,
			Pagination pagination, Boolean startsWith) {
		return (List<Mensajecola>) this.mensajecolaDao.findAllLike(mensajecola,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Mensajecola table using like.
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Mensajecola mensajecola, Boolean startsWith) {
		return this.mensajecolaDao.findAllLikeCount(mensajecola, startsWith);
	}

	/**
	 * Deletes a single row in the Mensajecola table.
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Mensajecola mensajecola) {
		this.mensajecolaDao.remove(mensajecola);
	}

	/**
	 * Deletes multiple rows in the Mensajecola table.
	 * 
	 * @param mensajecolaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Mensajecola> mensajecolaList) {
		for (Mensajecola mensajecolaAux : mensajecolaList) {
			this.mensajecolaDao.remove(mensajecolaAux);
		}
	}

	/**
	 * Guardar el mensaje recibido en la cola. SIN TRANSACCIONALIDAD
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 */
	public void guardarMensaje(Mensajecola mensajecola) {

		mensajecola.setSwcodmensaje(Y41bUIDGenerator.getInstance().generateId(
				Y41bConstantes.PK_SIZE));
		if (mensajecola.getSwfecrecepcion() == null) {
			mensajecola.setSwfecrecepcion(Y41bUtils.obtenerFechaHoy());
		}

		this.mensajecolaDao.add(mensajecola);
	}
}
