package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.LocalidaDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Localida;

/**
 * LocalidaServiceImpl  
 *  
 */

@Service(value = "localidaService")
public class LocalidaServiceImpl implements LocalidaService {

	@Autowired
	private LocalidaDao localidaDao;

	/**
	 * Inserts a single row in the Localida table.
	 *
	 * @param localida Localida
	 * @return Localida
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Localida add(Localida localida) {
		return this.localidaDao.add(localida);
	}

	/**
	 * Updates a single row in the Localida table.
	 *
	 * @param localida Localida
	 * @return Localida
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Localida update(Localida localida) {
		return this.localidaDao.update(localida);
	 }

	/**
	 * Finds a single row in the Localida table.
	 *
	 * @param localida Localida
	 * @return Localida
	 */
	public Localida find(Localida localida) {
		return (Localida) this.localidaDao.find(localida);
	}

	/**
	 * Finds a List of rows in the Localida table.
	 *
	 * @param localida Localida
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Localida> findAll(Localida localida, Pagination pagination) {
		return (List<Localida>) this.localidaDao.findAll(localida, pagination);
	}
    
	/**
	 * Counts rows in the Localida table.
	 *
	 * @param localida Localida
	 * @return Long
	 */
	public Long findAllCount(Localida localida) {        
		return  this.localidaDao.findAllCount(localida);
	}

	/**
	 * Finds rows in the Localida table using like.
	 *
	 * @param localida Localida
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Localida> findAllLike(Localida localida, Pagination pagination, Boolean startsWith) {
		return (List<Localida>) this.localidaDao.findAllLike(localida, pagination, startsWith);
	}

	/**
	 * Counts rows in the Localida table using like.
	 *
	 * @param localida Localida
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Localida localida, Boolean startsWith) {
		return this.localidaDao.findAllLikeCount(localida, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Localida table.
	 *
	 * @param localida Localida
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Localida localida) {
		this.localidaDao.remove(localida);
	}
	
	/**
	 * Deletes multiple rows in the Localida table.
	 *
	 * @param localidaList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Localida> localidaList) {
		for (Localida  localidaAux:localidaList) {
			this.localidaDao.remove(localidaAux);
		}
	}
	
}

