package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Localida;

/**
 * LocalidaService  
 *  
 */

public interface LocalidaService {

	/**
	 * Inserts a single row in the Localida table.
	 *
	 * @param localida Localida
	 * @return Localida
	 */
    Localida add(Localida localida);

	/**
	 * Updates a single row in the Localida table.
	 *
	 * @param localida Localida
	 * @return Localida
	 */
	Localida update(Localida localida);

	/**
	 * Finds a single row in the Localida table.
	 *
	 * @param localida Localida
	 * @return Localida
	 */
	Localida find(Localida localida);

	/**
	 * Finds a List of rows in the Localida table.
	 *
	 * @param localida Localida
	 * @param pagination Pagination
	 * @return List
	 */
	List<Localida> findAll(Localida localida, Pagination pagination);

	/**
	 * Counts rows in the Localida table.
	 *
	 * @param localida Localida
	 * @return Long
	 */
	Long findAllCount(Localida localida);
	
	/**
	 * Finds rows in the Localida table using like.
	 *
	 * @param localida Localida
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Localida> findAllLike(Localida localida, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the Localida table using like.
	 *
	 * @param localida Localida
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(Localida localida, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Localida table.
	 *
	 * @param localida Localida
	 * @return 
	 */
	void remove(Localida localida);
	
	/**
	 * Deletes multiple rows in the Localida table.
	 *
	 * @param localidaList List
	 * @return 
	 */	
	void removeMultiple(List<Localida> localidaList);
    
}


