package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.LaudosTipoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.LaudosTipo;

/**
 * LaudosTipoServiceImpl  
 *  
 */

@Service(value = "laudosTipoService")
public class LaudosTipoServiceImpl implements LaudosTipoService {

	@Autowired
	private LaudosTipoDao laudosTipoDao;

	/**
	 * Inserts a single row in the LaudosTipo table.
	 *
	 * @param laudosTipo LaudosTipo
	 * @return LaudosTipo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public LaudosTipo add(LaudosTipo laudosTipo) {
		return this.laudosTipoDao.add(laudosTipo);
	}

	/**
	 * Updates a single row in the LaudosTipo table.
	 *
	 * @param laudosTipo LaudosTipo
	 * @return LaudosTipo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public LaudosTipo update(LaudosTipo laudosTipo) {
		return this.laudosTipoDao.update(laudosTipo);
	 }

	/**
	 * Finds a single row in the LaudosTipo table.
	 *
	 * @param laudosTipo LaudosTipo
	 * @return LaudosTipo
	 */
	public LaudosTipo find(LaudosTipo laudosTipo) {
		return (LaudosTipo) this.laudosTipoDao.find(laudosTipo);
	}

	/**
	 * Finds a List of rows in the LaudosTipo table.
	 *
	 * @param laudosTipo LaudosTipo
	 * @param pagination Pagination
	 * @return List
	 */
	public List<LaudosTipo> findAll(LaudosTipo laudosTipo, Pagination pagination) {
		return (List<LaudosTipo>) this.laudosTipoDao.findAll(laudosTipo, pagination);
	}
    
	/**
	 * Counts rows in the LaudosTipo table.
	 *
	 * @param laudosTipo LaudosTipo
	 * @return Long
	 */
	public Long findAllCount(LaudosTipo laudosTipo) {        
		return  this.laudosTipoDao.findAllCount(laudosTipo);
	}

	/**
	 * Finds rows in the LaudosTipo table using like.
	 *
	 * @param laudosTipo LaudosTipo
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<LaudosTipo> findAllLike(LaudosTipo laudosTipo, Pagination pagination, Boolean startsWith) {
		return (List<LaudosTipo>) this.laudosTipoDao.findAllLike(laudosTipo, pagination, startsWith);
	}

	/**
	 * Counts rows in the LaudosTipo table using like.
	 *
	 * @param laudosTipo LaudosTipo
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(LaudosTipo laudosTipo, Boolean startsWith) {
		return this.laudosTipoDao.findAllLikeCount(laudosTipo, startsWith);
	}
	    
	/**
	 * Deletes a single row in the LaudosTipo table.
	 *
	 * @param laudosTipo LaudosTipo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(LaudosTipo laudosTipo) {
		this.laudosTipoDao.remove(laudosTipo);
	}
	
	/**
	 * Deletes multiple rows in the LaudosTipo table.
	 *
	 * @param laudosTipoList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<LaudosTipo> laudosTipoList) {
		for (LaudosTipo  laudosTipoAux:laudosTipoList) {
			this.laudosTipoDao.remove(laudosTipoAux);
		}
	}
	
}

