package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.LaudosTipo;

/**
 * LaudosTipoService  
 *  
 */

public interface LaudosTipoService {

	/**
	 * Inserts a single row in the LaudosTipo table.
	 *
	 * @param laudosTipo LaudosTipo
	 * @return LaudosTipo
	 */
    LaudosTipo add(LaudosTipo laudosTipo);

	/**
	 * Updates a single row in the LaudosTipo table.
	 *
	 * @param laudosTipo LaudosTipo
	 * @return LaudosTipo
	 */
	LaudosTipo update(LaudosTipo laudosTipo);

	/**
	 * Finds a single row in the LaudosTipo table.
	 *
	 * @param laudosTipo LaudosTipo
	 * @return LaudosTipo
	 */
	LaudosTipo find(LaudosTipo laudosTipo);

	/**
	 * Finds a List of rows in the LaudosTipo table.
	 *
	 * @param laudosTipo LaudosTipo
	 * @param pagination Pagination
	 * @return List
	 */
	List<LaudosTipo> findAll(LaudosTipo laudosTipo, Pagination pagination);

	/**
	 * Counts rows in the LaudosTipo table.
	 *
	 * @param laudosTipo LaudosTipo
	 * @return Long
	 */
	Long findAllCount(LaudosTipo laudosTipo);
	
	/**
	 * Finds rows in the LaudosTipo table using like.
	 *
	 * @param laudosTipo LaudosTipo
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<LaudosTipo> findAllLike(LaudosTipo laudosTipo, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the LaudosTipo table using like.
	 *
	 * @param laudosTipo LaudosTipo
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(LaudosTipo laudosTipo, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the LaudosTipo table.
	 *
	 * @param laudosTipo LaudosTipo
	 * @return 
	 */
	void remove(LaudosTipo laudosTipo);
	
	/**
	 * Deletes multiple rows in the LaudosTipo table.
	 *
	 * @param laudosTipoList List
	 * @return 
	 */	
	void removeMultiple(List<LaudosTipo> laudosTipoList);
    
}


