package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.LaudosAdoptadoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.LaudosAdoptado;

/**
 * LaudosAdoptadoServiceImpl  
 *  
 */

@Service(value = "laudosAdoptadoService")
public class LaudosAdoptadoServiceImpl implements LaudosAdoptadoService {

	@Autowired
	private LaudosAdoptadoDao laudosAdoptadoDao;

	/**
	 * Inserts a single row in the LaudosAdoptado table.
	 *
	 * @param laudosAdoptado LaudosAdoptado
	 * @return LaudosAdoptado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public LaudosAdoptado add(LaudosAdoptado laudosAdoptado) {
		return this.laudosAdoptadoDao.add(laudosAdoptado);
	}

	/**
	 * Updates a single row in the LaudosAdoptado table.
	 *
	 * @param laudosAdoptado LaudosAdoptado
	 * @return LaudosAdoptado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public LaudosAdoptado update(LaudosAdoptado laudosAdoptado) {
		return this.laudosAdoptadoDao.update(laudosAdoptado);
	 }

	/**
	 * Finds a single row in the LaudosAdoptado table.
	 *
	 * @param laudosAdoptado LaudosAdoptado
	 * @return LaudosAdoptado
	 */
	public LaudosAdoptado find(LaudosAdoptado laudosAdoptado) {
		return (LaudosAdoptado) this.laudosAdoptadoDao.find(laudosAdoptado);
	}

	/**
	 * Finds a List of rows in the LaudosAdoptado table.
	 *
	 * @param laudosAdoptado LaudosAdoptado
	 * @param pagination Pagination
	 * @return List
	 */
	public List<LaudosAdoptado> findAll(LaudosAdoptado laudosAdoptado, Pagination pagination) {
		return (List<LaudosAdoptado>) this.laudosAdoptadoDao.findAll(laudosAdoptado, pagination);
	}
    
	/**
	 * Counts rows in the LaudosAdoptado table.
	 *
	 * @param laudosAdoptado LaudosAdoptado
	 * @return Long
	 */
	public Long findAllCount(LaudosAdoptado laudosAdoptado) {        
		return  this.laudosAdoptadoDao.findAllCount(laudosAdoptado);
	}

	/**
	 * Finds rows in the LaudosAdoptado table using like.
	 *
	 * @param laudosAdoptado LaudosAdoptado
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<LaudosAdoptado> findAllLike(LaudosAdoptado laudosAdoptado, Pagination pagination, Boolean startsWith) {
		return (List<LaudosAdoptado>) this.laudosAdoptadoDao.findAllLike(laudosAdoptado, pagination, startsWith);
	}

	/**
	 * Counts rows in the LaudosAdoptado table using like.
	 *
	 * @param laudosAdoptado LaudosAdoptado
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(LaudosAdoptado laudosAdoptado, Boolean startsWith) {
		return this.laudosAdoptadoDao.findAllLikeCount(laudosAdoptado, startsWith);
	}
	    
	/**
	 * Deletes a single row in the LaudosAdoptado table.
	 *
	 * @param laudosAdoptado LaudosAdoptado
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(LaudosAdoptado laudosAdoptado) {
		this.laudosAdoptadoDao.remove(laudosAdoptado);
	}
	
	/**
	 * Deletes multiple rows in the LaudosAdoptado table.
	 *
	 * @param laudosAdoptadoList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<LaudosAdoptado> laudosAdoptadoList) {
		for (LaudosAdoptado  laudosAdoptadoAux:laudosAdoptadoList) {
			this.laudosAdoptadoDao.remove(laudosAdoptadoAux);
		}
	}
	
}

