package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.LaboratorioDao;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.Laboratorio;

/**
 * LaboratorioServiceImpl  
 * 
 *  
 */

@Service(value = "laboratorioService")
public class LaboratorioServiceImpl implements LaboratorioService {

	@Autowired
	private LaboratorioDao laboratorioDao;
	@Autowired
	private DocumentoHechoDao documentoHechoDao;
	@Autowired
	private AdjuntardocsDao adjuntardocsDao;

	/**
	 * Inserts a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @return Laboratorio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Laboratorio add(Laboratorio laboratorio) {
		return this.laboratorioDao.add(laboratorio);
	}

	/**
	 * Inserts a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @param codLaboratorioAlta
	 *            String
	 * @return Laboratorio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Laboratorio addLaboratorio(Laboratorio laboratorio,
			String codLaboratorioAlta) {
		Laboratorio laboratorioAux = this.laboratorioDao
				.findNextPK(laboratorio);
		laboratorio.setLacodigo(laboratorioAux.getLacodigo());
		this.laboratorioDao.add(laboratorio);

		this.documentoHechoDao.addAllDocumentosAdjuntarDocs(
				laboratorio.getLacodigo(), codLaboratorioAlta);

		this.adjuntardocsDao.removeAllDocsTableTemporal(codLaboratorioAlta);

		return laboratorio;
	}

	/**
	 * Updates a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @return Laboratorio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Laboratorio update(Laboratorio laboratorio) {
		laboratorio = this.laboratorioDao.update(laboratorio);

		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5hdcodigo(laboratorio.getLacodigo());
		this.documentoHechoDao.removeDocsExpediente(documentoHecho);

		this.documentoHechoDao.addAllDocumentosAdjuntarDocs(
				laboratorio.getLacodigo(), laboratorio.getLacodigo());

		this.adjuntardocsDao.removeAllDocsTableTemporal(laboratorio
				.getLacodigo());

		return laboratorio;
	}

	/**
	 * Finds a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @return Laboratorio
	 */
	public Laboratorio find(Laboratorio laboratorio) {
		Laboratorio laboratorioAux = (Laboratorio) this.laboratorioDao
				.find(laboratorio);

		StringBuffer direccionAntiguaCompleta = new StringBuffer();

		String lanodir = (laboratorioAux.getLanodir() == null) ? ""
				: laboratorioAux.getLanodir();
		String lanrcopo = (laboratorioAux.getLanrcopo() == null) ? ""
				: laboratorioAux.getLanrcopo();

		direccionAntiguaCompleta.append(lanodir).append(" ").append(lanrcopo);

		laboratorioAux.setDireccionAntiguaCompleta(direccionAntiguaCompleta
				.toString());

		return laboratorioAux;
	}

	/**
	 * Finds a List of rows in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Laboratorio> findAll(Laboratorio laboratorio,
			Pagination pagination) {
		return (List<Laboratorio>) this.laboratorioDao.findAll(laboratorio,
				pagination);
	}

	/**
	 * Counts rows in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @return Long
	 */
	public Long findAllCount(Laboratorio laboratorio) {
		return this.laboratorioDao.findAllCount(laboratorio);
	}

	/**
	 * Finds rows in the Laboratorio table using like.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Laboratorio> findAllLike(Laboratorio laboratorio,
			Pagination pagination, Boolean startsWith) {
		return (List<Laboratorio>) this.laboratorioDao.findAllLike(laboratorio,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Laboratorio table using like.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Laboratorio laboratorio, Boolean startsWith) {
		return this.laboratorioDao.findAllLikeCount(laboratorio, startsWith);
	}

	/**
	 * Deletes a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Laboratorio laboratorio) {
		this.laboratorioDao.remove(laboratorio);
	}

	/**
	 * Deletes a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeLaboratorioBBDD(Laboratorio laboratorio) {
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5hdcodigo(laboratorio.getLacodigo());
		this.documentoHechoDao.removeDocsExpediente(documentoHecho);

		this.laboratorioDao.remove(laboratorio);
	}

	/**
	 * Updates a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateFechaBaja(Laboratorio laboratorio) {
		this.laboratorioDao.updateFechaBaja(laboratorio);
	}

	/**
	 * Deletes multiple rows in the Laboratorio table.
	 * 
	 * @param laboratorioList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Laboratorio> laboratorioList) {
		for (Laboratorio laboratorioAux : laboratorioList) {
			this.laboratorioDao.remove(laboratorioAux);
		}
	}

}
