package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Laboratorio;

/**
 * LaboratorioService  
 * 
 *  
 */

public interface LaboratorioService {

	/**
	 * Inserts a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @return Laboratorio
	 */
	Laboratorio add(Laboratorio laboratorio);

	/**
	 * Inserts a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @param codLaboratorioAlta
	 *            String
	 * @return Laboratorio
	 */
	public Laboratorio addLaboratorio(Laboratorio laboratorio,
			String codLaboratorioAlta);

	/**
	 * Updates a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @return Laboratorio
	 */
	Laboratorio update(Laboratorio laboratorio);

	/**
	 * Finds a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @return Laboratorio
	 */
	Laboratorio find(Laboratorio laboratorio);

	/**
	 * Finds a List of rows in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Laboratorio> findAll(Laboratorio laboratorio, Pagination pagination);

	/**
	 * Counts rows in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @return Long
	 */
	Long findAllCount(Laboratorio laboratorio);

	/**
	 * Finds rows in the Laboratorio table using like.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Laboratorio> findAllLike(Laboratorio laboratorio,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Laboratorio table using like.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Laboratorio laboratorio, Boolean startsWith);

	/**
	 * Deletes a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @return
	 */
	void remove(Laboratorio laboratorio);

	/**
	 * Deletes a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 */
	public void removeLaboratorioBBDD(Laboratorio laboratorio);

	/**
	 * Updates a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 */
	public void updateFechaBaja(Laboratorio laboratorio);

	/**
	 * Deletes multiple rows in the Laboratorio table.
	 * 
	 * @param laboratorioList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Laboratorio> laboratorioList);

}
