package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.JjaaDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.model.Jjaa;
import com.ejie.y41b.model.Organismo;

/**
 * JjaaServiceImpl  
 * 
 *  
 */

@Service(value = "jjaaService")
public class JjaaServiceImpl implements JjaaService {

	@Autowired()
	private JjaaDao jjaaDao;

	@Autowired()
	private OrganismoDao organismoDao;

	/**
	 * Inserts a single row in the Jjaa table.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @return Jjaa
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Jjaa add(Jjaa jjaa) {
		return this.jjaaDao.add(jjaa);
	}

	/**
	 * Updates a single row in the Jjaa table.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @return Jjaa
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Jjaa update(Jjaa jjaa) {
		return this.jjaaDao.update(jjaa);
	}

	/**
	 * Finds a single row in the Jjaa table.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @return Jjaa
	 */
	public Jjaa find(Jjaa jjaa) {

		Jjaa jjaaDetalle = this.jjaaDao.find(jjaa);
		Organismo organismo = new Organismo();
		organismo.setCodOrg(jjaa.getJacodigo());
		organismo = this.organismoDao.find(organismo);
		jjaaDetalle.setOrganismo(organismo);

		return jjaaDetalle;
	}

	/**
	 * Finds a List of rows in the Jjaa table.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Jjaa> findAll(Jjaa jjaa, Pagination pagination) {
		if (pagination.getSort() != null
				&& pagination.getSort().equals("organismo.nombreEs")) {
			pagination.setSort("OrganismoNOMBREES");
		}
		if (pagination.getSort() != null
				&& pagination.getSort().equals("organismo.nombreEu")) {
			pagination.setSort("OrganismoNOMBREEU");
		}
		if (pagination.getSort() != null
				&& pagination.getSort().equals("organismo.nombreProvincia")) {
			pagination.setSort("OrganismoNOMBREPROVINCIA");
		}
		if (pagination.getSort() != null
				&& pagination.getSort().equals("organismo.nombreMunicipio")) {
			pagination.setSort("OrganismoNOMBREMUNICIPIO");
		}
		return (List<Jjaa>) this.jjaaDao.findAll(jjaa, pagination);
	}

	/**
	 * Counts rows in the Jjaa table.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @return Long
	 */
	public Long findAllCount(Jjaa jjaa) {
		return this.jjaaDao.findAllCount(jjaa);
	}

	/**
	 * Finds rows in the Jjaa table using like.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Jjaa> findAllLike(Jjaa jjaa, Pagination pagination,
			Boolean startsWith) {
		return (List<Jjaa>) this.jjaaDao.findAllLike(jjaa, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Jjaa table using like.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Jjaa jjaa, Boolean startsWith) {
		return this.jjaaDao.findAllLikeCount(jjaa, startsWith);
	}

	/**
	 * Deletes a single row in the Jjaa table.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Jjaa jjaa) {
		this.jjaaDao.remove(jjaa);
	}

	/**
	 * Deletes multiple rows in the Jjaa table.
	 * 
	 * @param jjaaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Jjaa> jjaaList) {
		for (Jjaa jjaaAux : jjaaList) {
			this.jjaaDao.remove(jjaaAux);
		}
	}

}
