package com.ejie.y41b.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.dao.IntervinientesTramiteDao;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.IntervinientesTramite;

/**
 * IntervinientesTramiteServiceImpl  
 * 
 *  
 */

@Service(value = "intervinientesTramiteService")
public class IntervinientesTramiteServiceImpl implements
		IntervinientesTramiteService {

	@Autowired
	private IntervinientesTramiteDao intervinientesTramiteDao;

	/**
	 * Inserts a single row in the IntervinientesTramite table.
	 * 
	 * @param intervinientes
	 *            IntervinientesTramite
	 * @return IntervinientesTramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public IntervinientesTramite add(IntervinientesTramite intervinientes) {
		return this.add(intervinientes);
	}

	/**
	 * Mtodo para guardar los rbitros asociados al trmite
	 * 
	 * @param idTramite
	 *            String
	 * @param arbitros
	 *            String[]
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void guardarArbitros(String idTramite, String[] arbitros) {

		if (arbitros != null && arbitros.length > 0) {
			IntervinientesTramite intervinientesTramite;
			for (String interviniente : arbitros) {
				intervinientesTramite = new IntervinientesTramite();
				intervinientesTramite.setInterviniente(new Intervinientes(
						interviniente));
				intervinientesTramite.setArbtramexp(new Arbtramexp(idTramite));
				this.intervinientesTramiteDao.add(intervinientesTramite);
			}
		}
	}

	/**
	 * Mtodo para borrar los rbitros asociados al trmite
	 * 
	 * @param idTramite
	 *            String
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void borrarArbitros(String idTramite) {

		this.intervinientesTramiteDao.remove(idTramite);
	}

	/**
	 * Mtodo para coger los rbitros asociados al trmite
	 * 
	 * @param idTramite
	 *            String
	 * @return String
	 */
	@Transactional(readOnly = true)
	public String cogerArbitros(String idTramite) {

		return this.intervinientesTramiteDao.cogerArbitros(idTramite);
	}
}
