package com.ejie.y41b.service;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.EstablecimArbitraDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.SedeDao;
import com.ejie.y41b.model.ConsumidorDetalle;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * IntervinientesServiceImpl  
 * 
 *  
 */

@Service(value = "intervinientesService")
public class IntervinientesServiceImpl implements IntervinientesService {

	@Autowired
	private IntervinientesDao intervinientesDao;

	@Autowired
	private EstablecimientoDao establecimientoDao;

	@Autowired
	private EstablecimArbitraDao establecimArbitraDao;

	@Autowired
	private SedeDao sedeDao;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Intervinientes add(Intervinientes intervinientes) {
		return this.intervinientesDao.add(intervinientes);
	}

	/**
	 * Updates a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Intervinientes update(Intervinientes intervinientes) {
		return this.intervinientesDao.update(intervinientes);
	}

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes find(Intervinientes intervinientes) {
		return (Intervinientes) this.intervinientesDao.find(intervinientes);
	}

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public ConsumidorDetalle findIntervinienteConsumidor(Intervinientes intervinientes) {
		Intervinientes intervinien = (Intervinientes) this.intervinientesDao.find(intervinientes);

		ConsumidorDetalle consumidorDetalle = new ConsumidorDetalle(intervinien.getDtcodigo(), intervinien.getIncozs(),
				null, intervinien.getUsuarioxlnet(), intervinien.getDtrango_edad(), null, intervinien.getNombre(),
				intervinien.getApellido1(), intervinien.getApellido2(), intervinien.getNif(), null, null, null,
				intervinien.getNrtel(), null, null, null, intervinien.getCoem(), intervinien.getNrtel2(), null,
				intervinien.getCoidco(), null, null, null, null, null, null, intervinien.getDtcosx(), null, null,
				intervinien.getInfemod(), null, null, null, null, null, null, null, null, null, null, null,
				intervinien.getDtintipid(), intervinien.getNoraPaisId(), intervinien.getNombrePais(),
				intervinien.getNoraProvinciaId(), intervinien.getNombreProvincia(), intervinien.getNoraMunicipioId(),
				intervinien.getNombreMunicipio(), intervinien.getNoraLocalidadId(), intervinien.getNombreLocalidad(),
				intervinien.getNoraCalleId(), intervinien.getNombreCalle(), intervinien.getNoraCpId(),
				intervinien.getNombreCp(), intervinien.getNoraPortalId(), intervinien.getNombrePortal(),
				intervinien.getNombrePiso(), intervinien.getDireccionNocapv(), intervinien.getDireccionCompleta(), null,
				null, null, intervinien.getExtranjero());

		return consumidorDetalle;
	}

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public EstablecimientoDetalle findIntervinienteEstablecimiento(Intervinientes intervinientes) {
		Intervinientes intervinien = (Intervinientes) this.intervinientesDao.find(intervinientes);

		EstablecimientoDetalle establecidetalle = new EstablecimientoDetalle(intervinien.getEscodigo(),
				intervinien.getIncozs(), null, intervinien.getUsuarioxlnet(), intervinien.getNombre(), null,
				intervinien.getNif(), null, intervinien.getEsnoco(), null, null, null, intervinien.getNrtel(), null,
				null, null, null, null, intervinien.getInadar(), null, intervinien.getCoem(), null, null,
				intervinien.getNrtel2(), null, intervinien.getEsfeba(), null, null, null, null, null,
				intervinien.getEsnopeco(), null, null, intervinien.getInfemod(), null, null, null, null, null, null,
				intervinien.getEsteurl(), null, null, null, null, null, intervinien.getNoraPaisId(),
				intervinien.getNombrePais(), intervinien.getNoraProvinciaId(), intervinien.getNombreProvincia(),
				intervinien.getNoraMunicipioId(), intervinien.getNombreMunicipio(), intervinien.getNoraLocalidadId(),
				intervinien.getNombreLocalidad(), intervinien.getNoraCalleId(), intervinien.getNombreCalle(),
				intervinien.getNoraCpId(), intervinien.getNombreCp(), intervinien.getNoraPortalId(),
				intervinien.getNombrePortal(), intervinien.getNombrePiso(), intervinien.getDireccionNocapv(),
				intervinien.getDireccionCompleta(), null, null, null, null, null, intervinien.getSecodigo(),
				intervinien.getSenombre(), intervinien.getSenombree(), null, intervinien.getExtranjero(), null);

		// buscar establecimiento
		Establecimiento establecimiento = new Establecimiento();
		establecimiento.setEscodigo(intervinien.getEscodigo());
		Establecimiento estableci = (Establecimiento) this.establecimientoDao.find(establecimiento);

		establecidetalle.setEsfeadar(estableci.getEsfeadar());
		establecidetalle.setEsintiar(estableci.getEsintiar());
		establecidetalle.setEsfeerd(estableci.getEsfeerd());
		establecidetalle.setEssede(estableci.getEssede());
		establecidetalle.setEstipid(estableci.getEstipid());

		// 0157454 reapertura nota (0209071)
		establecidetalle.setEsfeba(estableci.getEsfeba());

		// Datos aadidos por especificacin en arbitraje
		establecidetalle.setEscooe(estableci.getEscooe());
		establecidetalle.setEsnorep(estableci.getEsnorep());
		establecidetalle.setEsnifrep(estableci.getEsnifrep());

		// Buscar arbitraje
		try {
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.getEstablecimiento().setEscodigo(estableci.getEscodigo());
			establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
			establecidetalle.setAhfeba(establecimArbitra.getAhfeba());
			establecidetalle.setAhtelimi(establecimArbitra.getAhtelimi());
			// Datos aadidos por especificacin en arbitraje
			establecidetalle.setAhcodigo(establecimArbitra.getAhcodigo());
			establecidetalle.setAhcoja(establecimArbitra.getAhcoja());
			establecidetalle.setEsinadar(estableci.getEsinadar());
			establecidetalle.setAhfere(establecimArbitra.getAhfere());
			establecidetalle.setAhindef(establecimArbitra.getAhindef());
			establecidetalle.setAhmedia(establecimArbitra.getAhmedia());
			establecidetalle.setAhnrdi(establecimArbitra.getAhnrdi().toString());
			if ("A".equals(estableci.getEsinadar())) {
				if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
					establecidetalle.setEsinadar("L");
				}
			}
		} catch (Exception e) {

		}

		// Buscar sedes
		// buscar sedes
		if (establecidetalle.getEssede() != null && establecidetalle.getEssede().equals(Y41bConstantes.SI)) {
			Sede sede = new Sede();
			sede.setEscodigo(establecidetalle.getEscodigo());

			List<Sede> listSede = this.sedeDao.findAll(sede, null);
			establecidetalle.setSedes(listSede);
		}

		return establecidetalle;
	}

	/**
	 * Finds a List of rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Intervinientes> findAll(Intervinientes intervinientes, Pagination pagination) {
		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, pagination);

		for (Intervinientes intervinientesAux : listIntervinientes) {
			StringBuffer nombreCompleto = new StringBuffer();

			if (Y41bUtils.isFilled(intervinientesAux.getNombre())) {
				nombreCompleto.append(intervinientesAux.getNombre());
			}
			if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
				nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
			}
			if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
				nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
			}

			intervinientesAux.setNombre(nombreCompleto.toString());
		}

		return listIntervinientes;
	}

	/**
	 * Finds a List of rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Intervinientes> findAllInspecciones(Intervinientes intervinientes, Pagination pagination) {
		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, pagination);

		for (Intervinientes intervinientesAux : listIntervinientes) {
			StringBuffer nombreCompleto = new StringBuffer();

			if (Y41bUtils.isFilled(intervinientesAux.getNombre())) {
				nombreCompleto.append(intervinientesAux.getNombre());
			}
			if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
				nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
			}
			if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
				nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
			}

			if (Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO
					.equals(intervinientesAux.getTipoInterviniente())) {
				nombreCompleto.append(" (").append(
						appMessageSource.getMessage("inspecciones.visitado", null, LocaleContextHolder.getLocale()))
						.append(")");
			} else if (Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE
					.equals(intervinientesAux.getTipoInterviniente())) {
				nombreCompleto.append(" (").append(
						appMessageSource.getMessage("inspecciones.responsable", null, LocaleContextHolder.getLocale()))
						.append(")");
			}

			intervinientesAux.setNombre(nombreCompleto.toString());

		}

		return listIntervinientes;
	}

	/**
	 * Counts rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Long
	 */
	public Long findAllCount(Intervinientes intervinientes) {
		return this.intervinientesDao.findAllCount(intervinientes);
	}

	/**
	 * Finds rows in the Intervinientes table using like.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Intervinientes> findAllLike(Intervinientes intervinientes, Pagination pagination, Boolean startsWith) {
		return (List<Intervinientes>) this.intervinientesDao.findAllLike(intervinientes, pagination, startsWith);
	}

	/**
	 * Counts rows in the Intervinientes table using like.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Intervinientes intervinientes, Boolean startsWith) {
		return this.intervinientesDao.findAllLikeCount(intervinientes, startsWith);
	}

	/**
	 * Deletes a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Intervinientes intervinientes) {
		this.intervinientesDao.remove(intervinientes);
	}

	/**
	 * Deletes multiple rows in the Intervinientes table.
	 * 
	 * @param intervinientesList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Intervinientes> intervinientesList) {
		for (Intervinientes intervinientesAux : intervinientesList) {
			this.intervinientesDao.remove(intervinientesAux);
		}
	}

}
