package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.ConsumidorDetalle;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Intervinientes;

/**
 * IntervinientesService  
 * 
 *  
 */

public interface IntervinientesService {

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	Intervinientes add(Intervinientes intervinientes);

	/**
	 * Updates a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	Intervinientes update(Intervinientes intervinientes);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	Intervinientes find(Intervinientes intervinientes);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public ConsumidorDetalle findIntervinienteConsumidor(
			Intervinientes intervinientes);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public EstablecimientoDetalle findIntervinienteEstablecimiento(
			Intervinientes intervinientes);

	/**
	 * Finds a List of rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Intervinientes> findAll(Intervinientes intervinientes,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Intervinientes> findAllInspecciones(
			Intervinientes intervinientes, Pagination pagination);

	/**
	 * Counts rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Long
	 */
	Long findAllCount(Intervinientes intervinientes);

	/**
	 * Finds rows in the Intervinientes table using like.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Intervinientes> findAllLike(Intervinientes intervinientes,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Intervinientes table using like.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Intervinientes intervinientes, Boolean startsWith);

	/**
	 * Deletes a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return
	 */
	void remove(Intervinientes intervinientes);

	/**
	 * Deletes multiple rows in the Intervinientes table.
	 * 
	 * @param intervinientesList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Intervinientes> intervinientesList);

}
