package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.InstructorDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Instructor;

/**
 * InstructorServiceImpl  
 * 
 *  
 */

@Service(value = "instructorService")
public class InstructorServiceImpl implements InstructorService {

	@Autowired
	private InstructorDao instructorDao;

	/**
	 * Inserts a single row in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return Instructor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Instructor add(Instructor instructor) {
		return this.instructorDao.add(instructor);
	}

	/**
	 * Updates a single row in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return Instructor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Instructor update(Instructor instructor) {
		return this.instructorDao.update(instructor);
	}

	/**
	 * Finds a single row in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return Instructor
	 */
	public Instructor find(Instructor instructor) {
		return (Instructor) this.instructorDao.find(instructor);
	}

	/**
	 * Finds a List of rows in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Instructor> findAll(Instructor instructor, Pagination pagination) {
		return (List<Instructor>) this.instructorDao.findAll(instructor,
				pagination);
	}

	/**
	 * Counts rows in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return Long
	 */
	public Long findAllCount(Instructor instructor) {
		return this.instructorDao.findAllCount(instructor);
	}

	/**
	 * Finds rows in the Instructor table using like.
	 * 
	 * @param instructor
	 *            Instructor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Instructor> findAllLike(Instructor instructor,
			Pagination pagination, Boolean startsWith) {
		return (List<Instructor>) this.instructorDao.findAllLike(instructor,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Instructor table using like.
	 * 
	 * @param instructor
	 *            Instructor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Instructor instructor, Boolean startsWith) {
		return this.instructorDao.findAllLikeCount(instructor, startsWith);
	}

	/**
	 * Deletes a single row in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Instructor instructor) {
		this.instructorDao.remove(instructor);
	}

	/**
	 * Deletes multiple rows in the Instructor table.
	 * 
	 * @param instructorList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Instructor> instructorList) {
		for (Instructor instructorAux : instructorList) {
			this.instructorDao.remove(instructorAux);
		}
	}

}
