// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.adapter.helper.Y41bDokusiHelper;
import com.ejie.y41b.adapter.services.N61ServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActaDao;
import com.ejie.y41b.dao.ActaInfraccionDao;
import com.ejie.y41b.dao.ActaNuevaDao;
import com.ejie.y41b.dao.ActdecDao;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.AdjunDatosAvisosEstablecDao;
import com.ejie.y41b.dao.AdjunInfraccHechoDenunDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.AlertaDao;
import com.ejie.y41b.dao.BandejaFirmaDao;
import com.ejie.y41b.dao.CampanhaDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.ComunicacionSoivreDao;
import com.ejie.y41b.dao.DatosMailEstablecimientoDao;
import com.ejie.y41b.dao.DatosMailSedeDao;
import com.ejie.y41b.dao.DecisionDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.dao.HistorialAlertaDao;
import com.ejie.y41b.dao.InfraccHechoDenDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.LaboratorioDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.PlantillaTramiteDao;
import com.ejie.y41b.dao.RemesaDao;
import com.ejie.y41b.dao.TramiteDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.ActaInfraccion;
import com.ejie.y41b.model.ActaNueva;
import com.ejie.y41b.model.Actdec;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjunDatosAvisosEstablec;
import com.ejie.y41b.model.AdjunInfraccHechoDenun;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.AttachFile;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ComunicacionSoivre;
import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.Decision;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoHechoDetalle;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.HistorialAlerta;
import com.ejie.y41b.model.Historicofases;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Laboratorio;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.Sanpropbandeja;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteAcuseRecibo;
import com.ejie.y41b.model.TramiteAdjuntarDocs;
import com.ejie.y41b.model.TramiteAlegacion;
import com.ejie.y41b.model.TramiteAnulacionPropuestaSancion;
import com.ejie.y41b.model.TramiteAsignacionInstructor;
import com.ejie.y41b.model.TramiteBOPVAyto;
import com.ejie.y41b.model.TramiteCierre;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteElaboracionBOPVAyto;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteINSAceptacionInformeValoracion;
import com.ejie.y41b.model.TramiteINSAcuerdoInicioProcedimiento;
import com.ejie.y41b.model.TramiteINSAmpliacionInspeccion;
import com.ejie.y41b.model.TramiteINSArchivoAIP;
import com.ejie.y41b.model.TramiteINSComunicarNuevoDistribuidor;
import com.ejie.y41b.model.TramiteINSDesinmovilizacion;
import com.ejie.y41b.model.TramiteINSEmisionInforme;
import com.ejie.y41b.model.TramiteINSEnviarMuestraEmpresa;
import com.ejie.y41b.model.TramiteINSEstablecimientoRelacionConCampana;
import com.ejie.y41b.model.TramiteINSEstablecimientoRelacionConRedAlerta;
import com.ejie.y41b.model.TramiteINSGenericoFirma;
import com.ejie.y41b.model.TramiteINSLevantamientoActa;
import com.ejie.y41b.model.TramiteINSOrdenServicio;
import com.ejie.y41b.model.TramiteINSRecepcionCertificadoDestruccion;
import com.ejie.y41b.model.TramiteINSRecepcionJustificanteDevolucion;
import com.ejie.y41b.model.TramiteINSRemisionMuestrasAlLaboratorio;
import com.ejie.y41b.model.TramiteINSResolucionAIP;
import com.ejie.y41b.model.TramiteINSResultadoEnsayos;
import com.ejie.y41b.model.TramiteINSRevisionInclusionRedAlerta;
import com.ejie.y41b.model.TramiteINSValoracionInspeccion;
import com.ejie.y41b.model.TramiteInformeAsesoria;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteInspeccionDetalle;
import com.ejie.y41b.model.TramiteNotificacion;
import com.ejie.y41b.model.TramiteRecepcionOrdenConsejero;
import com.ejie.y41b.model.TramiteRecepcionRecurso;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoInformacion;
import com.ejie.y41b.model.TramiteRegistroDecision;
import com.ejie.y41b.model.TramiteRegistroSolicitud;
import com.ejie.y41b.model.TramiteRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRequerimientoInformacion;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.Formato;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.ActualizarExpediente;
import com.ejie.y41b.model.platea.ActualizarMisGestiones;
import com.ejie.y41b.model.platea.CierreExpediente;
import com.ejie.y41b.model.platea.CrearNotifEJGV;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.Proceedings;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;
import com.ejie.y41b.model.platea.RespuestaNotificacion;
import com.ejie.y41b.model.platea.SolicitudOficio;
import com.ejie.y41b.n61.ArrayOfWSParamPerson;
import com.ejie.y41b.n61.WSInputRegister;
import com.ejie.y41b.n61.WSOutputRegister;
import com.ejie.y41b.n61.WSParamInputRegisterEx;
import com.ejie.y41b.n61.WSParamOutputRegisterEx;
import com.ejie.y41b.n61.WSParamPerson;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotification;

/**
 * InstramexpServiceImpl
 * 
 *  
 */
@Service(value = "instramexpService")
public class InstramexpServiceImpl implements InstramexpService {

	private static final Logger logger = LoggerFactory.getLogger(InstramexpServiceImpl.class);

	@Autowired()
	private TramiteInspeccionDao tramiteInspeccionDao;

	@Autowired()
	private TramiteDao tramiteDao;

	@Autowired()
	private ActuacionDao actuacionDao;

	@Autowired()
	private ActaDao actaDao;

	@Autowired()
	private ActaNuevaDao actaNuevaDao;

	@Autowired()
	private ComunicacionSoivreDao comunicacionSoivreDao;

	@Autowired()
	private PlantillaTramiteDao plantillaTramiteDao;

	@Autowired()
	private AdjuntardocsDao adjuntardocsDao;

	@Autowired()
	private DocumentoHechoDao documentoHechoDao;

	@Autowired()
	private LaboratorioDao laboratorioDao;

	@Autowired()
	private RemesaDao remesaDao;

	@Autowired()
	private IntervinientesDao intervinientesDao;

	@Autowired()
	private BandejaFirmaDao bandejaFirmaDao;

	@Autowired()
	private CensoMonitorDao censoMonitorDao;

	@Autowired()
	private TramiteInspeccionService tramiteInspeccionService;

	@Autowired()
	private HistoricofasesService historicofasesService;

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired()
	private EstablecimientoService establecimientoService;

	@Autowired()
	private ParametrosDao parametrosDao;

	@Autowired()
	private OrganismoDao organismoDao;

	@Autowired()
	private ActaInfraccionDao actaInfraccionDao;

	@Autowired()
	private InfraccHechoDenDao infraccHechoDenDao;

	@Autowired()
	private AdjunInfraccHechoDenunDao adjunInfraccHechoDenunDao;

	@Autowired()
	private SanpropbandejaService sanpropbandejaService;

	@Autowired()
	private DatosMailEstablecimientoDao datosMailEstablecimientoDao;

	@Autowired()
	private DatosMailSedeDao datosMailSedeDao;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Resource()
	private AlertaService alertaService;

	@Autowired()
	private ActdecDao actdecDao;

	@Autowired()
	private InspeccionService inspeccionService;

	@Autowired()
	private DecisionDao decisionDao;

	@Autowired()
	private HistorialAlertaDao historialAlertaDao;

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired()
	private BandejaInspeccionesService bandejaInspeccionesService;

	@Autowired
	private CampanhaDao campanhaDao;

	@Autowired
	private AlertaDao alertaDao;

	@Autowired
	private SanexprelService sanexprelService;

	@Autowired
	private HechoDenunciadoDao hechoDenunciadoDao;

	@Autowired
	private AdjunDatosAvisosEstablecDao adjunDatosAvisosEstablecDao;

	/*********************
	 * FINDS DE TRAMITES *
	 *********************/

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAdjuntarDocs
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAdjuntarDocs findTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs,
			CensoMonitor censoMonitor) {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteAdjuntarDocs.getIdTramite());

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteAdjuntarDocs tramiteAdjuntarDocsAux = new TramiteAdjuntarDocs();
		tramiteAdjuntarDocsAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteAdjuntarDocsAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteAdjuntarDocsAux.setFechaFin(tramiteinspeccion.getTifechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteAdjuntarDocsAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteAdjuntarDocsAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAdjuntarDocsAux.setIstelematico(tramiteinspeccion.getTiistelematico());

		/* Evolutivo SIR */
		tramiteAdjuntarDocsAux.setIsSIR(tramiteinspeccion.getTiissir());

		tramiteAdjuntarDocsAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteinspeccion);

		tramiteAdjuntarDocsAux.setComentario(tramiteInspeccionAux.getTicomentario());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteAdjuntarDocsAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAdjuntarDocsAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAdjuntarDocsAux;
	}

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSEstablecimientoRelacionConRedAlerta findTramiteEstablecimientoRelacionConRedAlerta(
			TramiteINSEstablecimientoRelacionConRedAlerta tramiteINSEstablecimientoRelacionConRedAlerta,
			CensoMonitor censoMonitor) {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteINSEstablecimientoRelacionConRedAlerta.getIdTramite());

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteINSEstablecimientoRelacionConRedAlerta tramiteINSEstablecimientoRelacionConRedAlertaAux = new TramiteINSEstablecimientoRelacionConRedAlerta();
		tramiteINSEstablecimientoRelacionConRedAlertaAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteINSEstablecimientoRelacionConRedAlertaAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteINSEstablecimientoRelacionConRedAlertaAux.setFechaFin(tramiteinspeccion.getTifechafin());
		tramiteINSEstablecimientoRelacionConRedAlertaAux.setAccodigo(tramiteinspeccion.getTiaccodigo());

		tramiteINSEstablecimientoRelacionConRedAlertaAux.setRedAlerta(tramiteinspeccion.getTicoalrel());

		tramiteINSEstablecimientoRelacionConRedAlertaAux.setTicocr(tramiteinspeccion.getTicocr());

		Alerta alerta = new Alerta();
		alerta.setAlcodigo(tramiteinspeccion.getTicoalrel());

		alerta = alertaService.find(alerta);

		if (alerta != null) {
			tramiteINSEstablecimientoRelacionConRedAlertaAux.setNumAlerta(alerta.getAlnror());

			tramiteINSEstablecimientoRelacionConRedAlertaAux.setAnyo(alerta.getAlnran());

		}

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteINSEstablecimientoRelacionConRedAlertaAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteINSEstablecimientoRelacionConRedAlertaAux.setInstructorEjecucion(instructorEjecucion);

		tramiteINSEstablecimientoRelacionConRedAlertaAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteinspeccion);

		tramiteINSEstablecimientoRelacionConRedAlertaAux.setComentario(tramiteInspeccionAux.getTicomentario());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteINSEstablecimientoRelacionConRedAlertaAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteINSEstablecimientoRelacionConRedAlertaAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteINSEstablecimientoRelacionConRedAlertaAux;
	}

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteINSEstablecimientoRelacionConCampana
	 *            TramiteINSEstablecimientoRelacionConCampana
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSEstablecimientoRelacionConCampana findTramiteEstablecimientoRelacionConCampana(
			TramiteINSEstablecimientoRelacionConCampana tramiteINSEstablecimientoRelacionConCampana,
			CensoMonitor censoMonitor) {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteINSEstablecimientoRelacionConCampana.getIdTramite());

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteINSEstablecimientoRelacionConCampana tramiteINSEstablecimientoRelacionConCampanaAux = new TramiteINSEstablecimientoRelacionConCampana();
		tramiteINSEstablecimientoRelacionConCampanaAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteINSEstablecimientoRelacionConCampanaAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteINSEstablecimientoRelacionConCampanaAux.setFechaFin(tramiteinspeccion.getTifechafin());

		tramiteINSEstablecimientoRelacionConCampanaAux.setTicocm(tramiteinspeccion.getTicocmrel());
		tramiteINSEstablecimientoRelacionConCampanaAux.setTicopg(tramiteinspeccion.getTicopg());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteINSEstablecimientoRelacionConCampanaAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteINSEstablecimientoRelacionConCampanaAux.setInstructorEjecucion(instructorEjecucion);

		tramiteINSEstablecimientoRelacionConCampanaAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteinspeccion);

		tramiteINSEstablecimientoRelacionConCampanaAux.setComentario(tramiteInspeccionAux.getTicomentario());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteINSEstablecimientoRelacionConCampanaAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteINSEstablecimientoRelacionConCampanaAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteINSEstablecimientoRelacionConCampanaAux;
	}

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSRevisionInclusionRedAlerta findTramiteRevisionInclusionRedAlerta(
			TramiteINSRevisionInclusionRedAlerta tramiteINSRevisionInclusionRedAlerta, CensoMonitor censoMonitor) {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteINSRevisionInclusionRedAlerta.getIdTramite());

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteINSRevisionInclusionRedAlerta tramiteINSRevisionInclusionRedAlertaAux = new TramiteINSRevisionInclusionRedAlerta();
		tramiteINSRevisionInclusionRedAlertaAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteINSRevisionInclusionRedAlertaAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteINSRevisionInclusionRedAlertaAux.setFechaFin(tramiteinspeccion.getTifechafin());
		tramiteINSRevisionInclusionRedAlertaAux.setAccodigo(tramiteinspeccion.getTiaccodigo());

		tramiteINSRevisionInclusionRedAlertaAux.setFechaRedAlerta(tramiteinspeccion.getTifecharedalerta());

		tramiteINSRevisionInclusionRedAlertaAux.setInclusion(tramiteinspeccion.getTiinclusiredalerta());

		tramiteINSRevisionInclusionRedAlertaAux.setMotivo(tramiteinspeccion.getTimotivoredalerta());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteINSRevisionInclusionRedAlertaAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteINSRevisionInclusionRedAlertaAux.setActa(tramiteinspeccion.getTiancodigo());

		tramiteINSRevisionInclusionRedAlertaAux.setInstructorEjecucion(instructorEjecucion);

		tramiteINSRevisionInclusionRedAlertaAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteinspeccion);

		tramiteINSRevisionInclusionRedAlertaAux.setComentario(tramiteInspeccionAux.getTicomentario());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteINSRevisionInclusionRedAlertaAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteINSRevisionInclusionRedAlertaAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteINSRevisionInclusionRedAlertaAux;
	}

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteGenerico findTramiteGenerico(TramiteGenerico tramiteGenerico, CensoMonitor censoMonitor) {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteGenerico.getIdTramite());

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteGenerico tramiteGenericoAux = new TramiteGenerico();
		tramiteGenericoAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteGenericoAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteGenericoAux.setFechaFin(tramiteinspeccion.getTifechafin());
		tramiteGenericoAux.setAccodigo(tramiteinspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteGenericoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteGenericoAux.setInstructorEjecucion(instructorEjecucion);

		tramiteGenericoAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		tramiteGenericoAux.setNombreTramite(tramiteinspeccion.getTinombretramite());

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteinspeccion);

		tramiteGenericoAux.setComentario(tramiteInspeccionAux.getTicomentario());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteGenericoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteGenericoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteGenericoAux;
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteComunicacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteComunicacion findTramiteComunicacion(TramiteComunicacion tramiteComunicacion,
			CensoMonitor censoMonitor) throws SQLException, IOException {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComunicacion.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteComunicacion tramiteComunicacionAux = new TramiteComunicacion();
		tramiteComunicacionAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteComunicacionAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteComunicacionAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteComunicacionAux.setAccodigo(tramiteInspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteComunicacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteComunicacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteComunicacionAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteComunicacionAux.setFechaComunicacion(tramiteInspeccion.getTifechacomunicacion());

		tramiteComunicacionAux.setDestinatario(this.calcularDestinatarioComunicacionNotificacion(tramiteInspeccion));

		tramiteComunicacionAux.setSede(tramiteInspeccion.getTisede());

		tramiteComunicacionAux.setTipoComunicacion(tramiteInspeccion.getTitipocomunicacion());

		tramiteComunicacionAux.setFechasalida(tramiteInspeccion.getTifecharegistrosalida());

		tramiteComunicacionAux.setNumregistrosalida(tramiteInspeccion.getTinumregistrosalida());

		tramiteComunicacionAux.setAsuntoComunicacion(tramiteInspeccion.getTiasuntocomunicacion());

		// Remesas Ini
		tramiteComunicacionAux.setEnvRemesaComunicacion(tramiteInspeccion.getTienvrem());
		if (tramiteInspeccion.getTicodrem() != null && !"".equals(tramiteInspeccion.getTicodrem())) {
			// Si tiene remesa asociada, recupero datos de la remesa
			Remesa remesa = new Remesa();
			remesa.setRmcodigo(tramiteInspeccion.getTicodrem());
			remesa = this.remesaDao.find(remesa);
			tramiteComunicacionAux.setIdRemesaComunicacion(remesa.getRmcodigo());
			tramiteComunicacionAux.setFechaRemesaComunicacion(remesa.getRmfechageneracion());
		}
		// Remesas Fin

		tramiteComunicacionAux.setIdmailorigen(tramiteInspeccion.getTiidmailorigen());
		tramiteComunicacionAux.setMailorigen(tramiteInspeccion.getTimailorigen());
		tramiteComunicacionAux.setIdmaildestino(tramiteInspeccion.getTiidmaildestino());
		tramiteComunicacionAux.setMaildestino(tramiteInspeccion.getTimaildestino());

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteInspeccion);

		tramiteComunicacionAux.setComentario(tramiteInspeccionAux.getTicomentario());

		tramiteComunicacionAux.setTextoComunicacion(tramiteInspeccion.getTitextocomunicacion());

		if (tramiteInspeccion.getTramiteInspeccion() != null
				&& tramiteInspeccion.getTramiteInspeccion().getTicodigo() != null) {
			tramiteComunicacionAux.setPermisoModificacionDestinatario(Y41bConstantes.NO);
		} else {
			tramiteComunicacionAux.setPermisoModificacionDestinatario(Y41bConstantes.SI);
		}

		if (tratamientoPermisoTramitar(tramiteInspeccion, censoMonitor)) {
			tramiteComunicacionAux.setPermisoTramitar(Y41bConstantes.SI);
		} else {
			tramiteComunicacionAux.setPermisoTramitar(Y41bConstantes.NO);
		}

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteComunicacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteComunicacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteComunicacionAux;
	}

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteValoracionInspeccion
	 *            TramiteINSValoracionInspeccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSValoracionInspeccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSValoracionInspeccion findTramiteValoracionInspeccion(
			TramiteINSValoracionInspeccion tramiteValoracionInspeccion, CensoMonitor censoMonitor) {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteValoracionInspeccion.getIdTramite());

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteINSValoracionInspeccion tramiteValoracionInspeccionAux = new TramiteINSValoracionInspeccion();
		tramiteValoracionInspeccionAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteValoracionInspeccionAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteValoracionInspeccionAux.setFechaFin(tramiteinspeccion.getTifechafin());
		tramiteValoracionInspeccionAux.setAccodigo(tramiteinspeccion.getTiaccodigo());

		tramiteValoracionInspeccionAux.setValoracionInspeccion(tramiteinspeccion.getTivaloracion());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteValoracionInspeccionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteValoracionInspeccionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteValoracionInspeccionAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		tramiteValoracionInspeccionAux.setComentario(tramiteinspeccion.getTicomentario());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteValoracionInspeccionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteValoracionInspeccionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteValoracionInspeccionAux;
	}

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteAmpliacionInspeccion
	 *            TramiteINSAmpliacionInspeccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSAmpliacionInspeccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSAmpliacionInspeccion findTramiteAmpliacionInspeccion(
			TramiteINSAmpliacionInspeccion tramiteAmpliacionInspeccion, CensoMonitor censoMonitor) {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteAmpliacionInspeccion.getIdTramite());

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteINSAmpliacionInspeccion tramiteAmpliacionInspeccionAux = new TramiteINSAmpliacionInspeccion();
		tramiteAmpliacionInspeccionAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteAmpliacionInspeccionAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteAmpliacionInspeccionAux.setFechaFin(tramiteinspeccion.getTifechafin());
		tramiteAmpliacionInspeccionAux.setAccodigo(tramiteinspeccion.getTiaccodigo());

		tramiteAmpliacionInspeccionAux.setFechaAmpliacion(tramiteinspeccion.getTifechaampli());

		tramiteAmpliacionInspeccionAux.setMotivoAmpliacion(tramiteinspeccion.getTimotivoampli());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteAmpliacionInspeccionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteAmpliacionInspeccionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAmpliacionInspeccionAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		tramiteAmpliacionInspeccionAux.setComentario(tramiteinspeccion.getTicomentario());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteAmpliacionInspeccionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAmpliacionInspeccionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAmpliacionInspeccionAux;
	}

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteINSAceptacionInformeValoracion
	 *            TramiteINSAceptacionInformeValoracion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSAmpliacionInspeccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSAceptacionInformeValoracion findTramiteAceptacionInformeValoracion(
			TramiteINSAceptacionInformeValoracion tramiteAceptacionInformeValoracion, CensoMonitor censoMonitor) {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteAceptacionInformeValoracion.getIdTramite());

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteINSAceptacionInformeValoracion tramiteAceptacionInformeValoracionAux = new TramiteINSAceptacionInformeValoracion();
		tramiteAceptacionInformeValoracionAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteAceptacionInformeValoracionAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteAceptacionInformeValoracionAux.setFechaFin(tramiteinspeccion.getTifechafin());
		tramiteAceptacionInformeValoracionAux.setAccodigo(tramiteinspeccion.getTiaccodigo());

		tramiteAceptacionInformeValoracionAux.setFechaAceptacion(tramiteinspeccion.getTifechaaceptacion());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteAceptacionInformeValoracionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteAceptacionInformeValoracionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAceptacionInformeValoracionAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		tramiteAceptacionInformeValoracionAux.setComentario(tramiteinspeccion.getTicomentario());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteAceptacionInformeValoracionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAceptacionInformeValoracionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAceptacionInformeValoracionAux;
	}

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteINSOrdenServicio
	 *            TramiteINSOrdenServicio
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSOrdenServicio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSOrdenServicio findTramiteOrdenServicio(TramiteINSOrdenServicio tramiteINSOrdenServicio,
			CensoMonitor censoMonitor) {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteINSOrdenServicio.getIdTramite());

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteINSOrdenServicio tramiteINSOrdenServicioAux = new TramiteINSOrdenServicio();
		tramiteINSOrdenServicioAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteINSOrdenServicioAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteINSOrdenServicioAux.setFechaFin(tramiteinspeccion.getTifechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteINSOrdenServicioAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteINSOrdenServicioAux.setInstructorEjecucion(instructorEjecucion);

		tramiteINSOrdenServicioAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		tramiteINSOrdenServicioAux.setComentario(tramiteinspeccion.getTicomentario());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteINSOrdenServicioAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteINSOrdenServicioAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteINSOrdenServicioAux;
	}

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteINSRecepcionCertificadoDestruccion
	 *            TramiteINSRecepcionCertificadoDestruccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSRecepcionCertificadoDestruccion findTramiteRecepcionCertificadoDestruccion(
			TramiteINSRecepcionCertificadoDestruccion tramiteINSRecepcionCertificadoDestruccion,
			CensoMonitor censoMonitor) {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteINSRecepcionCertificadoDestruccion.getIdTramite());

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteINSRecepcionCertificadoDestruccion.getIdExpediente());
		actuacion = actuacionDao.find(actuacion);
		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteINSRecepcionCertificadoDestruccion tramiteINSRecepcionCertificadoDestruccionAux = new TramiteINSRecepcionCertificadoDestruccion();
		tramiteINSRecepcionCertificadoDestruccionAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteINSRecepcionCertificadoDestruccionAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteINSRecepcionCertificadoDestruccionAux.setFechaFin(tramiteinspeccion.getTifechafin());
		tramiteINSRecepcionCertificadoDestruccionAux.setAccodigo(tramiteinspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteINSRecepcionCertificadoDestruccionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteINSRecepcionCertificadoDestruccionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteINSRecepcionCertificadoDestruccionAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		tramiteINSRecepcionCertificadoDestruccionAux.setTiempresagest(tramiteinspeccion.getTiempresagest());

		tramiteINSRecepcionCertificadoDestruccionAux.setTinumrecupe(tramiteinspeccion.getTinumrecupe());

		tramiteINSRecepcionCertificadoDestruccionAux.setTinumadestruir(tramiteinspeccion.getTinumadestruir());

		tramiteINSRecepcionCertificadoDestruccionAux.setInmovilizadas(
				actuacion.getAtuinmovilizadas() != null ? actuacion.getAtuinmovilizadas().toString() : "0");

		tramiteINSRecepcionCertificadoDestruccionAux
				.setDestruidas(actuacion.getAtudestruidas() != null ? actuacion.getAtudestruidas().toString() : "0");

		tramiteINSRecepcionCertificadoDestruccionAux.setDevueltas(
				actuacion.getAtudevolucionorigen() != null ? actuacion.getAtudevolucionorigen().toString() : "0");

		tramiteINSRecepcionCertificadoDestruccionAux.setTomamuestras(
				actuacion.getAtutomamuestras() != null ? actuacion.getAtutomamuestras().toString() : "0");

		tramiteINSRecepcionCertificadoDestruccionAux
				.setLibrecomercializacion(actuacion.getAtulibrecomercializacion() != null
						? actuacion.getAtulibrecomercializacion().toString() : "0");

		tramiteINSRecepcionCertificadoDestruccionAux
				.setOtros(actuacion.getAtuotros() != null ? actuacion.getAtuotros().toString() : "0");

		tramiteINSRecepcionCertificadoDestruccionAux
				.setPendientes(actuacion.getAtupendientes() != null ? actuacion.getAtupendientes().toString() : "0");

		tramiteINSRecepcionCertificadoDestruccionAux.setRecuperadasContador(
				actuacion.getAturecuperadas() != null ? actuacion.getAturecuperadas().toString() : "0");

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteinspeccion);

		tramiteINSRecepcionCertificadoDestruccionAux.setComentario(tramiteInspeccionAux.getTicomentario());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteINSRecepcionCertificadoDestruccionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteINSRecepcionCertificadoDestruccionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteINSRecepcionCertificadoDestruccionAux;
	}

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteINSRecepcionJustificanteDevolucion
	 *            TramiteINSRecepcionJustificanteDevolucion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSRecepcionJustificanteDevolucion findTramiteRecepcionJustificanteDevolucion(
			TramiteINSRecepcionJustificanteDevolucion tramiteINSRecepcionJustificanteDevolucion,
			CensoMonitor censoMonitor) {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteINSRecepcionJustificanteDevolucion.getIdTramite());

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteINSRecepcionJustificanteDevolucion.getIdExpediente());
		actuacion = actuacionDao.find(actuacion);

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteINSRecepcionJustificanteDevolucion tramiteINSRecepcionJustificanteDevolucionAux = new TramiteINSRecepcionJustificanteDevolucion();
		tramiteINSRecepcionJustificanteDevolucionAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteINSRecepcionJustificanteDevolucionAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteINSRecepcionJustificanteDevolucionAux.setFechaFin(tramiteinspeccion.getTifechafin());
		tramiteINSRecepcionJustificanteDevolucionAux.setAccodigo(tramiteinspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteINSRecepcionJustificanteDevolucionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteINSRecepcionJustificanteDevolucionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteINSRecepcionJustificanteDevolucionAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		tramiteINSRecepcionJustificanteDevolucionAux.setTiempresagest(tramiteinspeccion.getTiempresagest());

		tramiteINSRecepcionJustificanteDevolucionAux.setTinumrecupe(tramiteinspeccion.getTinumrecupe());

		tramiteINSRecepcionJustificanteDevolucionAux.setTinumadevolver(tramiteinspeccion.getTinumadevolver());

		tramiteINSRecepcionJustificanteDevolucionAux.setInmovilizadas(
				actuacion.getAtuinmovilizadas() != null ? actuacion.getAtuinmovilizadas().toString() : "0");

		tramiteINSRecepcionJustificanteDevolucionAux
				.setDestruidas(actuacion.getAtudestruidas() != null ? actuacion.getAtudestruidas().toString() : "0");

		tramiteINSRecepcionJustificanteDevolucionAux.setDevueltas(
				actuacion.getAtudevolucionorigen() != null ? actuacion.getAtudevolucionorigen().toString() : "0");

		tramiteINSRecepcionJustificanteDevolucionAux.setTomamuestras(
				actuacion.getAtutomamuestras() != null ? actuacion.getAtutomamuestras().toString() : "0");

		tramiteINSRecepcionJustificanteDevolucionAux
				.setLibrecomercializacion(actuacion.getAtulibrecomercializacion() != null
						? actuacion.getAtulibrecomercializacion().toString() : "0");

		tramiteINSRecepcionJustificanteDevolucionAux
				.setOtros(actuacion.getAtuotros() != null ? actuacion.getAtuotros().toString() : "0");

		tramiteINSRecepcionJustificanteDevolucionAux
				.setPendientes(actuacion.getAtupendientes() != null ? actuacion.getAtupendientes().toString() : "0");

		tramiteINSRecepcionJustificanteDevolucionAux.setRecuperadasContador(
				actuacion.getAturecuperadas() != null ? actuacion.getAturecuperadas().toString() : "0");

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteinspeccion);

		tramiteINSRecepcionJustificanteDevolucionAux.setComentario(tramiteInspeccionAux.getTicomentario());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteINSRecepcionJustificanteDevolucionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteINSRecepcionJustificanteDevolucionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteINSRecepcionJustificanteDevolucionAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAsignacionInstructor
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAsignacionInstructor findTramiteAsignacionInstructor(
			TramiteAsignacionInstructor tramiteAsignacionInstructor, CensoMonitor censoMonitor)
			throws SQLException, IOException {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteAsignacionInstructor.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteAsignacionInstructor tramiteAsignacionInstructorAux = new TramiteAsignacionInstructor();
		tramiteAsignacionInstructorAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteAsignacionInstructorAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteAsignacionInstructorAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteAsignacionInstructorAux.setAccodigo(tramiteInspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteAsignacionInstructorAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteAsignacionInstructorAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAsignacionInstructorAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		CensoMonitor instructorExpediente = new CensoMonitor();
		instructorExpediente.setMocodigo(tramiteInspeccion.getTicomodesignado());

		if (tramiteInspeccion.getTicomodesignado() != null && !tramiteInspeccion.getTicomodesignado().equals("")) {
			instructorExpediente = this.censoMonitorDao.find(instructorExpediente);
		}

		tramiteAsignacionInstructorAux.setInstructorExpediente(instructorExpediente);

		tramiteAsignacionInstructorAux.setComentario(tramiteInspeccion.getTicomentario());

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteAsignacionInstructorAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAsignacionInstructorAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAsignacionInstructorAux;
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param tramiteRegistroSolicitud
	 *            TramiteRegistroSolicitud
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRegistroSolicitud
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRegistroSolicitud findTramiteRegistroInspeccion(TramiteRegistroSolicitud tramiteRegistroSolicitud,
			CensoMonitor censoMonitor) {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteRegistroSolicitud.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteRegistroSolicitud tramiteRegistroSolicitudAux = new TramiteRegistroSolicitud();
		tramiteRegistroSolicitudAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteRegistroSolicitudAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteRegistroSolicitudAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteRegistroSolicitudAux.setAccodigo(tramiteInspeccion.getTiaccodigo());
		tramiteRegistroSolicitudAux.setComentario(tramiteInspeccion.getTicomentario());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRegistroSolicitudAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRegistroSolicitudAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRegistroSolicitudAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		if (this.tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteRegistroSolicitudAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRegistroSolicitudAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRegistroSolicitudAux;
	}

	/**
	 * Finds a single row in the Tramite_Inspeccion table.
	 * 
	 * @param tramiteINSAcuerdoInicioProcedimiento
	 *            TramiteINSAcuerdoInicioProcedimiento
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSAcuerdoInicioProcedimiento
	 */
	public TramiteINSAcuerdoInicioProcedimiento findTramiteAcuerdoInicioProcedimiento(
			TramiteINSAcuerdoInicioProcedimiento tramiteINSAcuerdoInicioProcedimiento, CensoMonitor censoMonitor) {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteINSAcuerdoInicioProcedimiento.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteINSAcuerdoInicioProcedimiento tramiteINSAcuerdoInicioProcedimientoAux = new TramiteINSAcuerdoInicioProcedimiento();
		tramiteINSAcuerdoInicioProcedimientoAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteINSAcuerdoInicioProcedimientoAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteINSAcuerdoInicioProcedimientoAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteINSAcuerdoInicioProcedimientoAux.setAccodigo(tramiteInspeccion.getTiaccodigo());
		tramiteINSAcuerdoInicioProcedimientoAux.setComentario(tramiteInspeccion.getTicomentario());

		tramiteINSAcuerdoInicioProcedimientoAux.setFechaDecision(tramiteInspeccion.getTifecharesolucion());

		if (tramiteInspeccion.getTramiteInspeccion() != null
				&& tramiteInspeccion.getTramiteInspeccion().getTicodigo() != null) {
			tramiteINSAcuerdoInicioProcedimientoAux
					.setCodigoTramiteRelacionado(tramiteInspeccion.getTramiteInspeccion().getTicodigo());

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			Tramite tramite = new Tramite();
			tramite.setTrcodigo(tramiteInspeccion.getTramiteInspeccion().getTicotee());
			tramite = this.tramiteDao.find(tramite);
			if (Y41bConstantes.EUSKERA.equals(idioma)) {
				tramiteINSAcuerdoInicioProcedimientoAux.setNombreTramiteRelacionado(tramite.getTrnombree());
			} else {
				tramiteINSAcuerdoInicioProcedimientoAux.setNombreTramiteRelacionado(tramite.getTrnombre());
			}
		}

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteINSAcuerdoInicioProcedimientoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteINSAcuerdoInicioProcedimientoAux.setInstructorEjecucion(instructorEjecucion);

		tramiteINSAcuerdoInicioProcedimientoAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		if (this.tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteINSAcuerdoInicioProcedimientoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteINSAcuerdoInicioProcedimientoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteINSAcuerdoInicioProcedimientoAux;
	}

	/**
	 * Obtiene el objecto de levantamiento de acta
	 * 
	 * @param tramiteLevantamientoActa
	 *            TramiteLevantamientoActa
	 * @param monitor
	 *            CensoMonitor
	 * @return Parametros
	 */
	public TramiteINSLevantamientoActa findTramiteLevantamientoActa(
			TramiteINSLevantamientoActa tramiteLevantamientoActa, CensoMonitor monitor) {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteLevantamientoActa.getIdTramite());
		tramiteInspeccion = this.tramiteInspeccionService.find(tramiteInspeccion);

		Acta acta = new Acta();
		acta.setAccodigo(tramiteInspeccion.getTiaccodigo());
		acta = this.actaDao.find(acta);

		tramiteLevantamientoActa.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteLevantamientoActa.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteLevantamientoActa.setAccodigo(tramiteInspeccion.getTiaccodigo());

		tramiteLevantamientoActa.setComentario(tramiteInspeccion.getTicomentario());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());
		if (instructorAsignado.getMocodigo() != null && !instructorAsignado.getMocodigo().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}
		tramiteLevantamientoActa.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());
		if (instructorEjecucion.getMocodigo() != null && !instructorEjecucion.getMocodigo().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}
		tramiteLevantamientoActa.setInstructorEjecucion(instructorEjecucion);

		tramiteLevantamientoActa.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteLevantamientoActa.setTipoActa(tramiteInspeccion.getTitipactua());
		tramiteLevantamientoActa.setAncodigo(tramiteInspeccion.getTiancodigo());

		if (this.tratamientoSeguridad(tramiteInspeccion, monitor)) {
			tramiteLevantamientoActa.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteLevantamientoActa.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteLevantamientoActa;
	}

	/**
	 * Obtiene el objecto de levantamiento de acta
	 * 
	 * @param tramiteRequerimientoInformacion
	 *            TramiteRequerimientoInformacion
	 * @param monitor
	 *            CensoMonitor
	 * @return Parametros
	 */
	public TramiteRequerimientoInformacion findTramiteRequerimientoEscrito(
			TramiteRequerimientoInformacion tramiteRequerimientoInformacion, CensoMonitor monitor) {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteRequerimientoInformacion.getIdTramite());
		tramiteInspeccion = this.tramiteInspeccionService.find(tramiteInspeccion);

		tramiteRequerimientoInformacion.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteRequerimientoInformacion.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteRequerimientoInformacion.setAccodigo(tramiteInspeccion.getTiaccodigo());

		tramiteRequerimientoInformacion.setComentario(tramiteInspeccion.getTicomentario());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());
		if (instructorAsignado.getMocodigo() != null && !instructorAsignado.getMocodigo().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}
		tramiteRequerimientoInformacion.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());
		if (instructorEjecucion.getMocodigo() != null && !instructorEjecucion.getMocodigo().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}
		tramiteRequerimientoInformacion.setInstructorEjecucion(instructorEjecucion);

		tramiteRequerimientoInformacion.setOrigen(tramiteInspeccion.getTiorigenalegacion());
		tramiteRequerimientoInformacion.setDocumentacionrequerida(tramiteInspeccion.getTidocumentacionrequerida());
		tramiteRequerimientoInformacion.setDocumentacionrequeridae(tramiteInspeccion.getTidocumentacionrequeridae());

		tramiteRequerimientoInformacion.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		if (this.tratamientoSeguridad(tramiteInspeccion, monitor)) {
			tramiteRequerimientoInformacion.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRequerimientoInformacion.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRequerimientoInformacion;
	}

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramiteRecepcionRequerimiento
	 *            TramiteRecepcionRequerimientoInformacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoInformacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionRequerimientoInformacion findTramiteRecepcionRequerimiento(
			TramiteRecepcionRequerimientoInformacion tramiteRecepcionRequerimiento, CensoMonitor censoMonitor) {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteRecepcionRequerimiento.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteRecepcionRequerimientoInformacion tramiteRecepcionRequerimientoInformacionAux = new TramiteRecepcionRequerimientoInformacion();
		tramiteRecepcionRequerimientoInformacionAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteRecepcionRequerimientoInformacionAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteRecepcionRequerimientoInformacionAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteRecepcionRequerimientoInformacionAux.setAccodigo(tramiteInspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRecepcionRequerimientoInformacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRecepcionRequerimientoInformacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRecepcionRequerimientoInformacionAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteRecepcionRequerimientoInformacionAux.setRespuesta(tramiteInspeccion.getTirespuestarecepcion());

		tramiteRecepcionRequerimientoInformacionAux.setOrigen(tramiteInspeccion.getTiorigenalegacion());

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteInspeccion);

		tramiteRecepcionRequerimientoInformacionAux.setComentario(tramiteInspeccionAux.getTicomentario());

		tramiteRecepcionRequerimientoInformacionAux.setResumenAlegaciones(tramiteInspeccion.getTiresumenrecepcion());

		if (tramiteInspeccion.getTramiteInspeccion() != null
				&& tramiteInspeccion.getTramiteInspeccion().getTicodigo() != null) {
			tramiteRecepcionRequerimientoInformacionAux.setPermisoModificacionOrigen(Y41bConstantes.NO);
		} else {
			tramiteRecepcionRequerimientoInformacionAux.setPermisoModificacionOrigen(Y41bConstantes.SI);
		}

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteRecepcionRequerimientoInformacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRecepcionRequerimientoInformacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRecepcionRequerimientoInformacionAux;
	}

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramite
	 *            TramiteRequerimientoAcreditacionRepresentacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRequerimientoAcreditacionRepresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRequerimientoAcreditacionRepresentacion findTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramite, CensoMonitor censoMonitor) {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramite.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteRequerimientoAcreditacionRepresentacion tramiteRequerimientoAcreditacionRepresentacionAux = new TramiteRequerimientoAcreditacionRepresentacion();
		tramiteRequerimientoAcreditacionRepresentacionAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteRequerimientoAcreditacionRepresentacionAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteRequerimientoAcreditacionRepresentacionAux.setFechaFin(tramiteInspeccion.getTifechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRequerimientoAcreditacionRepresentacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRequerimientoAcreditacionRepresentacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRequerimientoAcreditacionRepresentacionAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteRequerimientoAcreditacionRepresentacionAux.setOrigen(tramiteInspeccion.getTiorigenalegacion());

		tramiteRequerimientoAcreditacionRepresentacionAux.setComentario(tramiteInspeccion.getTicomentario());

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteRequerimientoAcreditacionRepresentacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRequerimientoAcreditacionRepresentacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRequerimientoAcreditacionRepresentacionAux;
	}

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramite
	 *            TramiteAnulacionPropuestaSancion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAnulacionPropuestaSancion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAnulacionPropuestaSancion findTramiteAnulacionPropuestaSancion(
			TramiteAnulacionPropuestaSancion tramite, CensoMonitor censoMonitor) {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramite.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteAnulacionPropuestaSancion tramiteAnulacionPropuestaSancionAux = new TramiteAnulacionPropuestaSancion();
		tramiteAnulacionPropuestaSancionAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteAnulacionPropuestaSancionAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteAnulacionPropuestaSancionAux.setFechaFin(tramiteInspeccion.getTifechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteAnulacionPropuestaSancionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteAnulacionPropuestaSancionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAnulacionPropuestaSancionAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteAnulacionPropuestaSancionAux.setOrigen(tramiteInspeccion.getTiorigenalegacion());

		tramiteAnulacionPropuestaSancionAux.setComentario(tramiteInspeccion.getTicomentario());

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteAnulacionPropuestaSancionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAnulacionPropuestaSancionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAnulacionPropuestaSancionAux;
	}

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionRequerimientoAcreditacionRepresentacion findTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacion,
			CensoMonitor censoMonitor) {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacionAux = new TramiteRecepcionRequerimientoAcreditacionRepresentacion();
		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setFechaFin(tramiteInspeccion.getTifechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux
				.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux
				.setRespuesta(tramiteInspeccion.getTirespuestarecepcion());

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setOrigen(tramiteInspeccion.getTiorigenalegacion());

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setComentario(tramiteInspeccion.getTicomentario());

		tramiteRecepcionRequerimientoAcreditacionRepresentacionAux
				.setResumenAlegaciones(tramiteInspeccion.getTiresumenrecepcion());

		if (tramiteInspeccion.getTramiteInspeccion() != null
				&& tramiteInspeccion.getTramiteInspeccion().getTicodigo() != null) {
			tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setPermisoModificacionOrigen(Y41bConstantes.NO);
		} else {
			tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setPermisoModificacionOrigen(Y41bConstantes.SI);
		}

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRecepcionRequerimientoAcreditacionRepresentacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRecepcionRequerimientoAcreditacionRepresentacionAux;
	}

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramiteRecepcionRequerimiento
	 *            TramiteResolucionAIP
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteResolucionAIP
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSResolucionAIP findTramiteResolucionAIP(TramiteINSResolucionAIP tramiteResolucion,
			CensoMonitor censoMonitor) {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteResolucion.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteINSResolucionAIP tramiteResolucionAIPAux = new TramiteINSResolucionAIP();
		tramiteResolucionAIPAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteResolucionAIPAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteResolucionAIPAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteResolucionAIPAux.setAccodigo(tramiteInspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteResolucionAIPAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteResolucionAIPAux.setInstructorEjecucion(instructorEjecucion);

		tramiteResolucionAIPAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteResolucionAIPAux.setTifechaaip(tramiteInspeccion.getTifechaaip());

		tramiteResolucionAIPAux.setTiarchivar(tramiteInspeccion.getTiarchivar());

		// Contadores

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteResolucion.getIdExpediente());
		actuacion = this.actuacionDao.find(actuacion);

		tramiteResolucionAIPAux.setInmovilizadas(
				actuacion.getAtuinmovilizadas() != null ? actuacion.getAtuinmovilizadas().toString() : "0");

		tramiteResolucionAIPAux
				.setDestruidas(actuacion.getAtudestruidas() != null ? actuacion.getAtudestruidas().toString() : "0");

		tramiteResolucionAIPAux.setDevueltas(
				actuacion.getAtudevolucionorigen() != null ? actuacion.getAtudevolucionorigen().toString() : "0");

		tramiteResolucionAIPAux.setTomamuestras(
				actuacion.getAtutomamuestras() != null ? actuacion.getAtutomamuestras().toString() : "0");

		tramiteResolucionAIPAux.setLibrecomercializacion(actuacion.getAtulibrecomercializacion() != null
				? actuacion.getAtulibrecomercializacion().toString() : "0");

		tramiteResolucionAIPAux.setOtros(actuacion.getAtuotros() != null ? actuacion.getAtuotros().toString() : "0");

		tramiteResolucionAIPAux
				.setPendientes(actuacion.getAtupendientes() != null ? actuacion.getAtupendientes().toString() : "0");

		tramiteResolucionAIPAux.setRecuperadasContador(
				actuacion.getAturecuperadas() != null ? actuacion.getAturecuperadas().toString() : "0");

		// a inmovilizar
		tramiteResolucionAIPAux.setTinumdesin(tramiteInspeccion.getTinumdesin());

		// recuperadas
		tramiteResolucionAIPAux.setRecuperadas(tramiteInspeccion.getTinumrecupe());

		tramiteResolucionAIPAux.setTifechadesin(tramiteInspeccion.getTifechadesin());

		tramiteResolucionAIPAux.setTidestinodesin(tramiteInspeccion.getTidestinodesin());

		tramiteResolucionAIPAux.setTidestruccioninsitu(tramiteInspeccion.getTidestruccioninsitu());

		tramiteResolucionAIPAux.setComentario(tramiteInspeccion.getTicomentario());

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteResolucionAIPAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteResolucionAIPAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		// Si el padre es una Notificacion y su padre es Acuerdo Inicio
		// Procedimiento, el usuario tiene como plazo de alegaciones desde la
		// fecha de tramitacion de la Notificacion hasta el parametro (en dias)
		// guardado en la DB.
		TramiteInspeccion tramiteInspeccionAleg = new TramiteInspeccion();
		tramiteInspeccionAleg.setTiatcodigo(tramiteInspeccion.getTiatcodigo());
		tramiteInspeccionAleg.setTicodigo(tramiteInspeccion.getTicodigorelacionado());
		tramiteInspeccionAleg.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);
		tramiteInspeccionAleg.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		List<TramiteInspeccion> tramitesInspeccionNotif = this.tramiteInspeccionDao.findAll(tramiteInspeccionAleg,
				null);

		if (tramitesInspeccionNotif.size() > 0 && tramitesInspeccionNotif.get(0) != null
				&& Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO
						.equals(tramitesInspeccionNotif.get(0).getTramiteInspeccion().getTicotee())) {

			Parametros parametros = new Parametros();
			parametros.setParametro(Y41bConstantes.INSPECCIONES_PLAZO_ALEGACIONES);
			parametros = this.parametrosDao.find(parametros);
			if (null != parametros && null != parametros.getValor()) {
				Date ultimaFecha = tramitesInspeccionNotif.get(0).getTifecmodif();
				Calendar c = Calendar.getInstance();
				c.setTime(ultimaFecha);
				c.add(Calendar.DAY_OF_MONTH, Integer.parseInt(parametros.getValor()));
				ultimaFecha = c.getTime();
				tramiteResolucionAIPAux.setPlazoAlegaciones(ultimaFecha);
			}
		}

		return tramiteResolucionAIPAux;
	}

	/**
	 * Finds a single row in the Tramite_Inspeccion table.
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteCierre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteCierre findTramiteCierre(TramiteCierre tramiteCierre, CensoMonitor censoMonitor) {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteCierre.getIdTramite());

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteCierre tramiteCierreAux = new TramiteCierre();
		tramiteCierreAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteCierreAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteCierreAux.setFechaFin(tramiteinspeccion.getTifechafin());
		tramiteCierreAux.setAccodigo(tramiteinspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteCierreAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteCierreAux.setInstructorEjecucion(instructorEjecucion);

		tramiteCierreAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteinspeccion);

		tramiteCierreAux.setComentario(tramiteInspeccionAux.getTicomentario());

		tramiteCierreAux.setFechaCierre(tramiteinspeccion.getTifechacierre());

		tramiteCierreAux.setExcluirCierre(tramiteinspeccion.getTiexcluircierre());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteCierreAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteCierreAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteCierreAux;
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteNotificacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteNotificacion findTramiteNotificacion(TramiteNotificacion tramiteNotificacion,
			CensoMonitor censoMonitor) throws SQLException, IOException {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteNotificacion.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteNotificacion tramiteNotificacionAux = new TramiteNotificacion();
		tramiteNotificacionAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteNotificacionAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteNotificacionAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteNotificacionAux.setAccodigo(tramiteInspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteNotificacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteNotificacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteNotificacionAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteNotificacionAux.setFechaComunicacion(tramiteInspeccion.getTifechacomunicacion());

		tramiteNotificacionAux.setDestinatario(this.calcularDestinatarioComunicacionNotificacion(tramiteInspeccion));

		tramiteNotificacionAux.setSede(tramiteInspeccion.getTisede());

		tramiteNotificacionAux.setTipoNotificacion(tramiteInspeccion.getTitiponotificacion());

		tramiteNotificacionAux.setTipoNotificacionPlatea(tramiteInspeccion.getTitiponotificacionplatea());

		tramiteNotificacionAux.setFechasalida(tramiteInspeccion.getTifecharegistrosalida());

		tramiteNotificacionAux.setNumregistrosalida(tramiteInspeccion.getTinumregistrosalida());

		tramiteNotificacionAux.setIdnotificacionplatea(tramiteInspeccion.getTiidnotificacionplatea());

		// Remesas Ini
		tramiteNotificacionAux.setEnvRemesaNotificacion(tramiteInspeccion.getTienvrem());
		if (tramiteInspeccion.getTicodrem() != null && !"".equals(tramiteInspeccion.getTicodrem())) {
			// Si tiene remesa asociada, recupero datos de la remesa
			Remesa remesa = new Remesa();
			remesa.setRmcodigo(tramiteInspeccion.getTicodrem());
			remesa = this.remesaDao.find(remesa);
			tramiteNotificacionAux.setIdRemesaNotificacion(remesa.getRmcodigo());
			tramiteNotificacionAux.setFechaRemesaNotificacion(remesa.getRmfechageneracion());
		}
		// Remesas Fin

		tramiteNotificacionAux.setNotificacionPorActa(tramiteInspeccion.getTinotificacionporacta());

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteInspeccion);

		tramiteNotificacionAux.setComentario(tramiteInspeccionAux.getTicomentario());

		tramiteNotificacionAux.setTextoComunicacion(tramiteInspeccion.getTitextocomunicacion());

		if ((tramiteInspeccion.getTramiteInspeccion() != null
				&& tramiteInspeccion.getTramiteInspeccion().getTicodigo() != null)
				|| Y41bConstantes.VALOR_SI.equals(tramiteInspeccion.getTiautomatico())) {
			tramiteNotificacionAux.setPermisoModificacionDestinatario(Y41bConstantes.NO);
		} else {
			tramiteNotificacionAux.setPermisoModificacionDestinatario(Y41bConstantes.SI);
		}

		if (tratamientoPermisoTramitar(tramiteInspeccion, censoMonitor)) {
			tramiteNotificacionAux.setPermisoTramitar(Y41bConstantes.SI);
		} else {
			tramiteNotificacionAux.setPermisoTramitar(Y41bConstantes.NO);
		}

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteNotificacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteNotificacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteNotificacionAux;
	}

	/**
	 * Finds a single row in the Inspecciones table.
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAcuseRecibo
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAcuseRecibo findTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteAcuseRecibo.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteAcuseRecibo tramiteAcuseReciboAux = new TramiteAcuseRecibo();
		tramiteAcuseReciboAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteAcuseReciboAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteAcuseReciboAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteAcuseReciboAux.setAccodigo(tramiteInspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteAcuseReciboAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteAcuseReciboAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAcuseReciboAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteAcuseReciboAux.setAcusereintentado(tramiteInspeccion.getTiacusereintentado());

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteInspeccion);

		tramiteAcuseReciboAux.setComentario(tramiteInspeccionAux.getTicomentario());

		// Info de Acuse recibo ini
		tramiteAcuseReciboAux.setFechaacuse(tramiteInspeccion.getTiacuserecibo());
		tramiteAcuseReciboAux.setSituacionacuse(tramiteInspeccion.getTiacusereciborecibido());
		tramiteAcuseReciboAux.setFechaentrada(tramiteInspeccion.getTifecharegistroentrada());
		tramiteAcuseReciboAux.setNumregistroentrada(tramiteInspeccion.getTinumregistroentrada());
		// Info de Acuse recibo fin

		// Recupero el tramite de notificacion relacionado ini
		TramiteNotificacion tramiteNotificacionWhere = new TramiteNotificacion();
		tramiteNotificacionWhere.setIdTramite(tramiteInspeccion.getTramiteInspeccion().getTicodigo());
		TramiteNotificacion tramiteNotificacionRelacionado = this.findTramiteNotificacion(tramiteNotificacionWhere,
				censoMonitor);
		tramiteAcuseReciboAux.setTramiteNotificacion(tramiteNotificacionRelacionado);
		// Recupero el tramite de notificacion relacionado fin

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteAcuseReciboAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAcuseReciboAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAcuseReciboAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteBOPVAyto
	 *            TramiteBOPVAyto
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteBOPVAyto findTramiteBOPVAyto(TramiteBOPVAyto tramiteBOPVAyto, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteBOPVAyto.getIdTramite());

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteBOPVAyto tramiteBOPVAytoAux = new TramiteBOPVAyto();
		tramiteBOPVAytoAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteBOPVAytoAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteBOPVAytoAux.setFechaFin(tramiteinspeccion.getTifechafin());
		tramiteBOPVAytoAux.setAccodigo(tramiteinspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteBOPVAytoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteBOPVAytoAux.setInstructorEjecucion(instructorEjecucion);

		tramiteBOPVAytoAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteinspeccion);

		tramiteBOPVAytoAux.setComentario(tramiteInspeccionAux.getTicomentario());

		tramiteBOPVAytoAux.setFechaPublicacionBOPV(tramiteinspeccion.getTifechapublicacionbopv());
		tramiteBOPVAytoAux.setFechaPublicacionAyto(tramiteinspeccion.getTifechapublicacionayto());
		tramiteBOPVAytoAux.setFechaEnvioBOPVBOE(tramiteinspeccion.getTifechaenviobopvboe());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteBOPVAytoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteBOPVAytoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteBOPVAytoAux;
	}

	/**
	 * Finds a single row in the inspeccion tramite table.
	 * 
	 * @param tramiteDesinmovilizacion
	 *            TramiteINSDesinmovilizacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSDesinmovilizacion findTramiteDesinmovilizacion(
			TramiteINSDesinmovilizacion tramiteDesinmovilizacion, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteDesinmovilizacion.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteINSDesinmovilizacion tramiteDesinmovilizacionAux = new TramiteINSDesinmovilizacion();
		tramiteDesinmovilizacionAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteDesinmovilizacionAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteDesinmovilizacionAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteDesinmovilizacionAux.setAccodigo(tramiteInspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteDesinmovilizacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteDesinmovilizacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteDesinmovilizacionAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteDesinmovilizacionAux.setTifechaaip(tramiteInspeccion.getTifechaaip());

		// Contadores

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteDesinmovilizacion.getIdExpediente());
		actuacion = this.actuacionDao.find(actuacion);

		tramiteDesinmovilizacionAux.setInmovilizadas(
				actuacion.getAtuinmovilizadas() != null ? actuacion.getAtuinmovilizadas().toString() : "0");

		tramiteDesinmovilizacionAux
				.setDestruidas(actuacion.getAtudestruidas() != null ? actuacion.getAtudestruidas().toString() : "0");

		tramiteDesinmovilizacionAux.setDevueltas(
				actuacion.getAtudevolucionorigen() != null ? actuacion.getAtudevolucionorigen().toString() : "0");

		tramiteDesinmovilizacionAux.setTomamuestras(
				actuacion.getAtutomamuestras() != null ? actuacion.getAtutomamuestras().toString() : "0");

		tramiteDesinmovilizacionAux.setLibrecomercializacion(actuacion.getAtulibrecomercializacion() != null
				? actuacion.getAtulibrecomercializacion().toString() : "0");

		tramiteDesinmovilizacionAux
				.setOtros(actuacion.getAtuotros() != null ? actuacion.getAtuotros().toString() : "0");

		tramiteDesinmovilizacionAux
				.setPendientes(actuacion.getAtupendientes() != null ? actuacion.getAtupendientes().toString() : "0");

		tramiteDesinmovilizacionAux.setRecuperadasContador(
				actuacion.getAturecuperadas() != null ? actuacion.getAturecuperadas().toString() : "0");

		// a inmovilizar
		tramiteDesinmovilizacionAux.setTinumdesin(tramiteInspeccion.getTinumdesin());

		// recuperadas
		tramiteDesinmovilizacionAux.setRecuperadas(tramiteInspeccion.getTinumrecupe());

		tramiteDesinmovilizacionAux.setTifechadesin(tramiteInspeccion.getTifechadesin());

		tramiteDesinmovilizacionAux.setTidestinodesin(tramiteInspeccion.getTidestinodesin());

		tramiteDesinmovilizacionAux.setTidestruccioninsitu(tramiteInspeccion.getTidestruccioninsitu());

		tramiteDesinmovilizacionAux.setComentario(tramiteInspeccion.getTicomentario());

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteDesinmovilizacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteDesinmovilizacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteDesinmovilizacionAux;
	}

	/**
	 * Finds a single row in the inspeccion tramite table.
	 * 
	 * @param tramiteEmisionInforme
	 *            TramiteINSEmisionInforme
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSEmisionInforme findTramiteEmisionInforme(TramiteINSEmisionInforme tramiteEmisionInforme,
			CensoMonitor censoMonitor) throws SQLException, IOException {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteEmisionInforme.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteINSEmisionInforme tramiteEmisionInformeAux = new TramiteINSEmisionInforme();
		tramiteEmisionInformeAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteEmisionInformeAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteEmisionInformeAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteEmisionInformeAux.setAccodigo(tramiteInspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteEmisionInformeAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteEmisionInformeAux.setInstructorEjecucion(instructorEjecucion);

		tramiteEmisionInformeAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteEmisionInformeAux.setTifechaemiinf(tramiteInspeccion.getTifechaemiinf());

		tramiteEmisionInformeAux.setTidniinf(tramiteInspeccion.getTidniinf());

		tramiteEmisionInformeAux.setTinombreinf(tramiteInspeccion.getTinombreinf());

		tramiteEmisionInformeAux.setTiencondicioninf(tramiteInspeccion.getTiencondicioninf());

		tramiteEmisionInformeAux.setTiinforme(tramiteInspeccion.getTiinforme());

		tramiteEmisionInformeAux.setComentario(tramiteInspeccion.getTicomentario());

		tramiteEmisionInformeAux.setTinombreCalle(tramiteInspeccion.getTinombreCalle());
		tramiteEmisionInformeAux.setTinombreCp(tramiteInspeccion.getTinombreCp());
		tramiteEmisionInformeAux.setTinoraMunicipioId(tramiteInspeccion.getTinoraMunicipioId());
		tramiteEmisionInformeAux.setTinoraPortalId(tramiteInspeccion.getTinoraPortalId());
		tramiteEmisionInformeAux.setTinoraCalleId(tramiteInspeccion.getTinoraCalleId());
		tramiteEmisionInformeAux.setTinoraProvinciaId(tramiteInspeccion.getTinoraProvinciaId());
		tramiteEmisionInformeAux.setTinoraLocalidadId(tramiteInspeccion.getTinoraLocalidadId());
		tramiteEmisionInformeAux.setTitelinf(tramiteInspeccion.getTitelinf());

		tramiteEmisionInformeAux.setTitelinf2(tramiteInspeccion.getTitelinf2());

		tramiteEmisionInformeAux.setTicompdireccion(tramiteInspeccion.getTicompdireccion());

		tramiteEmisionInformeAux.setTimaildestino(tramiteInspeccion.getTimaildestino());

		tramiteEmisionInformeAux.setTihorainicioemiinf(tramiteInspeccion.getTihorainicioemiinf());
		tramiteEmisionInformeAux.setTihorafininf(tramiteInspeccion.getTihorafininf());

		tramiteEmisionInformeAux.setTiligadoprotocolo(tramiteInspeccion.getTiligadoprotocolo());

		tramiteEmisionInformeAux.setTiape1inf(tramiteInspeccion.getTiape1inf());
		tramiteEmisionInformeAux.setTiape2inf(tramiteInspeccion.getTiape2inf());
		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteEmisionInformeAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteEmisionInformeAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteEmisionInformeAux;
	}

	/**
	 * Finds a single row in the inspeccion tramite table.
	 * 
	 * @param tramiteRemisionMuestrasAlLaboratorio
	 *            TramiteINSRemisionMuestrasAlLaboratorio
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSRemisionMuestrasAlLaboratorio findTramiteRemisionMuestrasAlLaboratorio(
			TramiteINSRemisionMuestrasAlLaboratorio tramiteRemisionMuestrasAlLaboratorio, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteRemisionMuestrasAlLaboratorio.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteINSRemisionMuestrasAlLaboratorio tramiteRemisionMuestrasAlLaboratorioAux = new TramiteINSRemisionMuestrasAlLaboratorio();
		tramiteRemisionMuestrasAlLaboratorioAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteRemisionMuestrasAlLaboratorioAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteRemisionMuestrasAlLaboratorioAux.setFechaFin(tramiteInspeccion.getTifechafin());

		if (tramiteInspeccion.getTiaccodigo() != null && !tramiteInspeccion.getTiaccodigo().equals("")) {
			ActaNueva actaNueva = new ActaNueva();
			actaNueva.setAncodigo(tramiteInspeccion.getTiaccodigo());
			actaNueva = actaNuevaDao.find(actaNueva);
			tramiteRemisionMuestrasAlLaboratorioAux.setTiancodigo(actaNueva.getAncodigo());
			tramiteRemisionMuestrasAlLaboratorioAux.setNombreActa(actaNueva.getAncodac());
		}

		tramiteRemisionMuestrasAlLaboratorioAux.setAccodigo(tramiteInspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRemisionMuestrasAlLaboratorioAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRemisionMuestrasAlLaboratorioAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRemisionMuestrasAlLaboratorioAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteRemisionMuestrasAlLaboratorioAux.setComentario(tramiteInspeccion.getTicomentario());

		tramiteRemisionMuestrasAlLaboratorioAux.setTifechaenvlab(tramiteInspeccion.getTifechaenvlab());
		tramiteRemisionMuestrasAlLaboratorioAux.setTicodmuestra(tramiteInspeccion.getTicodmuestra());
		tramiteRemisionMuestrasAlLaboratorioAux.setTilacodigo(tramiteInspeccion.getTilacodigo());

		if (tramiteInspeccion.getTilacodigo() != null) {

			Laboratorio laboratorio = new Laboratorio();
			laboratorio.setLacodigo(tramiteInspeccion.getTilacodigo());
			laboratorio = this.laboratorioDao.find(laboratorio);
			tramiteRemisionMuestrasAlLaboratorioAux.setLaboratorioNombre(laboratorio.getLanombre());
		}

		tramiteRemisionMuestrasAlLaboratorioAux.setTidetana(tramiteInspeccion.getTidetana());

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteRemisionMuestrasAlLaboratorioAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRemisionMuestrasAlLaboratorioAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRemisionMuestrasAlLaboratorioAux;
	}

	/**
	 * Finds a single row in the inspeccion tramite table.
	 * 
	 * @param tramiteINSEnviarMuestraEmpresa
	 *            TramiteINSEnviarMuestraEmpresa
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSRemisionMuestrasAlLaboratorio
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSEnviarMuestraEmpresa findTramiteEnviarMuestraEmpresa(
			TramiteINSEnviarMuestraEmpresa tramiteINSEnviarMuestraEmpresa, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteINSEnviarMuestraEmpresa.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteINSEnviarMuestraEmpresa tramiteINSEnviarMuestraEmpresaAux = new TramiteINSEnviarMuestraEmpresa();
		tramiteINSEnviarMuestraEmpresaAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteINSEnviarMuestraEmpresaAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteINSEnviarMuestraEmpresaAux.setFechaFin(tramiteInspeccion.getTifechafin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteINSEnviarMuestraEmpresaAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteINSEnviarMuestraEmpresaAux.setInstructorEjecucion(instructorEjecucion);

		tramiteINSEnviarMuestraEmpresaAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteINSEnviarMuestraEmpresaAux.setComentario(tramiteInspeccion.getTicomentario());

		tramiteINSEnviarMuestraEmpresaAux.setTifechaenvlab(tramiteInspeccion.getTifechaenvlab());
		tramiteINSEnviarMuestraEmpresaAux.setTilacodigo(tramiteInspeccion.getTilacodigo());

		if (tramiteInspeccion.getTilacodigo() != null) {

			Laboratorio laboratorio = new Laboratorio();
			laboratorio.setLacodigo(tramiteInspeccion.getTilacodigo());
			laboratorio = this.laboratorioDao.find(laboratorio);
			tramiteINSEnviarMuestraEmpresaAux.setLaboratorioNombre(laboratorio.getLanombre());
		}

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteINSEnviarMuestraEmpresaAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteINSEnviarMuestraEmpresaAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteINSEnviarMuestraEmpresaAux;
	}

	/**
	 * Finds a single row in the inspeccion tramite table.
	 * 
	 * @param tramiteResultadoEnsayos
	 *            TramiteINSResultadoEnsayos
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSResultadoEnsayos findTramiteResultadoEnsayos(TramiteINSResultadoEnsayos tramiteResultadoEnsayos,
			CensoMonitor censoMonitor) throws SQLException, IOException {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteResultadoEnsayos.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteINSResultadoEnsayos tramiteResultadoEnsayosAux = new TramiteINSResultadoEnsayos();
		tramiteResultadoEnsayosAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteResultadoEnsayosAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteResultadoEnsayosAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteResultadoEnsayosAux.setAccodigo(tramiteInspeccion.getTiaccodigo());

		tramiteResultadoEnsayosAux.setTifecharesens(tramiteInspeccion.getTifecharesens());
		tramiteResultadoEnsayosAux.setTicodmuestra(tramiteInspeccion.getTicodmuestra());
		tramiteResultadoEnsayosAux.setTicodinfensay(tramiteInspeccion.getTicodinfensay());
		tramiteResultadoEnsayosAux.setTiresudictam(tramiteInspeccion.getTiresudictam());
		tramiteResultadoEnsayosAux.setTiconstatacion(tramiteInspeccion.getTiconstatacion());
		tramiteResultadoEnsayosAux.setTiinclusiredalerta(tramiteInspeccion.getTiinclusiredalerta());
		tramiteResultadoEnsayosAux.setTifechacomunicacion(tramiteInspeccion.getTifechacomunicacion());
		tramiteResultadoEnsayosAux.setTilacodigo(tramiteInspeccion.getTilacodigo());

		if (tramiteInspeccion.getTilacodigo() != null) {

			Laboratorio laboratorio = new Laboratorio();
			laboratorio.setLacodigo(tramiteInspeccion.getTilacodigo());
			laboratorio = this.laboratorioDao.find(laboratorio);
			tramiteResultadoEnsayosAux.setLaboratorioNombre(laboratorio.getLanombre());
		}

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteResultadoEnsayosAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteResultadoEnsayosAux.setInstructorEjecucion(instructorEjecucion);

		tramiteResultadoEnsayosAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteResultadoEnsayosAux.setComentario(tramiteInspeccion.getTicomentario());

		if (tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteResultadoEnsayosAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteResultadoEnsayosAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteResultadoEnsayosAux;
	}

	/**
	 * Finds a single row os inspeccion .
	 * 
	 * @param tramiteElaboracionBOPVAyto
	 *            TramiteElaboracionBOPVAyto
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteElaboracionBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteElaboracionBOPVAyto findTramiteElaboracionBOPVAyto(
			TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAyto, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteElaboracionBOPVAyto.getIdTramite());

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAytoAux = new TramiteElaboracionBOPVAyto();
		tramiteElaboracionBOPVAytoAux.setIdTramite(tramiteinspeccion.getTicodigo());
		tramiteElaboracionBOPVAytoAux.setFechaInicio(tramiteinspeccion.getTifechainicio());
		tramiteElaboracionBOPVAytoAux.setFechaFin(tramiteinspeccion.getTifechafin());
		tramiteElaboracionBOPVAytoAux.setAccodigo(tramiteinspeccion.getTiaccodigo());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteinspeccion.getTicomoasignado());

		if (tramiteinspeccion.getTicomoasignado() != null && !tramiteinspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteElaboracionBOPVAytoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteinspeccion.getTicomoejecucion());

		if (tramiteinspeccion.getTicomoejecucion() != null && !tramiteinspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteElaboracionBOPVAytoAux.setInstructorEjecucion(instructorEjecucion);

		tramiteElaboracionBOPVAytoAux.setEstadoTramite(tramiteinspeccion.getTiestadotramite());

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteinspeccion);

		tramiteElaboracionBOPVAytoAux.setComentario(tramiteInspeccionAux.getTicomentario());

		if (tratamientoSeguridad(tramiteinspeccion, censoMonitor)) {
			tramiteElaboracionBOPVAytoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteElaboracionBOPVAytoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteElaboracionBOPVAytoAux;
	}

	/**
	 * Finds a single row in the Inspeccion table.
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRegistroDecision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRegistroDecision findTramiteRegistroDecision(TramiteRegistroDecision tramiteRegistroDecision,
			CensoMonitor censoMonitor) {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteRegistroDecision.getIdTramite());
		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteRegistroDecision tramiteRegistroDecisionAux = new TramiteRegistroDecision();
		tramiteRegistroDecisionAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteRegistroDecisionAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteRegistroDecisionAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteRegistroDecisionAux.setComentario(tramiteInspeccion.getTicomentario());

		// acta
		tramiteRegistroDecisionAux.setAncodigo(tramiteInspeccion.getTiancodigo());

		// Destinatario
		tramiteRegistroDecisionAux.setTidestinatario(tramiteInspeccion.getTidestinatario());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());
		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}
		tramiteRegistroDecisionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());
		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}
		tramiteRegistroDecisionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRegistroDecisionAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		if (this.tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteRegistroDecisionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRegistroDecisionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		// Registro decision ini
		tramiteRegistroDecisionAux.setTipoDecision(tramiteInspeccion.getTidecodigo());
		tramiteRegistroDecisionAux.setFechaDecision(tramiteInspeccion.getTifecharesolucion());
		// Registro decision fin

		// TramiteInspeccion
		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteInspeccion);

		tramiteRegistroDecisionAux.setComentario(tramiteInspeccionAux.getTicomentario());

		tramiteRegistroDecisionAux.setJustificacionInfraccion(tramiteInspeccion.getTijustificacioninfraccion());

		if (tramiteInspeccion.getTicoortraspaso() != null && !tramiteInspeccion.getTicoortraspaso().equals("")) {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(tramiteInspeccion.getTicoortraspaso());

			organismo = this.organismoDao.find(organismo);

			tramiteRegistroDecisionAux.setCodOrgTraslado(organismo.getCodOrg());
			tramiteRegistroDecisionAux.setNombreOrgTrasladoEs(organismo.getNombreEs());
			tramiteRegistroDecisionAux.setNombreOrgTrasladoEu(organismo.getNombreEu());
		}

		// Si existe una o mas notificaciones cuyos padres sean Resoluciones
		// AIP, coge la fecha mas a futuro para calcular el plazo de recurso.
		tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTiatcodigo(tramiteInspeccion.getTiatcodigo());
		tramiteInspeccionAux.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);
		tramiteInspeccionAux.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		TramiteInspeccion tramiteInspeccionAux2 = new TramiteInspeccion();
		tramiteInspeccionAux2.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RESOLUCION_ACUERDO_INICIO_PROCEDIMIENTO);
		tramiteInspeccionAux.setTramiteInspeccion(tramiteInspeccionAux2);
		List<TramiteInspeccion> listaTramitesAux = this.tramiteInspeccionService.findAll(tramiteInspeccionAux, null);

		if (listaTramitesAux.size() > 0) {
			for (TramiteInspeccion tramiteInspeccionAux3 : listaTramitesAux) {
				if (tramiteRegistroDecisionAux.getPlazoRecurso() == null
						|| tramiteInspeccionAux3.getTifecmodif().after(tramiteRegistroDecisionAux.getPlazoRecurso())) {
					tramiteRegistroDecisionAux.setPlazoRecurso(tramiteInspeccionAux3.getTifecmodif());
				}
			}

			Parametros parametros = new Parametros();
			parametros.setParametro(Y41bConstantes.INSPECCIONES_PLAZO_RECURSO);
			parametros = this.parametrosDao.find(parametros);
			if (null != parametros && null != parametros.getValor()) {
				Date ultimaFecha = tramiteRegistroDecisionAux.getPlazoRecurso();
				Calendar c = Calendar.getInstance();
				c.setTime(ultimaFecha);
				c.add(Calendar.DAY_OF_MONTH, Integer.parseInt(parametros.getValor()));
				ultimaFecha = c.getTime();
				tramiteRegistroDecisionAux.setPlazoRecurso(ultimaFecha);
			}

		}

		return tramiteRegistroDecisionAux;
	}

	/**
	 * Finds a single row in the Inspeccion table.
	 * 
	 * @param tramiteINSArchivoAIP
	 *            TramiteINSArchivoAIP
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSArchivoAIP
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSArchivoAIP findTramiteArchivoAIP(TramiteINSArchivoAIP tramiteINSArchivoAIP,
			CensoMonitor censoMonitor) {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteINSArchivoAIP.getIdTramite());
		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteINSArchivoAIP tramiteINSArchivoAIPAux = new TramiteINSArchivoAIP();
		tramiteINSArchivoAIPAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteINSArchivoAIPAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteINSArchivoAIPAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteINSArchivoAIPAux.setComentario(tramiteInspeccion.getTicomentario());

		// acta
		tramiteINSArchivoAIPAux.setAncodigo(tramiteInspeccion.getTiancodigo());

		// Destinatario
		tramiteINSArchivoAIPAux.setTidestinatario(tramiteInspeccion.getTidestinatario());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());
		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}
		tramiteINSArchivoAIPAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());
		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}
		tramiteINSArchivoAIPAux.setInstructorEjecucion(instructorEjecucion);

		tramiteINSArchivoAIPAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		if (this.tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteINSArchivoAIPAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteINSArchivoAIPAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		// Registro decision ini
		tramiteINSArchivoAIPAux.setTipoDecision(tramiteInspeccion.getTidecodigo());
		tramiteINSArchivoAIPAux.setFechaDecision(tramiteInspeccion.getTifecharesolucion());
		// Registro decision fin

		// TramiteInspeccion
		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteInspeccion);

		tramiteINSArchivoAIPAux.setComentario(tramiteInspeccionAux.getTicomentario());

		// Si existe una o mas notificaciones cuyos padres sean Resoluciones
		// AIP, coge la fecha mas a futuro para calcular el plazo de recurso.
		tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTiatcodigo(tramiteInspeccion.getTiatcodigo());
		tramiteInspeccionAux.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);
		tramiteInspeccionAux.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		TramiteInspeccion tramiteInspeccionAux2 = new TramiteInspeccion();
		tramiteInspeccionAux2.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RESOLUCION_ACUERDO_INICIO_PROCEDIMIENTO);
		tramiteInspeccionAux.setTramiteInspeccion(tramiteInspeccionAux2);
		List<TramiteInspeccion> listaTramitesAux = this.tramiteInspeccionService.findAll(tramiteInspeccionAux, null);

		if (listaTramitesAux.size() > 0) {
			for (TramiteInspeccion tramiteInspeccionAux3 : listaTramitesAux) {
				if (tramiteINSArchivoAIPAux.getPlazoRecurso() == null
						|| tramiteInspeccionAux3.getTifecmodif().after(tramiteINSArchivoAIPAux.getPlazoRecurso())) {
					tramiteINSArchivoAIPAux.setPlazoRecurso(tramiteInspeccionAux3.getTifecmodif());
				}
			}

			Parametros parametros = new Parametros();
			parametros.setParametro(Y41bConstantes.INSPECCIONES_PLAZO_RECURSO);
			parametros = this.parametrosDao.find(parametros);
			if (null != parametros && null != parametros.getValor()) {
				Date ultimaFecha = tramiteINSArchivoAIPAux.getPlazoRecurso();
				Calendar c = Calendar.getInstance();
				c.setTime(ultimaFecha);
				c.add(Calendar.DAY_OF_MONTH, Integer.parseInt(parametros.getValor()));
				ultimaFecha = c.getTime();
				tramiteINSArchivoAIPAux.setPlazoRecurso(ultimaFecha);
			}

		}

		return tramiteINSArchivoAIPAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionRecurso
	 *            TramiteRecepcionRecurso
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRecurso
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionRecurso findTramiteRecepcionRecurso(TramiteRecepcionRecurso tramiteRecepcionRecurso,
			CensoMonitor censoMonitor) throws SQLException, IOException {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteRecepcionRecurso.getIdTramite());
		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteRecepcionRecurso tramiteRecepcionRecursoAux = new TramiteRecepcionRecurso();
		tramiteRecepcionRecursoAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteRecepcionRecursoAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteRecepcionRecursoAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteRecepcionRecursoAux.setComentario(tramiteInspeccion.getTicomentario());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());
		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}
		tramiteRecepcionRecursoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());
		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}
		tramiteRecepcionRecursoAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRecepcionRecursoAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		// Info recepcion recurso ini
		tramiteRecepcionRecursoAux.setTiporecurso(tramiteInspeccion.getTitiporecurso());
		tramiteRecepcionRecursoAux.setFecharecurso(tramiteInspeccion.getTifecharecurso());
		tramiteRecepcionRecursoAux.setAbogado(tramiteInspeccion.getTiabogado());

		tramiteRecepcionRecursoAux.setMotivorecurso(tramiteInspeccion.getTimotivorecurso());

		// Info recepcion recurso fin

		if (this.tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteRecepcionRecursoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRecepcionRecursoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRecepcionRecursoAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteInformeAsesoria
	 *            TramiteInformeAsesoria
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteInformeAsesoria
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInformeAsesoria findTramiteInformeAsesoria(TramiteInformeAsesoria tramiteInformeAsesoria,
			CensoMonitor censoMonitor) {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteInformeAsesoria.getIdTramite());
		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteInformeAsesoria tramiteInformeAsesoriaAux = new TramiteInformeAsesoria();
		tramiteInformeAsesoriaAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteInformeAsesoriaAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteInformeAsesoriaAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteInformeAsesoriaAux.setComentario(tramiteInspeccion.getTicomentario());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());
		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}
		tramiteInformeAsesoriaAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());
		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}
		tramiteInformeAsesoriaAux.setInstructorEjecucion(instructorEjecucion);

		tramiteInformeAsesoriaAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		if (this.tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteInformeAsesoriaAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteInformeAsesoriaAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteInformeAsesoriaAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionOrdenConsejero
	 *            TramiteRecepcionOrdenConsejero
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionOrdenConsejero
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionOrdenConsejero findTramiteRecepcionOrdenConsejero(
			TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejero, CensoMonitor censoMonitor)
			throws SQLException, IOException {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteRecepcionOrdenConsejero.getIdTramite());
		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejeroAux = new TramiteRecepcionOrdenConsejero();
		tramiteRecepcionOrdenConsejeroAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteRecepcionOrdenConsejeroAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteRecepcionOrdenConsejeroAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteRecepcionOrdenConsejeroAux.setComentario(tramiteInspeccion.getTicomentario());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteRecepcionOrdenConsejeroAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteRecepcionOrdenConsejeroAux.setInstructorEjecucion(instructorEjecucion);

		tramiteRecepcionOrdenConsejeroAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		// Info recepcion orden consejero ini
		tramiteRecepcionOrdenConsejeroAux.setEstimacion(tramiteInspeccion.getTiestimacion());
		// Info recepcion orden consejero fin

		if (this.tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteRecepcionOrdenConsejeroAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteRecepcionOrdenConsejeroAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteRecepcionOrdenConsejeroAux;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAlegacion
	 *            TramiteAlegacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAlegacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAlegacion findTramiteAlegacion(TramiteAlegacion tramiteAlegacion, CensoMonitor censoMonitor) {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteAlegacion.getIdTramite());
		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		TramiteAlegacion tramiteAlegacionAux = new TramiteAlegacion();
		tramiteAlegacionAux.setIdTramite(tramiteInspeccion.getTicodigo());
		tramiteAlegacionAux.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteAlegacionAux.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteAlegacionAux.setComentario(tramiteInspeccion.getTicomentario());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

		if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}

		tramiteAlegacionAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());

		if (tramiteInspeccion.getTicomoejecucion() != null && !tramiteInspeccion.getTicomoejecucion().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}

		tramiteAlegacionAux.setInstructorEjecucion(instructorEjecucion);

		tramiteAlegacionAux.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		tramiteAlegacionAux.setRespuesta(tramiteInspeccion.getTirespuestarecepcion());

		tramiteAlegacionAux.setResumenAlegaciones(tramiteInspeccion.getTiresumenrecepcion());

		if (this.tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
			tramiteAlegacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAlegacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAlegacionAux;
	}

	/**
	 * Obtiene el objecto de tramite generico firma
	 * 
	 * @param tramiteINSGenericoFirma
	 *            TramiteINSGenericoFirma
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteINSGenericoFirma
	 */
	public TramiteINSGenericoFirma findTramiteGenericoFirma(TramiteINSGenericoFirma tramiteINSGenericoFirma,
			CensoMonitor monitor) {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteINSGenericoFirma.getIdTramite());
		tramiteInspeccion = this.tramiteInspeccionService.find(tramiteInspeccion);

		tramiteINSGenericoFirma.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteINSGenericoFirma.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteINSGenericoFirma.setComentario(tramiteInspeccion.getTicomentario());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());
		if (instructorAsignado.getMocodigo() != null && !instructorAsignado.getMocodigo().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}
		tramiteINSGenericoFirma.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());
		if (instructorEjecucion.getMocodigo() != null && !instructorEjecucion.getMocodigo().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}
		tramiteINSGenericoFirma.setInstructorEjecucion(instructorEjecucion);

		tramiteINSGenericoFirma.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		if (this.tratamientoSeguridad(tramiteInspeccion, monitor)) {
			tramiteINSGenericoFirma.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteINSGenericoFirma.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteINSGenericoFirma;
	}

	/**
	 * Obtiene el objecto de tramite Comunicacin de existencia de nuevo
	 * Distribuidor
	 * 
	 * @param tramiteINSComunicarNuevoDistribuidor
	 *            TramiteINSComunicarNuevoDistribuidor
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteINSComunicarNuevoDistribuidor
	 */
	public TramiteINSComunicarNuevoDistribuidor findTramiteComunicarNuevoDistribuidor(
			TramiteINSComunicarNuevoDistribuidor tramiteINSComunicarNuevoDistribuidor, CensoMonitor monitor) {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteINSComunicarNuevoDistribuidor.getIdTramite());
		tramiteInspeccion = this.tramiteInspeccionService.find(tramiteInspeccion);

		tramiteINSComunicarNuevoDistribuidor.setFechaInicio(tramiteInspeccion.getTifechainicio());
		tramiteINSComunicarNuevoDistribuidor.setFechaFin(tramiteInspeccion.getTifechafin());
		tramiteINSComunicarNuevoDistribuidor.setComentario(tramiteInspeccion.getTicomentario());

		CensoMonitor instructorAsignado = new CensoMonitor();
		instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());
		if (instructorAsignado.getMocodigo() != null && !instructorAsignado.getMocodigo().equals("")) {
			instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
		}
		tramiteINSComunicarNuevoDistribuidor.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		instructorEjecucion.setMocodigo(tramiteInspeccion.getTicomoejecucion());
		if (instructorEjecucion.getMocodigo() != null && !instructorEjecucion.getMocodigo().equals("")) {
			instructorEjecucion = this.censoMonitorDao.find(instructorEjecucion);
		}
		tramiteINSComunicarNuevoDistribuidor.setInstructorEjecucion(instructorEjecucion);

		tramiteINSComunicarNuevoDistribuidor.setEstadoTramite(tramiteInspeccion.getTiestadotramite());

		if (this.tratamientoSeguridad(tramiteInspeccion, monitor)) {
			tramiteINSComunicarNuevoDistribuidor.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteINSComunicarNuevoDistribuidor.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteINSComunicarNuevoDistribuidor;
	}

	/********************
	 * ADDS DE TRAMITES *
	 ********************/

	/**
	 * Guardar tramite aportacion de documentacion
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION);

		tramiteinspeccion.setTifechainicio(tramiteAdjuntarDocs.getFechaInicio());
		// tramiteinspeccion.setTiaccodigo(tramiteComun.getAccodigo());

		tramiteinspeccion.setTicomoasignado(tramiteAdjuntarDocs.getInstructorAsignado().getMocodigo());
		tramiteinspeccion.setTicomoejecucion(tramiteAdjuntarDocs.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteAdjuntarDocs.getComentario());

		if (tramitar) {
			tramiteinspeccion.setTifechafin(tramiteAdjuntarDocs.getFechaFin());
			tramiteinspeccion.setTicomoejecucion(tramiteAdjuntarDocs.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
			this.enviarMailInstructorRegistroDecision(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_APORTACION_DOCUMENTOS)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
			this.enviarMailInstructor(tramiteinspeccion);
			this.enviarMailInstructorRegistroDecision(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.soltramexpService.procesarDocumentosTramite(tramiteComun);

		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (tramitar) {
			// Validacion: Debe haber almenos 1 documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
		}

		if (tramitar) {
			// Subimos los documentos a dokusi sin localizar
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {

				// Recorro los documentos del tramite buscando aquel
				// documento que
				// este pendiente de firma
				DocumentoHecho documentoHecho = null;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					documentoHecho = listDocumentoHecho.get(i);
					TramiteComun tramiteComunDokusiAux = new TramiteComun();
					tramiteComunDokusiAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
					tramiteComunDokusiAux.setIdTramite(documentoHecho.getQ5tramite());

					this.soltramexpService.registrarDocumentosDokusiSinLocalizarIns(documentoHecho,
							tramiteComunDokusiAux);
				}
			}

			TramiteInspeccion tramiteinspeccionAux = new TramiteInspeccion();
			tramiteinspeccionAux.setTicodigo(tramiteComun.getIdTramite());

			tramiteinspeccionAux = this.tramiteInspeccionDao.find(tramiteinspeccionAux);

			if (tramiteinspeccionAux.getTiistelematico() == null) {
				this.inspeccionService.actualizarMisGestionesAportaciondocumentacion(tramiteinspeccion,
						listDocumentoHecho);
			}

			this.adjuntarDocumentosTramiteCorrespondiente(listDocumentoHecho, tramiteComun);
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteinspeccion;
	}

	/**
	 * Guardar tramite asignacion instructor
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteAsignacionInstructor(TramiteAsignacionInstructor tramiteAsignacionInstructor,
			TramiteComun tramiteComun, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ASIGNACION_RESPONSABLE_EXPEDIENTE);
		tramiteInspeccion.setTifechainicio(tramiteAsignacionInstructor.getFechaInicio());
		if (tramiteAsignacionInstructor.getInstructorAsignado() != null) {
			tramiteInspeccion.setTicomoasignado(tramiteAsignacionInstructor.getInstructorAsignado().getMocodigo());
			tramiteInspeccion.setTicomodesignado(tramiteAsignacionInstructor.getInstructorExpediente().getMocodigo());
		}

		tramiteInspeccion.setTicomentario(tramiteAsignacionInstructor.getComentario());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteAsignacionInstructor.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteAsignacionInstructor.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			// Generar numero expediente
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());
			InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

			if (inspeccionDetalle != null && inspeccionDetalle.getAcnror() != null
					&& inspeccionDetalle.getAcnror().equals(Y41bConstantes.INSPECCIONES_NUM_EXPEDIENTE_INICIAL)) {
				Acta actaAux = new Acta();
				actaAux.setAccodigo(inspeccionDetalle.getAccodigo());
				actaAux.setAccoor(inspeccionDetalle.getAccoor());
				actaAux.setAcnran(inspeccionDetalle.getAcnran());

				actaAux.setAcnror(String.valueOf(this.actaDao.getNextAcnror(actaAux)));

				this.actaDao.updateNumExpediente(actaAux);
			}

		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		if (tramitar) {
			// Actualizamos el instructor de la actuacion
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());

			Acta acta = new Acta();
			acta.setAccomo(tramiteAsignacionInstructor.getInstructorExpediente().getMocodigo());
			actuacion.setActa(acta);

			this.actuacionDao.updateTramiteCambioInstructor(actuacion);

			// Si no existe ya, sugerimos el registro de inspeccion.
			Long total = this.tramiteInspeccionDao.findTramiteRegistroInspeccionPorActuacionCount(actuacion);
			if (total == 0) {
				this.generarTramiteRegistroInspeccion(actuacion.getAtcodigo(), acta.getAccomo(), false);
			}

			// Si el origen es una solicitud, generar en ella un tramite de
			// Recepcion de inpeccion.
			Actuacion actuacionAux = new Actuacion();
			actuacionAux.setAtcodigo(tramiteComun.getIdExpediente());
			actuacionAux = this.actuacionDao.find(actuacionAux);

			if (actuacionAux.getAtcohd() != null) {
				TramiteHecho tramiteRecepcionInspeccion = new TramiteHecho();
				TramiteComun tramiteComunAux = new TramiteComun();

				tramiteComunAux.setIdExpediente(actuacionAux.getAtcohd());
				tramiteRecepcionInspeccion.setEhfechainicio(new Date());
				tramiteRecepcionInspeccion.setEhfecha(new Date());

				String numExpediente = actuacionAux.getActa().getAccoor() + "-" + actuacionAux.getActa().getAcnror()
						+ "-" + actuacionAux.getActa().getAcnran() + "-" + actuacionAux.getAtnror();

				tramiteRecepcionInspeccion.setEhcodins(numExpediente);
				tramiteRecepcionInspeccion.setEhcoactua(actuacionAux.getAtcodigo());

				this.soltramexpService.generarTramiteRecepcionInspeccion(tramiteRecepcionInspeccion, tramiteComunAux);
			}

			BandejaInspecciones bandejaInspecciones = new BandejaInspecciones();
			bandejaInspecciones.setAtcodigo(tramiteComun.getIdExpediente());

			this.bandejaInspeccionesService.updateUltimoTramite(bandejaInspecciones);
		}

		return tramiteInspeccion;
	}

	/**
	 * Guardar tramite asignacion instructor
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteAsignacionInstructorMasiva(
			TramiteAsignacionInstructor tramiteAsignacionInstructor, TramiteComun tramiteComun, boolean tramitar,
			String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ASIGNACION_RESPONSABLE_EXPEDIENTE);
		tramiteInspeccion.setTifechainicio(tramiteAsignacionInstructor.getFechaInicio());
		if (tramiteAsignacionInstructor.getInstructorAsignado() != null) {
			tramiteInspeccion.setTicomoasignado(tramiteAsignacionInstructor.getInstructorAsignado().getMocodigo());
			tramiteInspeccion.setTicomodesignado(tramiteAsignacionInstructor.getInstructorExpediente().getMocodigo());
		}

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		tramiteInspeccion = this.tramiteInspeccionService.addTramiteInspeccionMasiva(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Guardar Tramite Registro Inspeccion
	 * 
	 * @param tramiteRegistroSolicitud
	 *            TramiteRegistroSolicitud
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteRegistroSolicitud
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRegistroSolicitud addTramiteRegistroInspeccion(TramiteRegistroSolicitud tramiteRegistroSolicitud,
			TramiteComun tramiteComun, boolean tramitar, String modoEditar) throws Exception {
		TramiteInspeccion tramiteInspeccion = null;
		if (tramitar) {
			// Validar campos obligatorios
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());

			InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

			if (this.validarSiTramiteInspeccionEstaCompleta(inspeccionDetalle)) {
				throw new Y41bUDAException("error.inspecciones.noCompletaInspeccionException", true, new Exception());
			}
		}

		tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_INSPECCION);
		tramiteInspeccion.setTifechainicio(tramiteRegistroSolicitud.getFechaInicio());
		// tramiteInspeccion.setTiaccodigo(tramiteRegistroSolicitud.getAccodigo());
		tramiteInspeccion.setTicomoasignado(tramiteRegistroSolicitud.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteRegistroSolicitud.getComentario());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteRegistroSolicitud.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteRegistroSolicitud.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);

		}

		List<DocumentoExpediente> listDocumentoExpediente = new ArrayList<DocumentoExpediente>();
		if (tramiteRegistroSolicitud.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);
		}

		if (tramitar) {
			Actuacion actuacionAux = new Actuacion();
			actuacionAux.setAtcodigo(tramiteComun.getIdExpediente());
			actuacionAux = this.actuacionDao.find(actuacionAux);

			// Si tiene un origen de Solicitudes / Denuncias AACC, genera el
			// tramite de Informe de valoracion de la inspeccion solicitada.
			if (actuacionAux.getAtcohd() != null) {
				this.generarTramiteAutomatico(tramiteComun, Y41bConstantes.TRAMITE_INSPECCIONES_INFORME_VALORACION);
			}

			// Si en Actuacion tiene el campo ATACUERDOINICIO, generar
			// automaticamente un AIP.
			if (Y41bConstantes.VALOR_SI.equals(actuacionAux.getAtacuerdoinicio())) {
				TramiteINSAcuerdoInicioProcedimiento tramiteAcuerdoInicioProcedimiento = new TramiteINSAcuerdoInicioProcedimiento();
				tramiteAcuerdoInicioProcedimiento.setIdExpediente(tramiteComun.getIdExpediente());
				tramiteAcuerdoInicioProcedimiento.setAccodigo(tramiteRegistroSolicitud.getAccodigo());
				tramiteAcuerdoInicioProcedimiento.setCodigoTramiteRelacionado(tramiteComun.getIdTramite());

				tramiteAcuerdoInicioProcedimiento
						.setInstructorAsignado(tramiteRegistroSolicitud.getInstructorAsignado());

				this.generarTramiteAcuerdoInicioProcedimiento(tramiteAcuerdoInicioProcedimiento);

				// Actualizar ultimo tramite
				actuacionAux = new Actuacion();
				actuacionAux.setAtcodigo(tramiteInspeccion.getTicodigo());
				actuacionAux.setFcodigoactual(Y41bConstantes.FASE_REGISTRO);
				actuacionAux.setTrcodigoactual(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);
				actuacionAux.setTrposiblecodigo(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);

				this.actuacionDao.updateUltimoTramiteConFase(actuacionAux);

			} else {
				// Actualizar ultimo tramite
				actuacionAux = new Actuacion();
				actuacionAux.setAtcodigo(tramiteInspeccion.getTicodigo());
				actuacionAux.setFcodigoactual(Y41bConstantes.FASE_REGISTRO);
				actuacionAux.setTrcodigoactual(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_INSPECCION);
				actuacionAux.setTrposiblecodigo(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_INSPECCION);

				this.actuacionDao.updateUltimoTramiteConFase(actuacionAux);
			}

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());

			InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

			if (Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA.equals(inspeccionDetalle.getActiororigen())) {
				this.generarTramiteComunicacionRegistroInspeccion(tramiteRegistroSolicitud, tramiteComun);
			}

		}

		if (tramitar) {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteInspeccion.getTiatcodigo());

			InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

			if (insDetalle != null && insDetalle.getAtidcomunicacionsoivre() != null) {
				HistorialAlerta historialAlerta = new HistorialAlerta();
				historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				historialAlerta.setCodigo(insDetalle.getAtidcomunicacionsoivre());
				historialAlerta.setOrganismoorigen(insDetalle.getAdcoor());
				historialAlerta.setOrganismodestino(Y41bConstantes.ORGANISMO_SSCC);
				historialAlerta.setDescripcion(Y41bConstantes.FECHA_PRIMER_CONTACTO_COMUNICACION_SOIVRE);
				historialAlerta.setGenerado(Y41bConstantes.SI);
				historialAlerta.setFecha(new Date());

				this.historialAlertaDao.add(historialAlerta);
			}
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteRegistroSolicitud;
	}

	/**
	 * Guardar Tramite de Acuerdo de Inicio de Procedimiento
	 * 
	 * @param tramiteAcuerdoInicioProcedimiento
	 *            TramiteINSAcuerdoInicioProcedimiento
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteINSAcuerdoInicioProcedimiento
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSAcuerdoInicioProcedimiento addTramiteAcuerdoInicioProcedimiento(
			TramiteINSAcuerdoInicioProcedimiento tramiteAcuerdoInicioProcedimiento, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {
		TramiteInspeccion tramiteInspeccion = null;
		tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);
		tramiteInspeccion.setTifechainicio(tramiteAcuerdoInicioProcedimiento.getFechaInicio());
		tramiteInspeccion.setTiaccodigo(tramiteAcuerdoInicioProcedimiento.getAccodigo());
		tramiteInspeccion.setTicomoasignado(tramiteAcuerdoInicioProcedimiento.getInstructorAsignado().getMocodigo());

		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTicodigo(tramiteAcuerdoInicioProcedimiento.getCodigoTramiteRelacionado());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionAux);

		tramiteInspeccion.setTicomentario(tramiteAcuerdoInicioProcedimiento.getComentario());

		tramiteInspeccion.setTifecharesolucion(tramiteAcuerdoInicioProcedimiento.getFechaDecision());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteAcuerdoInicioProcedimiento.getFechaFin());
			tramiteInspeccion
					.setTicomoejecucion(tramiteAcuerdoInicioProcedimiento.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);

		}

		List<DocumentoExpediente> listDocumentoExpediente = new ArrayList<DocumentoExpediente>();
		if (tramiteAcuerdoInicioProcedimiento.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.soltramexpService.controlDocumentosPendientesFirmaTramitar(tramiteComun,
						Y41bConstantes.TIPO_PROC_INSPECCIONES);
			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramiteInspeccion,
						Y41bConstantes.FASE_REQUERIMIENTO,
						Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);
			}
		}

		if (tramitar) {
			// Si existe el tramite de Desinmovilizacion asignado al mismo acta,
			// lo elimina.
			TramiteInspeccion tramiteInspeccionElim = new TramiteInspeccion();
			tramiteInspeccionElim.setTiatcodigo(tramiteComun.getIdExpediente());
			tramiteInspeccionElim.setTiaccodigo(tramiteAcuerdoInicioProcedimiento.getAccodigo());
			tramiteInspeccionElim.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_DESINMOVILIZACION);

			List<TramiteInspeccion> listaTramitesBorrar = this.tramiteInspeccionDao
					.findAllTramitesPendientesPorTipo(tramiteInspeccionElim, null);
			for (TramiteInspeccion tramiteBorrar : listaTramitesBorrar) {
				this.tramiteInspeccionDao.remove(tramiteBorrar);
			}

			// Generar el tramite de Notificacion por Acta.
			this.generarTramiteNotificacionPorActaAutomaticoAIP(tramiteAcuerdoInicioProcedimiento, tramiteComun);

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());

			InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

			if (inspeccionDetalle != null && inspeccionDetalle.getEstablecimientoV() != null
					&& Y41bUtils.isValidCIF(inspeccionDetalle.getEstablecimientoV().getNif())) {
				if (inspeccionDetalle.getAtformanotifestablecimientovi() != null && inspeccionDetalle
						.getAtformanotifestablecimientovi().equals(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA)) {
					this.generarTramiteComunicacionPostalAIP(tramiteAcuerdoInicioProcedimiento, tramiteComun);
				}
			}
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		if (tramitar) {
			CensoMonitor censoMonitor = tramiteAcuerdoInicioProcedimiento.getInstructorEjecucion();

			// revisar si es control mercado
			if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
					.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
				this.enviarEmailTramiteEjecutadoSSCC(tramiteComun.getIdExpediente(),
						Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);
			}
		}

		return tramiteAcuerdoInicioProcedimiento;
	}

	/**
	 * Guardar Tramite Levantamiento Acta
	 * 
	 * @param tramiteRegistroSolicitud
	 *            TramiteRegistroSolicitud
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteINSLevantamientoActa
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSLevantamientoActa addTramiteLevantamientoActa(TramiteINSLevantamientoActa tramiteLevantamientoActa,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		// El tramite se genera como tramitado de forma automatica.
		// El usuario no realiza ninguna accion por lo que no hay validaciones.
		tramiteInspeccion.setTifechainicio(tramiteLevantamientoActa.getFechaInicio());
		tramiteInspeccion.setTifechafin(tramiteLevantamientoActa.getFechaFin());
		tramiteInspeccion.setTiaccodigo(tramiteLevantamientoActa.getAccodigo());

		tramiteInspeccion.setTicomoasignado(tramiteLevantamientoActa.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomoejecucion(tramiteLevantamientoActa.getInstructorEjecucion().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteLevantamientoActa.getComentario());

		tramiteInspeccion.setTiancodigo(tramiteLevantamientoActa.getAncodigo());
		tramiteLevantamientoActa.setTipoActa(tramiteInspeccion.getTitipactua());

		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_LEVANTAMIENTO_ACTA);
		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		tramiteInspeccionDao.add(tramiteInspeccion);

		return tramiteLevantamientoActa;
	}

	/**
	 * Guardar Tramite de Acuerdo de Inicio de Procedimiento
	 * 
	 * @param tramiteRequerimientoEscrito
	 *            TramiteRequerimientoInformacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteRequerimientoInformacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRequerimientoInformacion addTramiteRequerimientoEscrito(
			TramiteRequerimientoInformacion tramiteRequerimientoEscrito, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {
		TramiteInspeccion tramiteInspeccion = null;
		tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REQUERIMIENTO_POR_ESCRITO);
		tramiteInspeccion.setTifechainicio(tramiteRequerimientoEscrito.getFechaInicio());
		// tramiteInspeccion.setTiaccodigo(tramiteRequerimientoEscrito
		// .getAccodigo());
		tramiteInspeccion.setTicomoasignado(tramiteRequerimientoEscrito.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteRequerimientoEscrito.getComentario());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteRequerimientoEscrito.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteRequerimientoEscrito.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		tramiteInspeccion.setTiorigenalegacion(tramiteRequerimientoEscrito.getOrigen());
		tramiteInspeccion.setTidocumentacionrequerida(tramiteRequerimientoEscrito.getDocumentacionrequerida());
		tramiteInspeccion.setTidocumentacionrequeridae(tramiteRequerimientoEscrito.getDocumentacionrequeridae());

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);

		}

		List<DocumentoExpediente> listDocumentoExpediente = new ArrayList<DocumentoExpediente>();
		if (tramiteRequerimientoEscrito.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.soltramexpService.controlDocumentosPendientesFirmaTramitar(tramiteComun,
						Y41bConstantes.TIPO_PROC_INSPECCIONES);
			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramiteInspeccion,
						Y41bConstantes.FASE_REQUERIMIENTO,
						Y41bConstantes.TRAMITE_INSPECCIONES_REQUERIMIENTO_POR_ESCRITO);
			}
		}

		if (tramitar) {
			// Generar notificacion al establecimiento visitado
			this.generarTramiteNotificacionAutomaticoRequerimientoEscrito(tramiteRequerimientoEscrito, tramiteComun);

			// Generar recepcion informacion
			this.generarTramiteRecInformacionAutomaticoRequerimientoEscrito(tramiteInspeccion, tramiteComun);
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteRequerimientoEscrito;
	}

	/**
	 * Guardar el tramite Recepcion Requerimiento
	 * 
	 * @param tramiteRecepcionRequerimiento
	 *            TramiteRecepcionRequerimientoInformacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRecepcionRequerimiento(
			TramiteRecepcionRequerimientoInformacion tramiteRecepcionRequerimiento, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_REQUERIMIENTO);

		tramiteInspeccion.setTifechainicio(tramiteRecepcionRequerimiento.getFechaInicio());
		// tramiteInspeccion.setTiaccodigo(tramiteRecepcionRequerimiento
		// .getAccodigo());
		tramiteInspeccion.setTicomoasignado(tramiteRecepcionRequerimiento.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteRecepcionRequerimiento.getComentario());

		tramiteInspeccion.setTiresumenrecepcion(tramiteRecepcionRequerimiento.getResumenAlegaciones());
		tramiteInspeccion.setTirespuestarecepcion(tramiteRecepcionRequerimiento.getRespuesta());
		tramiteInspeccion.setTiorigenalegacion(tramiteRecepcionRequerimiento.getOrigen());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteRecepcionRequerimiento.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteRecepcionRequerimiento.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.soltramexpService.procesarDocumentosTramite(tramiteComun);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite requerimientoAcreditacionRepresentacion
	 * 
	 * @param tramiteRequerimientoAcreditacionRepresentacion
	 *            TramiteRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramiteRequerimientoAcreditacionRepresentacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REQUERIMIENTO_ACREDITACION_REPRESENTACION);
		tramiteInspeccion.setTifechainicio(tramiteRequerimientoAcreditacionRepresentacion.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(
				tramiteRequerimientoAcreditacionRepresentacion.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteRequerimientoAcreditacionRepresentacion.getComentario());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteRequerimientoAcreditacionRepresentacion.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(
					tramiteRequerimientoAcreditacionRepresentacion.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		tramiteInspeccion.setTiorigenalegacion(tramiteRequerimientoAcreditacionRepresentacion.getOrigen());

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);

		}

		List<DocumentoExpediente> listDocumentoExpediente = new ArrayList<DocumentoExpediente>();
		if (tramiteRequerimientoAcreditacionRepresentacion.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.soltramexpService.controlDocumentosPendientesFirmaTramitar(tramiteComun,
						Y41bConstantes.TIPO_PROC_INSPECCIONES);
			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramiteInspeccion,
						Y41bConstantes.FASE_REQUERIMIENTO,
						Y41bConstantes.TRAMITE_INSPECCIONES_REQUERIMIENTO_ACREDITACION_REPRESENTACION);
			}
		}

		if (tramitar) {
			Intervinientes interviniente = new Intervinientes();
			interviniente.setIdExpediente(tramiteInspeccion.getTiatcodigo());

			if (Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO
					.equals(tramiteRequerimientoAcreditacionRepresentacion.getOrigen())) {

				interviniente.setTipoInterviniente(
						Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO);
				interviniente = this.intervinientesDao.findIntervinienteTipo(interviniente);

				if (interviniente == null) {
					throw new Y41bUDAException(
							"error.tramiteRecepcionAcreditacionRepresentacion.establecimientovisitado", true,
							new Exception());
				}
			} else if (Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTORESPONSABLE
					.equals(tramiteRequerimientoAcreditacionRepresentacion.getOrigen())) {

				interviniente.setTipoInterviniente(
						Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO);
				interviniente = this.intervinientesDao.findIntervinienteTipo(interviniente);

				if (interviniente == null) {
					throw new Y41bUDAException(
							"error.tramiteRecepcionAcreditacionRepresentacion.establecimientoresponsable", true,
							new Exception());
				}
			}

			// Generar notificacion al reclamado
			this.generarTramiteNotificacionAutomaticoReqAcreditacionRepresentacion(
					tramiteRequerimientoAcreditacionRepresentacion, tramiteComun);

			// Generar recepcion informacion
			this.generarTramiteRecInformacionAutomaticoReqAcreditacionRepresentacion(tramiteInspeccion, tramiteComun);
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;

	}

	/**
	 * Guardar el tramite anulacionPropuestaSancion
	 * 
	 * @param TramiteAnulacionPropuestaSancion
	 *            TramiteAnulacionPropuestaSancion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteAnulacionPropuestaSancion(
			TramiteAnulacionPropuestaSancion tramiteAnulacionPropuestaSancion, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ANULACION_PROPUESTA_INSPECCION);
		tramiteInspeccion.setTifechainicio(tramiteAnulacionPropuestaSancion.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(tramiteAnulacionPropuestaSancion.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteAnulacionPropuestaSancion.getComentario());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteAnulacionPropuestaSancion.getFechaFin());
			tramiteInspeccion
					.setTicomoejecucion(tramiteAnulacionPropuestaSancion.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		tramiteInspeccion.setTiorigenalegacion(tramiteAnulacionPropuestaSancion.getOrigen());

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);

		}

		if (tramitar) {

			if (Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO
					.equals(tramiteAnulacionPropuestaSancion.getOrigen())) {

				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

				List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

				if (listIntervinientes != null && listIntervinientes.size() > 0) {

					Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
					sanpropbandeja.setBaprsanexcodigo(tramiteComun.getIdExpediente());
					sanpropbandeja.setBaprsansancionado(listIntervinientes.get(0).getEscodigo());

					if (this.sanpropbandejaService.findAllCount(sanpropbandeja) > 0) {
						this.sanpropbandejaService.removeInspecciones(sanpropbandeja);
					} else {
						throw new Y41bUDAException("error.tramiteAnulacionPropuestaSancion.propuestaSancion", true,
								new Exception());
					}
				} else {
					throw new Y41bUDAException("error.tramiteAnulacionPropuestaSancion.propuestaSancion", true,
							new Exception());
				}

			} else if (Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTORESPONSABLE
					.equals(tramiteAnulacionPropuestaSancion.getOrigen())) {
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);

				List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

				if (listIntervinientes != null && listIntervinientes.size() > 0) {

					Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
					sanpropbandeja.setBaprsanexcodigo(tramiteComun.getIdExpediente());
					sanpropbandeja.setBaprsansancionado(listIntervinientes.get(0).getEscodigo());

					if (this.sanpropbandejaService.findAllCount(sanpropbandeja) > 0) {
						this.sanpropbandejaService.removeInspecciones(sanpropbandeja);
					} else {
						throw new Y41bUDAException("error.tramiteAnulacionPropuestaSancion.propuestaSancion", true,
								new Exception());
					}
				} else {
					throw new Y41bUDAException("error.tramiteAnulacionPropuestaSancion.propuestaSancion", true,
							new Exception());
				}

			}
		}

		return tramiteInspeccion;

	}

	/**
	 * Guardar el tramite Recepcion Requerimiento Acreditacion Representacion
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ACREDITACION_REPRESENTACION);
		tramiteInspeccion.setTifechainicio(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(
				tramiteRecepcionRequerimientoAcreditacionRepresentacion.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getComentario());

		tramiteInspeccion
				.setTiresumenrecepcion(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getResumenAlegaciones());
		tramiteInspeccion
				.setTirespuestarecepcion(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getRespuesta());
		tramiteInspeccion.setTiorigenalegacion(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getOrigen());

		if (tramitar) {

			// Si la respuesta es 'Valido', se busca un representante de origen
			// no valido y se le pone a 'Valido'. Si no encuentra representante,
			// se devuelve un mensaje de error.
			if (Y41bConstantes.RESPUESTA_ACREDITACION_VALIDO
					.equals(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getRespuesta())) {
				Intervinientes interviniente = new Intervinientes();
				interviniente.setIdExpediente(tramiteInspeccion.getTiatcodigo());

				Intervinientes intervinienteAux = new Intervinientes();
				intervinienteAux.setIdExpediente(tramiteInspeccion.getTiatcodigo());

				if (Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO
						.equals(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getOrigen())) {

					// 0183585: Acreditacin de representacin
					intervinienteAux.setTipoInterviniente(
							Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO);
					intervinienteAux = this.intervinientesDao.findIntervinienteTipo(intervinienteAux);
					if (intervinienteAux != null) {
					} else {
						interviniente.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO);
						interviniente = this.intervinientesDao.findIntervinienteTipo(interviniente);

						if (interviniente == null) {
							throw new Y41bUDAException(
									"error.tramiteRecepcionAcreditacionRepresentacion.establecimientovisitado", true,
									new Exception());
						}

						interviniente.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO);
					}

				} else if (Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTORESPONSABLE
						.equals(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getOrigen())) {

					// 0183585: Acreditacin de representacin
					intervinienteAux.setTipoInterviniente(
							Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE);
					intervinienteAux = this.intervinientesDao.findIntervinienteTipo(intervinienteAux);
					if (intervinienteAux != null) {
					} else {
						interviniente.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO);
						interviniente = this.intervinientesDao.findIntervinienteTipo(interviniente);

						if (interviniente == null) {
							throw new Y41bUDAException(
									"error.tramiteRecepcionAcreditacionRepresentacion.establecimientoresponsable", true,
									new Exception());
						}

						interviniente.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE);
					}

				}

				this.intervinientesDao.updateTipoInterviniente(interviniente);
			}

			tramiteInspeccion.setTifechafin(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(
					tramiteRecepcionRequerimientoAcreditacionRepresentacion.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);

		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.soltramexpService.procesarDocumentosTramite(tramiteComun);

		// Actualizamos todos los documentos con el origen recibido por
		// parametro
		this.actualizarOrigenDocsTramiteAlegacion(tramiteComun,
				tramiteRecepcionRequerimientoAcreditacionRepresentacion.getOrigen());

		if (tramitar) {

			if (Y41bConstantes.RESPUESTA_ACREDITACION_VALIDO
					.equals(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getRespuesta())) {
				if (Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO
						.equals(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getOrigen())) {

					Actuacion actuacion = new Actuacion();
					actuacion.setAtcodigo(tramiteComun.getIdExpediente());
					actuacion = this.actuacionDao.findByActa(actuacion);

					// Actualizamos la participacoion del establecimiento
					// visitado
					if (actuacion != null && actuacion.getAtenplatea() != null
							&& actuacion.getAtenplatea().equals(Y41bConstantes.VALOR_SI)) {
						tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(actuacion.getAtcodigo());

						this.actualizarParticipacionEstablecimientoVisitado(tramiteComunAux);
					}
				} else if (Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTORESPONSABLE
						.equals(tramiteRecepcionRequerimientoAcreditacionRepresentacion.getOrigen())) {

					Actuacion actuacion = new Actuacion();
					actuacion.setAtcodigo(tramiteComun.getIdExpediente());
					actuacion = this.actuacionDao.findByActa(actuacion);

					// Actualizamos la participacoion del establecimiento
					// responsable
					if (actuacion != null && actuacion.getAtparticipacionresponsable() != null
							&& actuacion.getAtparticipacionresponsable().equals(Y41bConstantes.VALOR_SI)) {
						tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(actuacion.getAtcodigo());

						this.actualizarParticipacionEstablecimientoResponsable(tramiteComunAux);
					}
				}
			}
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite Recepcion Requerimiento
	 * 
	 * @param tramiteResolucionAIP
	 *            TramiteResolucionAIPInformacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteResolucionAIP(TramiteINSResolucionAIP tramiteResolucionAIP,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RESOLUCION_ACUERDO_INICIO_PROCEDIMIENTO);

		tramiteInspeccion.setTifechainicio(tramiteResolucionAIP.getFechaInicio());
		// tramiteInspeccion.setTiaccodigo(tramiteResolucionAIP.getAccodigo());
		tramiteInspeccion.setTicomoasignado(tramiteResolucionAIP.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteResolucionAIP.getComentario());

		tramiteInspeccion.setTifechadesin(tramiteResolucionAIP.getTifechadesin());

		tramiteInspeccion.setTidestinodesin(tramiteResolucionAIP.getTidestinodesin());

		tramiteInspeccion.setTidestruccioninsitu(tramiteResolucionAIP.getTidestruccioninsitu());

		tramiteInspeccion.setTinumrecupe(tramiteResolucionAIP.getRecuperadas());

		if (Y41bUtils.isFilled(tramiteResolucionAIP.getAdesinmovilizar())) {
			tramiteInspeccion.setTinumdesin(tramiteResolucionAIP.getAdesinmovilizar());
		} else {
			tramiteInspeccion.setTinumdesin("0");
		}

		tramiteInspeccion.setTifechaaip(tramiteResolucionAIP.getTifechaaip());
		tramiteInspeccion.setTiarchivar(tramiteResolucionAIP.getTiarchivar());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteResolucionAIP.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteResolucionAIP.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}
		List<DocumentoExpediente> listDocumentoExpediente = new ArrayList<DocumentoExpediente>();
		if (tramiteResolucionAIP.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.soltramexpService.controlDocumentosPendientesFirmaTramitar(tramiteComun,
						Y41bConstantes.TIPO_PROC_INSPECCIONES);
			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramiteInspeccion,
						Y41bConstantes.FASE_REQUERIMIENTO,
						Y41bConstantes.TRAMITE_INSPECCIONES_RESOLUCION_ACUERDO_INICIO_PROCEDIMIENTO);
			}
		}

		if (tramitar) {

			// Si NO viene de una Revision para Inclusion en red de alerta...
			TramiteInspeccion tramiteInspeccionInclusionRedAlerta = new TramiteInspeccion();
			tramiteInspeccionInclusionRedAlerta
					.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REVISION_INCLUSION_EN_RED_DE_ALERTA);
			tramiteInspeccionInclusionRedAlerta.setTiaccodigo(tramiteResolucionAIP.getAccodigo());
			Long total = this.tramiteInspeccionDao.findAllCount(tramiteInspeccionInclusionRedAlerta);

			// Generar notificacion
			this.generarTramiteNotificacionResolucionAIP(tramiteResolucionAIP, tramiteComun);

			if (total == 0) {
				TramiteComun tramiteComunAux = new TramiteComun();
				tramiteComunAux.setAccodigo(tramiteResolucionAIP.getAccodigo());
				tramiteComunAux.setIdExpediente(tramiteComun.getIdExpediente());

				// Generar un tramite dado segun su destino.
				if (Y41bConstantes.DESTINO_LABORATORIO.equals(tramiteResolucionAIP.getTidestinodesin())) {

					TramiteInspeccion tramiteInspeccionRemision = new TramiteInspeccion();
					//
					// ActaNueva actaNueva = new ActaNueva();
					// actaNueva.setAncodigo(tramiteResolucionAIP.getAccodigo());
					// actaNueva = this.actaNuevaDao.find(actaNueva);
					//
					// tramiteInspeccionRemision.setTiancodigo(actaNueva
					// .getAncodac());
					tramiteInspeccionRemision.setTicodmuestra("");

					this.generarTramiteRemisionMuestrasAlLaboratorio(tramiteInspeccionRemision, tramiteComunAux);

				} else if (Y41bConstantes.DESTINO_DESTRUCCION.equals(tramiteResolucionAIP.getTidestinodesin())) {
					TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
					tramiteInspeccionDetalle.setAtcodigo(tramiteComun.getIdExpediente());
					tramiteInspeccionDetalle
							.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION);
					tramiteInspeccionDetalle = this.tramiteInspeccionDao
							.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteInspeccionDetalle);

					if (tramiteInspeccionDetalle == null
							|| !Y41bUtils.isFilled(tramiteInspeccionDetalle.getTicodigo())) {
						this.generarTramiteAutomatico(tramiteComunAux,
								Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION);
					}

				} else if (Y41bConstantes.DESTINO_DEVOLUCION.equals(tramiteResolucionAIP.getTidestinodesin())) {
					this.generarTramiteAutomatico(tramiteComunAux,
							Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_JUSTIFICANTE_DE_DEVOLUCION);
				}
			}

			// Actualizar contadores libre comercializacin
			// si no venimos de una red de alerta
			if (tramiteResolucionAIP.getTidestinodesin() != null) {
				Actuacion actuacion = new Actuacion();
				actuacion.setAtcodigo(tramiteComun.getIdExpediente());
				actuacion = this.actuacionDao.find(actuacion);

				// Si el destino es libre comercializacin, se suma las unidades
				// a libre comercializacin.
				if (tramiteResolucionAIP.getTidestinodesin() != null && tramiteResolucionAIP.getTidestinodesin()
						.equalsIgnoreCase(Y41bConstantes.DESTINO_LIBRE_COMERCIALIZACION)) {

					if (actuacion.getAtulibrecomercializacion() != null) {
						actuacion.setAtulibrecomercializacion(actuacion.getAtulibrecomercializacion()
								.add(new BigDecimal(tramiteResolucionAIP.getAdesinmovilizar() != null
										? tramiteResolucionAIP.getAdesinmovilizar() : "0")));
					} else {
						actuacion.setAtulibrecomercializacion(
								new BigDecimal(tramiteResolucionAIP.getAdesinmovilizar() != null
										? tramiteResolucionAIP.getAdesinmovilizar() : "0"));
					}

				}

				// Si el destino es otros, se suma las unidades
				// a otros.
				if (tramiteResolucionAIP.getTidestinodesin() != null
						&& tramiteResolucionAIP.getTidestinodesin().equalsIgnoreCase(Y41bConstantes.DESTINO_OTROS)) {

					if (actuacion.getAtuotros() != null) {
						actuacion.setAtuotros(actuacion.getAtuotros()
								.add(new BigDecimal(tramiteResolucionAIP.getAdesinmovilizar() != null
										? tramiteResolucionAIP.getAdesinmovilizar() : "0")));
					} else {
						actuacion.setAtuotros(new BigDecimal(tramiteResolucionAIP.getAdesinmovilizar() != null
								? tramiteResolucionAIP.getAdesinmovilizar() : "0"));
					}

				}

				// Se actualizan las unidades recuperadas
				if (actuacion.getAturecuperadas() != null) {
					actuacion.setAturecuperadas(actuacion.getAturecuperadas()
							.add(new BigDecimal(tramiteResolucionAIP.getRecuperadas() != null
									? tramiteResolucionAIP.getRecuperadas() : "0")));

				} else {
					actuacion.setAturecuperadas(new BigDecimal(tramiteResolucionAIP.getRecuperadas() != null
							? tramiteResolucionAIP.getRecuperadas() : "0"));
				}

				// Se actualizan las unidades pendientes, sumando las
				// recuperadas
				if (actuacion.getAtupendientes() != null) {
					actuacion.setAtupendientes(actuacion.getAtupendientes()
							.add(new BigDecimal(tramiteResolucionAIP.getRecuperadas() != null
									? tramiteResolucionAIP.getRecuperadas() : "0")));

				} else {
					actuacion.setAtupendientes(new BigDecimal(tramiteResolucionAIP.getRecuperadas() != null
							? tramiteResolucionAIP.getRecuperadas() : "0"));
				}

				// Si el destino es libre comercializacin, se restan las
				// unidades a desinmovilizar.
				if (tramiteResolucionAIP.getTidestinodesin() != null && tramiteResolucionAIP.getTidestinodesin()
						.equalsIgnoreCase(Y41bConstantes.DESTINO_LIBRE_COMERCIALIZACION)) {
					actuacion.setAtupendientes(actuacion.getAtupendientes()
							.subtract(new BigDecimal(tramiteResolucionAIP.getAdesinmovilizar() != null
									? tramiteResolucionAIP.getAdesinmovilizar() : "0")));
				}

				// Si el destino es otros, se restan las
				// unidades a desinmovilizar.
				if (tramiteResolucionAIP.getTidestinodesin() != null
						&& tramiteResolucionAIP.getTidestinodesin().equalsIgnoreCase(Y41bConstantes.DESTINO_OTROS)) {
					actuacion.setAtupendientes(actuacion.getAtupendientes()
							.subtract(new BigDecimal(tramiteResolucionAIP.getAdesinmovilizar() != null
									? tramiteResolucionAIP.getAdesinmovilizar() : "0")));
				}

				actuacionDao.update(actuacion);

				int pendientes = Integer.parseInt(Y41bUtils.isFilled(tramiteResolucionAIP.getPendientes())
						? tramiteResolucionAIP.getPendientes().toString() : "0");

				int recuperadas = Integer.parseInt(Y41bUtils.isFilled(tramiteResolucionAIP.getRecuperadas())
						? tramiteResolucionAIP.getRecuperadas().toString() : "0");

				int desinmovilizar = Integer.parseInt(Y41bUtils.isFilled(tramiteResolucionAIP.getAdesinmovilizar())
						? tramiteResolucionAIP.getAdesinmovilizar().toString() : "0");

				if (pendientes + recuperadas > desinmovilizar) {

					TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
					tramiteInspeccionAux.setTicodigo(tramiteInspeccion.getTicodigo());

					tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);
					this.generarTramiteResolucionAIP(tramiteInspeccionAux.getTramiteInspeccion(), tramiteComun);
				}

			}

		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		if (tramitar) {
			CensoMonitor censoMonitor = tramiteResolucionAIP.getInstructorEjecucion();

			// revisar si es control mercado
			if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
					.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
				this.enviarEmailTramiteEjecutadoSSCC(tramiteComun.getIdExpediente(),
						Y41bConstantes.TRAMITE_INSPECCIONES_RESOLUCION_ACUERDO_INICIO_PROCEDIMIENTO);
			}
		}

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite relacion red alerta
	 * 
	 * @param tramiteINSEstablecimientoRelacionConRedAlerta
	 *            TramiteINSEstablecimientoRelacionConRedAlerta
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteEstablecimientoRelacionConRedAlerta(
			TramiteINSEstablecimientoRelacionConRedAlerta tramiteINSEstablecimientoRelacionConRedAlerta,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteINSEstablecimientoRelacionConRedAlerta.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteINSEstablecimientoRelacionConRedAlerta.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_RED_DE_ALERTA);

		tramiteinspeccion.setTifechainicio(tramiteINSEstablecimientoRelacionConRedAlerta.getFechaInicio());
		tramiteinspeccion.setTiaccodigo(tramiteINSEstablecimientoRelacionConRedAlerta.getAccodigo());
		tramiteinspeccion
				.setTicomoasignado(tramiteINSEstablecimientoRelacionConRedAlerta.getInstructorAsignado().getMocodigo());
		tramiteinspeccion.setTicomoejecucion(
				tramiteINSEstablecimientoRelacionConRedAlerta.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteINSEstablecimientoRelacionConRedAlerta.getComentario());

		tramiteinspeccion.setTicoalrel(tramiteINSEstablecimientoRelacionConRedAlerta.getRedAlerta());

		tramiteinspeccion.setTicocr(tramiteINSEstablecimientoRelacionConRedAlerta.getTicocr());

		if (tramitar) {
			tramiteinspeccion.setTifechafin(tramiteINSEstablecimientoRelacionConRedAlerta.getFechaFin());
			tramiteinspeccion.setTicomoejecucion(
					tramiteINSEstablecimientoRelacionConRedAlerta.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		// Validacion de un tramite en el expediente
		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTiatcodigo(tramiteINSEstablecimientoRelacionConRedAlerta.getIdExpediente());
		tramiteInspeccionAux.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_RED_DE_ALERTA);

		Long total = this.tramiteInspeccionDao.findAllCount(tramiteInspeccionAux);

		if (total > 1) {
			throw new Y41bUDAException("error.inspecciones.tramitaExistenteException", true, new Exception());
		}

		if (tramitar) {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcoalrelacionada(tramiteINSEstablecimientoRelacionConRedAlerta.getRedAlerta());
			actuacion.setAtcocrrelacionada(tramiteINSEstablecimientoRelacionConRedAlerta.getTicocr());
			actuacion.setAtcodigo(tramiteINSEstablecimientoRelacionConRedAlerta.getIdExpediente());

			this.actuacionDao.updateRelacionConAlerta(actuacion);
		}

		return tramiteinspeccion;
	}

	/**
	 * Guardar el tramite relacion campaa
	 * 
	 * @param tramiteINSEstablecimientoRelacionConCampana
	 *            TramiteINSEstablecimientoRelacionCampana
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteEstablecimientoRelacionConCampana(
			TramiteINSEstablecimientoRelacionConCampana tramiteINSEstablecimientoRelacionConCampana,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteINSEstablecimientoRelacionConCampana.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteINSEstablecimientoRelacionConCampana.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_CAMPANA);

		tramiteinspeccion.setTifechainicio(tramiteINSEstablecimientoRelacionConCampana.getFechaInicio());
		tramiteinspeccion
				.setTicomoasignado(tramiteINSEstablecimientoRelacionConCampana.getInstructorAsignado().getMocodigo());
		tramiteinspeccion
				.setTicomoejecucion(tramiteINSEstablecimientoRelacionConCampana.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteINSEstablecimientoRelacionConCampana.getComentario());

		tramiteinspeccion.setTicocmrel(tramiteINSEstablecimientoRelacionConCampana.getTicocm());

		tramiteinspeccion.setTicopg(tramiteINSEstablecimientoRelacionConCampana.getTicopg());

		if (tramitar) {
			tramiteinspeccion.setTifechafin(tramiteINSEstablecimientoRelacionConCampana.getFechaFin());
			tramiteinspeccion.setTicomoejecucion(
					tramiteINSEstablecimientoRelacionConCampana.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		// Validacion de un tramite en el expediente
		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTiatcodigo(tramiteINSEstablecimientoRelacionConCampana.getIdExpediente());
		tramiteInspeccionAux.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_CAMPANA);

		Long total = this.tramiteInspeccionDao.findAllCount(tramiteInspeccionAux);

		if (total > 1) {
			throw new Y41bUDAException("error.inspecciones.tramitaExistenteException", true, new Exception());
		}

		if (tramitar) {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcocmrelacionada(tramiteINSEstablecimientoRelacionConCampana.getTicocm());
			actuacion.setAtcopgrelacionada(tramiteINSEstablecimientoRelacionConCampana.getTicopg());
			actuacion.setAtcodigo(tramiteINSEstablecimientoRelacionConCampana.getIdExpediente());

			this.actuacionDao.updateRelacionConCampana(actuacion);
		}

		return tramiteinspeccion;
	}

	/**
	 * Guardar el tramite red de alerta
	 * 
	 * @param tramiteINSRevisionInclusionRedAlerta
	 *            TramiteINSRevisionInclusionRedAlerta
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRevisionInclusionRedAlerta(
			TramiteINSRevisionInclusionRedAlerta tramiteINSRevisionInclusionRedAlerta, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteINSRevisionInclusionRedAlerta.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteINSRevisionInclusionRedAlerta.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REVISION_INCLUSION_EN_RED_DE_ALERTA);

		tramiteinspeccion.setTifechainicio(tramiteINSRevisionInclusionRedAlerta.getFechaInicio());
		tramiteinspeccion.setTiaccodigo(tramiteINSRevisionInclusionRedAlerta.getAccodigo());
		tramiteinspeccion.setTicomoasignado(tramiteINSRevisionInclusionRedAlerta.getInstructorAsignado().getMocodigo());
		tramiteinspeccion
				.setTicomoejecucion(tramiteINSRevisionInclusionRedAlerta.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteINSRevisionInclusionRedAlerta.getComentario());

		tramiteinspeccion.setTiinclusiredalerta(tramiteINSRevisionInclusionRedAlerta.getInclusion());
		tramiteinspeccion.setTimotivoredalerta(tramiteINSRevisionInclusionRedAlerta.getMotivo());
		tramiteinspeccion.setTifecharedalerta(tramiteINSRevisionInclusionRedAlerta.getFechaRedAlerta());
		tramiteinspeccion.setTiancodigo(tramiteINSRevisionInclusionRedAlerta.getActa());

		if (tramitar) {
			tramiteinspeccion.setTifechafin(tramiteINSRevisionInclusionRedAlerta.getFechaFin());
			tramiteinspeccion
					.setTicomoejecucion(tramiteINSRevisionInclusionRedAlerta.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		if (tramitar) {
			// genera siguiente tramite en funcion de la inclusion
			if (tramiteINSRevisionInclusionRedAlerta.getInclusion().equals(Y41bConstantes.VALOR_SI)) {
				// Si no existe un tramite de acuerdo de inicio de procedimiento
				// con inclusion en red de alerta.
				Actuacion actuacion = new Actuacion();
				actuacion.setAtcodigo(tramiteINSRevisionInclusionRedAlerta.getIdExpediente());

				if (!this.existeAcuerdoInicioProcedimiento(actuacion)) {
					TramiteINSAcuerdoInicioProcedimiento tramiteAcuerdoInicioProcedimiento = new TramiteINSAcuerdoInicioProcedimiento();
					tramiteAcuerdoInicioProcedimiento
							.setIdExpediente(tramiteINSRevisionInclusionRedAlerta.getIdExpediente());
					tramiteAcuerdoInicioProcedimiento
							.setCodigoTramiteRelacionado(tramiteINSRevisionInclusionRedAlerta.getIdTramite());
					tramiteAcuerdoInicioProcedimiento
							.setInstructorAsignado(tramiteINSRevisionInclusionRedAlerta.getInstructorAsignado());

					this.generarTramiteAcuerdoInicioProcedimiento(tramiteAcuerdoInicioProcedimiento);
				}
			} else {
				// tramite de registro de decision.
				TramiteRegistroDecision tramiteRegistroDecision = new TramiteRegistroDecision();
				tramiteRegistroDecision.setComentario(tramiteINSRevisionInclusionRedAlerta.getMotivo());
				tramiteRegistroDecision.setFechaInicio(new Date());
				// tramiteRegistroDecision
				// .setAccodigo(tramiteINSRevisionInclusionRedAlerta
				// .getAccodigo());

				TramiteComun tramiteComunAux = new TramiteComun();
				tramiteComunAux.setIdExpediente(tramiteINSRevisionInclusionRedAlerta.getIdExpediente());
				tramiteComunAux.setIdTramite(tramiteINSRevisionInclusionRedAlerta.getIdTramite());
				TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
				tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				tramiteComunAux.setTipoProcedimiento(tipoProcedimiento);
				this.generarTramiteRegistroDecision(tramiteRegistroDecision, tramiteComunAux);
			}

		}

		return tramiteinspeccion;
	}

	/**
	 * Guardar el tramite cierre
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteCierre(TramiteCierre tramiteCierre, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteCierre.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteCierre.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE);

		tramiteinspeccion.setTifechainicio(tramiteCierre.getFechaInicio());
		// tramiteinspeccion.setTiaccodigo(tramiteCierre.getAccodigo());
		tramiteinspeccion.setTicomoasignado(tramiteCierre.getInstructorAsignado().getMocodigo());
		tramiteinspeccion.setTicomoejecucion(tramiteCierre.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteCierre.getComentario());

		tramiteinspeccion.setTifechacierre(tramiteCierre.getFechaCierre());

		tramiteinspeccion.setTiexcluircierre(tramiteCierre.getExcluirCierre());

		if (tramitar) {
			tramiteinspeccion.setTifechafin(tramiteCierre.getFechaFin());
			tramiteinspeccion.setTicomoejecucion(tramiteCierre.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		// 2.1 Se comprueba que no haya ningun tramite de cierre
		boolean isTramiteCierre = tramiteInspeccionService.existenMasTramites(tramiteCierre.getIdExpediente(),
				tramiteCierre.getIdTramite(), Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE);
		if (isTramiteCierre) {
			throw new Y41bUDAException("error.tramiteCierre.existeCierre", true, null);
		}

		if (tramitar) {
			// buscar el tramite de decision
			TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
			tramiteInspeccionDetalle.setAtcodigo(tramiteCierre.getIdExpediente());

			Long tramiteRegistroDecisionTramitado = this.tramiteInspeccionDao
					.findAllTramiteRegistroDecisionTramitadoCount(tramiteInspeccionDetalle);

			if (tramiteRegistroDecisionTramitado == 0) {
				throw new Y41bUDAException("error.tramiteDecision.sinTramitar", true, null);
			}
		} else {
			// Caso especial en el tratamiento del ultimo tramite del expediente
			this.actualizarUltimoTramiteCierreGuardar(tramiteCierre.getIdExpediente());
		}

		if (tramitar) {
			// 4. Cerramos el expediente en PLATEA
			// Obtengo la informacion del expediente

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());
			actuacion = this.actuacionDao.find(actuacion);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-")
					.append(actuacion.getActa().getAccoor()).append("-").append(actuacion.getActa().getAcnror())
					.append("-").append(actuacion.getActa().getAcnran()).append("-").append(actuacion.getAtnror());

			this.actuacionDao.updateFechaCierre(actuacion);

			if (actuacion != null && actuacion.getAtenplatea() != null
					&& actuacion.getAtenplatea().equals(Y41bConstantes.VALOR_SI)) {
				CierreExpediente cierreExpediente = new CierreExpediente();
				Procedure procedure = new Procedure();
				procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
				cierreExpediente.setProcedure(procedure);
				cierreExpediente.setNumeroExpediente(numeroExpediente.toString());
				cierreExpediente.setEjercicio(actuacion.getActa().getAcnran().toString());

				y41bPlateaAdapterService.cerrarExpediente(cierreExpediente);
			}
		}

		return tramiteinspeccion;
	}

	/**
	 * Guardar tramite generico
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteGenerico(TramiteGenerico tramiteGenerico, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_GENERICO);

		tramiteinspeccion.setTifechainicio(tramiteGenerico.getFechaInicio());
		// tramiteinspeccion.setTiaccodigo(tramiteGenerico.getAccodigo());
		tramiteinspeccion.setTicomoasignado(tramiteGenerico.getInstructorAsignado().getMocodigo());
		tramiteinspeccion.setTicomoejecucion(tramiteGenerico.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteGenerico.getComentario());

		tramiteinspeccion.setTinombretramite(tramiteGenerico.getNombreTramite());

		if (tramitar) {
			tramiteinspeccion.setTifechafin(tramiteGenerico.getFechaFin());
			tramiteinspeccion.setTicomoejecucion(tramiteGenerico.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		this.soltramexpService.procesarDocumentosTramite(tramiteComun);

		return tramiteinspeccion;
	}

	/**
	 * Generar tramite generico
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param literalNombreTramite
	 *            String
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteGenericoAutomatico(TramiteGenerico tramiteGenerico, String literalNombreTramite)
			throws Exception {
		return this.addTramiteGenericoAutomatico(tramiteGenerico, literalNombreTramite, null);
	}

	/**
	 * Generar tramite generico
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param literalNombreTramite
	 *            String
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteGenericoAutomatico(TramiteGenerico tramiteGenerico, String literalNombreTramite,
			String cadenaAdicional) throws Exception {
		try {
			TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
			tramiteinspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramiteinspeccion.setTiatcodigo(tramiteGenerico.getIdExpediente());
			tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_GENERICO);

			tramiteinspeccion.setTifechainicio(new Date());

			String instructor = null;
			if (null != tramiteGenerico.getInstructorAsignado()) {
				instructor = tramiteGenerico.getInstructorAsignado().getMocodigo();
			}

			tramiteinspeccion.setTicomoasignado(instructor);

			tramiteinspeccion.setTicomentario(tramiteGenerico.getComentario());

			StringBuffer nombreTramite = new StringBuffer();
			nombreTramite.append(
					appMessageSource.getMessage(literalNombreTramite, null, new Locale(Y41bConstantes.CASTELLANO)));
			nombreTramite.append(" / ");
			nombreTramite.append(
					appMessageSource.getMessage(literalNombreTramite, null, new Locale(Y41bConstantes.EUSKERA)));
			if (cadenaAdicional != null) {
				nombreTramite.append(" (").append(cadenaAdicional).append(")");
			}

			tramiteinspeccion.setTinombretramite(nombreTramite.toString());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			tramiteinspeccion.setTiautomatico(Y41bConstantes.VALOR_SI);

			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);

			return tramiteinspeccion;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Guardar tramite comunicacion
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param tipoComunicacion
	 *            tipo de comunicacion
	 * @param idZipFile
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, String tipoComunicacion, String idZipFile,
			CensoMonitor censoMonitor) throws Exception {

		if (tramitar) {
			if (Y41bConstantes.VALOR_SI.equals(tramiteComunicacion.getSede())) {
				this.soltramexpService.validarSiExisteSede(tramiteComunicacion.getDestinatario());
			}

			if (tipoComunicacion != null
					&& tipoComunicacion.equals(Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO)) {
				if (censoMonitor != null && (censoMonitor.getMocoem() == null || censoMonitor.getMocoem().equals(""))) {
					throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, new Exception());
				}
			}
		}

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION);

		tramiteInspeccion.setTifechainicio(tramiteComunicacion.getFechaInicio());
		tramiteInspeccion.setTiaccodigo(tramiteComunicacion.getAccodigo());
		tramiteInspeccion.setTicomoasignado(tramiteComunicacion.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteComunicacion.getComentario());

		// Remesas Ini
		tramiteInspeccion.setTienvrem(tramiteComunicacion.getEnvRemesaComunicacion());
		tramiteInspeccion.setTicodrem(tramiteComunicacion.getIdRemesaComunicacion());
		// Remesas Fin

		tramiteInspeccion.setTifechacomunicacion(tramiteComunicacion.getFechaComunicacion());
		tramiteInspeccion.setTiiddestinatario(tramiteComunicacion.getDestinatario());
		tramiteInspeccion.setTisede(tramiteComunicacion.getSede());
		tramiteInspeccion.setTitipocomunicacion(tipoComunicacion);
		tramiteInspeccion.setTifecharegistrosalida(tramiteComunicacion.getFechasalida());
		tramiteInspeccion.setTinumregistrosalida(tramiteComunicacion.getNumregistrosalida());
		tramiteInspeccion.setTiasuntocomunicacion(tramiteComunicacion.getAsuntoComunicacion());
		tramiteInspeccion.setTitextocomunicacion(tramiteComunicacion.getTextoComunicacion());

		tramiteInspeccion.setTiidmailorigen(tramiteComunicacion.getIdmailorigen());
		tramiteInspeccion.setTimailorigen(tramiteComunicacion.getMailorigen());
		tramiteInspeccion.setTiidmaildestino(tramiteComunicacion.getIdmaildestino());
		tramiteInspeccion.setTimaildestino(tramiteComunicacion.getMaildestino());

		if (tramitar) {
			if (tramiteInspeccion.getTitipocomunicacion() != null && tramiteInspeccion.getTitipocomunicacion()
					.equals(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO)) {
				tramiteInspeccion = this.obtenerRegistrosalidaComunicacionNotificacion(tramiteInspeccion, tramiteComun);
			}

			tramiteInspeccion.setTifechafin(tramiteComunicacion.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteComunicacion.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteComunicacion.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			// Recupero de la tabla temporal la lista de documentos del
			// expediente
			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
			List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			// Obtenemos los documentos del tramite
			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			if (tramitar) {
				if (tramiteInspeccion.getTitipocomunicacion() != null && tramiteInspeccion.getTitipocomunicacion()
						.equals(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO)) {
					this.procesarComunicacionNotificacionOrdinaria(listadjuntardocs, listDocumentoHecho,
							tramiteInspeccion, tramiteComun, idZipFile);
				} else if (tramiteInspeccion.getTitipocomunicacion() != null && tramiteInspeccion
						.getTitipocomunicacion().equals(Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO)) {
					// Mando el email
					boolean enviadoOk = this.envioEmailComunicacion(tramiteComunicacion, tramiteComun, listadjuntardocs,
							censoMonitor);
					if (!enviadoOk) {
						throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
					}
				} else if (tramiteInspeccion.getTitipocomunicacion() != null && tramiteInspeccion
						.getTitipocomunicacion().equals(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA)) {
					this.procesarComunicacionElectronica(listDocumentoHecho, tramiteComunicacion, tramiteInspeccion,
							censoMonitor);
				}
			} else {
				this.soltramexpService.guardarDocumentosDokusiTramiteComunicacionNotificacion(listDocumentoHecho,
						tramiteComun, Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
				/******************************************/
			}
		}

		if (tramitar) {
			this.tratamientoComunicacion(tramiteInspeccion, tramiteComun);
		} else {
			this.calcularEstadoTramiteGenerado(tramiteInspeccion);
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar tramite Valoracion de inspeccion
	 * 
	 * @param tramiteValoracionInspeccion
	 *            TramiteINSValoracionInspeccion
	 * @param tramiteComun
	 *            TramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteValoracionInspeccion(TramiteINSValoracionInspeccion tramiteValoracionInspeccion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_INFORME_VALORACION);

		tramiteinspeccion.setTifechainicio(tramiteValoracionInspeccion.getFechaInicio());
		// tramiteinspeccion.setTiaccodigo(tramiteValoracionInspeccion
		// .getAccodigo());
		tramiteinspeccion.setTicomoasignado(tramiteValoracionInspeccion.getInstructorAsignado().getMocodigo());
		tramiteinspeccion.setTicomoejecucion(tramiteValoracionInspeccion.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteValoracionInspeccion.getComentario());

		tramiteinspeccion.setTivaloracion(tramiteValoracionInspeccion.getValoracionInspeccion());

		if (tramitar) {
			tramiteinspeccion.setTifechafin(tramiteValoracionInspeccion.getFechaFin());
			tramiteinspeccion.setTicomoejecucion(tramiteValoracionInspeccion.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}
		this.soltramexpService.procesarDocumentosTramite(tramiteComun);

		if (tramitar) {
			// Validacion: Debe haber almenos 1 documento
			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}

			// Si el origen es una solicitud, generar en ella un tramite de
			// Recepcion de inpeccion.
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());
			actuacion = this.actuacionDao.find(actuacion);

			if (actuacion.getAtcohd() != null) {
				TramiteHecho tramiteRecepcionInspeccion = new TramiteHecho();
				TramiteComun tramiteComunAux = new TramiteComun();

				tramiteComunAux.setIdExpediente(actuacion.getAtcohd());
				tramiteRecepcionInspeccion.setEhfechainicio(new Date());
				tramiteRecepcionInspeccion.setEhfecha(new Date());

				String numExpediente = actuacion.getActa().getAccoor() + "-" + actuacion.getActa().getAcnror() + "-"
						+ actuacion.getActa().getAcnran() + "-" + actuacion.getAtnror();

				tramiteRecepcionInspeccion.setEhcodins(numExpediente);
				tramiteRecepcionInspeccion.setEhresumenins(tramiteValoracionInspeccion.getValoracionInspeccion());
				tramiteRecepcionInspeccion.setEhcoactua(actuacion.getAtcodigo());

				List<DocumentoHecho> listaDocumentos = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
						null);

				this.soltramexpService.generarTramiteRecepcionInspeccion(tramiteRecepcionInspeccion, tramiteComunAux,
						listaDocumentos);
			}
		}

		return tramiteinspeccion;
	}

	/**
	 * Guardar tramite Ampliacion de inspeccion
	 * 
	 * @param tramiteAmpliacionInspeccion
	 *            TramiteINSAmpliacionInspeccion
	 * @param tramiteComun
	 *            TramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteAmpliacionInspeccion(TramiteINSAmpliacionInspeccion tramiteAmpliacionInspeccion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_SOLICITUD_AMPLIACION_DE_INSPECCION);

		tramiteinspeccion.setTifechainicio(tramiteAmpliacionInspeccion.getFechaInicio());
		// tramiteinspeccion.setTiaccodigo(tramiteAmpliacionInspeccion
		// .getAccodigo());
		tramiteinspeccion.setTicomoasignado(tramiteAmpliacionInspeccion.getInstructorAsignado().getMocodigo());
		tramiteinspeccion.setTicomoejecucion(tramiteAmpliacionInspeccion.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteAmpliacionInspeccion.getComentario());

		tramiteinspeccion.setTimotivoampli(tramiteAmpliacionInspeccion.getMotivoAmpliacion());
		tramiteinspeccion.setTifechaampli(tramiteAmpliacionInspeccion.getFechaAmpliacion());

		if (tramitar) {
			this.generarTramiteAutomatico(tramiteComun, Y41bConstantes.TRAMITE_INSPECCIONES_INFORME_VALORACION);

			tramiteinspeccion.setTifechafin(tramiteAmpliacionInspeccion.getFechaFin());
			tramiteinspeccion.setTicomoejecucion(tramiteAmpliacionInspeccion.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		return tramiteinspeccion;
	}

	/**
	 * Guardar tramite Aceptacion del Informe de Valoracion
	 * 
	 * @param tramiteAceptacionInformeValoracion
	 *            TramiteINSAceptacionInformeValoracion
	 * @param tramiteComun
	 *            TramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteAceptacionInformeValoracion(
			TramiteINSAceptacionInformeValoracion tramiteAceptacionInformeValoracion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ACEPTACION_INFORME_VALORACION);

		tramiteinspeccion.setTifechainicio(tramiteAceptacionInformeValoracion.getFechaInicio());
		// tramiteinspeccion.setTiaccodigo(tramiteAceptacionInformeValoracion
		// .getAccodigo());
		tramiteinspeccion.setTicomoasignado(tramiteAceptacionInformeValoracion.getInstructorAsignado().getMocodigo());
		tramiteinspeccion.setTicomoejecucion(tramiteAceptacionInformeValoracion.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteAceptacionInformeValoracion.getComentario());

		tramiteinspeccion.setTifechaaceptacion(tramiteAceptacionInformeValoracion.getFechaAceptacion());

		if (tramitar) {
			tramiteinspeccion.setTifechafin(tramiteAceptacionInformeValoracion.getFechaFin());
			tramiteinspeccion
					.setTicomoejecucion(tramiteAceptacionInformeValoracion.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		return tramiteinspeccion;
	}

	/**
	 * Guardar tramite Orden de Servicio
	 * 
	 * @param tramiteINSOrdenServicio
	 *            TramiteINSOrdenServicio
	 * @param tramiteComun
	 *            TramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteOrdenServicio(TramiteINSOrdenServicio tramiteINSOrdenServicio,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar, CensoMonitor censoMonitor)
			throws Exception {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ORDEN_SERVICIO);

		tramiteinspeccion.setTifechainicio(tramiteINSOrdenServicio.getFechaInicio());
		tramiteinspeccion.setTicomoasignado(tramiteINSOrdenServicio.getInstructorAsignado().getMocodigo());
		tramiteinspeccion.setTicomoejecucion(tramiteINSOrdenServicio.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteINSOrdenServicio.getComentario());

		if (tramitar) {
			tramiteinspeccion.setTifechafin(tramiteINSOrdenServicio.getFechaFin());
			tramiteinspeccion.setTicomoejecucion(tramiteINSOrdenServicio.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		soltramexpService.procesarDocumentosTramite(tramiteComun);

		if (!tramitar) {
			// revisar si es control mercado
			if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
					.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
				this.enviarEmailTramiteEjecutadoSSCC(tramiteComun.getIdExpediente(),
						Y41bConstantes.TRAMITE_INSPECCIONES_ORDEN_SERVICIO);
				// revisar si es coordinador
			} else if (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)) {
				this.enviarEmailTramiteEjecutadoCoordinador(tramiteComun.getIdExpediente(),
						Y41bConstantes.TRAMITE_INSPECCIONES_ORDEN_SERVICIO, censoMonitor);
			}
		}

		return tramiteinspeccion;
	}

	/**
	 * Guardar tramite certificado de destruccin
	 * 
	 * @param tramiteINSRecepcionCertificadoDestruccion
	 *            TramiteINSRecepcionCertificadoDestruccion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRecepcionCertificadoDestruccion(
			TramiteINSRecepcionCertificadoDestruccion tramiteINSRecepcionCertificadoDestruccion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
		adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocsFilter.setThidtipodoc(Y41bConstantes.TIPO_DOC_CERTIFICADO);
		Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

		if (total == 0) {
			throw new Y41bUDAException("error.inspecciones.documentoCertificadoDestruccionException", true,
					new Exception());
		}

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION);

		tramiteinspeccion.setTifechainicio(tramiteINSRecepcionCertificadoDestruccion.getFechaInicio());
		tramiteinspeccion.setTiaccodigo(tramiteINSRecepcionCertificadoDestruccion.getAccodigo());
		tramiteinspeccion
				.setTicomoasignado(tramiteINSRecepcionCertificadoDestruccion.getInstructorAsignado().getMocodigo());
		tramiteinspeccion
				.setTicomoejecucion(tramiteINSRecepcionCertificadoDestruccion.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteINSRecepcionCertificadoDestruccion.getComentario());

		tramiteinspeccion.setTiempresagest(tramiteINSRecepcionCertificadoDestruccion.getTiempresagest());

		tramiteinspeccion.setTinumrecupe(tramiteINSRecepcionCertificadoDestruccion.getTinumrecupe());

		tramiteinspeccion.setTinumadestruir(tramiteINSRecepcionCertificadoDestruccion.getTinumadestruir());

		if (tramitar) {
			tramiteinspeccion.setTifechafin(tramiteINSRecepcionCertificadoDestruccion.getFechaFin());
			tramiteinspeccion.setTicomoejecucion(
					tramiteINSRecepcionCertificadoDestruccion.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		soltramexpService.procesarDocumentosTramite(tramiteComun);

		if (tramitar) {
			// Validacion: Debe haber almenos 1 documento
			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}

			// Actualizar contadores
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());
			actuacion = actuacionDao.find(actuacion);

			// Se suman las unidades destruidas
			if (actuacion.getAtudestruidas() != null) {
				actuacion.setAtudestruidas(actuacion.getAtudestruidas()
						.add(new BigDecimal(tramiteINSRecepcionCertificadoDestruccion.getTinumadestruir() != null
								? tramiteINSRecepcionCertificadoDestruccion.getTinumadestruir() : "0")));
			} else {
				actuacion.setAtudestruidas(
						new BigDecimal(tramiteINSRecepcionCertificadoDestruccion.getTinumadestruir() != null
								? tramiteINSRecepcionCertificadoDestruccion.getTinumadestruir() : "0"));
			}

			// Se actualizan las unidades recuperadas
			if (actuacion.getAturecuperadas() != null) {
				actuacion.setAturecuperadas(actuacion.getAturecuperadas()
						.add(new BigDecimal(tramiteINSRecepcionCertificadoDestruccion.getTinumrecupe() != null
								? tramiteINSRecepcionCertificadoDestruccion.getTinumrecupe() : "0")));

			} else {
				actuacion.setAturecuperadas(
						new BigDecimal(tramiteINSRecepcionCertificadoDestruccion.getTinumrecupe() != null
								? tramiteINSRecepcionCertificadoDestruccion.getTinumrecupe() : "0"));
			}

			// Se actualizan las unidades pendientes
			if (actuacion.getAtupendientes() != null) {
				actuacion.setAtupendientes(actuacion.getAtupendientes()
						.add(new BigDecimal(tramiteINSRecepcionCertificadoDestruccion.getTinumrecupe() != null
								? tramiteINSRecepcionCertificadoDestruccion.getTinumrecupe() : "0")));

			} else {
				actuacion.setAtupendientes(
						new BigDecimal(tramiteINSRecepcionCertificadoDestruccion.getTinumrecupe() != null
								? tramiteINSRecepcionCertificadoDestruccion.getTinumrecupe() : "0"));
			}

			// Se actualizan las unidades pendientes, restando las unidades
			// destruidas
			actuacion.setAtupendientes(actuacion.getAtupendientes()
					.subtract(new BigDecimal(tramiteINSRecepcionCertificadoDestruccion.getTinumadestruir() != null
							? tramiteINSRecepcionCertificadoDestruccion.getTinumadestruir() : "0")));

			actuacionDao.update(actuacion);
		}

		return tramiteinspeccion;
	}

	/**
	 * Guardar tramite certificado de destruccin
	 * 
	 * @param tramiteINSRecepcionJustificanteDevolucion
	 *            TramiteINSRecepcionJustificanteDevolucion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRecepcionJustificanteDevolucion(
			TramiteINSRecepcionJustificanteDevolucion tramiteINSRecepcionJustificanteDevolucion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
		adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocsFilter.setThidtipodoc(Y41bConstantes.TIPO_DOC_JUSTIFICANTE);
		Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

		if (total == 0) {
			throw new Y41bUDAException("error.inspecciones.documentoJustificanteDevolucionException", true,
					new Exception());
		}

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_JUSTIFICANTE_DE_DEVOLUCION);

		tramiteinspeccion.setTifechainicio(tramiteINSRecepcionJustificanteDevolucion.getFechaInicio());
		tramiteinspeccion.setTiaccodigo(tramiteINSRecepcionJustificanteDevolucion.getAccodigo());
		tramiteinspeccion
				.setTicomoasignado(tramiteINSRecepcionJustificanteDevolucion.getInstructorAsignado().getMocodigo());
		tramiteinspeccion
				.setTicomoejecucion(tramiteINSRecepcionJustificanteDevolucion.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteINSRecepcionJustificanteDevolucion.getComentario());

		tramiteinspeccion.setTiempresagest(tramiteINSRecepcionJustificanteDevolucion.getTiempresagest());

		tramiteinspeccion.setTinumrecupe(tramiteINSRecepcionJustificanteDevolucion.getTinumrecupe());

		tramiteinspeccion.setTinumadevolver(tramiteINSRecepcionJustificanteDevolucion.getTinumadevolver());

		if (tramitar) {

			tramiteinspeccion.setTifechafin(tramiteINSRecepcionJustificanteDevolucion.getFechaFin());
			tramiteinspeccion.setTicomoejecucion(
					tramiteINSRecepcionJustificanteDevolucion.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		soltramexpService.procesarDocumentosTramite(tramiteComun);

		if (tramitar) {
			// Validacion: Debe haber almenos 1 documento
			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}

			// Actualizar contadores
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());
			actuacion = actuacionDao.find(actuacion);

			// Se actualizan las unidades devueltas
			if (actuacion.getAtudevolucionorigen() != null) {
				actuacion.setAtudevolucionorigen(actuacion.getAtudevolucionorigen()
						.add(new BigDecimal(tramiteINSRecepcionJustificanteDevolucion.getTinumadevolver() != null
								? tramiteINSRecepcionJustificanteDevolucion.getTinumadevolver() : "0")));
			} else {
				actuacion.setAtudevolucionorigen(
						new BigDecimal(tramiteINSRecepcionJustificanteDevolucion.getTinumadevolver() != null
								? tramiteINSRecepcionJustificanteDevolucion.getTinumadevolver() : "0"));
			}

			// Se actualizan las unidades recuperadas
			if (actuacion.getAturecuperadas() != null) {
				actuacion.setAturecuperadas(actuacion.getAturecuperadas()
						.add(new BigDecimal(tramiteINSRecepcionJustificanteDevolucion.getTinumrecupe() != null
								? tramiteINSRecepcionJustificanteDevolucion.getTinumrecupe() : "0")));

			} else {
				actuacion.setAturecuperadas(
						new BigDecimal(tramiteINSRecepcionJustificanteDevolucion.getTinumrecupe() != null
								? tramiteINSRecepcionJustificanteDevolucion.getTinumrecupe() : "0"));
			}

			// Se actualizan las unidades pendientes
			if (actuacion.getAtupendientes() != null) {
				actuacion.setAtupendientes(actuacion.getAtupendientes()
						.add(new BigDecimal(tramiteINSRecepcionJustificanteDevolucion.getTinumrecupe() != null
								? tramiteINSRecepcionJustificanteDevolucion.getTinumrecupe() : "0")));

			} else {
				actuacion.setAtupendientes(
						new BigDecimal(tramiteINSRecepcionJustificanteDevolucion.getTinumrecupe() != null
								? tramiteINSRecepcionJustificanteDevolucion.getTinumrecupe() : "0"));
			}

			// Se actualizan las unidades pendientes, restando las unidades
			// pendientes
			actuacion.setAtupendientes(actuacion.getAtupendientes()
					.subtract(new BigDecimal(tramiteINSRecepcionJustificanteDevolucion.getTinumadevolver() != null
							? tramiteINSRecepcionJustificanteDevolucion.getTinumadevolver() : "0")));

			actuacionDao.update(actuacion);
		}

		return tramiteinspeccion;
	}

	/**
	 * Guardar tramite notificacion
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param tipoNotificacion
	 *            tipo de notificacion
	 * @param idZipFile
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteNotificacion(TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, String tipoNotificacion, String idZipFile,
			CensoMonitor censoMonitor) throws Exception {

		if (tramitar) {
			if (Y41bConstantes.VALOR_SI.equals(tramiteNotificacion.getSede())) {
				this.soltramexpService.validarSiExisteSede(tramiteNotificacion.getDestinatario());
			}
		}

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);

		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTicomoasignado(tramiteNotificacion.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteNotificacion.getComentario());

		// Remesas Ini
		tramiteInspeccion.setTienvrem(tramiteNotificacion.getEnvRemesaNotificacion());
		tramiteInspeccion.setTicodrem(tramiteNotificacion.getIdRemesaNotificacion());
		// Remesas Fin

		tramiteInspeccion.setTifechacomunicacion(tramiteNotificacion.getFechaComunicacion());
		tramiteInspeccion.setTiiddestinatario(tramiteNotificacion.getDestinatario());
		tramiteInspeccion.setTisede(tramiteNotificacion.getSede());
		tramiteInspeccion.setTitiponotificacion(tipoNotificacion);
		tramiteInspeccion.setTitiponotificacionplatea(tramiteNotificacion.getTipoNotificacionPlatea());
		tramiteInspeccion.setTifecharegistrosalida(tramiteNotificacion.getFechasalida());
		tramiteInspeccion.setTinumregistrosalida(tramiteNotificacion.getNumregistrosalida());
		tramiteInspeccion.setTitextocomunicacion(tramiteNotificacion.getTextoComunicacion());
		tramiteInspeccion.setTinotificacionporacta(tramiteNotificacion.getNotificacionPorActa());
		tramiteInspeccion.setTiaccodigo(tramiteNotificacion.getAccodigo());

		if (tramitar) {
			if (tramiteInspeccion.getTitiponotificacion() != null
					&& tramiteInspeccion.getTitiponotificacion().equals(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA)) {
				tramiteInspeccion = this.obtenerRegistrosalidaComunicacionNotificacion(tramiteInspeccion, tramiteComun);
			}

			tramiteInspeccion.setTifechafin(tramiteNotificacion.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteNotificacion.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteNotificacion.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			// Recupero de la tabla temporal la lista de documentos del
			// expediente
			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
			List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			/******************************************/
			// Obtenemos los documentos del tramite
			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			if (tramitar) {
				if (tramiteInspeccion.getTitiponotificacion() != null && tramiteInspeccion.getTitiponotificacion()
						.equals(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA)) {
					this.procesarComunicacionNotificacionOrdinaria(listadjuntardocs, listDocumentoHecho,
							tramiteInspeccion, tramiteComun, idZipFile);

					// Se genera el tramite de acuse de recibo vinculado al
					// tramite de notificacion.
					String idEspera = null;
					this.generarTramiteAcuseReciboAutomatico(idEspera, tramiteInspeccion, tramiteComun);

				} else if (tramiteInspeccion.getTitiponotificacion() != null && tramiteInspeccion
						.getTitiponotificacion().equals(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA)) {
					this.procesarNotificacionElectronica(listDocumentoHecho, tramiteNotificacion, tramiteInspeccion,
							tramiteComun, censoMonitor);
				}
			} else {
				this.soltramexpService.guardarDocumentosDokusiTramiteComunicacionNotificacion(listDocumentoHecho,
						tramiteComun, Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
			}
		}

		if (tramitar) {
			// Si el tramite padre es un Acuerdo Inicio Procedimiento, genera un
			// tramite de Resolucion AIP. Si es un tramite de Resolucion AIP,
			// genera un Registro de decision si no existe uno ya.
			TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
			tramiteInspeccionAux.setTicodigo(tramiteInspeccion.getTicodigo());

			tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);

			if (tramiteInspeccionAux.getTramiteInspeccion() != null
					&& tramiteInspeccionAux.getTramiteInspeccion().getTicodigo() != null) {
				TramiteInspeccion tramiteInspeccionAux2 = new TramiteInspeccion();
				tramiteInspeccionAux2.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());

				tramiteInspeccionAux2 = this.tramiteInspeccionDao.find(tramiteInspeccionAux2);
				if (Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO
						.equals(tramiteInspeccionAux2.getTicotee())) {
					this.generarTramiteResolucionAIP(tramiteInspeccion, tramiteComun);
				} else if (Y41bConstantes.TRAMITE_INSPECCIONES_RESOLUCION_ACUERDO_INICIO_PROCEDIMIENTO
						.equals(tramiteInspeccionAux2.getTicotee())) {
					// Si en el tramite de Revision para inclusion en red de
					// alerta se indica una inclusion en red de alerta, genera
					// un Establecer relacion con red de alerta.
					TramiteInspeccion tramiteInspeccionAux3 = new TramiteInspeccion();
					tramiteInspeccionAux3.setTiatcodigo(tramiteComun.getIdExpediente());
					tramiteInspeccionAux3
							.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REVISION_INCLUSION_EN_RED_DE_ALERTA);
					tramiteInspeccionAux3.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
					tramiteInspeccionAux3.setTiinclusiredalerta(Y41bConstantes.VALOR_SI);

					Long total = this.tramiteInspeccionDao.findAllCount(tramiteInspeccionAux3);

					if (total > 0) {
						// Genera tramite de Registro de decision.
						TramiteInspeccion tramiteInspeccionAuxAlerta = new TramiteInspeccion();
						tramiteInspeccionAuxAlerta.setTiatcodigo(tramiteComun.getIdExpediente());
						tramiteInspeccionAuxAlerta.setTicotee(
								Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_RED_DE_ALERTA);

						total = this.tramiteInspeccionDao.findAllCount(tramiteInspeccionAuxAlerta);

						if (total == 0) {
							this.generarTramiteAutomatico(tramiteComun,
									Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_RED_DE_ALERTA);
						}
					}

					// Genera tramite de Registro de decision.
					TramiteInspeccion tramiteInspeccionAux4 = new TramiteInspeccion();
					tramiteInspeccionAux4.setTiatcodigo(tramiteComun.getIdExpediente());
					tramiteInspeccionAux4.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ARCHIVO_AIP);

					total = this.tramiteInspeccionDao.findAllCount(tramiteInspeccionAux4);

					if (total == 0) {

						if (Y41bConstantes.VALOR_SI.equals(tramiteInspeccionAux2.getTiarchivar())) {
							TramiteComun tramiteComunAux = new TramiteComun();
							tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
							tramiteComunAux.setIdExpediente(tramiteComun.getIdExpediente());
							TramiteINSArchivoAIP tramiteINSArchivoAIP = new TramiteINSArchivoAIP();
							tramiteINSArchivoAIP.setFechaInicio(new Date());

							// Se genera el tramite archivo aip tramitado
							this.generarTramiteArchivoAIP(tramiteINSArchivoAIP, tramiteComunAux, true);
						} else {
							TramiteComun tramiteComunAux = new TramiteComun();
							tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
							tramiteComunAux.setIdExpediente(tramiteComun.getIdExpediente());
							TramiteINSArchivoAIP tramiteINSArchivoAIP = new TramiteINSArchivoAIP();
							tramiteINSArchivoAIP.setFechaInicio(new Date());

							// Se genera el tramite archivo aip pendiente de
							// tramitar
							this.generarTramiteArchivoAIP(tramiteINSArchivoAIP, tramiteComunAux, false);
						}
					}
				}
			}
		} else {
			this.calcularEstadoTramiteGenerado(tramiteInspeccion);
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite acuse de recibo
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param docHechoPEE
	 *            DocumentoHecho
	 * @param esRemesa
	 *            boolean
	 * @param reintento
	 *            boolean
	 * @return Inspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, DocumentoHecho docHechoPEE, boolean esRemesa,
			boolean reintento) throws Exception {
		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTicodigo(tramiteComun.getIdTramite());

		tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);

		if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTiestadotramite() != null
				&& !tramiteInspeccionAux.getTiestadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
			TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
			tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
			tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO);

			tramiteInspeccion.setTifechainicio(tramiteAcuseRecibo.getFechaInicio());
			// tramiteInspeccion.setTiaccodigo(tramiteAcuseRecibo.getAccodigo());
			tramiteInspeccion.setTicomoasignado(tramiteAcuseRecibo.getInstructorAsignado().getMocodigo());
			tramiteInspeccion.setTicomentario(tramiteAcuseRecibo.getComentario());

			// Info de Acuse recibo ini
			tramiteInspeccion.setTiacuserecibo(tramiteAcuseRecibo.getFechaacuse());
			tramiteInspeccion.setTiacusereciborecibido(tramiteAcuseRecibo.getSituacionacuse());
			tramiteInspeccion.setTifecharegistroentrada(tramiteAcuseRecibo.getFechaentrada());
			tramiteInspeccion.setTinumregistroentrada(tramiteAcuseRecibo.getNumregistroentrada());
			// Info de Acuse recibo fin

			if (tramitar) {
				tramiteInspeccion.setTifechafin(tramiteAcuseRecibo.getFechaFin());
				tramiteInspeccion.setTicomoejecucion(tramiteAcuseRecibo.getInstructorEjecucion().getMocodigo());
				tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			} else {
				tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			}

			if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
				// Se inserta el tramite
				this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
			} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
				this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
			}

			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			List<DocumentoExpediente> listDocumentoExpediente = null;
			if (esRemesa) {
				if (docHechoPEE != null) {
					this.documentoHechoDao.add(docHechoPEE);

					DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setEhcodigo(tramiteComun.getIdTramite());
					documentoTramiteHecho.setCodocumento(docHechoPEE.getQ5codocumento());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			} else {
				if (tramiteAcuseRecibo.getAnyadirPlantilla() == null) {
					listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

					this.soltramexpService.procesarDocumentosTramite(tramiteComun);
				}
			}

			// Se actualiza el origen de la lista de documentos del tramite
			// dependiendo del destinatario de la notificacion
			this.actualizarOrigenDocsTramiteAcuseRecibo(tramiteComun,
					tramiteAcuseRecibo.getTramiteNotificacion().getDestinatario());

			if (tramitar) {
				this.tratamientoMisGestionesAcuseRecibo(tramiteInspeccion);
			}

			// Eliminamos los documentos de dokusi
			if (listDocumentoExpediente != null) {
				this.eliminarDocumentosDokusi(listDocumentoExpediente);
			}

			if (reintento) {
				// actualizar el campo del tramite de acuse a TIACUSEREINTENTADO
				// a S
				tramiteInspeccion.setTiacusereintentado(Y41bConstantes.SI);
				this.tramiteInspeccionDao.updateAcuseReintentado(tramiteInspeccion);

				// generar la notificacin
				tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccion);

				this.generarReintentoTramiteNotificacion(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
			}

			return tramiteInspeccion;
		} else {

			if (reintento) {
				// actualizar el campo del tramite de acuse a TIACUSEREINTENTADO
				// a S
				tramiteInspeccionAux.setTiacusereintentado(Y41bConstantes.SI);
				this.tramiteInspeccionDao.updateAcuseReintentado(tramiteInspeccionAux);

				// generar la notificacin
				this.generarReintentoTramiteNotificacion(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
			}

			return tramiteInspeccionAux;
		}
	}

	/**
	 * Guardar el tramite BOPVAyto
	 * 
	 * @param tramiteBOPVAyto
	 *            TramiteBOPVAyto
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteBOPVAyto(TramiteBOPVAyto tramiteBOPVAyto, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_INFORMACION_PUBLICACION_BOPV_BOE);

		tramiteinspeccion.setTifechainicio(tramiteBOPVAyto.getFechaInicio());
		// tramiteinspeccion.setTiaccodigo(tramiteBOPVAyto.getAccodigo());
		tramiteinspeccion.setTicomoasignado(tramiteBOPVAyto.getInstructorAsignado().getMocodigo());
		tramiteinspeccion.setTicomoejecucion(tramiteBOPVAyto.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteBOPVAyto.getComentario());

		tramiteinspeccion.setTifechapublicacionbopv(tramiteBOPVAyto.getFechaPublicacionBOPV());
		tramiteinspeccion.setTifechapublicacionayto(tramiteBOPVAyto.getFechaPublicacionAyto());
		tramiteinspeccion.setTifechaenviobopvboe(tramiteBOPVAyto.getFechaEnvioBOPVBOE());

		if (tramitar) {
			tramiteinspeccion.setTifechafin(tramiteBOPVAyto.getFechaFin());
			tramiteinspeccion.setTicomoejecucion(tramiteBOPVAyto.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteBOPVAyto.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				soltramexpService.controlDocumentosPendientesFirmaTramitar(tramiteComun,
						Y41bConstantes.TIPO_PROC_INSPECCIONES);
			} else {
				// Llamamos a un metodo que recorrera la lista de documentos
				// del tramite y actualizara la bandeja de firma
				// En este caso, al ser un tramite generico le metemos la
				// fase del expediente
				// SolicitudDetalle solicitudDetalleAux = new
				// SolicitudDetalle();
				// solicitudDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());
				// solicitudDetalleAux = this.hechoDenunciadoDao
				// .findSolicitud(solicitudDetalleAux);
				// String faseExp = solicitudDetalleAux.getFcodigo();

				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramiteinspeccion, null,
						Y41bConstantes.TRAMITE_INSPECCIONES_INFORMACION_PUBLICACION_BOPV_BOE);
			}
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteinspeccion;
	}

	/**
	 * Guardar el tramite Elaboracion BOPV
	 * 
	 * @param tramiteElaboracionBOPVAyto
	 *            TramiteElaboracionBOPVAyto
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteElaboracionBOPVAyto(TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAyto,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteinspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteinspeccion
				.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ELABORACION_DOCUMENTACION_PARA_PUBLICACION_BOPV_BOE);

		tramiteinspeccion.setTifechainicio(tramiteElaboracionBOPVAyto.getFechaInicio());
		// tramiteinspeccion.setTiaccodigo(tramiteElaboracionBOPVAyto
		// .getAccodigo());
		tramiteinspeccion.setTicomoasignado(tramiteElaboracionBOPVAyto.getInstructorAsignado().getMocodigo());
		tramiteinspeccion.setTicomoejecucion(tramiteElaboracionBOPVAyto.getInstructorEjecucion().getMocodigo());
		tramiteinspeccion.setTicomentario(tramiteElaboracionBOPVAyto.getComentario());

		if (tramitar) {
			tramiteinspeccion.setTifechafin(tramiteElaboracionBOPVAyto.getFechaFin());
			tramiteinspeccion.setTicomoejecucion(tramiteElaboracionBOPVAyto.getInstructorEjecucion().getMocodigo());
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteinspeccion);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteElaboracionBOPVAyto.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);
		}

		if (tramitar) {
			this.generarTramiteBOPV_AYTO(tramiteComun);
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteinspeccion;
	}

	/**
	 * Guardar el tramite Desinmovilizacion
	 * 
	 * @param tramiteDesinmovilizacion
	 *            TramiteDesinmovilizacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteDesinmovilizacion(TramiteINSDesinmovilizacion tramiteDesinmovilizacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_DESINMOVILIZACION);

		tramiteInspeccion.setTifechainicio(tramiteDesinmovilizacion.getFechaInicio());
		tramiteInspeccion.setTiaccodigo(tramiteDesinmovilizacion.getAccodigo());
		tramiteInspeccion.setTicomoasignado(tramiteDesinmovilizacion.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteDesinmovilizacion.getComentario());

		tramiteInspeccion.setTifechadesin(tramiteDesinmovilizacion.getTifechadesin());

		tramiteInspeccion.setTidestinodesin(tramiteDesinmovilizacion.getTidestinodesin());

		tramiteInspeccion.setTidestruccioninsitu(tramiteDesinmovilizacion.getTidestruccioninsitu());

		tramiteInspeccion.setTinumrecupe(tramiteDesinmovilizacion.getRecuperadas());

		tramiteInspeccion.setTinumdesin(tramiteDesinmovilizacion.getAdesinmovilizar());

		tramiteInspeccion.setTifechaaip(tramiteDesinmovilizacion.getTifechaaip());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteDesinmovilizacion.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteDesinmovilizacion.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {

			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteDesinmovilizacion.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);
		}

		if (tramitar) {

			// Si existe el tramite de Desinmovilizacion asignado al mismo acta,
			// lo elimina.
			TramiteInspeccion tramiteInspeccionElim = new TramiteInspeccion();
			tramiteInspeccionElim.setTiatcodigo(tramiteComun.getIdExpediente());
			tramiteInspeccionElim.setTiaccodigo(tramiteDesinmovilizacion.getAccodigo());
			tramiteInspeccionElim.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);
			List<TramiteInspeccion> listaTramitesBorrar = this.tramiteInspeccionDao
					.findAllTramitesPendientesPorTipo(tramiteInspeccionElim, null);
			for (TramiteInspeccion tramiteBorrar : listaTramitesBorrar) {
				this.tramiteInspeccionDao.remove(tramiteBorrar);
			}

			// Generar notificacion
			this.generarTramiteNotificacionPorActaDesinmovilizacion(tramiteDesinmovilizacion, tramiteComun);

			// Actualizar contadores
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());
			actuacion = this.actuacionDao.find(actuacion);

			// Se actualizan las unidades recuperadas
			if (actuacion.getAturecuperadas() != null) {
				actuacion.setAturecuperadas(actuacion.getAturecuperadas()
						.add(new BigDecimal(tramiteDesinmovilizacion.getRecuperadas() != null
								? tramiteDesinmovilizacion.getRecuperadas() : "0")));

			} else {
				actuacion.setAturecuperadas(new BigDecimal(tramiteDesinmovilizacion.getRecuperadas() != null
						? tramiteDesinmovilizacion.getRecuperadas() : "0"));
			}

			// Se actualizan las unidades pendientes, sumando las recuperadas
			if (actuacion.getAtupendientes() != null) {
				actuacion.setAtupendientes(actuacion.getAtupendientes()
						.add(new BigDecimal(tramiteDesinmovilizacion.getRecuperadas() != null
								? tramiteDesinmovilizacion.getRecuperadas() : "0")));

			} else {
				actuacion.setAtupendientes(new BigDecimal(tramiteDesinmovilizacion.getRecuperadas() != null
						? tramiteDesinmovilizacion.getRecuperadas() : "0"));
			}

			if (tramiteDesinmovilizacion.getTidestinodesin()
					.equalsIgnoreCase(Y41bConstantes.DESTINO_LIBRE_COMERCIALIZACION)) {

				// Si el destino es libre comercializacin, se suma las unidades
				// a libre comercializacin.
				if (actuacion.getAtulibrecomercializacion() != null) {
					actuacion.setAtulibrecomercializacion(actuacion.getAtulibrecomercializacion()
							.add(new BigDecimal(tramiteDesinmovilizacion.getAdesinmovilizar() != null
									? tramiteDesinmovilizacion.getAdesinmovilizar() : "0")));
				} else {
					actuacion.setAtulibrecomercializacion(
							new BigDecimal(tramiteDesinmovilizacion.getAdesinmovilizar() != null
									? tramiteDesinmovilizacion.getAdesinmovilizar() : "0"));
				}
			}

			if (tramiteDesinmovilizacion.getTidestinodesin().equalsIgnoreCase(Y41bConstantes.DESTINO_OTROS)) {

				// Si el destino es otros, se suma las unidades
				// a otros.
				if (actuacion.getAtuotros() != null) {
					actuacion.setAtuotros(actuacion.getAtuotros()
							.add(new BigDecimal(tramiteDesinmovilizacion.getAdesinmovilizar() != null
									? tramiteDesinmovilizacion.getAdesinmovilizar() : "0")));
				} else {
					actuacion.setAtuotros(new BigDecimal(tramiteDesinmovilizacion.getAdesinmovilizar() != null
							? tramiteDesinmovilizacion.getAdesinmovilizar() : "0"));
				}
			}

			// Si el destino es libre comercializacin, se restan las unidades a
			// desinmovilizar.
			if (tramiteDesinmovilizacion.getTidestinodesin() != null && tramiteDesinmovilizacion.getTidestinodesin()
					.equalsIgnoreCase(Y41bConstantes.DESTINO_LIBRE_COMERCIALIZACION)) {
				actuacion.setAtupendientes(actuacion.getAtupendientes()
						.subtract(new BigDecimal(tramiteDesinmovilizacion.getAdesinmovilizar() != null
								? tramiteDesinmovilizacion.getAdesinmovilizar() : "0")));
			}

			// Si el destino es otros, se restan las unidades a
			// desinmovilizar.
			if (tramiteDesinmovilizacion.getTidestinodesin() != null
					&& tramiteDesinmovilizacion.getTidestinodesin().equalsIgnoreCase(Y41bConstantes.DESTINO_OTROS)) {
				actuacion.setAtupendientes(actuacion.getAtupendientes()
						.subtract(new BigDecimal(tramiteDesinmovilizacion.getAdesinmovilizar() != null
								? tramiteDesinmovilizacion.getAdesinmovilizar() : "0")));
			}

			actuacionDao.update(actuacion);

			int pendientes = Integer.parseInt(Y41bUtils.isFilled(tramiteDesinmovilizacion.getPendientes())
					? tramiteDesinmovilizacion.getPendientes().toString() : "0");

			int recuperadas = Integer.parseInt(Y41bUtils.isFilled(tramiteDesinmovilizacion.getRecuperadas())
					? tramiteDesinmovilizacion.getRecuperadas().toString() : "0");

			int desinmovilizar = Integer.parseInt(Y41bUtils.isFilled(tramiteDesinmovilizacion.getAdesinmovilizar())
					? tramiteDesinmovilizacion.getAdesinmovilizar().toString() : "0");

			// dependiendo del destino se generan diferentes tramites
			if (Y41bConstantes.DESTINO_DESTRUCCION.equals(tramiteDesinmovilizacion.getTidestinodesin())) {
				TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
				tramiteInspeccionDetalle.setAtcodigo(tramiteComun.getIdExpediente());
				tramiteInspeccionDetalle
						.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION);
				tramiteInspeccionDetalle = this.tramiteInspeccionDao
						.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteInspeccionDetalle);

				if (tramiteInspeccionDetalle == null || !Y41bUtils.isFilled(tramiteInspeccionDetalle.getTicodigo())) {

					if (pendientes > 0) {
						this.generarTramiteAutomatico(tramiteComun,
								Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION);
					}
				}
			} else if (Y41bConstantes.DESTINO_DEVOLUCION.equals(tramiteDesinmovilizacion.getTidestinodesin())) {
				this.generarTramiteAutomatico(tramiteComun,
						Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_JUSTIFICANTE_DE_DEVOLUCION);
			}

			if (pendientes + recuperadas > desinmovilizar) {
				this.generarTramiteDesinmovilizacion(null, tramiteComun);
				this.generarTramiteAcuerdoInicioProcedimiento(tramiteComun);
			}

		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite EmisionInforme
	 * 
	 * @param tramiteEmisionInforme
	 *            TramiteEmisionInforme
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteEmisionInforme(TramiteINSEmisionInforme tramiteEmisionInforme,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_EMISION_DE_INFORME);

		tramiteInspeccion.setTifechainicio(tramiteEmisionInforme.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(tramiteEmisionInforme.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteEmisionInforme.getComentario());

		// tramiteInspeccion.setTiaccodigo(tramiteEmisionInforme.getAccodigo());

		tramiteInspeccion.setTifechaemiinf(tramiteEmisionInforme.getTifechaemiinf());
		tramiteInspeccion.setTidniinf(tramiteEmisionInforme.getTidniinf());

		tramiteInspeccion.setTinombreinf(tramiteEmisionInforme.getTinombreinf());

		tramiteInspeccion.setTiencondicioninf(tramiteEmisionInforme.getTiencondicioninf());

		tramiteInspeccion.setTiinforme(tramiteEmisionInforme.getTiinforme());

		tramiteInspeccion.setTinombreCalle(tramiteEmisionInforme.getTinombreCalle());
		tramiteInspeccion.setTinombreCp(tramiteEmisionInforme.getTinombreCp());
		tramiteInspeccion.setTinoraMunicipioId(tramiteEmisionInforme.getTinoraMunicipioId());
		tramiteInspeccion.setTinoraPortalId(tramiteEmisionInforme.getTinoraPortalId());
		tramiteInspeccion.setTinoraProvinciaId(tramiteEmisionInforme.getTinoraProvinciaId());
		tramiteInspeccion.setTinoraCalleId(tramiteEmisionInforme.getTinoraCalleId());
		tramiteInspeccion.setTinoraLocalidadId(tramiteEmisionInforme.getTinoraLocalidadId());
		tramiteInspeccion.setTitelinf(tramiteEmisionInforme.getTitelinf());
		tramiteInspeccion.setTitelinf2(tramiteEmisionInforme.getTitelinf2());
		tramiteInspeccion.setTimaildestino(tramiteEmisionInforme.getTimaildestino());

		tramiteInspeccion.setTicompdireccion(tramiteEmisionInforme.getTicompdireccion());

		tramiteInspeccion.setTihorainicioemiinf(tramiteEmisionInforme.getTihorainicioemiinf());
		tramiteInspeccion.setTihorafininf(tramiteEmisionInforme.getTihorafininf());

		tramiteInspeccion.setTiape1inf(tramiteEmisionInforme.getTiape1inf());
		tramiteInspeccion.setTiape2inf(tramiteEmisionInforme.getTiape2inf());

		tramiteInspeccion.setTiligadoprotocolo(tramiteEmisionInforme.getTiligadoprotocolo());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteEmisionInforme.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteEmisionInforme.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteEmisionInforme.getAnyadirPlantilla() == null) {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsFilter.setThidtipodoc(Y41bConstantes.TIPO_DOC_INFORME);
			Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

			if (total == 0) {
				throw new Y41bUDAException("error.inspecciones.documentoInformeException", true, new Exception());
			}

			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite registro decision
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRegistroDecision(TramiteRegistroDecision tramiteRegistroDecision,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		if (tramitar) {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());

			InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

			if (inspeccionDetalle != null && inspeccionDetalle.getAttipo() != null
					&& (inspeccionDetalle.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR)
							|| inspeccionDetalle.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS))) {
				actuacion = new Actuacion();
				actuacion.setAtcodigo(tramiteComun.getIdExpediente());

				// contar las infracciones de protocolo
				Long numInfraccionesProtocolo = this.actaDao.findInfraccionesProtocoloCount(actuacion);

				/* CARACTER */
				// Buscar el caracter de campaa de la actuacion
				String caracterCampanha = "";
				Actuacion actuacionAux = this.actuacionDao.find(actuacion);
				if (actuacionAux.getAtcocm() != null) {
					Campanha campanha = new Campanha();
					campanha.setCmcodigo(actuacionAux.getAtcocm());
					campanha = this.campanhaDao.find(campanha);
					caracterCampanha = campanha.getCmcaracter();
				}

				// /////

				if (numInfraccionesProtocolo > 0
						&& (!caracterCampanha.equalsIgnoreCase(Y41bConstantes.CAMPANHA_CARACTER_PROSPECTIVA))
						&& (!caracterCampanha.equalsIgnoreCase(Y41bConstantes.CAMPANHA_CARACTER_INFORMATIVA))) {
					// Si hay infracciones contar acta de infraccion tramitada
					// ligado a protocolo

					ActaNueva actaNueva = new ActaNueva();
					actaNueva.setAncodins(tramiteComun.getIdExpediente());
					actaNueva.setAntipo(Y41bConstantes.ACTA_NUEVA_TIPO_INFRACCION);
					actaNueva.setAnligadoprotocolo(Y41bConstantes.VALOR_SI);

					Long numActaInfraccionProtocolo = this.actaNuevaDao
							.findAllActaInfraccionProtocoloTramitadaCount(actaNueva);

					if (numActaInfraccionProtocolo != null && numActaInfraccionProtocolo > 0) {
						// CORRECTO
					} else {
						throw new Y41bUDAException("error.inspecciones.registrodecisionactaException", true,
								new Exception());
					}

				} else {
					// si no hay infracciones contar tramite emision informe
					// tramitado
					// o acta infraccion tramitada
					// ligado a protocolo
					ActaNueva actaNueva = new ActaNueva();
					actaNueva.setAncodins(tramiteComun.getIdExpediente());
					// actaNueva.setAntipo(Y41bConstantes.ACTA_NUEVA_TIPO_INFRACCION);
					actaNueva.setAnligadoprotocolo(Y41bConstantes.VALOR_SI);

					Long numActaInfraccionProtocolo = this.actaNuevaDao
							.findAllActaInfraccionProtocoloTramitadaCount(actaNueva);

					TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
					tramiteInspeccionDetalle.setAtcodigo(tramiteComun.getIdExpediente());
					Long numEmisionInformeProtocolo = this.tramiteInspeccionDao
							.findAllTramiteEmisionInformeProtocoloTramitadoCount(tramiteInspeccionDetalle);

					if ((numActaInfraccionProtocolo != null && numActaInfraccionProtocolo > 0)
							|| (numEmisionInformeProtocolo != null && numEmisionInformeProtocolo > 0)) {
						// CORRECTO
					} else {
						throw new Y41bUDAException("error.inspecciones.registrodecisioninformeException", true,
								new Exception());
					}
				}
			}

			String codOrigenInspeccion = this.findCodOrigenInspeccionPorIdExpediente(tramiteComun.getIdExpediente());

			if (codOrigenInspeccion != null && (codOrigenInspeccion.equals(Y41bConstantes.INSPECCIONES_ORIGEN_OFICIO)
					|| codOrigenInspeccion.equals(Y41bConstantes.INSPECCIONES_ORIGEN_COMUNICACION_EXTERNA)
					|| codOrigenInspeccion.equals(Y41bConstantes.INSPECCIONES_ORIGEN_NOTIFICACION_PRODUCTORES))) {

				actuacion = new Actuacion();
				actuacion.setAtcodigo(tramiteComun.getIdExpediente());

				// contar las infracciones de protocolo
				Long numInfraccionesProtocolo = this.actaDao.findInfraccionesProtocoloCount(actuacion);

				if (numInfraccionesProtocolo > 0) {
					// Si existen infracciones se validara que exista un acta o
					// un tramite de emision de informe ligado a protocolo.
					ActaNueva actaNueva = new ActaNueva();
					actaNueva.setAncodins(tramiteComun.getIdExpediente());
					actaNueva.setAnligadoprotocolo(Y41bConstantes.VALOR_SI);

					Long numActaInfraccionProtocolo = this.actaNuevaDao
							.findAllActaInfraccionProtocoloTramitadaCount(actaNueva);

					TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
					tramiteInspeccionDetalle.setAtcodigo(tramiteComun.getIdExpediente());
					Long numEmisionInformeProtocolo = this.tramiteInspeccionDao
							.findAllTramiteEmisionInformeProtocoloTramitadoCount(tramiteInspeccionDetalle);

					if ((numActaInfraccionProtocolo != null && numActaInfraccionProtocolo > 0)
							|| (numEmisionInformeProtocolo != null && numEmisionInformeProtocolo > 0)) {
						// CORRECTO
					} else {
						throw new Y41bUDAException("error.inspecciones.registrodecisioninformeException", true,
								new Exception());
					}
				}

			}

			Intervinientes interviniente = new Intervinientes();
			interviniente.setIdExpediente(tramiteComun.getIdExpediente());

			if (Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTOVISITADO
					.equals(tramiteRegistroDecision.getTidestinatario())) {

				interviniente.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);
				interviniente = this.intervinientesDao.findIntervinienteTipo(interviniente);

				if (interviniente == null) {
					throw new Y41bUDAException("error.tramiteRegistroDecision.establecimientovisitado", true,
							new Exception());
				}
			} else if (Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTORESPONSABLE
					.equals(tramiteRegistroDecision.getTidestinatario())) {

				interviniente.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);
				interviniente = this.intervinientesDao.findIntervinienteTipo(interviniente);

				if (interviniente == null) {
					throw new Y41bUDAException("error.tramiteRegistroDecision.establecimientoresponsable", true,
							new Exception());
				}
			}

			// Validacion si existe un resultado de ensayo pendiente
			TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
			tramiteInspeccionDetalle.setAtcodigo(tramiteComun.getIdExpediente());

			Long total = this.tramiteInspeccionDao
					.findAllTramiteResultadoEnsayosNoTramitadoCount(tramiteInspeccionDetalle);

			if (total > 0) {
				throw new Y41bUDAException("error.tramiteRegistroDecision.resultadoEnsayoPendiente", true,
						new Exception());
			}
		}

		// INSPECCION
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION);

		tramiteInspeccion.setTifechainicio(tramiteRegistroDecision.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(tramiteRegistroDecision.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteRegistroDecision.getComentario());

		tramiteInspeccion.setTijustificacioninfraccion(tramiteRegistroDecision.getJustificacionInfraccion());
		tramiteInspeccion.setTicoortraspaso(tramiteRegistroDecision.getCodOrgTraslado());
		tramiteInspeccion.setTiancodigo(tramiteRegistroDecision.getAncodigo());
		tramiteInspeccion.setTidestinatario(tramiteRegistroDecision.getTidestinatario());

		// Acta
		// tramiteInspeccion.setTiaccodigo(tramiteRegistroDecision.getAccodigo());

		// Registro decision ini
		tramiteInspeccion.setTidecodigo(tramiteRegistroDecision.getTipoDecision());
		tramiteInspeccion.setTifecharesolucion(tramiteRegistroDecision.getFechaDecision());
		// Registro decision fin

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteRegistroDecision.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteRegistroDecision.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		this.actaInfraccionDao.removeAllInfracciones(tramiteComun);

		this.infraccHechoDenDao.addAllInfraccionesHechoAdjuntarInfraccionesControlMercado(tramiteComun);

		// //////////////////////////////////////////////////////////////////

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteRegistroDecision.getAnyadirPlantilla() == null) {

			this.adjunInfraccHechoDenunDao.removeAllAdjuntarInfracciones(tramiteComun);

			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.soltramexpService.controlDocumentosPendientesFirmaTramitar(tramiteComun,
						Y41bConstantes.TIPO_PROC_INSPECCIONES);

				this.tratamientoDecisionTraslado(tramiteRegistroDecision, tramiteComun);

				// Generamos tramites de notificacion automaticos
				this.generarTramiteNotificacionAutomaticoRegistroDecision(tramiteRegistroDecision, tramiteComun);

				this.tratamientoCierreDecision(tramiteComun);

				this.tratamientoModificacionDecision(tramiteRegistroDecision, tramiteComun);

				// Actualizamos la bandeja de propuestas de sancion (si el tipo
				// decision es una propuesta de sancion)

				if (Y41bConstantes.DECISION_INSPECCIONES_CON_PROPUESTA_DE_SANCION
						.equals(tramiteRegistroDecision.getTipoDecision())) {
					Actuacion actuacion = new Actuacion();
					actuacion.setAtcodigo(tramiteComun.getIdExpediente());

					InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

					if (inspeccionDetalle.getAtcohd() == null) {
						if (!this.existePropuestaSancionOExpedienteSancionador(tramiteComun,
								tramiteRegistroDecision.getTidestinatario())) {
							this.tratamientoBandejaPropuestaSancion(tramiteInspeccion);
						}
					}
				}

				// Actualizamos la Fecha Fin de la inspeccion.
				this.actualizarFechaFinInspeccion(tramiteComun.getIdExpediente(),
						tramiteRegistroDecision.getFechaDecision());

			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramiteInspeccion,
						Y41bConstantes.FASE_RESOLUCION, Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION);
			}
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		if (tramitar) {

			// Al tramitar el registro de decisin, se buscarn los tramites
			// IN25 (Informativos), IN06 (Recepcin de requerimiento) y IN31
			// (Recepcin de alegaciones), que estn sin tramitar y con fecha de
			// inicio del trmite anterior a la fecha de ejecucin del trmite
			// de registro de decisin, y se marcarn como tramitados con fecha
			// de ejecucin la misma que el registro de decisin y con usuario
			// de ejecucin el que est configurado en un nuevo parmetro de la
			// tabla de parmetros.
			List<TramiteInspeccion> listTramiteInspeccion = this.tramiteInspeccionDao
					.findAllTramiteInspeccionATramitarautomaticamente(tramiteInspeccion, null);
			if (listTramiteInspeccion != null && listTramiteInspeccion.size() > 0) {
				for (TramiteInspeccion tramiteInspeccionAux : listTramiteInspeccion) {
					tramiteInspeccionAux.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
					tramiteInspeccionAux.setTifechafin(tramiteInspeccion.getTifechafin());
					tramiteInspeccionAux.setTicomoejecucion(Y41bConstantes.CODIGO_USUARIO_SYS_CENSO_MONITOR);

					this.tramiteInspeccionDao.updateTramitarTramite(tramiteInspeccionAux);
				}
			}

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());

			InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

			if (Y41bConstantes.DECISION_INSPECCIONES_TRASLADO.equals(tramiteRegistroDecision.getTipoDecision())
					|| Y41bConstantes.DECISION_INSPECCIONES_CON_APERCIBIMIENTO
							.equals(tramiteRegistroDecision.getTipoDecision())
					|| Y41bConstantes.DECISION_INSPECCIONES_ARCHIVO_AIP
							.equals(tramiteRegistroDecision.getTipoDecision())
					|| Y41bConstantes.INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES
							.equals(inspeccionDetalle.getActiororigen())
					|| Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA
							.equals(inspeccionDetalle.getActiororigen())) {
				CensoMonitor censoMonitor = tramiteRegistroDecision.getInstructorEjecucion();

				// revisar si es control mercado
				if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
					this.enviarEmailTramiteEjecutadoSSCC(tramiteComun.getIdExpediente(),
							Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION);
				}
			}
		}

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite archivo AIP
	 * 
	 * @param tramiteINSArchivoAIP
	 *            TramiteINSArchivoAIP
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteArchivoAIP(TramiteINSArchivoAIP tramiteINSArchivoAIP, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {

		if (tramitar) {
			Intervinientes interviniente = new Intervinientes();
			interviniente.setIdExpediente(tramiteComun.getIdExpediente());

			if (Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTOVISITADO.equals(tramiteINSArchivoAIP.getTidestinatario())) {

				interviniente.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);
				interviniente = this.intervinientesDao.findIntervinienteTipo(interviniente);

				if (interviniente == null) {
					throw new Y41bUDAException("error.tramiteRegistroDecision.establecimientovisitado", true,
							new Exception());
				}
			} else if (Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTORESPONSABLE
					.equals(tramiteINSArchivoAIP.getTidestinatario())) {

				interviniente.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);
				interviniente = this.intervinientesDao.findIntervinienteTipo(interviniente);

				if (interviniente == null) {
					throw new Y41bUDAException("error.tramiteRegistroDecision.establecimientoresponsable", true,
							new Exception());
				}
			}

		}

		// INSPECCION
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ARCHIVO_AIP);

		tramiteInspeccion.setTifechainicio(tramiteINSArchivoAIP.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(tramiteINSArchivoAIP.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteINSArchivoAIP.getComentario());

		tramiteInspeccion.setTiancodigo(tramiteINSArchivoAIP.getAncodigo());
		tramiteInspeccion.setTidestinatario(tramiteINSArchivoAIP.getTidestinatario());

		// Registro decision ini
		tramiteInspeccion.setTidecodigo(tramiteINSArchivoAIP.getTipoDecision());
		tramiteInspeccion.setTifecharesolucion(tramiteINSArchivoAIP.getFechaDecision());
		// Registro decision fin

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteINSArchivoAIP.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteINSArchivoAIP.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		// //////////////////////////////////////////////////////////////////

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteINSArchivoAIP.getAnyadirPlantilla() == null) {

			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.soltramexpService.controlDocumentosPendientesFirmaTramitar(tramiteComun,
						Y41bConstantes.TIPO_PROC_INSPECCIONES);

				// Generamos tramites de notificacion automaticos
				this.generarTramiteNotificacionAutomaticoArchivoAIP(tramiteINSArchivoAIP, tramiteComun);

			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramiteInspeccion,
						Y41bConstantes.FASE_RESOLUCION, Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION);
			}
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		if (tramitar) {

			CensoMonitor censoMonitor = tramiteINSArchivoAIP.getInstructorEjecucion();

			// revisar si es control mercado
			if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
					.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
				this.enviarEmailTramiteEjecutadoSSCC(tramiteComun.getIdExpediente(),
						Y41bConstantes.TRAMITE_INSPECCIONES_ARCHIVO_AIP);
			}
		}

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite RemisionMuestrasAlLaboratorio
	 * 
	 * @param tramiteRemisionMuestrasAlLaboratorio
	 *            TramiteRemisionMuestrasAlLaboratorio
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRemisionMuestrasAlLaboratorio(
			TramiteINSRemisionMuestrasAlLaboratorio tramiteRemisionMuestrasAlLaboratorio, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REMISION_MUESTRAS_AL_LABORATORIO);

		tramiteInspeccion.setTifechainicio(tramiteRemisionMuestrasAlLaboratorio.getFechaInicio());
		tramiteInspeccion.setTiaccodigo(tramiteRemisionMuestrasAlLaboratorio.getAccodigo());
		tramiteInspeccion.setTicomoasignado(tramiteRemisionMuestrasAlLaboratorio.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteRemisionMuestrasAlLaboratorio.getComentario());

		tramiteInspeccion.setTifechaenvlab(tramiteRemisionMuestrasAlLaboratorio.getTifechaenvlab());
		tramiteInspeccion.setTicodmuestra(tramiteRemisionMuestrasAlLaboratorio.getTicodmuestra());
		tramiteInspeccion.setTilacodigo(tramiteRemisionMuestrasAlLaboratorio.getTilacodigo());
		tramiteInspeccion.setTidetana(tramiteRemisionMuestrasAlLaboratorio.getTidetana());
		tramiteInspeccion.setTiancodigo(tramiteRemisionMuestrasAlLaboratorio.getTiancodigo());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteRemisionMuestrasAlLaboratorio.getFechaFin());
			tramiteInspeccion
					.setTicomoejecucion(tramiteRemisionMuestrasAlLaboratorio.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {

			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		List<DocumentoExpediente> listDocumentoExpediente = new ArrayList<DocumentoExpediente>();
		if (tramiteRemisionMuestrasAlLaboratorio.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {

				this.soltramexpService.controlDocumentosPendientesFirmaTramitar(tramiteComun,
						Y41bConstantes.TIPO_PROC_INSPECCIONES);
				// se generan dos tramites automaticamente:
				TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
				tramiteInspeccionAux.setTiancodigo(tramiteRemisionMuestrasAlLaboratorio.getTiancodigo());
				tramiteInspeccionAux.setTiaccodigo(tramiteRemisionMuestrasAlLaboratorio.getAccodigo());
				tramiteInspeccionAux.setTilacodigo(tramiteRemisionMuestrasAlLaboratorio.getTilacodigo());
				tramiteInspeccionAux.setTicodmuestra(tramiteRemisionMuestrasAlLaboratorio.getTicodmuestra());

				Actuacion actuacionAux = new Actuacion();
				actuacionAux.setAtcodigo(tramiteComun.getIdExpediente());

				InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacionAux);

				if (inspeccionDetalle != null && inspeccionDetalle.getAttipo() != null
						&& inspeccionDetalle.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS)) {
					// Actualizar flag ATISTOMAMUESTRAS
					Actuacion actuacion = new Actuacion();
					actuacion.setAtcodigo(tramiteComun.getIdExpediente());
					this.actuacionDao.updateIsTOMAMUESTRAS(actuacion);
				}

				this.generarTramiteComunicacionRemisionMuestrasAlLaboratorio(tramiteRemisionMuestrasAlLaboratorio,
						tramiteComun);

				this.generarTramiteResultadoEnsayos(tramiteInspeccionAux, tramiteComun);
			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramiteInspeccion,
						Y41bConstantes.FASE_REQUERIMIENTO,
						Y41bConstantes.TRAMITE_INSPECCIONES_REMISION_MUESTRAS_AL_LABORATORIO);
			}
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite EnviarMuestraEmpresa
	 * 
	 * @param tramiteINSEnviarMuestraEmpresa
	 *            TramiteINSEnviarMuestraEmpresa
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteEnviarMuestraEmpresa(
			TramiteINSEnviarMuestraEmpresa tramiteINSEnviarMuestraEmpresa, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ENVIAR_MUESTRA_EMPRESA);

		tramiteInspeccion.setTifechainicio(tramiteINSEnviarMuestraEmpresa.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(tramiteINSEnviarMuestraEmpresa.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteINSEnviarMuestraEmpresa.getComentario());

		tramiteInspeccion.setTifechaenvlab(tramiteINSEnviarMuestraEmpresa.getTifechaenvlab());
		tramiteInspeccion.setTilacodigo(tramiteINSEnviarMuestraEmpresa.getTilacodigo());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteINSEnviarMuestraEmpresa.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteINSEnviarMuestraEmpresa.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {

			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		List<DocumentoExpediente> listDocumentoExpediente = new ArrayList<DocumentoExpediente>();
		if (tramiteINSEnviarMuestraEmpresa.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {

				this.soltramexpService.controlDocumentosPendientesFirmaTramitar(tramiteComun,
						Y41bConstantes.TIPO_PROC_INSPECCIONES);
				// se generan dos tramites automaticamente:
				TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
				tramiteInspeccionAux.setTiaccodigo(tramiteINSEnviarMuestraEmpresa.getAccodigo());
				tramiteInspeccionAux.setTilacodigo(tramiteINSEnviarMuestraEmpresa.getTilacodigo());

				this.generarTramiteResultadoEnsayos(tramiteInspeccionAux, tramiteComun);
			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramiteInspeccion,
						Y41bConstantes.FASE_REQUERIMIENTO, Y41bConstantes.TRAMITE_INSPECCIONES_ENVIAR_MUESTRA_EMPRESA);
			}
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite ResultadoEnsayos
	 * 
	 * @param tramiteResultadoEnsayos
	 *            TramiteResultadoEnsayos
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteResultadoEnsayos(TramiteINSResultadoEnsayos tramiteResultadoEnsayos,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
		adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocsFilter.setThidtipodoc(Y41bConstantes.TIPO_DOC_INFORME);
		Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

		if (total == 0) {
			throw new Y41bUDAException("error.inspecciones.documentoInformeException", true, new Exception());
		}

		AdjunInfraccHechoDenun adjuninfracchechodenun = new AdjunInfraccHechoDenun();
		adjuninfracchechodenun.setHicohd(tramiteComun.getIdTramite());
		Long numInfracciones = this.adjunInfraccHechoDenunDao.findAllCount(adjuninfracchechodenun);

		if (tramiteResultadoEnsayos.getTiconstatacion() != null
				&& tramiteResultadoEnsayos.getTiconstatacion().equals(Y41bConstantes.VALOR_SI)) {
			if (numInfracciones == 0) {
				throw new Y41bUDAException("error.inspecciones.InfraccionesException", true, new Exception());
			}
		}

		if (numInfracciones > 0) {
			if (tramiteResultadoEnsayos.getTiconstatacion() == null
					|| !tramiteResultadoEnsayos.getTiconstatacion().equals(Y41bConstantes.VALOR_SI)) {
				throw new Y41bUDAException("error.inspecciones.ConstantacionException", true, new Exception());
			}
		}

		if (tramiteResultadoEnsayos.getTiinclusiredalerta() != null
				&& tramiteResultadoEnsayos.getTiinclusiredalerta().equals(Y41bConstantes.VALOR_SI)) {
			if (tramiteResultadoEnsayos.getTiconstatacion() == null
					|| !tramiteResultadoEnsayos.getTiconstatacion().equals(Y41bConstantes.VALOR_SI)) {
				throw new Y41bUDAException("error.inspecciones.InclusionRedAlertaException", true, new Exception());
			}
		}

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RESULTADO_ENSAYOS);

		tramiteInspeccion.setTifechainicio(tramiteResultadoEnsayos.getFechaInicio());
		tramiteInspeccion.setTiaccodigo(tramiteResultadoEnsayos.getAccodigo());
		tramiteInspeccion.setTicomoasignado(tramiteResultadoEnsayos.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteResultadoEnsayos.getComentario());

		tramiteInspeccion.setTifecharesens(tramiteResultadoEnsayos.getTifecharesens());
		tramiteInspeccion.setTicodmuestra(tramiteResultadoEnsayos.getTicodmuestra());
		tramiteInspeccion.setTicodinfensay(tramiteResultadoEnsayos.getTicodinfensay());
		tramiteInspeccion.setTiresudictam(tramiteResultadoEnsayos.getTiresudictam());
		tramiteInspeccion.setTiconstatacion(tramiteResultadoEnsayos.getTiconstatacion());
		tramiteInspeccion.setTiinclusiredalerta(tramiteResultadoEnsayos.getTiinclusiredalerta());
		tramiteInspeccion.setTifechacomunicacion(tramiteResultadoEnsayos.getTifechacomunicacion());
		tramiteInspeccion.setTilacodigo(tramiteResultadoEnsayos.getTilacodigo());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteResultadoEnsayos.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteResultadoEnsayos.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdExpediente(tramiteComun.getIdTramite());

		this.actaInfraccionDao.removeAllInfracciones(tramiteComunAux);

		this.infraccHechoDenDao.addAllInfraccionesHechoAdjuntarInfraccionesControlMercado(tramiteComunAux);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.soltramexpService.procesarDocumentosTramite(tramiteComun);

		if (tramitar) {
			// Aadir las infracciones a la tabla ACTA_INFRACCION
			AdjunInfraccHechoDenun adjunInfraccHechoDenunFilter = new AdjunInfraccHechoDenun();
			adjunInfraccHechoDenunFilter.setHicohd(tramiteComun.getIdTramite());

			List<AdjunInfraccHechoDenun> listAdjunInfraccHechoDenun = this.adjunInfraccHechoDenunDao
					.findAll(adjunInfraccHechoDenunFilter, null);

			ActaInfraccion actainfraccion = null;
			Long numInfraccionesAux = null;
			for (AdjunInfraccHechoDenun adjunInfraccHechoDenunAux : listAdjunInfraccHechoDenun) {

				actainfraccion = new ActaInfraccion();
				actainfraccion.setAicoat(tramiteComun.getIdExpediente());
				actainfraccion.setAicotti(adjunInfraccHechoDenunAux.getHicotti());
				numInfraccionesAux = this.actaInfraccionDao.findAllCount(actainfraccion);
				if (numInfraccionesAux == 0) {
					actainfraccion = new ActaInfraccion();
					actainfraccion.setAicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					actainfraccion.setAicoat(tramiteComun.getIdExpediente());
					actainfraccion.setAicotti(adjunInfraccHechoDenunAux.getHicotti());
					String hiinexii = null;
					if (adjunInfraccHechoDenunAux.getHicotti() != null
							&& adjunInfraccHechoDenunAux.getHicotti().indexOf("N0") > -1) {
						// es un articulo
						hiinexii = "S";
					} else {
						hiinexii = "N";
					}
					actainfraccion.setAiinexii(hiinexii);

					this.actaInfraccionDao.add(actainfraccion);
				}
			}

			if (tramiteResultadoEnsayos.getTiinclusiredalerta() != null
					&& tramiteResultadoEnsayos.getTiinclusiredalerta().equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
				// tramiteComun.setAccodigo(tramiteResultadoEnsayos.getAccodigo());
				this.generarTramiteRevisionInclusionRedAlerta(tramiteComun);
			}
		}

		this.adjunInfraccHechoDenunDao.removeAllAdjuntarInfracciones(tramiteComunAux);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite Recepcion Recurso
	 * 
	 * @param tramiteRecepcionRecurso
	 *            TramiteRecepcionRecurso
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRecepcionRecurso(TramiteRecepcionRecurso tramiteRecepcionRecurso,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_RECURSO);

		tramiteInspeccion.setTifechainicio(tramiteRecepcionRecurso.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(tramiteRecepcionRecurso.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteRecepcionRecurso.getComentario());

		// Info recepcion recurso ini
		tramiteInspeccion.setTitiporecurso(tramiteRecepcionRecurso.getTiporecurso());
		tramiteInspeccion.setTifecharecurso(tramiteRecepcionRecurso.getFecharecurso());
		tramiteInspeccion.setTiabogado(tramiteRecepcionRecurso.getAbogado());
		tramiteInspeccion.setTimotivorecurso(tramiteRecepcionRecurso.getMotivorecurso());
		// Info recepcion recurso fin

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteRecepcionRecurso.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteRecepcionRecurso.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.soltramexpService.procesarDocumentosTramite(tramiteComun);

		if (tramitar) {
			this.generarTramiteInformeAsesoriaAutomatico(tramiteInspeccion);

			// Miramos si existe tramite de cierre
			boolean isTramiteCierre = this.tramiteInspeccionService.existeTramite(
					tramiteRecepcionRecurso.getIdExpediente(), Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE);

			if (isTramiteCierre) {
				// Actualizamos la fecha limite del tramite de cierre a null
				this.tramiteInspeccionService.updateFechaLimiteTramiteCierre(tramiteRecepcionRecurso.getIdExpediente());
			}
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite Informe Asesoria
	 * 
	 * @param tramiteInformeAsesoria
	 *            TramiteInformeAsesoria
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteInformeAsesoria(TramiteInformeAsesoria tramiteInformeAsesoria,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ELABORACION_INFORME_PARA_ASESORIA);

		tramiteInspeccion.setTifechainicio(tramiteInformeAsesoria.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(tramiteInformeAsesoria.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteInformeAsesoria.getComentario());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteInformeAsesoria.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteInformeAsesoria.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		List<DocumentoExpediente> listDocumentoExpediente = null;
		if (tramiteInformeAsesoria.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);
		}

		if (tramitar) {
			// Validacion: Debe haber almenos 1 documento
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdExpediente());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}

			this.generarTramiteComunicacionAutomaticoInformeAsesoria(tramiteInformeAsesoria, tramiteComun);

			this.generarTramiteRecepcionOrdenConsejeroAutomatico(tramiteInspeccion, tramiteComun);
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite RecepcionOrdenConsejero
	 * 
	 * @param tramiteRecepcionOrdenConsejero
	 *            TramiteRecepcionOrdenConsejero
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRecepcionOrdenConsejero(
			TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejero, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ORDEN_DEL_CONSEJERO);

		tramiteInspeccion.setTifechainicio(tramiteRecepcionOrdenConsejero.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(tramiteRecepcionOrdenConsejero.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteRecepcionOrdenConsejero.getComentario());

		// Info recepcion orden consejero ini
		tramiteInspeccion.setTiestimacion(tramiteRecepcionOrdenConsejero.getEstimacion());
		// Info recepcion orden consejero fin

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteRecepcionOrdenConsejero.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteRecepcionOrdenConsejero.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.soltramexpService.procesarDocumentosTramite(tramiteComun);

		if (tramitar) {
			// Generar notificacion al establecimiento visitado
			tramiteInspeccion = this.generarTramiteNotificacionAutomaticoOrdenConsejero(tramiteRecepcionOrdenConsejero,
					tramiteComun);

			// Miramos si existe tramite de cierre
			boolean isTramiteCierre = this.tramiteInspeccionService.existeTramite(
					tramiteRecepcionOrdenConsejero.getIdExpediente(),
					Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE);

			if (Y41bConstantes.SI.equals(tramiteRecepcionOrdenConsejero.getEstimacion())) {
				// Genero el tramite de asignacion de instructor
				this.generarTramiteAsignacionInstructorAutomaticoRecepcConsejero(tramiteRecepcionOrdenConsejero);

				if (isTramiteCierre) {
					this.tramiteInspeccionDao.removeTramiteCierreSinTramitarExpediente(tramiteInspeccion);
				}

			} else {
				if (isTramiteCierre) {
					// Actualizamos las fechas del tramite de cierre del
					// expediente
					tramiteInspeccionService
							.updateFechasTramiteCierre(tramiteRecepcionOrdenConsejero.getIdExpediente());
				}
			}
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite alegacion
	 * 
	 * @param tramiteAlegacion
	 *            TramiteAlegacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteAlegacion(TramiteAlegacion tramiteAlegacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ALEGACIONES);

		tramiteInspeccion.setTifechainicio(tramiteAlegacion.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(tramiteAlegacion.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteAlegacion.getComentario());

		tramiteInspeccion.setTiresumenrecepcion(tramiteAlegacion.getResumenAlegaciones());
		tramiteInspeccion.setTirespuestarecepcion(tramiteAlegacion.getRespuesta());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteAlegacion.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteAlegacion.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);
		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosEliminados(tramiteComun, null);

		this.soltramexpService.procesarDocumentosTramite(tramiteComun);

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteInspeccion;
	}

	/**
	 * Guardar Tramite Generico de Firma
	 * 
	 * @param tramiteINSGenericoFirma
	 *            TramiteINSGenericoFirma
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteINSGenericoFirma
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSGenericoFirma addTramiteGenericoFirma(TramiteINSGenericoFirma tramiteINSGenericoFirma,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {
		TramiteInspeccion tramiteInspeccion = null;
		tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_GENERICO_FIRMA);
		tramiteInspeccion.setTifechainicio(tramiteINSGenericoFirma.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(tramiteINSGenericoFirma.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteINSGenericoFirma.getComentario());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteINSGenericoFirma.getFechaFin());
			tramiteInspeccion.setTicomoejecucion(tramiteINSGenericoFirma.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);

		}

		List<DocumentoExpediente> listDocumentoExpediente = new ArrayList<DocumentoExpediente>();
		if (tramiteINSGenericoFirma.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.soltramexpService.controlDocumentosPendientesFirmaTramitar(tramiteComun,
						Y41bConstantes.TIPO_PROC_INSPECCIONES);
			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramiteInspeccion,
						Y41bConstantes.FASE_REQUERIMIENTO, Y41bConstantes.TRAMITE_INSPECCIONES_GENERICO_FIRMA);
			}
		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		return tramiteINSGenericoFirma;
	}

	/**
	 * Guardar Tramite Comunicacin de existencia de nuevo Distribuidor
	 * 
	 * @param tramiteINSComunicarNuevoDistribuidor
	 *            TramiteINSComunicarNuevoDistribuidor
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteINSComunicarNuevoDistribuidor
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSComunicarNuevoDistribuidor addTramiteComunicarNuevoDistribuidor(
			TramiteINSComunicarNuevoDistribuidor tramiteINSComunicarNuevoDistribuidor, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception {
		TramiteInspeccion tramiteInspeccion = null;
		tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICAR_NUEVO_DISTRIBUIDOR);
		tramiteInspeccion.setTifechainicio(tramiteINSComunicarNuevoDistribuidor.getFechaInicio());
		tramiteInspeccion.setTicomoasignado(tramiteINSComunicarNuevoDistribuidor.getInstructorAsignado().getMocodigo());
		tramiteInspeccion.setTicomentario(tramiteINSComunicarNuevoDistribuidor.getComentario());

		if (tramitar) {
			tramiteInspeccion.setTifechafin(tramiteINSComunicarNuevoDistribuidor.getFechaFin());
			tramiteInspeccion
					.setTicomoejecucion(tramiteINSComunicarNuevoDistribuidor.getInstructorEjecucion().getMocodigo());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
			// Se inserta el tramite
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		} else if (modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
			this.tramiteInspeccionService.updateTramiteInspeccion(tramiteInspeccion);

		}

		List<DocumentoExpediente> listDocumentoExpediente = new ArrayList<DocumentoExpediente>();
		if (tramiteINSComunicarNuevoDistribuidor.getAnyadirPlantilla() == null) {
			// buscar los documentos que no estan en la tabla de trabajo de
			// documentos y que pertenecen al Tramite
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
			listDocumentoExpediente = this.documentoHechoDao.findAllDocumentosEliminados(tramiteComun, null);

			this.soltramexpService.procesarDocumentosTramite(tramiteComun);

			if (tramitar) {
				this.soltramexpService.controlDocumentosPendientesFirmaTramitar(tramiteComun,
						Y41bConstantes.TIPO_PROC_INSPECCIONES);

			} else {
				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramiteInspeccion,
						Y41bConstantes.FASE_REQUERIMIENTO,
						Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICAR_NUEVO_DISTRIBUIDOR);
			}

		}

		// Eliminamos los documentos de dokusi
		this.eliminarDocumentosDokusi(listDocumentoExpediente);

		// 0185432: INS- Comunicacin de nuevo distribuidor
		// Mando el email no cuando se tramita sino cuando se guarda (al
		// 'sugerir' el tramite, para que sepa que tiene que hacer algo -
		// tramitarlo)
		if (!tramitar && modoEditar != null && modoEditar.equals(Y41bConstantes.MODO_POPUP_ALTA)) {

			this.envioEmailComunicacionNuevoDistribuidor(tramiteComun);
		}

		return tramiteINSComunicarNuevoDistribuidor;
	}

	/************************
	 * TRAMITES AUTOMATICOS *
	 ************************/

	/**
	 * Generar Tramite Automatico.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipoTramite
	 *            String
	 * @param estado
	 *            String
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteAutomaticoConEstado(TramiteComun tramiteComun, String tipoTramite,
			String estado) throws Exception {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTiaccodigo(tramiteComun.getAccodigo());
		tramiteInspeccion.setTicotee(tipoTramite);

		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTiestadotramite(estado);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico con un estado sin ejecutar.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipoTramite
	 *            String
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteAutomatico(TramiteComun tramiteComun, String tipoTramite) throws Exception {
		return this.generarTramiteAutomaticoConEstado(tramiteComun, tipoTramite,
				Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
	}

	/**
	 * Generar Tramite BOPV
	 * 
	 * @param tramiteElaboracionBOPVAyto
	 *            TramiteElaboracionBOPVAyto
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteBOPV_AYTO(TramiteComun tramiteComun) throws Exception {
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteinspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_INFORMACION_PUBLICACION_BOPV_BOE);

		tramiteinspeccion.setTifechainicio(new Date());
		// tramiteinspeccion.setTiaccodigo(tramiteComun.getAccodigo());
		tramiteinspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteinspeccion.setTicomentario("");

		TramiteInspeccion tramiteinspeccionRel = new TramiteInspeccion();
		tramiteinspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteinspeccion.setTramiteInspeccion(tramiteinspeccionRel);

		tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);

		// Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramiteinspeccion.getTicodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteinspeccion);

		return tramiteinspeccion;
	}

	/**
	 * Generar Tramite Automatico de resultado ensayos
	 * 
	 * @param tramiteComunicacion
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteResultadoEnsayos(TramiteInspeccion tramiteResultadoEnsayos,
			TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RESULTADO_ENSAYOS);

		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteResultadoEnsayos.getTiaccodigo());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTilacodigo(tramiteResultadoEnsayos.getTilacodigo());
		tramiteInspeccion.setTicodmuestra(tramiteResultadoEnsayos.getTicodmuestra());

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de desinmovilizacin
	 * 
	 * @param tramiteDesinmovilizacion
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	// TODO eliminar que igual no sirve.
	public TramiteInspeccion generarTramiteDesinmovilizacion(TramiteInspeccion tramiteDesinmovilizacion,
			TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_DESINMOVILIZACION);

		tramiteInspeccion.setTifechaaip(new Date());
		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteComun.getAccodigo());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de desinmovilizacin
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	// TODO eliminar que igual no sirve.
	public TramiteInspeccion generarTramiteAcuerdoInicioProcedimiento(TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);

		tramiteInspeccion.setTifechaaip(new Date());
		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteComun.getAccodigo());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de resultado ensayos
	 * 
	 * @param tramiteAIP
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteResolucionAIP(TramiteInspeccion tramiteAIP, TramiteComun tramiteComun)
			throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RESOLUCION_ACUERDO_INICIO_PROCEDIMIENTO);

		tramiteInspeccion.setTifechaaip(new Date());
		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteComun.getAccodigo());
		// tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomoasignado(null);
		tramiteInspeccion.setTicomentario("");
		tramiteInspeccion.setTramiteInspeccion(tramiteAIP);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Levantamiento de acta
	 * 
	 * @param tramiteLevantamientoActa
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteLevantamientoActa(TramiteInspeccion tramiteLevantamientoActa,
			TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_LEVANTAMIENTO_ACTA);

		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTifechafin(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteComun.getAccodigo());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomoejecucion(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTiancodigo(tramiteLevantamientoActa.getTiancodigo());
		tramiteInspeccion.setTitipactua(tramiteLevantamientoActa.getTitipactua());

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Revision para inclusion en red de alerta
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteRevisionInclusionRedAlerta(TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REVISION_INCLUSION_EN_RED_DE_ALERTA);

		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteComun.getAccodigo());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");
		tramiteInspeccion.setTiancodigo(tramiteComun.getAccodigo());

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite registro decision
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteRegistroDecision(TramiteRegistroDecision tramiteRegistroDecision,
			TramiteComun tramiteComun) throws Exception {

		// INSPECCION
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTifechainicio(tramiteRegistroDecision.getFechaInicio());
		tramiteInspeccion.setTiaccodigo(tramiteRegistroDecision.getAccodigo());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION);
		tramiteInspeccion.setTicomentario(tramiteRegistroDecision.getComentario());

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Guardar el tramite archivo AIP
	 * 
	 * @param tramiteINSArchivoAIP
	 *            TramiteINSArchivoAIP
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteArchivoAIP(TramiteINSArchivoAIP tramiteINSArchivoAIP,
			TramiteComun tramiteComun, boolean tramitar) throws Exception {

		// INSPECCION
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTifechainicio(tramiteINSArchivoAIP.getFechaInicio());
		tramiteInspeccion.setTiaccodigo(tramiteINSArchivoAIP.getAccodigo());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ARCHIVO_AIP);
		tramiteInspeccion.setTicomentario(tramiteINSArchivoAIP.getComentario());

		tramiteInspeccion.setTidecodigo(Y41bConstantes.DECISION_INSPECCIONES_ARCHIVO_AIP);
		tramiteInspeccion.setTidestinatario(Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTOVISITADO);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		if (tramitar) {
			tramiteInspeccion.setTifecharesolucion(new Date());
			tramiteInspeccion.setTicomoejecucion(Y41bConstantes.CODIGO_USUARIO_SYS_CENSO_MONITOR);
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Genera un tramite de Acuerdo de inicio de procedimiento.
	 * 
	 * @param idExpediente
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	private void generarTramiteAcuerdoInicioProcedimiento(
			TramiteINSAcuerdoInicioProcedimiento tramiteAcuerdoInicioProcedimiento) throws Exception {
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		TramiteINSAcuerdoInicioProcedimiento tramiteINSAcuerdoInicioProcedimiento = new TramiteINSAcuerdoInicioProcedimiento();
		tramiteINSAcuerdoInicioProcedimiento.setFechaInicio(new Date());
		tramiteINSAcuerdoInicioProcedimiento.setAccodigo(tramiteAcuerdoInicioProcedimiento.getAccodigo());
		tramiteINSAcuerdoInicioProcedimiento
				.setCodigoTramiteRelacionado(tramiteAcuerdoInicioProcedimiento.getCodigoTramiteRelacionado());

		TramiteComun tramiteComun = new TramiteComun();

		tramiteComun.setIdExpediente(tramiteAcuerdoInicioProcedimiento.getIdExpediente());
		tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		tramiteINSAcuerdoInicioProcedimiento
				.setInstructorAsignado(tramiteAcuerdoInicioProcedimiento.getInstructorAsignado());

		// Generar el tramite.
		tramiteINSAcuerdoInicioProcedimiento = this.addTramiteAcuerdoInicioProcedimiento(
				tramiteINSAcuerdoInicioProcedimiento, tramiteComun, idioma, false, Y41bConstantes.MODO_POPUP_ALTA);

		// Recuperar el documento de la Comunicacion Soivre o de la programacion
		// de la Alerta e introducirlo en el tramite.
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteAcuerdoInicioProcedimiento.getIdExpediente());
		actuacion = this.actuacionDao.find(actuacion);

		if (Y41bConstantes.VALOR_SI.equals(actuacion.getAtacuerdoinicio())) {
			DocumentoHecho documentoHecho = new DocumentoHecho();
			if (actuacion.getAtidcomunicacionsoivre() != null && !"".equals(actuacion.getAtidcomunicacionsoivre())) {
				documentoHecho.setQ5hdcodigo(actuacion.getAtidcomunicacionsoivre());
			} else if (actuacion.getAtcoal() != null && !"".equals(actuacion.getAtcoal())) {
				documentoHecho.setQ5hdcodigo(actuacion.getAtcocr());
			}
			if (documentoHecho.getQ5hdcodigo() != null) {
				documentoHecho.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_AIP);
				List<DocumentoHecho> documentosHecho = this.documentoHechoDao.findAll(documentoHecho, null);
				if (documentosHecho.size() > 0) {
					DocumentoHecho documentoHechoAux = documentosHecho.get(0);
					documentoHechoAux.setQ5hdcodigo(tramiteAcuerdoInicioProcedimiento.getIdExpediente());
					documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
					documentoHechoAux.setQ5codocumento(String.valueOf(this.documentoHechoDao.getNewPK()));

					documentoHechoAux.setQ5idPerfilfirma(Y41bConstantes.PERFIL_DIRECTOR);
					documentoHechoAux.setQ5fechasolfirma(Calendar.getInstance().getTime());
					documentoHechoAux.setQ5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
					this.documentoHechoDao.add(documentoHechoAux);

					// Insertar los documentos en la tabla intermedia
					DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setEhcodigo(tramiteComun.getIdTramite());
					documentoTramiteHecho.setCodocumento(documentoHechoAux.getQ5codocumento());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}

				TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
				tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());

				tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

				this.controlDocumentosPendientesFirmaGuardar(tramiteComun, tramiteInspeccion,
						Y41bConstantes.FASE_REQUERIMIENTO,
						Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);
			}
		}
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Requerimiento
	 * acreditacin
	 * 
	 * @param tramiteRequerimientoAcreditacionRepresentacion
	 *            TramiteRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteNotificacionAutomaticoReqAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramiteRequerimientoAcreditacionRepresentacion,
			TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);
		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteRequerimientoAcreditacionRepresentacion.getAccodigo());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		// buscar el interviniente
		String tipo_interviniente_destinatario = "";
		if (Y41bUtils.isFilled(tramiteRequerimientoAcreditacionRepresentacion.getOrigen())
				&& Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO
						.equals(tramiteRequerimientoAcreditacionRepresentacion.getOrigen())) {
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO;
		} else if (Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTORESPONSABLE
				.equals(tramiteRequerimientoAcreditacionRepresentacion.getOrigen())) {
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE;
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(tipo_interviniente_destinatario);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramiteInspeccion.setTitiponotificacionplatea(Y41bConstantes.NOTIFICACION_REQUERIMIENTO);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Requerimiento por
	 * Escrito
	 * 
	 * @param tramiteRequerimientoInformacion
	 *            TramiteRequerimientoInformacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteNotificacionAutomaticoRequerimientoEscrito(
			TramiteRequerimientoInformacion tramiteRequerimientoInformacion, TramiteComun tramiteComun)
			throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);
		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteRequerimientoInformacion.getAccodigo());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		// buscar el interviniente
		String tipo_interviniente_destinatario = "";
		if (Y41bUtils.isFilled(tramiteRequerimientoInformacion.getOrigen())
				&& Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO
						.equals(tramiteRequerimientoInformacion.getOrigen())) {
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO;
		} else if (Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTORESPONSABLE
				.equals(tramiteRequerimientoInformacion.getOrigen())) {
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE;
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(tipo_interviniente_destinatario);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramiteInspeccion.setTitiponotificacionplatea(Y41bConstantes.NOTIFICACION_REQUERIMIENTO);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Requerimiento por
	 * Escrito
	 * 
	 * @param tramiteRequerimientoInformacion
	 *            TramiteRequerimientoInformacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteNotificacionResolucionAIP(TramiteINSResolucionAIP tramiteResolucionAIP,
			TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);
		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteResolucionAIP.getAccodigo());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");
		tramiteInspeccion.setTicodigorelacionado(tramiteResolucionAIP.getIdTramite());

		tramiteInspeccion.setTifechacomunicacion(new Date());

		// buscar el interviniente
		String tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO;

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(tipo_interviniente_destinatario);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramiteInspeccion.setTitiponotificacionplatea(Y41bConstantes.NOTIFICACION_RESOLUCION);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Desinmovilizacion
	 * 
	 * @param tramiteDesinmovilizacion
	 *            TramiteINSDesinmovilizacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteNotificacionPorActaDesinmovilizacion(
			TramiteINSDesinmovilizacion tramiteDesinmovilizacion, TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);

		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicodigorelacionado(tramiteDesinmovilizacion.getIdExpediente());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramiteInspeccion.setTitiponotificacionplatea(Y41bConstantes.NOTIFICACION_RESOLUCION);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		tramiteInspeccion.setTinotificacionporacta(Y41bConstantes.VALOR_SI);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Recepcion Escrito desde Requerimiento de
	 * Informacion
	 * 
	 * @param tramiteInspeccionReqInformacion
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteRecInformacionAutomaticoRequerimientoEscrito(
			TramiteInspeccion tramiteInspeccionReqInformacion, TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_REQUERIMIENTO);
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));

		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteInspeccionReqInformacion.getTiaccodigo());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");
		// Origen del tramite que lo origina
		tramiteInspeccion.setTiorigenalegacion(tramiteInspeccionReqInformacion.getTiorigenalegacion());
		// Enlazamos al tramite que lo origina
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionReqInformacion);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Recepcion Acreditacin desde Requerimiento
	 * de Acreditacin
	 * 
	 * @param tramiteInspeccionReqAcreditacionRepresentacion
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteRecInformacionAutomaticoReqAcreditacionRepresentacion(
			TramiteInspeccion tramiteInspeccionReqAcreditacionRepresentacion, TramiteComun tramiteComun)
			throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ACREDITACION_REPRESENTACION);
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));

		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");
		// Origen del tramite que lo origina
		tramiteInspeccion.setTiorigenalegacion(tramiteInspeccionReqAcreditacionRepresentacion.getTiorigenalegacion());
		// Enlazamos al tramite que lo origina
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionReqAcreditacionRepresentacion);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite automatico de Acuse de Recibo
	 * 
	 * @param idEspera
	 *            String
	 * @param tramiteInspeccionNotifRel
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteAcuseReciboAutomatico(String idEspera,
			TramiteInspeccion tramiteInspeccionNotifRel, TramiteComun tramiteComun) throws Exception {
		// Generar el tramite de acuse de recibo vinculado al tramite de
		// notificacion
		// Creacion de tramite de registro de solicitud tramitado
		TramiteInspeccion tramiteInspeccionAcuse = new TramiteInspeccion();
		tramiteInspeccionAcuse.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccionAcuse.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccionAcuse.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO);
		tramiteInspeccionAcuse.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccionAcuse.setTifechainicio(tramiteInspeccionNotifRel.getTifechainicio());
		tramiteInspeccionAcuse.setTiaccodigo(tramiteInspeccionNotifRel.getTiaccodigo());
		tramiteInspeccionAcuse.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccionAcuse.setTicomentario("");
		tramiteInspeccionAcuse.setTramiteInspeccion(tramiteInspeccionNotifRel);
		tramiteInspeccionAcuse.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// tratamos el idEspera pasado por parametro
		if (Y41bUtils.isFilled(idEspera)) {
			tramiteInspeccionAcuse.setTiidesperaplatea(idEspera);
			tramiteInspeccionAcuse.setTimatarespera(Y41bConstantes.NO);
		}

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccionAcuse);
		return tramiteInspeccionAcuse;
	}

	/**
	 * Generar Tramite automatico de Remision de muestras al laboratorio
	 * 
	 * @param idEspera
	 *            String
	 * @param tramiteInspeccionRemision
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteRemisionMuestrasAlLaboratorio(TramiteInspeccion tramiteInspeccionRemision,
			TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REMISION_MUESTRAS_AL_LABORATORIO);
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));

		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteInspeccionRemision.getTiaccodigo());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTiancodigo(tramiteInspeccionRemision.getTiancodigo());
		tramiteInspeccion.setTicodmuestra(tramiteInspeccionRemision.getTicodmuestra());

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite automatico de Ampliacion de la Inspeccion
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteAmpliacionInspeccion(TramiteInspeccion tramiteInspeccion,
			TramiteComun tramiteComun) throws Exception {
		// Generar el tramite de Ampliacin de Inspeccion vinculado al tramite
		// de Recepcion de inspeccion.

		// Creacion de tramite de Ampliacin de Inspeccion en tramite.
		TramiteInspeccion tramiteAmpliacionInspeccion = new TramiteInspeccion();
		tramiteAmpliacionInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteAmpliacionInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteAmpliacionInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_SOLICITUD_AMPLIACION_DE_INSPECCION);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteAmpliacionInspeccion.setTifechainicio(new Date());
		tramiteAmpliacionInspeccion.setTiaccodigo(tramiteInspeccion.getTiaccodigo());
		tramiteAmpliacionInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteAmpliacionInspeccion.setTicomentario("");
		tramiteAmpliacionInspeccion.setTimotivoampli(tramiteInspeccion.getTimotivoampli());

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteAmpliacionInspeccion.setTramiteInspeccion(tramiteInspeccionRel);
		tramiteAmpliacionInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteAmpliacionInspeccion);
		return tramiteAmpliacionInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Acuerdo Inicio
	 * Procedimiento
	 * 
	 * @param tramiteAcuerdoInicioProcedimiento
	 *            TramiteINSAcuerdoInicioProcedimiento
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteNotificacionPorActaAutomaticoAIP(
			TramiteINSAcuerdoInicioProcedimiento tramiteAcuerdoInicioProcedimiento, TramiteComun tramiteComun)
			throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);

		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteAcuerdoInicioProcedimiento.getAccodigo());

		tramiteInspeccion.setTicodigorelacionado(tramiteAcuerdoInicioProcedimiento.getIdExpediente());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramiteInspeccion.setTitiponotificacionplatea(Y41bConstantes.NOTIFICACION_RESOLUCION);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Acuerdo Inicio
	 * Procedimiento
	 * 
	 * @param tramiteAcuerdoInicioProcedimiento
	 *            TramiteINSAcuerdoInicioProcedimiento
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteComunicacionPostalAIP(
			TramiteINSAcuerdoInicioProcedimiento tramiteAcuerdoInicioProcedimiento, TramiteComun tramiteComun)
			throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);

		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTiaccodigo(tramiteAcuerdoInicioProcedimiento.getAccodigo());

		tramiteInspeccion.setTicodigorelacionado(tramiteAcuerdoInicioProcedimiento.getIdExpediente());
		tramiteInspeccion.setTicomoasignado(this.obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite automatico de Elaboracion de Informe de Asesoria
	 * 
	 * @param tramitehechoRecepRecRel
	 *            TramiteHecho
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteInformeAsesoriaAutomatico(TramiteInspeccion tramiteInspeccionRecepRecRel)
			throws Exception {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteInspeccionRecepRecRel.getTiatcodigo());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ELABORACION_INFORME_PARA_ASESORIA);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(tramiteInspeccionRecepRecRel.getTiatcodigo());
		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));

		tramiteInspeccion.setTicomentario("");
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRecepRecRel);
		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		CensoMonitor censoMonitor = new CensoMonitor();
		censoMonitor.setMocodigo(tramiteInspeccion.getTicomoasignado());

		this.enviarEmailElaboracionInformeAsesoria(tramiteInspeccionRecepRecRel.getTiatcodigo(), censoMonitor);

		return tramiteInspeccion;
	}

	/**
	 * Envia un email a los usuarios que son administrativo en liquidaciones
	 * 
	 * @param atcodigo
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	private void enviarEmailElaboracionInformeAsesoria(String atcodigo, CensoMonitor censoMonitor) {

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");
		censoMonitor = censoMonitorDao.find(censoMonitor);
		if (censoMonitor != null && (censoMonitor.getMocoem() == null || censoMonitor.getMocoem().equals(""))) {
			throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, new Exception());
		}
		String from = censoMonitor.getMocoem();

		CensoMonitor adminLiq = new CensoMonitor();
		adminLiq.setMoadmiliquidacion(Y41bConstantes.VALOR_SI);
		List<CensoMonitor> ladminLiq = censoMonitorDao.findAllCensoMonitorSanciones(adminLiq);
		StringBuffer destinatarios = new StringBuffer("");
		for (int i = 0; i < ladminLiq.size(); i++) {
			if (!Y41bUtils.esNullOCadenaVacia(ladminLiq.get(i).getMocoem())) {
				if (destinatarios.length() > 0) {
					destinatarios.append(";");
				}
				destinatarios.append(ladminLiq.get(i).getMocoem());
			}
		}
		if (!Y41bUtils.isFilled(destinatarios.toString())) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}
		// 2. Creo el asunto
		// Obtener el numero de expediente
		String numeroExpediente = this.findNumExpedienteActuacion(atcodigo);

		StringBuffer asunto = new StringBuffer();
		// Castellano
		asunto.append(this.appMessageSource.getMessage("liquidacion.mail.asuntoRecurso", null,
				new Locale(Y41bConstantes.CASTELLANO)));
		asunto.append(" ").append(numeroExpediente).append(" / ");
		// Euskera
		asunto.append(this.appMessageSource.getMessage("liquidacion.mail.asuntoRecurso", null,
				new Locale(Y41bConstantes.EUSKERA)));
		asunto.append(" ").append(numeroExpediente);

		// 3. Creo el contenido del mail
		StringBuffer texto = new StringBuffer();
		String[] params = new String[1];
		params[0] = numeroExpediente.toString();
		texto.append("<B>").append(this.appMessageSource.getMessage("liquidacion.mail.textoRecurso", params,
				new Locale(Y41bConstantes.CASTELLANO)));
		texto.append(" / ").append(this.appMessageSource.getMessage("liquidacion.mail.textoRecurso", params,
				new Locale(Y41bConstantes.EUSKERA))).append("</B><BR>");

		boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
				destinatarios.toString(), "", null);
		if (!enviadoOK) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}
	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Informe Asesoria
	 * 
	 * @param tramiteInformeAsesoria
	 *            TramiteInformeAsesoria
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteComunicacionAutomaticoInformeAsesoria(
			TramiteInformeAsesoria tramiteInformeAsesoria, TramiteComun tramiteComun) throws Exception {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// Hay que relacionar los documentos del informe de asesoria con el
		// tramite de comunicacion
		// 1. Recupero los documentos
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosinformeasesoria = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// 2. Relaciono tramite - documento
		if (documentosinformeasesoria != null && documentosinformeasesoria.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentoinformeasesoria : documentosinformeasesoria) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
				documentoTramiteHecho.setCodocumento(documentoinformeasesoria.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite automatico de Recepcion de Orden del Consejero
	 * 
	 * @param tramitehechoInformeAsesoriaRel
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteRecepcionOrdenConsejeroAutomatico(
			TramiteInspeccion tramitehechoInformeAsesoriaRel, TramiteComun tramiteComun) throws Exception {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ORDEN_DEL_CONSEJERO);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));

		tramiteInspeccion.setTicomentario("");
		tramiteInspeccion.setTramiteInspeccion(tramitehechoInformeAsesoriaRel);
		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Orden Consejero
	 * 
	 * @param tramiteRecepcionOrdenConsejero
	 *            TramiteRecepcionOrdenConsejero
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteNotificacionAutomaticoOrdenConsejero(
			TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejero, TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramiteInspeccion.setTitiponotificacionplatea(Y41bConstantes.NOTIFICACION_RESOLUCION_RECURSO);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
				documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Asignacion de Instructor desde el Tramite
	 * de Recepcion de Consejero
	 * 
	 * @param tramiteRecepcionOrdenConsejero
	 *            TramiteRecepcionOrdenConsejero
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteAsignacionInstructorAutomaticoRecepcConsejero(
			TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejero) throws Exception {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteRecepcionOrdenConsejero.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ASIGNACION_RESPONSABLE_EXPEDIENTE);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(tramiteRecepcionOrdenConsejero.getIdExpediente());
		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Recepcion de Recurso
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteRecepcionRecurso(TramiteComun tramiteComun, DocumentoHecho documentoHecho)
			throws Exception {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_RECURSO);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTitiporecurso(Y41bConstantes.TIPO_RECURSO_ALZADA);
		tramiteInspeccion.setTifecharecurso(new Date());

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos
		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
		documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
		documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Recepcion de Recurso
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteRecepcionAlegacion(TramiteComun tramiteComun, DocumentoHecho documentoHecho)
			throws Exception {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ALEGACIONES);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos
		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
		documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
		documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Recepcion de Acreditacin Representacin
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteRecepcionAcreditacionRepresentacion(TramiteComun tramiteComun,
			DocumentoHecho documentoHecho) throws Exception {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ACREDITACION_REPRESENTACION);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		String origen = "";
		if (documentoHecho.getQ5origen() != null
				&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO) || documentoHecho
						.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO))) {
			origen = Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO;
		} else if (documentoHecho.getQ5origen() != null && (documentoHecho.getQ5origen()
				.equals(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE)
				|| documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE))) {
			origen = Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTORESPONSABLE;
		} else {
			origen = Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO;
		}

		tramiteInspeccion.setTiorigenalegacion(origen);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Enlazamos al tramite que lo origina
		tramiteInspeccion.setTramiteInspeccion(new TramiteInspeccion(tramiteComun.getIdTramite()));

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos
		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
		documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
		documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Requerimiento de Acreditacin
	 * Representacin
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteRequerimientoAcreditacionRepresentacion(Intervinientes intervinientes)
			throws Exception {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(intervinientes.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REQUERIMIENTO_ACREDITACION_REPRESENTACION);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(intervinientes.getIdExpediente());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		intervinientes = this.intervinientesDao.find(intervinientes);

		String origen = "";
		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO))) {
			origen = Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO;
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente().equals(
						Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO))) {
			origen = Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTORESPONSABLE;
		}

		tramiteInspeccion.setTiorigenalegacion(origen);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Genera un tramite de Asignacion de instructor.
	 * 
	 * @param idExpediente
	 *            String
	 * @param moCodigoEjecucion
	 *            String
	 * @param moCodigoDesignado
	 *            String
	 * @param tramitado
	 *            boolean
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarTramiteAsignacionInstructor(String idExpediente, String moCodigoEjecucion,
			String moCodigoDesignado, boolean tramitado) throws Exception {
		TramiteAsignacionInstructor tramiteAsignacionInstructor = new TramiteAsignacionInstructor();
		tramiteAsignacionInstructor.setFechaInicio(new Date());

		TramiteComun tramiteComun = new TramiteComun();

		tramiteComun.setIdExpediente(idExpediente);
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		// Coordinador
		CensoMonitor censoMonitorCoordinador = new CensoMonitor();
		try {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());

			InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

			Organismo organismo = new Organismo();
			organismo.setCodOrg(inspeccionDetalle.getAdcoor());

			censoMonitorCoordinador.setOrganismo(organismo);

			censoMonitorCoordinador = this.censoMonitorDao.findCoordinadorInspecciones(censoMonitorCoordinador);
		} catch (Exception e) {
			censoMonitorCoordinador = new CensoMonitor();
		}

		tramiteAsignacionInstructor.setInstructorAsignado(censoMonitorCoordinador);

		CensoMonitor censoMonitor = new CensoMonitor();
		censoMonitor.setMocodigo(moCodigoDesignado);
		tramiteAsignacionInstructor.setInstructorExpediente(censoMonitor);

		if (tramitado) {
			CensoMonitor censoMonitorEjecucion = new CensoMonitor();
			censoMonitorEjecucion.setMocodigo(moCodigoEjecucion);

			tramiteAsignacionInstructor.setInstructorAsignado(censoMonitorEjecucion);

			tramiteAsignacionInstructor.setInstructorEjecucion(censoMonitorEjecucion);
		}

		// Buscar el tramite de asignacin SIN tramitar
		TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
		tramiteInspeccionDetalle.setAtcodigo(idExpediente);
		tramiteInspeccionDetalle.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_ASIGNACION_RESPONSABLE_EXPEDIENTE);

		tramiteInspeccionDetalle = this.tramiteInspeccionDao
				.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteInspeccionDetalle);

		if (tramiteInspeccionDetalle != null && Y41bUtils.isFilled(tramiteInspeccionDetalle.getTicodigo())) {
			// Actualizar el tramite.
			tramiteComun.setIdTramite(tramiteInspeccionDetalle.getTicodigo());
			this.addTramiteAsignacionInstructor(tramiteAsignacionInstructor, tramiteComun, tramitado,
					Y41bConstantes.MODO_POPUP_MODIFICACION);
		} else {
			// Generar el tramite.
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			this.addTramiteAsignacionInstructor(tramiteAsignacionInstructor, tramiteComun, tramitado,
					Y41bConstantes.MODO_POPUP_ALTA);
		}
	}

	/**
	 * Genera un tramite de Registro de inspeccion.
	 * 
	 * @param idExpediente
	 *            String
	 * @param moCodigoDesignado
	 *            String
	 * @param tramitado
	 *            boolean
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarTramiteRegistroInspeccion(String idExpediente, String moCodigoDesignado, boolean tramitado)
			throws Exception {

		TramiteComun tramiteComunRegistro = new TramiteComun();
		TramiteRegistroSolicitud tramiteRegistroSolicitudRegistro = new TramiteRegistroSolicitud();
		tramiteRegistroSolicitudRegistro.setFechaInicio(new Date());
		CensoMonitor censoMonitor = new CensoMonitor();
		censoMonitor.setMocodigo(moCodigoDesignado);
		tramiteRegistroSolicitudRegistro.setInstructorAsignado(censoMonitor);
		tramiteComunRegistro.setIdExpediente(idExpediente);
		tramiteComunRegistro.setIdTipoTramite(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_INSPECCION);
		tramiteComunRegistro.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		tramiteComunRegistro.setTipoProcedimiento(tipoProcedimiento);

		this.addTramiteRegistroInspeccion(tramiteRegistroSolicitudRegistro, tramiteComunRegistro, tramitado,
				Y41bConstantes.MODO_POPUP_ALTA);
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Registro de Decision
	 * para traslado a Otros
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteComunicacionOtrosRegistroDecision(
			TramiteRegistroDecision tramiteRegistroDecision, TramiteComun tramiteComun, Intervinientes intervinientes)
			throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		tramiteInspeccion.setTiiddestinatario(intervinientes.getIdinterviniente());

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				if (documentodecision.getQ5destino().equals(Y41bConstantes.DESTINO_RESOL_OTROS)) {
					documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
					documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Registro Decision.
	 * Genera 2 tramites de notificacion: Reclamante + Reclamado
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteNotificacionAutomaticoRegistroDecision(
			TramiteRegistroDecision tramiteRegistroDecision, TramiteComun tramiteComun) throws Exception {
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteComun.getIdExpediente());

		InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

		if (Y41bConstantes.INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES.equals(inspeccionDetalle.getActiororigen())
				|| Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA.equals(inspeccionDetalle.getActiororigen())) {
			this.generarTramiteComunicacionNotificacionProductoresRegistroDecision(tramiteRegistroDecision,
					tramiteComun);
		}

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		if (Y41bConstantes.DECISION_INSPECCIONES_TRASLADO.equals(tramiteRegistroDecision.getTipoDecision())) {

		} else if (Y41bConstantes.DECISION_INSPECCIONES_SIN_INFRACCION
				.equals(tramiteRegistroDecision.getTipoDecision())) {

		} else if (Y41bConstantes.DECISION_INSPECCIONES_CON_APERCIBIMIENTO
				.equals(tramiteRegistroDecision.getTipoDecision())) {
			if (tramiteRegistroDecision != null && tramiteRegistroDecision.getTidestinatario() != null
					&& tramiteRegistroDecision.getTidestinatario()
							.equals(Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTOVISITADO)) {
				this.generarTramiteNotificacionEstablecimientoVisitadoRegistroDecision(tramiteRegistroDecision,
						tramiteComun);
			} else if (tramiteRegistroDecision != null && tramiteRegistroDecision.getTidestinatario() != null
					&& tramiteRegistroDecision.getTidestinatario()
							.equals(Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTORESPONSABLE)) {
				this.generarTramiteNotificacionEstablecimientoResponsableRegistroDecision(tramiteRegistroDecision,
						tramiteComun);
			}

		} else if (Y41bConstantes.DECISION_INSPECCIONES_CON_PROPUESTA_DE_SANCION
				.equals(tramiteRegistroDecision.getTipoDecision())) {

		} else if (Y41bConstantes.DECISION_INSPECCIONES_ARCHIVO_AIP.equals(tramiteRegistroDecision.getTipoDecision())) {
			if (tramiteRegistroDecision != null && tramiteRegistroDecision.getTidestinatario() != null
					&& tramiteRegistroDecision.getTidestinatario()
							.equals(Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTOVISITADO)) {
				this.generarTramiteNotificacionEstablecimientoVisitadoRegistroDecision(tramiteRegistroDecision,
						tramiteComun);
			} else if (tramiteRegistroDecision != null && tramiteRegistroDecision.getTidestinatario() != null
					&& tramiteRegistroDecision.getTidestinatario()
							.equals(Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTORESPONSABLE)) {
				this.generarTramiteNotificacionEstablecimientoResponsableRegistroDecision(tramiteRegistroDecision,
						tramiteComun);
			}

		}

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Archivo AIP. Genera 2
	 * tramites de notificacion: Reclamante + Reclamado
	 * 
	 * @param tramiteINSArchivoAIP
	 *            TramiteINSArchivoAIP
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteNotificacionAutomaticoArchivoAIP(TramiteINSArchivoAIP tramiteINSArchivoAIP,
			TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();

		if (Y41bConstantes.DECISION_INSPECCIONES_ARCHIVO_AIP.equals(tramiteINSArchivoAIP.getTipoDecision())) {
			if (tramiteINSArchivoAIP != null && tramiteINSArchivoAIP.getTidestinatario() != null && tramiteINSArchivoAIP
					.getTidestinatario().equals(Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTOVISITADO)) {
				this.generarTramiteNotificacionEstablecimientoVisitadoArchivoAIP(tramiteINSArchivoAIP, tramiteComun);
			} else if (tramiteINSArchivoAIP != null && tramiteINSArchivoAIP.getTidestinatario() != null
					&& tramiteINSArchivoAIP.getTidestinatario()
							.equals(Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTORESPONSABLE)) {
				this.generarTramiteNotificacionEstablecimientoResponsableArchivoAIP(tramiteINSArchivoAIP, tramiteComun);
			}

		}

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Registro de Decisin
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteComunicacionNotificacionProductoresRegistroDecision(
			TramiteRegistroDecision tramiteRegistroDecision, TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ORGANISMO_PRODUCTOR);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				if (documentodecision.getQ5destino().equals(Y41bConstantes.DESTINO_RESOL_OTROS)) {
					documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
					documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Registro de Inspeccin
	 * 
	 * @param tramiteRegistroSolicitud
	 *            TramiteRegistroSolicitud
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteComunicacionRegistroInspeccion(
			TramiteRegistroSolicitud tramiteRegistroSolicitud, TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ORGANISMO_PRODUCTOR);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Comunicacion desde Remision Muestras Al
	 * Laboratorio
	 * 
	 * @param tramiteRemisionMuestrasAlLaboratorio
	 *            TramiteINSRemisionMuestrasAlLaboratorio
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteComunicacionRemisionMuestrasAlLaboratorio(
			TramiteINSRemisionMuestrasAlLaboratorio tramiteRemisionMuestrasAlLaboratorio, TramiteComun tramiteComun)
			throws Exception {

		// Aadir el interviniente
		// Buscar si tiene el laboratorio introducido como interviniente.
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setEntidadId(tramiteRemisionMuestrasAlLaboratorio.getTilacodigo());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_LABORATORIO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		Laboratorio laboratorio = new Laboratorio();
		laboratorio.setLacodigo(tramiteRemisionMuestrasAlLaboratorio.getTilacodigo());
		laboratorio = this.laboratorioDao.find(laboratorio);

		if (listIntervinientes.size() > 0) {
			// Actualizacion del interviniente del organismo.
			Intervinientes intervinientesAux = new Intervinientes(listIntervinientes.get(0).getIdinterviniente(), null,
					null, laboratorio.getLacodigo(), laboratorio.getLanombre(), null, null, null, null, null, null,
					null, null, null, null, null, laboratorio.getLanrtel(), null, laboratorio.getLamail(), null,
					laboratorio.getNoraProvinciaId(), laboratorio.getNombreProvincia(),
					laboratorio.getNoraMunicipioId(), laboratorio.getNombreMunicipio(),
					laboratorio.getNoraLocalidadId(), laboratorio.getNombreLocalidad(), laboratorio.getNoraCalleId(),
					laboratorio.getNombreCalle(), laboratorio.getNoraCpId(), laboratorio.getNombreCp(),
					laboratorio.getNoraPortalId(), laboratorio.getNombrePortal(), laboratorio.getNombrePiso(),
					laboratorio.getNoraPaisId(), laboratorio.getNombrePais(), laboratorio.getDireccionNocapv(), null,
					null, null, null, null, Y41bConstantes.TIPO_INTERVINIENTE_LABORATORIO,
					tramiteComun.getIdExpediente(), null, null, null, null);

			this.intervinientesDao.update(intervinientesAux);
		} else {
			// Alta como interviniente del organismo.
			Intervinientes intervinientesAux = new Intervinientes(
					Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, null,
					laboratorio.getLacodigo(), laboratorio.getLanombre(), null, null, null, null, null, null, null,
					null, null, null, null, laboratorio.getLanrtel(), null, laboratorio.getLamail(), null,
					laboratorio.getNoraProvinciaId(), laboratorio.getNombreProvincia(),
					laboratorio.getNoraMunicipioId(), laboratorio.getNombreMunicipio(),
					laboratorio.getNoraLocalidadId(), laboratorio.getNombreLocalidad(), laboratorio.getNoraCalleId(),
					laboratorio.getNombreCalle(), laboratorio.getNoraCpId(), laboratorio.getNombreCp(),
					laboratorio.getNoraPortalId(), laboratorio.getNombrePortal(), laboratorio.getNombrePiso(),
					laboratorio.getNoraPaisId(), laboratorio.getNombrePais(), laboratorio.getDireccionNocapv(), null,
					null, null, null, null, Y41bConstantes.TIPO_INTERVINIENTE_LABORATORIO,
					tramiteComun.getIdExpediente(), null, null, null, null);

			this.intervinientesDao.add(intervinientesAux);
		}

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		// buscar el interviniente
		intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setEntidadId(tramiteRemisionMuestrasAlLaboratorio.getTilacodigo());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_LABORATORIO);

		listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// Hay que relacionar los documentos del tramite con la comunicacion
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentos = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentos != null && documentos.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documento : documentos) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
				documentoTramiteHecho.setCodocumento(documento.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Registro de Decisin
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteNotificacionEstablecimientoVisitadoRegistroDecision(
			TramiteRegistroDecision tramiteRegistroDecision, TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramiteInspeccion.setTitiponotificacionplatea(Y41bConstantes.NOTIFICACION_RESOLUCION);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				if (documentodecision.getQ5destino().equals(Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTOVISITADO)) {
					documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
					documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Archivo AIP
	 * 
	 * @param tramiteINSArchivoAIP
	 *            TramiteINSArchivoAIP
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteNotificacionEstablecimientoVisitadoArchivoAIP(
			TramiteINSArchivoAIP tramiteINSArchivoAIP, TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramiteInspeccion.setTitiponotificacionplatea(Y41bConstantes.NOTIFICACION_RESOLUCION);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				if (documentodecision.getQ5destino().equals(Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTOVISITADO)) {
					documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
					documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Registro de Decisin
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteNotificacionEstablecimientoResponsableRegistroDecision(
			TramiteRegistroDecision tramiteRegistroDecision, TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramiteInspeccion.setTitiponotificacionplatea(Y41bConstantes.NOTIFICACION_RESOLUCION);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				if (documentodecision.getQ5destino().equals(Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTORESPONSABLE)) {
					documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
					documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Automatico de Notificacion desde Archivo AIP
	 * 
	 * @param tramiteINSArchivoAIP
	 *            TramiteINSArchivoAIP
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteNotificacionEstablecimientoResponsableArchivoAIP(
			TramiteINSArchivoAIP tramiteINSArchivoAIP, TramiteComun tramiteComun) throws Exception {

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(tramiteComun.getIdExpediente());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);

		tramiteInspeccion.setTienvrem(Y41bConstantes.VALOR_SI);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());

		tramiteInspeccion.setTicomoasignado(obtenerResponsableExpediente(tramiteComun));
		tramiteInspeccion.setTicomentario("");

		tramiteInspeccion.setTifechacomunicacion(new Date());

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			tramiteInspeccion.setTiiddestinatario(listIntervinientes.get(0).getIdinterviniente());
		}

		tramiteInspeccion.setTitiponotificacionplatea(Y41bConstantes.NOTIFICACION_RESOLUCION);

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteComun.getIdTramite());
		tramiteInspeccion.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		// 1.2 Hay que relacionar los documentos de la decision con
		DocumentoHecho documentoHechoAux = new DocumentoHecho();
		documentoHechoAux.setQ5hdcodigo(tramiteComun.getIdExpediente());
		documentoHechoAux.setQ5tramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> documentosdecision = this.documentoHechoDao.findAll(documentoHechoAux, null);
		// Relaciono tramite - documento
		if (documentosdecision != null && documentosdecision.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentodecision : documentosdecision) {
				if (documentodecision.getQ5destino().equals(Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTORESPONSABLE)) {
					documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setEhcodigo(tramiteInspeccion.getTicodigo());
					documentoTramiteHecho.setCodocumento(documentodecision.getQ5codocumento());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Generar Tramite Generico de reapertura de expediente
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private TramiteInspeccion generarTramiteGenericoReabrirExpediente(InspeccionDetalle inspeccionDetalle,
			CensoMonitor censoMonitor) throws Exception {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccion.setTiatcodigo(inspeccionDetalle.getAtcodigo());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_GENERICO);

		// Ponemos en la fecha de inicio la fecha en la que se genera
		tramiteInspeccion.setTifechainicio(new Date());
		tramiteInspeccion.setTifechafin(new Date());

		tramiteInspeccion.setTicomoasignado(censoMonitor.getMocodigo());
		tramiteInspeccion.setTicomoejecucion(censoMonitor.getMocodigo());

		tramiteInspeccion.setTinombretramite(Y41bConstantes.NOMBRE_TRAMITE_GENERICO_REAPERTURA);

		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/*********
	 * OTROS *
	 *********/

	/**
	 * Finds registro entrada document
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @return RegistroEntrada
	 * @throws Exception
	 *             Exception
	 */
	public RegistroEntrada getRegistroEntrada(TramiteComun tramiteComun, Intervinientes intervinientes)
			throws Exception {

		RegistroEntrada registroEntrada = new RegistroEntrada();

		WSParamInputRegisterEx datas = new WSParamInputRegisterEx();

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteComun.getIdExpediente());
		actuacion = this.actuacionDao.find(actuacion);

		if (actuacion.getActa().getAccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
		} else if (actuacion.getActa().getAccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
		} else if (actuacion.getActa().getAccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
		} else if (actuacion.getActa().getAccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
		}

		ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

		Intervinientes intervinientesDatos = new Intervinientes();
		intervinientesDatos.setIdinterviniente(intervinientes.getIdinterviniente());
		intervinientesDatos = this.intervinientesDao.find(intervinientesDatos);

		WSParamPerson wSParamPerson = new WSParamPerson();
		StringBuffer sbPerson = new StringBuffer();
		if (Y41bUtils.isFilled(intervinientesDatos.getNif())) {
			sbPerson.append(intervinientesDatos.getNif());
			sbPerson.append(" - ");
		}
		if (Y41bUtils.isFilled(intervinientesDatos.getEsnoco())) {
			sbPerson.append(intervinientesDatos.getEsnoco());
			sbPerson.append(" ");
		} else {
			if (Y41bUtils.isFilled(intervinientesDatos.getNombre())) {
				sbPerson.append(intervinientesDatos.getNombre());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(intervinientesDatos.getApellido1())) {
				sbPerson.append(intervinientesDatos.getApellido1());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(intervinientesDatos.getApellido2())) {
				sbPerson.append(intervinientesDatos.getApellido2());
				sbPerson.append(" ");
			}
		}

		wSParamPerson.setPersonName(sbPerson.toString());

		persons.getWSParamPerson().add(wSParamPerson);

		datas.setPersons(persons);

		StringBuffer sbMatter = new StringBuffer();
		sbMatter.append(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		sbMatter.append(" - [").append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-")
				.append(actuacion.getActa().getAccoor()).append("-").append(actuacion.getActa().getAcnror()).append("-")
				.append(actuacion.getActa().getAcnran()).append("-").append(actuacion.getAtnror());
		sbMatter.append("]");
		datas.setMatter(sbMatter.toString());

		N61ServiceImpl n61Service = new N61ServiceImpl();
		WSInputRegister wSInputRegister = n61Service.wsNewInputRegister(datas);

		registroEntrada.setRegistryNumber(wSInputRegister.getNumber());
		registroEntrada.setRegistryDate(wSInputRegister.getDate().toGregorianCalendar().getTime());

		return registroEntrada;
	}

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addTramiteAdjuntarDocsTableTemporal(TramiteComun tramiteComun) {
		this.adjuntardocsDao.removeAllAdjuntarDocs(tramiteComun);
		this.documentoHechoDao.addAdjuntarDocs(tramiteComun);
	}

	/**
	 * Inserta las infracciones en la tabla temporal de adjuntar infracciones
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addTramiteAdjuntarActaInfraccTableTemporal(TramiteComun tramiteComun) {
		this.adjunInfraccHechoDenunDao.removeAllAdjuntarInfracciones(tramiteComun);
		this.infraccHechoDenDao.addAdjuntarInfraccionesControlMercado(tramiteComun);
	}

	/**
	 * Esta funcion actualiza el ultimo tramite ejecutado para Inspecciones CASO
	 * ESPECIAL PARA TRAMITE CIERRE (AL GUARDAR)
	 * 
	 * @param idExpediente
	 *            String
	 */
	public void actualizarUltimoTramiteCierreGuardar(String idExpediente) {
		// 1. Actualizo la fase del expediente
		Date hfffin = new Date();
		String faseExpediente = "";
		/*
		 * if (Y41bUtils.isFilled(idExpediente)) { Actuacion actuacion = new
		 * Actuacion(); actuacion.setAtcodigo(idExpediente);
		 * 
		 * InspeccionDetalle inspeccionDetalle = this.actaDao
		 * .findInspeccion(actuacion);
		 * 
		 * faseExpediente = inspeccionDetalle.getFcodigo(); }
		 */
		// 1.1 Cerramos (fechafin) la fase del expediente en el historico de
		// fases
		boolean crearNewFaseCierre = false;
		if (Y41bUtils.isFilled(faseExpediente)) {
			Historicofases historicotrejecutadoAux = new Historicofases();
			historicotrejecutadoAux.setHfhdcodigo(idExpediente);
			List<Historicofases> historicotrejecutadoList = this.historicofasesService
					.findAllFasesHistoricoAbiertas(historicotrejecutadoAux);
			if (historicotrejecutadoList != null && historicotrejecutadoList.size() > 0) {
				for (Historicofases historicotrejecutado : historicotrejecutadoList) {
					if (!Y41bConstantes.FASE_CIERRE.equals(historicotrejecutado.getHffcodigo())) {
						if (historicotrejecutado.getHfffin() == null) {
							historicotrejecutado.setHfffin(hfffin);
							this.historicofasesService.updateFechaFin(historicotrejecutado);
							crearNewFaseCierre = true;
						}
					}
				}
			}
		}
		// 1.2 Miramos si existe en el historico de fases una fase de
		// cierre.
		if (crearNewFaseCierre) {
			Historicofases historicotrcierre = new Historicofases();
			historicotrcierre.setHfhdcodigo(idExpediente);
			historicotrcierre.setHffcodigo(Y41bConstantes.FASE_CIERRE);
			historicotrcierre.setHffinicio(new Date());
			historicotrcierre.setHfffin(null);
			this.historicofasesService.add(historicotrcierre);
		}
		// 2. Calculo si el tramite ejecutado es generico o no es generico
		Tramite tramiteEjecutado = new Tramite();
		tramiteEjecutado.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE);
		tramiteEjecutado = this.tramiteDao.find(tramiteEjecutado);

		String faseTramiteEjecutado = tramiteEjecutado.getFase().getFcodigo();

		Actuacion actuacionAux = new Actuacion();
		actuacionAux.setAtcodigo(idExpediente);
		actuacionAux.setFcodigoactual(faseTramiteEjecutado);
		actuacionAux.setTrcodigoactual(Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE);

		this.actuacionDao.updateUltimoTramiteConFaseGenerico(actuacionAux);
	}

	/**
	 * Esta funcion actualiza el historico de fases del expediente a partir de
	 * los tramites ejecutados y generados. Cubre los casos siempre que el
	 * tramite ejecutado no genere automaticamente tramites (que no sean el
	 * codTramiteGenerado): - NO GENERICOS - CON CAMBIO DE FASE. Esta funcion no
	 * contempla el caso de Registro de Solicitud ya que es especial y no usa
	 * esta funcionalidad.
	 * 
	 * @param codTramiteEjecutado
	 *            String
	 * @param codTramiteGenerado
	 *            String
	 * @param idExpediente
	 *            String
	 */
	/*
	 * private void actualizarHistoricoFases(String codTramiteEjecutado, String
	 * codTramiteGenerado, String idExpediente) {
	 * InstramexpServiceImpl.logger.info("ActualizarHistoricoFases Ini"); Date
	 * hfffin = new Date(); String faseExpediente = ""; String
	 * faseTramiteEjecutado = ""; String faseTramiteGenerado = ""; // 1.
	 * Recuperamos las fases que vamos a necesitar // 1.1 Recuperamos la fase
	 * actual del expediente if (Y41bUtils.isFilled(idExpediente)) { Actuacion
	 * actuacion = new Actuacion(); actuacion.setAtcodigo(idExpediente);
	 * 
	 * Acta acta = this.actaDao.findActuacion(actuacion); faseExpediente =
	 * acta.getFcodigo(); }
	 * 
	 * // 1.2 Recuperamos la fase del tramite ejecutado if
	 * (Y41bUtils.isFilled(codTramiteEjecutado)) { Tramite tramiteEjecutado =
	 * new Tramite(); tramiteEjecutado.setTrcodigo(codTramiteEjecutado);
	 * tramiteEjecutado = this.tramiteDao.find(tramiteEjecutado); if
	 * (tramiteEjecutado.getFase() != null &&
	 * Y41bUtils.isFilled(tramiteEjecutado.getFase() .getFcodigo())) {
	 * faseTramiteEjecutado = tramiteEjecutado.getFase().getFcodigo(); } } //
	 * 1.3 Recuperamos la fase del tramite generado if
	 * (Y41bUtils.isFilled(codTramiteGenerado)) { Tramite tramiteGenerado = new
	 * Tramite(); tramiteGenerado.setTrcodigo(codTramiteGenerado);
	 * tramiteGenerado = this.tramiteDao.find(tramiteGenerado); if
	 * (tramiteGenerado.getFase() != null &&
	 * Y41bUtils.isFilled(tramiteGenerado.getFase() .getFcodigo())) {
	 * faseTramiteGenerado = tramiteGenerado.getFase().getFcodigo(); } }
	 * 
	 * if (Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE
	 * .equals(codTramiteEjecutado)) { // Cuando se da a tramitar el Cierre //
	 * 2.1 Cerramos (fechafin) la fase del expediente en el historico de //
	 * fases boolean ultimoTramiteAbiertoCierre = false; if
	 * (Y41bUtils.isFilled(faseExpediente)) { Historicofases
	 * historicotrexpedienteAux = new Historicofases();
	 * historicotrexpedienteAux.setHfhdcodigo(idExpediente);
	 * List<Historicofases> historicotrexpedienteList =
	 * this.historicofasesService
	 * .findAllFasesHistoricoAbiertas(historicotrexpedienteAux); if
	 * (historicotrexpedienteList != null && historicotrexpedienteList.size() >
	 * 0) { for (Historicofases historicotrexpediente :
	 * historicotrexpedienteList) { if (historicotrexpediente.getHfffin() ==
	 * null) { historicotrexpediente.setHfffin(hfffin);
	 * this.historicofasesService .updateFechaFin(historicotrexpediente); } if
	 * (Y41bConstantes.FASE_CIERRE
	 * .equals(historicotrexpediente.getHffcodigo())) {
	 * ultimoTramiteAbiertoCierre = true; } } } } // 2.2 Miramos si existe en el
	 * historico de fases una fase de // cierre. if
	 * (!ultimoTramiteAbiertoCierre) { Historicofases historicotrcierre = new
	 * Historicofases(); historicotrcierre.setHfhdcodigo(idExpediente);
	 * historicotrcierre.setHffcodigo(Y41bConstantes.FASE_CIERRE);
	 * historicotrcierre.setHffinicio(new Date());
	 * historicotrcierre.setHfffin(new Date());
	 * this.historicofasesService.add(historicotrcierre); } } else { // 3.1
	 * Comparamos la fase del expediente con la fase del tramite // ejecutado if
	 * (faseExpediente != null && Y41bUtils.isFilled(faseTramiteEjecutado)) { //
	 * Si son diferentes if (!faseExpediente.equals(faseTramiteEjecutado)) { //
	 * - Cerramos (fechafin) la fase del expediente en el // historico de fases
	 * if (Y41bUtils.isFilled(faseExpediente)) { Historicofases
	 * historicotrexpedienteAux = new Historicofases();
	 * historicotrexpedienteAux.setHfhdcodigo(idExpediente);
	 * List<Historicofases> historicotrexpedienteList =
	 * this.historicofasesService
	 * .findAllFasesHistoricoAbiertas(historicotrexpedienteAux); if
	 * (historicotrexpedienteList != null && historicotrexpedienteList.size() >
	 * 0) { for (Historicofases historicotrexpediente :
	 * historicotrexpedienteList) { if (historicotrexpediente.getHfffin() ==
	 * null) { historicotrexpediente.setHfffin(hfffin);
	 * this.historicofasesService .updateFechaFin(historicotrexpediente); } } }
	 * } // - Creamos una nueva fase (tramite ejecutado) Historicofases
	 * historicoejecutadotr = new Historicofases();
	 * historicoejecutadotr.setHfhdcodigo(idExpediente);
	 * historicoejecutadotr.setHffcodigo(faseTramiteEjecutado);
	 * historicoejecutadotr.setHffinicio(new Date());
	 * historicoejecutadotr.setHfffin(null);
	 * this.historicofasesService.add(historicoejecutadotr); } }
	 * 
	 * // 3.2 Comparamos la fase del tramite ejecutado con la fase del //
	 * tramite generado if (Y41bUtils.isFilled(faseTramiteGenerado)) { // Si son
	 * diferentes if (!faseTramiteEjecutado.equals(faseTramiteGenerado)) { // -
	 * Cerramos (fechafin) la fase del tramite ejecutado en el // historico de
	 * fases if (Y41bUtils.isFilled(faseTramiteEjecutado)) { Historicofases
	 * historicotrejecutadoAux = new Historicofases();
	 * historicotrejecutadoAux.setHfhdcodigo(idExpediente); List<Historicofases>
	 * historicotrejecutadoList = this.historicofasesService
	 * .findAllFasesHistoricoAbiertas(historicotrejecutadoAux); if
	 * (historicotrejecutadoList != null && historicotrejecutadoList.size() > 0)
	 * { for (Historicofases historicotrejecutado : historicotrejecutadoList) {
	 * if (historicotrejecutado.getHfffin() == null) {
	 * historicotrejecutado.setHfffin(hfffin); this.historicofasesService
	 * .updateFechaFin(historicotrejecutado); } } } } // - Creamos una nueva
	 * fase (tramite generado) Historicofases historicogeneradotr = new
	 * Historicofases(); historicogeneradotr.setHfhdcodigo(idExpediente);
	 * historicogeneradotr.setHffcodigo(faseTramiteGenerado);
	 * historicogeneradotr.setHffinicio(new Date());
	 * historicogeneradotr.setHfffin(null);
	 * this.historicofasesService.add(historicogeneradotr); } } }
	 * InstramexpServiceImpl.logger.info("ActualizarHistoricoFases Fin"); }
	 */

	/**
	 * Extrae el origen de una inspeccion segun su id de tramite.
	 * 
	 * @param idTramite
	 *            String
	 * @return String
	 */
	public String findOrigenInspeccionPorIdTramite(String idTramite) {

		TramiteInspeccion tramite = new TramiteInspeccion();
		tramite.setTicodigo(idTramite);
		Actuacion actuacion = this.actuacionDao.findOrigenInspeccionPorIdTramite(tramite);

		Locale locale = LocaleContextHolder.getLocale();

		return this.formarOrigen(actuacion, locale);
	}

	/**
	 * Extrae el origen de una inspeccion segun su id de tramite.
	 * 
	 * @param idTramite
	 *            String
	 * @param locale
	 *            Locale
	 * @return String
	 */
	public String findOrigenInspeccionPorIdExpediente(String atcodigo, Locale locale) {

		TramiteInspeccion tramite = new TramiteInspeccion();
		tramite.setTiatcodigo(atcodigo);
		Actuacion actuacion = this.actuacionDao.findOrigenInspeccionPorIdExpediente(tramite);

		return this.formarOrigen(actuacion, locale);
	}

	/**
	 * Forma la cadena generada en findOrigenInspeccionPorIdExpediente y
	 * findOrigenInspeccionPorIdTramite.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return String
	 */
	private String formarOrigen(Actuacion actuacion, Locale locale) {
		String origenInspeccion = null;

		if (actuacion.getAtcocm() != null && !"".equals(actuacion.getAtcocm())) {
			origenInspeccion = this.appMessageSource.getMessage("inspecciones.origenInspeccion.campanha", null, locale)
					+ " " + actuacion.getAtcocm();
		} else if (actuacion.getAtcoal() != null && !"".equals(actuacion.getAtalerta())) {
			origenInspeccion = this.appMessageSource.getMessage("inspecciones.origenInspeccion.alerta", null, locale)
					+ " " + actuacion.getAtalerta();
		} else if (actuacion.getV6codigo() != null && !"".equals(actuacion.getV6codigo())) {
			origenInspeccion = this.appMessageSource.getMessage("inspecciones.origenInspeccion.soivre", null, locale)
					+ " " + actuacion.getV6codigo();
		} else if (actuacion.getAtsolicitud() != null && !"".equals(actuacion.getAtsolicitud())) {
			if (actuacion.getAthdtipodenunciante() == null || "".equals(actuacion.getAthdtipodenunciante())) {
				origenInspeccion = this.appMessageSource.getMessage("inspecciones.origenInspeccion.solicitud", null,
						locale) + " " + actuacion.getAtsolicitud();
			} else {
				origenInspeccion = this.appMessageSource.getMessage("inspecciones.origenInspeccion.denuncia", null,
						locale) + " " + actuacion.getAtsolicitud();
			}
		} else if (actuacion.getActa() != null && actuacion.getActa().getActiororigen() != null
				&& Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA
						.equals(actuacion.getActa().getActiororigen())) {
			origenInspeccion = this.appMessageSource.getMessage("inspecciones.origenInspeccion.comunicacionesExternas",
					null, locale);

		} else if (actuacion.getActa() != null && actuacion.getActa().getActiororigen() != null
				&& Y41bConstantes.INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES
						.equals(actuacion.getActa().getActiororigen())) {
			origenInspeccion = this.appMessageSource.getMessage("inspecciones.origenInspeccion.notificacionProductores",
					null, locale);

		} else {
			origenInspeccion = this.appMessageSource.getMessage("inspecciones.origenInspeccion.oficio", null, locale);
		}

		return origenInspeccion;
	}

	/**
	 * Extrae el codigo de origen de una inspeccion segun su id de expediente.
	 * 
	 * @param atcodigo
	 *            String
	 * @return String
	 */
	public String findCodOrigenInspeccionPorIdExpediente(String atcodigo) {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);

		actuacion = this.actuacionDao.find(actuacion);

		String codOrigenInspeccion = null;

		if (actuacion.getAtcocm() != null && !"".equals(actuacion.getAtcocm())) {
			codOrigenInspeccion = Y41bConstantes.INSPECCIONES_ORIGEN_CAMPANHA;
		} else if (actuacion.getAtcoal() != null && !"".equals(actuacion.getAtcoal())) {
			codOrigenInspeccion = Y41bConstantes.INSPECCIONES_ORIGEN_ALERTA;
		} else if (actuacion.getAtidcomunicacionsoivre() != null && !"".equals(actuacion.getAtidcomunicacionsoivre())) {
			codOrigenInspeccion = Y41bConstantes.INSPECCIONES_ORIGEN_SOIVRE;
		} else if (actuacion.getAtcohd() != null && !"".equals(actuacion.getAtcohd())) {
			if (actuacion.getAtcohddenuncia() != null
					&& Y41bConstantes.VALOR_SI.equals(actuacion.getAtcohddenuncia())) {
				codOrigenInspeccion = Y41bConstantes.INSPECCIONES_ORIGEN_DENUNCIA;
			} else {
				codOrigenInspeccion = Y41bConstantes.INSPECCIONES_ORIGEN_SOLICITUD;
			}
		} else {
			if (actuacion.getActa() != null && actuacion.getActa().getActiororigen() != null
					&& Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA
							.equals(actuacion.getActa().getActiororigen())) {
				codOrigenInspeccion = Y41bConstantes.INSPECCIONES_ORIGEN_COMUNICACION_EXTERNA;
			} else if (actuacion.getActa() != null && actuacion.getActa().getActiororigen() != null
					&& Y41bConstantes.INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES
							.equals(actuacion.getActa().getActiororigen())) {
				codOrigenInspeccion = Y41bConstantes.INSPECCIONES_ORIGEN_NOTIFICACION_PRODUCTORES;
			} else {
				codOrigenInspeccion = Y41bConstantes.INSPECCIONES_ORIGEN_OFICIO;
			}
		}

		return codOrigenInspeccion;
	}

	/**
	 * Extrae el numero de expediente de una inspeccion segun su id de
	 * expediente.
	 * 
	 * @param idExpediente
	 *            String
	 * @return String
	 */
	public String findNumExpedienteActuacion(String idExpediente) {
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(idExpediente);
		actuacion = this.actuacionDao.find(actuacion);
		if (actuacion != null) {
			return Y41bConstantes.TIPO_PROC_INSPECCIONES + "-" + actuacion.getActa().getAccoor() + "-"
					+ actuacion.getActa().getAcnror() + "-" + actuacion.getActa().getAcnran() + "-"
					+ actuacion.getAtnror();
		} else {
			return null;
		}
	}

	/**
	 * Metodo que devuelve true si tiene permiso de modificacion, false si no
	 * tiene permiso de modificacion
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 */
	public boolean tratamientoSeguridad(TramiteInspeccion tramiteInspeccion, CensoMonitor censoMonitor) {
		// obtener la inspeccion
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteInspeccion.getTiatcodigo());

		InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

		if (censoMonitor == null) {
			return false;
		}

		// Si la campaa est inactiva no se podr modificar
		if (Y41bUtils.isFilled(inspeccionDetalle.getAtcocm())) {
			// buscar campaa
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(inspeccionDetalle.getAtcocm());
			Campanha campanhaAux = this.campanhaDao.find(campanha);

			// Si es distinto de activa return false
			if (campanhaAux != null && (!Y41bUtils.isFilled(campanhaAux.getCmactiva())
					|| !campanhaAux.getCmactiva().equals(Y41bConstantes.VALOR_SI))) {
				return false;
			}
		}

		// Si la alerta est inactiva no se podr modificar
		if (Y41bUtils.isFilled(inspeccionDetalle.getAtcoal())) {
			// buscar alerta
			Alerta alerta = new Alerta();
			alerta.setAlcodigo(inspeccionDetalle.getAtcoal());
			Alerta alertaAux = this.alertaDao.find(alerta);

			// Si es distinto de activa return false
			if (alertaAux != null && (!Y41bUtils.isFilled(alertaAux.getAlactiva())
					|| !alertaAux.getAlactiva().equals(Y41bConstantes.VALOR_SI))) {
				return false;
			}
		}

		// Miro si la inspeccion esta cerrada
		if (inspeccionDetalle.getAtfechacierre() != null) {
			return false;
		}

		if (tramiteInspeccion != null && tramiteInspeccion.getTicotee()
				.equals(Y41bConstantes.TRAMITE_INSPECCIONES_INFORMACION_PUBLICACION_BOPV_BOE)) {

			if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
				return true;
			} else {
				return false;
			}
		}

		if (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
			return true;
		}

		// **********************************************
		// INICIO TRAMITES CONTROL MERCADO
		// **********************************************
		// Si la inspeccion es con origen solicitudes
		if (Y41bUtils.isFilled(inspeccionDetalle.getAtcohd())) {
			if (tramiteInspeccion.getTicotee()
					.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REVISION_INCLUSION_EN_RED_DE_ALERTA)
					|| tramiteInspeccion.getTicotee()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_RED_DE_ALERTA)) {
				// revisar si es control mercado
				if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
					return true;
				} else {
					return false;
				}
			}
			// Si la inspeccion es de oficio
		} else if (inspeccionDetalle.getAtcocm() == null && inspeccionDetalle.getAtcoal() == null
				&& inspeccionDetalle.getAtidcomunicacionsoivre() == null && inspeccionDetalle.getAtcohd() == null
				&& inspeccionDetalle.getActiororigen() == null) {
			if (tramiteInspeccion.getTicotee()
					.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REVISION_INCLUSION_EN_RED_DE_ALERTA)
					|| tramiteInspeccion.getTicotee()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_RED_DE_ALERTA)) {
				// revisar si es control mercado
				if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
					return true;
				} else {
					return false;
				}
			}
		} else {
			if (tramiteInspeccion != null && (tramiteInspeccion.getTicotee()
					.equals(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO)
					|| tramiteInspeccion.getTicotee()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_RESOLUCION_ACUERDO_INICIO_PROCEDIMIENTO)
					|| tramiteInspeccion.getTicotee()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REVISION_INCLUSION_EN_RED_DE_ALERTA)
					|| tramiteInspeccion.getTicotee()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_RED_DE_ALERTA)
					|| tramiteInspeccion.getTicotee()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_ELABORACION_INFORME_PARA_ASESORIA)
					|| tramiteInspeccion.getTicotee()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ORDEN_DEL_CONSEJERO)
					|| tramiteInspeccion.getTicotee()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ALEGACIONES))) {
				// revisar si es control mercado
				if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
					return true;
				} else {
					return false;
				}
			}

			if (tramiteInspeccion != null
					&& tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_ARCHIVO_AIP)) {
				if (Y41bConstantes.VALOR_SI.equals(inspeccionDetalle.getAtacuerdoinicio())) {
					// revisar si es control mercado
					if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
						return true;
					}
				}

				// buscar tramite de acuerdo de inicio procedimiento
				TramiteInspeccionDetalle tramiteInspeccionAux = new TramiteInspeccionDetalle();
				tramiteInspeccionAux.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);
				tramiteInspeccionAux.setAtcodigo(tramiteInspeccion.getTiatcodigo());
				try {
					tramiteInspeccionAux = this.tramiteInspeccionDao
							.findUltimoTramiteHechoPorTipoTramite(tramiteInspeccionAux);
				} catch (Exception e) {
				}

				// si existe solo puede tramitar SSCC, el resto no.
				if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTicodigo() != null) {

					// revisar si es control mercado
					if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
						return true;
					} else {
						return false;
					}

				}
			}

			// Comunicacin del informe a asesoria (tramite de comunicacin
			// relacionado con el tramite de elaboracion informe asesoria)
			if (tramiteInspeccion != null
					&& tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION)) {
				TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
				tramiteinspeccion.setTicodigo(tramiteInspeccion.getTicodigo());

				tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

				if (tramiteinspeccion != null && tramiteinspeccion.getTramiteInspeccion() != null
						&& tramiteinspeccion.getTramiteInspeccion().getTicodigo() != null) {

					if (tramiteinspeccion.getTramiteInspeccion() != null
							&& tramiteinspeccion.getTramiteInspeccion().getTicotee() != null
							&& tramiteinspeccion.getTramiteInspeccion().getTicotee()
									.equals(Y41bConstantes.TRAMITE_INSPECCIONES_ELABORACION_INFORME_PARA_ASESORIA)) {
						// revisar si es control mercado
						if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
							return true;
						} else {
							return false;
						}
					}
				}
			}

			if (tramiteInspeccion != null
					&& (tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_ORDEN_SERVICIO))) {
				// revisar si es control mercado
				if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
					return true;
				}
			}

			if (tramiteInspeccion != null && (tramiteInspeccion.getTicotee()
					.equals(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICAR_NUEVO_DISTRIBUIDOR))) {
				// revisar si es control mercado
				if (censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
					return true;
				}
			}

		}

		// **********************************************
		// FIN TRAMITES CONTROL MERCADO
		// **********************************************

		// comprobar si el organismo propietario del expediente es igual al
		// organismo del usuario conectado
		if (inspeccionDetalle != null
				&& inspeccionDetalle.getAdcoor().equals(censoMonitor.getOrganismo().getCodOrg())) {
			Tramite tramite = new Tramite();
			tramite.setTrcodigo(tramiteInspeccion.getTicotee());

			tramite = this.tramiteDao.find(tramite);

			if (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
				if (inspeccionDetalle.getMocodigo() != null
						&& !inspeccionDetalle.getMocodigo().equals(censoMonitor.getMocodigo())) {
					return false;
				}
			}

			if (tramite != null && tramite.getIdPerfil() != null) {
				if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO) && (censoMonitor
						.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)
						|| censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
						|| censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
						|| censoMonitor.getPerfilInspecciones().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO)
						|| censoMonitor.getPerfilInspecciones().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
					return true;
				} else if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR) && (censoMonitor
						.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
						|| censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
						|| censoMonitor.getPerfilInspecciones().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO)
						|| censoMonitor.getPerfilInspecciones().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SUPERVISOR))) {

					if (tramiteInspeccion != null
							&& tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_ARCHIVO_AIP)) {
						if (Y41bConstantes.VALOR_SI.equals(inspeccionDetalle.getAtacuerdoinicio())) {
							return false;
						} else {
							return true;
						}
					} else {
						return true;
					}
				} else if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
						&& (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
								|| censoMonitor.getPerfilInspecciones().getIdPerfil()
										.equals(Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO)
								|| censoMonitor.getPerfilInspecciones().getIdPerfil()
										.equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			// si el usuario conectado tiene perfil de supervisior, le damos
			// permiso para modificar
			if (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				return true;
			} else {
				return false;
			}
		}
	}

	/**
	 * Metodo que devuelve true si tiene permiso de modificacion, false si no
	 * tiene permiso de modificacion
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 */
	private boolean tratamientoPermisoTramitar(TramiteInspeccion tramiteInspeccion, CensoMonitor censoMonitor) {
		if (censoMonitor == null) {
			return false;
		}

		if (tramiteInspeccion.getTramiteInspeccion() != null
				&& tramiteInspeccion.getTramiteInspeccion().getTicodigo() != null) {
			if (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)
					|| censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
					|| censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					|| censoMonitor.getPerfilInspecciones().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO)
					|| censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				return true;
			} else {
				return false;
			}

		} else {
			if (censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)
					|| censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
					|| censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					|| censoMonitor.getPerfilInspecciones().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO)
					|| censoMonitor.getPerfilInspecciones().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				return true;
			} else {
				return false;
			}
		}
	}

	private boolean validarSiTramiteInspeccionEstaCompleta(InspeccionDetalle inspeccionDetalle) {
		return inspeccionDetalle != null
				&& (inspeccionDetalle.getAcfere() == null || inspeccionDetalle.getAcfere().equals("")
						|| inspeccionDetalle.getEstablecimientoV().getEscodigo() == null
						|| inspeccionDetalle.getEstablecimientoV().getEscodigo().equals("")
						|| inspeccionDetalle.getAtformanotifestablecimientovi() == null
						|| inspeccionDetalle.getAtformanotifestablecimientovi().equals("")
						|| inspeccionDetalle.getAtcops() == null || inspeccionDetalle.getAtcops().equals("")
						|| inspeccionDetalle.getAtonline() == null || inspeccionDetalle.getAtonline().equals(""));
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los elimina en
	 * DOKUSI
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 */
	public void eliminarDocumentosDokusi(List<DocumentoExpediente> listDocumentoExpediente) throws SQLException {
		// Eliminamos los documentos de dokusi
		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			DocumentoHecho documentoHecho = null;
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				if (documentoExpediente != null && documentoExpediente.getIddocumentum() != null
						&& !documentoExpediente.getIddocumentum().equals("")) {

					documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5codocumento(documentoExpediente.getCodocumento());
					Long numTramitesUtilizado = this.documentoHechoDao.findAllDocTramiteHechoCount(documentoHecho);

					if (numTramitesUtilizado == 0) {
						Documento documento = new Documento();
						// 1.User
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoExpediente.getIddocumentum());
						documento.setBoolAllVersions("true");

						this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
					}
				}
			}
		}
	}

	/**
	 * Obtiene el responsable del expediente
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * 
	 * @return String
	 */
	private String obtenerResponsableExpediente(TramiteComun tramiteComun) {
		// Obtengo la informacion del expediente
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteComun.getIdExpediente());

		InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

		return inspeccionDetalle.getMocodigo();
	}

	/**
	 * Metodo que actualiza el estado de los tramites generados
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @throws SQLException
	 */
	private void calcularEstadoTramiteGenerado(TramiteInspeccion tramiteInspeccion) throws SQLException {
		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteInspeccion.getTiestadotramite())) {

			// Validacion: Debe haber almenos 1 documento
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteInspeccion.getTicodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
					null);

			boolean todosFirmados = true;
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					if (listDocumentoHecho.get(i).getQ5estadodocumento() != null && !listDocumentoHecho.get(i)
							.getQ5estadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO)) {
						todosFirmados = false;
						break;
					}
				}
			}
			if (todosFirmados) {
				boolean firmado = false;
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
					for (int i = 0; i < listDocumentoHecho.size(); i++) {
						if (listDocumentoHecho.get(i).getQ5estadodocumento() != null) {
							firmado = true;
							break;
						}
					}
				}

				if (firmado) {
					tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
				} else {
					tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				}

			} else {
				boolean pendienteFirma = false;
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
					for (int i = 0; i < listDocumentoHecho.size(); i++) {
						if (listDocumentoHecho.get(i).getQ5estadodocumento() != null) {
							pendienteFirma = true;
							break;
						}
					}
				}

				if (pendienteFirma) {
					tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
				} else {
					tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				}
			}
		}

		this.tramiteInspeccionDao.updateEstadoTramite(tramiteInspeccion);
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosAdjuntos(TramiteComun tramiteComun, Pagination pagination) {

		if (pagination.getSort() != null && pagination.getSort().equals("fecha")) {
			pagination.setSort("Q5FECHA");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("tedesfile")) {
			pagination.setSort("Q5TEDESFILE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("nofile")) {
			pagination.setSort("Q5NOFILE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("origen")) {
			pagination.setSort("Q5ORIGEN");
		}

		List<DocumentoExpediente> listDocumentoExpediente = (List<DocumentoExpediente>) this.documentoHechoDao
				.findAllDocumentosHechoInspeccionComunicacion(tramiteComun, pagination);

		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				documentoExpediente.setIncluidoComunicacion(Y41bConstantes.NO);
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
					for (DocumentoHecho documentoHecho : listDocumentoHecho) {
						if (documentoExpediente.getCodocumento().equals(documentoHecho.getQ5codocumento())) {
							documentoExpediente.setIncluidoComunicacion(Y41bConstantes.SI);
						}
					}
				}
			}
		}

		return listDocumentoExpediente;
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosAdjuntosOrigenExpediente(TramiteComun tramiteComun,
			Pagination pagination) {

		if (pagination.getSort() != null && pagination.getSort().equals("fecha")) {
			pagination.setSort("Q5FECHA");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("tedesfile")) {
			pagination.setSort("Q5TEDESFILE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("nofile")) {
			pagination.setSort("Q5NOFILE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("origen")) {
			pagination.setSort("Q5ORIGEN");
		}

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteComun.getIdExpediente());
		InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

		TramiteComun tramiteComunAux = new TramiteComun();

		if (Y41bUtils.isFilled(inspeccionDetalle.getAtcocm())) {
			tramiteComunAux.setIdExpediente(inspeccionDetalle.getAtcocm());
		} else if (Y41bUtils.isFilled(inspeccionDetalle.getAtcoal())) {
			tramiteComunAux.setIdExpediente(inspeccionDetalle.getAtcoal());
		} else if (Y41bUtils.isFilled(inspeccionDetalle.getAtidcomunicacionsoivre())) {
			tramiteComunAux.setIdExpediente(inspeccionDetalle.getAtidcomunicacionsoivre());
		}

		List<DocumentoExpediente> listDocumentoExpediente = (List<DocumentoExpediente>) this.documentoHechoDao
				.findAllDocumentosHechoInspeccionComunicacionOrigenExpediente(tramiteComunAux, pagination);

		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				documentoExpediente.setIncluidoComunicacion(Y41bConstantes.NO);
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
					for (DocumentoHecho documentoHecho : listDocumentoHecho) {
						if (documentoExpediente.getCodocumento().equals(documentoHecho.getQ5codocumento())) {
							documentoExpediente.setIncluidoComunicacion(Y41bConstantes.SI);
						}
					}
				}
			}
		}

		return listDocumentoExpediente;
	}

	/**
	 * Counts rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosAdjuntosOrigenExpedienteCount(TramiteComun tramiteComun) {
		return this.documentoHechoDao.findAllDocumentosAdjuntosOrigenExpedienteCount(tramiteComun);
	}

	/**
	 * Counts rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosAdjuntosCount(TramiteComun tramiteComun) {
		return this.documentoHechoDao.findAllDocumentosHechoInspeccionComunicacionCount(tramiteComun);
	}

	/**
	 * Metodo que obtiene el registro de salida en una comunicacion o
	 * notificacion ordinaria sin remesa
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws SQLException
	 */
	private TramiteInspeccion obtenerRegistrosalidaComunicacionNotificacion(TramiteInspeccion tramiteInspeccion,
			TramiteComun tramiteComun) throws SQLException {
		if (tramiteInspeccion.getTienvrem() == null || Y41bConstantes.NO.equals(tramiteInspeccion.getTienvrem())) {
			if (tramiteInspeccion.getTinumregistrosalida() == null
					|| tramiteInspeccion.getTinumregistrosalida().equals("")) {
				WSParamOutputRegisterEx datas = new WSParamOutputRegisterEx();

				Actuacion actuacion = new Actuacion();
				actuacion.setAtcodigo(tramiteComun.getIdExpediente());
				actuacion = this.actuacionDao.find(actuacion);

				if (actuacion.getActdec().getAdcoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
					datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
					datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
				} else if (actuacion.getActdec().getAdcoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
					datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
					datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
				} else if (actuacion.getActdec().getAdcoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
					datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
					datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
				} else if (actuacion.getActdec().getAdcoor()
						.equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
					datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
					datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
				} else {
					if (actuacion.getActdec().getAdcoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
						datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
					} else if (actuacion.getActdec().getAdcoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
						datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
					} else if (actuacion.getActdec().getAdcoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
						datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
					} else if (actuacion.getActdec().getAdcoor()
							.equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
						datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
					} else {
						datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
						datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
					}
				}

				ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdinterviniente(tramiteInspeccion.getTiiddestinatario());

				intervinientes = this.intervinientesDao.find(intervinientes);

				WSParamPerson wSParamPerson = new WSParamPerson();
				StringBuffer sbPerson = new StringBuffer();
				if (Y41bUtils.isFilled(intervinientes.getNif())) {
					sbPerson.append(intervinientes.getNif());
					sbPerson.append(" - ");
				}
				if (Y41bUtils.isFilled(intervinientes.getEsnoco())) {
					sbPerson.append(intervinientes.getEsnoco());
					sbPerson.append(" ");
				} else {
					if (Y41bUtils.isFilled(intervinientes.getNombre())) {
						sbPerson.append(intervinientes.getNombre());
						sbPerson.append(" ");
					}
					if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
						sbPerson.append(intervinientes.getApellido1());
						sbPerson.append(" ");
					}
					if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
						sbPerson.append(intervinientes.getApellido2());
						sbPerson.append(" ");
					}
				}

				wSParamPerson.setPersonName(sbPerson.toString());

				persons.getWSParamPerson().add(wSParamPerson);

				datas.setPersons(persons);

				StringBuffer sbMatter = new StringBuffer();

				if (tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION)) {
					sbMatter.append(Y41bConstantes.LITERAL_COMUNICACION_ES);
				} else if (tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION)) {
					sbMatter.append(Y41bConstantes.LITERAL_NOTIFICACION_ES);
				}

				sbMatter.append(" - [");

				sbMatter.append(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				sbMatter.append("-");
				sbMatter.append(this.findNumExpedienteActuacion(tramiteComun.getIdExpediente()));
				sbMatter.append("]");
				datas.setMatter(sbMatter.toString());

				N61ServiceImpl n61Service = new N61ServiceImpl();
				WSOutputRegister wSOutputRegister = n61Service.wsNewOutputRegister(datas);

				tramiteInspeccion.setTifecharegistrosalida(new Date());
				tramiteInspeccion.setTinumregistrosalida(wSOutputRegister.getNumber());
			}
		}

		return tramiteInspeccion;
	}

	/**
	 * Metodo que procesa el envio de una comunicacin o notificacion ordinaria
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idZipFile
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	private void procesarComunicacionNotificacionOrdinaria(List<Adjuntardocs> listadjuntardocs,
			List<DocumentoHecho> listDocumentoHecho, TramiteInspeccion tramiteInspeccion, TramiteComun tramiteComun,
			String idZipFile) throws Exception {

		// Validacion: Debe haber almenos 1 documento
		if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
			for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
				PlantillaTramite plantillaTramite = null;
				if (adjuntardocsAux != null && adjuntardocsAux.getPtcodigo() != null
						&& !adjuntardocsAux.getPtcodigo().equals("")) {
					plantillaTramite = new PlantillaTramite();
					plantillaTramite.setPtcodigo(adjuntardocsAux.getPtcodigo());
					// Obtener la plantilla del tramite
					plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);
				}

				if (Y41bUtils.isDocumentoLocalizable(adjuntardocsAux)) {
					if ((tramiteInspeccion.getTienvrem() == null
							|| Y41bConstantes.NO.equals(tramiteInspeccion.getTienvrem()))
							&& (plantillaTramite != null && plantillaTramite.getNolocalizable() != null
									&& plantillaTramite.getNolocalizable().equals(Y41bConstantes.VALOR_SI))) {

					} else {
						if (!StringUtils.isBlank(adjuntardocsAux.getThiddocumentum())) {
							Documento documento = new Documento();
							// 1.User
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
							documento.setProcedure(procedure);
							documento.setOidDokusi(adjuntardocsAux.getThiddocumentum());
							Formato formato = y41bDokusiAdapterService.recuperarFormatosDocumentosDokusi(documento);

							if (formato != null && formato.getName().equals(Y41bConstantes.PDFA)) {
								if (adjuntardocsAux != null && adjuntardocsAux.getThnofile() != null
										&& !com.ejie.y41b.utils.Y41bUtils
												.getExtensionFile(adjuntardocsAux.getThnofile())
												.equalsIgnoreCase(Y41bConstantes.PDF)) {
									throw new Y41bUDAException("error.documentos.sinlocalizador", true,
											new Exception());
								}
							} else {
								throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
							}
						} else {
							throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
						}
					}
				} else {
					if (tramiteInspeccion.getTienvrem() != null
							&& Y41bConstantes.SI.equals(tramiteInspeccion.getTienvrem())) {
						if (adjuntardocsAux != null && adjuntardocsAux.getThnofile() != null
								&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(adjuntardocsAux.getThnofile())
										.equalsIgnoreCase(Y41bConstantes.PDF)) {
							throw new Y41bUDAException("error.documentos.remesapdf", true, new Exception());
						}
					}
				}
			}
		}

		if (tramiteInspeccion.getTienvrem() != null && Y41bConstantes.SI.equals(tramiteInspeccion.getTienvrem())) {
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				this.soltramexpService.controlDocumentosProtegidosRemesa(listadjuntardocs);
			}
		}

		if (tramiteInspeccion.getTienvrem() == null || Y41bConstantes.NO.equals(tramiteInspeccion.getTienvrem())) {
			this.soltramexpService.crearZipDocumentosExpediente(idZipFile, listadjuntardocs, tramiteComun);
		}

		// Subimos los documentos a dokusi
		this.soltramexpService.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);
	}

	/**
	 * Metodo que procesa el envio de una comunicacin electronica
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 */
	private void procesarComunicacionElectronica(List<DocumentoHecho> listDocumentoHecho,
			TramiteComunicacion tramiteComunicacion, TramiteInspeccion tramiteInspeccion, CensoMonitor censoMonitor)
			throws Exception {
		if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		String textoNotificacionComunicacion = tramiteComunicacion.getTextoComunicacion();
		String destinatario = tramiteComunicacion.getDestinatario();
		String envRemesa = tramiteComunicacion.getEnvRemesaComunicacion();

		CrearNotifEJGV crearNotifEJGV = this.crearObjetoCrearNotifEJGV(tramiteInspeccion.getTiatcodigo(),
				tramiteInspeccion.getTicodigo(), Y41bConstantes.NOTIFICACION_COMUNICACION,
				textoNotificacionComunicacion, destinatario, envRemesa, listDocumentoHecho, censoMonitor);

		RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService.procesarEnviarNotificacionX43(crearNotifEJGV);

		// update tramite campo idnotificacionplatea
		tramiteInspeccion.setTiidnotificacionplatea(respuestaNotif.getNumeroRegistro());
		this.tramiteInspeccionDao.updateIdNotificacionPlatea(tramiteInspeccion);

		// recuperar segistro salida de notificacion y actualizar tabla
		// tramite hecho con el registro de salida y su fecha de registro
		TNotification tNotification = this.y41bPlateaAdapterService
				.getJustificanteNotificacion(respuestaNotif.getNumeroRegistro());

		tramiteInspeccion.setTinumregistrosalida(tNotification.getRegistryID().getRegistryNumber());
		tramiteInspeccion.setTifecharegistrosalida(
				Y41bUtils.parseRegistrytimestamp(tNotification.getRegistryID().getRegistryDate()));
		this.tramiteInspeccionDao.updateRegistroSalidaPlatea(tramiteInspeccion);
	}

	/**
	 * Metodo que crea el objeto CrearNotifEJGV para envio de
	 * notificacin/comunicacin electrnica
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idTipoNotificacion
	 *            String
	 * @param textoNotificacionComunicacion
	 *            String
	 * @param destinatario
	 *            String
	 * @param envRemesa
	 *            String
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CrearNotifEJGV
	 * @throws Exception
	 */
	private CrearNotifEJGV crearObjetoCrearNotifEJGV(String idExpediente, String idTramite, String idTipoNotificacion,
			String textoNotificacionComunicacion, String destinatario, String envRemesa,
			List<DocumentoHecho> listDocumentoHecho, CensoMonitor censoMonitor) throws Exception {

		CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
		crearNotifEJGV.setProcedure(procedure);

		crearNotifEJGV.setTextoNotificacion(textoNotificacionComunicacion);

		crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());
		crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(destinatario);

		intervinientes = this.intervinientesDao.find(intervinientes);

		DatosPersona datosPersonaSolicitante = new DatosPersona();
		datosPersonaSolicitante.setDni(intervinientes.getNif());

		StringBuffer nombreCompleto = new StringBuffer();
		nombreCompleto.append(intervinientes.getNombre());
		if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
			nombreCompleto.append(" ").append(intervinientes.getApellido1());
		}
		if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
			nombreCompleto.append(" ").append(intervinientes.getApellido2());
		}

		datosPersonaSolicitante.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
			datosPersonaSolicitante.setApellido1(intervinientes.getApellido1());
		}
		datosPersonaSolicitante.setMail(intervinientes.getCoem());

		// Mail de notificacion del establecimiento
		if (Y41bUtils.isFilled(intervinientes.getEscodigo())) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(intervinientes.getEscodigo());
			establecimiento = this.establecimientoService.find(establecimiento);

			AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
			adjunDatosAvisosEstablec.setYiescif(establecimiento.getEsnif());
			adjunDatosAvisosEstablec.setYipcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			adjunDatosAvisosEstablec = this.adjunDatosAvisosEstablecDao.findByCifProc(adjunDatosAvisosEstablec);

			if (adjunDatosAvisosEstablec != null && Y41bUtils.isFilled(adjunDatosAvisosEstablec.getYiemail())) {
				datosPersonaSolicitante.setMail(adjunDatosAvisosEstablec.getYiemail());
			} else if (Y41bUtils.isFilled(establecimiento.getEsmailnotificacion())) {
				datosPersonaSolicitante.setMail(establecimiento.getEsmailnotificacion());
			}
		}

		datosPersonaSolicitante.setTelefono(intervinientes.getNrtel());

		crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

		DatosPersona datosPersonaSender = new DatosPersona();
		datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
		datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());

		crearNotifEJGV.setSender(datosPersonaSender);

		// Obtener el numero de expediente
		String numeroExpediente = this.findNumExpedienteActuacion(idExpediente);

		crearNotifEJGV.setNumeroExpediente(numeroExpediente);

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// Indicar la serie documental que corresponde al expediente
		crearNotifEJGV.setSerieDocumental(prop.getProperty(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES + ".serie."
				+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString())));

		// El tipo de notificacion para PLATEA
		crearNotifEJGV.setIdTipoNotificacion(idTipoNotificacion);

		List<Documento> listDocumentos = this.soltramexpService.registrarDocumentosDokusi(listDocumentoHecho, null);

		crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);

		if (null != crearNotifEJGV.getDocumentosAdjuntos() && crearNotifEJGV.getDocumentosAdjuntos().size() > 0) {

			for (Documento documentoAux : crearNotifEJGV.getDocumentosAdjuntos()) {
				if (!com.ejie.y41b.utils.Y41bUtils.isDocumentoLocalizable(documentoAux)) {
					if (envRemesa != null && Y41bConstantes.SI.equals(envRemesa)) {
						if (documentoAux != null && documentoAux.getNombre() != null && !com.ejie.y41b.utils.Y41bUtils
								.getExtensionFile(documentoAux.getNombre()).equalsIgnoreCase(Y41bConstantes.PDF)) {
							throw new Y41bUDAException("error.documentos.remesapdf", true, new Exception());
						}
					}
				}
			}
		}

		return crearNotifEJGV;
	}

	/**
	 * Metodo que procesa el envio de una notificacin electronica
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramitehecho
	 *            TramiteHecho
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 */
	private void procesarNotificacionElectronica(List<DocumentoHecho> listDocumentoHecho,
			TramiteNotificacion tramiteNotificacion, TramiteInspeccion tramiteInspeccion, TramiteComun tramiteComun,
			CensoMonitor censoMonitor) throws Exception {
		if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		// 2. Se genera el tramite de acuse de recibo vinculado al tramite de
		// notificacion
		String idEspera = Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE);
		TramiteInspeccion tramiteAcuse = this.generarTramiteAcuseReciboAutomatico(idEspera, tramiteInspeccion,
				tramiteComun);

		// 3. Enviamos telematicamente la solicitud
		String textoNotificacionComunicacion = tramiteNotificacion.getTextoComunicacion();
		String destinatario = tramiteNotificacion.getDestinatario();
		String envRemesa = tramiteNotificacion.getEnvRemesaNotificacion();

		CrearNotifEJGV crearNotifEJGV = this.crearObjetoCrearNotifEJGV(tramiteInspeccion.getTiatcodigo(),
				tramiteInspeccion.getTicodigo(), tramiteNotificacion.getTipoNotificacionPlatea(),
				textoNotificacionComunicacion, destinatario, envRemesa, listDocumentoHecho, censoMonitor);

		RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService.procesarEnviarNotificacionX43(crearNotifEJGV);

		// 4.1 Update tramite notificacion (campo idnotificacionplatea)
		tramiteInspeccion.setTiidnotificacionplatea(respuestaNotif.getNumeroRegistro());
		this.tramiteInspeccionDao.updateIdNotificacionPlatea(tramiteInspeccion);

		// 4.2 Recuperar segistro salida de notificacion y actualizar tabla
		// tramite hecho con el registro de salida y su fecha de registro
		TNotification tNotification = this.y41bPlateaAdapterService
				.getJustificanteNotificacion(respuestaNotif.getNumeroRegistro());

		tramiteInspeccion.setTinumregistrosalida(tNotification.getRegistryID().getRegistryNumber());
		tramiteInspeccion.setTifecharegistrosalida(
				Y41bUtils.parseRegistrytimestamp(tNotification.getRegistryID().getRegistryDate()));
		this.tramiteInspeccionDao.updateRegistroSalidaPlatea(tramiteInspeccion);
		// 4.3 Add notificacion / acuse recibo (tabla)
		NotificacionAcuseRecibo notificacionAcuseRecibo = new NotificacionAcuseRecibo();
		notificacionAcuseRecibo.setEhidnotificacionplatea(respuestaNotif.getNumeroRegistro());
		notificacionAcuseRecibo.setEhcodigoacuse(tramiteAcuse.getTicodigo());
		notificacionAcuseRecibo.setEhpcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		this.tramiteInspeccionDao.addNotificacionAcuseRecibo(notificacionAcuseRecibo);
	}

	/**
	 * Create ejgv document for notificacion and comunication
	 * 
	 * @param textoNotificacionComunicacion
	 *            String
	 * @param destinatario
	 *            String
	 * @param tipoNotificacionPlatea
	 *            String
	 * @param envRemesa
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentNotificacionComunicacion(
			String textoNotificacionComunicacion, String destinatario, String tipoNotificacionPlatea, String envRemesa,
			TramiteComun tramiteComun, CensoMonitor censoMonitor) throws Exception {
		RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = null;
		List<Adjuntardocs> listadjuntardocs = null;

		CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
		crearNotifEJGV.setProcedure(procedure);

		crearNotifEJGV.setTextoNotificacion(textoNotificacionComunicacion);

		crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());
		crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);

		// buscar el interviniente
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(destinatario);

		intervinientes = this.intervinientesDao.find(intervinientes);

		DatosPersona datosPersonaSolicitante = new DatosPersona();
		datosPersonaSolicitante.setDni(intervinientes.getNif());

		StringBuffer nombreCompleto = new StringBuffer();
		nombreCompleto.append(intervinientes.getNombre());
		if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
			nombreCompleto.append(" ").append(intervinientes.getApellido1());
		}
		if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
			nombreCompleto.append(" ").append(intervinientes.getApellido2());
		}

		datosPersonaSolicitante.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
			datosPersonaSolicitante.setApellido1(intervinientes.getApellido1());
		}
		datosPersonaSolicitante.setMail(intervinientes.getCoem());
		datosPersonaSolicitante.setTelefono(intervinientes.getNrtel());

		crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

		DatosPersona datosPersonaSender = new DatosPersona();
		datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
		datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());

		crearNotifEJGV.setSender(datosPersonaSender);

		// Obtener el numero de expediente
		String numeroExpediente = this.findNumExpedienteActuacion(tramiteComun.getIdExpediente());

		crearNotifEJGV.setNumeroExpediente(numeroExpediente);

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// Indicar la serie documental que corresponde al expediente
		crearNotifEJGV.setSerieDocumental(prop.getProperty(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES + ".serie."
				+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString())));

		// El tipo de notificacion para PLATEA
		crearNotifEJGV.setIdTipoNotificacion(tipoNotificacionPlatea);
		// Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		listadjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

		List<Documento> listDocumentos = new ArrayList<Documento>();
		Documento documento = null;

		if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
			for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {

				adjuntardocsAux = this.adjuntardocsDao.findAdjuntarDocs(adjuntardocsAux);

				if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					// crear el objeto DocumentoHecho
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5iddocumentum(adjuntardocsAux.getThiddocumentum());
					documentoHecho.setQ5idTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					documentoHecho.setQ5codocumento(adjuntardocsAux.getThcodocumento());
					documentoHecho.setQ5nofile(adjuntardocsAux.getThnofile());
					documentoHecho.setQ5tedesfile(adjuntardocsAux.getThtedesfile());
					documentoHecho.setQ5origen(adjuntardocsAux.getThorigen());
					documentoHecho.setQ5ptcodigo(adjuntardocsAux.getPtcodigo());
					documentoHecho.setQ5datafile(adjuntardocsAux.getThdatafile());

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
					tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

					documento = this.soltramexpService.registrarDocumentosDokusiSol(documentoHecho, tramiteComunAux);
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					// crear el objeto Sandoctemp
					Sandoctemp sandocTemp = new Sandoctemp();
					sandocTemp.setU5iddocumentum(adjuntardocsAux.getThiddocumentum());
					sandocTemp.setU5tipodocumento(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					sandocTemp.setU5codocumento(adjuntardocsAux.getThcodocumento());
					sandocTemp.setU5nofile(adjuntardocsAux.getThnofile());
					sandocTemp.setU5tedesfile(adjuntardocsAux.getThtedesfile());
					sandocTemp.setU5origen(adjuntardocsAux.getThorigen());
					sandocTemp.setU5ptcodigo(adjuntardocsAux.getPtcodigo());
					sandocTemp.setU5datafile(adjuntardocsAux.getThdatafile());

					DocumentoHecho documentoHechoAux = new DocumentoHecho();
					documentoHechoAux.setQ5codocumento(adjuntardocsAux.getThcodocumento());
					documentoHechoAux = this.documentoHechoDao.findDocumentoHecho(documentoHechoAux);

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(documentoHechoAux.getQ5hdcodigo());
					tramiteComunAux.setIdTramite(documentoHechoAux.getQ5tramite());

					documento = this.soltramexpService.registrarDocumentosDokusiSan(sandocTemp, tramiteComunAux);
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					// crear el objeto Sandoctemp
					Arbdoctemp arbdocTemp = new Arbdoctemp();
					arbdocTemp.setX5iddocumentum(adjuntardocsAux.getThiddocumentum());
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					arbtipdoc.setTdid(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					arbdocTemp.setArbtipdoc(arbtipdoc);
					arbdocTemp.setX5codocumento(adjuntardocsAux.getThcodocumento());
					arbdocTemp.setX5nofile(adjuntardocsAux.getThnofile());
					arbdocTemp.setX5tedesfile(adjuntardocsAux.getThtedesfile());
					arbdocTemp.setX5origen(adjuntardocsAux.getThorigen());
					arbdocTemp.setX5ptcodigo(adjuntardocsAux.getPtcodigo());
					arbdocTemp.setX5datafile(adjuntardocsAux.getThdatafile());

					DocumentoHecho documentoHechoAux = new DocumentoHecho();
					documentoHechoAux.setQ5codocumento(adjuntardocsAux.getThcodocumento());
					documentoHechoAux = this.documentoHechoDao.findDocumentoHecho(documentoHechoAux);

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(documentoHechoAux.getQ5hdcodigo());
					tramiteComunAux.setIdTramite(documentoHechoAux.getQ5tramite());

					documento = this.soltramexpService.registrarDocumentosDokusiArb(arbdocTemp, tramiteComunAux);
				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null
						&& (adjuntardocsAux.getTipoProcedimiento().getPcodigo()
								.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
										.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
										.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

				} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
						&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
								.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					// crear el objeto DocumentoHecho
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5iddocumentum(adjuntardocsAux.getThiddocumentum());
					documentoHecho.setQ5idTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
					documentoHecho.setQ5codocumento(adjuntardocsAux.getThcodocumento());
					documentoHecho.setQ5nofile(adjuntardocsAux.getThnofile());
					documentoHecho.setQ5tedesfile(adjuntardocsAux.getThtedesfile());
					documentoHecho.setQ5origen(adjuntardocsAux.getThorigen());
					documentoHecho.setQ5ptcodigo(adjuntardocsAux.getPtcodigo());
					documentoHecho.setQ5datafile(adjuntardocsAux.getThdatafile());

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
					tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

					documento = this.soltramexpService.registrarDocumentosDokusiIns(documentoHecho, tramiteComunAux);

				}

				listDocumentos.add(documento);
			}
		}

		crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);

		if (Y41bUtils.isFilled(tipoNotificacionPlatea)) {
			respuestaEjgv = y41bPlateaAdapterService.crearEJGVDocumentNotificacion(crearNotifEJGV);
		} else {
			respuestaEjgv = y41bPlateaAdapterService.crearEJGVDocumentComunicacion(crearNotifEJGV);
		}

		if (null != crearNotifEJGV.getDocumentosAdjuntos() && crearNotifEJGV.getDocumentosAdjuntos().size() > 0) {

			for (Documento documentoAux : crearNotifEJGV.getDocumentosAdjuntos()) {
				if (!com.ejie.y41b.utils.Y41bUtils.isDocumentoLocalizable(documentoAux)) {
					if (envRemesa != null && Y41bConstantes.SI.equals(envRemesa)) {
						if (documentoAux != null && documentoAux.getNombre() != null && !com.ejie.y41b.utils.Y41bUtils
								.getExtensionFile(documentoAux.getNombre()).equalsIgnoreCase(Y41bConstantes.PDF)) {
							throw new Y41bUDAException("error.documentos.remesapdf", true, new Exception());
						}
					}
				}
			}
		}

		return respuestaEjgv;
	}

	/**
	 * Metodo que comprueba que los documentos se encuentren todos firmados al
	 * guardar
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @throws Exception
	 *             Exception
	 */
	private void controlDocumentosPendientesFirmaGuardar(TramiteComun tramiteComun, TramiteInspeccion tramiteInspeccion,
			String fase, String tramite) throws Exception {
		// Miramos si hay algun documento pendiente de firma para
		// actualizar el estado del tramite
		boolean isDocPendienteFirma = false;
		boolean isDocDenegadaFirma = false;
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getQ5estadodocumento())) {
					isDocPendienteFirma = true;
					break;
				}
			}
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA.equals(documentoHecho.getQ5estadodocumento())) {
					isDocDenegadaFirma = true;
					break;
				}
			}
		} else {
			// Validacion: Debe haber almenos 1 documento
			// throw new Y41bUDAException("error.solicitud.documentoException",
			// true, new Exception());
		}

		if (isDocDenegadaFirma) {
			// Llamamos a un metodo que recorrera la lista de
			// documentos del tramite y actualizara la bandeja de firma
			this.actualizarBandejaFirma(listDocumentoHecho, tramiteComun, fase, tramite);
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA);
			this.tramiteInspeccionDao.updateEstadoTramite(tramiteInspeccion);
		} else if (isDocPendienteFirma) {
			// Llamamos a un metodo que recorrera la lista de
			// documentos del tramite y actualizara la bandeja de firma
			this.actualizarBandejaFirma(listDocumentoHecho, tramiteComun, fase, tramite);
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
			this.tramiteInspeccionDao.updateEstadoTramite(tramiteInspeccion);
		} else {
			BandejaFirma bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
			this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
		}

		// Tratar la Bandeja de inspecciones
		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		BandejaInspecciones bandejaInspecciones = new BandejaInspecciones();
		bandejaInspecciones.setAtcodigo(tramiteInspeccion.getTiatcodigo());

		this.bandejaInspeccionesService.updateUltimoTramite(bandejaInspecciones);
	}

	/**
	 * Responde si la actuacion tiene un Acuerdo Inicio Procedimiento.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return boolean
	 */
	public boolean existeAcuerdoInicioProcedimiento(Actuacion actuacion) {
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTiatcodigo(actuacion.getAtcodigo());
		tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);

		Long total = this.tramiteInspeccionDao.findAllCount(tramiteInspeccion);

		return (total != 0);
	}

	/**
	 * Comprueba si existe propuesta de inspeccion o expediente sancionador para
	 * el tipo de interviniente (establecimiento visitado o responsable)
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipoInterviniente
	 *            String
	 * @return boolean
	 */
	public boolean existePropuestaSancionOExpedienteSancionador(TramiteComun tramiteComun, String tipoInterviniente) {
		// buscar el interviniente
		String tipo_interviniente_destinatario = "";
		if (Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTOVISITADO.equals(tipoInterviniente)) {
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO;
		} else if (Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTORESPONSABLE.equals(tipoInterviniente)) {
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE;
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(tipo_interviniente_destinatario);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
			sanpropbandeja.setBaprsanexcodigo(tramiteComun.getIdExpediente());
			sanpropbandeja.setBaprsansancionado(listIntervinientes.get(0).getEscodigo());

			if (this.sanpropbandejaService.findAllCount(sanpropbandeja) > 0) {
				return true;
			}

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(listIntervinientes.get(0).getEscodigo());

			Sanexprel sanexprel = new Sanexprel();
			sanexprel.setRlinscodrel(tramiteComun.getIdExpediente());

			if (this.sanexprelService.findSancionadorRelacionadoInspeccionesCount(sanexprel, establecimiento) > 0) {
				return true;
			}
		}

		return false;
	}

	/***********
	 * REMESAS *
	 ***********/

	/**
	 * Finds rows in the Tramites table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifComuni, Pagination pagination) {
		filterNotifComuni.setCompatibleAA66(this.compatibleConAA66());
		List<NotificacionesComunicacionesBusqueda> listNotifiComuniBusqueda = this.tramiteInspeccionDao
				.findAllNotifiComuni(filterNotifComuni, pagination);

		for (NotificacionesComunicacionesBusqueda notifcomun : listNotifiComuniBusqueda) {
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(filterNotifComuni.getRmtipoExpediente()).append(" ").append(notifcomun.getDecoor())
					.append("-").append(notifcomun.getDenran()).append("-").append(notifcomun.getDenror()).append("-")
					.append(notifcomun.getHdnror());

			notifcomun.setRmtipoExpediente(filterNotifComuni.getRmtipoExpediente());

			notifcomun.setNumExpediente(numeroExpediente.toString());

			// En caso de que sea el destino Sede fijar la direccin de la misma
			if (notifcomun.getEhsede() != null && notifcomun.getEhsede().equals("S")) {

				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEsnif(notifcomun.getNif());

				establecimiento = this.establecimientoService.obtenerEstablecimientoSede(establecimiento);

				if (establecimiento != null) {
					Sede sede = new Sede();
					sede.setEscodigo(establecimiento.getEscodigo());
					sede.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);

					sede = this.establecimientoService.findEstablecimientoSede(sede);

					if (sede != null) {
						notifcomun.setNombre_CP(sede.getNombreCp());
						if (sede.getNombreMunicipio() != null) {
							notifcomun.setNombre_Municipio(sede.getNombreMunicipio());
						}
						if (sede.getNombreLocalidad() != null) {
							notifcomun.setNombre_Localidad(sede.getNombreLocalidad());
						}
						if (sede.getNombreProvincia() != null) {
							notifcomun.setNombre_Provincia(sede.getNombreProvincia());
						}

						if (sede.getNombreCalle() != null) {
							notifcomun.setNombre_Calle(sede.getNombreCalle());

							notifcomun.setNombre_Portal(sede.getNombrePortal());
							notifcomun.setNombre_Piso(sede.getNombrePiso());

						} else if (sede.getDireccionNocapv() != null) {

							notifcomun.setNombre_Calle("");
							notifcomun.setNombre_Portal("");
							notifcomun.setNombre_Piso("");

							if (sede.getNoraPaisNombre() != null && !sede.getNoraPaisNombre().equals("")) {
								notifcomun.setNombre_Pais(sede.getNoraPaisNombre());
							}
							notifcomun.setExtranjero(sede.getExtranjero());
							notifcomun.setDireccionNocapv(sede.getDireccionNocapv());
						}
					} else {
						ponerVaciaLaSedeEnLaNotificaComunica(notifcomun);
					}
				} else {
					ponerVaciaLaSedeEnLaNotificaComunica(notifcomun);
				}
			}
			// PREPARO LAS DIRECCIONES DESTINO
			StringBuffer direccion2 = new StringBuffer();
			if (notifcomun.getNombre_CP() != null && !notifcomun.getNombre_CP().equals("")) {
				direccion2.append(notifcomun.getNombre_CP());
			} else {
				direccion2.append("");
				notifcomun.setNombre_CP("");
			}
			if (notifcomun.getExtranjero() != null && notifcomun.getExtranjero().equals("S")) {
				notifcomun.setDireccion1(notifcomun.getDireccionNocapv());
				direccion2.append(" ").append(notifcomun.getNombre_Pais());
				notifcomun.setDireccion2(direccion2.toString());

			} else {
				if (notifcomun.getNombre_Calle() != null && !notifcomun.getNombre_Calle().equals("")) {
					StringBuffer direccionCapv = new StringBuffer();
					direccionCapv.append(notifcomun.getNombre_Calle());
					if (notifcomun.getNombre_Portal() != null && !notifcomun.getNombre_Portal().equals("")) {
						direccionCapv.append(" ").append(notifcomun.getNombre_Portal());
					}
					if (notifcomun.getNombre_Piso() != null && !notifcomun.getNombre_Piso().equals("")) {
						direccionCapv.append(" ").append(notifcomun.getNombre_Piso());
					}
					notifcomun.setDireccion1(direccionCapv.toString());
				} else {
					notifcomun.setDireccion1(notifcomun.getDireccionNocapv());
				}

				direccion2.append(" ").append(notifcomun.getNombre_Municipio());
				notifcomun.setDireccion2(direccion2.toString());

			}

			// Creamos el campo direccion del organismo conectado
			StringBuffer direccionCompleta = new StringBuffer();

			if (notifcomun.getNombreCalle() != null && !notifcomun.getNombreCalle().equals("")) {
				direccionCompleta.append(notifcomun.getNombreCalle());

				if (notifcomun.getNombrePortal() != null && !notifcomun.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(notifcomun.getNombrePortal());
				}
			}

			notifcomun.setDireccionOrganismo(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo
			// conectado
			StringBuffer cpMunicipio = new StringBuffer();

			if (notifcomun.getNombreCp() != null && !notifcomun.getNombreCp().equals("")) {
				cpMunicipio.append(notifcomun.getNombreCp());

				if (notifcomun.getNombreMunicipio() != null && !notifcomun.getNombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(notifcomun.getNombreMunicipio());
				}
			} else if (notifcomun.getNombreMunicipio() != null && !notifcomun.getNombreMunicipio().equals("")) {
				cpMunicipio.append(notifcomun.getNombreMunicipio());
			}

			notifcomun.setCpMunicipioOrganismo(cpMunicipio.toString());

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea1 = new StringBuffer();

			piepagina_linea1.append(notifcomun.getDireccionOrganismo()).append(" - ")
					.append(notifcomun.getCpMunicipioOrganismo()).append(" / ").append(" Tl. ")
					.append(notifcomun.getTelefonoOrganismo());

			notifcomun.setPiePaginaLinea1(piepagina_linea1.toString());

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea2 = new StringBuffer();

			piepagina_linea2.append("e-mail: ").append(notifcomun.getEmailOrganismo()).append(" / ")
					.append(notifcomun.getWebOrganismo());

			notifcomun.setPiePaginaLinea2(piepagina_linea2.toString());
		}

		return listNotifiComuniBusqueda;

	}

	/**
	 * Devuelve el tamao de la remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda filterNotifiComuni) {

		return this.tramiteInspeccionDao.findSumSizeBlobNotifiComuni(filterNotifiComuni);
	}

	/**
	 * Comprueba si existe compatibilidad con AA66
	 * 
	 * @return boolean
	 */
	private boolean compatibleConAA66() {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.INTEGRACION_CON_AA66);
		parametros = this.parametrosDao.find(parametros);
		if (null != parametros && null != parametros.getValor()) {
			String integracion = parametros.getValor();
			return integracion.equalsIgnoreCase(Y41bConstantes.VALOR_SI);
		}
		return false;
	}

	private void ponerVaciaLaSedeEnLaNotificaComunica(NotificacionesComunicacionesBusqueda notifcomun) {
		notifcomun.setNombre_CP("");
		notifcomun.setNombre_Municipio("");
		notifcomun.setNombre_Provincia("");
		notifcomun.setNombre_Calle("");
		notifcomun.setNombre_Portal("");
		notifcomun.setNombre_Piso("");
		notifcomun.setNombre_Pais("");
		notifcomun.setExtranjero("");
		notifcomun.setDireccionNocapv("");
	}

	/**
	 * Counts rows in the Tramites table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda filterNotifComuni) {
		return this.tramiteInspeccionDao.findAllNotifiComuniCount(filterNotifComuni);
	}

	/**
	 * Busca los documentos de notificacion o comunicacion que componen la
	 * remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni) throws SerialException, SQLException, Exception {

		List<NotificacionesComunicacionesBusqueda> listaClobsNotifiComuni = this.tramiteInspeccionDao
				.findBlobTablaDocumentosHecho(filterNotifiComuni);

		if (listaClobsNotifiComuni != null) {

			for (NotificacionesComunicacionesBusqueda notificacionesComunicacionesBusquedaAux : listaClobsNotifiComuni) {

				// si est en dokusi, descargar de dokusi
				if (notificacionesComunicacionesBusquedaAux != null
						&& notificacionesComunicacionesBusquedaAux.getQ5iddocumentum() != null
						&& !notificacionesComunicacionesBusquedaAux.getQ5iddocumentum().equals("")) {
					// descargar de dokusi
					// descargar documentos dokusi
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.TIPO_PROC_INSPECCIONES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(notificacionesComunicacionesBusquedaAux.getQ5iddocumentum());

					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

					Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
					notificacionesComunicacionesBusquedaAux.setQ5datafile(blob);
				} else {
					// si no est en dokusi descargar de base de datos
				}
			}
		}
		return listaClobsNotifiComuni;
	}

	/**
	 * Finds registro salida document
	 * 
	 * @param remesa
	 *            Remesa
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @return RegistroSalida
	 * @throws Exception
	 *             Exception
	 */
	public RegistroSalida getRegistroSalida(Remesa remesa, TramiteComun tramiteComun, Intervinientes intervinientes)
			throws Exception {

		WSParamOutputRegisterEx datas = new WSParamOutputRegisterEx();

		// obtener la solicitud
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteComun.getIdExpediente());

		actuacion = this.actuacionDao.find(actuacion);

		if (actuacion != null && actuacion.getActdec() != null && actuacion.getActdec().getAdcoor() != null) {
			if (actuacion.getActdec().getAdcoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			} else if (actuacion.getActdec().getAdcoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			} else if (actuacion.getActdec().getAdcoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			} else if (actuacion.getActdec().getAdcoor().equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
			}
		} else {
			if (actuacion.getActa().getAccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			} else if (actuacion.getActa().getAccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_ARABA)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			} else if (actuacion.getActa().getAccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			} else if (actuacion.getActa().getAccoor().equals(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_CONTROLMERCADO);
			} else {
				datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
				datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			}
		}

		ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

		Intervinientes intervinientesAux = this.intervinientesDao.find(intervinientes);

		WSParamPerson wSParamPerson = new WSParamPerson();
		StringBuffer sbPerson = new StringBuffer();
		if (Y41bUtils.isFilled(intervinientesAux.getNif())) {
			sbPerson.append(intervinientesAux.getNif());
			sbPerson.append(" - ");
		}
		if (Y41bUtils.isFilled(intervinientesAux.getEsnoco())) {
			sbPerson.append(intervinientesAux.getEsnoco());
			sbPerson.append(" ");
		} else {
			if (Y41bUtils.isFilled(intervinientesAux.getNombre())) {
				sbPerson.append(intervinientesAux.getNombre());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
				sbPerson.append(intervinientesAux.getApellido1());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
				sbPerson.append(intervinientesAux.getApellido2());
				sbPerson.append(" ");
			}
		}

		wSParamPerson.setPersonName(sbPerson.toString());

		persons.getWSParamPerson().add(wSParamPerson);

		datas.setPersons(persons);

		StringBuffer sbMatter = new StringBuffer();

		if (remesa.getRmtipo().equals(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION)) {
			sbMatter.append(Y41bConstantes.LITERAL_NOTIFICACION_ES);
		} else {
			sbMatter.append(Y41bConstantes.LITERAL_COMUNICACION_ES);
		}

		sbMatter.append(" - [");
		sbMatter.append(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		sbMatter.append("-");
		sbMatter.append(actuacion.getActa().getAccoor()).append("-").append(actuacion.getActa().getAcnror()).append("-")
				.append(actuacion.getActa().getAcnran()).append("-").append(actuacion.getAtnror());
		sbMatter.append("]");
		datas.setMatter(sbMatter.toString());

		N61ServiceImpl n61Service = new N61ServiceImpl();
		WSOutputRegister wSOutputRegister = n61Service.wsNewOutputRegister(datas);

		RegistroSalida registroSalida = new RegistroSalida();

		registroSalida.setRegistryNumber(wSOutputRegister.getNumber());
		registroSalida.setRegistryDate(new Date());

		return registroSalida;
	}

	/**
	 * Para actualizar el tramite de acuse de recibo correspondiente al envio de
	 * una remesa.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param remesaEmitida
	 *            Remesa
	 * @param envio
	 *            NotificacionesComunicacionesBusqueda
	 * @param fechaSituacion
	 *            String
	 * @param situacionCorreos
	 *            String
	 * @param estadoDelEnvio
	 *            String
	 * @param documentoByte
	 *            byte[]
	 * @param filename
	 *            String
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void actualizarTramiteDeAcuseReciboDesdeRemesa(CensoMonitor censoMonitor, Remesa remesaEmitida,
			NotificacionesComunicacionesBusqueda envio, String fechaSituacion, String situacionCorreos,
			String estadoDelEnvio, byte[] documentoByte, String filename) {

		// "Salir si no est respondido por Correos"
		if (!Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS.equals(estadoDelEnvio)
				&& !Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {
			return;
		}

		TramiteComun tramiteComun = null;
		TramiteAcuseRecibo tramiteAcuseRecibo = null;

		if (envio.getIdTramiteAcuseRelacionado() != null) {
			try {
				// Buscar el trmite de Acuse relacionado con el envio
				tramiteAcuseRecibo = new TramiteAcuseRecibo();
				tramiteAcuseRecibo.setIdTramite(envio.getIdTramiteAcuseRelacionado());
				tramiteAcuseRecibo = this.findTramiteAcuseRecibo(tramiteAcuseRecibo, censoMonitor);

				if (tramiteAcuseRecibo == null) {
					throw new Exception(envio.getIdTramiteAcuseRelacionado());
				}

				tramiteComun = new TramiteComun();
				tramiteComun.setIdExpediente(envio.getHdcodigo());
				tramiteComun.setIdTramite(envio.getIdTramiteAcuseRelacionado());
				TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
				tipoProcedimiento.setPcodigo(remesaEmitida.getRmtipoproc());
				tramiteComun.setTipoProcedimiento(tipoProcedimiento);

				// "Crear el documento hecho del PEE para asociar al tramite,
				// siempre y cuando el envio no haya dado error"
				// " El unico error que se ha podido dar es que no exista
				// documento PEE; ya que el resto dan excepcin previa y no
				// entran por aqui"
				DocumentoHecho docHechoPEE_Aux = null;
				if (!Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {
					docHechoPEE_Aux = new DocumentoHecho();
					docHechoPEE_Aux.setQ5codocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

					docHechoPEE_Aux.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION);
					docHechoPEE_Aux.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_ACUSE_RECIBO);
					Blob blob = new SerialBlob(documentoByte);
					docHechoPEE_Aux.setQ5datafile(blob);
					docHechoPEE_Aux.setQ5contenttypefile(Y41bConstantes.CONTENT_TYPE_PDF);
					docHechoPEE_Aux.setQ5nofile(filename);
					docHechoPEE_Aux.setQ5tedesfile(Y41bConstantes.PRUEBA_ENTREGA_ENVIO);
					docHechoPEE_Aux.setQ5sizefile((int) documentoByte.length);
					docHechoPEE_Aux.setQ5hdcodigo(tramiteComun.getIdExpediente());
					docHechoPEE_Aux.setQ5tramite(tramiteComun.getIdTramite());
					docHechoPEE_Aux.setQ5fecha(new Date());
				}

				// "Actualizar tramite de acuse de recibo asociado al envio"
				Date fecha;
				fecha = Y41bUtils.convertFromSQLDateToJAVADate(
						Y41bUtils.formatearStringToDateFormato(fechaSituacion, Y41bConstantes.FORMATO_FECHA_ES));
				tramiteAcuseRecibo.setFechaacuse(fecha);

				if (situacionCorreos != null) {
					tramiteAcuseRecibo.setSituacionacuse(situacionCorreos);
				}

				// "Si el trmite ya estaba TRAMITADO, entonces SOLO se aade el
				// documeto PEE al trmite"
				if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteAcuseRecibo.getEstadoTramite())) {

					// "Solo si ha sido respondido por Correos"
					if (Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS.equals(estadoDelEnvio)) {

						this.documentoHechoDao.add(docHechoPEE_Aux);

						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteComun.getIdTramite());
						documentoTramiteHecho.setCodocumento(docHechoPEE_Aux.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					}
					// "ELSE: Si el envo viene erroneo; entonces NO se hace
					// nada, se queda a la espera de que venga el documento PEE"

				} else {

					// "Si la situacin devuelta por Correos es convertida a
					// ACUSE ACEPTADO, entonces hay que tramitar el trmite de
					// Acuese e informar al responsable."
					// "Aunque solo en el caso de que NO se haya producido un
					// error (el de no existe PEE, ya que el resto lanzan
					// excepcin y no pasan por aqu)"
					if (situacionCorreos != null
							&& situacionCorreos.equals(Y41bConstantes.SITUACION_ACUSERECIBO_ACEPTADO)
							&& !Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {

						// "Aceptado y NO erroneo >>> Tramita acuse y envia
						// email al responsable."
						this.tramitarEditTramiteAcuseReciboDesdeRemesa(tramiteAcuseRecibo, tramiteComun,
								docHechoPEE_Aux);
						this.envioMailAcuseRecibo(tramiteComun, fecha);

					} else {
						// "Guarda acuse."
						this.editTramiteAcuseReciboDesdeRemesa(tramiteAcuseRecibo, tramiteComun, docHechoPEE_Aux);
					}
				}
			} catch (ParseException e) {
				logger.error("error ParseException", e);
				throw new Y41bUDAException("error.generico", true, e);
			} catch (Exception e) {
				logger.error("error genrico", e);
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	}

	private TramiteInspeccion tramitarEditTramiteAcuseReciboDesdeRemesa(TramiteAcuseRecibo tramiteAcuseRecibo,
			TramiteComun tramiteComun, DocumentoHecho docHechoPEE) throws Exception {
		return addTramiteAcuseRecibo(tramiteAcuseRecibo, tramiteComun, null, true,
				Y41bConstantes.MODO_POPUP_MODIFICACION, docHechoPEE, true, false);
	}

	private TramiteInspeccion editTramiteAcuseReciboDesdeRemesa(TramiteAcuseRecibo tramiteAcuseRecibo,
			TramiteComun tramiteComun, DocumentoHecho docHechoPEE) throws Exception {
		return addTramiteAcuseRecibo(tramiteAcuseRecibo, tramiteComun, null, false,
				Y41bConstantes.MODO_POPUP_MODIFICACION, docHechoPEE, true, false);
	}

	/**
	 * Envio mail acuse de recibo aceptado
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param fecha
	 *            Date
	 */
	private void envioMailAcuseRecibo(TramiteComun tramiteComun, Date fecha) {
		// Enviar mail
		// obtener la solicitud
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteComun.getIdExpediente());

		actuacion = this.actuacionDao.find(actuacion);

		StringBuffer numeroExpediente = new StringBuffer(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-")
				.append(actuacion.getActa().getAccoor()).append("-").append(actuacion.getActa().getAcnror()).append("-")
				.append(actuacion.getActa().getAcnran()).append("-").append(actuacion.getAtnror());

		CensoMonitor responsableExpediente = new CensoMonitor();
		responsableExpediente.setMocodigo(actuacion.getActa().getAccomo());

		if (responsableExpediente.getMocodigo() != null && !responsableExpediente.getMocodigo().equals("")) {
			responsableExpediente = this.censoMonitorDao.find(responsableExpediente);
		}

		String from = "";
		if (responsableExpediente != null && responsableExpediente.getOrganismo() != null) {
			from = responsableExpediente.getOrganismo().getEmail();
		}

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

		StringBuffer asunto = new StringBuffer();
		asunto.append(
				appMessageSource.getMessage("acuserecibido.mail.asunto", null, new Locale(Y41bConstantes.CASTELLANO)));

		asunto.append(" ").append(numeroExpediente).append(" / ");

		asunto.append(
				appMessageSource.getMessage("acuserecibido.mail.asunto", null, new Locale(Y41bConstantes.EUSKERA)));
		asunto.append(" ").append(numeroExpediente);

		StringBuffer texto = new StringBuffer();
		texto.append("<B>").append(
				appMessageSource.getMessage("acuserecibido.mail.texto", null, new Locale(Y41bConstantes.CASTELLANO)))
				.append("</B>");
		texto.append(" ").append(numeroExpediente).append("<BR>");
		texto.append("<B>").append(appMessageSource.getMessage("acuserecibido.mail.textofecha", null,
				new Locale(Y41bConstantes.CASTELLANO))).append("</B>");
		texto.append(" ").append(Y41bUtils.parseDateToString(fecha, Y41bConstantes.CASTELLANO)).append("<BR><BR>");

		texto.append("<B>").append(
				appMessageSource.getMessage("acuserecibido.mail.texto", null, new Locale(Y41bConstantes.EUSKERA)))
				.append("</B>");
		texto.append(" ").append(numeroExpediente).append("<BR>");
		texto.append("<B>").append(
				appMessageSource.getMessage("acuserecibido.mail.textofecha", null, new Locale(Y41bConstantes.EUSKERA)))
				.append("</B>");
		texto.append(" ").append(Y41bUtils.parseDateToString(fecha, Y41bConstantes.EUSKERA)).append("<BR><BR>");

		String destinatariosMail = responsableExpediente.getMocoem();

		ArrayList attachments = new ArrayList();

		// Envio mail
		Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from, destinatariosMail, "", attachments);
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y actualiza la
	 * BANDEJA DE FIRMA con los documentos pendientes de firmar Cuando un
	 * documento se inserte en la bandeja de firma, se inserta en Dokusi el
	 * documento si no tiene oidDokusi
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @param faseTramite
	 *            String
	 * @param tipoTramite
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	private void actualizarBandejaFirma(List<DocumentoHecho> listDocumentoHecho, TramiteComun tramiteComun,
			String faseTramite, String tipoTramite) throws Exception {
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			// Elimino de la Bandeja de Firma los documentos del tramite
			BandejaFirma bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
			this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

			// Calculo el numero del expediente para Dokusi
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());

			actuacion = this.actuacionDao.find(actuacion);

			String numeroExpediente = actuacion.getActa().getAccoor() + "-" + actuacion.getActa().getAcnror() + "-"
					+ actuacion.getActa().getAcnran() + "-" + actuacion.getAtnror();

			// Recorro los documentos del tramite buscando aquel documento que
			// este pendiente de firma
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getQ5estadodocumento())) {
					// Si esta pendiente de firma, lo primero lo meto en Dokusi
					// si NO esta dado de alta ya
					if (!Y41bUtils.isFilled(documentoHecho.getQ5iddocumentum())) {

						// Si esta pendiente de firma, lo primero lo meto en
						// Dokusi
						// si NO esta dado de alta ya
						if (!Y41bUtils.isFilled(documentoHecho.getQ5iddocumentum())) {

							if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
									&& documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

								TramiteComun tramiteComunAux = new TramiteComun();
								tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
								tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

								this.soltramexpService.registrarDocumentosDokusiSol(documentoHecho, tramiteComunAux);
							} else if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
									&& documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
								// crear el objeto Sandoctemp
								Sandoctemp sandocTemp = new Sandoctemp();
								sandocTemp.setU5iddocumentum(documentoHecho.getQ5iddocumentum());
								sandocTemp.setU5tipodocumento(documentoHecho.getQ5idTipodoc());
								sandocTemp.setU5codocumento(documentoHecho.getQ5codocumento());
								sandocTemp.setU5nofile(documentoHecho.getQ5nofile());
								sandocTemp.setU5origen(documentoHecho.getQ5origen());
								sandocTemp.setU5ptcodigo(documentoHecho.getQ5ptcodigo());
								sandocTemp.setU5datafile(documentoHecho.getQ5datafile());

								TramiteComun tramiteComunAux = new TramiteComun();
								tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
								tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

								this.soltramexpService.registrarDocumentosDokusiSan(sandocTemp, tramiteComunAux);
							} else if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
									&& documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
								// crear el objeto Sandoctemp
								Arbdoctemp arbdocTemp = new Arbdoctemp();
								arbdocTemp.setX5iddocumentum(documentoHecho.getQ5iddocumentum());
								Arbtipdoc arbtipdoc = new Arbtipdoc();
								arbtipdoc.setTdid(documentoHecho.getQ5idTipodoc());
								arbdocTemp.setArbtipdoc(arbtipdoc);
								arbdocTemp.setX5codocumento(documentoHecho.getQ5codocumento());
								arbdocTemp.setX5nofile(documentoHecho.getQ5nofile());
								arbdocTemp.setX5origen(documentoHecho.getQ5origen());
								arbdocTemp.setX5ptcodigo(documentoHecho.getQ5ptcodigo());
								arbdocTemp.setX5datafile(documentoHecho.getQ5datafile());

								TramiteComun tramiteComunAux = new TramiteComun();
								tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
								tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

								this.soltramexpService.registrarDocumentosDokusiArb(arbdocTemp, tramiteComunAux);
							} else if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
									&& (documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
											|| documentoHecho.getQ5pcodigo()
													.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
											|| documentoHecho.getQ5pcodigo()
													.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

							} else if (documentoHecho != null && documentoHecho.getQ5pcodigo() != null
									&& documentoHecho.getQ5pcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

								TramiteComun tramiteComunAux = new TramiteComun();
								tramiteComunAux.setIdExpediente(documentoHecho.getQ5hdcodigo());
								tramiteComunAux.setIdTramite(documentoHecho.getQ5tramite());

								this.soltramexpService.registrarDocumentosDokusiIns(documentoHecho, tramiteComunAux);
							}
						}
					}

					// Lo segundo lo meto en la Bandeja de Firma
					bandejaFirma = new BandejaFirma();

					bandejaFirma.setIdbandejafirma(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					bandejaFirma.setIdexpediente(tramiteComun.getIdExpediente());
					bandejaFirma.setExpediente(numeroExpediente);
					bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
					bandejaFirma.setHccoor(actuacion.getActdec().getAdcoor());
					bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
					bandejaFirma.setTrcodigo(tipoTramite);

					Fase fase = new Fase();
					fase.setFcodigo(faseTramite);
					bandejaFirma.setFase(fase);

					bandejaFirma.setCodocumento(documentoHecho.getQ5codocumento());
					bandejaFirma.setIddocumentum(documentoHecho.getQ5iddocumentum());
					bandejaFirma.setNofile(documentoHecho.getQ5nofile());
					bandejaFirma.setDesfile(documentoHecho.getQ5tedesfile());
					bandejaFirma.setFechalimfirma(new Date());
					bandejaFirma.setIdperfilfirma(documentoHecho.getQ5idPerfilfirma());

					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoHecho.getQ5iddocumentum());

					Documento documentoRdo = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

					documento.setBytes(new String(Y41bUtilsWS.decode(documentoRdo.getBytes())));

					String hashDocumento = y41bPlateaAdapterService.generarHashDocumento(documento);
					bandejaFirma.setHashfile(hashDocumento);

					if (bandejaFirma.getIdperfilfirma() != null
							&& bandejaFirma.getIdperfilfirma().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
						bandejaFirma.setComoasigfirma(actuacion.getActa().getAccomo());
					}

					this.bandejaFirmaDao.add(bandejaFirma);
				}
			}
		}
	}

	/**
	 * Metodo que actualiza el origen de todos los documentos de un tramite
	 * acuse de recibo con el parametro recibido
	 * 
	 * @param origen
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 */
	private void actualizarOrigenDocsTramiteAcuseRecibo(TramiteComun tramiteComun, String destinatario) {
		String origen_doc = "";
		// Calculamos el origen del documento adjunto en el acuse a
		// partir del destinatario del tramite de notificacion
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(destinatario);
		intervinientes = this.intervinientesDao.find(intervinientes);
		String tipo_interviniente = intervinientes.getTipoInterviniente();
		if (Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE.equals(tipo_interviniente)) {
			origen_doc = Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE;
		} else if (Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO.equals(tipo_interviniente)) {
			origen_doc = Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO;
		} else if (Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO.equals(tipo_interviniente)) {
			origen_doc = Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO;
		} else if (Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE
				.equals(tipo_interviniente)) {
			origen_doc = Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE;
		} else if (Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_ADMINISTRACION.equals(tipo_interviniente)) {
			origen_doc = Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION;
		} else {
			origen_doc = Y41bConstantes.ORIGEN_INS_APORTADO_OTROS;
		}

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
				null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				documentoHecho.setQ5origen(origen_doc);
				this.documentoHechoDao.updateOrigen(documentoHecho);
			}
		}
	}

	/**
	 * Metodo que actualiza el origen de todos los documentos de un tramite de
	 * alegacion con el parametro recibido
	 * 
	 * @param origen
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 */
	private void actualizarOrigenDocsTramiteAlegacion(TramiteComun tramiteComun, String origen) {
		String origen_doc = "";
		if (Y41bUtils.isFilled(origen) && Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO.equals(origen)) {
			origen_doc = Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO;
		} else if (Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTORESPONSABLE.equals(origen)) {
			origen_doc = Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE;
		}
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
				null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			DocumentoHecho documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				documentoHecho.setQ5origen(origen_doc);
				this.documentoHechoDao.updateOrigen(documentoHecho);
			}
		}
	}

	/**
	 * Generar Reintento Tramite de Notificacion
	 * 
	 * @param ehcodigo
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	private void generarReintentoTramiteNotificacion(String ticodigo) throws Exception {

		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTicodigo(ticodigo);

		tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);

		TramiteInspeccion tramiteInspeccionReintento = new TramiteInspeccion();

		tramiteInspeccionReintento.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteInspeccionReintento.setTiatcodigo(tramiteInspeccionAux.getTiatcodigo());
		tramiteInspeccionReintento.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);

		tramiteInspeccionReintento.setTienvrem(tramiteInspeccionAux.getTienvrem());
		tramiteInspeccionReintento.setTifechainicio(new Date());

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdExpediente(tramiteInspeccionAux.getTiatcodigo());

		tramiteInspeccionReintento.setTicomoasignado(obtenerResponsableExpediente(tramiteComunAux));

		tramiteInspeccionReintento.setTifechacomunicacion(new Date());

		tramiteInspeccionReintento.setTiiddestinatario(tramiteInspeccionAux.getTiiddestinatario());

		tramiteInspeccionReintento.setTisede(tramiteInspeccionAux.getTisede());

		tramiteInspeccionReintento.setTitiponotificacionplatea(tramiteInspeccionAux.getTitiponotificacionplatea());

		TramiteInspeccion tramiteInspeccionRel = new TramiteInspeccion();
		tramiteInspeccionRel.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
		tramiteInspeccionReintento.setTramiteInspeccion(tramiteInspeccionRel);

		tramiteInspeccionReintento.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		tramiteInspeccionReintento.setTinotificacionporacta(tramiteInspeccionAux.getTinotificacionporacta());

		tramiteInspeccionReintento.setTitextocomunicacion(tramiteInspeccionAux.getTitextocomunicacion());

		tramiteInspeccionAux = this.tramiteInspeccionDao.findLobTablaTemporal(tramiteInspeccionAux);

		tramiteInspeccionReintento.setTicomentario(tramiteInspeccionAux.getTicomentario());

		tramiteInspeccionReintento.setTiautomatico(Y41bConstantes.VALOR_SI);

		// Se inserta el tramite
		this.tramiteInspeccionService.addTramiteInspeccion(tramiteInspeccionReintento);

		// Buscar los documentos del tramite de notificacion
		tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(ticodigo);
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
				null);

		// Relaciono tramite - documento
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			DocumentoTramiteHecho documentoTramiteHecho = null;
			for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
				documentoTramiteHecho = new DocumentoTramiteHecho();
				documentoTramiteHecho.setEhcodigo(tramiteInspeccionReintento.getTicodigo());
				documentoTramiteHecho.setCodocumento(documentoHechoAux.getQ5codocumento());
				documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
				this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
			}
		}

		this.calcularEstadoTramiteGenerado(tramiteInspeccionReintento);
	}

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailOrigen> findAllMailOrigen(TramiteComun tramiteComun, Pagination pagination) {

		List<DatosMailOrigen> listDatosMailOrigen = new ArrayList<DatosMailOrigen>();

		// Obtener el numero de expediente
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteComun.getIdExpediente());

		actuacion = this.actuacionDao.find(actuacion);

		// Buscar el monitor
		CensoMonitor remitente = new CensoMonitor();
		remitente.setMocodigo(actuacion.getActa().getAccomo());

		remitente = this.censoMonitorDao.find(remitente);

		DatosMailOrigen datosMailOrigen = new DatosMailOrigen();

		datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE);
		datosMailOrigen.setEmail(remitente.getMocoem());
		datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCION);
		datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE);

		listDatosMailOrigen.add(datosMailOrigen);

		// Buscar el organismo
		Organismo organismo = new Organismo();
		organismo.setCodOrg(actuacion.getActdec().getAdcoor());

		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

		datosMailOrigen = new DatosMailOrigen();

		datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_GENERICO);
		datosMailOrigen.setEmail(organismo.getEmail());
		datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCION);
		datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCIONE);

		listDatosMailOrigen.add(datosMailOrigen);

		datosMailOrigen = new DatosMailOrigen();

		datosMailOrigen.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_CONTROL_MERCADO);

		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.PARAMETRO_CONTROLMERCADO_FROMGENERICO);
		parametros = this.parametrosDao.find(parametros);

		datosMailOrigen.setEmail(parametros.getValor());

		datosMailOrigen.setDescripcion(Y41bConstantes.MAIL_ORIGEN_CONTROL_MERCADO_DESCRIPCION);
		datosMailOrigen.setDescripcione(Y41bConstantes.MAIL_ORIGEN_CONTROL_MERCADO_DESCRIPCIONE);

		listDatosMailOrigen.add(datosMailOrigen);

		return listDatosMailOrigen;
	}

	/**
	 * Finds a single row in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailOrigen
	 *            DatosMailOrigen
	 * @return DatosMailOrigen
	 */
	public DatosMailOrigen findMailOrigen(TramiteComun tramiteComun, DatosMailOrigen datosMailOrigen) {
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteComun.getIdExpediente());
		actuacion = this.actuacionDao.find(actuacion);

		DatosMailOrigen datosMailOrigenAux = new DatosMailOrigen();

		if (Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE.equals(datosMailOrigen.getIdDatomail())) {
			// Buscar el monitor
			CensoMonitor remitente = new CensoMonitor();
			remitente.setMocodigo(actuacion.getActa().getAccomo());

			remitente = this.censoMonitorDao.find(remitente);

			datosMailOrigenAux.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_RESPONSABLE);
			datosMailOrigenAux.setEmail(remitente.getMocoem());
			datosMailOrigenAux.setDescripcion(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCION);
			datosMailOrigenAux.setDescripcione(Y41bConstantes.MAIL_ORIGEN_RESPONSABLE_DESCRIPCIONE);
		} else if (Y41bConstantes.ID_MAIL_ORIGEN_GENERICO.equals(datosMailOrigen.getIdDatomail())) {
			// Buscar el organismo
			Organismo organismo = new Organismo();
			organismo.setCodOrg(actuacion.getActdec().getAdcoor());

			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			datosMailOrigenAux.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_GENERICO);
			datosMailOrigenAux.setEmail(organismo.getEmail());
			datosMailOrigenAux.setDescripcion(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCION);
			datosMailOrigenAux.setDescripcione(Y41bConstantes.MAIL_ORIGEN_GENERICO_DESCRIPCIONE);
		} else if (Y41bConstantes.ID_MAIL_ORIGEN_CONTROL_MERCADO.equals(datosMailOrigen.getIdDatomail())) {

			datosMailOrigenAux.setIdDatomail(Y41bConstantes.ID_MAIL_ORIGEN_CONTROL_MERCADO);

			Parametros parametros = new Parametros();
			parametros.setParametro(Y41bConstantes.PARAMETRO_CONTROLMERCADO_FROMGENERICO);
			parametros = this.parametrosDao.find(parametros);

			datosMailOrigenAux.setEmail(parametros.getValor());
			datosMailOrigenAux.setDescripcion(Y41bConstantes.MAIL_ORIGEN_CONTROL_MERCADO_DESCRIPCION);
			datosMailOrigenAux.setDescripcione(Y41bConstantes.MAIL_ORIGEN_CONTROL_MERCADO_DESCRIPCIONE);
		}

		return datosMailOrigenAux;
	}

	/**
	 * Finds a List of rows in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailEstablecimiento> findAllMailEstablecimiento(TramiteComun tramiteComun,
			Intervinientes intervinientes, Pagination pagination) {

		List<DatosMailEstablecimiento> listDatosMailEstablecimiento = new ArrayList<DatosMailEstablecimiento>();

		intervinientes = this.intervinientesDao.find(intervinientes);

		DatosMailEstablecimiento datosMailEstablecimiento = new DatosMailEstablecimiento();

		datosMailEstablecimiento.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
		datosMailEstablecimiento.setEmail(intervinientes.getCoem());
		datosMailEstablecimiento.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
		datosMailEstablecimiento.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		listDatosMailEstablecimiento.add(datosMailEstablecimiento);

		// buscar todos los mails del establecimiento
		DatosMailEstablecimiento datosMailEstablecimientoAux = new DatosMailEstablecimiento();
		datosMailEstablecimientoAux.setEscodigo(intervinientes.getEscodigo());

		List<DatosMailEstablecimiento> listDatosMailEstablecimientoAux = this.datosMailEstablecimientoDao
				.findAll(datosMailEstablecimientoAux, null);

		for (DatosMailEstablecimiento datosMailEstablecimientoAux2 : listDatosMailEstablecimientoAux) {
			// aadirlo a la lista
			listDatosMailEstablecimiento.add(datosMailEstablecimientoAux2);
		}

		return listDatosMailEstablecimiento;
	}

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param idDestinatario
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailEstablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	public DatosMailEstablecimiento findMailEstablecimiento(String idDestinatario, TramiteComun tramiteComun,
			DatosMailEstablecimiento datosMailEstablecimiento) {

		DatosMailEstablecimiento datosMailEstablecimientoAux = new DatosMailEstablecimiento();

		if (Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL.equals(datosMailEstablecimiento.getIdDatomail())) {
			// buscar el interviniente demandado
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
			intervinientes.setIdinterviniente(idDestinatario);
			// intervinientes
			// .setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

			if (listIntervinientes.size() > 0) {
				datosMailEstablecimientoAux.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
				datosMailEstablecimientoAux.setEmail(listIntervinientes.get(0).getCoem());
				datosMailEstablecimientoAux.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
				datosMailEstablecimientoAux.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

			}

		} else {
			datosMailEstablecimientoAux = this.datosMailEstablecimientoDao.find(datosMailEstablecimiento);
		}

		return datosMailEstablecimientoAux;
	}

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DatosMailSede> findAllMailEstablecimientoSede(TramiteComun tramiteComun, Intervinientes intervinientes,
			Pagination pagination) {

		List<DatosMailSede> listDatosMailSede = new ArrayList<DatosMailSede>();

		Sede sede = new Sede();
		sede.setEscodigo(intervinientes.getEscodigo());
		sede.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);

		sede = this.establecimientoService.findEstablecimientoSede(sede);

		DatosMailSede datosMailSede = new DatosMailSede();

		datosMailSede.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
		datosMailSede.setEmail(sede.getEmail());
		datosMailSede.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
		datosMailSede.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		listDatosMailSede.add(datosMailSede);

		// buscar todos los mails del establecimiento
		DatosMailSede datosMailSedeAux = new DatosMailSede();
		datosMailSedeAux.setEscodigo(intervinientes.getEscodigo());
		datosMailSedeAux.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

		List<DatosMailSede> listDatosMailSedeAux = this.datosMailSedeDao.findAll(datosMailSedeAux, null);

		for (DatosMailSede datosMailSedeAux2 : listDatosMailSedeAux) {
			// aadirlo a la lista
			listDatosMailSede.add(datosMailSedeAux2);
		}

		return listDatosMailSede;
	}

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailSede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	public DatosMailSede findMailEstablecimientoSede(TramiteComun tramiteComun, DatosMailSede datosMailSede) {

		DatosMailSede datosMailSedeAux = new DatosMailSede();

		if (Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL.equals(datosMailSede.getIdDatomail())) {

			Sede sede = new Sede();
			sede.setEscodigo(datosMailSede.getEscodigo());
			sede.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);

			sede = this.establecimientoService.findEstablecimientoSede(sede);

			datosMailSedeAux.setIdDatomail(Y41bConstantes.ID_MAIL_ESTABLECIMIENTO_PRINCIPAL);
			datosMailSedeAux.setEmail(sede.getEmail());
			datosMailSedeAux.setDescripcion(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCION);
			datosMailSedeAux.setDescripcione(Y41bConstantes.MAIL_ESTABLECIMIENTO_DESCRIPCIONE);

		} else {
			datosMailSedeAux = this.datosMailSedeDao.find(datosMailSede);
		}

		return datosMailSedeAux;
	}

	/**
	 * Metodo que actualiza el estado de los tramites generados
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return String
	 */
	private String calcularDestinatarioComunicacionNotificacion(TramiteInspeccion tramiteInspeccion) {
		// Calcular el destinatario
		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteInspeccion.getTiestadotramite())) {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteInspeccion.getTiatcodigo());

			actuacion = this.actuacionDao.find(actuacion);

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(tramiteInspeccion.getTiiddestinatario());

			intervinientes = this.intervinientesDao.find(intervinientes);

			if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
					.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO)) {
				if (actuacion.getAtdestnotificavisitado() != null && actuacion.getAtdestnotificavisitado()
						.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

					// buscar el representante
					Intervinientes intervinientesAux = new Intervinientes();
					intervinientesAux.setIdExpediente(actuacion.getAtcodigo());
					intervinientesAux.setTipoInterviniente(
							Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO);
					intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

					if (intervinientesAux != null && Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
						return intervinientesAux.getIdinterviniente();
					} else {

						intervinientesAux = new Intervinientes();
						intervinientesAux.setIdExpediente(actuacion.getAtcodigo());
						intervinientesAux.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO);
						intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

						if (intervinientesAux != null && Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
							return intervinientesAux.getIdinterviniente();
						} else {
							// Si no existe se pone como destinatario el titular
							return tramiteInspeccion.getTiiddestinatario();
						}
					}

				} else {
					return tramiteInspeccion.getTiiddestinatario();
				}

			} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
					.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)) {
				if (actuacion.getAtdestnotificaresponsable() != null && actuacion.getAtdestnotificaresponsable()
						.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

					// buscar el representante
					Intervinientes intervinientesAux = new Intervinientes();
					intervinientesAux.setIdExpediente(actuacion.getAtcodigo());
					intervinientesAux.setTipoInterviniente(
							Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE);
					intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

					if (intervinientesAux != null && Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
						return intervinientesAux.getIdinterviniente();
					} else {

						intervinientesAux = new Intervinientes();
						intervinientesAux.setIdExpediente(actuacion.getAtcodigo());
						intervinientesAux.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO);
						intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

						if (intervinientesAux != null && Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {
							return intervinientesAux.getIdinterviniente();
						} else {
							// Si no existe se pone como destinatario el titular
							return tramiteInspeccion.getTiiddestinatario();
						}
					}

				} else {
					return tramiteInspeccion.getTiiddestinatario();
				}

			} else {
				return tramiteInspeccion.getTiiddestinatario();
			}

		} else {
			return tramiteInspeccion.getTiiddestinatario();
		}
	}

	/**
	 * Metodo que manda un email con la información de comunicacion recibida
	 * por parametro.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	private boolean envioEmailComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			List<Adjuntardocs> listadjuntardocs, CensoMonitor censoMonitor)
			throws SerialException, SQLException, Exception {
		DocumentoHechoDetalle documentoHechoDetalle = null;
		try {
			// 1. Calculo FROM + TO del email

			String from = tramiteComunicacion.getMailorigen();

			String destinatariosMail = "";

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(tramiteComunicacion.getDestinatario());

			intervinientes = this.intervinientesDao.find(intervinientes);

			if (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)
					|| intervinientes.getTipoInterviniente()
							.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_ESTABLECIMIENTO)) {
				destinatariosMail = tramiteComunicacion.getMaildestino();
			} else {
				destinatariosMail = intervinientes.getCoem();
			}

			if (!Y41bUtils.isFilled(destinatariosMail) || !Y41bUtils.isFilled(from)) {
				throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
			}

			StringBuffer destinatarios = new StringBuffer();
			destinatarios.append(destinatariosMail);

			StringBuffer copiaoculta = new StringBuffer();
			copiaoculta.append(censoMonitor.getMocoem());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

			// 2. Creo el asunto
			// Calculo el numero de expediente
			StringBuffer numeroExpediente = new StringBuffer();
			numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-")
					.append(this.findNumExpedienteActuacion(tramiteComun.getIdExpediente()));

			StringBuffer asunto = new StringBuffer();
			if (Y41bUtils.isFilled(tramiteComunicacion.getAsuntoComunicacion())) {
				asunto.append(tramiteComunicacion.getAsuntoComunicacion());
			} else {
				// Castellano
				asunto.append(appMessageSource.getMessage("comunicacion.mail.asunto", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				asunto.append(" ").append(numeroExpediente).append(" / ");
				// Euskera
				asunto.append(appMessageSource.getMessage("comunicacion.mail.asunto", null,
						new Locale(Y41bConstantes.EUSKERA)));
				asunto.append(" ").append(numeroExpediente);
			}

			// 3. Creo el contenido del mail
			StringBuffer texto = new StringBuffer();
			texto.append("<B>").append(appMessageSource.getMessage("comunicacion.mail.texto", null,
					new Locale(Y41bConstantes.CASTELLANO)));
			texto.append(" / ").append(
					appMessageSource.getMessage("comunicacion.mail.texto", null, new Locale(Y41bConstantes.EUSKERA)))
					.append("</B><BR><BR>");
			texto.append(tramiteComunicacion.getTextoComunicacion().replaceAll("\n", "<BR>"));

			// 4. Creo attachments del mail
			List<AttachFile> attachments = new ArrayList<AttachFile>();

			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					PlantillaTramite plantillaTramite = null;
					if (adjuntardocs != null && adjuntardocs.getPtcodigo() != null
							&& !adjuntardocs.getPtcodigo().equals("")) {
						plantillaTramite = new PlantillaTramite();
						plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());
						// Obtener la plantilla del tramite
						plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);
					}

					if (Y41bUtils.isDocumentoLocalizable(adjuntardocs)) {
						if (!StringUtils.isBlank(adjuntardocs.getThiddocumentum())) {
							Documento documento = new Documento();
							// 1.User
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
							documento.setProcedure(procedure);
							documento.setOidDokusi(adjuntardocs.getThiddocumentum());
							Formato formato = y41bDokusiAdapterService.recuperarFormatosDocumentosDokusi(documento);

							if (formato != null && formato.getName().equals(Y41bConstantes.PDFA)) {
								if (adjuntardocs != null && adjuntardocs.getThnofile() != null
										&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(adjuntardocs.getThnofile())
												.equalsIgnoreCase(Y41bConstantes.PDF)) {
									throw new Y41bUDAException("error.documentos.sinlocalizador", true,
											new Exception());
								}
							} else {
								throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
							}
						} else {
							throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
						}
					}

					AttachFile fileattach = new AttachFile();
					documentoHechoDetalle = new DocumentoHechoDetalle();
					documentoHechoDetalle.setQ5codocumento(adjuntardocs.getThcodocumento());
					documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

					fileattach.setContentType(documentoHechoDetalle.getQ5contenttypefile());
					fileattach.setNombre(documentoHechoDetalle.getQ5nofile());
					fileattach.setAdjunto(documentoHechoDetalle.getQ5datafile());

					attachments.add(fileattach);
				}
			}

			// 5. Envio mail
			boolean envio = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
					destinatarios.toString(), copiaoculta.toString(), attachments);

			return envio;
		} finally {

		}
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHecho(TramiteComun tramiteComun, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("fecha")) {
				pagination.setSort("Q5FECHA");
			}
			if (pagination.getSort() == null || pagination.getSort().equals("origen")) {
				pagination.setSort("Q5ORIGEN");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("tedesfile")) {
				pagination.setSort("Q5TEDESFILE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("fnombre")) {
				pagination.setSort("FNOMBRE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("fnombree")) {
				pagination.setSort("FNOMBREE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("trnombre")) {
				pagination.setSort("TRNOMBRE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("trnombree")) {
				pagination.setSort("TRNOMBREE");
			}
		}

		// return this.documentoHechoDao.findAllDocumentosHechoInspeccion(
		// tramiteComun, pagination);
		return this.documentoHechoDao.findAllDocumentosHechoInspeccion(tramiteComun, pagination);
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoCount(TramiteComun tramiteComun) {
		// return this.documentoHechoDao
		// .findAllDocumentosHechoInspeccionCount(tramiteComun);
		return this.documentoHechoDao.findAllDocumentosHechoInspeccionCount(tramiteComun);
	}

	/**
	 * Esta funcion actualiza la bandeja de propuesta de sancion con la
	 * informacion del tramitehecho recibido por parametro
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 */
	public void tratamientoBandejaPropuestaSancion(TramiteInspeccion tramiteInspeccion) {
		logger.info("Inspecciones - TratamientoBandejaPropuestaSancion - Ini");
		Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
		// Codigo de actuacion
		sanpropbandeja.setBaprsanexcodigo(tramiteInspeccion.getTiatcodigo());
		// Num expediente
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteInspeccion.getTiatcodigo());
		InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);
		StringBuffer numeroExpediente = new StringBuffer();
		numeroExpediente.append(inspeccionDetalle.getAccoor()).append("-").append(inspeccionDetalle.getAcnror())
				.append("-").append(inspeccionDetalle.getAcnran()).append("-").append(inspeccionDetalle.getAtnror());

		sanpropbandeja.setBaprsanexcodigocompleto(numeroExpediente.toString());

		// Procedimiento
		sanpropbandeja.setBaprsanpcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		// Fecha registro
		Date fechaPropuestaSancion = null;

		// obtener la fecha del acta de infraccion tramitada
		Pagination pagination = new Pagination();
		pagination.setSort("ANFECHA");
		pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);

		ActaNueva actanuevaAux = new ActaNueva();
		actanuevaAux.setAncodins(tramiteInspeccion.getTiatcodigo());
		actanuevaAux.setAntipo(Y41bConstantes.ACTA_NUEVA_TIPO_INFRACCION);
		actanuevaAux.setAnligadoprotocolo(null);
		List<ActaNueva> listActaNuevaInfraccion = this.actaNuevaDao.findAllActaInfraccionTramitada(actanuevaAux,
				pagination);

		if (listActaNuevaInfraccion != null && listActaNuevaInfraccion.size() > 0) {
			fechaPropuestaSancion = listActaNuevaInfraccion.get(0).getAnfecha();
		}

		// Si no hay acta de infraccion, se coge la fecha del registro
		if (fechaPropuestaSancion == null) {
			fechaPropuestaSancion = inspeccionDetalle.getAcfere();
		}

		sanpropbandeja.setBaprsanfec(fechaPropuestaSancion);

		// Responsable del expediente
		sanpropbandeja.setBaprsanrespexp(inspeccionDetalle.getMocodigo());

		// buscar el interviniente
		String tipo_interviniente_destinatario = "";
		if (Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTOVISITADO.equals(tramiteInspeccion.getTidestinatario())) {
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO;
		} else if (Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTORESPONSABLE
				.equals(tramiteInspeccion.getTidestinatario())) {
			tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE;
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteInspeccion.getTiatcodigo());
		intervinientes.setTipoInterviniente(tipo_interviniente_destinatario);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			sanpropbandeja.setBaprsansancionado(listIntervinientes.get(0).getEscodigo());
			sanpropbandeja.setBaprsanmunic(listIntervinientes.get(0).getNoraMunicipioId());
			sanpropbandeja.setBaprsanprov(listIntervinientes.get(0).getNoraProvinciaId());

			sanpropbandejaService.add(sanpropbandeja);
		}

		logger.info("Inspecciones - TratamientoBandejaPropuestaSancion - Ini");
	}

	/**
	 * Esta funcion realiza el tratamiento de la decisin de traslado
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 */
	public void tratamientoDecisionTraslado(TramiteRegistroDecision tramiteRegistroDecision, TramiteComun tramiteComun)
			throws Exception {
		if (Y41bConstantes.DECISION_INSPECCIONES_TRASLADO.equals(tramiteRegistroDecision.getTipoDecision())) {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(tramiteRegistroDecision.getCodOrgTraslado());

			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

			// buscar el interviniente interesado
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_OTROS);

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

			Intervinientes intervinientesAux = new Intervinientes(
					Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, null,
					organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(), null,
					null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null, organismo.getEmail(),
					esExtranjero, organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
					organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(),
					organismo.getNombreLocalidad(), organismo.getNoraCalleId(), organismo.getNombreCalle(),
					organismo.getNoraCpId(), organismo.getNombreCp(), organismo.getNoraPortalId(),
					organismo.getNombrePortal(), organismo.getCompleDirec(), organismo.getNoraPaisId(),
					organismo.getNombrePais(), organismo.getNombreCalle(), null, null, null, null, null,
					Y41bConstantes.TIPO_INTERVINIENTESOL_OTROS, intervinientes.getIdExpediente(), null, null, null,
					null);

			if (listIntervinientes != null && listIntervinientes.size() > 0) {
				intervinientesAux.setIdinterviniente(listIntervinientes.get(0).getIdinterviniente());
				this.intervinientesDao.update(intervinientesAux);
			} else {
				this.intervinientesDao.add(intervinientesAux);
			}

			this.generarTramiteComunicacionOtrosRegistroDecision(tramiteRegistroDecision, tramiteComun,
					intervinientesAux);
		}

	}

	/**
	 * Comprueba si existen tramites de apertura (asignacion de expediente y
	 * registro de inspeccion) en base a un codigo de acta.
	 * 
	 * @param acta
	 *            Acta
	 * @return boolean
	 */
	public boolean existenTramitesAperturaPorActa(Acta acta) {
		List<TramiteInspeccion> tramitesInspeccion = this.tramiteInspeccionDao.findTramitesAperturaPorActa(acta);

		return tramitesInspeccion.size() > 0;
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los adjunta en
	 * los tramites correspondientes
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 *             Exception
	 */
	public void adjuntarDocumentosTramiteCorrespondiente(List<DocumentoHecho> listDocumentoHecho,
			TramiteComun tramiteComun) throws Exception {
		// MODIFICACIONES DE LA TRAMITACION DE APORTACION DE DOCUMENTOS
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				if (documentoHecho.getQ5idTipodoc() != null
						&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_REQUERIMIENTO)) {
					// se debe buscar el trmite de recepcin de
					// requerimiento pendiente de tramitar
					// con el destino que coincida con el origen de la
					// aportacin y aportarlo. Si existe ms de un trmite,
					// se aportar al ltimo trmite pendiente de recepcin.
					TramiteInspeccionDetalle tramiteInspeccionDetalleAux = new TramiteInspeccionDetalle();
					tramiteInspeccionDetalleAux
							.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_REQUERIMIENTO);
					tramiteInspeccionDetalleAux.setAtcodigo(tramiteComun.getIdExpediente());

					try {
						tramiteInspeccionDetalleAux = this.tramiteInspeccionDao
								.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteInspeccionDetalleAux);
					} catch (Exception e) {
					}

					if (tramiteInspeccionDetalleAux != null && tramiteInspeccionDetalleAux.getTicodigo() != null) {
						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteInspeccionDetalleAux.getTicodigo());
						documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					}

				} else if (documentoHecho.getQ5idTipodoc() != null
						&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_RECURSO)) {
					// habr que buscar el ultimo, sino generarlo
					// se genere automticamente el trmite de recepcin de
					// recurso de alzada y se adjunte el documento al
					// tramite
					TramiteInspeccionDetalle tramiteInspeccionDetalleAux = new TramiteInspeccionDetalle();
					tramiteInspeccionDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_RECURSO);
					tramiteInspeccionDetalleAux.setAtcodigo(tramiteComun.getIdExpediente());
					try {
						tramiteInspeccionDetalleAux = this.tramiteInspeccionDao
								.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteInspeccionDetalleAux);
					} catch (Exception e) {
					}

					if (tramiteInspeccionDetalleAux != null && tramiteInspeccionDetalleAux.getTicodigo() != null) {
						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteInspeccionDetalleAux.getTicodigo());
						documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					} else {
						// generar tramite y adjuntar el documento
						this.generarTramiteRecepcionRecurso(tramiteComun, documentoHecho);
					}
				} else if (documentoHecho.getQ5idTipodoc() != null
						&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_ORDEN)) {
					// se debe buscar el trmite de recepcin de orden de
					// consejero y aportarlo. Si existe ms de un trmite,
					// se aportar al ltimo trmite pendiente de recepcin.
					TramiteInspeccionDetalle tramiteInspeccionDetalleAux = new TramiteInspeccionDetalle();
					tramiteInspeccionDetalleAux
							.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ORDEN_DEL_CONSEJERO);
					tramiteInspeccionDetalleAux.setAtcodigo(tramiteComun.getIdExpediente());
					try {
						tramiteInspeccionDetalleAux = this.tramiteInspeccionDao
								.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteInspeccionDetalleAux);
					} catch (Exception e) {
					}

					if (tramiteInspeccionDetalleAux != null && tramiteInspeccionDetalleAux.getTicodigo() != null) {
						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteInspeccionDetalleAux.getTicodigo());
						documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					}
				} else if (documentoHecho.getQ5idTipodoc() != null
						&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_ALEGACION)) {
					// habr que buscar el ultimo, sino generarlo
					// se genere automticamente el trmite de recepcin de
					// alegaciones y se adjunte el documento al
					// tramite
					TramiteInspeccionDetalle tramiteInspeccionDetalleAux = new TramiteInspeccionDetalle();
					tramiteInspeccionDetalleAux.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ALEGACIONES);
					tramiteInspeccionDetalleAux.setAtcodigo(tramiteComun.getIdExpediente());
					try {
						tramiteInspeccionDetalleAux = this.tramiteInspeccionDao
								.findUltimoTramiteHechoPorTipoTramiteNoTramitado(tramiteInspeccionDetalleAux);
					} catch (Exception e) {
					}

					if (tramiteInspeccionDetalleAux != null && tramiteInspeccionDetalleAux.getTicodigo() != null) {
						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteInspeccionDetalleAux.getTicodigo());
						documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					} else {
						// generar tramite y adjuntar el documento
						this.generarTramiteRecepcionAlegacion(tramiteComun, documentoHecho);
					}
				} else if (documentoHecho.getQ5idTipodoc() != null && documentoHecho.getQ5idTipodoc()
						.equals(Y41bConstantes.TIPO_DOC_ACREDITACION_REPRESENTACION)) {
					// habr que buscar el ultimo, sino generarlo
					// se genere automticamente el trmite de recepcin de
					// recurso de alzada y se adjunte el documento al
					// tramite
					TramiteInspeccionDetalle tramiteInspeccionDetalleAux = new TramiteInspeccionDetalle();
					tramiteInspeccionDetalleAux
							.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ACREDITACION_REPRESENTACION);
					tramiteInspeccionDetalleAux.setAtcodigo(tramiteComun.getIdExpediente());

					String origen = "";
					if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO))) {
						origen = Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO;
					} else if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE))) {
						origen = Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTORESPONSABLE;
					}

					try {
						tramiteInspeccionDetalleAux = this.tramiteInspeccionDao
								.findUltimoTramiteHechoPorTipoTramiteYOrigenNoTramitado(tramiteInspeccionDetalleAux,
										origen);
					} catch (Exception e) {
					}

					if (tramiteInspeccionDetalleAux != null && tramiteInspeccionDetalleAux.getTicodigo() != null) {
						DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
						documentoTramiteHecho.setEhcodigo(tramiteInspeccionDetalleAux.getTicodigo());
						documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
						documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
						this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					} else {
						// generar tramite y adjuntar el documento
						this.generarTramiteRecepcionAcreditacionRepresentacion(tramiteComun, documentoHecho);
					}
				}
			}
		}
	}

	/**
	 * Esta funcion realiza el tratamiento del cierre en la decisin
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void tratamientoCierreDecision(TramiteComun tramiteComun) {
		// Miramos si existe tramite de cierre
		boolean isTramiteCierre = tramiteInspeccionService.existeTramite(tramiteComun.getIdExpediente(),
				Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);
		if (isTramiteCierre) {
			// Actualizamos las fechas del tramite de cierre del
			// expediente
			// (fecha inicio y fecha limite)
			tramiteInspeccionService.updateFechasTramiteCierre(tramiteComun.getIdExpediente());
		} else {
			// JGREY. Comentado por 86471: [Evolutivo Bandejas ] -
			// Trmite de
			// Cierre - Solicitudes

			// Generamos tramite de cierre
			// this.generarTramiteCierreAutomaticoRegistroDecision(
			// tramiteRegistroDecision, tramiteComun);
		}
	}

	/**
	 * Esta funcion realiza la modificacion de la decisin del expediente
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void tratamientoModificacionDecision(TramiteRegistroDecision tramiteRegistroDecision,
			TramiteComun tramiteComun) {
		// Modificamos la decision de la inspeccion
		Actdec actdec = new Actdec();
		actdec.setAdcoat(tramiteComun.getIdExpediente());
		actdec = this.actdecDao.findDecisionInspeccion(actdec);
		Actdec actdecAux = new Actdec();
		actdecAux.setAdcodigo(actdec.getAdcodigo());
		actdecAux.setAdfede(tramiteRegistroDecision.getFechaDecision());
		actdecAux.setAdcottd(tramiteRegistroDecision.getTipoDecision());
		this.actdecDao.updateDecision(actdecAux);
	}

	/**********************
	 * INTEGRACION PLATEA *
	 **********************/

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI
	 * 
	 * @param insDetalle
	 *            InspeccionDetalle
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws SQLException
	 *             SQLException
	 * @throws ParseException
	 *             ParseException
	 */
	public void abrirExpedienteOficioPlatea(InspeccionDetalle insDetalle, TramiteComun tramiteComun)
			throws SQLException, ParseException {

		if (!Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getNif())) {
			throw new Y41bUDAException("error.inspecciones.nifEstablecimientoVisitadoException", true, new Exception());
		}

		// Abrir el expediente oficio
		SolicitudOficio solicitudOficio = new SolicitudOficio();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

		solicitudOficio.setProcedure(procedure);

		solicitudOficio.setIdParticipacion(insDetalle.getAtidparticipacionvisitado());

		DatosPersona datosPersona = new DatosPersona();
		CensoMonitor censoMonitorSender = new CensoMonitor();
		censoMonitorSender.setMocodigo(insDetalle.getMocodigo());
		censoMonitorSender = censoMonitorDao.find(censoMonitorSender);
		datosPersona.setDni(censoMonitorSender.getModni());
		datosPersona.setNombre(censoMonitorSender.getMonombre());
		solicitudOficio.setSender(datosPersona);

		datosPersona = new DatosPersona();
		datosPersona.setDni(insDetalle.getEstablecimientoV().getNif());
		datosPersona.setNombre(insDetalle.getEstablecimientoV().getNombre());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			datosPersona.setApellido1(new StringBuffer(insDetalle.getEstablecimientoV().getApellido1()).toString());

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido2())) {
				datosPersona.setApellido1(new StringBuffer(insDetalle.getEstablecimientoV().getApellido1()).append(" ")
						.append(insDetalle.getEstablecimientoV().getApellido2()).toString());
			}
		}

		// datosPersona.setMail(insDetalle.getEstablecimientoV().getCoem());
		// datosPersona.setTelefono(insDetalle.getEstablecimientoV().getNrtel());
		// datosPersona.setIdioma(insDetalle.getAtidiomaestablecimientovi());
		solicitudOficio.setSancionado(datosPersona);

		solicitudOficio.setIdiomaNotificacion(insDetalle.getAtidiomaestablecimientovi());

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
				.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
				.append(insDetalle.getAtnror());

		solicitudOficio.setNumeroExpediente(numeroExpediente.toString());

		solicitudOficio.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		if (insDetalle.getAperturaTimestamp() != null) {
			solicitudOficio.setAperturaTimestamp(insDetalle.getAperturaTimestamp());
		}

		y41bPlateaAdapterService.crearSolicitudOficio(solicitudOficio);
	}

	/**
	 * Actualiza la participacin del establecimiento visitado
	 * 
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarParticipacionEstablecimientoVisitado(TramiteComun tramiteComun) throws Exception {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteComun.getIdExpediente());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		// actualizar expediente
		ActualizarExpediente actualizarExpediente = new ActualizarExpediente();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
		actualizarExpediente.setProcedure(procedure);

		actualizarExpediente.setIdParticipacion(insDetalle.getAtidparticipacionvisitado());

		// Reclamante
		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(insDetalle.getEstablecimientoV().getNif());
		datosPersona.setNombre(insDetalle.getEstablecimientoV().getNombre());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			datosPersona.setApellido1(new StringBuffer(insDetalle.getEstablecimientoV().getApellido1()).toString());

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido2())) {
				datosPersona.setApellido1(new StringBuffer(insDetalle.getEstablecimientoV().getApellido1()).append(" ")
						.append(insDetalle.getEstablecimientoV().getApellido2()).toString());
			}
		}

		// Si tiene representante los datos sern del representante
		// datosPersona.setMail(insDetalle.getEstablecimientoV().getCoem());
		// datosPersona.setTelefono(insDetalle.getEstablecimientoV().getNrtel());
		// datosPersona.setIdioma(insDetalle.getAtidiomaestablecimientovi());

		// buscar el representante del reclamante validado
		// si existe se aade
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO);
		intervinientes = this.intervinientesDao.findIntervinienteTipo(intervinientes);

		if (intervinientes != null && Y41bUtils.isFilled(intervinientes.getNif())) {

			DatosPersona datosPersonaRepresentante = new DatosPersona();
			datosPersonaRepresentante.setDni(intervinientes.getNif());
			datosPersonaRepresentante.setNombre(intervinientes.getNombre());

			if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
				datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).toString());

				if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
					datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).append(" ")
							.append(intervinientes.getApellido2()).toString());
				}
			}
			actualizarExpediente.setRepresentante(datosPersonaRepresentante);

			// Si tiene representante los datos sern del representante
			datosPersona.setMail(intervinientes.getCoem());
			datosPersona.setTelefono(intervinientes.getNrtel());
		}

		// En actualizarExpediente el solicitante es el titular de la
		// participacin, en nuestro caso
		// el establecimiento visitado
		actualizarExpediente.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
				.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
				.append(insDetalle.getAtnror());

		actualizarExpediente.setNumeroExpediente(numeroExpediente.toString());

		actualizarExpediente.setEjercicio(insDetalle.getAcnran().toString());

		actualizarExpediente.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		this.y41bPlateaAdapterService.actualizarParticipantExpediente(actualizarExpediente);
	}

	/**
	 * Actualiza la participacin del establecimiento responsable
	 * 
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarParticipacionEstablecimientoResponsable(TramiteComun tramiteComun) throws Exception {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteComun.getIdExpediente());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		// actualizar expediente
		ActualizarExpediente actualizarExpediente = new ActualizarExpediente();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
		actualizarExpediente.setProcedure(procedure);

		actualizarExpediente.setIdParticipacion(insDetalle.getAtidparticipacionresponsable());

		// Establecimiento responsable
		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(insDetalle.getEstablecimientoR().getNif());
		datosPersona.setNombre(insDetalle.getEstablecimientoR().getNombre());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido1())) {
			datosPersona.setApellido1(new StringBuffer(insDetalle.getEstablecimientoR().getApellido1()).toString());

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido2())) {
				datosPersona.setApellido1(new StringBuffer(insDetalle.getEstablecimientoR().getApellido1()).append(" ")
						.append(insDetalle.getEstablecimientoV().getApellido2()).toString());
			}
		}

		// Si tiene representante los datos sern del representante
		// datosPersona.setMail(insDetalle.getEstablecimientoV().getCoem());
		// datosPersona.setTelefono(insDetalle.getEstablecimientoV().getNrtel());
		// datosPersona.setIdioma(insDetalle.getAtidiomaestablecimientovi());

		// buscar el representante del establecimiento responsable validado
		// si existe se aade
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE);
		intervinientes = this.intervinientesDao.findIntervinienteTipo(intervinientes);

		if (intervinientes != null && Y41bUtils.isFilled(intervinientes.getNif())) {

			DatosPersona datosPersonaRepresentante = new DatosPersona();
			datosPersonaRepresentante.setDni(intervinientes.getNif());
			datosPersonaRepresentante.setNombre(intervinientes.getNombre());

			if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
				datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).toString());

				if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
					datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).append(" ")
							.append(intervinientes.getApellido2()).toString());
				}
			}
			actualizarExpediente.setRepresentante(datosPersonaRepresentante);

			// Si tiene representante los datos sern del representante
			datosPersona.setMail(intervinientes.getCoem());
			datosPersona.setTelefono(intervinientes.getNrtel());
		}

		// En actualizarExpediente el solicitante es el titular de la
		// participacin, en nuestro caso
		// el establecimiento responsable
		actualizarExpediente.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
				.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
				.append(insDetalle.getAtnror());

		actualizarExpediente.setNumeroExpediente(numeroExpediente.toString());

		actualizarExpediente.setEjercicio(insDetalle.getAcnran().toString());

		actualizarExpediente.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		this.y41bPlateaAdapterService.actualizarParticipantExpediente(actualizarExpediente);
	}

	/**
	 * Esta funcion realiza el tratamiento de mis gestiones para el acuse recibo
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @throws Exception
	 */
	public void tratamientoMisGestionesAcuseRecibo(TramiteInspeccion tramiteInspeccion) throws Exception {
		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccion);

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(tramiteInspeccionAux.getTramiteInspeccion().getTiiddestinatario());

		intervinientes = this.intervinientesDao.find(intervinientes);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteInspeccion.getTiatcodigo());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		// El expediente se encuentra dado de alta en PLATEA (ATENPLATEA=S)
		if (insDetalle != null && insDetalle.getAtenplatea() != null
				&& insDetalle.getAtenplatea().equals(Y41bConstantes.VALOR_SI)) {
			// El campo ATPARTICIPACIONRESPONSABLE de la tabla L2107T00 tiene
			// valor
			// nulo
			if (insDetalle != null && insDetalle.getAtparticipacionresponsable() == null) {
				try {

					// La notificacin asociada tiene como destinatario el
					// establecimiento responsable
					if (intervinientes != null && intervinientes.getTipoInterviniente() != null && (intervinientes
							.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)
							|| intervinientes.getTipoInterviniente()
									.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)
							|| intervinientes.getTipoInterviniente().equals(
									Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO))) {

						// Documentos notificacion
						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdTramite(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());

						List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao
								.findAllDocumentosTramite(tramiteComunAux, null);

						// La notificacin tiene adjuntada un documento de tipo
						// ejgv_d_acuerdo_inicunproc Acuerdo inicio
						// procedimiento
						boolean notificacionAIP = false;
						if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
							for (DocumentoHecho documentoHecho : listDocumentoHecho) {
								if (documentoHecho != null && documentoHecho.getQ5idTipodoc() != null
										&& documentoHecho.getQ5idTipodoc().equals(Y41bConstantes.TIPO_DOC_AIP)) {
									notificacionAIP = true;
								}
							}
						}

						if (notificacionAIP) {
							// El establecimiento responsable tiene un CIF
							// distinto al establecimiento visitado.
							if (insDetalle.getEstablecimientoR() != null
									&& insDetalle.getEstablecimientoR().getNif() != null
									&& insDetalle.getEstablecimientoV() != null
									&& insDetalle.getEstablecimientoV().getNif() != null
									&& !insDetalle.getEstablecimientoV().getNif()
											.equals(insDetalle.getEstablecimientoR().getNif())) {
								// Se actualiza campo ATENPLATEARESPONSABLE a S
								// (indica que el expediente
								// est
								// abierto en PLATEA para el establecimiento
								// responsable)
								this.actuacionDao.updateATPARTICIPACIONRESPONSABLE(actuacion);

								this.abrirParticipacionEstablecimientoResponsable(insDetalle);
							}
						}
					}
				} catch (Y41bUDAException e) {
					throw e;
				} catch (Exception e) {
					throw new Y41bUDAException("error.generico", true, e);
				}
			}
		}

		insDetalle = this.actaDao.findInspeccion(actuacion);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)
						|| intervinientes.getTipoInterviniente().equals(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO))) {
			// Documentos notificacion
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
					null);

			tramiteInspeccionAux.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
			tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);
			if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTramiteInspeccion() != null
					&& tramiteInspeccionAux.getTramiteInspeccion().getTicodigo() != null) {

				tramiteInspeccionAux.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());

				tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);
				if (tramiteInspeccionAux.getTicotee() != null && tramiteInspeccionAux.getTicotee()
						.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION)) {
					this.actualizarMisGestionesRegistroDecisionEstablecimientoVisitado(tramiteInspeccionAux);
				}
			}

			this.actualizarMisGestionesNotificacionEstablecimientoVisitado(tramiteInspeccion, listDocumentoHecho);
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && (intervinientes
				.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)
				|| intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)
				|| intervinientes.getTipoInterviniente().equals(
						Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO))) {
			// Documentos notificacion
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
					null);

			tramiteInspeccionAux.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
			tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);
			if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTramiteInspeccion() != null
					&& tramiteInspeccionAux.getTramiteInspeccion().getTicodigo() != null) {

				tramiteInspeccionAux.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());

				tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);
				if (tramiteInspeccionAux.getTicotee() != null && tramiteInspeccionAux.getTicotee()
						.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION)) {
					this.actualizarMisGestionesRegistroDecisionEstablecimientoResponsable(tramiteInspeccionAux);
				}
			}

			this.actualizarMisGestionesNotificacionEstablecimientoResponsable(tramiteInspeccion, listDocumentoHecho);
		}

	}

	/**
	 * Metodo que abre la participacin del establecimiento responsable
	 * 
	 * @param insDetalle
	 *            InspeccionDetalle
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 */
	private void abrirParticipacionEstablecimientoResponsable(InspeccionDetalle insDetalle) throws Exception {
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdExpediente(insDetalle.getAtcodigo());

		this.actualizarParticipacionEstablecimientoResponsable(tramiteComunAux);

		List<Proceedings> listProceedingsEstablecimientoVisitado = new ArrayList<Proceedings>();

		// buscar los tramites del expediente
		TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
		tramiteInspeccionDetalle.setAtcodigo(insDetalle.getAtcodigo());
		List<TramiteInspeccionDetalle> listTramiteInspeccionDetalle = this.tramiteInspeccionDao
				.findAllTramiteInspeccion(tramiteInspeccionDetalle, null);
		if (listTramiteInspeccionDetalle != null && listTramiteInspeccionDetalle.size() > 0) {
			for (int i = 0; i < listTramiteInspeccionDetalle.size(); i++) {
				tramiteInspeccionDetalle = listTramiteInspeccionDetalle.get(i);

				if (tramiteInspeccionDetalle.getTifechafin() != null) {
					if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION)) {
						listProceedingsEstablecimientoVisitado = this
								.reabrirExpedienteAportacionDocumentacionParticipacionEstablecimientoVisitado(
										tramiteInspeccionDetalle, listProceedingsEstablecimientoVisitado);
					} else if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION)) {
						listProceedingsEstablecimientoVisitado = this
								.reabrirExpedienteComunicacionParticipacionEstablecimientoVisitado(
										tramiteInspeccionDetalle, listProceedingsEstablecimientoVisitado);
					} else if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO)) {
						listProceedingsEstablecimientoVisitado = this
								.reabrirExpedienteAcuseReciboParticipacionEstablecimientoVisitado(
										tramiteInspeccionDetalle, listProceedingsEstablecimientoVisitado);
					} else if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_LEVANTAMIENTO_ACTA)) {
						listProceedingsEstablecimientoVisitado = this
								.reabrirExpedienteLevantamientoActaParticipacionEstablecimientoVisitado(
										tramiteInspeccionDetalle, listProceedingsEstablecimientoVisitado);
					}
				}
			}
		}

		// Calcular la fecha mas baja de todo lo que se
		// escribe en mi carpeta
		Calendar presentacionSolicitudTimestamp = null;
		if (listProceedingsEstablecimientoVisitado != null && listProceedingsEstablecimientoVisitado.size() > 0) {
			for (Proceedings proceedingsAux : listProceedingsEstablecimientoVisitado) {
				if (presentacionSolicitudTimestamp == null) {
					presentacionSolicitudTimestamp = proceedingsAux.getTimestamp();
				} else if (proceedingsAux.getTimestamp() != null
						&& proceedingsAux.getTimestamp().before(presentacionSolicitudTimestamp)) {
					presentacionSolicitudTimestamp = proceedingsAux.getTimestamp();
				}
			}
		}

		if (presentacionSolicitudTimestamp == null) {
			if (listTramiteInspeccionDetalle != null && listTramiteInspeccionDetalle.size() > 0) {
				for (int i = 0; i < listTramiteInspeccionDetalle.size(); i++) {
					tramiteInspeccionDetalle = listTramiteInspeccionDetalle.get(i);

					if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_LEVANTAMIENTO_ACTA)) {
						TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
						tramiteInspeccionAux.setTicodigo(tramiteInspeccionDetalle.getTicodigo());
						tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);

						ActaNueva actaNuevaAux = new ActaNueva();
						actaNuevaAux.setAncodigo(tramiteInspeccionAux.getTiaccodigo());
						actaNuevaAux = this.actaNuevaDao.find(actaNuevaAux);

						Calendar aportacionTimestamp = Calendar.getInstance();

						String fechaActaSinHoras = Y41bUtils.parseDateToString(actaNuevaAux.getAnfecha(),
								Y41bConstantes.CASTELLANO);

						String fechaActaConHoras = "";

						fechaActaConHoras = new StringBuffer().append(fechaActaSinHoras).append(" 01:00:00").toString();
						aportacionTimestamp.setTime(
								Y41bUtils.parseDateTime(fechaActaConHoras, new Locale(Y41bConstantes.CASTELLANO)));

						if (presentacionSolicitudTimestamp == null) {
							presentacionSolicitudTimestamp = aportacionTimestamp;
						} else if (aportacionTimestamp != null
								&& aportacionTimestamp.before(presentacionSolicitudTimestamp)) {
							presentacionSolicitudTimestamp = aportacionTimestamp;
						}
					}
				}
			}
		}

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(insDetalle.getAtidparticipacionresponsable());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(insDetalle.getEstablecimientoR().getNif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(insDetalle.getEstablecimientoR().getNombre());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido1())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoR().getApellido1());
		}

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido2())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoR().getApellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido1())) {
			datosPersona.setApellido1(insDetalle.getEstablecimientoV().getApellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
				.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
				.append(insDetalle.getAtnror());

		actualizarMisGestiones.setEjercicio(insDetalle.getAcnran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		actualizarMisGestiones.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);

		actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_APERTURA_OFICIO_ES);
		actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_APERTURA_OFICIO_EU);

		Calendar solicitudOficioTimestamp = Calendar.getInstance();

		String solicitudOficioSinHoras = Y41bUtils.parseDateToString(presentacionSolicitudTimestamp.getTime(),
				Y41bConstantes.CASTELLANO);

		String fechaSolicitudOficioConHoras = "";

		fechaSolicitudOficioConHoras = new StringBuffer().append(solicitudOficioSinHoras).append(" 00:00:00")
				.toString();

		solicitudOficioTimestamp
				.setTime(Y41bUtils.parseDateTime(fechaSolicitudOficioConHoras, new Locale(Y41bConstantes.CASTELLANO)));

		actualizarMisGestiones.setAportacionTimestamp(solicitudOficioTimestamp);

		y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);

	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de registro de decision
	 * para el establecimiento visitado
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @throws SQLException
	 */
	public void actualizarMisGestionesRegistroDecisionEstablecimientoVisitado(TramiteInspeccion tramiteInspeccion)
			throws SQLException {
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteInspeccion.getTiatcodigo());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		if (insDetalle != null && insDetalle.getAtenplatea() == null) {
			try {
				Calendar aperturaTimestamp = Calendar.getInstance();

				String fechaSinHoras = Y41bUtils.parseDateToString(tramiteInspeccion.getTifechafin(),
						Y41bConstantes.CASTELLANO);

				String fechaConHoras = "";

				fechaConHoras = new StringBuffer().append(fechaSinHoras).append(" 00:00:00").toString();
				aperturaTimestamp
						.setTime(Y41bUtils.parseDateTime(fechaConHoras, new Locale(Y41bConstantes.CASTELLANO)));

				insDetalle.setAperturaTimestamp(aperturaTimestamp);

				this.abrirExpedienteOficioPlatea(insDetalle, null);

				// Se actualiza campo ATENPLATE a S (indica que el expediente
				// est
				// abierto en PLATEA)
				this.actuacionDao.updateEnPLATEA(actuacion);
			} catch (Y41bUDAException e) {
				throw e;
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
		}

		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(insDetalle.getAtidparticipacionvisitado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(insDetalle.getEstablecimientoV().getNif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(insDetalle.getEstablecimientoV().getNombre());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoV().getApellido1());
		}

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido2())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoV().getApellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			datosPersona.setApellido1(insDetalle.getEstablecimientoV().getApellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
				.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
				.append(insDetalle.getAtnror());

		actualizarMisGestiones.setEjercicio(insDetalle.getAcnran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		if (Y41bUtils.isFilled(tramiteInspeccion.getTiproceedingsidplatea())) {
			actualizarMisGestiones.setProceedingsID(tramiteInspeccion.getTiproceedingsidplatea());
		} else {
			actualizarMisGestiones.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
		}

		actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_DECISION_ES);
		actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_DECISION_EU);

		Decision decision = new Decision();
		decision.setDecodigo(tramiteInspeccion.getTidecodigo());

		decision = this.decisionDao.find(decision);

		actualizarMisGestiones.setDecisionCas(decision.getDenombre());
		actualizarMisGestiones.setDecisionEus(decision.getDenombree());

		Calendar decisionTimestamp = Calendar.getInstance();
		decisionTimestamp.setTime(tramiteInspeccion.getTifecharesolucion());
		actualizarMisGestiones.setDecisionTimestamp(decisionTimestamp);

		y41bPlateaAdapterService.actualizarMisGestionesDecision(actualizarMisGestiones);

		tramiteInspeccion.setTiproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.tramiteInspeccionDao.updateProceedingsIdPlatea(tramiteInspeccion);
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de registro de decision
	 * para el establecimiento responsable
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @throws SQLException
	 */
	public void actualizarMisGestionesRegistroDecisionEstablecimientoResponsable(TramiteInspeccion tramiteInspeccion)
			throws SQLException {
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteInspeccion.getTiatcodigo());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		// Si esta en PLATEA la participacin del responsable se escribe en Mi
		// Carpeta
		if (insDetalle != null && insDetalle.getAtparticipacionresponsable() != null
				&& insDetalle.getAtparticipacionresponsable().equals(Y41bConstantes.VALOR_SI)) {
			tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

			ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

			actualizarMisGestiones.setProcedure(procedure);

			actualizarMisGestiones.setIdParticipacion(insDetalle.getAtidparticipacionresponsable());

			DatosPersona datosPersona = new DatosPersona();
			datosPersona.setDni(insDetalle.getEstablecimientoR().getNif());

			StringBuffer nombreCompleto = new StringBuffer();

			nombreCompleto.append(insDetalle.getEstablecimientoR().getNombre());

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido1())) {
				nombreCompleto.append(" ").append(insDetalle.getEstablecimientoR().getApellido1());
			}

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido2())) {
				nombreCompleto.append(" ").append(insDetalle.getEstablecimientoR().getApellido2());
			}

			datosPersona.setNombre(nombreCompleto.toString());

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido1())) {
				datosPersona.setApellido1(insDetalle.getEstablecimientoR().getApellido1());
			}

			actualizarMisGestiones.setSolicitante(datosPersona);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
					.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
					.append(insDetalle.getAtnror());

			actualizarMisGestiones.setEjercicio(insDetalle.getAcnran().toString());

			actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

			if (Y41bUtils.isFilled(tramiteInspeccion.getTiproceedingsidplatea())) {
				actualizarMisGestiones.setProceedingsID(tramiteInspeccion.getTiproceedingsidplatea());
			} else {
				actualizarMisGestiones.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
			}

			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_DECISION_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_DECISION_EU);

			Decision decision = new Decision();
			decision.setDecodigo(tramiteInspeccion.getTidecodigo());

			decision = this.decisionDao.find(decision);

			actualizarMisGestiones.setDecisionCas(decision.getDenombre());
			actualizarMisGestiones.setDecisionEus(decision.getDenombree());

			Calendar decisionTimestamp = Calendar.getInstance();
			decisionTimestamp.setTime(tramiteInspeccion.getTifecharesolucion());
			actualizarMisGestiones.setDecisionTimestamp(decisionTimestamp);

			y41bPlateaAdapterService.actualizarMisGestionesDecision(actualizarMisGestiones);

			tramiteInspeccion.setTiproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.tramiteInspeccionDao.updateProceedingsIdPlatea(tramiteInspeccion);
		}
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de notificacin
	 * realizado al establecimiento visitado
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 */
	public void actualizarMisGestionesNotificacionEstablecimientoVisitado(TramiteInspeccion tramiteInspeccion,
			List<DocumentoHecho> listDocumentoHecho) throws SQLException {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteInspeccion.getTiatcodigo());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccion);

		if (insDetalle != null && insDetalle.getAtenplatea() == null) {
			try {
				Calendar aperturaTimestamp = Calendar.getInstance();

				String fechaSinHoras = Y41bUtils.parseDateToString(
						tramiteInspeccionAux.getTramiteInspeccion().getTifechafin(), Y41bConstantes.CASTELLANO);

				String fechaConHoras = "";

				fechaConHoras = new StringBuffer().append(fechaSinHoras).append(" 00:00:00").toString();
				aperturaTimestamp
						.setTime(Y41bUtils.parseDateTime(fechaConHoras, new Locale(Y41bConstantes.CASTELLANO)));

				insDetalle.setAperturaTimestamp(aperturaTimestamp);

				this.abrirExpedienteOficioPlatea(insDetalle, null);

				// Se actualiza campo ATENPLATE a S (indica que el expediente
				// est
				// abierto en PLATEA)
				this.actuacionDao.updateEnPLATEA(actuacion);
			} catch (Y41bUDAException e) {
				throw e;
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
		}

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(insDetalle.getAtidparticipacionvisitado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(insDetalle.getEstablecimientoV().getNif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(insDetalle.getEstablecimientoV().getNombre());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoV().getApellido1());
		}

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido2())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoV().getApellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			datosPersona.setApellido1(insDetalle.getEstablecimientoV().getApellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
				.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
				.append(insDetalle.getAtnror());

		actualizarMisGestiones.setEjercicio(insDetalle.getAcnran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());

		actualizarMisGestiones
				.setIdnotificacionplatea(tramiteInspeccionAux.getTramiteInspeccion().getTiidnotificacionplatea());

		if (Y41bUtils.isFilled(tramiteInspeccionAux.getTramiteInspeccion().getTiidnotificacionplatea())) {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
		} else {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
		}

		actualizarMisGestiones
				.setIdTiponotificacionplatea(tramiteInspeccionAux.getTramiteInspeccion().getTitiponotificacionplatea());
		Calendar notificacionPublicationTimestamp = Calendar.getInstance();
		notificacionPublicationTimestamp.setTime(tramiteInspeccionAux.getTramiteInspeccion().getTifechafin());
		actualizarMisGestiones.setNotificacionPublicationTimestamp(notificacionPublicationTimestamp);

		Calendar notificacionDeliveryTimestamp = Calendar.getInstance();
		notificacionDeliveryTimestamp.setTime(tramiteInspeccion.getTiacuserecibo());
		actualizarMisGestiones.setNotificacionDeliveryTimestamp(notificacionDeliveryTimestamp);

		actualizarMisGestiones.setSituacionNotificacionAcuseRecibo(tramiteInspeccion.getTiacusereciborecibido());

		List<Documento> listaDocumentosRdo = null;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				documento = new Documento();
				documento.setNombre(documentoHecho.getQ5nofile());
				documento.setDescripcion(documentoHecho.getQ5tedesfile());
				documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
				documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
				listaDocumentosRdo.add(documento);
			}
		}

		actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

		y41bPlateaAdapterService.actualizarMisGestionesNotificacion(actualizarMisGestiones);

		tramiteInspeccion.setTiproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.tramiteInspeccionDao.updateProceedingsIdPlatea(tramiteInspeccion);
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de notificacin
	 * realizado al establecimiento responsable
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 */
	public void actualizarMisGestionesNotificacionEstablecimientoResponsable(TramiteInspeccion tramiteInspeccion,
			List<DocumentoHecho> listDocumentoHecho) throws SQLException {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteInspeccion.getTiatcodigo());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		// Si esta en PLATEA la participacin del responsable se escribe en Mi
		// Carpeta
		if (insDetalle != null && insDetalle.getAtparticipacionresponsable() != null
				&& insDetalle.getAtparticipacionresponsable().equals(Y41bConstantes.VALOR_SI)) {
			TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccion);

			ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

			actualizarMisGestiones.setProcedure(procedure);

			actualizarMisGestiones.setIdParticipacion(insDetalle.getAtidparticipacionresponsable());

			DatosPersona datosPersona = new DatosPersona();
			datosPersona.setDni(insDetalle.getEstablecimientoR().getNif());

			StringBuffer nombreCompleto = new StringBuffer();

			nombreCompleto.append(insDetalle.getEstablecimientoR().getNombre());

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido1())) {
				nombreCompleto.append(" ").append(insDetalle.getEstablecimientoR().getApellido1());
			}

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido2())) {
				nombreCompleto.append(" ").append(insDetalle.getEstablecimientoR().getApellido2());
			}

			datosPersona.setNombre(nombreCompleto.toString());

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido1())) {
				datosPersona.setApellido1(insDetalle.getEstablecimientoR().getApellido1());
			}

			actualizarMisGestiones.setSolicitante(datosPersona);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
					.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
					.append(insDetalle.getAtnror());

			actualizarMisGestiones.setEjercicio(insDetalle.getAcnran().toString());

			actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

			actualizarMisGestiones.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());

			actualizarMisGestiones
					.setIdnotificacionplatea(tramiteInspeccionAux.getTramiteInspeccion().getTiidnotificacionplatea());

			if (Y41bUtils.isFilled(tramiteInspeccionAux.getTramiteInspeccion().getTiidnotificacionplatea())) {
				actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			} else {
				actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
			}

			actualizarMisGestiones.setIdTiponotificacionplatea(
					tramiteInspeccionAux.getTramiteInspeccion().getTitiponotificacionplatea());
			Calendar notificacionPublicationTimestamp = Calendar.getInstance();
			notificacionPublicationTimestamp.setTime(tramiteInspeccionAux.getTramiteInspeccion().getTifechafin());
			actualizarMisGestiones.setNotificacionPublicationTimestamp(notificacionPublicationTimestamp);

			Calendar notificacionDeliveryTimestamp = Calendar.getInstance();
			notificacionDeliveryTimestamp.setTime(tramiteInspeccion.getTiacuserecibo());
			actualizarMisGestiones.setNotificacionDeliveryTimestamp(notificacionDeliveryTimestamp);

			actualizarMisGestiones.setSituacionNotificacionAcuseRecibo(tramiteInspeccion.getTiacusereciborecibido());

			List<Documento> listaDocumentosRdo = null;
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
				listaDocumentosRdo = new ArrayList<Documento>();
				Documento documento = null;
				for (DocumentoHecho documentoHecho : listDocumentoHecho) {
					documento = new Documento();
					documento.setNombre(documentoHecho.getQ5nofile());
					documento.setDescripcion(documentoHecho.getQ5tedesfile());
					documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
					documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
					listaDocumentosRdo.add(documento);
				}
			}

			actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

			y41bPlateaAdapterService.actualizarMisGestionesNotificacion(actualizarMisGestiones);

			tramiteInspeccion.setTiproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.tramiteInspeccionDao.updateProceedingsIdPlatea(tramiteInspeccion);
		}
	}

	/**
	 * Metodo que procesa la tramitacion de la comunicacin e informa a mis
	 * gestiones
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 */
	private void tratamientoComunicacion(TramiteInspeccion tramiteInspeccion, TramiteComun tramiteComun)
			throws Exception {

		TramiteInspeccion tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccion);

		if (tramiteInspeccion.getTitipocomunicacion() != null && (tramiteInspeccion.getTitipocomunicacion()
				.equals(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO)
				|| tramiteInspeccion.getTitipocomunicacion().equals(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA))) {
			if (tramiteInspeccion.getTienvrem() == null || Y41bConstantes.NO.equals(tramiteInspeccion.getTienvrem())) {
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdinterviniente(tramiteInspeccion.getTiiddestinatario());

				intervinientes = this.intervinientesDao.find(intervinientes);

				if (intervinientes != null && intervinientes.getTipoInterviniente() != null && (intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)
						|| intervinientes.getTipoInterviniente().equals(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO))) {

					if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTramiteInspeccion() != null
							&& tramiteInspeccionAux.getTramiteInspeccion().getTicodigo() != null) {

						tramiteInspeccionAux.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
						tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);
						if (tramiteInspeccionAux.getTicotee() != null && tramiteInspeccionAux.getTicotee()
								.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION)) {
							this.actualizarMisGestionesRegistroDecisionEstablecimientoVisitado(tramiteInspeccionAux);
						}
					}

					List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao
							.findAllDocumentosTramite(tramiteComun, null);

					this.actualizarMisGestionesComunicacionEstablecimientoVisitado(tramiteInspeccion,
							listDocumentoHecho);
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && (intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)
						|| intervinientes.getTipoInterviniente().equals(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO))) {

					if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTramiteInspeccion() != null
							&& tramiteInspeccionAux.getTramiteInspeccion().getTicodigo() != null) {

						tramiteInspeccionAux.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
						tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);
						if (tramiteInspeccionAux.getTicotee() != null && tramiteInspeccionAux.getTicotee()
								.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION)) {
							this.actualizarMisGestionesRegistroDecisionEstablecimientoResponsable(tramiteInspeccionAux);
						}
					}

					List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao
							.findAllDocumentosTramite(tramiteComun, null);

					this.actualizarMisGestionesComunicacionEstablecimientoResponsable(tramiteInspeccion,
							listDocumentoHecho);
				}
			}
		}

	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado al establecimiento visitado
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 *             SQLException
	 */
	public void actualizarMisGestionesComunicacionEstablecimientoVisitado(TramiteInspeccion tramiteInspeccion,
			List<DocumentoHecho> listDocumentoHecho) throws SQLException {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteInspeccion.getTiatcodigo());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		if (insDetalle != null && insDetalle.getAtenplatea() == null) {
			try {
				this.abrirExpedienteOficioPlatea(insDetalle, null);

				// Se actualiza campo ATENPLATE a S (indica que el expediente
				// est
				// abierto en PLATEA)
				this.actuacionDao.updateEnPLATEA(actuacion);
			} catch (Y41bUDAException e) {
				throw e;
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
		}

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(insDetalle.getAtidparticipacionvisitado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(insDetalle.getEstablecimientoV().getNif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(insDetalle.getEstablecimientoV().getNombre());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoV().getApellido1());
		}

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido2())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoV().getApellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			datosPersona.setApellido1(insDetalle.getEstablecimientoV().getApellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
				.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
				.append(insDetalle.getAtnror());

		actualizarMisGestiones.setEjercicio(insDetalle.getAcnran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		if (Y41bUtils.isFilled(tramiteInspeccion.getTiidnotificacionplatea())) {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
		} else {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
		}

		actualizarMisGestiones.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());

		actualizarMisGestiones.setIdnotificacionplatea(tramiteInspeccion.getTiidnotificacionplatea());

		List<Documento> listaDocumentosRdo = null;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				documento = new Documento();
				documento.setNombre(documentoHecho.getQ5nofile());
				documento.setDescripcion(documentoHecho.getQ5tedesfile());
				documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
				documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
				listaDocumentosRdo.add(documento);
			}
		}

		actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

		y41bPlateaAdapterService.actualizarMisGestionesComunicacion(actualizarMisGestiones);

		tramiteInspeccion.setTiproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.tramiteInspeccionDao.updateProceedingsIdPlatea(tramiteInspeccion);
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado al establecimiento responsable
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 *             SQLException
	 */
	public void actualizarMisGestionesComunicacionEstablecimientoResponsable(TramiteInspeccion tramiteInspeccion,
			List<DocumentoHecho> listDocumentoHecho) throws SQLException {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteInspeccion.getTiatcodigo());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		// Si esta en PLATEA la participacin del responsable se escribe en Mi
		// Carpeta
		if (insDetalle != null && insDetalle.getAtparticipacionresponsable() != null
				&& insDetalle.getAtparticipacionresponsable().equals(Y41bConstantes.VALOR_SI)) {

			ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

			actualizarMisGestiones.setProcedure(procedure);

			actualizarMisGestiones.setIdParticipacion(insDetalle.getAtidparticipacionresponsable());

			DatosPersona datosPersona = new DatosPersona();
			datosPersona.setDni(insDetalle.getEstablecimientoR().getNif());

			StringBuffer nombreCompleto = new StringBuffer();

			nombreCompleto.append(insDetalle.getEstablecimientoR().getNombre());

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido1())) {
				nombreCompleto.append(" ").append(insDetalle.getEstablecimientoR().getApellido1());
			}

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido2())) {
				nombreCompleto.append(" ").append(insDetalle.getEstablecimientoR().getApellido2());
			}

			datosPersona.setNombre(nombreCompleto.toString());

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido1())) {
				datosPersona.setApellido1(insDetalle.getEstablecimientoR().getApellido1());
			}

			actualizarMisGestiones.setSolicitante(datosPersona);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
					.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
					.append(insDetalle.getAtnror());

			actualizarMisGestiones.setEjercicio(insDetalle.getAcnran().toString());

			actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

			if (Y41bUtils.isFilled(tramiteInspeccion.getTiidnotificacionplatea())) {
				actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			} else {
				actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
			}

			actualizarMisGestiones.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());

			actualizarMisGestiones.setIdnotificacionplatea(tramiteInspeccion.getTiidnotificacionplatea());

			List<Documento> listaDocumentosRdo = null;
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
				listaDocumentosRdo = new ArrayList<Documento>();
				Documento documento = null;
				for (DocumentoHecho documentoHecho : listDocumentoHecho) {
					documento = new Documento();
					documento.setNombre(documentoHecho.getQ5nofile());
					documento.setDescripcion(documentoHecho.getQ5tedesfile());
					documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
					documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
					listaDocumentosRdo.add(documento);
				}
			}

			actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

			y41bPlateaAdapterService.actualizarMisGestionesComunicacion(actualizarMisGestiones);

			tramiteInspeccion.setTiproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.tramiteInspeccionDao.updateProceedingsIdPlatea(tramiteInspeccion);
		}
	}

	/**
	 * Metodo que elimina en Mis Gestiones
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @throws SQLException
	 */
	public void eliminarMisGestiones(TramiteInspeccion tramiteinspeccion) throws SQLException {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteinspeccion.getTiatcodigo());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(insDetalle.getAtidparticipacionvisitado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(insDetalle.getEstablecimientoV().getNif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(insDetalle.getEstablecimientoV().getNombre());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoV().getApellido1());
		}

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido2())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoV().getApellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			datosPersona.setApellido1(insDetalle.getEstablecimientoV().getApellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
				.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
				.append(insDetalle.getAtnror());

		actualizarMisGestiones.setEjercicio(insDetalle.getAcnran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setProceedingsID(tramiteinspeccion.getTiproceedingsidplatea());

		y41bPlateaAdapterService.eliminarMisGestiones(actualizarMisGestiones);
	}

	/**********************
	 * ELIMINAR TRAMITE *
	 **********************/

	/**
	 * Elimina el tramite recibido por parametro
	 * 
	 * @param ticodigo
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void eliminarTramite(String ticodigo) {
		logger.info("eliminarTramite ini:" + ticodigo);
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTicodigo(ticodigo);

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		// No se permite eliminar el tramite de registro de inspeccin, est o
		// no
		// tramitado.
		if (Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_INSPECCION.equals(tramiteinspeccion.getTicotee())) {
			throw new Y41bUDAException("error.eliminarTramite.isTramiteRegInsException", true, new Exception());
		}

		if (Y41bConstantes.TRAMITE_INSPECCIONES_GENERICO.equals(tramiteinspeccion.getTicotee())
				&& Y41bConstantes.VALOR_SI.equals(tramiteinspeccion.getTiautomatico())) {
			throw new Y41bUDAException("error.eliminarTramite.isTramiteAutomaticoException", true, new Exception());
		}

		// Tramites que no se pueden eliminar, estn o no tramitados.
		if (Y41bConstantes.TRAMITE_INSPECCIONES_ASIGNACION_RESPONSABLE_EXPEDIENTE.equals(tramiteinspeccion.getTicotee())
				|| Y41bConstantes.TRAMITE_INSPECCIONES_RESOLUCION_ACUERDO_INICIO_PROCEDIMIENTO
						.equals(tramiteinspeccion.getTicotee())
				|| (Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_RED_DE_ALERTA
						.equals(tramiteinspeccion.getTicotee()) && tramiteinspeccion.getTramiteInspeccion() != null
						&& Y41bUtils.isFilled(tramiteinspeccion.getTramiteInspeccion().getTicodigo()))
				|| Y41bConstantes.TRAMITE_INSPECCIONES_RESULTADO_ENSAYOS.equals(tramiteinspeccion.getTicotee())
				|| Y41bConstantes.TRAMITE_INSPECCIONES_INFORME_VALORACION.equals(tramiteinspeccion.getTicotee())
				|| Y41bConstantes.TRAMITE_INSPECCIONES_ACEPTACION_INFORME_VALORACION
						.equals(tramiteinspeccion.getTicotee())
				|| Y41bConstantes.TRAMITE_INSPECCIONES_SOLICITUD_AMPLIACION_DE_INSPECCION
						.equals(tramiteinspeccion.getTicotee())
				|| Y41bConstantes.TRAMITE_INSPECCIONES_ARCHIVO_AIP.equals(tramiteinspeccion.getTicotee())) {
			throw new Y41bUDAException("error.eliminarTramite.isTramiteAutomaticoException", true, new Exception());
		}

		// Tramites que se pueden eliminar si para el acta asociada no hay
		// ningn trmite tramitado
		if (Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO.equals(tramiteinspeccion.getTicotee())
				|| Y41bConstantes.TRAMITE_INSPECCIONES_LEVANTAMIENTO_ACTA.equals(tramiteinspeccion.getTicotee())
				|| Y41bConstantes.TRAMITE_INSPECCIONES_REVISION_INCLUSION_EN_RED_DE_ALERTA
						.equals(tramiteinspeccion.getTicotee())
				|| Y41bConstantes.TRAMITE_INSPECCIONES_REMISION_MUESTRAS_AL_LABORATORIO
						.equals(tramiteinspeccion.getTicotee())
				|| Y41bConstantes.TRAMITE_INSPECCIONES_DESINMOVILIZACION.equals(tramiteinspeccion.getTicotee())) {
			TramiteInspeccionDetalle tramiteInspeccionDetalleAux = new TramiteInspeccionDetalle();
			tramiteInspeccionDetalleAux.setAtcodigo(tramiteinspeccion.getTiatcodigo());
			tramiteInspeccionDetalleAux.setTiaccodigo(tramiteinspeccion.getTiaccodigo());

			if (this.tramiteInspeccionDao.findAllTramiteAsociadoActaTramitadoCount(tramiteInspeccionDetalleAux) > 0) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteAutomaticoException", true, new Exception());
			}
		}

		// Tramites que se pueden eliminar si para el acta asociada no hay
		// ningn trmite tramitado
		// Si no est asociado a ninguna acta si se puede eliminar
		if (Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_REQUERIMIENTO.equals(tramiteinspeccion.getTicotee())
				|| Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION.equals(tramiteinspeccion.getTicotee())
				|| Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION
						.equals(tramiteinspeccion.getTicotee())
				|| Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_JUSTIFICANTE_DE_DEVOLUCION
						.equals(tramiteinspeccion.getTicotee())) {
			if (Y41bUtils.isFilled(tramiteinspeccion.getTiaccodigo())) {
				TramiteInspeccionDetalle tramiteInspeccionDetalleAux = new TramiteInspeccionDetalle();
				tramiteInspeccionDetalleAux.setAtcodigo(tramiteinspeccion.getTiatcodigo());
				tramiteInspeccionDetalleAux.setTiaccodigo(tramiteinspeccion.getTiaccodigo());

				if (this.tramiteInspeccionDao
						.findAllTramiteAsociadoActaTramitadoCount(tramiteInspeccionDetalleAux) > 0) {
					throw new Y41bUDAException("error.eliminarTramite.isTramiteAutomaticoException", true,
							new Exception());
				}
			}
		}

		// No se permite eliminar el tramite de aportacin de documentacin
		// telematico
		if (Y41bConstantes.TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION.equals(tramiteinspeccion.getTicotee())) {
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(ticodigo);
			List<DocumentoHecho> listDocumentoHechoAporta = this.documentoHechoDao
					.findAllDocumentosTramite(tramiteComunAux, null);
			if (listDocumentoHechoAporta != null && listDocumentoHechoAporta.size() > 0) {
				DocumentoHecho documentoHecho = null;
				boolean aportadoEstablecimientoVisitado = false;
				for (int j = 0; j < listDocumentoHechoAporta.size(); j++) {
					documentoHecho = listDocumentoHechoAporta.get(j);
					if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE))
							&& documentoHecho.getQ5iddocumentum() != null
							&& !documentoHecho.getQ5iddocumentum().equals("")
							&& documentoHecho.getQ5numregistroentrada() != null
							&& documentoHecho.getQ5numregistroentrada().contains("RTE")) {
						aportadoEstablecimientoVisitado = true;
						break;
					}
				}
				if (aportadoEstablecimientoVisitado) {
					throw new Y41bUDAException("error.eliminarTramite.isTramiteAportacionTelematicaException", true,
							new Exception());
				}
			}
		}

		if (tramiteinspeccion.getTifechafin() != null
				&& Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION.equals(tramiteinspeccion.getTicotee())) {
			// No se podr eliminar un tramite de comunicacion si esta tramitado
			// telematicamente.
			if (Y41bConstantes.TIPO_COMUNICACION_TELEMATICA.equals(tramiteinspeccion.getTitipocomunicacion())) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteComunicacionTelematicaException", true,
						new Exception());
				// No se podr eliminar una comunicacion tramitada por mail
			} else if (Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO
					.equals(tramiteinspeccion.getTitipocomunicacion())) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteComunicacionMailException", true,
						new Exception());
			} else if (Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO
					.equals(tramiteinspeccion.getTitipocomunicacion())
					&& Y41bConstantes.SI.equals(tramiteinspeccion.getTienvrem())
					&& tramiteinspeccion.getTicodrem() != null && !tramiteinspeccion.getTicodrem().equals("")) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteComunicacionOrdinariaRemesaException", true,
						new Exception());
			}
		}

		if (tramiteinspeccion.getTifechafin() != null
				&& Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION.equals(tramiteinspeccion.getTicotee())) {
			// No se podr eliminar un tramite de notificacin si esta tramitado
			// telematicamente.
			if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(tramiteinspeccion.getTitiponotificacion())) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteNotificacionTelematicaException", true,
						new Exception());
			} else if (Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA.equals(tramiteinspeccion.getTitiponotificacion())
					&& Y41bConstantes.SI.equals(tramiteinspeccion.getTienvrem())
					&& tramiteinspeccion.getTicodrem() != null && !tramiteinspeccion.getTicodrem().equals("")) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteNotificacionOrdinariaRemesaException", true,
						new Exception());
			}
		}

		if (Y41bConstantes.TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO.equals(tramiteinspeccion.getTicotee())) {
			// No se permite eliminar el tramite de acuse de recibo si est
			// tramitado.
			if (tramiteinspeccion.getTifechafin() != null) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteAcuseReciboTramitadoException", true,
						new Exception());
			}

			// No se podr eliminar un tramite de acuse de recibo realacionado
			// con
			// una notificacin telematica
			if (tramiteinspeccion.getTramiteInspeccion() != null
					&& Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION
							.equals(tramiteinspeccion.getTramiteInspeccion().getTicotee())
					&& Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA
							.equals(tramiteinspeccion.getTramiteInspeccion().getTitiponotificacion())) {
				throw new Y41bUDAException("error.eliminarTramite.isTramiteAcuseReciboNotificacionTelematicaException",
						true, new Exception());
			}

			// No se podr eliminar un tramite de acuse de recibo realacionado
			// con
			// una notificacin ordinaria con remesa generada (por lo que si se
			// elimina la remesa, se podr eliminar el acuse)
			if (tramiteinspeccion.getTramiteInspeccion() != null
					&& Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION
							.equals(tramiteinspeccion.getTramiteInspeccion().getTicotee())
					&& Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA
							.equals(tramiteinspeccion.getTramiteInspeccion().getTitiponotificacion())
					&& Y41bConstantes.SI.equals(tramiteinspeccion.getTramiteInspeccion().getTienvrem())
					&& tramiteinspeccion.getTramiteInspeccion().getTicodrem() != null
					&& !tramiteinspeccion.getTramiteInspeccion().getTicodrem().equals("")) {
				throw new Y41bUDAException(
						"error.eliminarTramite.isTramiteAcuseReciboNotificacionOrdinariaRemesaException", true,
						new Exception());
			}
		}

		// No se permite eliminar el tramite de cierre de expediente si est
		// tramitado
		if (tramiteinspeccion.getTifechafin() != null
				&& Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE.equals(tramiteinspeccion.getTicotee())) {
			throw new Y41bUDAException("error.eliminarTramite.isTramiteCierreException", true, new Exception());
		}

		// Al elminar el acuse de recibo (en los casos que se pueda) el tramite
		// notificacion asociado pasara a estar como pendiente.
		if (Y41bConstantes.TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO.equals(tramiteinspeccion.getTicotee())) {

			if (tramiteinspeccion.getTramiteInspeccion() != null && Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION
					.equals(tramiteinspeccion.getTramiteInspeccion().getTicotee())) {
				TramiteInspeccion tramiteinspeccionAux = new TramiteInspeccion();
				tramiteinspeccionAux.setTicodigo(tramiteinspeccion.getTramiteInspeccion().getTicodigo());
				tramiteinspeccionAux.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				this.tramiteInspeccionDao.updateReabrirTramite(tramiteinspeccionAux);
			}
		} else if (Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION.equals(tramiteinspeccion.getTicotee())
				&& tramiteinspeccion.getTramiteInspeccion() != null
				&& Y41bUtils.isFilled(tramiteinspeccion.getTramiteInspeccion().getTicodigo())
				&& Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION
						.equals(tramiteinspeccion.getTramiteInspeccion().getTicotee())) {
			// Se permite eliminar la comunicaciones generadas en el registro de
			// decisin, en inspecciones con origen Comunicacin externas y
			// Notificacin a Productores
		} else {
			if (!Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION
					.equals(tramiteinspeccion.getTicotee())) {
				// No se permite eliminar cualquier tramite que tenga padre (el
				// acuse de recibo si se permite eliminar)
				if (tramiteinspeccion.getTramiteInspeccion() != null
						&& Y41bUtils.isFilled(tramiteinspeccion.getTramiteInspeccion().getTicodigo())) {
					throw new Y41bUDAException("error.eliminarTramite.isTramiteAutomaticoException", true,
							new Exception());
				}
			}
		}

		if (tramiteinspeccion.getTifechafin() != null
				&& Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_CERTIFICADO_DE_DESTRUCCION
						.equals(tramiteinspeccion.getTicotee())) {
			// Actualizar contadores
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteinspeccion.getTiatcodigo());
			actuacion = actuacionDao.find(actuacion);

			// Se suman las unidades destruidas
			if (actuacion.getAtudestruidas() != null) {
				actuacion.setAtudestruidas(actuacion.getAtudestruidas().subtract(new BigDecimal(
						tramiteinspeccion.getTinumadestruir() != null ? tramiteinspeccion.getTinumadestruir() : "0")));
			}

			// Se actualizan las unidades recuperadas
			if (actuacion.getAturecuperadas() != null) {
				actuacion.setAturecuperadas(actuacion.getAturecuperadas().subtract(new BigDecimal(
						tramiteinspeccion.getTinumrecupe() != null ? tramiteinspeccion.getTinumrecupe() : "0")));

			}

			// Se actualizan las unidades pendientes
			if (actuacion.getAtupendientes() != null) {
				actuacion.setAtupendientes(actuacion.getAtupendientes().subtract(new BigDecimal(
						tramiteinspeccion.getTinumrecupe() != null ? tramiteinspeccion.getTinumrecupe() : "0")));

			}

			// Se actualizan las unidades pendientes, restando las unidades
			// destruidas
			actuacion.setAtupendientes(actuacion.getAtupendientes().add(new BigDecimal(
					tramiteinspeccion.getTinumadestruir() != null ? tramiteinspeccion.getTinumadestruir() : "0")));

			actuacionDao.update(actuacion);
		}

		if (tramiteinspeccion.getTifechafin() != null
				&& Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_JUSTIFICANTE_DE_DEVOLUCION
						.equals(tramiteinspeccion.getTicotee())) {
			// Actualizar contadores
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteinspeccion.getTiatcodigo());
			actuacion = actuacionDao.find(actuacion);

			// Se actualizan las unidades devueltas
			if (actuacion.getAtudevolucionorigen() != null) {
				actuacion.setAtudevolucionorigen(actuacion.getAtudevolucionorigen().subtract(new BigDecimal(
						tramiteinspeccion.getTinumadevolver() != null ? tramiteinspeccion.getTinumadevolver() : "0")));
			}

			// Se actualizan las unidades recuperadas
			if (actuacion.getAturecuperadas() != null) {
				actuacion.setAturecuperadas(actuacion.getAturecuperadas().subtract(new BigDecimal(
						tramiteinspeccion.getTinumrecupe() != null ? tramiteinspeccion.getTinumrecupe() : "0")));

			}

			// Se actualizan las unidades pendientes
			if (actuacion.getAtupendientes() != null) {
				actuacion.setAtupendientes(actuacion.getAtupendientes().subtract(new BigDecimal(
						tramiteinspeccion.getTinumrecupe() != null ? tramiteinspeccion.getTinumrecupe() : "0")));

			}

			// Se actualizan las unidades pendientes, restando las unidades
			// pendientes
			actuacion.setAtupendientes(actuacion.getAtupendientes().add(new BigDecimal(
					tramiteinspeccion.getTinumadevolver() != null ? tramiteinspeccion.getTinumadevolver() : "0")));

			actuacionDao.update(actuacion);
		}

		try {
			// 3. Eliminamos el tramiteHecho
			// 3.1 Recuperamos los documentos del tramite
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(ticodigo);
			List<DocumentoExpediente> documentosHecho = this.documentoHechoDao
					.findAllDocumentosGeneradosTramite(tramiteComun, null);
			// 3.2 Eliminamos los documentos del tramite de la tabla intermedia
			DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
			documentoTramiteHecho.setEhcodigo(ticodigo);
			this.documentoHechoDao.removeDocsTramiteHecho(documentoTramiteHecho);

			// 3.3.2 Recorremos tabla de documentos y los eliminamos
			DocumentoHecho documentoHechoAux = null;
			if (documentosHecho != null && documentosHecho.size() > 0) {
				for (DocumentoExpediente documentoExpediente : documentosHecho) {
					try {
						documentoHechoAux = new DocumentoHecho();
						documentoHechoAux.setQ5codocumento(documentoExpediente.getCodocumento());
						this.documentoHechoDao.remove(documentoHechoAux);
					} catch (DataIntegrityViolationException e) {
						// Si tiene tramnite relacionado dara esta excepcion
						throw new Y41bUDAException("error.eliminarTramite.documentos.DataIntegrityViolationException",
								true, e);
					}
				}
			}
			// 3.3.3 Eliminamos el tramiteHecho
			this.tramiteInspeccionDao.remove(tramiteinspeccion);

			if (Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION.equals(tramiteinspeccion.getTicotee())) {

				// buscar el interviniente
				String tipo_interviniente_destinatario = "";
				if (Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTOVISITADO
						.equals(tramiteinspeccion.getTidestinatario())) {
					tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO;
				} else if (Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTORESPONSABLE
						.equals(tramiteinspeccion.getTidestinatario())) {
					tipo_interviniente_destinatario = Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE;
				}

				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(tramiteinspeccion.getTiatcodigo());
				intervinientes.setTipoInterviniente(tipo_interviniente_destinatario);

				List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

				if (listIntervinientes != null && listIntervinientes.size() > 0) {
					Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
					sanpropbandeja.setBaprsanexcodigo(tramiteinspeccion.getTiatcodigo());
					sanpropbandeja.setBaprsansancionado(listIntervinientes.get(0).getEscodigo());

					this.sanpropbandejaService.removeInspecciones(sanpropbandeja);
				}

				Actuacion actuacion = new Actuacion();
				actuacion.setAtcodigo(tramiteinspeccion.getTiatcodigo());
				actuacion.setAtfefin(null);
				this.actuacionDao.updateFechaFin(actuacion);

				tramiteComun = new TramiteComun();
				tramiteComun.setIdExpediente(tramiteinspeccion.getTiatcodigo());
				TramiteRegistroDecision tramiteRegistroDecision = new TramiteRegistroDecision();
				this.tratamientoModificacionDecision(tramiteRegistroDecision, tramiteComun);
			}

			if (Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_CAMPANA
					.equals(tramiteinspeccion.getTicotee())) {
				Actuacion actuacion = new Actuacion();
				actuacion.setAtcocmrelacionada(null);
				actuacion.setAtcopgrelacionada(null);
				actuacion.setAtcodigo(tramiteinspeccion.getTiatcodigo());

				this.actuacionDao.updateRelacionConCampana(actuacion);
			}

			if (Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_RED_DE_ALERTA
					.equals(tramiteinspeccion.getTicotee())) {
				Actuacion actuacion = new Actuacion();
				actuacion.setAtcoalrelacionada(null);
				actuacion.setAtcocrrelacionada(null);
				actuacion.setAtcodigo(tramiteinspeccion.getTiatcodigo());

				this.actuacionDao.updateRelacionConAlerta(actuacion);
			}

			// 3.5 Actualizamos Bandeja Firma - Elinamos de la bandeja todos
			// los documentos del tramite
			BandejaFirma bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdtramitehecho(ticodigo);
			bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

			this.tramiteInspeccionService.actualizarUltimoTramite(tramiteinspeccion);

			// Eliminamos los documentos de dokusi
			if (documentosHecho != null && documentosHecho.size() > 0) {
				for (DocumentoExpediente documentoExpediente : documentosHecho) {
					if (documentoExpediente != null && documentoExpediente.getIddocumentum() != null
							&& !documentoExpediente.getIddocumentum().equals("")) {

						documentoHechoAux = new DocumentoHecho();
						documentoHechoAux.setQ5codocumento(documentoExpediente.getCodocumento());
						Long numTramitesUtilizado = this.documentoHechoDao
								.findAllDocTramiteHechoCount(documentoHechoAux);

						if (numTramitesUtilizado == 0) {
							Documento documento = new Documento();
							// 1.User
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
							documento.setProcedure(procedure);
							documento.setOidDokusi(documentoExpediente.getIddocumentum());
							documento.setBoolAllVersions("true");

							y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
						}
					}
				}
			}
		} catch (DataIntegrityViolationException e) {
			// Si tiene tramnite relacionado dara esta excepcion
			throw new Y41bUDAException("error.eliminarTramite.DataIntegrityViolationException", true, e);
		}

		if (tramiteinspeccion != null && tramiteinspeccion.getTiproceedingsidplatea() != null) {
			try {
				this.eliminarMisGestiones(tramiteinspeccion);
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
		logger.info("eliminarTramite fin:" + ticodigo);
	}

	/**
	 * Actualiza la fecha de fin de la inspeccion y realiza las modificaciones
	 * necesarias en la Comunicacion Soivre de origen si procede.
	 * 
	 * @param idExpediente
	 *            String
	 * @param fechaFin
	 *            Date
	 */
	private void actualizarFechaFinInspeccion(String idExpediente, Date fechaFin) {
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(idExpediente);
		actuacion = this.actuacionDao.find(actuacion);
		actuacion.setAtfefin(fechaFin);
		this.actuacionDao.updateFechaFin(actuacion);

		if (actuacion.getAtidcomunicacionsoivre() != null) {
			// update fecha fin comunicacion soivre
			ComunicacionSoivre comunicacionsoivre = new ComunicacionSoivre();
			comunicacionsoivre.setV6fechafininspeccion(fechaFin);
			comunicacionsoivre.setV6coactua(idExpediente);
			this.comunicacionSoivreDao.updateFechaFinInspeccion(comunicacionsoivre);

			HistorialAlerta historialAlerta = new HistorialAlerta();
			historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			historialAlerta.setCodigo(actuacion.getAtidcomunicacionsoivre());

			String organismoOrigen = "";
			if (actuacion != null && actuacion.getActdec() != null && actuacion.getActdec().getAdcoor() != null) {
				organismoOrigen = actuacion.getActdec().getAdcoor();
			}

			historialAlerta.setOrganismoorigen(organismoOrigen);
			historialAlerta.setOrganismodestino(Y41bConstantes.ORGANISMO_SSCC);
			historialAlerta.setDescripcion(Y41bConstantes.FECHA_FIN_INSPECCION_COMUNICACION_SOIVRE);
			historialAlerta.setGenerado(Y41bConstantes.SI);
			historialAlerta.setFecha(fechaFin);

			this.historialAlertaDao.add(historialAlerta);

			// Enviar mail
			this.enviarEmailFinalizarInspeccion(actuacion);
		}
	}

	/**
	 * Envia un mail al finalizar la inspeccion
	 * 
	 * @param actuacion
	 *            Actuacion
	 */
	private void enviarEmailFinalizarInspeccion(Actuacion actuacion) {
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

		// Remitente
		String from = "";
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.PARAMETRO_CONTROLMERCADO_FROMGENERICO);
		parametros = this.parametrosDao.find(parametros);

		if (parametros != null && (parametros.getValor() == null || parametros.getValor().equals(""))) {
			throw new Y41bUDAException("error.parametro.CONTROLMERCADO_FROMGENERICO_EMAIL", true, new Exception());
		} else {
			from = parametros.getValor();
		}

		// Destinatario
		StringBuffer destinatarios = new StringBuffer("");
		parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.PARAMETRO_CONTROLMERCADO_TOGENERICO);
		parametros = this.parametrosDao.find(parametros);

		if (parametros != null && (parametros.getValor() == null || parametros.getValor().equals(""))) {
			throw new Y41bUDAException("error.parametro.CONTROLMERCADO_TOGENERICO_EMAIL", true, new Exception());
		} else {
			destinatarios.append(parametros.getValor());
		}

		ComunicacionSoivre comunicacionsoivre = new ComunicacionSoivre();
		comunicacionsoivre.setIdcomunicacionsoivre(actuacion.getAtidcomunicacionsoivre());
		comunicacionsoivre = this.comunicacionSoivreDao.find(comunicacionsoivre);

		// 2. Asunto del mail
		StringBuffer asunto = new StringBuffer();
		String[] params1 = new String[Y41bConstantes.NUM_2];
		params1[0] = comunicacionsoivre.getV6codigo();
		// Castellano
		params1[1] = comunicacionsoivre.getV6psnombre();
		asunto.append(this.appMessageSource.getMessage("inspeccion.finalizarinspeccion.mail.asunto", params1,
				new Locale(Y41bConstantes.CASTELLANO)));
		asunto.append(" ").append(comunicacionsoivre.getV6codigo()).append(" / ");
		// Euskera
		params1[1] = (comunicacionsoivre.getV6psnombree() == null) ? comunicacionsoivre.getV6psnombre()
				: comunicacionsoivre.getV6psnombree();
		asunto.append(this.appMessageSource.getMessage("inspeccion.finalizarinspeccion.mail.asunto", params1,
				new Locale(Y41bConstantes.EUSKERA)));

		// 3. Creo el contenido del mail
		StringBuffer texto = new StringBuffer();
		String[] params2 = new String[Y41bConstantes.NUM_4];
		params2[0] = comunicacionsoivre.getV6codigo();
		params2[2] = comunicacionsoivre.getV6importadoresnoco();
		params2[3] = actuacion.getActdec().getAdcoor();

		params2[1] = comunicacionsoivre.getV6psnombre();
		texto.append("<B>").append(this.appMessageSource.getMessage("inspeccion.finalizarinspeccion.mail.texto",
				params2, new Locale(Y41bConstantes.CASTELLANO)));

		params2[1] = (comunicacionsoivre.getV6psnombree() == null) ? comunicacionsoivre.getV6psnombre()
				: comunicacionsoivre.getV6psnombree();
		texto.append(" / ").append(this.appMessageSource.getMessage("inspeccion.finalizarinspeccion.mail.texto",
				params2, new Locale(Y41bConstantes.EUSKERA))).append("</B><BR>");

		// ENLACE
		texto.append("<a href=\"");

		String urlDetalleAlerta = (String) prop.getProperty("URL_DETALLE_COMUNICACIONSOIVRE");

		urlDetalleAlerta = urlDetalleAlerta.replace("XXX", actuacion.getAtidcomunicacionsoivre());

		texto.append(new StringBuffer(urlDetalleAlerta).append("?locale=es").toString());

		texto.append("\">");

		texto.append(this.appMessageSource.getMessage("comun.enlace", null, new Locale(Y41bConstantes.CASTELLANO)));

		texto.append("</a>");

		texto.append(" / ");

		texto.append("<a href=\"");

		texto.append(new StringBuffer(urlDetalleAlerta).append("?locale=eu").toString());

		texto.append("\">");

		texto.append(this.appMessageSource.getMessage("comun.enlace", null, new Locale(Y41bConstantes.EUSKERA)));

		texto.append("</a>");

		texto.append("<BR>");

		boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
				destinatarios.toString(), "", null);
		if (!enviadoOK) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}
	}

	/**
	 * Envia un mail al ejecutar un tramite
	 * 
	 * @param atcodigo
	 *            String
	 * @param trcodigo
	 *            String
	 */
	private void enviarEmailTramiteEjecutadoSSCC(String atcodigo, String trcodigo) {
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

		// Remitente
		String from = "";
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.PARAMETRO_CONTROLMERCADO_FROMGENERICO);
		parametros = this.parametrosDao.find(parametros);

		if (parametros != null && (parametros.getValor() == null || parametros.getValor().equals(""))) {
			throw new Y41bUDAException("error.parametro.CONTROLMERCADO_FROMGENERICO_EMAIL", true, new Exception());
		} else {
			from = parametros.getValor();
		}

		Actuacion actuacionAux = new Actuacion();
		actuacionAux.setAtcodigo(atcodigo);
		actuacionAux = this.actuacionDao.find(actuacionAux);

		String numExpediente = "";
		String emailResponsableExpediente = "";
		if (actuacionAux != null && actuacionAux.getActa() != null) {
			numExpediente = new StringBuffer().append(actuacionAux.getActa().getAccoor()).append("-")
					.append(actuacionAux.getActa().getAcnror()).append("-").append(actuacionAux.getActa().getAcnran())
					.append("-").append(actuacionAux.getAtnror()).toString();

			CensoMonitor responsableExpediente = new CensoMonitor();
			responsableExpediente.setMocodigo(actuacionAux.getActa().getAccomo());

			if (actuacionAux.getActa().getAccomo() != null && !actuacionAux.getActa().getAccomo().equals("")) {
				responsableExpediente = this.censoMonitorDao.find(responsableExpediente);

				if (responsableExpediente != null) {
					emailResponsableExpediente = responsableExpediente.getMocoem();
				}
			}
		}

		Tramite tramite = new Tramite();
		tramite.setTrcodigo(trcodigo);
		tramite = this.tramiteDao.find(tramite);

		String nombreTramite = "";
		if (tramite != null) {
			nombreTramite = tramite.getTrnombre();
		}

		// Destinatario
		StringBuffer destinatarios = new StringBuffer("");
		destinatarios.append(emailResponsableExpediente);

		// 2. Asunto del mail
		StringBuffer asunto = new StringBuffer();
		String[] params1 = new String[Y41bConstantes.NUM_1];
		params1[0] = numExpediente;

		asunto.append(this.appMessageSource.getMessage("inspeccion.tramiteejecutadosscc.mail.asunto", params1,
				new Locale(Y41bConstantes.CASTELLANO)));

		// 3. Creo el contenido del mail
		StringBuffer texto = new StringBuffer();
		String[] params2 = new String[Y41bConstantes.NUM_2];
		params2[0] = nombreTramite;
		params2[1] = numExpediente;

		texto.append(this.appMessageSource.getMessage("inspeccion.tramiteejecutadosscc.mail.texto", params2,
				new Locale(Y41bConstantes.CASTELLANO)));

		boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
				destinatarios.toString(), "", null);
		if (!enviadoOK) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}
	}

	/**
	 * Envia un mail al ejecutar un tramite el coordinador
	 * 
	 * @param atcodigo
	 *            String
	 * @param trcodigo
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	private void enviarEmailTramiteEjecutadoCoordinador(String atcodigo, String trcodigo, CensoMonitor censoMonitor) {
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

		// Remitente
		String from = "";
		from = censoMonitor.getMocoem();

		Actuacion actuacionAux = new Actuacion();
		actuacionAux.setAtcodigo(atcodigo);
		actuacionAux = this.actuacionDao.find(actuacionAux);

		String numExpediente = "";
		String emailResponsableExpediente = "";
		if (actuacionAux != null && actuacionAux.getActa() != null) {
			numExpediente = new StringBuffer().append(actuacionAux.getActa().getAccoor()).append("-")
					.append(actuacionAux.getActa().getAcnror()).append("-").append(actuacionAux.getActa().getAcnran())
					.append("-").append(actuacionAux.getAtnror()).toString();

			CensoMonitor responsableExpediente = new CensoMonitor();
			responsableExpediente.setMocodigo(actuacionAux.getActa().getAccomo());

			if (actuacionAux.getActa().getAccomo() != null && !actuacionAux.getActa().getAccomo().equals("")) {
				responsableExpediente = this.censoMonitorDao.find(responsableExpediente);

				if (responsableExpediente != null) {
					emailResponsableExpediente = responsableExpediente.getMocoem();
				}
			}
		}

		// Destinatario
		StringBuffer destinatarios = new StringBuffer("");
		destinatarios.append(emailResponsableExpediente);

		// 2. Asunto del mail
		StringBuffer asunto = new StringBuffer();
		String[] params1 = new String[Y41bConstantes.NUM_1];
		params1[0] = numExpediente;

		asunto.append(this.appMessageSource.getMessage("inspeccion.tramiteejecutadosscc.mail.asunto", params1,
				new Locale(Y41bConstantes.CASTELLANO)));

		// 3. Creo el contenido del mail
		StringBuffer texto = new StringBuffer();
		String[] params2 = new String[Y41bConstantes.NUM_2];
		params2[0] = numExpediente;

		texto.append(this.appMessageSource.getMessage("inspeccion.tramiteejecutadocoordinador.mail.texto", params2,
				new Locale(Y41bConstantes.CASTELLANO)));

		boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
				destinatarios.toString(), "", null);
		if (!enviadoOK) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}
	}

	/**
	 * Reabrir expediente
	 * 
	 * @param atcodigo
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void reabrirExpediente(String atcodigo, CensoMonitor censoMonitor) throws Exception {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);
		InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

		// buscar el tramite de cierre
		TramiteInspeccionDetalle tramiteInspeccionAux = new TramiteInspeccionDetalle();
		tramiteInspeccionAux.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE);
		tramiteInspeccionAux.setAtcodigo(inspeccionDetalle.getAtcodigo());
		try {
			tramiteInspeccionAux = this.tramiteInspeccionDao.findUltimoTramiteHechoPorTipoTramite(tramiteInspeccionAux);
		} catch (Exception e) {
		}

		// eliminar tramite de cierre
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteInspeccionAux.getTicodigo());
		this.tramiteInspeccionDao.remove(tramiteInspeccion);

		// Eliminamos la fecha de cierre
		this.actuacionDao.updateFechaCierreReabrirExpediente(actuacion);

		// crear tramite generico
		this.generarTramiteGenericoReabrirExpediente(inspeccionDetalle, censoMonitor);

		if (inspeccionDetalle != null && inspeccionDetalle.getAtenplatea() != null
				&& inspeccionDetalle.getAtenplatea().equals(Y41bConstantes.VALOR_SI)) {
			this.reabrirExpedienteParticipacion(inspeccionDetalle);
		}
	}

	/**
	 * Reabrir expediente participacion reclamante
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 */
	private void reabrirExpedienteParticipacion(InspeccionDetalle inspeccionDetalle) throws Exception {
		// Reabrir expediente
		ActualizarExpediente actualizarExpediente = new ActualizarExpediente();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

		actualizarExpediente.setProcedure(procedure);

		actualizarExpediente.setIdParticipacion(inspeccionDetalle.getAtidparticipacionvisitado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(inspeccionDetalle.getEstablecimientoV().getNif());
		datosPersona.setNombre(inspeccionDetalle.getEstablecimientoV().getNombre());

		if (Y41bUtils.isFilled(inspeccionDetalle.getEstablecimientoV().getApellido1())) {
			datosPersona
					.setApellido1(new StringBuffer(inspeccionDetalle.getEstablecimientoV().getApellido1()).toString());

			if (Y41bUtils.isFilled(inspeccionDetalle.getEstablecimientoV().getApellido2())) {
				datosPersona.setApellido1(new StringBuffer(inspeccionDetalle.getEstablecimientoV().getApellido1())
						.append(" ").append(inspeccionDetalle.getEstablecimientoV().getApellido2()).toString());
			}
		}

		// datosPersona.setMail(inspeccionDetalle.getEstablecimientoV().getCoem());
		// datosPersona.setTelefono(inspeccionDetalle.getEstablecimientoV().getNrtel());
		// datosPersona.setIdioma(inspeccionDetalle.getAtidiomaestablecimientovi());

		// actualizarExpediente.setIdiomaNotificacion(inspeccionDetalle.getAtidiomaestablecimientovi());

		// buscar el representante del reclamante validado
		// si existe se aade
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO);
		intervinientes = this.intervinientesDao.findIntervinienteTipo(intervinientes);

		if (intervinientes != null && Y41bUtils.isFilled(intervinientes.getNif())) {

			DatosPersona datosPersonaRepresentante = new DatosPersona();
			datosPersonaRepresentante.setDni(intervinientes.getNif());
			datosPersonaRepresentante.setNombre(intervinientes.getNombre());

			if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
				datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).toString());

				if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
					datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).append(" ")
							.append(intervinientes.getApellido2()).toString());
				}
			}
			actualizarExpediente.setRepresentante(datosPersonaRepresentante);

			// Si tiene representante los datos sern del representante
			datosPersona.setMail(intervinientes.getCoem());
			datosPersona.setTelefono(intervinientes.getNrtel());
		}

		actualizarExpediente.setSolicitante(datosPersona);

		// Si esta en PLATEA la participacin del responsable se vuelve a
		// generar
		if (inspeccionDetalle != null && inspeccionDetalle.getAtparticipacionresponsable() != null
				&& inspeccionDetalle.getAtparticipacionresponsable().equals(Y41bConstantes.VALOR_SI)) {

			actualizarExpediente.setIdParticipacionInteresado(inspeccionDetalle.getAtidparticipacionresponsable());

			DatosPersona datosInteresado = new DatosPersona();
			datosInteresado.setDni(inspeccionDetalle.getEstablecimientoR().getNif());
			datosInteresado.setNombre(inspeccionDetalle.getEstablecimientoR().getNombre());

			if (Y41bUtils.isFilled(inspeccionDetalle.getEstablecimientoR().getApellido1())) {
				datosInteresado.setApellido1(
						new StringBuffer(inspeccionDetalle.getEstablecimientoR().getApellido1()).toString());

				if (Y41bUtils.isFilled(inspeccionDetalle.getEstablecimientoR().getApellido2())) {
					datosInteresado.setApellido1(
							new StringBuffer(inspeccionDetalle.getEstablecimientoR().getApellido1()).append(" ")
									.append(inspeccionDetalle.getEstablecimientoR().getApellido2()).toString());
				}
			}

			// buscar el representante del reclamante validado
			// si existe se aade
			intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
			intervinientes
					.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE);
			intervinientes = this.intervinientesDao.findIntervinienteTipo(intervinientes);

			if (intervinientes != null && Y41bUtils.isFilled(intervinientes.getNif())) {

				DatosPersona datosPersonaRepresentante = new DatosPersona();
				datosPersonaRepresentante.setDni(intervinientes.getNif());
				datosPersonaRepresentante.setNombre(intervinientes.getNombre());

				if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
					datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1()).toString());

					if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
						datosPersonaRepresentante.setApellido1(new StringBuffer(intervinientes.getApellido1())
								.append(" ").append(intervinientes.getApellido2()).toString());
					}
				}
				actualizarExpediente.setRepresentanteInteresado(datosPersonaRepresentante);

				// Si tiene representante los datos sern del representante
				datosInteresado.setMail(intervinientes.getCoem());
				datosInteresado.setTelefono(intervinientes.getNrtel());
			}

			// En actualizarExpediente el solicitante es el titular de la
			// participacin, en nuestro caso
			// el reclamado
			actualizarExpediente.setInteresado(datosInteresado);
		}

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(inspeccionDetalle.getAccoor())
				.append("-").append(inspeccionDetalle.getAcnror()).append("-").append(inspeccionDetalle.getAcnran())
				.append("-").append(inspeccionDetalle.getAtnror());

		actualizarExpediente.setEjercicio(inspeccionDetalle.getAcnran().toString());

		actualizarExpediente.setNumeroExpediente(numeroExpediente.toString());

		actualizarExpediente.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		// Tramites Expediente
		List<Proceedings> listProceedingsEstablecimientoVisitado = new ArrayList<Proceedings>();

		// buscar los tramites del expediente
		TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
		tramiteInspeccionDetalle.setAtcodigo(inspeccionDetalle.getAtcodigo());
		List<TramiteInspeccionDetalle> listTramiteInspeccionDetalle = this.tramiteInspeccionDao
				.findAllTramiteInspeccion(tramiteInspeccionDetalle, null);
		if (listTramiteInspeccionDetalle != null && listTramiteInspeccionDetalle.size() > 0) {
			for (int i = 0; i < listTramiteInspeccionDetalle.size(); i++) {
				tramiteInspeccionDetalle = listTramiteInspeccionDetalle.get(i);

				if (tramiteInspeccionDetalle.getTifechafin() != null) {
					if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION)) {
						listProceedingsEstablecimientoVisitado = this
								.reabrirExpedienteAportacionDocumentacionParticipacionEstablecimientoVisitado(
										tramiteInspeccionDetalle, listProceedingsEstablecimientoVisitado);
					} else if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION)) {
						listProceedingsEstablecimientoVisitado = this
								.reabrirExpedienteComunicacionParticipacionEstablecimientoVisitado(
										tramiteInspeccionDetalle, listProceedingsEstablecimientoVisitado);
					} else if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO)) {
						listProceedingsEstablecimientoVisitado = this
								.reabrirExpedienteAcuseReciboParticipacionEstablecimientoVisitado(
										tramiteInspeccionDetalle, listProceedingsEstablecimientoVisitado);
					} else if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_LEVANTAMIENTO_ACTA)) {
						listProceedingsEstablecimientoVisitado = this
								.reabrirExpedienteLevantamientoActaParticipacionEstablecimientoVisitado(
										tramiteInspeccionDetalle, listProceedingsEstablecimientoVisitado);
					}
				}
			}
		}

		// Calcular la fecha mas baja de todo lo que se escribe en mi carpeta
		Calendar presentacionSolicitudTimestamp = null;
		if (listProceedingsEstablecimientoVisitado != null && listProceedingsEstablecimientoVisitado.size() > 0) {
			for (Proceedings proceedingsAux : listProceedingsEstablecimientoVisitado) {
				if (presentacionSolicitudTimestamp == null) {
					presentacionSolicitudTimestamp = proceedingsAux.getTimestamp();
				} else if (proceedingsAux.getTimestamp() != null
						&& proceedingsAux.getTimestamp().before(presentacionSolicitudTimestamp)) {
					presentacionSolicitudTimestamp = proceedingsAux.getTimestamp();
				}
			}
		}

		if (presentacionSolicitudTimestamp == null) {
			if (listTramiteInspeccionDetalle != null && listTramiteInspeccionDetalle.size() > 0) {
				for (int i = 0; i < listTramiteInspeccionDetalle.size(); i++) {
					tramiteInspeccionDetalle = listTramiteInspeccionDetalle.get(i);

					if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_INSPECCIONES_LEVANTAMIENTO_ACTA)) {
						TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
						tramiteInspeccionAux.setTicodigo(tramiteInspeccionDetalle.getTicodigo());
						tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);

						ActaNueva actaNuevaAux = new ActaNueva();
						actaNuevaAux.setAncodigo(tramiteInspeccionAux.getTiaccodigo());
						actaNuevaAux = this.actaNuevaDao.find(actaNuevaAux);

						Calendar aportacionTimestamp = Calendar.getInstance();

						String fechaActaSinHoras = Y41bUtils.parseDateToString(actaNuevaAux.getAnfecha(),
								Y41bConstantes.CASTELLANO);

						String fechaActaConHoras = "";

						fechaActaConHoras = new StringBuffer().append(fechaActaSinHoras).append(" 01:00:00").toString();
						aportacionTimestamp.setTime(
								Y41bUtils.parseDateTime(fechaActaConHoras, new Locale(Y41bConstantes.CASTELLANO)));

						if (presentacionSolicitudTimestamp == null) {
							presentacionSolicitudTimestamp = aportacionTimestamp;
						} else if (aportacionTimestamp != null
								&& aportacionTimestamp.before(presentacionSolicitudTimestamp)) {
							presentacionSolicitudTimestamp = aportacionTimestamp;
						}
					}
				}
			}
		}

		Proceedings proceedings = new Proceedings();
		proceedings.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);
		proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APERTURA_OFICIO_ES);
		proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APERTURA_OFICIO_EU);

		Calendar solicitudOficioTimestamp = Calendar.getInstance();

		String solicitudOficioSinHoras = Y41bUtils.parseDateToString(presentacionSolicitudTimestamp.getTime(),
				Y41bConstantes.CASTELLANO);

		String fechaSolicitudOficioConHoras = "";

		fechaSolicitudOficioConHoras = new StringBuffer().append(solicitudOficioSinHoras).append(" 00:00:00")
				.toString();

		solicitudOficioTimestamp
				.setTime(Y41bUtils.parseDateTime(fechaSolicitudOficioConHoras, new Locale(Y41bConstantes.CASTELLANO)));

		actualizarExpediente.setStartTimestamp(solicitudOficioTimestamp);
		proceedings.setTimestamp(solicitudOficioTimestamp);

		listProceedingsEstablecimientoVisitado.add(proceedings);

		// Eliminar duplicados
		Map<String, Proceedings> mapProceedingsEstablecimientoVisitado = new HashMap<String, Proceedings>(
				listProceedingsEstablecimientoVisitado.size());

		for (Proceedings p : listProceedingsEstablecimientoVisitado) {
			mapProceedingsEstablecimientoVisitado.put(p.getProceedingsID(), p);
		}

		List listaProceedingsEstablecimientoVisitadoSinDuplicados = new ArrayList();
		// Agrego cada elemento del map a una nueva lista y muestro cada
		// elemento.
		for (Entry<String, Proceedings> p : mapProceedingsEstablecimientoVisitado.entrySet()) {
			listaProceedingsEstablecimientoVisitadoSinDuplicados.add(p.getValue());
		}

		actualizarExpediente.setProceedings(listaProceedingsEstablecimientoVisitadoSinDuplicados);

		// Si esta en PLATEA la participacin del responsable se vuelve a
		// generar
		if (inspeccionDetalle != null && inspeccionDetalle.getAtparticipacionresponsable() != null
				&& inspeccionDetalle.getAtparticipacionresponsable().equals(Y41bConstantes.VALOR_SI)) {
			List<Proceedings> listProceedingsEstablecimientoResponsable = new ArrayList<Proceedings>();

			listProceedingsEstablecimientoResponsable.add(proceedings);

			// buscar los tramites de aportacin de documentacin
			tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
			tramiteInspeccionDetalle.setAtcodigo(inspeccionDetalle.getAtcodigo());
			listTramiteInspeccionDetalle = this.tramiteInspeccionDao.findAllTramiteInspeccion(tramiteInspeccionDetalle,
					null);
			if (listTramiteInspeccionDetalle != null && listTramiteInspeccionDetalle.size() > 0) {
				for (int i = 0; i < listTramiteInspeccionDetalle.size(); i++) {
					tramiteInspeccionDetalle = listTramiteInspeccionDetalle.get(i);

					if (tramiteInspeccionDetalle.getTifechafin() != null) {
						if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle.getTrcodigo()
								.equals(Y41bConstantes.TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION)) {
							listProceedingsEstablecimientoResponsable = this
									.reabrirExpedienteAportacionDocumentacionParticipacionEstablecimientoResponsable(
											tramiteInspeccionDetalle, listProceedingsEstablecimientoResponsable);
						} else if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle
								.getTrcodigo().equals(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION)) {
							listProceedingsEstablecimientoResponsable = this
									.reabrirExpedienteComunicacionParticipacionEstablecimientoResponsable(
											tramiteInspeccionDetalle, listProceedingsEstablecimientoResponsable);
						} else if (tramiteInspeccionDetalle.getTrcodigo() != null && tramiteInspeccionDetalle
								.getTrcodigo().equals(Y41bConstantes.TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO)) {
							listProceedingsEstablecimientoResponsable = this
									.reabrirExpedienteAcuseReciboParticipacionEstablecimientoResponsable(
											tramiteInspeccionDetalle, listProceedingsEstablecimientoResponsable);
						}
					}
				}
			}

			// Eliminar duplicados
			Map<String, Proceedings> mapProceedingsEstablecimientoResponsable = new HashMap<String, Proceedings>(
					listProceedingsEstablecimientoResponsable.size());

			for (Proceedings p : listProceedingsEstablecimientoResponsable) {
				mapProceedingsEstablecimientoResponsable.put(p.getProceedingsID(), p);
			}

			List listaProceedingsEstablecimientoResponsableSinDuplicados = new ArrayList();
			// Agrego cada elemento del map a una nueva lista y muestro cada
			// elemento.
			for (Entry<String, Proceedings> p : mapProceedingsEstablecimientoResponsable.entrySet()) {
				listaProceedingsEstablecimientoResponsableSinDuplicados.add(p.getValue());
			}

			actualizarExpediente.setProceedingsInteresado(listaProceedingsEstablecimientoResponsableSinDuplicados);
		}

		y41bPlateaAdapterService.actualizarExpediente(actualizarExpediente);
	}

	/**
	 * Metodo que genera el proceedings para aportacion de documentacion
	 * participacin del establecimiento visitado
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 * @throws Exception
	 *             Exception
	 */
	private List<Proceedings> reabrirExpedienteAportacionDocumentacionParticipacionEstablecimientoVisitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, List<Proceedings> listProceedings) throws Exception {
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteInspeccionDetalle.getTicodigo());
		List<DocumentoHecho> listDocumentoHechoAporta = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
				null);
		if (listDocumentoHechoAporta != null && listDocumentoHechoAporta.size() > 0) {
			DocumentoHecho documentoHecho = null;
			boolean aportadoEstablecimientoVisitado = false;
			for (int j = 0; j < listDocumentoHechoAporta.size(); j++) {
				documentoHecho = listDocumentoHechoAporta.get(j);
				if (documentoHecho.getQ5origen() != null
						&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO)
								|| documentoHecho.getQ5origen()
										.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO))
						&& documentoHecho.getQ5iddocumentum() != null
						&& !documentoHecho.getQ5iddocumentum().equals("")) {
					aportadoEstablecimientoVisitado = true;
					break;
				}
			}
			if (aportadoEstablecimientoVisitado) {
				Proceedings proceedings = new Proceedings();

				if (tramiteInspeccionDetalle != null && tramiteInspeccionDetalle.getTiproceedingsidplatea() != null) {
					proceedings.setProceedingsID(tramiteInspeccionDetalle.getTiproceedingsidplatea());
				} else {
					proceedings.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
				}

				proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
				proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

				List<Documento> documentos = new ArrayList<Documento>();
				Date fechaAportacion = null;
				if (listDocumentoHechoAporta != null && listDocumentoHechoAporta.size() > 0) {
					documentoHecho = null;
					for (int k = 0; k < listDocumentoHechoAporta.size(); k++) {
						documentoHecho = listDocumentoHechoAporta.get(k);
						Documento documento = new Documento();
						if (documentoHecho.getQ5origen() != null
								&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO)
										|| documentoHecho.getQ5origen()
												.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO))
								&& documentoHecho.getQ5iddocumentum() != null
								&& !documentoHecho.getQ5iddocumentum().equals("")) {
							if (fechaAportacion == null) {
								fechaAportacion = documentoHecho.getQ5fechaentrada();
							} else if (documentoHecho.getQ5fechaentrada() != null
									&& documentoHecho.getQ5fechaentrada().after(fechaAportacion)) {
								fechaAportacion = documentoHecho.getQ5fechaentrada();
							}

							documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
							documento.setDescripcion(documentoHecho.getQ5tedesfile());
							documento.setNombre(documentoHecho.getQ5nofile());
							documentos.add(documento);
						}
					}
				}

				Calendar aportacionTimestamp = Calendar.getInstance();

				String fechaAportacionSinHoras = Y41bUtils.parseDateToString(fechaAportacion,
						Y41bConstantes.CASTELLANO);

				String fechaAportacionConHoras = "";

				DateFormat hourFormat = new SimpleDateFormat("HH:mm:ss");

				fechaAportacionConHoras = new StringBuffer().append(fechaAportacionSinHoras).append(" ")
						.append(hourFormat.format(tramiteInspeccionDetalle.getTifechainicio())).toString();
				aportacionTimestamp.setTime(
						Y41bUtils.parseDateTime(fechaAportacionConHoras, new Locale(Y41bConstantes.CASTELLANO)));

				proceedings.setTimestamp(aportacionTimestamp);

				proceedings.setDocumentos(documentos);

				listProceedings.add(proceedings);

			}
		}
		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para aportacion de documentacion
	 * participacin del establecimiento responsable
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 * @throws Exception
	 *             Exception
	 */
	private List<Proceedings> reabrirExpedienteAportacionDocumentacionParticipacionEstablecimientoResponsable(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, List<Proceedings> listProceedings) throws Exception {
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteInspeccionDetalle.getTicodigo());
		List<DocumentoHecho> listDocumentoHechoAporta = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
				null);
		if (listDocumentoHechoAporta != null && listDocumentoHechoAporta.size() > 0) {
			DocumentoHecho documentoHecho = null;
			boolean aportadoEstablecimientoResponsable = false;
			for (int j = 0; j < listDocumentoHechoAporta.size(); j++) {
				documentoHecho = listDocumentoHechoAporta.get(j);
				if (documentoHecho.getQ5origen() != null
						&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE)
								|| documentoHecho.getQ5origen()
										.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE))
						&& documentoHecho.getQ5iddocumentum() != null
						&& !documentoHecho.getQ5iddocumentum().equals("")) {
					aportadoEstablecimientoResponsable = true;
					break;
				}
			}
			if (aportadoEstablecimientoResponsable) {
				Proceedings proceedings = new Proceedings();

				if (tramiteInspeccionDetalle != null && tramiteInspeccionDetalle.getTiproceedingsidplatea() != null) {
					proceedings.setProceedingsID(tramiteInspeccionDetalle.getTiproceedingsidplatea());
				} else {
					proceedings.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
				}

				proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
				proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

				List<Documento> documentos = new ArrayList<Documento>();
				Date fechaAportacion = null;
				if (listDocumentoHechoAporta != null && listDocumentoHechoAporta.size() > 0) {
					documentoHecho = null;
					for (int k = 0; k < listDocumentoHechoAporta.size(); k++) {
						documentoHecho = listDocumentoHechoAporta.get(k);
						Documento documento = new Documento();
						if (documentoHecho.getQ5origen() != null
								&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE)
										|| documentoHecho.getQ5origen()
												.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE))
								&& documentoHecho.getQ5iddocumentum() != null
								&& !documentoHecho.getQ5iddocumentum().equals("")) {
							if (fechaAportacion == null) {
								fechaAportacion = documentoHecho.getQ5fechaentrada();
							} else if (documentoHecho.getQ5fechaentrada() != null
									&& documentoHecho.getQ5fechaentrada().after(fechaAportacion)) {
								fechaAportacion = documentoHecho.getQ5fechaentrada();
							}

							documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
							documento.setDescripcion(documentoHecho.getQ5tedesfile());
							documento.setNombre(documentoHecho.getQ5nofile());
							documentos.add(documento);
						}
					}
				}

				Calendar aportacionTimestamp = Calendar.getInstance();

				String fechaAportacionSinHoras = Y41bUtils.parseDateToString(fechaAportacion,
						Y41bConstantes.CASTELLANO);

				String fechaAportacionConHoras = "";

				DateFormat hourFormat = new SimpleDateFormat("HH:mm:ss");

				fechaAportacionConHoras = new StringBuffer().append(fechaAportacionSinHoras).append(" ")
						.append(hourFormat.format(tramiteInspeccionDetalle.getTifechainicio())).toString();
				aportacionTimestamp.setTime(
						Y41bUtils.parseDateTime(fechaAportacionConHoras, new Locale(Y41bConstantes.CASTELLANO)));

				proceedings.setTimestamp(aportacionTimestamp);

				proceedings.setDocumentos(documentos);

				listProceedings.add(proceedings);

			}
		}
		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para comunicacion participacin del
	 * establecimiento visitado
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteComunicacionParticipacionEstablecimientoVisitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, List<Proceedings> listProceedings) {
		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTicodigo(tramiteInspeccionDetalle.getTicodigo());
		tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);

		boolean remesaEmitida = true;
		if (tramiteInspeccionAux.getTienvrem() != null
				&& tramiteInspeccionAux.getTienvrem().equals(Y41bConstantes.VALOR_SI)) {

			if (tramiteInspeccionAux.getTicodrem() != null && !tramiteInspeccionAux.getTicodrem().equals("")) {
				// buscar remesa
				Remesa remesa = new Remesa();
				remesa.setRmcodigo(tramiteInspeccionAux.getTicodrem());
				remesa = this.remesaDao.find(remesa);

				if (!remesa.getRmestado().equals(Y41bConstantes.ESTADO_REMESA_EMITIDA)) {
					remesaEmitida = false;
				}
			} else {
				remesaEmitida = false;
			}
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(tramiteInspeccionAux.getTiiddestinatario());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO))
				&& (tramiteInspeccionAux.getTitipocomunicacion() != null && (tramiteInspeccionAux
						.getTitipocomunicacion().equals(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO)
						|| tramiteInspeccionAux.getTitipocomunicacion()
								.equals(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA)))
				&& remesaEmitida) {
			if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTramiteInspeccion() != null
					&& tramiteInspeccionAux.getTramiteInspeccion().getTicodigo() != null) {

				TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
				tramiteInspeccion.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
				tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

				TramiteInspeccionDetalle tramiteInspeccionDetalleAux = new TramiteInspeccionDetalle();
				tramiteInspeccionDetalleAux.setTicodigo(tramiteInspeccion.getTicodigo());

				if (tramiteInspeccion.getTicotee() != null && tramiteInspeccion.getTicotee()
						.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION)) {
					listProceedings = this.reabrirExpedienteDecision(tramiteInspeccionDetalleAux, listProceedings);
				}
			}

			Proceedings proceedings = new Proceedings();

			if (tramiteInspeccionDetalle != null && tramiteInspeccionDetalle.getTiproceedingsidplatea() != null) {
				proceedings.setProceedingsID(tramiteInspeccionDetalle.getTiproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
			}

			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_COMUNICACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_COMUNICACION_EU);
			Calendar cal = Calendar.getInstance();
			cal.setTime(tramiteInspeccionAux.getTifechafin());
			proceedings.setTimestamp(cal);

			if (Y41bUtils.isFilled(tramiteInspeccionAux.getTiidnotificacionplatea())) {
				proceedings.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			} else {
				proceedings.setTipoNotificacion(Y41bConstantes.POSTAL);
			}

			proceedings.setOidnotification(tramiteInspeccionAux.getTiidnotificacionplatea());

			proceedings.setNotifiedActId(Y41bConstantes.NOTIFICACION_COMUNICACION);

			proceedings.setDesnotifiedActCast(Y41bConstantes.LITERAL_COMUNICACION_ES);
			proceedings.setDesnotifiedActEus(Y41bConstantes.LITERAL_COMUNICACION_EU);

			cal = Calendar.getInstance();
			cal.setTime(tramiteInspeccionAux.getTifechafin());
			proceedings.setNotifiedPublicationtimestamp(cal);

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteInspeccionDetalle.getTicodigo());
			List<DocumentoHecho> listDocumentoComunicacion = this.documentoHechoDao
					.findAllDocumentosTramite(tramiteComunAux, null);
			List<Documento> documentos = new ArrayList<Documento>();
			if (listDocumentoComunicacion != null && listDocumentoComunicacion.size() > 0) {
				DocumentoHecho documentoHecho = null;
				for (int k = 0; k < listDocumentoComunicacion.size(); k++) {
					documentoHecho = listDocumentoComunicacion.get(k);
					Documento documento = new Documento();
					if (documentoHecho.getQ5iddocumentum() != null && !documentoHecho.getQ5iddocumentum().equals("")) {
						documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
						documento.setDescripcion(documentoHecho.getQ5tedesfile());
						documento.setNombre(documentoHecho.getQ5nofile());
						documentos.add(documento);
					}
				}
			}

			proceedings.setDocumentosNotificacionComunicacion(documentos);

			listProceedings.add(proceedings);
		}

		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para comunicacion participacin del
	 * establecimiento responsable
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteComunicacionParticipacionEstablecimientoResponsable(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, List<Proceedings> listProceedings) {
		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTicodigo(tramiteInspeccionDetalle.getTicodigo());
		tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);

		boolean remesaEmitida = true;
		if (tramiteInspeccionAux.getTienvrem() != null
				&& tramiteInspeccionAux.getTienvrem().equals(Y41bConstantes.VALOR_SI)) {

			if (tramiteInspeccionAux.getTicodrem() != null && !tramiteInspeccionAux.getTicodrem().equals("")) {
				// buscar remesa
				Remesa remesa = new Remesa();
				remesa.setRmcodigo(tramiteInspeccionAux.getTicodrem());
				remesa = this.remesaDao.find(remesa);

				if (!remesa.getRmestado().equals(Y41bConstantes.ESTADO_REMESA_EMITIDA)) {
					remesaEmitida = false;
				}
			} else {
				remesaEmitida = false;
			}
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(tramiteInspeccionAux.getTiiddestinatario());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO))
				&& (tramiteInspeccionAux.getTitipocomunicacion() != null && (tramiteInspeccionAux
						.getTitipocomunicacion().equals(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO)
						|| tramiteInspeccionAux.getTitipocomunicacion()
								.equals(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA)))
				&& remesaEmitida) {
			if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTramiteInspeccion() != null
					&& tramiteInspeccionAux.getTramiteInspeccion().getTicodigo() != null) {

				TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
				tramiteInspeccion.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
				tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

				TramiteInspeccionDetalle tramiteInspeccionDetalleAux = new TramiteInspeccionDetalle();
				tramiteInspeccionDetalleAux.setTicodigo(tramiteInspeccion.getTicodigo());

				if (tramiteInspeccion.getTicotee() != null && tramiteInspeccion.getTicotee()
						.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION)) {
					listProceedings = this.reabrirExpedienteDecision(tramiteInspeccionDetalleAux, listProceedings);
				}
			}

			Proceedings proceedings = new Proceedings();

			if (tramiteInspeccionDetalle != null && tramiteInspeccionDetalle.getTiproceedingsidplatea() != null) {
				proceedings.setProceedingsID(tramiteInspeccionDetalle.getTiproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
			}

			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_COMUNICACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_COMUNICACION_EU);
			Calendar cal = Calendar.getInstance();
			cal.setTime(tramiteInspeccionAux.getTifechafin());
			proceedings.setTimestamp(cal);

			if (Y41bUtils.isFilled(tramiteInspeccionAux.getTiidnotificacionplatea())) {
				proceedings.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			} else {
				proceedings.setTipoNotificacion(Y41bConstantes.POSTAL);
			}

			proceedings.setOidnotification(tramiteInspeccionAux.getTiidnotificacionplatea());

			proceedings.setNotifiedActId(Y41bConstantes.NOTIFICACION_COMUNICACION);

			proceedings.setDesnotifiedActCast(Y41bConstantes.LITERAL_COMUNICACION_ES);
			proceedings.setDesnotifiedActEus(Y41bConstantes.LITERAL_COMUNICACION_EU);

			cal = Calendar.getInstance();
			cal.setTime(tramiteInspeccionAux.getTifechafin());
			proceedings.setNotifiedPublicationtimestamp(cal);

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteInspeccionDetalle.getTicodigo());
			List<DocumentoHecho> listDocumentoComunicacion = this.documentoHechoDao
					.findAllDocumentosTramite(tramiteComunAux, null);
			List<Documento> documentos = new ArrayList<Documento>();
			if (listDocumentoComunicacion != null && listDocumentoComunicacion.size() > 0) {
				DocumentoHecho documentoHecho = null;
				for (int k = 0; k < listDocumentoComunicacion.size(); k++) {
					documentoHecho = listDocumentoComunicacion.get(k);
					Documento documento = new Documento();
					if (documentoHecho.getQ5iddocumentum() != null && !documentoHecho.getQ5iddocumentum().equals("")) {
						documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
						documento.setDescripcion(documentoHecho.getQ5tedesfile());
						documento.setNombre(documentoHecho.getQ5nofile());
						documentos.add(documento);
					}
				}
			}

			proceedings.setDocumentosNotificacionComunicacion(documentos);

			listProceedings.add(proceedings);
		}

		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para decision
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteDecision(TramiteInspeccionDetalle tramiteInspeccionDetalle,
			List<Proceedings> listProceedings) {

		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTicodigo(tramiteInspeccionDetalle.getTicodigo());
		tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);

		Proceedings proceedings = new Proceedings();

		if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTiproceedingsidplatea() != null) {
			proceedings.setProceedingsID(tramiteInspeccionAux.getTiproceedingsidplatea());
		} else {
			proceedings.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
		}

		proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_DECISION_ES);
		proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_DECISION_EU);
		Calendar cal = Calendar.getInstance();
		cal.setTime(tramiteInspeccionAux.getTifechafin());
		proceedings.setTimestamp(cal);

		Decision decision = new Decision();
		decision.setDecodigo(tramiteInspeccionAux.getTidecodigo());

		decision = this.decisionDao.find(decision);

		proceedings.setDecisionCast(decision.getDenombre());
		proceedings.setDecisionEus(decision.getDenombree());
		cal = Calendar.getInstance();
		cal.setTime(tramiteInspeccionAux.getTifecharesolucion());
		proceedings.setDecisiontimestamp(cal);

		listProceedings.add(proceedings);

		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para acuse recibo participacion del
	 * establecimiento visitado
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteAcuseReciboParticipacionEstablecimientoVisitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, List<Proceedings> listProceedings) {

		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTicodigo(tramiteInspeccionDetalle.getTicodigo());
		tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(tramiteInspeccionAux.getTramiteInspeccion().getTiiddestinatario());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO)
						|| intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)
						|| intervinientes.getTipoInterviniente().equals(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO))) {

			TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
			tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

			if (tramiteInspeccion != null && tramiteInspeccion.getTramiteInspeccion() != null
					&& tramiteInspeccion.getTramiteInspeccion().getTicodigo() != null) {

				tramiteInspeccion.setTicodigo(tramiteInspeccion.getTramiteInspeccion().getTicodigo());
				tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

				TramiteInspeccionDetalle tramiteInspeccionDetalleAux = new TramiteInspeccionDetalle();
				tramiteInspeccionDetalleAux.setTicodigo(tramiteInspeccion.getTicodigo());

				if (tramiteInspeccion.getTicotee() != null && tramiteInspeccion.getTicotee()
						.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION)) {
					listProceedings = this.reabrirExpedienteDecision(tramiteInspeccionDetalleAux, listProceedings);
				}
			}

			Proceedings proceedings = new Proceedings();

			if (tramiteInspeccionDetalle != null && tramiteInspeccionDetalle.getTiproceedingsidplatea() != null) {
				proceedings.setProceedingsID(tramiteInspeccionDetalle.getTiproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
			}

			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_NOTIFICACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_NOTIFICACION_EU);

			tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
			tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

			Calendar cal = Calendar.getInstance();
			cal.setTime(tramiteInspeccion.getTifechafin());
			proceedings.setTimestamp(cal);

			if (Y41bUtils.isFilled(tramiteInspeccionAux.getTramiteInspeccion().getTiidnotificacionplatea())) {
				proceedings.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			} else {
				proceedings.setTipoNotificacion(Y41bConstantes.POSTAL);
			}

			proceedings.setOidnotification(tramiteInspeccionAux.getTramiteInspeccion().getTiidnotificacionplatea());

			proceedings.setNotifiedActId(tramiteInspeccionAux.getTramiteInspeccion().getTitiponotificacionplatea());

			cal = Calendar.getInstance();
			cal.setTime(tramiteInspeccion.getTifechafin());
			proceedings.setNotifiedPublicationtimestamp(cal);

			proceedings.setNotifiedResult(tramiteInspeccionAux.getTiacusereciborecibido());

			if (proceedings.getNotifiedResult() != null
					&& !proceedings.getNotifiedResult().equals(Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO)) {
				cal = Calendar.getInstance();
				cal.setTime(tramiteInspeccionAux.getTiacuserecibo());
				proceedings.setNotifiedDeliverytimestamp(cal);
			}

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
			List<DocumentoHecho> listDocumentoComunicacion = this.documentoHechoDao
					.findAllDocumentosTramite(tramiteComunAux, null);
			List<Documento> documentos = new ArrayList<Documento>();
			if (listDocumentoComunicacion != null && listDocumentoComunicacion.size() > 0) {
				DocumentoHecho documentoHecho = null;

				for (int k = 0; k < listDocumentoComunicacion.size(); k++) {
					documentoHecho = listDocumentoComunicacion.get(k);
					Documento documento = new Documento();
					if (documentoHecho.getQ5iddocumentum() != null && !documentoHecho.getQ5iddocumentum().equals("")) {
						documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
						documento.setDescripcion(documentoHecho.getQ5tedesfile());
						documento.setNombre(documentoHecho.getQ5nofile());
						documentos.add(documento);
					}
				}
			}

			proceedings.setDocumentosNotificacionComunicacion(documentos);

			listProceedings.add(proceedings);
		}

		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para acuse recibo participacion del
	 * establecimiento responsable
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteAcuseReciboParticipacionEstablecimientoResponsable(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, List<Proceedings> listProceedings) {

		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTicodigo(tramiteInspeccionDetalle.getTicodigo());
		tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(tramiteInspeccionAux.getTramiteInspeccion().getTiiddestinatario());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null && (intervinientes
				.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)
				|| intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)
				|| intervinientes.getTipoInterviniente().equals(
						Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO))) {

			TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
			tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

			if (tramiteInspeccion != null && tramiteInspeccion.getTramiteInspeccion() != null
					&& tramiteInspeccion.getTramiteInspeccion().getTicodigo() != null) {

				tramiteInspeccion.setTicodigo(tramiteInspeccion.getTramiteInspeccion().getTicodigo());
				tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

				TramiteInspeccionDetalle tramiteInspeccionDetalleAux = new TramiteInspeccionDetalle();
				tramiteInspeccionDetalleAux.setTicodigo(tramiteInspeccion.getTicodigo());

				if (tramiteInspeccion.getTicotee() != null && tramiteInspeccion.getTicotee()
						.equals(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION)) {
					listProceedings = this.reabrirExpedienteDecision(tramiteInspeccionDetalleAux, listProceedings);
				}
			}

			Proceedings proceedings = new Proceedings();

			if (tramiteInspeccionDetalle != null && tramiteInspeccionDetalle.getTiproceedingsidplatea() != null) {
				proceedings.setProceedingsID(tramiteInspeccionDetalle.getTiproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
			}

			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_NOTIFICACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_NOTIFICACION_EU);

			tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTicodigo(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
			tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

			Calendar cal = Calendar.getInstance();
			cal.setTime(tramiteInspeccion.getTifechafin());
			proceedings.setTimestamp(cal);

			if (Y41bUtils.isFilled(tramiteInspeccionAux.getTramiteInspeccion().getTiidnotificacionplatea())) {
				proceedings.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			} else {
				proceedings.setTipoNotificacion(Y41bConstantes.POSTAL);
			}

			proceedings.setOidnotification(tramiteInspeccionAux.getTramiteInspeccion().getTiidnotificacionplatea());

			proceedings.setNotifiedActId(tramiteInspeccionAux.getTramiteInspeccion().getTitiponotificacionplatea());

			cal = Calendar.getInstance();
			cal.setTime(tramiteInspeccion.getTifechafin());
			proceedings.setNotifiedPublicationtimestamp(cal);

			proceedings.setNotifiedResult(tramiteInspeccionAux.getTiacusereciborecibido());

			if (proceedings.getNotifiedResult() != null
					&& !proceedings.getNotifiedResult().equals(Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO)) {
				cal = Calendar.getInstance();
				cal.setTime(tramiteInspeccionAux.getTiacuserecibo());
				proceedings.setNotifiedDeliverytimestamp(cal);
			}

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteInspeccionAux.getTramiteInspeccion().getTicodigo());
			List<DocumentoHecho> listDocumentoComunicacion = this.documentoHechoDao
					.findAllDocumentosTramite(tramiteComunAux, null);
			List<Documento> documentos = new ArrayList<Documento>();
			if (listDocumentoComunicacion != null && listDocumentoComunicacion.size() > 0) {
				DocumentoHecho documentoHecho = null;

				for (int k = 0; k < listDocumentoComunicacion.size(); k++) {
					documentoHecho = listDocumentoComunicacion.get(k);
					Documento documento = new Documento();
					if (documentoHecho.getQ5iddocumentum() != null && !documentoHecho.getQ5iddocumentum().equals("")) {
						documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
						documento.setDescripcion(documentoHecho.getQ5tedesfile());
						documento.setNombre(documentoHecho.getQ5nofile());
						documentos.add(documento);
					}
				}
			}

			proceedings.setDocumentosNotificacionComunicacion(documentos);

			listProceedings.add(proceedings);
		}

		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para aportacion de documentacion
	 * participacin del establecimiento visitado
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 * @throws Exception
	 *             Exception
	 */
	private List<Proceedings> reabrirExpedienteLevantamientoActaParticipacionEstablecimientoVisitado(
			TramiteInspeccionDetalle tramiteInspeccionDetalle, List<Proceedings> listProceedings) throws Exception {
		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTicodigo(tramiteInspeccionDetalle.getTicodigo());
		tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);

		ActaNueva actaNuevaAux = new ActaNueva();
		actaNuevaAux.setAncodigo(tramiteInspeccionAux.getTiaccodigo());
		actaNuevaAux = this.actaNuevaDao.find(actaNuevaAux);

		if (actaNuevaAux.getAneliminadamicarpeta() == null || actaNuevaAux.getAneliminadamicarpeta().equals("")) {
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(actaNuevaAux.getAncodigo());
			List<DocumentoHecho> listDocumentoHechoAporta = this.documentoHechoDao
					.findAllDocumentosTramite(tramiteComunAux, null);

			if (listDocumentoHechoAporta != null && listDocumentoHechoAporta.size() > 0) {

				Proceedings proceedings = new Proceedings();

				if (tramiteInspeccionDetalle != null && tramiteInspeccionDetalle.getTiproceedingsidplatea() != null) {
					proceedings.setProceedingsID(tramiteInspeccionDetalle.getTiproceedingsidplatea());
				} else {
					proceedings.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
				}

				proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_ACTA_ES);
				proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_ACTA_EU);

				List<Documento> documentos = new ArrayList<Documento>();
				if (listDocumentoHechoAporta != null && listDocumentoHechoAporta.size() > 0) {
					DocumentoHecho documentoHecho = null;
					for (int k = 0; k < listDocumentoHechoAporta.size(); k++) {
						documentoHecho = listDocumentoHechoAporta.get(k);
						Documento documento = new Documento();

						documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
						documento.setDescripcion(documentoHecho.getQ5tedesfile());
						documento.setNombre(documentoHecho.getQ5nofile());
						documentos.add(documento);
					}
				}

				Calendar aportacionTimestamp = Calendar.getInstance();

				String fechaActaSinHoras = Y41bUtils.parseDateToString(actaNuevaAux.getAnfecha(),
						Y41bConstantes.CASTELLANO);

				String fechaActaConHoras = "";

				fechaActaConHoras = new StringBuffer().append(fechaActaSinHoras).append(" 01:00:00").toString();

				aportacionTimestamp
						.setTime(Y41bUtils.parseDateTime(fechaActaConHoras, new Locale(Y41bConstantes.CASTELLANO)));

				proceedings.setTimestamp(aportacionTimestamp);

				proceedings.setDocumentosNotificacionComunicacion(documentos);

				listProceedings.add(proceedings);

			}
		}
		return listProceedings;
	}

	/**
	 * Aporta el justificante del acuse telematico al tramite de acuse
	 * 
	 * @param tramiteinspeccionAcuse
	 *            TramiteInspeccion
	 * @param justificanteAcuse
	 *            Documento
	 */
	public void aportarJustificanteAcuseRecibo(TramiteInspeccion tramiteinspeccionAcuse, Documento justificanteAcuse) {

		DocumentoHecho docHechoJustificanteAcuse = new DocumentoHecho();
		docHechoJustificanteAcuse.setQ5codocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

		docHechoJustificanteAcuse.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION);
		docHechoJustificanteAcuse.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_ACUSE_RECIBO);
		docHechoJustificanteAcuse.setQ5iddocumentum(justificanteAcuse.getOidDokusi());
		docHechoJustificanteAcuse.setQ5contenttypefile(justificanteAcuse.getContentType());
		docHechoJustificanteAcuse.setQ5nofile(justificanteAcuse.getNombre());
		docHechoJustificanteAcuse.setQ5tedesfile(Y41bConstantes.JUSTIFICANTE_NOTIFICACION_ELECTRONICA);
		docHechoJustificanteAcuse.setQ5sizefile((int) justificanteAcuse.getLength());
		docHechoJustificanteAcuse.setQ5hdcodigo(tramiteinspeccionAcuse.getTiatcodigo());
		docHechoJustificanteAcuse.setQ5tramite(tramiteinspeccionAcuse.getTicodigo());
		docHechoJustificanteAcuse.setQ5fecha(new Date());

		this.documentoHechoDao.add(docHechoJustificanteAcuse);

		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		documentoTramiteHecho.setEhcodigo(tramiteinspeccionAcuse.getTicodigo());
		documentoTramiteHecho.setCodocumento(docHechoJustificanteAcuse.getQ5codocumento());
		documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocsMovilidad(InspeccionDetalle inspeccionDetalle, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("fecha")) {
				pagination.setSort("Q5FECHA");
			}
			if (pagination.getSort() == null || pagination.getSort().equals("origen")) {
				pagination.setSort("Q5ORIGEN");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("tedesfile")) {
				pagination.setSort("Q5TEDESFILE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("fnombre")) {
				pagination.setSort("FNOMBRE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("fnombree")) {
				pagination.setSort("FNOMBREE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("trnombre")) {
				pagination.setSort("TRNOMBRE");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("trnombree")) {
				pagination.setSort("TRNOMBREE");
			}
		}

		Campanha campanha = new Campanha();
		Alerta alerta = new Alerta();
		ComunicacionSoivre comunicacionSoivre = new ComunicacionSoivre();
		SolicitudDetalle solDetalle = new SolicitudDetalle();

		if (inspeccionDetalle.getAtcocm() != null && !(inspeccionDetalle.getAtcocm().equalsIgnoreCase(""))) {

			campanha.setCmcodigo(inspeccionDetalle.getAtcocm());
			campanha = this.campanhaDao.find(campanha);
		} else if (inspeccionDetalle.getAtcoal() != null && !(inspeccionDetalle.getAtcoal().equalsIgnoreCase(""))) {

			alerta.setAlcodigo(inspeccionDetalle.getAtcoal());
			alerta = this.alertaDao.find(alerta);
		} else if (inspeccionDetalle.getAtidcomunicacionsoivre() != null
				&& !(inspeccionDetalle.getAtidcomunicacionsoivre().equalsIgnoreCase(""))) {

			comunicacionSoivre.setIdcomunicacionsoivre(inspeccionDetalle.getAtidcomunicacionsoivre());
			comunicacionSoivre = this.comunicacionSoivreDao.find(comunicacionSoivre);
		} else if (inspeccionDetalle.getAtcohd() != null && !(inspeccionDetalle.getAtcohd().equalsIgnoreCase(""))) {

			solDetalle.setHdcodigo(inspeccionDetalle.getAtcohd());
			solDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);
		}

		// return this.documentoHechoDao.findAllDocumentosHechoInspeccion(
		// tramiteComun, pagination);
		return this.documentoHechoDao.findAllDocsMovilidad(inspeccionDetalle, pagination, campanha, alerta,
				comunicacionSoivre, solDetalle);
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocsMovilidadCount(InspeccionDetalle inspeccionDetalle) {
		// return this.documentoHechoDao
		// .findAllDocumentosHechoInspeccionCount(tramiteComun);

		Campanha campanha = new Campanha();
		Alerta alerta = new Alerta();
		ComunicacionSoivre comunicacionSoivre = new ComunicacionSoivre();
		SolicitudDetalle solDetalle = new SolicitudDetalle();

		if (inspeccionDetalle.getAtcocm() != null && !(inspeccionDetalle.getAtcocm().equalsIgnoreCase(""))) {

			campanha.setCmcodigo(inspeccionDetalle.getAtcocm());
			campanha = this.campanhaDao.find(campanha);
		} else if (inspeccionDetalle.getAtcoal() != null && !(inspeccionDetalle.getAtcoal().equalsIgnoreCase(""))) {

			alerta.setAlcodigo(inspeccionDetalle.getAtcoal());
			alerta = this.alertaDao.find(alerta);
		} else if (inspeccionDetalle.getAtidcomunicacionsoivre() != null
				&& !(inspeccionDetalle.getAtidcomunicacionsoivre().equalsIgnoreCase(""))) {

			comunicacionSoivre.setIdcomunicacionsoivre(inspeccionDetalle.getAtidcomunicacionsoivre());
			comunicacionSoivre = this.comunicacionSoivreDao.find(comunicacionSoivre);
		} else if (inspeccionDetalle.getAtcohddenuncia() != null
				&& !(inspeccionDetalle.getAtcohddenuncia().equalsIgnoreCase(""))) {

			solDetalle.setHdcodigo(inspeccionDetalle.getAtcohddenuncia());
			solDetalle = this.hechoDenunciadoDao.findSolicitud(solDetalle);
		}
		return this.documentoHechoDao.findAllDocsMovilidadCount(inspeccionDetalle, campanha, alerta, comunicacionSoivre,
				solDetalle);
	}

	/**
	 * Envia mail al instructor al hacer una aportacion de documentacion
	 * mediante la utilidad de y41b, solo si el expediente esta cerrado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	private void enviarMailInstructor(TramiteInspeccion tramiteinspeccion) {

		logger.info("Inicio enviarMailInstructor");

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteinspeccion.getTiatcodigo());
		InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

		if (inspeccionDetalle.getAtfechacierre() != null) {
			CensoMonitor instructor = new CensoMonitor();

			instructor.setMocodigo(inspeccionDetalle.getMocodigo());
			instructor = this.censoMonitorDao.find(instructor);

			if (instructor != null && !Y41bUtils.esNullOCadenaVacia(instructor.getMocoem())) {
				// obtener servidor smtp
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");
				// 0. From
				String from = "";
				Parametros parametros = new Parametros();
				parametros.setParametro(Y41bConstantes.PARAMETRO_GENERAL_FROMGENERICO);
				parametros = this.parametrosDao.find(parametros);
				if (parametros == null || (parametros != null
						&& (parametros.getValor() == null || parametros.getValor().equals("")))) {
					// salimos sin enviar correo - no esta definido el from en
					// parametros
					logger.info("enviarMailInstructor / Correo no enviado - no esta definido el from en parametros");

					return;
				}
				from = parametros.getValor();
				// 1. Destinatario
				String destinatario = instructor.getMocoem();
				// 2. Creo el asunto
				// Obtener el numero de expediente

				StringBuilder numeroExpediente = new StringBuilder();

				numeroExpediente.append("INS-").append(inspeccionDetalle.getAccoor()).append("-")
						.append(inspeccionDetalle.getAcnror()).append("-").append(inspeccionDetalle.getAcnran())
						.append("-").append(inspeccionDetalle.getAtnror());
				logger.info("enviarMailInstructor / numExpediente" + numeroExpediente);

				StringBuilder asunto = new StringBuilder();
				// Castellano
				asunto.append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.asunto", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				asunto.append(" ").append(numeroExpediente).append(" / ");
				// Euskera
				asunto.append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.asunto", null,
						new Locale(Y41bConstantes.EUSKERA)));
				asunto.append(" ").append(numeroExpediente);
				// 3. Creo el contenido del mail
				StringBuilder texto = new StringBuilder();
				String[] params = new String[1];
				params[0] = numeroExpediente.toString();
				texto.append("<B>").append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.texto",
						params, new Locale(Y41bConstantes.CASTELLANO)));
				texto.append(" / ").append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.texto",
						params, new Locale(Y41bConstantes.EUSKERA))).append("</B><BR>");
				boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
						destinatario, "", null);
				if (!enviadoOK) {
					logger.info("enviarMailInstructor / Correo no enviado - sendMail resultado false");
				} else {
					logger.info("enviarMailInstructor / Correo enviado correctamente");
				}
			} else {
				logger.info(
						"enviarMailInstructor / No se ha enviado correo al intructor porque carece de correo electronico (email)");
			}
		}
		logger.info("FIN enviarMailInstructor");
	}

	/**
	 * Envia mail al instructor al hacer una aportacion de documentacion
	 * mediante la utilidad de y41b, solo si el expediente tiene el registro de
	 * decision tramitado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void enviarMailInstructorRegistroDecision(TramiteInspeccion tramiteinspeccion) {

		logger.info("Inicio enviarMailInstructorRegistroDecision");

		TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
		tramiteInspeccionDetalle.setAtcodigo(tramiteinspeccion.getTiatcodigo());

		this.tramiteInspeccionDao.findAllTramiteRegistroDecisionTramitadoCount(tramiteInspeccionDetalle);

		Long tramiteRegistroDecisionTramitado = this.tramiteInspeccionDao
				.findAllTramiteRegistroDecisionTramitadoCount(tramiteInspeccionDetalle);

		if (tramiteRegistroDecisionTramitado > 0) {
			CensoMonitor instructor = new CensoMonitor();

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteinspeccion.getTiatcodigo());
			InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

			instructor.setMocodigo(inspeccionDetalle.getMocodigo());
			instructor = this.censoMonitorDao.find(instructor);

			if (instructor != null && !Y41bUtils.esNullOCadenaVacia(instructor.getMocoem())) {
				// obtener servidor smtp
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");
				// 0. From
				String from = "";
				Parametros parametros = new Parametros();
				parametros.setParametro(Y41bConstantes.PARAMETRO_GENERAL_FROMGENERICO);
				parametros = this.parametrosDao.find(parametros);
				if (parametros == null || (parametros != null
						&& (parametros.getValor() == null || parametros.getValor().equals("")))) {
					// salimos sin enviar correo - no esta definido el from en
					// parametros
					logger.info(
							"enviarMailInstructorRegistroDecision / Correo no enviado - no esta definido el from en parametros");

					return;
				}
				from = parametros.getValor();
				// 1. Destinatario
				String destinatario = instructor.getMocoem();
				// 2. Creo el asunto
				// Obtener el numero de expediente

				StringBuilder numeroExpediente = new StringBuilder();

				numeroExpediente.append("INS-").append(inspeccionDetalle.getAccoor()).append("-")
						.append(inspeccionDetalle.getAcnror()).append("-").append(inspeccionDetalle.getAcnran())
						.append("-").append(inspeccionDetalle.getAtnror());
				logger.info("enviarMailInstructorRegistroDecision / numExpediente" + numeroExpediente);

				StringBuilder asunto = new StringBuilder();
				// Castellano
				asunto.append(this.appMessageSource.getMessage("aportacionExpedienteDecision.mail.asunto", null,
						new Locale(Y41bConstantes.CASTELLANO)));
				asunto.append(" ").append(numeroExpediente).append(" / ");
				// Euskera
				asunto.append(this.appMessageSource.getMessage("aportacionExpedienteDecision.mail.asunto", null,
						new Locale(Y41bConstantes.EUSKERA)));
				asunto.append(" ").append(numeroExpediente);
				// 3. Creo el contenido del mail
				StringBuilder texto = new StringBuilder();
				String[] params = new String[1];
				params[0] = numeroExpediente.toString();
				texto.append("<B>").append(this.appMessageSource.getMessage("aportacionExpedienteDecision.mail.texto",
						params, new Locale(Y41bConstantes.CASTELLANO)));
				texto.append(" / ").append(this.appMessageSource.getMessage("aportacionExpedienteDecision.mail.texto",
						params, new Locale(Y41bConstantes.EUSKERA))).append("</B><BR>");
				boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
						destinatario, "", null);
				if (!enviadoOK) {
					logger.info("enviarMailInstructorRegistroDecision / Correo no enviado - sendMail resultado false");
				} else {
					logger.info("enviarMailInstructorRegistroDecision / Correo enviado correctamente");
				}
			} else {
				logger.info(
						"enviarMailInstructorRegistroDecision / No se ha enviado correo al intructor porque carece de correo electronico (email)");
			}
		}
		logger.info("FIN enviarMailInstructorRegistroDecision");
	}

	/**
	 * Envia un mail al tramitar comunicacion nuevo distribuidor
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	private void envioEmailComunicacionNuevoDistribuidor(TramiteComun tramiteComun) {
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

		// Remitente
		String from = "";
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.PARAMETRO_CONTROLMERCADO_FROMGENERICO);
		parametros = this.parametrosDao.find(parametros);

		if (parametros != null && (parametros.getValor() == null || parametros.getValor().equals(""))) {
			throw new Y41bUDAException("error.parametro.CONTROLMERCADO_FROMGENERICO_EMAIL", true, new Exception());
		} else {
			from = parametros.getValor();
		}

		// Destinatarios
		StringBuffer destinatarios = new StringBuffer("");
		parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.PARAMETRO_CONTROLMERCADO_TOGENERICO);
		parametros = this.parametrosDao.find(parametros);

		if (parametros != null && (parametros.getValor() == null || parametros.getValor().equals(""))) {
			throw new Y41bUDAException("error.parametro.CONTROLMERCADO_TOGENERICO_EMAIL", true, new Exception());
		} else {
			destinatarios.append(parametros.getValor());
		}

		// 2. Asunto del mail

		String numExpediente = this.findNumExpedienteActuacion(tramiteComun.getIdExpediente());

		StringBuffer asunto = new StringBuffer();
		// EU
		asunto.append(numExpediente);
		asunto.append(" ");
		asunto.append(this.appMessageSource.getMessage("inspeccion.comunicacionNuevoDistribuidor.mail.asunto", null,
				new Locale(Y41bConstantes.EUSKERA)));
		// Separador
		asunto.append(" / ");
		// ES
		asunto.append(numExpediente);
		asunto.append(" ");
		asunto.append(this.appMessageSource.getMessage("inspeccion.comunicacionNuevoDistribuidor.mail.asunto", null,
				new Locale(Y41bConstantes.CASTELLANO)));

		// 3. Creo el contenido del mail
		StringBuffer texto = new StringBuffer();

		// EU
		texto.append(numExpediente);
		texto.append(" ");
		texto.append(this.appMessageSource.getMessage("inspeccion.comunicacionNuevoDistribuidor.mail.texto", null,
				new Locale(Y41bConstantes.EUSKERA)));
		// Separador
		texto.append("<BR>");
		texto.append("<BR>");
		texto.append("<BR>");
		// ES
		texto.append(this.appMessageSource.getMessage("inspeccion.comunicacionNuevoDistribuidor.mail.texto", null,
				new Locale(Y41bConstantes.CASTELLANO)));
		texto.append(" ");
		texto.append(numExpediente);

		boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
				destinatarios.toString(), "", null);
		if (!enviadoOK) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}
	}
}
