package com.ejie.y41b.service;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;

import javax.sql.rowset.serial.SerialException;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.TramiteAcuseRecibo;
import com.ejie.y41b.model.TramiteAdjuntarDocs;
import com.ejie.y41b.model.TramiteAlegacion;
import com.ejie.y41b.model.TramiteAnulacionPropuestaSancion;
import com.ejie.y41b.model.TramiteAsignacionInstructor;
import com.ejie.y41b.model.TramiteBOPVAyto;
import com.ejie.y41b.model.TramiteCierre;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteElaboracionBOPVAyto;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteINSAceptacionInformeValoracion;
import com.ejie.y41b.model.TramiteINSAcuerdoInicioProcedimiento;
import com.ejie.y41b.model.TramiteINSAmpliacionInspeccion;
import com.ejie.y41b.model.TramiteINSArchivoAIP;
import com.ejie.y41b.model.TramiteINSComunicarNuevoDistribuidor;
import com.ejie.y41b.model.TramiteINSDesinmovilizacion;
import com.ejie.y41b.model.TramiteINSEmisionInforme;
import com.ejie.y41b.model.TramiteINSEnviarMuestraEmpresa;
import com.ejie.y41b.model.TramiteINSEstablecimientoRelacionConCampana;
import com.ejie.y41b.model.TramiteINSEstablecimientoRelacionConRedAlerta;
import com.ejie.y41b.model.TramiteINSGenericoFirma;
import com.ejie.y41b.model.TramiteINSLevantamientoActa;
import com.ejie.y41b.model.TramiteINSOrdenServicio;
import com.ejie.y41b.model.TramiteINSRecepcionCertificadoDestruccion;
import com.ejie.y41b.model.TramiteINSRecepcionJustificanteDevolucion;
import com.ejie.y41b.model.TramiteINSRemisionMuestrasAlLaboratorio;
import com.ejie.y41b.model.TramiteINSResolucionAIP;
import com.ejie.y41b.model.TramiteINSResultadoEnsayos;
import com.ejie.y41b.model.TramiteINSRevisionInclusionRedAlerta;
import com.ejie.y41b.model.TramiteINSValoracionInspeccion;
import com.ejie.y41b.model.TramiteInformeAsesoria;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteNotificacion;
import com.ejie.y41b.model.TramiteRecepcionOrdenConsejero;
import com.ejie.y41b.model.TramiteRecepcionRecurso;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoInformacion;
import com.ejie.y41b.model.TramiteRegistroDecision;
import com.ejie.y41b.model.TramiteRegistroSolicitud;
import com.ejie.y41b.model.TramiteRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRequerimientoInformacion;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;

/**
 * InstramexpService
 * 
 *  
 */

public interface InstramexpService {

	/*********************
	 * FINDS DE TRAMITES *
	 *********************/

	/**
	 * Finds a single row in the inspeccion tramite table.
	 * 
	 * @param tramiteEmisionInforme
	 *            TramiteINSEmisionInforme
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSEmisionInforme findTramiteEmisionInforme(TramiteINSEmisionInforme tramiteEmisionInforme,
			CensoMonitor censoMonitor) throws SQLException, IOException;

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramiteRecepcionRequerimiento
	 *            TramiteResolucionAIP
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteResolucionAIP
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSResolucionAIP findTramiteResolucionAIP(TramiteINSResolucionAIP tramiteRecepcionRequerimiento,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the inspeccion tramite table.
	 * 
	 * @param tramiteResultadoEnsayos
	 *            TramiteINSResultadoEnsayos
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSResultadoEnsayos findTramiteResultadoEnsayos(TramiteINSResultadoEnsayos tramiteResultadoEnsayos,
			CensoMonitor censoMonitor) throws SQLException, IOException;

	/**
	 * Finds a single row in the inspeccion tramite table.
	 * 
	 * @param tramiteDesinmovilizacion
	 *            TramiteINSDesinmovilizacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSDesinmovilizacion findTramiteDesinmovilizacion(
			TramiteINSDesinmovilizacion tramiteDesinmovilizacion, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the inspeccion tramite table.
	 * 
	 * @param tramiteRemisionMuestrasAlLaboratorio
	 *            TramiteINSRemisionMuestrasAlLaboratorio
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSRemisionMuestrasAlLaboratorio findTramiteRemisionMuestrasAlLaboratorio(
			TramiteINSRemisionMuestrasAlLaboratorio tramiteRemisionMuestrasAlLaboratorio, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the inspeccion tramite table.
	 * 
	 * @param tramiteINSEnviarMuestraEmpresa
	 *            TramiteINSEnviarMuestraEmpresa
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSRemisionMuestrasAlLaboratorio
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSEnviarMuestraEmpresa findTramiteEnviarMuestraEmpresa(
			TramiteINSEnviarMuestraEmpresa tramiteINSEnviarMuestraEmpresa, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteINSRecepcionJustificanteDevolucion
	 *            TramiteINSRecepcionJustificanteDevolucion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteINSRecepcionJustificanteDevolucion findTramiteRecepcionJustificanteDevolucion(
			TramiteINSRecepcionJustificanteDevolucion tramiteINSRecepcionJustificanteDevolucion,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteINSEstablecimientoRelacionConRedAlerta
	 *            TramiteINSEstablecimientoRelacionConRedAlerta
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteINSEstablecimientoRelacionConRedAlerta findTramiteEstablecimientoRelacionConRedAlerta(
			TramiteINSEstablecimientoRelacionConRedAlerta tramiteINSEstablecimientoRelacionConRedAlerta,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteINSEstablecimientoRelacionConCampana
	 *            TramiteINSEstablecimientoRelacionConCampana
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSEstablecimientoRelacionConCampana findTramiteEstablecimientoRelacionConCampana(
			TramiteINSEstablecimientoRelacionConCampana tramiteINSEstablecimientoRelacionConCampana,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteINSRevisionInclusionRedAlerta
	 *            TramiteINSRevisionInclusionRedAlerta
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteINSRevisionInclusionRedAlerta findTramiteRevisionInclusionRedAlerta(
			TramiteINSRevisionInclusionRedAlerta tramiteINSRevisionInclusionRedAlerta, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHechoDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteAdjuntarDocs findTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteGenerico findTramiteGenerico(TramiteGenerico tramiteGenerico, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteComunicacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteComunicacion findTramiteComunicacion(TramiteComunicacion tramiteComunicacion, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteValoracionInspeccion
	 *            TramiteINSValoracionInspeccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSValoracionInspeccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteINSValoracionInspeccion findTramiteValoracionInspeccion(
			TramiteINSValoracionInspeccion tramiteValoracionInspeccion, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteAmpliacionInspeccion
	 *            TramiteINSAmpliacionInspeccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSAmpliacionInspeccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteINSAmpliacionInspeccion findTramiteAmpliacionInspeccion(
			TramiteINSAmpliacionInspeccion tramiteAmpliacionInspeccion, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteAceptacionInformeValoracion
	 *            TramiteINSAceptacionInformeValoracion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSAmpliacionInspeccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteINSAceptacionInformeValoracion findTramiteAceptacionInformeValoracion(
			TramiteINSAceptacionInformeValoracion tramiteAceptacionInformeValoracion, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteINSOrdenServicio
	 *            TramiteINSOrdenServicio
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSOrdenServicio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSOrdenServicio findTramiteOrdenServicio(TramiteINSOrdenServicio tramiteINSOrdenServicio,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Tramite_Inspeccion table.
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAsignacionInstructor
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	TramiteAsignacionInstructor findTramiteAsignacionInstructor(TramiteAsignacionInstructor tramiteAsignacionInstructor,
			CensoMonitor censoMonitor) throws SQLException, IOException;

	/**
	 * Finds a single row in the Tramite_Inspeccion table.
	 * 
	 * @param tramiteRegistroSolicitud
	 *            TramiteRegistroSolicitud
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRegistroSolicitud
	 */
	TramiteRegistroSolicitud findTramiteRegistroInspeccion(TramiteRegistroSolicitud tramiteRegistroSolicitud,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Tramite_Inspeccion table.
	 * 
	 * @param tramiteINSAcuerdoInicioProcedimiento
	 *            TramiteINSAcuerdoInicioProcedimiento
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSAcuerdoInicioProcedimiento
	 */
	TramiteINSAcuerdoInicioProcedimiento findTramiteAcuerdoInicioProcedimiento(
			TramiteINSAcuerdoInicioProcedimiento tramiteINSAcuerdoInicioProcedimiento, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Tramite_Inspeccion table.
	 * 
	 * @param tramiteLevantamientoActa
	 *            TramiteLevantamientoActa
	 * @param monitor
	 *            CensoMonitor
	 * @return Parametros
	 */
	TramiteINSLevantamientoActa findTramiteLevantamientoActa(TramiteINSLevantamientoActa tramiteLevantamientoActa,
			CensoMonitor monitor);

	/**
	 * Obtiene el objecto de levantamiento de acta
	 * 
	 * @param tramiteRequerimientoInformacion
	 *            TramiteRequerimientoInformacion
	 * @param monitor
	 *            CensoMonitor
	 * @return Parametros
	 */
	TramiteRequerimientoInformacion findTramiteRequerimientoEscrito(
			TramiteRequerimientoInformacion tramiteRequerimientoInformacion, CensoMonitor monitor);

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramiteRecepcionRequerimiento
	 *            TramiteRecepcionRequerimientoInformacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoInformacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteRecepcionRequerimientoInformacion findTramiteRecepcionRequerimiento(
			TramiteRecepcionRequerimientoInformacion tramiteRecepcionRequerimiento, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Tramite_Inspeccion table.
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteCierre
	 */

	TramiteCierre findTramiteCierre(TramiteCierre tramiteCierre, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteNotificacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteNotificacion findTramiteNotificacion(TramiteNotificacion tramiteNotificacion, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Inspecciones table.
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAcuseRecibo
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteAcuseRecibo findTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionRecurso
	 *            TramiteRecepcionRecurso
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRecurso
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionRecurso findTramiteRecepcionRecurso(TramiteRecepcionRecurso tramiteRecepcionRecurso,
			CensoMonitor censoMonitor) throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteInformeAsesoria
	 *            TramiteInformeAsesoria
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteInformeAsesoria
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInformeAsesoria findTramiteInformeAsesoria(TramiteInformeAsesoria tramiteInformeAsesoria,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionOrdenConsejero
	 *            TramiteRecepcionOrdenConsejero
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionOrdenConsejero
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionOrdenConsejero findTramiteRecepcionOrdenConsejero(
			TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejero, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAlegacion
	 *            TramiteAlegacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAlegacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAlegacion findTramiteAlegacion(TramiteAlegacion tramiteAlegacion, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramite
	 *            TramiteAnulacionPropuestaSancion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAnulacionPropuestaSancion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAnulacionPropuestaSancion findTramiteAnulacionPropuestaSancion(
			TramiteAnulacionPropuestaSancion tramite, CensoMonitor censoMonitor);

	/**
	 * Guardar el tramite EmisionInforme
	 * 
	 * @param tramiteEmisionInforme
	 *            TramiteEmisionInforme
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteEmisionInforme(TramiteINSEmisionInforme tramiteEmisionInforme,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite registro decision
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	TramiteInspeccion addTramiteRegistroDecision(TramiteRegistroDecision tramiteRegistroDecision,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite archivo AIP
	 * 
	 * @param tramiteINSArchivoAIP
	 *            TramiteINSArchivoAIP
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	public TramiteInspeccion addTramiteArchivoAIP(TramiteINSArchivoAIP tramiteINSArchivoAIP, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite generico
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteGenerico(TramiteGenerico tramiteGenerico, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Generar tramite generico
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param literalNombreTramite
	 *            String
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteGenericoAutomatico(TramiteGenerico tramiteGenerico, String literalNombreTramite)
			throws Exception;

	/**
	 * Generar tramite generico
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param literalNombreTramite
	 *            String
	 * @param cadenaAdicional
	 *            String
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteGenericoAutomatico(TramiteGenerico tramiteGenerico, String literalNombreTramite,
			String cadenaAdicional) throws Exception;

	/**
	 * Guardar tramite comunicacion
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param tipoComunicacion
	 *            tipo de comunicacion
	 * @param idZipFile
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, String tipoComunicacion, String idZipFile,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * Guardar tramite Valoracion de inspeccion
	 * 
	 * @param tramiteValoracionInspeccion
	 *            TramiteINSValoracionInspeccion
	 * @param tramiteComun
	 *            TramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteValoracionInspeccion(TramiteINSValoracionInspeccion tramiteValoracionInspeccion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite Ampliacion de inspeccion
	 * 
	 * @param tramiteAmpliacionInspeccion
	 *            TramiteINSAmpliacionInspeccion
	 * @param tramiteComun
	 *            TramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteAmpliacionInspeccion(TramiteINSAmpliacionInspeccion tramiteAmpliacionInspeccion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite Aceptacion del Informe de Valoracion
	 * 
	 * @param tramiteAceptacionInformeValoracion
	 *            TramiteINSAceptacionInformeValoracion
	 * @param tramiteComun
	 *            TramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteAceptacionInformeValoracion(
			TramiteINSAceptacionInformeValoracion tramiteAceptacionInformeValoracion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite Orden de Servicio
	 * 
	 * @param tramiteINSOrdenServicio
	 *            TramiteINSOrdenServicio
	 * @param tramiteComun
	 *            TramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteOrdenServicio(TramiteINSOrdenServicio tramiteINSOrdenServicio,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar, CensoMonitor censoMonitor)
			throws Exception;

	/**
	 * Guardar el tramite Desinmovilizacion
	 * 
	 * @param tramiteDesinmovilizacion
	 *            TramiteDesinmovilizacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteDesinmovilizacion(TramiteINSDesinmovilizacion tramiteDesinmovilizacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite ResultadoEnsayos
	 * 
	 * @param tramiteResultadoEnsayos
	 *            TramiteResultadoEnsayos
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteResultadoEnsayos(TramiteINSResultadoEnsayos tramiteResultadoEnsayos,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite RemisionMuestrasAlLaboratorio
	 * 
	 * @param tramiteRemisionMuestrasAlLaboratorio
	 *            TramiteRemisionMuestrasAlLaboratorio
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRemisionMuestrasAlLaboratorio(
			TramiteINSRemisionMuestrasAlLaboratorio tramiteRemisionMuestrasAlLaboratorio, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite EnviarMuestraEmpresa
	 * 
	 * @param tramiteINSEnviarMuestraEmpresa
	 *            TramiteINSEnviarMuestraEmpresa
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteEnviarMuestraEmpresa(
			TramiteINSEnviarMuestraEmpresa tramiteINSEnviarMuestraEmpresa, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite certificado de destruccin
	 * 
	 * @param tramiteINSRecepcionCertificadoDestruccion
	 *            TramiteINSRecepcionCertificadoDestruccion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteRecepcionCertificadoDestruccion(
			TramiteINSRecepcionCertificadoDestruccion tramiteINSRecepcionCertificadoDestruccion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the Inspeccion table.
	 * 
	 * @param tramiteBOPVAyto
	 *            TramiteBOPVAyto
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteBOPVAyto findTramiteBOPVAyto(TramiteBOPVAyto tramiteBOPVAyto, CensoMonitor censoMonitor)
			throws SQLException, IOException;

	/**
	 * Finds a single row in the tramite inspeccion table.
	 * 
	 * @param tramiteINSRecepcionCertificadoDestruccion
	 *            TramiteINSRecepcionCertificadoDestruccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteINSRecepcionCertificadoDestruccion findTramiteRecepcionCertificadoDestruccion(
			TramiteINSRecepcionCertificadoDestruccion tramiteINSRecepcionCertificadoDestruccion,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row of inspeccion.
	 * 
	 * @param tramiteElaboracionBOPVAyto
	 *            TramiteElaboracionBOPVAyto
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteElaboracionBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteElaboracionBOPVAyto findTramiteElaboracionBOPVAyto(TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAyto,
			CensoMonitor censoMonitor) throws SQLException, IOException;

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramite
	 *            TramiteRequerimientoAcreditacionRepresentacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRequerimientoAcreditacionRepresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRequerimientoAcreditacionRepresentacion findTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramite, CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the table.
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionRequerimientoAcreditacionRepresentacion findTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacion,
			CensoMonitor censoMonitor);

	/**
	 * Obtiene el objecto de tramite generico firma
	 * 
	 * @param tramiteINSGenericoFirma
	 *            TramiteINSGenericoFirma
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteINSGenericoFirma
	 */
	public TramiteINSGenericoFirma findTramiteGenericoFirma(TramiteINSGenericoFirma tramiteINSGenericoFirma,
			CensoMonitor monitor);

	/**
	 * Obtiene el objecto de tramite Comunicacin de existencia de nuevo
	 * Distribuidor
	 * 
	 * @param tramiteINSComunicarNuevoDistribuidor
	 *            TramiteINSComunicarNuevoDistribuidor
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteINSComunicarNuevoDistribuidor
	 */
	public TramiteINSComunicarNuevoDistribuidor findTramiteComunicarNuevoDistribuidor(
			TramiteINSComunicarNuevoDistribuidor tramiteINSComunicarNuevoDistribuidor, CensoMonitor monitor);

	/********************
	 * ADDS DE TRAMITES *
	 ********************/

	/**
	 * Guardar tramite certificado de destruccin
	 * 
	 * @param tramiteINSRecepcionJustificanteDevolucion
	 *            TramiteINSRecepcionJustificanteDevolucion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteRecepcionJustificanteDevolucion(
			TramiteINSRecepcionJustificanteDevolucion tramiteINSRecepcionJustificanteDevolucion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Recepcion Requerimiento
	 * 
	 * @param tramiteResolucionAIP
	 *            TramiteResolucionAIPInformacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteResolucionAIP(TramiteINSResolucionAIP tramiteResolucionAIP,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite relacion red alerta
	 * 
	 * @param tramiteINSEstablecimientoRelacionConRedAlerta
	 *            TramiteINSEstablecimientoRelacionConRedAlerta
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteEstablecimientoRelacionConRedAlerta(
			TramiteINSEstablecimientoRelacionConRedAlerta tramiteINSEstablecimientoRelacionConRedAlerta,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite relacion campaa
	 * 
	 * @param tramiteINSEstablecimientoRelacionConCampana
	 *            TramiteINSEstablecimientoRelacionCampana
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteEstablecimientoRelacionConCampana(
			TramiteINSEstablecimientoRelacionConCampana tramiteINSEstablecimientoRelacionConCampana,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite red alerta
	 * 
	 * @param tramiteINSRevisionInclusionRedAlerta
	 *            TramiteINSRevisionInclusionRedAlerta
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteRevisionInclusionRedAlerta(
			TramiteINSRevisionInclusionRedAlerta tramiteINSRevisionInclusionRedAlerta, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite aportacion de documentacion
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite asignacion instructor
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteAsignacionInstructor(TramiteAsignacionInstructor tramiteAsignacionInstructor,
			TramiteComun tramiteComun, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite asignacion instructor
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteAsignacionInstructorMasiva(
			TramiteAsignacionInstructor tramiteAsignacionInstructor, TramiteComun tramiteComun, boolean tramitar,
			String modoEditar) throws Exception;

	/**
	 * Guardar Tramite Registro Inspeccion
	 * 
	 * @param tramiteRegistroSolicitud
	 *            TramiteRegistroSolicitud
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteRegistroSolicitud addTramiteRegistroInspeccion(TramiteRegistroSolicitud tramiteRegistroSolicitud,
			TramiteComun tramiteComun, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar Tramite de Acuerdo de Inicio de Procedimiento
	 * 
	 * @param tramiteAcuerdoInicioProcedimiento
	 *            TramiteINSAcuerdoInicioProcedimiento
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteINSAcuerdoInicioProcedimiento
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteINSAcuerdoInicioProcedimiento addTramiteAcuerdoInicioProcedimiento(
			TramiteINSAcuerdoInicioProcedimiento tramiteAcuerdoInicioProcedimiento, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar Tramite Levantamiento Acta
	 * 
	 * @param tramiteLevantamientoActa
	 *            TramiteINSLevantamientoActa
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteINSLevantamientoActa addTramiteLevantamientoActa(TramiteINSLevantamientoActa tramiteLevantamientoActa,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar Tramite de Acuerdo de Inicio de Procedimiento
	 * 
	 * @param tramiteRequerimientoEscrito
	 *            TramiteRequerimientoInformacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteRequerimientoInformacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteRequerimientoInformacion addTramiteRequerimientoEscrito(
			TramiteRequerimientoInformacion tramiteRequerimientoEscrito, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Recepcion Requerimiento
	 * 
	 * @param tramiteRecepcionRequerimiento
	 *            TramiteRecepcionRequerimientoInformacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteRecepcionRequerimiento(
			TramiteRecepcionRequerimientoInformacion tramiteRecepcionRequerimiento, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite cierre
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteCierre(TramiteCierre tramiteCierre, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar tramite notificacion
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param tipoNotificacion
	 *            tipo de notificacion
	 * @param idZipFile
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteNotificacion(TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, String tipoNotificacion, String idZipFile,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * Guardar el tramite acuse de recibo
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @param docHechoPEE
	 *            DocumentoHecho
	 * @param esRemesa
	 *            boolean
	 * @param reintento
	 *            boolean
	 * @return Inspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, DocumentoHecho docHechoPEE, boolean esRemesa,
			boolean reintento) throws Exception;

	/**
	 * Guardar el tramite BOPVAyto
	 * 
	 * @param tramiteBOPVAyto
	 *            TramiteBOPVAyto
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteBOPVAyto(TramiteBOPVAyto tramiteBOPVAyto, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Elaboracion BOPV
	 * 
	 * @param tramiteElaboracionBOPVAyto
	 *            TramiteElaboracionBOPVAyto
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	TramiteInspeccion addTramiteElaboracionBOPVAyto(TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAyto,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Recepcion Recurso
	 * 
	 * @param tramiteRecepcionRecurso
	 *            TramiteRecepcionRecurso
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRecepcionRecurso(TramiteRecepcionRecurso tramiteRecepcionRecurso,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Informe Asesoria
	 * 
	 * @param tramiteInformeAsesoria
	 *            TramiteInformeAsesoria
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteInformeAsesoria(TramiteInformeAsesoria tramiteInformeAsesoria,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite RecepcionOrdenConsejero
	 * 
	 * @param tramiteRecepcionOrdenConsejero
	 *            TramiteRecepcionOrdenConsejero
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRecepcionOrdenConsejero(
			TramiteRecepcionOrdenConsejero tramiteRecepcionOrdenConsejero, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite alegacion
	 * 
	 * @param tramiteAlegacion
	 *            TramiteAlegacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteAlegacion(TramiteAlegacion tramiteAlegacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite requerimientoAcreditacionRepresentacion
	 * 
	 * @param tramiteRequerimientoAcreditacionRepresentacion
	 *            TramiteRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramiteRequerimientoAcreditacionRepresentacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite Recepcion Requerimiento Acreditacion Representacion
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar Tramite Generico de Firma
	 * 
	 * @param tramiteINSGenericoFirma
	 *            TramiteINSGenericoFirma
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteINSGenericoFirma
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSGenericoFirma addTramiteGenericoFirma(TramiteINSGenericoFirma tramiteINSGenericoFirma,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar Tramite Comunicacin de existencia de nuevo Distribuidor
	 * 
	 * @param tramiteINSComunicarNuevoDistribuidor
	 *            TramiteINSComunicarNuevoDistribuidor
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteINSComunicarNuevoDistribuidor
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteINSComunicarNuevoDistribuidor addTramiteComunicarNuevoDistribuidor(
			TramiteINSComunicarNuevoDistribuidor tramiteINSComunicarNuevoDistribuidor, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Guardar el tramite anulacionPropuestaSancion
	 * 
	 * @param TramiteAnulacionPropuestaSancion
	 *            TramiteAnulacionPropuestaSancion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteAnulacionPropuestaSancion(
			TramiteAnulacionPropuestaSancion tramiteAnulacionPropuestaSancion, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/************************
	 * TRAMITES AUTOMATICOS *
	 ************************/

	/*********
	 * OTROS *
	 *********/

	/**
	 * Finds registro entrada document
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @return RegistroEntrada
	 * @throws Exception
	 *             Exception
	 */
	RegistroEntrada getRegistroEntrada(TramiteComun tramiteComun, Intervinientes intervinientes) throws Exception;

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addTramiteAdjuntarDocsTableTemporal(TramiteComun tramiteComun);

	/**
	 * Inserta las infracciones en la tabla temporal de adjuntar infracciones
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addTramiteAdjuntarActaInfraccTableTemporal(TramiteComun tramiteComun);

	/**
	 * Extrae el origen de una inspeccion segun su id de tramite.
	 * 
	 * @param idTramite
	 *            String
	 * @return String
	 */
	String findOrigenInspeccionPorIdTramite(String idTramite);

	/**
	 * Extrae el origen de una inspeccion segun su id de tramite.
	 * 
	 * @param idTramite
	 *            String
	 * @param locale
	 *            Locale
	 * @return String
	 */
	public String findOrigenInspeccionPorIdExpediente(String atcodigo, Locale locale);

	/**
	 * Extrae el codigo de origen de una inspeccion segun su id de expediente.
	 * 
	 * @param atcodigo
	 *            String
	 * @return String
	 */
	public String findCodOrigenInspeccionPorIdExpediente(String atcodigo);

	/**
	 * Extrae el numero de expediente de una inspeccion segun su id de
	 * expediente.
	 * 
	 * @param idExpediente
	 *            String
	 * @return String
	 */
	String findNumExpedienteActuacion(String idExpediente);

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoExpediente> findAllDocumentosAdjuntos(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Counts rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosAdjuntosCount(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosAdjuntosOrigenExpediente(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Counts rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosAdjuntosOrigenExpedienteCount(TramiteComun tramiteComun);

	/**
	 * Create ejgv document for notificacion and comunication
	 * 
	 * @param textoNotificacionComunicacion
	 *            String
	 * @param destinatario
	 *            String
	 * @param tipoNotificacionPlatea
	 *            String
	 * @param envRemesa
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentNotificacionComunicacion(
			String textoNotificacionComunicacion, String destinatario, String tipoNotificacionPlatea, String envRemesa,
			TramiteComun tramiteComun, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DatosMailOrigen> findAllMailOrigen(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Finds a single row in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailOrigen
	 *            DatosMailOrigen
	 * @return DatosMailOrigen
	 */
	DatosMailOrigen findMailOrigen(TramiteComun tramiteComun, DatosMailOrigen datosMailOrigen);

	/**
	 * Finds a List of rows in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DatosMailEstablecimiento> findAllMailEstablecimiento(TramiteComun tramiteComun, Intervinientes intervinientes,
			Pagination pagination);

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param idDestinatario
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailEstablecimiento
	 *            DatosMailEstablecimiento
	 * @return DatosMailEstablecimiento
	 */
	DatosMailEstablecimiento findMailEstablecimiento(String idDestinatario, TramiteComun tramiteComun,
			DatosMailEstablecimiento datosMailEstablecimiento);

	/**
	 * Finds a List of rows in the datosMailOrigen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DatosMailSede> findAllMailEstablecimientoSede(TramiteComun tramiteComun, Intervinientes intervinientes,
			Pagination pagination);

	/**
	 * Finds a single row in the datosMailEstablecimiento table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param datosMailSede
	 *            DatosMailSede
	 * @return DatosMailSede
	 */
	DatosMailSede findMailEstablecimientoSede(TramiteComun tramiteComun, DatosMailSede datosMailSede);

	/**
	 * Finds a List of rows in the Tramite Inspeccion table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoExpediente> findAllDocumentosHecho(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Counts rows in the Tramite Inspeccion table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosHechoCount(TramiteComun tramiteComun);

	/**
	 * Comprueba si existen tramites de apertura (asignacion de expediente y
	 * registro de inspeccion) en base a un codigo de acta.
	 * 
	 * @param acta
	 *            Acta
	 * @return boolean
	 */
	boolean existenTramitesAperturaPorActa(Acta acta);

	/**
	 * Responde si la actuacion tiene un Acuerdo Inicio Procedimiento.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return boolean
	 */
	boolean existeAcuerdoInicioProcedimiento(Actuacion actuacion);

	/**
	 * Comprueba si existe propuesta de inspeccion o expediente sancionador para
	 * el tipo de interviniente (establecimiento visitado o responsable)
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipoInterviniente
	 *            String
	 * @return boolean
	 */
	public boolean existePropuestaSancionOExpedienteSancionador(TramiteComun tramiteComun, String tipoInterviniente);

	/***********
	 * REMESAS *
	 ***********/

	/**
	 * Finds rows in the Tramites table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifComuni, Pagination pagination);

	/**
	 * Devuelve el tamao de la remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda filterNotifiComuni);

	/**
	 * Counts rows in the Tramites table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda filterNotifComuni);

	/**
	 * Busca los documentos de notificacion o comunicacion que componen la
	 * remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List
	 * @throws Exception
	 *             Exception
	 * @throws SQLException
	 *             SQLException
	 * @throws SerialException
	 *             SerialException
	 */
	List<NotificacionesComunicacionesBusqueda> findAllBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni) throws SerialException, SQLException, Exception;

	/**
	 * Finds registro salida document
	 * 
	 * @param remesa
	 *            Remesa
	 * @param tramiteComun
	 *            TramiteComun
	 * @param intervinientes
	 *            Intervinientes
	 * @return RegistroSalida
	 * @throws Exception
	 *             Exception
	 */
	RegistroSalida getRegistroSalida(Remesa remesa, TramiteComun tramiteComun, Intervinientes intervinientes)
			throws Exception;

	/**
	 * Para actualizar el tramite de acuse de recibo correspondiente al envio de
	 * una remesa.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param remesaEmitida
	 *            Remesa
	 * @param envio
	 *            NotificacionesComunicacionesBusqueda
	 * @param fechaSituacion
	 *            String
	 * @param situacionCorreos
	 *            String
	 * @param estadoDelEnvio
	 *            String
	 * @param documentoByte
	 *            byte[]
	 * @param filename
	 *            String
	 */
	void actualizarTramiteDeAcuseReciboDesdeRemesa(CensoMonitor censoMonitor, Remesa remesaEmitida,
			NotificacionesComunicacionesBusqueda envio, String fechaSituacion, String situacionCorreos,
			String estadoDelEnvio, byte[] documentoByte, String filename);

	/**
	 * Finds a single row in the Inspecciones table.
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRegistroDecision
	 */
	TramiteRegistroDecision findTramiteRegistroDecision(TramiteRegistroDecision tramiteRegistroDecision,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Inspeccion table.
	 * 
	 * @param tramiteINSArchivoAIP
	 *            TramiteINSArchivoAIP
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteINSArchivoAIP
	 */
	public TramiteINSArchivoAIP findTramiteArchivoAIP(TramiteINSArchivoAIP tramiteINSArchivoAIP,
			CensoMonitor censoMonitor);

	/**
	 * Generar Tramite Automatico.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipoTramite
	 *            String
	 * @param estado
	 *            String
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	public TramiteInspeccion generarTramiteAutomaticoConEstado(TramiteComun tramiteComun, String tipoTramite,
			String estado) throws Exception;

	/**
	 * Generar Tramite Automatico con un estado sin ejecutar.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipoTramite
	 *            String
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteAutomatico(TramiteComun tramiteComun, String tipoTramite) throws Exception;

	/**
	 * Generar Tramite Automatico de Levantamiento de acta
	 * 
	 * @param tramiteLevantamientoActa
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	public TramiteInspeccion generarTramiteLevantamientoActa(TramiteInspeccion tramiteLevantamientoActa,
			TramiteComun tramiteComun) throws Exception;

	/**
	 * Generar Tramite Automatico de Revision para inclusion en red de alerta
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteRevisionInclusionRedAlerta(TramiteComun tramiteComun) throws Exception;

	/**
	 * Generar Tramite automatico de Ampliacion de la Inspeccion
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteAmpliacionInspeccion(TramiteInspeccion tramiteInspeccion,
			TramiteComun tramiteComun) throws Exception;

	/**
	 * Genera un tramite de Asignacion de instructor.
	 * 
	 * @param idExpediente
	 *            String
	 * @param moCodigoEjecucion
	 *            String
	 * @param moCodigoDesignado
	 *            String
	 * @param tramitado
	 *            boolean
	 * @throws Exception
	 *             Exception
	 */
	public void generarTramiteAsignacionInstructor(String idExpediente, String moCodigoEjecucion,
			String moCodigoDesignado, boolean tramitado) throws Exception;

	/**
	 * Genera un tramite de Registro de inspeccion.
	 * 
	 * @param idExpediente
	 *            String
	 * @param moCodigoDesignado
	 *            String
	 * @param tramitado
	 *            boolean
	 * @throws Exception
	 *             Exception
	 */
	public void generarTramiteRegistroInspeccion(String idExpediente, String moCodigoDesignado, boolean tramitado)
			throws Exception;

	/**
	 * Generar Tramite Automatico de resultado ensayos
	 * 
	 * @param tramiteComunicacion
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	public TramiteInspeccion generarTramiteResultadoEnsayos(TramiteInspeccion tramiteResultadoEnsayos,
			TramiteComun tramiteComun) throws Exception;

	/**********************
	 * INTEGRACION PLATEA *
	 **********************/

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI
	 * 
	 * @param insDetalle
	 *            InspeccionDetalle
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws SQLException
	 *             SQLException
	 * @throws ParseException
	 *             ParseException
	 */
	public void abrirExpedienteOficioPlatea(InspeccionDetalle insDetalle, TramiteComun tramiteComun)
			throws SQLException, ParseException;

	/**
	 * Actualiza la participacin del establecimiento visitado
	 * 
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarParticipacionEstablecimientoVisitado(TramiteComun tramiteComun) throws Exception;

	/**
	 * Actualiza la participacin del establecimiento responsable
	 * 
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarParticipacionEstablecimientoResponsable(TramiteComun tramiteComun) throws Exception;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de registro de decision
	 * para el establecimiento visitado
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @throws SQLException
	 *             SQLException
	 */
	public void actualizarMisGestionesRegistroDecisionEstablecimientoVisitado(TramiteInspeccion tramiteInspeccion)
			throws SQLException;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de registro de decision
	 * para el establecimiento responsable
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @throws SQLException
	 */
	public void actualizarMisGestionesRegistroDecisionEstablecimientoResponsable(TramiteInspeccion tramiteInspeccion)
			throws SQLException;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado al establecimiento visitado
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 *             SQLException
	 */
	public void actualizarMisGestionesComunicacionEstablecimientoVisitado(TramiteInspeccion tramiteInspeccion,
			List<DocumentoHecho> listDocumentoHecho) throws SQLException;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado al establecimiento responsable
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 *             SQLException
	 */
	public void actualizarMisGestionesComunicacionEstablecimientoResponsable(TramiteInspeccion tramiteInspeccion,
			List<DocumentoHecho> listDocumentoHecho) throws SQLException;

	/**
	 * Esta funcion realiza el tratamiento de mis gestiones para el acuse recibo
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	public void tratamientoMisGestionesAcuseRecibo(TramiteInspeccion tramiteInspeccion) throws Exception;

	/**
	 * Generar Tramite automatico de Remision de muestras al laboratorio
	 * 
	 * @param tramiteInspeccionRemision
	 *            TramiteInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteRemisionMuestrasAlLaboratorio(TramiteInspeccion tramiteInspeccionRemision,
			TramiteComun tramiteComun) throws Exception;

	/**
	 * Generar Tramite Automatico de Requerimiento de Acreditacin
	 * Representacin
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion generarTramiteRequerimientoAcreditacionRepresentacion(Intervinientes intervinientes)
			throws Exception;

	/**********************
	 * ELIMINAR TRAMITE *
	 **********************/

	/**
	 * Elimina el tramite recibido por parametro
	 * 
	 * @param ticodigo
	 *            String
	 */
	public void eliminarTramite(String ticodigo);

	/**
	 * Metodo que recibe una lista de documentos del tramite y los elimina en
	 * DOKUSI
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 */
	public void eliminarDocumentosDokusi(List<DocumentoExpediente> listDocumentoExpediente) throws SQLException;

	/**
	 * Metodo que devuelve true si tiene permiso de modificacion, false si no
	 * tiene permiso de modificacion
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 */
	public boolean tratamientoSeguridad(TramiteInspeccion tramiteInspeccion, CensoMonitor censoMonitor);

	/**
	 * Reabrir expediente
	 * 
	 * @param atcodigo
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 */
	public void reabrirExpediente(String atcodigo, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Metodo que elimina en Mis Gestiones
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @throws SQLException
	 */
	public void eliminarMisGestiones(TramiteInspeccion tramiteinspeccion) throws SQLException;

	/**
	 * Aporta el justificante del acuse telematico al tramite de acuse
	 * 
	 * @param tramiteinspeccionAcuse
	 *            TramiteInspeccion
	 * @param justificanteAcuse
	 *            Documento
	 */
	public void aportarJustificanteAcuseRecibo(TramiteInspeccion tramiteinspeccionAcuse, Documento justificanteAcuse);

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocsMovilidad(InspeccionDetalle inspeccionDetalle, Pagination pagination);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return Long
	 */
	public Long findAllDocsMovilidadCount(InspeccionDetalle inspeccionDetalle);

	/**
	 * Envia mail al instructor al hacer una aportacion de documentacion
	 * mediante la utilidad de y41b, solo si el expediente tiene el registro de
	 * decision tramitado
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 */
	public void enviarMailInstructorRegistroDecision(TramiteInspeccion tramiteinspeccion);
}