package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.InspectorDao;
import com.ejie.y41b.model.Inspector;

/**
 * * InspectorServiceImpl  
 * 
 *  
 */

@Service(value = "inspectorService")
public class InspectorServiceImpl implements InspectorService {

	private static final Logger logger = LoggerFactory
			.getLogger(InspectorServiceImpl.class);
	@Autowired
	private InspectorDao inspectorDao;

	/**
	 * Inserts a single row in the Inspector table.
	 * 
	 * @param inspector
	 *            Inspector
	 * @return Inspector
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Inspector add(Inspector inspector) {
		return this.inspectorDao.add(inspector);
	}

	/**
	 * Updates a single row in the Inspector table.
	 * 
	 * @param inspector
	 *            Inspector
	 * @return Inspector
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Inspector update(Inspector inspector) {
		return this.inspectorDao.update(inspector);
	}

	/**
	 * Finds a single row in the Inspector table.
	 * 
	 * @param inspector
	 *            Inspector
	 * @return Inspector
	 */
	public Inspector find(Inspector inspector) {
		return (Inspector) this.inspectorDao.find(inspector);
	}

	/**
	 * Finds a List of rows in the Inspector table.
	 * 
	 * @param inspector
	 *            Inspector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Inspector> findAll(Inspector inspector, Pagination pagination) {
		return (List<Inspector>) this.inspectorDao.findAll(inspector,
				pagination);
	}

	/**
	 * Counts rows in the Inspector table.
	 * 
	 * @param inspector
	 *            Inspector
	 * @return Long
	 */
	public Long findAllCount(Inspector inspector) {
		return this.inspectorDao.findAllCount(inspector);
	}

	/**
	 * Finds rows in the Inspector table using like.
	 * 
	 * @param inspector
	 *            Inspector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Inspector> findAllLike(Inspector inspector,
			Pagination pagination, Boolean startsWith) {
		return (List<Inspector>) this.inspectorDao.findAllLike(inspector,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the Inspector table.
	 * 
	 * @param inspector
	 *            Inspector
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Inspector inspector) {
		this.inspectorDao.remove(inspector);
	}

	/**
	 * Deletes multiple rows in the Inspector table.
	 * 
	 * @param inspectorList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Inspector> inspectorList) {
		for (Inspector inspectorAux : inspectorList) {
			this.inspectorDao.remove(inspectorAux);
		}
	}

	/**
	 * Getter method for InspectorDao
	 * 
	 * @return InspectorDao
	 */
	public InspectorDao getInspectorDao() {
		return this.inspectorDao;
	}

	/**
	 * Setter method for InspectorDao.
	 * 
	 * @param inspectorDao
	 *            InspectorDao
	 * @return
	 */
	public void setInspectorDao(InspectorDao inspectorDao) {
		logger.info("Setting Dependency " + inspectorDao);
		this.inspectorDao = inspectorDao;
	}
}
