package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.InspeccionesTipoDocumentoDao;
import com.ejie.y41b.model.InspeccionesTipoDocumento;
import com.ejie.y41b.model.TipoDocumento;

/**
 * InspeccionesTipoDocumentoServiceImpl  
 * 
 *  
 */

@Service(value = "inspeccionesTipoDocumentoService")
public class InspeccionesTipoDocumentoServiceImpl implements
		InspeccionesTipoDocumentoService {

	@Autowired
	private InspeccionesTipoDocumentoDao inspeccionesTipoDocumentoDao;

	/**
	 * Inserts a single row in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionesTipoDocumento
	 *            InspeccionesTipoDocumento
	 * @return InspeccionesTipoDocumento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionesTipoDocumento add(
			InspeccionesTipoDocumento inspeccionesTipoDocumento) {
		return this.inspeccionesTipoDocumentoDao.add(inspeccionesTipoDocumento);
	}

	/**
	 * Updates a single row in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionesTipoDocumento
	 *            InspeccionesTipoDocumento
	 * @return InspeccionesTipoDocumento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionesTipoDocumento update(
			InspeccionesTipoDocumento inspeccionesTipoDocumento) {
		return this.inspeccionesTipoDocumentoDao
				.update(inspeccionesTipoDocumento);
	}

	/**
	 * Finds a single row in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionesTipoDocumento
	 *            InspeccionesTipoDocumento
	 * @return InspeccionesTipoDocumento
	 */
	public InspeccionesTipoDocumento find(
			InspeccionesTipoDocumento inspeccionesTipoDocumento) {
		return (InspeccionesTipoDocumento) this.inspeccionesTipoDocumentoDao
				.find(inspeccionesTipoDocumento);
	}

	/**
	 * Finds a List of rows in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionesTipoDocumento
	 *            InspeccionesTipoDocumento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<InspeccionesTipoDocumento> findAll(
			InspeccionesTipoDocumento inspeccionesTipoDocumento,
			Pagination pagination) {
		return (List<InspeccionesTipoDocumento>) this.inspeccionesTipoDocumentoDao
				.findAll(inspeccionesTipoDocumento, pagination);
	}

	/**
	 * Finds a List of rows in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionesTipoDocumento
	 *            InspeccionesTipoDocumento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipoDocumento> findAllTipoDocumento(
			InspeccionesTipoDocumento inspeccionesTipoDocumento,
			Pagination pagination) {
		List<InspeccionesTipoDocumento> listInspeccionesTipoDocumento = (List<InspeccionesTipoDocumento>) this.inspeccionesTipoDocumentoDao
				.findAll(inspeccionesTipoDocumento, pagination);
		if (listInspeccionesTipoDocumento != null) {
			List<TipoDocumento> listTipoDocumento = new ArrayList<TipoDocumento>();
			if (listInspeccionesTipoDocumento.size() > 0) {
				TipoDocumento tipoDocumentoAux;
				for (InspeccionesTipoDocumento inspeccionesTipoDocumentoAux : listInspeccionesTipoDocumento) {
					tipoDocumentoAux = new TipoDocumento();
					tipoDocumentoAux.setIdTipodoc(inspeccionesTipoDocumentoAux
							.getIdTipodoc());
					tipoDocumentoAux.setTdnombre(inspeccionesTipoDocumentoAux
							.getTdnombre());
					tipoDocumentoAux.setTdnombree(inspeccionesTipoDocumentoAux
							.getTdnombree());
					listTipoDocumento.add(tipoDocumentoAux);
				}
			}
			return listTipoDocumento;
		} else {
			return null;
		}
	}

	/**
	 * Counts rows in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionesTipoDocumento
	 *            InspeccionesTipoDocumento
	 * @return Long
	 */
	public Long findAllCount(InspeccionesTipoDocumento inspeccionesTipoDocumento) {
		return this.inspeccionesTipoDocumentoDao
				.findAllCount(inspeccionesTipoDocumento);
	}

	/**
	 * Finds rows in the InspeccionesTipoDocumento table using like.
	 * 
	 * @param inspeccionesTipoDocumento
	 *            InspeccionesTipoDocumento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<InspeccionesTipoDocumento> findAllLike(
			InspeccionesTipoDocumento inspeccionesTipoDocumento,
			Pagination pagination, Boolean startsWith) {
		return (List<InspeccionesTipoDocumento>) this.inspeccionesTipoDocumentoDao
				.findAllLike(inspeccionesTipoDocumento, pagination, startsWith);
	}

	/**
	 * Counts rows in the InspeccionesTipoDocumento table using like.
	 * 
	 * @param inspeccionesTipoDocumento
	 *            InspeccionesTipoDocumento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(
			InspeccionesTipoDocumento inspeccionesTipoDocumento,
			Boolean startsWith) {
		return this.inspeccionesTipoDocumentoDao.findAllLikeCount(
				inspeccionesTipoDocumento, startsWith);
	}

	/**
	 * Deletes a single row in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionesTipoDocumento
	 *            InspeccionesTipoDocumento
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(InspeccionesTipoDocumento inspeccionesTipoDocumento) {
		this.inspeccionesTipoDocumentoDao.remove(inspeccionesTipoDocumento);
	}

	/**
	 * Deletes multiple rows in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionesTipoDocumentoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			List<InspeccionesTipoDocumento> inspeccionesTipoDocumentoList) {
		for (InspeccionesTipoDocumento inspeccionesTipoDocumentoAux : inspeccionesTipoDocumentoList) {
			this.inspeccionesTipoDocumentoDao
					.remove(inspeccionesTipoDocumentoAux);
		}
	}

}
