package com.ejie.y41b.service;

import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.InspeccionesPropBandejaDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.SanexprelDao;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.InspeccionesPropBandeja;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * InspeccionesPropBandejaServiceImpl  
 * 
 *  
 */

@Service(value = "inspeccionesPropBandejaService")
public class InspeccionesPropBandejaServiceImpl implements
		InspeccionesPropBandejaService {

	@Autowired()
	private InspeccionesPropBandejaDao inspeccionesPropBandejaDao;

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private InspeccionService inspeccionService;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired()
	private IntervinientesDao intervinientesDao;

	@Autowired()
	private SanexprelDao sanexprelDao;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @return InspeccionesPropBandeja
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionesPropBandeja add(
			InspeccionesPropBandeja inspeccionesPropBandeja) {
		return this.inspeccionesPropBandejaDao.add(inspeccionesPropBandeja);
	}

	/**
	 * Updates a single row in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @return InspeccionesPropBandeja
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionesPropBandeja update(
			InspeccionesPropBandeja inspeccionesPropBandeja) {
		return this.inspeccionesPropBandejaDao.update(inspeccionesPropBandeja);
	}

	/**
	 * Finds a single row in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @return InspeccionesPropBandeja
	 */
	public InspeccionesPropBandeja find(
			InspeccionesPropBandeja inspeccionesPropBandeja) {
		return (InspeccionesPropBandeja) this.inspeccionesPropBandejaDao
				.find(inspeccionesPropBandeja);
	}

	/**
	 * Finds a List of rows in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<InspeccionesPropBandeja> findAll(
			InspeccionesPropBandeja inspeccionesPropBandeja,
			Pagination pagination) {

		if (pagination != null) {
			if ("baprinsresponsable.monombre".equals(pagination.getSort())) {
				pagination.setSort("MONOMBRE");
			} else if ("baprinstipoprocedimiento.pnombre".equals(pagination
					.getSort())) {
				pagination.setSort("PNOMBRE");
			} else if ("baprinstipoprocedimiento.pnombree".equals(pagination
					.getSort())) {
				pagination.setSort("PNOMBREE");
			} else if ("baprinsestablecimiento.esnoco".equals(pagination
					.getSort())) {
				pagination.setSort("ESNOCO");
			} else if ("baprinstipoprocedimiento.pcodigo".equals(pagination
					.getSort())) {
				if (pagination.getSort() != null
						&& pagination.getAscDsc().equals("asc")) {
					pagination
							.setSort("BAPRINSEXESDENUNCIA ASC, BAPRINSPCODIGO");
				}

				if (pagination.getSort() != null
						&& pagination.getAscDsc().equals("desc")) {
					pagination
							.setSort("BAPRINSEXESDENUNCIA DESC, BAPRINSPCODIGO");
				}
			}

			if ("baprinsprovnombre".equals(pagination.getSidx())) {
				pagination.setSidx("t5.DS_O");
			} else if ("baprinsmunicnombre".equals(pagination.getSidx())) {
				pagination.setSidx("t6.DS_O");
			}
		}

		return (List<InspeccionesPropBandeja>) this.inspeccionesPropBandejaDao
				.findAll(inspeccionesPropBandeja, pagination);
	}

	/**
	 * Counts rows in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @return Long
	 */
	public Long findAllCount(InspeccionesPropBandeja inspeccionesPropBandeja) {
		return this.inspeccionesPropBandejaDao
				.findAllCount(inspeccionesPropBandeja);
	}

	/**
	 * Finds rows in the InspeccionesPropBandeja table using like.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<InspeccionesPropBandeja> findAllLike(
			InspeccionesPropBandeja inspeccionesPropBandeja,
			Pagination pagination, Boolean startsWith) {
		return (List<InspeccionesPropBandeja>) this.inspeccionesPropBandejaDao
				.findAllLike(inspeccionesPropBandeja, pagination, startsWith);
	}

	/**
	 * Counts rows in the InspeccionesPropBandeja table using like.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(
			InspeccionesPropBandeja inspeccionesPropBandeja, Boolean startsWith) {
		return this.inspeccionesPropBandejaDao.findAllLikeCount(
				inspeccionesPropBandeja, startsWith);
	}

	/**
	 * Deletes a single row in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(InspeccionesPropBandeja inspeccionesPropBandeja) {
		this.inspeccionesPropBandejaDao.remove(inspeccionesPropBandeja);
	}

	/**
	 * Genera una Propuesta de inspeccion.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return InspeccionesPropBandeja
	 */
	public InspeccionesPropBandeja generarPropuestaInspeccion(
			SolicitudDetalle solicitudDetalle, TramiteHecho tramitehecho) {
		InspeccionesPropBandeja inspeccionesPropBandeja = new InspeccionesPropBandeja();

		inspeccionesPropBandeja.setBaprinsid(Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);
		inspeccionesPropBandeja.setBaprinstipoprocedimiento(tipoProcedimiento);
		inspeccionesPropBandeja.setBaprinsexcodigo(solicitudDetalle
				.getHdcodigo());
		inspeccionesPropBandeja.setBaprinsexesdenuncia(solicitudDetalle
				.getHddenunciaaaccempresas());
		inspeccionesPropBandeja.setBaprinsfec(new Date());

		Intervinientes interviniente = new Intervinientes();
		interviniente.setEscodigo(solicitudDetalle.getEscodigo());
		interviniente.setIdExpediente(solicitudDetalle.getHdcodigo());
		interviniente
				.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO);
		interviniente = this.intervinientesDao
				.findIntervinienteEstablecimiento(interviniente);

		inspeccionesPropBandeja.setBaprinsestablecimiento(interviniente);
		if (Y41bConstantes.CODIGO_PROVINCIA_ARABA.equals(interviniente
				.getNoraProvinciaId())
				|| Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA
						.equals(interviniente.getNoraProvinciaId())
				|| Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA.equals(interviniente
						.getNoraProvinciaId())

		) {
			inspeccionesPropBandeja.setBaprinsmunic(interviniente
					.getNoraMunicipioId());
			inspeccionesPropBandeja.setBaprinsprov(interviniente
					.getNoraProvinciaId());
		}

		CensoMonitor censoMonitor = new CensoMonitor(
				solicitudDetalle.getMocodigo(), null);
		inspeccionesPropBandeja.setBaprinsresponsable(censoMonitor);

		StringBuffer numeroExpediente = new StringBuffer();
		numeroExpediente.append(solicitudDetalle.getDecoor()).append("-")
				.append(solicitudDetalle.getDenror()).append("-")
				.append(solicitudDetalle.getDenran()).append("-")
				.append(solicitudDetalle.getHdnror());
		inspeccionesPropBandeja.setBaprinsexcodcompleto(numeroExpediente
				.toString());

		inspeccionesPropBandeja.setBaprinscoor(tramitehecho
				.getEhcoorinspeccion());

		inspeccionesPropBandeja.setBaprinsinstrucinspecc(Y41bUtils
				.clobToString(tramitehecho.getEhinstrucinspecc()));

		this.add(inspeccionesPropBandeja);

		return inspeccionesPropBandeja;
	}

	/**
	 * Genera el tramite de aceptacion de inspeccion y elimina la entrada de la
	 * bandeja.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param idPropuestaInspeccion
	 *            String
	 * @param idioma
	 *            String
	 * 
	 * @return InspeccionDetalle
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionDetalle aceptarPropuestaInspeccion(
			CensoMonitor censoMonitor, String idPropuestaInspeccion,
			String idioma) throws Exception {
		// Busca la propuesta para extraer los datos.
		InspeccionesPropBandeja inspeccionesPropBandeja = new InspeccionesPropBandeja();
		inspeccionesPropBandeja.setBaprinsid(idPropuestaInspeccion);
		inspeccionesPropBandeja = this.find(inspeccionesPropBandeja);

		InspeccionDetalle inspeccionDetalle = null;
		// Genera tramite de rechazo para el tipo de expediente deseado.
		if (inspeccionesPropBandeja != null
				&& Y41bConstantes.TIPO_PROC_SOLICITUDES
						.equals(inspeccionesPropBandeja
								.getBaprinstipoprocedimiento().getPcodigo())) {
			inspeccionDetalle = this
					.generarInspeccionDesdePropuestaInspeccionSOL(
							inspeccionesPropBandeja, censoMonitor);

			Locale locale = new Locale(idioma);
			String comentarioNombreTramite = this.appMessageSource.getMessage(
					"tramite.comentarioAceptacionInspeccion", null, locale);

			TramiteGenerico tramiteGenerico = new TramiteGenerico();
			tramiteGenerico.setComentario(comentarioNombreTramite);
			tramiteGenerico.setIdExpediente(inspeccionesPropBandeja
					.getBaprinsexcodigo());
			this.soltramexpService.addTramiteGenericoAutomatico(
					tramiteGenerico, "tramite.tituloAceptacionInspeccion");

			Sanexprel sanexprelsolicitud = new Sanexprel();

			/* CREAMOS LA RELACION EN SOLICITUDES */
			/* codigo de la solicitud */
			sanexprelsolicitud.setRlhdcodigo(inspeccionesPropBandeja
					.getBaprinsexcodigo());
			/* codigo de la inspeccion */
			sanexprelsolicitud.setRlinscodrel(inspeccionDetalle.getAtcodigo());
			sanexprelsolicitud
					.setRlesorig(Y41bConstantes.TIPO_SAN_EXPREL_ORIGEN);
			this.sanexprelDao.add(sanexprelsolicitud);

			sanexprelsolicitud = new Sanexprel();

			/* CREAMOS LA RELACION EN INSPECCIONES */
			/* codigo de la inspeccion */
			sanexprelsolicitud.setRlinscodigo(inspeccionDetalle.getAtcodigo());
			/* codigo de la solicitud */
			sanexprelsolicitud.setRlhdcodrel(inspeccionesPropBandeja
					.getBaprinsexcodigo());
			sanexprelsolicitud
					.setRlesorig(Y41bConstantes.TIPO_SAN_EXPREL_ORIGEN);
			this.sanexprelDao.add(sanexprelsolicitud);
		}

		// Elimina la entrada si ha ido todo bien.
		this.remove(inspeccionesPropBandeja);

		return inspeccionDetalle;
	}

	/**
	 * Genera el tramite de rechazo de inspeccion y elimina la entrada de la
	 * bandeja.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param idPropuestaInspeccion
	 *            String
	 * @param observaciones
	 *            String
	 * @param idioma
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void rechazarPropuestaInspeccion(CensoMonitor censoMonitor,
			String idPropuestaInspeccion, String observaciones, String idioma)
			throws Exception {
		// Busca la propuesta para extraer los datos.
		InspeccionesPropBandeja inspeccionesPropBandeja = new InspeccionesPropBandeja();
		inspeccionesPropBandeja.setBaprinsid(idPropuestaInspeccion);
		inspeccionesPropBandeja = this.find(inspeccionesPropBandeja);

		// Genera tramite de rechazo para el tipo de expediente deseado.
		if (inspeccionesPropBandeja != null
				&& Y41bConstantes.TIPO_PROC_SOLICITUDES
						.equals(inspeccionesPropBandeja
								.getBaprinstipoprocedimiento().getPcodigo())) {
			TramiteGenerico tramiteGenerico = new TramiteGenerico();
			tramiteGenerico.setIdExpediente(inspeccionesPropBandeja
					.getBaprinsexcodigo());
			tramiteGenerico.setComentario(observaciones);
			this.soltramexpService.addTramiteGenericoAutomatico(
					tramiteGenerico, "tramite.tituloDenegacionInspeccion");

		}

		// Elimina la entrada si ha ido todo bien.
		this.remove(inspeccionesPropBandeja);
	}

	/**
	 * Genera el una inspeccion nueva basada en los datos de Solicitudes.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return InspeccionDetalle
	 * @throws Exception
	 *             Exception
	 */
	private InspeccionDetalle generarInspeccionDesdePropuestaInspeccionSOL(
			InspeccionesPropBandeja inspeccionesPropBandeja,
			CensoMonitor censoMonitor) throws Exception {

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(inspeccionesPropBandeja
				.getBaprinsexcodigo());

		solicitudDetalle = this.denunciaService.findSolicitud(solicitudDetalle,
				censoMonitor);

		// Genera la inspeccion.
		InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();

		inspeccionDetalle.setAccoor(censoMonitor.getOrganismo().getCodOrg());
		inspeccionDetalle.setAcfere(new Date());
		inspeccionDetalle.setAccodexpedienteorigen(solicitudDetalle
				.getHdcodigo());

		inspeccionDetalle.setAccoes(solicitudDetalle.getEscodigo());

		Establecimiento establecimientoV = new Establecimiento();
		establecimientoV.setEscodigo(inspeccionDetalle.getAccoes());

		inspeccionDetalle.setAtformanotifestablecimientore(solicitudDetalle
				.getHdformanotificacion());
		inspeccionDetalle.setAtformanotifestablecimientovi(solicitudDetalle
				.getHdformanotificacionestablecimiento());
		inspeccionDetalle.setAtidiomaestablecimientovi(solicitudDetalle
				.getHdidiomareclamado());

		inspeccionDetalle.setAtcops(solicitudDetalle.getPscodigo());
		inspeccionDetalle.setAtnoprse(solicitudDetalle.getHdnops());
		inspeccionDetalle.setAtnomaps(solicitudDetalle.getHdnomaps());
		inspeccionDetalle.setAtnomops(solicitudDetalle.getHdnomops());
		inspeccionDetalle.setAtnrlops(solicitudDetalle.getHdnrlops());
		inspeccionDetalle.setAtcodigobarras(solicitudDetalle
				.getHdcodigobarras());
		inspeccionDetalle.setAtfedumi(solicitudDetalle.getHdfedmps());

		inspeccionDetalle.setAtcohd(inspeccionesPropBandeja
				.getBaprinsexcodigo());
		inspeccionDetalle.setAtcohddenuncia(solicitudDetalle
				.getHddenunciaaaccempresas());

		inspeccionDetalle.setAdcoor(censoMonitor.getOrganismo().getCodOrg());
		inspeccionDetalle.setMocodigo(censoMonitor.getMocodigo());

		return this.inspeccionService.addInspeccion(inspeccionDetalle);
	}
}
