package com.ejie.y41b.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.InspeccionesPropBandeja;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TramiteHecho;

/**
 * InspeccionesPropBandejaService  
 * 
 *  
 */

public interface InspeccionesPropBandejaService {

	/**
	 * Inserts a single row in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @return InspeccionesPropBandeja
	 */
	InspeccionesPropBandeja add(InspeccionesPropBandeja inspeccionesPropBandeja);

	/**
	 * Updates a single row in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @return InspeccionesPropBandeja
	 */
	InspeccionesPropBandeja update(
			InspeccionesPropBandeja inspeccionesPropBandeja);

	/**
	 * Finds a single row in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @return InspeccionesPropBandeja
	 */
	InspeccionesPropBandeja find(InspeccionesPropBandeja inspeccionesPropBandeja);

	/**
	 * Finds a List of rows in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<InspeccionesPropBandeja> findAll(
			InspeccionesPropBandeja inspeccionesPropBandeja,
			Pagination pagination);

	/**
	 * Counts rows in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @return Long
	 */
	Long findAllCount(InspeccionesPropBandeja inspeccionesPropBandeja);

	/**
	 * Finds rows in the InspeccionesPropBandeja table using like.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<InspeccionesPropBandeja> findAllLike(
			InspeccionesPropBandeja inspeccionesPropBandeja,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the InspeccionesPropBandeja table using like.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(InspeccionesPropBandeja inspeccionesPropBandeja,
			Boolean startsWith);

	/**
	 * Deletes a single row in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @return
	 */
	void remove(InspeccionesPropBandeja inspeccionesPropBandeja);

	/**
	 * Genera una Propuesta de inspeccion.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param tramitehecho
	 *            TramiteHecho
	 * @return InspeccionesPropBandeja
	 */
	public InspeccionesPropBandeja generarPropuestaInspeccion(
			SolicitudDetalle solicitudDetalle, TramiteHecho tramitehecho);

	/**
	 * Genera el tramite de aceptacion de inspeccion y elimina la entrada de la
	 * bandeja.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param idPropuestaInspeccion
	 *            String
	 * @param idioma
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionDetalle aceptarPropuestaInspeccion(
			CensoMonitor censoMonitor, String idPropuestaInspeccion,
			String idioma) throws Exception;

	/**
	 * Genera el tramite de rechazo de inspeccion y elimina la entrada de la
	 * bandeja.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param idPropuestaInspeccion
	 *            String
	 * @param observaciones
	 *            String
	 * @param idioma
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void rechazarPropuestaInspeccion(CensoMonitor censoMonitor,
			String idPropuestaInspeccion, String observaciones, String idioma)
			throws Exception;
}
