// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import java.math.BigDecimal;
import java.sql.Blob;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Arrays;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActaDao;
import com.ejie.y41b.dao.ActaInfraccionDao;
import com.ejie.y41b.dao.ActaNuevaDao;
import com.ejie.y41b.dao.ActdecDao;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.AlertaDao;
import com.ejie.y41b.dao.AlertaProgramacionDao;
import com.ejie.y41b.dao.BandejaAlertaDao;
import com.ejie.y41b.dao.BandejaCampanhaDao;
import com.ejie.y41b.dao.BandejaFirmaDao;
import com.ejie.y41b.dao.BandejaInspeccionesDao;
import com.ejie.y41b.dao.CampanhaProgramacionDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.ComunicacionSoivreDao;
import com.ejie.y41b.dao.ConsumidorDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.EstablecimArbitraDao;
import com.ejie.y41b.dao.EstablecimSectorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.PlantillaDecisionDao;
import com.ejie.y41b.dao.PlantillaTramiteDao;
import com.ejie.y41b.dao.ProtocolDao;
import com.ejie.y41b.dao.SanexprelDao;
import com.ejie.y41b.dao.SedeDao;
import com.ejie.y41b.dao.T17AutonomiaDao;
import com.ejie.y41b.dao.T17ProvinciaDao;
import com.ejie.y41b.dao.TipPregProtocDao;
import com.ejie.y41b.dao.TramiteDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.ActaNueva;
import com.ejie.y41b.model.Actdec;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.AlertaProgramacion;
import com.ejie.y41b.model.BandejaAlerta;
import com.ejie.y41b.model.BandejaCampanha;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.BusquedaInspeccion;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaProgramacion;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ComunicacionSoivre;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.DetalleInfraccion;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoHechoDetalle;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.FiltroInspeccion;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Laboratorio;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteINSDecisionDetalle;
import com.ejie.y41b.model.PlantillaTramiteINSDetalle;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Protocol;
import com.ejie.y41b.model.ProtocoloInspeccion;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.T17Autonomia;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteAsignacionInstructor;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteHechoDetalleKnet;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteInspeccionDetalle;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.ActualizarMisGestiones;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.MensajeAportacionDocumentacion;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * InspeccionServiceImpl  
 * 
 *  
 */
@Service(value = "inspeccionService")
public class InspeccionServiceImpl implements InspeccionService {

	private static final Logger logger = LoggerFactory.getLogger(InspeccionServiceImpl.class);

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired()
	private ActaDao actaDao;

	@Autowired()
	private ActaService actaService;

	@Autowired()
	private ActuacionDao actuacionDao;

	@Autowired()
	private EstablecimientoDao establecimientoDao;

	@Autowired()
	private EstablecimSectorDao establecimSectorDao;

	@Autowired()
	private EstablecimArbitraDao establecimArbitraDao;

	@Autowired()
	private IntervinientesDao intervinientesDao;

	@Autowired()
	private OrganismoDao organismoDao;

	@Autowired()
	private ActdecDao actdecDao;

	@Autowired()
	private DocumentoHechoDao documentoHechoDao;

	@Autowired()
	private ActaInfraccionDao actaInfraccionDao;

	@Autowired()
	private TramiteInspeccionDao tramiteInspeccionDao;

	@Autowired()
	private ParametrosDao parametrosDao;

	@Autowired()
	private TramiteDao tramiteDao;

	@Autowired()
	private ActaNuevaDao actaNuevaDao;

	@Autowired()
	private AdjuntardocsDao adjuntardocsDao;

	@Autowired()
	private PlantillaTramiteDao plantillaTramiteDao;

	@Autowired()
	private PlantillaDecisionDao plantillaDecisionDao;

	@Autowired()
	private CensoMonitorDao censoMonitorDao;

	@Autowired()
	private TramiteInspeccionService tramiteInspeccionService;

	@Autowired()
	private InstramexpService instramexpService;

	@Autowired()
	private LaboratorioService laboratorioService;

	@Autowired()
	private ProductoService productoService;

	@Autowired()
	private T17AutonomiaDao t17AutonomiaDao;

	@Autowired()
	private T17ProvinciaDao t17ProvinciaDao;

	@Autowired
	private ConsumidorDao consumidorDao;

	@Autowired
	private BandejaInspeccionesDao bandejaInspeccionesDao;

	@Autowired
	private SanexprelDao sanexprelDao;

	@Autowired
	private ProtocolDao protocolDao;

	@Autowired()
	private BandejaFirmaDao bandejaFirmaDao;

	@Autowired()
	private AlertaDao alertaDao;

	@Autowired()
	private ComunicacionSoivreDao comunicacionSoivreDao;

	@Autowired
	private SedeDao sedeDao;

	@Autowired()
	private BandejaInspeccionesService bandejaInspeccionesService;

	@Autowired()
	private CampanhaProgramacionDao campanhaProgramacionDao;

	@Autowired()
	private BandejaCampanhaDao bandejaCampanhaDao;

	@Autowired()
	private AlertaProgramacionDao alertaProgramacionDao;

	@Autowired()
	private BandejaAlertaDao bandejaAlertaDao;

	@Autowired
	private TipPregProtocDao tipPregProtocDao;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return SolicitudDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionDetalle findNumExpedienteInspeccion(Actuacion actuacion) {
		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
				.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
				.append(insDetalle.getAtnror());

		insDetalle.setNumExpediente(numeroExpediente.toString());

		return insDetalle;
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return InspeccionDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionDetalle findNumExpedienteInspeccion(InspeccionDetalle inspeccionDetalle) {
		InspeccionDetalle insDetalle = this.actaDao.findInspeccionByNumeroExpediente(inspeccionDetalle);

		if (insDetalle != null && insDetalle.getAtcodigo() == null) {
			throw new Y41bUDAException("error.solicitud.numExpedienteException", true, new Exception());
		}

		return insDetalle;
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return InspeccionDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionDetalle findInspeccionByNumeroExpediente(InspeccionDetalle inspeccionDetalle) {
		InspeccionDetalle insDetalle = this.actaDao.findInspeccionByNumeroExpediente(inspeccionDetalle);

		return insDetalle;
	}

	/**
	 * Guardar esa informacion en el Hashmap - idTramite + Tramite
	 * 
	 * @param listTramiteInspeccionDetalle
	 *            List<TramiteInspeccionDetalle>
	 * @return Map<String, TramiteInspeccionDetalle>
	 */
	public Map<String, TramiteInspeccionDetalle> creaHashmapTramitacion(
			List<TramiteInspeccionDetalle> listTramiteInspeccionDetalle) {

		Map<String, TramiteInspeccionDetalle> mapaTramiteInspeccionDetalle = new HashMap<String, TramiteInspeccionDetalle>();

		ListIterator iter = listTramiteInspeccionDetalle.listIterator(listTramiteInspeccionDetalle.size());

		TramiteInspeccionDetalle tramiteInspeccionDetalleAux = null;

		while (iter.hasPrevious()) {
			tramiteInspeccionDetalleAux = (TramiteInspeccionDetalle) iter.previous();
			mapaTramiteInspeccionDetalle.put(tramiteInspeccionDetalleAux.getTicodigo(), tramiteInspeccionDetalleAux);
		}

		return mapaTramiteInspeccionDetalle;
	}

	/**
	 * Recupera los tramites de inspeccion
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param pagination
	 *            Pagination
	 * @return List<TramiteInspeccionDetalle>
	 */
	public List<TramiteInspeccionDetalle> findAllTramiteInspeccion(TramiteInspeccionDetalle tramiteInspeccionDetalle,
			Pagination pagination) {

		List<TramiteInspeccionDetalle> listTramiteInspeccionDetalle = this.tramiteInspeccionDao
				.findAllTramiteInspeccion(tramiteInspeccionDetalle, pagination);

		if (listTramiteInspeccionDetalle != null && listTramiteInspeccionDetalle.size() > 0) {

			Map<String, TramiteInspeccionDetalle> mapaTramiteInspeccionDetalle = new HashMap<String, TramiteInspeccionDetalle>();
			mapaTramiteInspeccionDetalle = this.creaHashmapTramitacion(listTramiteInspeccionDetalle);

			ListIterator iter = listTramiteInspeccionDetalle.listIterator(listTramiteInspeccionDetalle.size());

			TramiteInspeccionDetalle tramiteInspeccionDetalleAux = null;
			String trnombre = null;
			String trnombree = null;

			while (iter.hasPrevious()) {
				tramiteInspeccionDetalleAux = (TramiteInspeccionDetalle) iter.previous();

				// buscar los documentos del tramite
				TramiteComun tramiteComun = new TramiteComun();
				tramiteComun.setIdTramite(tramiteInspeccionDetalleAux.getTicodigo());

				List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
						null);

				// origen comunicacion notificacion
				if (Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION.equals(tramiteInspeccionDetalleAux.getTrcodigo())
						|| Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION
								.equals(tramiteInspeccionDetalleAux.getTrcodigo())) {
					tramiteInspeccionDetalleAux.setOrigenDestino(tramiteInspeccionDetalleAux.getTipoInterviniente());
				}

				// si es un tramite generico se le cambia el nombre al dado por
				// el usuario
				if (Y41bConstantes.TRAMITE_INSPECCIONES_GENERICO.equals(tramiteInspeccionDetalleAux.getTrcodigo())) {
					tramiteInspeccionDetalleAux.setTrnombre(tramiteInspeccionDetalleAux.getTinombretramite());
					tramiteInspeccionDetalleAux.setTrnombree(tramiteInspeccionDetalleAux.getTinombretramite());
				}

				// si es un tramite BOPV/BOE...
				if (tramiteInspeccionDetalleAux.getTifechaEnvioBOPVBOE() != null) {
					if (!tramiteInspeccionDetalleAux.getTiestadotramite()
							.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
						StringBuffer sbTrnombre = new StringBuffer();
						sbTrnombre.append(tramiteInspeccionDetalleAux.getTrnombre());
						sbTrnombre.append(" (");
						sbTrnombre.append(Y41bUtils.parseDateToString(
								tramiteInspeccionDetalleAux.getTifechaEnvioBOPVBOE(), Y41bConstantes.CASTELLANO));
						sbTrnombre.append(")");

						StringBuffer sbTrnombree = new StringBuffer();
						sbTrnombree.append(tramiteInspeccionDetalleAux.getTrnombree());
						sbTrnombree.append(" (");
						sbTrnombree.append(Y41bUtils.parseDateToString(
								tramiteInspeccionDetalleAux.getTifechaEnvioBOPVBOE(), Y41bConstantes.EUSKERA));
						sbTrnombree.append(")");

						tramiteInspeccionDetalleAux.setTrnombre(sbTrnombre.toString());
						tramiteInspeccionDetalleAux.setTrnombree(sbTrnombree.toString());
					}
				}

				// si tiene un solo documento uno meterlo en el objeto
				if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
					tramiteInspeccionDetalleAux.setIndVariosDocumentos(Y41bConstantes.NO);

					tramiteInspeccionDetalleAux.setQ5codocumento(listDocumentoHecho.get(0).getQ5codocumento());
					tramiteInspeccionDetalleAux.setQ5nofile(listDocumentoHecho.get(0).getQ5nofile());
					tramiteInspeccionDetalleAux.setQ5sizefile(listDocumentoHecho.get(0).getQ5sizefile());
					tramiteInspeccionDetalleAux.setQ5contenttypefile(listDocumentoHecho.get(0).getQ5contenttypefile());
					tramiteInspeccionDetalleAux.setQ5tedesfile(listDocumentoHecho.get(0).getQ5tedesfile());

					if (Y41bConstantes.TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION
							.equals(tramiteInspeccionDetalleAux.getTrcodigo())) {
						tramiteInspeccionDetalleAux.setOrigenDestino(listDocumentoHecho.get(0).getQ5origen());
					}
				} else {
					if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
						// si tiene mas de un documento
						tramiteInspeccionDetalleAux.setIndVariosDocumentos(Y41bConstantes.SI);
					}

					if (Y41bConstantes.TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION
							.equals(tramiteInspeccionDetalleAux.getTrcodigo())) {
						int responsable = 0;
						int visitado = 0;
						int repVisitado = 0;
						int repResponsable = 0;
						int administracion = 0;
						int otros = 0;
						for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
							if (documentoHechoAux.getQ5origen()
									.equals(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE)) {
								responsable++;
							} else if (documentoHechoAux.getQ5origen()
									.equals(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO)) {
								visitado++;
							} else if (documentoHechoAux.getQ5origen()
									.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO)) {
								repVisitado++;
							} else if (documentoHechoAux.getQ5origen()
									.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE)) {
								repResponsable++;
							} else if (documentoHechoAux.getQ5origen()
									.equals(Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION)) {
								administracion++;
							} else if (documentoHechoAux.getQ5origen()
									.equals(Y41bConstantes.ORIGEN_INS_APORTADO_OTROS)) {
								otros++;
							}

						}
						if (responsable == listDocumentoHecho.size()) {
							tramiteInspeccionDetalleAux
									.setOrigenDestino(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE);
						} else if (visitado == listDocumentoHecho.size()) {
							tramiteInspeccionDetalleAux.setOrigenDestino(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO);
						} else if (repVisitado == listDocumentoHecho.size()) {
							tramiteInspeccionDetalleAux
									.setOrigenDestino(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO);
						} else if (repResponsable == listDocumentoHecho.size()) {
							tramiteInspeccionDetalleAux
									.setOrigenDestino(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE);
						} else if (administracion == listDocumentoHecho.size()) {
							tramiteInspeccionDetalleAux
									.setOrigenDestino(Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION);
						} else if (otros == listDocumentoHecho.size()) {
							tramiteInspeccionDetalleAux.setOrigenDestino(Y41bConstantes.ORIGEN_INS_APORTADO_OTROS);
						} else {
							tramiteInspeccionDetalleAux.setOrigenDestino(Y41bConstantes.NO);
						}

					}

				}
				if (listDocumentoHecho != null) {
					Parametros parametros = new Parametros();

					parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
					parametros = this.parametrosDao.find(parametros);

					for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
						if (documentoHechoAux.getQ5fechasollocalizador() != null
								&& !tramiteInspeccionDetalleAux.getTiestadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !tramiteInspeccionDetalleAux.getTiestadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !tramiteInspeccionDetalleAux.getTiestadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
							if (documentoHechoAux != null && documentoHechoAux.getQ5nofile() != null
									&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(documentoHechoAux.getQ5nofile())
											.equalsIgnoreCase(Y41bConstantes.PDF)) {

								int minutos = 0;
								if (parametros != null && parametros.getValor() != null
										&& Y41bUtils.isNumeric(parametros.getValor())) {
									minutos = Integer.parseInt(parametros.getValor());
								}

								SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

								Date d1 = null;
								Date d2 = null;
								long diffMinutes = 0;
								try {
									d1 = format.parse(format.format(documentoHechoAux.getQ5fechasollocalizador()));

									d2 = format.parse(format.format(new Date()));

									long diff = d2.getTime() - d1.getTime();

									diffMinutes = diff / (60 * 1000);
								} catch (ParseException e) {
									diffMinutes = 0;
								}

								if (diffMinutes > minutos) {
									tramiteInspeccionDetalleAux
											.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
								} else {
									tramiteInspeccionDetalleAux
											.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
								}
							} else {
								if (tramiteInspeccionDetalleAux.getTiestadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
									tramiteInspeccionDetalleAux
											.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
								} else if (!tramiteInspeccionDetalleAux.getTiestadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
										&& !tramiteInspeccionDetalleAux.getTiestadotramite()
												.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
										&& !tramiteInspeccionDetalleAux.getTiestadotramite()
												.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
										&& !tramiteInspeccionDetalleAux.getTiestadotramite()
												.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
										&& !tramiteInspeccionDetalleAux.getTiestadotramite()
												.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
									tramiteInspeccionDetalleAux
											.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
								}
							}
						}
					}
				}

				if (listTramiteInspeccionDetalle != null) {
					// fase de los valores del hashmap
					tramiteInspeccionDetalleAux.setFnombre(
							(mapaTramiteInspeccionDetalle.get(tramiteInspeccionDetalleAux.getTicodigo())).getFnombre());
					tramiteInspeccionDetalleAux
							.setFnombree((mapaTramiteInspeccionDetalle.get(tramiteInspeccionDetalleAux.getTicodigo()))
									.getFnombree());
				} else {
					tramiteInspeccionDetalleAux.setFnombre("");
					tramiteInspeccionDetalleAux.setFnombree("");

				}

				if (tramiteInspeccionDetalleAux.getTrnombre() == null
						|| tramiteInspeccionDetalleAux.getTrnombre().equals("")) {
					try {
						Tramite tramiteAux = new Tramite();
						tramiteAux.setTrcodigo(tramiteInspeccionDetalleAux.getTrcodigo());
						tramiteAux = this.tramiteDao.findTramiteKontsumoGest(tramiteAux);
						trnombre = tramiteAux.getTrnombre();
						trnombree = tramiteAux.getTrnombree();

						tramiteInspeccionDetalleAux.setTrnombre(trnombre);
						tramiteInspeccionDetalleAux.setTrnombree(trnombree);
					} catch (Exception e) {
					}
				}

				if (tramiteInspeccionDetalleAux.getTifechaEnvioBOPVBOE() != null) {
					if (!tramiteInspeccionDetalleAux.getTiestadotramite()
							.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
						StringBuffer sbTrnombre = new StringBuffer();
						sbTrnombre.append(tramiteInspeccionDetalleAux.getTrnombre());
						sbTrnombre.append(" (");
						sbTrnombre.append(Y41bUtils.parseDateToString(
								tramiteInspeccionDetalleAux.getTifechaEnvioBOPVBOE(), Y41bConstantes.CASTELLANO));
						sbTrnombre.append(")");

						StringBuffer sbTrnombree = new StringBuffer();
						sbTrnombree.append(tramiteInspeccionDetalleAux.getTrnombree());
						sbTrnombree.append(" (");
						sbTrnombree.append(Y41bUtils.parseDateToString(
								tramiteInspeccionDetalleAux.getTifechaEnvioBOPVBOE(), Y41bConstantes.EUSKERA));
						sbTrnombree.append(")");

						tramiteInspeccionDetalleAux.setTrnombre(sbTrnombre.toString());
						tramiteInspeccionDetalleAux.setTrnombree(sbTrnombree.toString());
					}
				}

				if (tramiteInspeccionDetalleAux.getTiistelematico() != null) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(tramiteInspeccionDetalleAux.getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(appMessageSource.getMessage("comun.telematico", null,
							new Locale(Y41bConstantes.CASTELLANO)));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(tramiteInspeccionDetalleAux.getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree.append(
							appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
					sbTrnombree.append(")");

					tramiteInspeccionDetalleAux.setTrnombre(sbTrnombre.toString());
					tramiteInspeccionDetalleAux.setTrnombree(sbTrnombree.toString());
				}
				// SIR

				// solo se mostrara coletilla sir si
				if ((tramiteInspeccionDetalleAux.getTiissir() != null
						&& tramiteInspeccionDetalleAux.getTiissir().equalsIgnoreCase(Y41bConstantes.VALOR_SI)
						&& !(tramiteInspeccionDetalleAux.getTiissirconnumregentori() != null))
						|| (tramiteInspeccionDetalleAux.getTiissir() != null
								&& tramiteInspeccionDetalleAux.getTiissir().equalsIgnoreCase(Y41bConstantes.VALOR_SI)
								&& tramiteInspeccionDetalleAux.getTiissirconnumregentori() != null
								&& tramiteInspeccionDetalleAux.getTiissirconnumregentori()
										.equalsIgnoreCase(Y41bConstantes.VALOR_SI))) {

					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(tramiteInspeccionDetalleAux.getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(
							appMessageSource.getMessage("comun.sir", null, new Locale(Y41bConstantes.CASTELLANO)));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(tramiteInspeccionDetalleAux.getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree
							.append(appMessageSource.getMessage("comun.sir", null, new Locale(Y41bConstantes.EUSKERA)));
					sbTrnombree.append(")");

					tramiteInspeccionDetalleAux.setTrnombre(sbTrnombre.toString());
					tramiteInspeccionDetalleAux.setTrnombree(sbTrnombree.toString());
				}
			}
		}

		return listTramiteInspeccionDetalle;
	}

	/**
	 * Busqueda para montar el hashmap - siempre ordenado por fecha y hora desc
	 * Al que se le aade el calculo de la fase para los tramites sin fase -
	 * calculo ok con ese orden
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return List<TramiteInspeccionDetalle>
	 */
	// TODO: Eliminar????
	public List<TramiteInspeccionDetalle> findAllTramiteInspeccionHash(
			TramiteInspeccionDetalle tramiteInspeccionDetalle) {

		Pagination pagination = new Pagination();

		// pagination.setSort("EHFECHA DESC, EHHORA");
		// pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);

		List<TramiteInspeccionDetalle> listTramiteInspeccionDetalle = this.tramiteInspeccionDao
				.findAllTramiteInspeccion(tramiteInspeccionDetalle, pagination);

		if (listTramiteInspeccionDetalle != null && listTramiteInspeccionDetalle.size() > 0) {
			ListIterator iter = listTramiteInspeccionDetalle.listIterator(listTramiteInspeccionDetalle.size());

			TramiteInspeccionDetalle tramiteInspeccionDetalleAux = null;
			String fnombre = null;
			String fnombree = null;

			while (iter.hasPrevious()) {
				tramiteInspeccionDetalleAux = (TramiteInspeccionDetalle) iter.previous();

				if (tramiteInspeccionDetalleAux.getFnombre() == null
						|| tramiteInspeccionDetalleAux.getFnombre().equals("")) {

					if (fnombre == null || fnombre.equals("")) {
						try {
							TramiteInspeccionDetalle tramInspeccionDetalleAux = new TramiteInspeccionDetalle();
							tramInspeccionDetalleAux.setTicodigo(tramiteInspeccionDetalleAux.getTicodigo());
							tramInspeccionDetalleAux.setAtcodigo(tramiteInspeccionDetalleAux.getAtcodigo());

							tramInspeccionDetalleAux = this.tramiteInspeccionDao
									.findUltimaFase(tramInspeccionDetalleAux);
							fnombre = tramInspeccionDetalleAux.getFnombre();
							fnombree = tramInspeccionDetalleAux.getFnombree();

							tramiteInspeccionDetalleAux.setFnombre(fnombre);
							tramiteInspeccionDetalleAux.setFnombree(fnombree);
						} catch (Exception e) {
						}
					} else {
						tramiteInspeccionDetalleAux.setFnombre(fnombre);
						tramiteInspeccionDetalleAux.setFnombree(fnombree);
					}
				} else {
					fnombre = tramiteInspeccionDetalleAux.getFnombre();
					fnombree = tramiteInspeccionDetalleAux.getFnombree();
				}
			}
		}
		return listTramiteInspeccionDetalle;
	}

	/**
	 * Recupera los tramites de inspeccion
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	public Long findAllTramiteInspeccionCount(TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		return this.tramiteInspeccionDao.findAllTramiteInspeccionCount(tramiteInspeccionDetalle);
	}

	/**
	 * Finds a single row in the tramiteinspeccion table.
	 * 
	 * @param tramiteHechoDetalleKnet
	 *            TramiteHechoDetalleKnet
	 * @return TramiteHechoDetalleKnet
	 */
	public TramiteHechoDetalleKnet findTramiteHecho(TramiteHechoDetalleKnet tramiteHechoDetalleKnet) {
		tramiteHechoDetalleKnet = this.tramiteInspeccionDao.findTramiteHecho(tramiteHechoDetalleKnet);
		return tramiteHechoDetalleKnet;
	}

	/**
	 * Aniade una nueva inspeccion.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return inspeccionDetalle InspeccionDetalle
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionDetalle addInspeccion(InspeccionDetalle inspeccionDetalle) throws Exception {

		Acta acta = new Acta();

		acta.setAccodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		acta.setAccoor(inspeccionDetalle.getAccoor());

		acta.setAcfere(inspeccionDetalle.getAcfere());

		acta.setAccodexpedienteorigen(inspeccionDetalle.getAccodexpedienteorigen());
		acta.setAccoororigen(inspeccionDetalle.getAccoororigen());
		acta.setActiororigen(inspeccionDetalle.getActiororigen());
		acta.setAcincumplimiento(inspeccionDetalle.getAcincumplimiento());

		Establecimiento establecimientoV = new Establecimiento();
		establecimientoV.setEscodigo(inspeccionDetalle.getAccoes());

		Establecimiento establecimientoR = new Establecimiento();
		establecimientoR.setEscodigo(inspeccionDetalle.getAtcoes());
		// acta.setAccoes(inspeccionDetalle.getAtcoes());
		acta.setAccoes(inspeccionDetalle.getAccoes());

		Calendar now = Calendar.getInstance();
		int year = now.get(Calendar.YEAR);
		acta.setAcnran(new BigDecimal(year));

		acta.setAcnror(Y41bConstantes.INSPECCIONES_NUM_EXPEDIENTE_INICIAL);

		// acta.setAcnror(String.valueOf(this.actaDao.getNextAcnror(acta)));

		inspeccionDetalle.setAcnran(acta.getAcnran());
		inspeccionDetalle.setAcnror(acta.getAcnror());
		inspeccionDetalle.setAtnror("1");

		// Da de alta acta
		this.actaDao.add(acta);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		inspeccionDetalle.setAtcodigo(actuacion.getAtcodigo());

		actuacion.setAtcoes(inspeccionDetalle.getAtcoes());
		actuacion.setAtformanotifestablecimientore(inspeccionDetalle.getAtformanotifestablecimientore());
		actuacion.setAtformanotifestablecimientovi(inspeccionDetalle.getAtformanotifestablecimientovi());
		actuacion.setAtidiomaestablecimientovi(inspeccionDetalle.getAtidiomaestablecimientovi());
		actuacion.setIskontsumobide(Y41bConstantes.SI);

		actuacion.setAtonline(inspeccionDetalle.getAtonline());

		// unidades

		actuacion.setAtudestruidas(new BigDecimal(0));
		actuacion.setAtudevolucionorigen(new BigDecimal(0));
		actuacion.setAtuexistentes(new BigDecimal(0));
		actuacion.setAtuinmovilizadas(new BigDecimal(0));
		actuacion.setAtulibrecomercializacion(new BigDecimal(0));
		actuacion.setAtuotros(new BigDecimal(0));
		actuacion.setAtutomamuestras(new BigDecimal(0));

		actuacion.setAtcoac(acta.getAccodigo());

		actuacion.setAtcops(inspeccionDetalle.getAtcops());
		actuacion.setAtnoprse(inspeccionDetalle.getAtnoprse());
		actuacion.setAtnomaps(inspeccionDetalle.getAtnomaps());
		actuacion.setAtnomops(inspeccionDetalle.getAtnomops());
		actuacion.setAtnrlops(inspeccionDetalle.getAtnrlops());
		actuacion.setAtcodigobarras(inspeccionDetalle.getAtcodigobarras());
		actuacion.setAtfedumi(inspeccionDetalle.getAtfedumi());

		actuacion.setAtnror(new BigDecimal(1));
		actuacion.setAtcohd(inspeccionDetalle.getAtcohd());
		actuacion.setAtcohd(inspeccionDetalle.getAtcohd());
		actuacion.setAtcohddenuncia(inspeccionDetalle.getAtcohddenuncia());
		actuacion.setAtcocm(inspeccionDetalle.getAtcocm());
		actuacion.setAtcoal(inspeccionDetalle.getAtcoal());
		actuacion.setAtidcomunicacionsoivre(inspeccionDetalle.getAtidcomunicacionsoivre());

		actuacion.setAtfefin(inspeccionDetalle.getAtfefin());
		actuacion.setAtcopg(inspeccionDetalle.getAtcopg());
		actuacion.setAttipo(inspeccionDetalle.getAttipo());
		actuacion.setAtadicional(inspeccionDetalle.getAtadicional());
		actuacion.setAtcocr(inspeccionDetalle.getAtcocr());
		actuacion.setAtacuerdoinicio(inspeccionDetalle.getAtacuerdoinicio());
		actuacion.setAtdestnotificavisitado(inspeccionDetalle.getAtdestnotificavisitado());
		actuacion.setAtdestnotificaresponsable(inspeccionDetalle.getAtdestnotificaresponsable());

		// Da de alta actuacion
		this.actuacionDao.add(actuacion);

		// Si la inspeccion es una notificacion de productores o comunicacion
		// externa.
		if (Y41bConstantes.INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES.equals(inspeccionDetalle.getActiororigen())
				|| Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA.equals(inspeccionDetalle.getActiororigen())) {
			// Buscar si tiene el organismo introducido como interviniente.
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ORGANISMO_PRODUCTOR);

			Organismo organismo = new Organismo();
			organismo.setCodOrg(inspeccionDetalle.getAccoororigen());
			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

			// Alta como interviniente del organismo.
			Intervinientes intervinientesAux = new Intervinientes(
					Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, null,
					organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(), null,
					null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null, organismo.getEmail(),
					esExtranjero, organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
					organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(),
					organismo.getNombreLocalidad(), organismo.getNoraCalleId(), organismo.getNombreCalle(),
					organismo.getNoraCpId(), organismo.getNombreCp(), organismo.getNoraPortalId(),
					organismo.getNombrePortal(), organismo.getCompleDirec(), organismo.getNoraPaisId(),
					organismo.getNombrePais(), organismo.getNombreCalle(), null, null, null, null, null,
					Y41bConstantes.TIPO_INTERVINIENTE_ORGANISMO_PRODUCTOR, actuacion.getAtcodigo(), null, null, null,
					null);

			this.intervinientesDao.add(intervinientesAux);
		}

		Intervinientes intervinientes = null;
		if (inspeccionDetalle.getAccoes() != null && !inspeccionDetalle.getAccoes().equals("")) {
			// Alta interviniente establecimiento
			establecimientoV = this.establecimientoDao.find(establecimientoV);

			establecimientoV = this.tratamientoAnadirIntervinienteEstablecimiento(establecimientoV);

			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimientoV);

			EstablecimSector establecSector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimientoV.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
				if (establecimArbitra != null) {
					if ("A".equals(establecimientoV.getEsinadar())) {
						if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
							establecimientoV.setEsinadar("L");
						}
					}
				}
			} catch (Exception e) {

			}

			intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					establecimientoV.getEscodigo(), null, establecimientoV.getEsnombre(), null, null,
					establecimientoV.getEsnoco(), null, establecimientoV.getEsnif(), null, null,
					establecimientoV.getEscoidco(), establecimientoV.getEsteurl(), establecimientoV.getEsnopeco(),
					establecimientoV.getEsfeba(), establecimientoV.getEsnrtel(), establecimientoV.getEsnrtel2(),
					establecimientoV.getEscoem(), establecimientoV.getEsextranjero(),
					establecimientoV.getEsnoraProvinciaId(), establecimientoV.getEsnombreProvincia(),
					establecimientoV.getEsnoraMunicipioId(), establecimientoV.getEsnombreMunicipio(),
					establecimientoV.getEsnoraLocalidadId(), establecimientoV.getEsnombreLocalidad(),
					establecimientoV.getEsnoraCalleId(), establecimientoV.getEsnombreCalle(),
					establecimientoV.getEsnoraCpId(), establecimientoV.getEsnombreCp(),
					establecimientoV.getEsnoraPortalId(), establecimientoV.getEsnombrePortal(),
					establecimientoV.getEsnombrePiso(), establecimientoV.getEsnoraPaisId(),
					establecimientoV.getEsnoraPaisNombre(), establecimientoV.getEsdireccion_nocapv(), null,
					establecimientoV.getEsinadar(), establecSector.getSector().getSecodigo(),
					establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
					Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO, actuacion.getAtcodigo(), null,
					establecimientoV.getEsfemod(), establecimientoV.getCensoMonitor().getMocodigo(),
					establecimientoV.getCensoMonitor().getUsuarioxlnet());

			this.intervinientesDao.add(intervinientes);
			this.actuacionDao.updateATIDPARTICIPACIONVISITADO(intervinientes);
		}

		if (inspeccionDetalle.getAtcoes() != null && !inspeccionDetalle.getAtcoes().equals("")) {
			// Alta interviniente establecimiento
			establecimientoR = this.establecimientoDao.find(establecimientoR);

			establecimientoR = this.tratamientoAnadirIntervinienteEstablecimiento(establecimientoR);

			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimientoR);

			EstablecimSector establecSector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimientoR.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
				if (establecimArbitra != null) {
					if ("A".equals(establecimientoR.getEsinadar())) {
						if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
							establecimientoR.setEsinadar("L");
						}
					}
				}
			} catch (Exception e) {

			}

			intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					establecimientoR.getEscodigo(), null, establecimientoR.getEsnombre(), null, null,
					establecimientoR.getEsnoco(), null, establecimientoR.getEsnif(), null, null,
					establecimientoR.getEscoidco(), establecimientoR.getEsteurl(), establecimientoR.getEsnopeco(),
					establecimientoR.getEsfeba(), establecimientoR.getEsnrtel(), establecimientoR.getEsnrtel2(),
					establecimientoR.getEscoem(), establecimientoR.getEsextranjero(),
					establecimientoR.getEsnoraProvinciaId(), establecimientoR.getEsnombreProvincia(),
					establecimientoR.getEsnoraMunicipioId(), establecimientoR.getEsnombreMunicipio(),
					establecimientoR.getEsnoraLocalidadId(), establecimientoR.getEsnombreLocalidad(),
					establecimientoR.getEsnoraCalleId(), establecimientoR.getEsnombreCalle(),
					establecimientoR.getEsnoraCpId(), establecimientoR.getEsnombreCp(),
					establecimientoR.getEsnoraPortalId(), establecimientoR.getEsnombrePortal(),
					establecimientoR.getEsnombrePiso(), establecimientoR.getEsnoraPaisId(),
					establecimientoR.getEsnoraPaisNombre(), establecimientoR.getEsdireccion_nocapv(), null,
					establecimientoR.getEsinadar(), establecSector.getSector().getSecodigo(),
					establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
					Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE, actuacion.getAtcodigo(), null,
					establecimientoR.getEsfemod(), establecimientoR.getCensoMonitor().getMocodigo(),
					establecimientoR.getCensoMonitor().getUsuarioxlnet());

			this.intervinientesDao.add(intervinientes);
			this.actuacionDao.updateATIDPARTICIPACIONRESPONSABLE(intervinientes);
		}

		// Al grabar la pestaa de inspeccin en una inspeccin de una
		// campaa on-line, se validar que el campo Web de la Web visitada
		// tenga valor
		if ((inspeccionDetalle.getAtcocm() != null && inspeccionDetalle.getCmonline() != null
				&& inspeccionDetalle.getCmonline().equals(Y41bConstantes.VALOR_SI))
				|| (inspeccionDetalle.getAtonline() != null
						&& inspeccionDetalle.getAtonline().equals(Y41bConstantes.VALOR_SI))) {
			intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

			List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);
			if (listIntervinientes.size() > 0) {
				intervinientes = listIntervinientes.get(0);

				if (intervinientes != null && !Y41bUtils.isFilled(intervinientes.getEsteurl())) {
					throw new Y41bUDAException("error.inspeccion.webWebvisitadaException", true, new Exception());
				}
			}
		}

		// Alta interviniente administrador
		Organismo organismo = new Organismo();
		organismo.setCodOrg(inspeccionDetalle.getAdcoor());

		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

		String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

		intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
				null, organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(),
				null, null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null, organismo.getEmail(),
				esExtranjero, organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
				organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(),
				organismo.getNombreLocalidad(), organismo.getNoraCalleId(), organismo.getNombreCalle(),
				organismo.getNoraCpId(), organismo.getNombreCp(), organismo.getNoraPortalId(),
				organismo.getNombrePortal(), organismo.getCompleDirec(), organismo.getNoraPaisId(),
				organismo.getNombrePais(), organismo.getNombreCalle(), null, null, null, null, null,
				Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION, actuacion.getAtcodigo(), null, null, null, null);

		this.intervinientesDao.add(intervinientes);

		Actdec actdec = new Actdec(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
				actuacion.getAtcodigo(), inspeccionDetalle.getAdcoor(), null, null, null);

		// Da de alta una decision vacia
		this.actdecDao.add(actdec);

		// Genera el tramite de Apertura y asignacion de expediente sin
		// tramitar.
		TramiteAsignacionInstructor tramiteAsignacionInstructor = new TramiteAsignacionInstructor();
		tramiteAsignacionInstructor.setFechaInicio(new Date());

		// Coordinador
		CensoMonitor censoMonitorCoordinador = new CensoMonitor();
		try {
			organismo = new Organismo();
			organismo.setCodOrg(inspeccionDetalle.getAdcoor());

			censoMonitorCoordinador.setOrganismo(organismo);

			censoMonitorCoordinador = this.censoMonitorDao.findCoordinadorInspecciones(censoMonitorCoordinador);
		} catch (Exception e) {
			censoMonitorCoordinador = new CensoMonitor();
		}

		tramiteAsignacionInstructor.setInstructorAsignado(censoMonitorCoordinador);
		tramiteAsignacionInstructor.setInstructorExpediente(censoMonitorCoordinador);

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteComun.setIdExpediente(actuacion.getAtcodigo());
		this.instramexpService.addTramiteAsignacionInstructor(tramiteAsignacionInstructor, tramiteComun, false,
				Y41bConstantes.MODO_POPUP_ALTA);

		return inspeccionDetalle;
	}

	/**
	 * Aniade una nueva inspeccion.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return inspeccionDetalle InspeccionDetalle
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionDetalle addInspeccionMasiva(InspeccionDetalle inspeccionDetalle) throws Exception {

		logger.debug("####################################################INICIO addInspeccionMasiva");
		Acta acta = new Acta();

		acta.setAccodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		acta.setAccoor(inspeccionDetalle.getAccoor());

		acta.setAcfere(inspeccionDetalle.getAcfere());

		Establecimiento establecimientoV = new Establecimiento();
		establecimientoV.setEscodigo(inspeccionDetalle.getAccoes());

		Establecimiento establecimientoR = new Establecimiento();
		establecimientoR.setEscodigo(inspeccionDetalle.getAtcoes());
		acta.setAccoes(inspeccionDetalle.getAccoes());

		Calendar now = Calendar.getInstance();
		int year = now.get(Calendar.YEAR);
		acta.setAcnran(new BigDecimal(year));

		acta.setAcnror(Y41bConstantes.INSPECCIONES_NUM_EXPEDIENTE_INICIAL);

		inspeccionDetalle.setAcnran(acta.getAcnran());
		inspeccionDetalle.setAcnror(acta.getAcnror());
		inspeccionDetalle.setAtnror("1");

		// Da de alta acta
		this.actaDao.addMasiva(acta);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		inspeccionDetalle.setAtcodigo(actuacion.getAtcodigo());

		actuacion.setAtcoes(inspeccionDetalle.getAtcoes());
		actuacion.setAtformanotifestablecimientore(inspeccionDetalle.getAtformanotifestablecimientore());
		actuacion.setAtformanotifestablecimientovi(inspeccionDetalle.getAtformanotifestablecimientovi());
		actuacion.setAtidiomaestablecimientovi(inspeccionDetalle.getAtidiomaestablecimientovi());
		actuacion.setIskontsumobide(Y41bConstantes.SI);

		actuacion.setAtcoac(acta.getAccodigo());
		actuacion.setAtcops(inspeccionDetalle.getAtcops());
		actuacion.setAtnoprse(inspeccionDetalle.getAtnoprse());
		actuacion.setAtnomaps(inspeccionDetalle.getAtnomaps());
		actuacion.setAtnomops(inspeccionDetalle.getAtnomops());
		actuacion.setAtnrlops(inspeccionDetalle.getAtnrlops());
		actuacion.setAtcodigobarras(inspeccionDetalle.getAtcodigobarras());
		actuacion.setAtfedumi(inspeccionDetalle.getAtfedumi());

		actuacion.setAtnror(new BigDecimal(1));
		actuacion.setAtcohd(inspeccionDetalle.getAtcohd());
		actuacion.setAtcohddenuncia(inspeccionDetalle.getAtcohddenuncia());
		actuacion.setAtcocm(inspeccionDetalle.getAtcocm());
		actuacion.setAtcoal(inspeccionDetalle.getAtcoal());
		actuacion.setAtidcomunicacionsoivre(inspeccionDetalle.getAtidcomunicacionsoivre());

		actuacion.setAtfefin(inspeccionDetalle.getAtfefin());
		actuacion.setAtcopg(inspeccionDetalle.getAtcopg());
		actuacion.setAttipo(inspeccionDetalle.getAttipo());
		actuacion.setAtadicional(inspeccionDetalle.getAtadicional());
		actuacion.setAtcocr(inspeccionDetalle.getAtcocr());
		actuacion.setAtacuerdoinicio(inspeccionDetalle.getAtacuerdoinicio());
		actuacion.setAtdestnotificavisitado(inspeccionDetalle.getAtdestnotificavisitado());
		actuacion.setAtdestnotificaresponsable(inspeccionDetalle.getAtdestnotificaresponsable());

		actuacion.setAtinspeccionsolicitada(inspeccionDetalle.getAtinspeccionsolicitada());

		// Da de alta actuacion
		this.actuacionDao.addMasiva(actuacion);

		Intervinientes intervinientes = null;
		if (inspeccionDetalle.getAccoes() != null && !inspeccionDetalle.getAccoes().equals("")) {
			// Alta interviniente establecimiento
			establecimientoV = this.establecimientoDao.find(establecimientoV);

			establecimientoV = this.tratamientoAnadirIntervinienteEstablecimiento(establecimientoV);

			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimientoV);

			EstablecimSector establecSector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimientoV.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
				if (establecimArbitra != null) {
					if ("A".equals(establecimientoV.getEsinadar())) {
						if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
							establecimientoV.setEsinadar("L");
						}
					}
				}
			} catch (Exception e) {

			}

			intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					establecimientoV.getEscodigo(), null, establecimientoV.getEsnombre(), null, null,
					establecimientoV.getEsnoco(), null, establecimientoV.getEsnif(), null, null,
					establecimientoV.getEscoidco(), establecimientoV.getEsteurl(), establecimientoV.getEsnopeco(),
					establecimientoV.getEsfeba(), establecimientoV.getEsnrtel(), establecimientoV.getEsnrtel2(),
					establecimientoV.getEscoem(), establecimientoV.getEsextranjero(),
					establecimientoV.getEsnoraProvinciaId(), establecimientoV.getEsnombreProvincia(),
					establecimientoV.getEsnoraMunicipioId(), establecimientoV.getEsnombreMunicipio(),
					establecimientoV.getEsnoraLocalidadId(), establecimientoV.getEsnombreLocalidad(),
					establecimientoV.getEsnoraCalleId(), establecimientoV.getEsnombreCalle(),
					establecimientoV.getEsnoraCpId(), establecimientoV.getEsnombreCp(),
					establecimientoV.getEsnoraPortalId(), establecimientoV.getEsnombrePortal(),
					establecimientoV.getEsnombrePiso(), establecimientoV.getEsnoraPaisId(),
					establecimientoV.getEsnoraPaisNombre(), establecimientoV.getEsdireccion_nocapv(), null,
					establecimientoV.getEsinadar(), establecSector.getSector().getSecodigo(),
					establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
					Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO, actuacion.getAtcodigo(), null,
					establecimientoV.getEsfemod(), establecimientoV.getCensoMonitor().getMocodigo(),
					establecimientoV.getCensoMonitor().getUsuarioxlnet());

			this.intervinientesDao.add(intervinientes);
			this.actuacionDao.updateATIDPARTICIPACIONVISITADO(intervinientes);
		}

		if (inspeccionDetalle.getAtcoes() != null && !inspeccionDetalle.getAtcoes().equals("")) {
			// Alta interviniente establecimiento
			establecimientoR = this.establecimientoDao.find(establecimientoR);

			establecimientoR = this.tratamientoAnadirIntervinienteEstablecimiento(establecimientoR);

			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimientoR);

			EstablecimSector establecSector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimientoR.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
				if (establecimArbitra != null) {
					if ("A".equals(establecimientoR.getEsinadar())) {
						if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
							establecimientoR.setEsinadar("L");
						}
					}
				}
			} catch (Exception e) {

			}

			intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
					establecimientoR.getEscodigo(), null, establecimientoR.getEsnombre(), null, null,
					establecimientoR.getEsnoco(), null, establecimientoR.getEsnif(), null, null,
					establecimientoR.getEscoidco(), establecimientoR.getEsteurl(), establecimientoR.getEsnopeco(),
					establecimientoR.getEsfeba(), establecimientoR.getEsnrtel(), establecimientoR.getEsnrtel2(),
					establecimientoR.getEscoem(), establecimientoR.getEsextranjero(),
					establecimientoR.getEsnoraProvinciaId(), establecimientoR.getEsnombreProvincia(),
					establecimientoR.getEsnoraMunicipioId(), establecimientoR.getEsnombreMunicipio(),
					establecimientoR.getEsnoraLocalidadId(), establecimientoR.getEsnombreLocalidad(),
					establecimientoR.getEsnoraCalleId(), establecimientoR.getEsnombreCalle(),
					establecimientoR.getEsnoraCpId(), establecimientoR.getEsnombreCp(),
					establecimientoR.getEsnoraPortalId(), establecimientoR.getEsnombrePortal(),
					establecimientoR.getEsnombrePiso(), establecimientoR.getEsnoraPaisId(),
					establecimientoR.getEsnoraPaisNombre(), establecimientoR.getEsdireccion_nocapv(), null,
					establecimientoR.getEsinadar(), establecSector.getSector().getSecodigo(),
					establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
					Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE, actuacion.getAtcodigo(), null,
					establecimientoR.getEsfemod(), establecimientoR.getCensoMonitor().getMocodigo(),
					establecimientoR.getCensoMonitor().getUsuarioxlnet());

			this.intervinientesDao.add(intervinientes);
			this.actuacionDao.updateATIDPARTICIPACIONRESPONSABLE(intervinientes);
		}

		// Alta interviniente administrador
		Organismo organismo = new Organismo();
		organismo.setCodOrg(inspeccionDetalle.getAdcoor());

		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

		String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

		intervinientes = new Intervinientes(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
				null, organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(),
				null, null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null, organismo.getEmail(),
				esExtranjero, organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
				organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(),
				organismo.getNombreLocalidad(), organismo.getNoraCalleId(), organismo.getNombreCalle(),
				organismo.getNoraCpId(), organismo.getNombreCp(), organismo.getNoraPortalId(),
				organismo.getNombrePortal(), organismo.getCompleDirec(), organismo.getNoraPaisId(),
				organismo.getNombrePais(), organismo.getNombreCalle(), null, null, null, null, null,
				Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION, actuacion.getAtcodigo(), null, null, null, null);

		this.intervinientesDao.add(intervinientes);

		Actdec actdec = new Actdec(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE),
				actuacion.getAtcodigo(), inspeccionDetalle.getAdcoor(), null, null, null);

		// Da de alta una decision vacia
		this.actdecDao.add(actdec);

		// Genera el tramite de Apertura y asignacion de expediente sin
		// tramitar.
		TramiteAsignacionInstructor tramiteAsignacionInstructor = new TramiteAsignacionInstructor();
		tramiteAsignacionInstructor.setFechaInicio(new Date());

		// Coordinador
		CensoMonitor censoMonitorCoordinador = new CensoMonitor();
		try {
			organismo = new Organismo();
			organismo.setCodOrg(inspeccionDetalle.getAdcoor());

			censoMonitorCoordinador.setOrganismo(organismo);

			censoMonitorCoordinador = this.censoMonitorDao.findCoordinadorInspecciones(censoMonitorCoordinador);
		} catch (Exception e) {
			censoMonitorCoordinador = new CensoMonitor();
		}

		tramiteAsignacionInstructor.setInstructorAsignado(censoMonitorCoordinador);
		tramiteAsignacionInstructor.setInstructorExpediente(censoMonitorCoordinador);

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		tramiteComun.setIdExpediente(actuacion.getAtcodigo());
		TramiteInspeccion tramiteInspeccion = this.instramexpService.addTramiteAsignacionInstructorMasiva(
				tramiteAsignacionInstructor, tramiteComun, false, Y41bConstantes.MODO_POPUP_ALTA);

		BandejaInspecciones bandejaInspeccionesAux = new BandejaInspecciones();
		bandejaInspeccionesAux.setAtcodigo(actuacion.getAtcodigo());

		if (actuacion.getAtcocm() != null && !"".equals(actuacion.getAtcocm())) {
			bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_CAMPANHA);
			bandejaInspeccionesAux.setIdorigen(actuacion.getAtcocm());
		} else if (actuacion.getAtcoal() != null && !"".equals(actuacion.getAtcoal())) {
			bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_ALERTA);
			bandejaInspeccionesAux.setIdorigen(actuacion.getAtcoal());
		} else if (actuacion.getAtidcomunicacionsoivre() != null && !"".equals(actuacion.getAtidcomunicacionsoivre())) {
			bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_SOIVRE);
			bandejaInspeccionesAux.setIdorigen(actuacion.getAtidcomunicacionsoivre());
		} else if (actuacion.getAtcohd() != null && !"".equals(actuacion.getAtcohd())) {
			if (actuacion.getAtcohddenuncia() != null
					&& Y41bConstantes.VALOR_SI.equals(actuacion.getAtcohddenuncia())) {
				bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_DENUNCIA);
			} else {
				bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_SOLICITUD);
			}
			bandejaInspeccionesAux.setIdorigen(actuacion.getAtcohd());
		} else {
			if (actuacion.getActa() != null && actuacion.getActa().getActiororigen() != null
					&& Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA
							.equals(actuacion.getActa().getActiororigen())) {
				bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_COMUNICACION_EXTERNA);
			} else if (actuacion.getActa() != null && actuacion.getActa().getActiororigen() != null
					&& Y41bConstantes.INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES
							.equals(actuacion.getActa().getActiororigen())) {
				bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_NOTIFICACION_PRODUCTORES);
			} else {
				bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_OFICIO);
			}
		}

		if (acta != null && acta.getAccoor() != null) {
			bandejaInspeccionesAux.setAccoor(acta.getAccoor());
		}

		if (acta != null && acta.getAcnror() != null) {
			bandejaInspeccionesAux.setAcnror(acta.getAcnror());
		}

		if (acta != null && acta.getAcnran() != null) {
			bandejaInspeccionesAux.setAcnran(acta.getAcnran());
		}

		bandejaInspeccionesAux.setAtnror(actuacion.getAtnror());

		if (actdec != null && actdec.getAdcoor() != null) {
			bandejaInspeccionesAux.setAdcoor(actdec.getAdcoor());
		}

		bandejaInspeccionesAux.setFcodigoactual(Y41bConstantes.FASE_INSPECCIONES);

		// ---------------------------

		bandejaInspeccionesAux.setTicodigo(tramiteInspeccion.getTicodigo());

		bandejaInspeccionesAux.setTrcodigoactual(Y41bConstantes.TRAMITE_INSPECCIONES_ASIGNACION_RESPONSABLE_EXPEDIENTE);

		bandejaInspeccionesAux.setVariosDocumentos(Y41bConstantes.VALOR_NO);

		bandejaInspeccionesAux.setFechatramite(tramiteInspeccion.getTifechainicio());

		if (acta != null && acta.getAccoes() != null) {
			bandejaInspeccionesAux.setEstvisitado(acta.getAccoes());
		}

		bandejaInspeccionesAux.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		bandejaInspeccionesAux.setFechalimite(tramiteInspeccion.getTifechalimite());

		this.bandejaInspeccionesDao.add(bandejaInspeccionesAux);

		logger.debug("####################################################FIN addInspeccionMasiva");

		return inspeccionDetalle;
	}

	private Establecimiento tratamientoAnadirIntervinienteEstablecimiento(Establecimiento establecimiento) {
		// Cuando se vaya a aadir un establecimiento a un expediente, se mirar
		// el nuevo campo identificacin. Si tiene valor 1 (CIF), se insertara
		// en el expediente como ahora utilizando el CIF del establecimiento. Si
		// tiene valor 2 (Otros), se mira si el campo CIF est relleno, si est
		// relleno se insertar el establecimiento con ese CIF, si no est
		// relleno el campo CIF, se utilizar como CIF la clave de BBDD de ese
		// establecimiento (ESCODIGO), que es un campo nico.
		if (establecimiento != null && establecimiento.getEstipid() != null
				&& establecimiento.getEstipid().equals(Y41bConstantes.OTROS)) {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		} else {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		}

		return establecimiento;
	}

	/**
	 * Actualiza la fecha de protocolo de una inspeccion.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return inspeccionDetalle InspeccionDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionDetalle updateFechaProtocolo(InspeccionDetalle inspeccionDetalle) {

		try {
			Actuacion actuacion = new Actuacion();

			actuacion.setAtcodigo(inspeccionDetalle.getAtcodigo());
			actuacion.setAtfeprotocolo(inspeccionDetalle.getAtfeprotocolo());

			this.actuacionDao.updateFechaProtocolo(actuacion);

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

		return inspeccionDetalle;
	}

	/**
	 * Actualiza una inspeccion.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return inspeccionDetalle InspeccionDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionDetalle updateInspeccion(InspeccionDetalle inspeccionDetalle) {

		try {

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(inspeccionDetalle.getAtcoes());

			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(inspeccionDetalle.getMocodigo());

			Producto producto = new Producto();
			producto.setPscodigo(inspeccionDetalle.getPscodigo());

			Actuacion actuacion = new Actuacion();

			// modifica la actuacion

			actuacion.setAtcodigo(inspeccionDetalle.getAtcodigo());
			actuacion = this.actuacionDao.findByActa(actuacion);
			actuacion.setAtcoes(inspeccionDetalle.getAtcoes());
			actuacion.setAtformanotifestablecimientore(inspeccionDetalle.getAtformanotifestablecimientore());
			actuacion.setAtformanotifestablecimientovi(inspeccionDetalle.getAtformanotifestablecimientovi());
			actuacion.setAtidiomaestablecimientovi(inspeccionDetalle.getAtidiomaestablecimientovi());
			actuacion.setAtcodigobarras(inspeccionDetalle.getAtcodigobarras());
			actuacion.setAtcops(inspeccionDetalle.getAtcops());
			actuacion.setAtnoprse(inspeccionDetalle.getAtnoprse());
			actuacion.setAtnomaps(inspeccionDetalle.getAtnomaps());
			actuacion.setAtnomops(inspeccionDetalle.getAtnomops());
			actuacion.setAtnrlops(inspeccionDetalle.getAtnrlops());
			actuacion.setAtcopsnom(inspeccionDetalle.getAtcopsnom());

			actuacion.setAtudestruidas(inspeccionDetalle.getAtudestruidas());
			actuacion.setAtudevolucionorigen(inspeccionDetalle.getAtudevolucionorigen());
			actuacion.setAtuexistentes(inspeccionDetalle.getAtuexistentes());
			actuacion.setAtuinmovilizadas(inspeccionDetalle.getAtuinmovilizadas());
			actuacion.setAtulibrecomercializacion(inspeccionDetalle.getAtulibrecomercializacion());
			actuacion.setAtuotros(inspeccionDetalle.getAtuotros());

			actuacion.setAtfefin(inspeccionDetalle.getAtfefin());
			actuacion.setAtfedumi(inspeccionDetalle.getAtfedumi());
			actuacion.setAtdestnotificavisitado(inspeccionDetalle.getAtdestnotificavisitado());
			actuacion.setAtdestnotificaresponsable(inspeccionDetalle.getAtdestnotificaresponsable());

			InspeccionDetalle inspeccionDetalleAux = this.actaDao.findInspeccion(actuacion);

			// Si la inspeccin es de una campaa no podr ser inspeccin online
			if (inspeccionDetalleAux.getAtcocm() != null) {
				actuacion.setAtonline(Y41bConstantes.VALOR_NO);
			} else {
				actuacion.setAtonline(inspeccionDetalle.getAtonline());
			}

			this.actuacionDao.update(actuacion);

			// Modifica un acta
			Acta acta = new Acta();
			acta.setAccodigo(actuacion.getAtcoac());
			acta.setAccoor(inspeccionDetalle.getAccoor());
			acta.setAcnror(inspeccionDetalle.getAcnror());
			acta.setAcnran(inspeccionDetalle.getAcnran());
			if (inspeccionDetalle.getAccoes() != null) {
				acta.setAccoes(inspeccionDetalle.getAccoes());
			}

			acta.setAcfere(inspeccionDetalle.getAcfere());

			acta.setAccodexpedienteorigen(inspeccionDetalle.getAccodexpedienteorigen());
			acta.setAccoororigen(inspeccionDetalle.getAccoororigen());
			acta.setActiororigen(inspeccionDetalle.getActiororigen());
			acta.setAcincumplimiento(inspeccionDetalle.getAcincumplimiento());

			this.actaDao.update(acta);

			// Si la inspeccion es una notificacion de productores o una
			// comunicacion externa.
			if (Y41bConstantes.INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES.equals(inspeccionDetalle.getActiororigen())
					|| Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA
							.equals(inspeccionDetalle.getActiororigen())) {
				// Buscar si tiene el organismo introducido como interviniente.
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ORGANISMO_PRODUCTOR);

				Organismo organismo = new Organismo();
				organismo.setCodOrg(inspeccionDetalle.getAccoororigen());
				organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

				String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

				if (Y41bConstantes.VALOR_SI.equals(inspeccionDetalle.getOrganismoCambio())) {
					List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);
					if (listIntervinientes.size() > 0) {
						// Actualizacion del interviniente del organismo.
						Intervinientes intervinientesAux = new Intervinientes(
								listIntervinientes.get(0).getIdinterviniente(), null, null, organismo.getEntidadId(),
								organismo.getNombreEs(), null, null, null, null, organismo.getCif(), null, null, null,
								organismo.getUrl(), null, null, organismo.getTelefono(), null, organismo.getEmail(),
								esExtranjero, organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
								organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(),
								organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(),
								organismo.getNoraCalleId(), organismo.getNombreCalle(), organismo.getNoraCpId(),
								organismo.getNombreCp(), organismo.getNoraPortalId(), organismo.getNombrePortal(),
								organismo.getCompleDirec(), organismo.getNoraPaisId(), organismo.getNombrePais(),
								organismo.getNombreCalle(), null, null, null, null, null,
								Y41bConstantes.TIPO_INTERVINIENTE_ORGANISMO_PRODUCTOR, actuacion.getAtcodigo(), null,
								null, null, null);

						this.intervinientesDao.update(intervinientesAux);
					} else {
						// Alta como interviniente del organismo.
						Intervinientes intervinientesAux = new Intervinientes(
								Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, null,
								organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null,
								organismo.getCif(), null, null, null, organismo.getUrl(), null, null,
								organismo.getTelefono(), null, organismo.getEmail(), esExtranjero,
								organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
								organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(),
								organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(),
								organismo.getNoraCalleId(), organismo.getNombreCalle(), organismo.getNoraCpId(),
								organismo.getNombreCp(), organismo.getNoraPortalId(), organismo.getNombrePortal(),
								organismo.getCompleDirec(), organismo.getNoraPaisId(), organismo.getNombrePais(),
								organismo.getNombreCalle(), null, null, null, null, null,
								Y41bConstantes.TIPO_INTERVINIENTE_ORGANISMO_PRODUCTOR, actuacion.getAtcodigo(), null,
								null, null, null);

						this.intervinientesDao.add(intervinientesAux);
					}
				}
			}

			// buscar el interviniente responsable
			if (inspeccionDetalle.getAtcoes() != null && !"".equals(inspeccionDetalle.getAtcoes())) {
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);

				List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);
				if (listIntervinientes.size() > 0) {
					intervinientes = listIntervinientes.get(0);
				}

				// Alta interviniente establecimiento
				establecimiento = this.establecimientoDao.find(establecimiento);

				establecimiento = this.tratamientoAnadirIntervinienteEstablecimiento(establecimiento);

				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEstablecimiento(establecimiento);

				EstablecimSector establecSector = new EstablecimSector();
				Actividad actividad = new Actividad();
				Sector sector = new Sector();
				establecSector.setActividad(actividad);
				establecSector.setSector(sector);

				establecSector = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);

				try {
					EstablecimArbitra establecimArbitra = new EstablecimArbitra();
					establecimArbitra.setEstablecimiento(new Establecimiento());
					establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
					establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
					if (establecimArbitra != null) {
						if ("A".equals(establecimiento.getEsinadar())) {
							if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
								establecimiento.setEsinadar("L");
							}
						}
					}
				} catch (Exception e) {

				}

				if (Y41bConstantes.VALOR_SI.equals(inspeccionDetalle.getEstablecimientoResponsableCambio())) {
					if (listIntervinientes.size() > 0) {
						if (actuacion != null && actuacion.getAtparticipacionresponsable() != null
								&& actuacion.getAtparticipacionresponsable().equals(Y41bConstantes.VALOR_SI)) {

							if (Y41bUtils.isValidCIF(intervinientes.getNif())
									|| Y41bUtils.isValidNIF(intervinientes.getNif())) {
								// si est en PLATEA
								if (intervinientes.getNif() != null
										&& !intervinientes.getNif().equals(establecimiento.getEsnif())) {
									throw new Y41bUDAException(
											"error.inspeccion.nifEstablecimientoresponsableDiferenteException", true,
											new Exception());
								}
							}
						}

						Intervinientes intervinientesAux = new Intervinientes(intervinientes.getIdinterviniente(), null,
								establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
								establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
								establecimiento.getEscoidco(), establecimiento.getEsteurl(),
								establecimiento.getEsnopeco(), establecimiento.getEsfeba(),
								establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
								establecimiento.getEscoem(), establecimiento.getEsextranjero(),
								establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
								establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
								establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
								establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
								establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
								establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
								establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
								establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
								establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
								establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
								Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE, actuacion.getAtcodigo(),
								null, establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
								establecimiento.getCensoMonitor().getUsuarioxlnet());

						this.intervinientesDao.update(intervinientesAux);
					} else {

						intervinientes = new Intervinientes(
								Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
								establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
								establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
								establecimiento.getEscoidco(), establecimiento.getEsteurl(),
								establecimiento.getEsnopeco(), establecimiento.getEsfeba(),
								establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
								establecimiento.getEscoem(), establecimiento.getEsextranjero(),
								establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
								establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
								establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
								establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
								establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
								establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
								establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
								establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
								establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
								establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
								Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE, actuacion.getAtcodigo(),
								null, establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
								establecimiento.getCensoMonitor().getUsuarioxlnet());

						this.intervinientesDao.add(intervinientes);
						this.actuacionDao.updateATIDPARTICIPACIONRESPONSABLE(intervinientes);
					}
				}

				// Actualizamos la participacoion del establecimiento
				// responsable
				if (actuacion != null && actuacion.getAtparticipacionresponsable() != null
						&& actuacion.getAtparticipacionresponsable().equals(Y41bConstantes.VALOR_SI)) {
					TramiteComun tramiteComun = new TramiteComun();
					tramiteComun.setIdExpediente(actuacion.getAtcodigo());

					this.instramexpService.actualizarParticipacionEstablecimientoResponsable(tramiteComun);

				}
			} else {
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);

				List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);
				if (listIntervinientes.size() > 0) {
					intervinientes = listIntervinientes.get(0);

					try {
						this.intervinientesDao.remove(intervinientes);
					} catch (DataIntegrityViolationException e) {
						throw new Y41bUDAException("error.interviniente.responsableException", true, e);
					}
				}
			}

			inspeccionDetalleAux = this.actaDao.findInspeccion(actuacion);

			// buscar el interviniente visitado
			if (inspeccionDetalle.getAccoes() != null && !"".equals(inspeccionDetalle.getAccoes())) {

				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

				List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);

				if (listIntervinientes.size() > 0) {
					intervinientes = listIntervinientes.get(0);
				}

				// Alta interviniente establecimiento
				establecimiento.setEscodigo(inspeccionDetalle.getAccoes());
				establecimiento = this.establecimientoDao.find(establecimiento);

				establecimiento = this.tratamientoAnadirIntervinienteEstablecimiento(establecimiento);

				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEstablecimiento(establecimiento);

				EstablecimSector establecSector = new EstablecimSector();
				Actividad actividad = new Actividad();
				Sector sector = new Sector();
				establecSector.setActividad(actividad);
				establecSector.setSector(sector);

				establecSector = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);

				try {
					EstablecimArbitra establecimArbitra = new EstablecimArbitra();
					establecimArbitra.setEstablecimiento(new Establecimiento());
					establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
					establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
					if (establecimArbitra != null) {
						if ("A".equals(establecimiento.getEsinadar())) {
							if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
								establecimiento.setEsinadar("L");
							}
						}
					}
				} catch (Exception e) {

				}

				if (listIntervinientes.size() > 0) {

					if (actuacion != null && actuacion.getAtenplatea() != null
							&& actuacion.getAtenplatea().equals(Y41bConstantes.VALOR_SI)) {

						if (Y41bUtils.isValidCIF(intervinientes.getNif())
								|| Y41bUtils.isValidNIF(intervinientes.getNif())) {
							// si est en PLATEA
							if (intervinientes.getNif() != null
									&& !intervinientes.getNif().equals(establecimiento.getEsnif())) {
								if (inspeccionDetalleAux.getAtcocm() != null
										&& ((inspeccionDetalleAux.getCmonline() != null
												&& inspeccionDetalleAux.getCmonline().equals(Y41bConstantes.VALOR_SI))
												|| (inspeccionDetalleAux.getAtonline() != null && inspeccionDetalleAux
														.getAtonline().equals(Y41bConstantes.VALOR_SI)))) {
									throw new Y41bUDAException("error.inspeccion.nifWebvisitadaDiferenteException",
											true, new Exception());
								} else {
									throw new Y41bUDAException(
											"error.inspeccion.nifEstablecimientovisitadoDiferenteException", true,
											new Exception());
								}
							}
						}
					}

					if (Y41bConstantes.VALOR_SI.equals(inspeccionDetalle.getEstablecimientoVisitadoCambio())) {
						Intervinientes intervinientesAux = new Intervinientes(intervinientes.getIdinterviniente(), null,
								establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
								establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
								establecimiento.getEscoidco(), establecimiento.getEsteurl(),
								establecimiento.getEsnopeco(), establecimiento.getEsfeba(),
								establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
								establecimiento.getEscoem(), establecimiento.getEsextranjero(),
								establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
								establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
								establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
								establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
								establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
								establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
								establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
								establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
								establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
								establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
								Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO, actuacion.getAtcodigo(),
								null, establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
								establecimiento.getCensoMonitor().getUsuarioxlnet());

						this.intervinientesDao.update(intervinientesAux);
					}
				} else {

					intervinientes = new Intervinientes(
							Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
							establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
							establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
							establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
							establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
							establecimiento.getEscoem(), establecimiento.getEsextranjero(),
							establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
							establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
							establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
							establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
							establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
							establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
							establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
							establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
							establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
							establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
							Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO, actuacion.getAtcodigo(), null,
							establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
							establecimiento.getCensoMonitor().getUsuarioxlnet());

					this.intervinientesDao.add(intervinientes);
					this.actuacionDao.updateATIDPARTICIPACIONVISITADO(intervinientes);
				}

				// Actualizamos la participacoion del establecimiento visitado
				if (actuacion != null && actuacion.getAtenplatea() != null
						&& actuacion.getAtenplatea().equals(Y41bConstantes.VALOR_SI)) {
					TramiteComun tramiteComun = new TramiteComun();
					tramiteComun.setIdExpediente(actuacion.getAtcodigo());

					this.instramexpService.actualizarParticipacionEstablecimientoVisitado(tramiteComun);

				}

			} else {
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

				List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);
				if (listIntervinientes.size() > 0) {
					intervinientes = listIntervinientes.get(0);

					try {
						this.intervinientesDao.remove(intervinientes);
					} catch (DataIntegrityViolationException e) {
						if ((inspeccionDetalleAux.getAtcocm() != null && inspeccionDetalleAux.getCmonline() != null
								&& inspeccionDetalleAux.getCmonline().equals(Y41bConstantes.VALOR_SI))
								|| (inspeccionDetalleAux.getAtonline() != null
										&& inspeccionDetalleAux.getAtonline().equals(Y41bConstantes.VALOR_SI))) {
							throw new Y41bUDAException("error.interviniente.webvisitadaException", true, e);
						} else {
							throw new Y41bUDAException("error.interviniente.visitadoException", true, e);
						}
					}
				}
			}

			// Al grabar la pestaa de inspeccin en una inspeccin de una
			// campaa on-line, se validar que el campo Web de la Web visitada
			// tenga valor
			if ((inspeccionDetalleAux.getAtcocm() != null && inspeccionDetalleAux.getCmonline() != null
					&& inspeccionDetalleAux.getCmonline().equals(Y41bConstantes.VALOR_SI))
					|| (inspeccionDetalleAux.getAtonline() != null
							&& inspeccionDetalleAux.getAtonline().equals(Y41bConstantes.VALOR_SI))) {
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

				List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);
				if (listIntervinientes.size() > 0) {
					intervinientes = listIntervinientes.get(0);

					if (intervinientes != null && !Y41bUtils.isFilled(intervinientes.getEsteurl())) {
						throw new Y41bUDAException("error.inspeccion.webWebvisitadaException", true, new Exception());
					}
				}
			}

			BandejaInspecciones bandejaInspecciones = new BandejaInspecciones();
			bandejaInspecciones.setAtcodigo(inspeccionDetalle.getAtcodigo());

			this.bandejaInspeccionesService.updateUltimoTramite(bandejaInspecciones);

			// movilidad
			if (inspeccionDetalle.getAtatablet() != null
					&& inspeccionDetalle.getAtatablet().equalsIgnoreCase(Y41bConstantes.SI)) {
				// actualizacion tabla sincronizacion

				acta = this.actaDao.find(acta);

				CensoMonitor censoMonitorAux = new CensoMonitor();
				censoMonitorAux.setMocodigo(acta.getAccomo());

				if (this.documentoHechoDao.findSincronizacion(censoMonitorAux) > 0) {
					this.documentoHechoDao.updateTablaSincronizacion(censoMonitorAux);
				} else {
					this.documentoHechoDao.addTablaSincronizacion(censoMonitorAux);
				}
			}

		} catch (DataIntegrityViolationException e) {
			String causa = e.getCause().toString();
			int i = causa.indexOf("L21.FK_L2114T00_03");
			int j = causa.indexOf("L21.FK_L2124T00_03");
			if (i != -1) {
				throw new Y41bUDAException("error.solicitud.consumidor", true, e);
			} else if (j != -1) {
				throw new Y41bUDAException("error.solicitud.establecimiento", true, e);
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

		return inspeccionDetalle;
	}

	/**
	 * Copiar una inspeccion.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return inspeccionDetalle InspeccionDetalle
	 */
	public InspeccionDetalle copiarInspeccion(InspeccionDetalle inspeccionDetalle, CensoMonitor censoMonitor) {

		try {
			// Buscar y guardar la inspeccion/actuacion a copiar.
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(inspeccionDetalle.getAtcodigo());
			inspeccionDetalle = this.actaDao.findInspeccion(actuacion);
			inspeccionDetalle.setAdcoor(censoMonitor.getOrganismo().getCodOrg());
			inspeccionDetalle.setAccoor(censoMonitor.getOrganismo().getCodOrg());

			if (inspeccionDetalle != null && inspeccionDetalle.getEstablecimientoR() != null
					&& inspeccionDetalle.getEstablecimientoR().getEscodigo() != null) {
				inspeccionDetalle.setAtcoes(inspeccionDetalle.getEstablecimientoR().getEscodigo());
			}

			if (inspeccionDetalle != null && inspeccionDetalle.getEstablecimientoV() != null
					&& inspeccionDetalle.getEstablecimientoV().getEscodigo() != null) {
				inspeccionDetalle.setAccoes(inspeccionDetalle.getEstablecimientoV().getEscodigo());
			}

			inspeccionDetalle.setAccodexpedienteorigen(null);
			inspeccionDetalle.setAccoororigen(null);
			inspeccionDetalle.setActiororigen(null);
			inspeccionDetalle.setAcincumplimiento(null);

			// Evita problemas con las fechas desde hasta
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			inspeccionDetalle.setAcfere(todayWithZeroTime);

			inspeccionDetalle.setAtcohd(null);
			inspeccionDetalle.setAtcohddenuncia(null);
			inspeccionDetalle.setAtcocm(null);
			inspeccionDetalle.setAtcopg(null);
			inspeccionDetalle.setAtcoal(null);
			inspeccionDetalle.setAtcocr(null);
			inspeccionDetalle.setAtidcomunicacionsoivre(null);

			inspeccionDetalle.setAtfechacierre(null);
			inspeccionDetalle.setAtfefin(null);
			inspeccionDetalle.setAtadicional(null);
			inspeccionDetalle.setAtenplatea(null);
			inspeccionDetalle.setAtparticipacionresponsable(null);
			inspeccionDetalle.setAtacuerdoinicio(null);

			inspeccionDetalle = this.addInspeccion(inspeccionDetalle);

			return inspeccionDetalle;
		} catch (DataIntegrityViolationException e) {
			String causa = e.getCause().toString();
			int i = causa.indexOf("L21.FK_L2114T00_03");
			int j = causa.indexOf("L21.FK_L2124T00_03");
			if (i != -1) {
				throw new Y41bUDAException("error.solicitud.consumidor", true, e);
			} else if (j != -1) {
				throw new Y41bUDAException("error.solicitud.establecimiento", true, e);
			}
			return null;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Borra una inspeccin
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeInspeccion(InspeccionDetalle inspeccionDetalle) {

		// Validacion: Si est dado de alta en PLATEA no se puede eliminar
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(inspeccionDetalle.getAtcodigo());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		// Actualizamos la participacoion del establecimiento visitado
		if (insDetalle != null && insDetalle.getAtenplatea() != null
				&& insDetalle.getAtenplatea().equals(Y41bConstantes.VALOR_SI)) {
			throw new Y41bUDAException("error.inspeccion.removeException", true, new Exception());
		}

		if (insDetalle != null && Y41bUtils.isFilled(insDetalle.getAtidcomunicacionsoivre())) {
			ComunicacionSoivre comunicacionsoivre = new ComunicacionSoivre();
			comunicacionsoivre.setIdcomunicacionsoivre(insDetalle.getAtidcomunicacionsoivre());

			this.comunicacionSoivreDao.updateFechaSolInspeccion(comunicacionsoivre);
		}

		// Si es campaa
		if (insDetalle != null && Y41bUtils.isFilled(insDetalle.getAtcocm())) {
			CampanhaProgramacion campanhaprogramacion = new CampanhaProgramacion();
			campanhaprogramacion.setPgcodigo(insDetalle.getAtcopg());

			BandejaCampanha bandejacampanha = new BandejaCampanha();
			bandejacampanha.setCampanhaProgramacion(campanhaprogramacion);

			Campanha campanha = new Campanha();
			campanha.setCmcodigo(insDetalle.getAtcocm());
			bandejacampanha.setCampanha(campanha);

			if (insDetalle != null && insDetalle.getAtadicional() != null
					&& insDetalle.getAtadicional().equals(Y41bConstantes.VALOR_SI)) {
				// reducir adicional en bandeja campaas
				this.bandejaCampanhaDao.updateEliminarInspeccionAdicional(bandejacampanha);
				// reducir adicional en programacion campaas
				this.campanhaProgramacionDao.updateEliminarInspeccionAdicional(campanhaprogramacion);
				// reducir adicional en bandeja campaas SSCC
				this.bandejaCampanhaDao.updateEliminarInspeccionAdicionalSSCC(bandejacampanha);
			} else if (insDetalle != null && insDetalle.getAttipo() != null
					&& insDetalle.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS)) {
				// reducir toma muestras en bandeja campaas
				this.bandejaCampanhaDao.updateEliminarInspeccionTomaMuestras(bandejacampanha);
				// reducir toma muestras en programacion campaas
				this.campanhaProgramacionDao.updateEliminarInspeccionTomaMuestras(campanhaprogramacion);
				// reducir toma muestras en bandeja campaas SSCC
				this.bandejaCampanhaDao.updateEliminarInspeccionTomaMuestrasSSCC(bandejacampanha);
			} else if (insDetalle != null && insDetalle.getAttipo() != null
					&& insDetalle.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR)) {
				// reducir control estandar en bandeja campaas
				this.bandejaCampanhaDao.updateEliminarInspeccionControlEstandar(bandejacampanha);
				// reducir control estandar en programacion campaas
				this.campanhaProgramacionDao.updateEliminarInspeccionControlEstandar(campanhaprogramacion);
				// reducir control estandar en bandeja campaas SSCC
				this.bandejaCampanhaDao.updateEliminarInspeccionControlEstandarSSCC(bandejacampanha);
			} else if (insDetalle != null && insDetalle.getAttipo() != null
					&& insDetalle.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS)) {
				// reducir control otros en bandeja campaas
				this.bandejaCampanhaDao.updateEliminarInspeccionControlOtros(bandejacampanha);
				// reducir control otros en programacion campaas
				this.campanhaProgramacionDao.updateEliminarInspeccionControlOtros(campanhaprogramacion);
				// reducir control otros en bandeja campaas SSCC
				this.bandejaCampanhaDao.updateEliminarInspeccionControlOtrosSSCC(bandejacampanha);
			}
		}

		// Si es alerta
		if (insDetalle != null && Y41bUtils.isFilled(insDetalle.getAtcoal())) {
			AlertaProgramacion alertaprogramacion = new AlertaProgramacion();
			alertaprogramacion.setCrcodigo(insDetalle.getAtcocr());

			BandejaAlerta bandejaalerta = new BandejaAlerta();
			bandejaalerta.setCrcodigo(insDetalle.getAtcocr());
			bandejaalerta.setAlcodigo(insDetalle.getAtcoal());
			// actualizar programacion alertas
			this.alertaProgramacionDao.updateEliminarInspeccionNumActuaciones(alertaprogramacion);
			// actualizar bandeja alertas
			this.bandejaAlertaDao.updateEliminarInspeccionNumActuaciones(bandejaalerta);
			// actualizar bandeja alertas
			this.bandejaAlertaDao.updateEliminarInspeccionNumActuacionesSSCC(bandejaalerta);
		}

		// Eliminar bandeja
		BandejaInspecciones bandejaInspecciones = new BandejaInspecciones();
		bandejaInspecciones.setAtcodigo(inspeccionDetalle.getAtcodigo());

		this.bandejaInspeccionesDao.remove(bandejaInspecciones);

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdExpediente(inspeccionDetalle.getAtcodigo());
		List<DocumentoExpediente> listDocumentoExpediente = this.documentoHechoDao
				.findAllDocumentosHechoInspeccion(tramiteComunAux, null);

		try {
			// Eliminamos los documentos de dokusi
			this.instramexpService.eliminarDocumentosDokusi(listDocumentoExpediente);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

		// Buscar todos los tramites del expediente
		TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
		tramiteInspeccionDetalle.setAtcodigo(inspeccionDetalle.getAtcodigo());
		List<TramiteInspeccionDetalle> listTramiteInspeccionDetalle = this.tramiteInspeccionDao
				.findAllTramiteInspeccion(tramiteInspeccionDetalle, null);

		BandejaFirma bandejaFirma = null;
		for (TramiteInspeccionDetalle tramiteInspeccionDetalleAux : listTramiteInspeccionDetalle) {
			DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
			documentoTramiteHecho.setEhcodigo(tramiteInspeccionDetalleAux.getTicodigo());
			this.documentoHechoDao.removeDocsTramiteHecho(documentoTramiteHecho);

			bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdtramitehecho(tramiteInspeccionDetalleAux.getTicodigo());
			bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
		}

		// Eliminar todos los documentos de las actas
		// Buscar todos las actas del expediente
		ActaNueva actanueva = new ActaNueva();
		actanueva.setAncodins(inspeccionDetalle.getAtcodigo());
		List<ActaNueva> listActaNueva = this.actaNuevaDao.findAll(actanueva, null);

		for (ActaNueva actaNuevaAux : listActaNueva) {
			DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
			documentoTramiteHecho.setEhcodigo(actaNuevaAux.getAncodigo());

			this.documentoHechoDao.removeDocsTramiteHecho(documentoTramiteHecho);
		}

		// eliminar documentos hecho
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5hdcodigo(inspeccionDetalle.getAtcodigo());
		this.documentoHechoDao.removeDocsExpediente(documentoHecho);

		// Eliminar todos los tramites
		TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
		tramiteinspeccion.setTiatcodigo(inspeccionDetalle.getAtcodigo());
		this.tramiteInspeccionDao.removeAllTramitesExpediente(tramiteinspeccion);

		// eliminar intervinientes
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
		this.intervinientesDao.removeIntervinientesExpediente(intervinientes);

		// eliminar expedientes relacionados
		Sanexprel sanexprel = new Sanexprel();
		sanexprel.setRlinscodigo(inspeccionDetalle.getAtcodigo());
		this.sanexprelDao.removeExpedienteInspeccion(sanexprel);

		// eliminar las respuestas de los protocolos
		actuacion = new Actuacion();
		actuacion.setAtcodigo(inspeccionDetalle.getAtcodigo());
		this.protocolDao.removeAllProtocoloInspeccion(actuacion);

		// Eliminar todos las actas
		this.actaNuevaDao.removeAllActasInspeccion(actanueva);

		// Eliminar infracciones
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(inspeccionDetalle.getAtcodigo());
		this.actaInfraccionDao.removeAllInfracciones(tramiteComun);

		// eliminar decision hecho
		Actdec actdec = new Actdec();
		actdec.setAdcoat(inspeccionDetalle.getAtcodigo());
		this.actdecDao.removeDecisionInspeccion(actdec);

		// eliminar actuacion
		actuacion = new Actuacion();
		actuacion.setAtcodigo(inspeccionDetalle.getAtcodigo());
		this.actuacionDao.remove(actuacion);

		// eliminar acta
		this.actaDao.removeActaExpediente(insDetalle);

	}

	/**
	 * Recupera la bandeja de inspecciones.
	 * 
	 * @param filterActa
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BusquedaInspeccion> findAllBandejaInspecciones(Acta filterActa, Pagination pagination) {
		return (List<BusquedaInspeccion>) this.actaDao.findAllBandejaInspecciones(filterActa, pagination);
	}

	/**
	 * Recupera el count de la bandeja de inspecciones.
	 * 
	 * @param filterActa
	 *            Acta
	 * @return Long
	 */
	public Long findAllBandejaInspeccionesCount(Acta filterActa) {
		return this.actaDao.findAllBandejaInspeccionesCount(filterActa);
	}

	/**************
	 * PLANTILLAS *
	 **************/

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addPlantilla(Adjuntardocs adjuntardocs, TramiteComun tramiteComun, String tipodocumento)
			throws Exception {

		PlantillaTramite plantillaTramite = new PlantillaTramite();
		plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());

		String plantilla = this.findPlantilla(plantillaTramite, tramiteComun);

		plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);

		adjuntardocs.setThcodocumento(this.documentoHechoDao.getNewPK().toString());

		adjuntardocs.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION);

		TipoDocumento tipoDocumento = new TipoDocumento();
		tipoDocumento.setIdTipodoc(tipodocumento);

		adjuntardocs.setTipoDocumento(tipoDocumento);

		Blob blob = new SerialBlob(plantilla.getBytes());
		adjuntardocs.setThdatafile(blob);
		adjuntardocs.setThcontenttypefile("application/msword");

		adjuntardocs.setThnofile(new StringBuffer(plantillaTramite.getPtnombre()).append(".rtf").toString());
		adjuntardocs.setThsizefile(plantilla.getBytes().length);

		adjuntardocs.setThidExpediente(tramiteComun.getIdExpediente());
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		adjuntardocs.setTipoProcedimiento(tipoProcedimiento);

		adjuntardocs.setThfecha(new Date());

		this.adjuntardocsDao.add(adjuntardocs);
	}

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addPlantillaDecision(Adjuntardocs adjuntardocs, TramiteComun tramiteComun, String tipodocumento)
			throws Exception {

		PlantillaDecision plantillaDecision = new PlantillaDecision();
		plantillaDecision.setPdcodigo(adjuntardocs.getPdcodigo());

		String plantilla = this.findPlantillaDecision(plantillaDecision, tramiteComun);

		plantillaDecision = this.plantillaDecisionDao.find(plantillaDecision);

		adjuntardocs.setThcodocumento(this.documentoHechoDao.getNewPK().toString());

		adjuntardocs.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION);

		TipoDocumento tipoDocumento = new TipoDocumento();
		tipoDocumento.setIdTipodoc(tipodocumento);

		adjuntardocs.setTipoDocumento(tipoDocumento);

		Blob blob = new SerialBlob(plantilla.getBytes());
		adjuntardocs.setThdatafile(blob);
		adjuntardocs.setThcontenttypefile("application/msword");

		adjuntardocs.setThnofile(new StringBuffer(plantillaDecision.getPdnombre()).append(".rtf").toString());
		adjuntardocs.setThsizefile(plantilla.getBytes().length);

		adjuntardocs.setThidExpediente(tramiteComun.getIdExpediente());
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
		adjuntardocs.setTipoProcedimiento(tipoProcedimiento);

		adjuntardocs.setThfecha(new Date());

		if (Y41bConstantes.SI.equals(adjuntardocs.getThrequierefirma())) {
			adjuntardocs.setThfechasolfirma(Calendar.getInstance().getTime());
			adjuntardocs.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
		}

		this.adjuntardocsDao.add(adjuntardocs);
	}

	/**
	 * Genera un documento en base a su plantilla.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	// CHECKSTYLE:OFF
	private String findPlantilla(PlantillaTramite plantillaTramite, TramiteComun tramiteComun) throws Exception {

		// Obtener la plantilla del tramite
		plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteComun.getIdExpediente());
		// Obtener los datos de la comunicacion soivre
		actuacion = this.actuacionDao.find(actuacion);

		PlantillaTramiteINSDetalle plantillaTramiteINSDetalle = new PlantillaTramiteINSDetalle();

		if (Y41bUtils.isFilled(actuacion.getAtcoal())) {
			Alerta alerta = new Alerta();
			alerta.setAlcodigo(actuacion.getAtcoal());
			alerta = this.alertaDao.find(alerta);

			plantillaTramiteINSDetalle.setAlcoor(alerta.getAlcoor());
			plantillaTramiteINSDetalle.setAlnran(alerta.getAlnran());
			plantillaTramiteINSDetalle.setAlnror(alerta.getAlnror());
		}

		// acfere
		plantillaTramiteINSDetalle.setAcfere(Y41bUtils.formatearDateToString(actuacion.getActa().getAcfere(),
				Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));

		plantillaTramiteINSDetalle
				.setAccodexpedienteorigen(Y41bUtils.trataNull(actuacion.getActa().getAccodexpedienteorigen()));

		// JAVI plantilla nueva - organismo origen - comunicacion externa
		if (actuacion.getActa() != null && actuacion.getActa().getActiororigen() != null
				&& Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA
						.equals(actuacion.getActa().getActiororigen())) {

			if (actuacion.getActa() != null && actuacion.getActa().getAccoororigen() != null) {
				plantillaTramiteINSDetalle.setAccoororigen(actuacion.getActa().getAccoororigen());

				Organismo organismoAux = new Organismo();
				organismoAux.setCodOrg(actuacion.getActa().getAccoororigen());

				organismoAux = this.organismoDao.findOrganismoComunicacionExterna(organismoAux);

				plantillaTramiteINSDetalle.setAccoororigennbes(organismoAux.getNombreEs());
				plantillaTramiteINSDetalle.setAccoororigennbeu(organismoAux.getNombreEu());
			}
		}

		// Producto
		plantillaTramiteINSDetalle.setNombreProducto(actuacion.getAtnoprse());
		plantillaTramiteINSDetalle.setMarcaProducto(actuacion.getAtnomaps());
		plantillaTramiteINSDetalle.setModeloProducto(actuacion.getAtnomops());
		plantillaTramiteINSDetalle.setLoteProducto(actuacion.getAtnrlops());
		plantillaTramiteINSDetalle.setCodigoBarrasProducto(actuacion.getAtcodigobarras());

		Producto producto = new Producto();
		producto.setPscodigo(actuacion.getAtcops());
		producto = this.productoService.find(producto);

		plantillaTramiteINSDetalle.setProductoServicio(producto.getPsnombre());

		// inspeccion
		plantillaTramiteINSDetalle
				.setExpediente(this.instramexpService.findNumExpedienteActuacion(tramiteComun.getIdExpediente()));

		plantillaTramiteINSDetalle.setOrigen(this.instramexpService.findOrigenInspeccionPorIdExpediente(
				tramiteComun.getIdExpediente(), new Locale(Y41bConstantes.CASTELLANO)));

		// lista de infracciones
		List<DetalleInfraccion> detalleInfraccion = this.actaService.findInfracciones(actuacion, null, false);
		StringBuffer infracciones = new StringBuffer();
		for (DetalleInfraccion di : detalleInfraccion) {

			infracciones.append("{ ");
			infracciones.append(" \\\\pard\\\\sb1 ");
			infracciones.append(" \\\\tab - \\\\tab ");
			infracciones.append(di.getTtinombre());
			infracciones.append(" \\\\line\\\\par ");
			infracciones.append("}");
		}

		plantillaTramiteINSDetalle.setInfracciones(Y41bUtils.trataNull(infracciones.toString()));

		// tramite inspeccion

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());

		tramiteInspeccion = this.tramiteInspeccionService.find(tramiteInspeccion);

		if (tramiteInspeccion != null) {

			ActaNueva actaNueva = new ActaNueva();
			if (tramiteInspeccion.getTiancodigo() != null) {
				actaNueva = new ActaNueva();
				actaNueva.setAncodigo(tramiteInspeccion.getTiancodigo());
				List<ActaNueva> listActaNueva = actaNuevaDao.findAll(actaNueva, null);
				if (listActaNueva != null && listActaNueva.size() > 0) {
					actaNueva = listActaNueva.get(0);
					plantillaTramiteINSDetalle.setNombreActa(actaNueva.getAncodac());
					plantillaTramiteINSDetalle.setFechaActa(Y41bUtils.formatearDateToString(actaNueva.getAnfecha(),
							Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));

					plantillaTramiteINSDetalle.setDeterminaciones(actaNueva.getAnespefificmu());

					String caracterMuestraCas = "";
					String caracterMuestraEus = "";
					if (actaNueva.getAncodcaractermu() != null && actaNueva.getAncodcaractermu()
							.equals(Y41bConstantes.INSPECCIONES_CARACTERMUESTRA_RECLAMENTARIA)) {

						caracterMuestraCas = appMessageSource.getMessage("plantilla.caractermuestra.reglamentaria",
								null, new Locale(Y41bConstantes.CASTELLANO));
						caracterMuestraEus = appMessageSource.getMessage("plantilla.caractermuestra.reglamentaria",
								null, new Locale(Y41bConstantes.EUSKERA));
					} else if (actaNueva.getAncodcaractermu() != null && actaNueva.getAncodcaractermu()
							.equals(Y41bConstantes.INSPECCIONES_CARACTERMUESTRA_INDICATIVA)) {
						caracterMuestraCas = appMessageSource.getMessage("plantilla.caractermuestra.indicativa", null,
								new Locale(Y41bConstantes.CASTELLANO));
						caracterMuestraEus = appMessageSource.getMessage("plantilla.caractermuestra.indicativa", null,
								new Locale(Y41bConstantes.EUSKERA));
					} else if (actaNueva.getAncodcaractermu() != null && actaNueva.getAncodcaractermu()
							.equals(Y41bConstantes.INSPECCIONES_CARACTERMUESTRA_OTROS)) {
						caracterMuestraCas = appMessageSource.getMessage("plantilla.caractermuestra.otros", null,
								new Locale(Y41bConstantes.CASTELLANO));
						caracterMuestraEus = appMessageSource.getMessage("plantilla.caractermuestra.otros", null,
								new Locale(Y41bConstantes.EUSKERA));
					}

					plantillaTramiteINSDetalle.setCaracterMuestraCas(caracterMuestraCas.toUpperCase());
					plantillaTramiteINSDetalle.setCaracterMuestraEus(caracterMuestraEus.toUpperCase());
				}

			}

			plantillaTramiteINSDetalle.setNombreCompareciente(
					new StringBuffer().append(Y41bUtils.trataNull(tramiteInspeccion.getTinombreinf())).append(" ")
							.append(Y41bUtils.trataNull(tramiteInspeccion.getTiape1inf())).append(" ")
							.append(Y41bUtils.trataNull(tramiteInspeccion.getTiape2inf())).toString());
			plantillaTramiteINSDetalle.setDniCompareciente(tramiteInspeccion.getTidniinf());
			plantillaTramiteINSDetalle.setEnCondicionDeCompareciente(tramiteInspeccion.getTiencondicioninf());

			CensoMonitor instructorAsignado = new CensoMonitor();
			instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

			if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
				instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
			}

			plantillaTramiteINSDetalle.setInspector(instructorAsignado.getMonombre());

			plantillaTramiteINSDetalle.setDocumentacionRequerida(tramiteInspeccion.getTidocumentacionrequerida());

			plantillaTramiteINSDetalle.setDocumentacionRequeridaE(tramiteInspeccion.getTidocumentacionrequeridae());

			if (tramiteInspeccion.getTinumdesin() != null) {
				plantillaTramiteINSDetalle
						.setUnidadesADesinmovilizar(Y41bUtils.trataNull(tramiteInspeccion.getTinumdesin().toString()));
			}

			// cargamos datos de las actas de inmovilizacion

			Pagination pagination = new Pagination();
			pagination.setSort("anfecha");
			pagination.setAscDsc("desc");
			actaNueva = new ActaNueva();
			actaNueva.setAncodins(actuacion.getAtcodigo());
			actaNueva.setAntipo("C");
			actaNueva.setAnestado("T");
			actaNueva.setAncodigo(tramiteInspeccion.getTiancodigo());

			List<ActaNueva> listActasNuevas = actaNuevaDao.findAllLike(actaNueva, pagination, false);

			if (listActasNuevas != null && listActasNuevas.size() > 0) {
				actaNueva = listActasNuevas.get(0);
				plantillaTramiteINSDetalle.setNombreActaInmo(actaNueva.getAncodac());
				plantillaTramiteINSDetalle.setFechaActaInmo(Y41bUtils.formatearDateToString(actaNueva.getAnfecha(),
						Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));

				plantillaTramiteINSDetalle
						.setUnidadesInmovilizadas(Y41bUtils.trataNull(actaNueva.getAnunidadesinmov().toString()));
			}

			// cargamos datos de las actas de toma de muestras

			actaNueva = new ActaNueva();
			actaNueva.setAncodins(actuacion.getAtcodigo());
			actaNueva.setAntipo("T");
			actaNueva.setAnestado("T");

			listActasNuevas = actaNuevaDao.findAllLike(actaNueva, pagination, false);
			if (listActasNuevas != null && listActasNuevas.size() > 0) {
				actaNueva = listActasNuevas.get(0);
				plantillaTramiteINSDetalle.setNombreActaToma(actaNueva.getAncodac());
				plantillaTramiteINSDetalle.setFechaActaToma(Y41bUtils.formatearDateToString(actaNueva.getAnfecha(),
						Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));
			}

			// datos del laboratorio
			if (tramiteInspeccion.getTilacodigo() != null) {
				Laboratorio laboratorio = new Laboratorio();
				laboratorio.setLacodigo(tramiteInspeccion.getTilacodigo());
				laboratorio = laboratorioService.find(laboratorio);

				plantillaTramiteINSDetalle.setLaNombre(laboratorio.getLanombre());
				plantillaTramiteINSDetalle.setLaCodigo(laboratorio.getLacodigo());

				// Creamos el campo direccion del establecimiento
				StringBuffer direccionCompleta = new StringBuffer();

				if (laboratorio.getNombreCalle() != null && !laboratorio.getNombreCalle().equals("")) {
					direccionCompleta.append(laboratorio.getNombreCalle());

					if (laboratorio.getNombrePortal() != null && !laboratorio.getNombrePortal().equals("")) {
						direccionCompleta.append(", ").append(laboratorio.getNombrePortal());
					}
					if (laboratorio.getNombrePiso() != null && !laboratorio.getNombrePiso().equals("")) {
						direccionCompleta.append(" ").append(laboratorio.getNombrePiso());
					}
				} else {
					if (laboratorio.getDireccionNocapv() != null && !laboratorio.getDireccionNocapv().equals("")) {
						direccionCompleta.append(laboratorio.getDireccionNocapv());
					} else {
						direccionCompleta.append(Y41bUtils.trataNull(laboratorio.getLanodir()));
					}
				}

				plantillaTramiteINSDetalle.setLaNoDir(Y41bUtils.trataNull(direccionCompleta.toString()));

				plantillaTramiteINSDetalle.setLaNrCoPo(laboratorio.getNombreCp());

				plantillaTramiteINSDetalle.setLaLocalidad(laboratorio.getNombreLocalidad());

				plantillaTramiteINSDetalle.setLaMunicipio(laboratorio.getNombreMunicipio());
			}

			plantillaTramiteINSDetalle.setInforme(tramiteInspeccion.getTiinforme());

			plantillaTramiteINSDetalle.setFechaActuacion(Y41bUtils.formatearDateToString(
					tramiteInspeccion.getTifechaemiinf(), Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));

		}

		// ESTABLECIMIENTO VISITADO
		Intervinientes intervinientesV = new Intervinientes();
		intervinientesV.setIdExpediente(actuacion.getAtcodigo());
		intervinientesV.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

		List<Intervinientes> listIntervinientesV = this.intervinientesDao.findAll(intervinientesV, null);

		Intervinientes intervinientesVAux = null;
		if (listIntervinientesV.size() > 0) {
			intervinientesVAux = listIntervinientesV.get(0);

			plantillaTramiteINSDetalle.setEsnifEstablecimientoVisitado(intervinientesVAux.getNif());

			plantillaTramiteINSDetalle
					.setEsnombreLocalidadEstablecimientoVisitado(intervinientesVAux.getNombreLocalidad());

			plantillaTramiteINSDetalle
					.setEsnombreMunicipioEstablecimientoVisitado(intervinientesVAux.getNombreMunicipio());

			plantillaTramiteINSDetalle
					.setEsnombreProvinciaEstablecimientoVisitado(intervinientesVAux.getNombreProvincia());

			plantillaTramiteINSDetalle.setEsnombreEstablecimientoVisitado(intervinientesVAux.getNombre());

			plantillaTramiteINSDetalle.setEsTelefonoEstablecimientoVisitado(intervinientesVAux.getNrtel());

			plantillaTramiteINSDetalle.setEsFaxEstablecimientoVisitado(intervinientesVAux.getNrtel2());

			plantillaTramiteINSDetalle.setEsMailEstablecimientoVisitado(intervinientesVAux.getCoem());

			plantillaTramiteINSDetalle.setEsCPEstablecimientoVisitado(intervinientesVAux.getNombreCp());

			plantillaTramiteINSDetalle.setEsSectorEstablecimientoVisitado(intervinientesVAux.getSenombre());

			plantillaTramiteINSDetalle.setEsNombreComercialEstablecimientoVisitado(intervinientesVAux.getEsnoco());

		}

		// ESTABLECIMIENTO RESPONSABLE

		Intervinientes intervinientesR = new Intervinientes();
		intervinientesR.setIdExpediente(actuacion.getAtcodigo());

		intervinientesR.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);

		List<Intervinientes> listIntervinientesR = this.intervinientesDao.findAll(intervinientesR, null);

		// Creamos el campo direccion del establecimiento
		StringBuffer direccionCompletaV = new StringBuffer();

		if (intervinientesVAux != null && intervinientesVAux.getNombreCalle() != null
				&& !intervinientesVAux.getNombreCalle().equals("")) {
			direccionCompletaV.append(intervinientesVAux.getNombreCalle());

			if (intervinientesVAux.getNombrePortal() != null && intervinientesVAux.getNombrePortal() != null
					&& !intervinientesVAux.getNombrePortal().equals("")) {
				direccionCompletaV.append(", ").append(intervinientesVAux.getNombrePortal());
			}
			if (intervinientesVAux.getNombrePiso() != null && intervinientesVAux.getNombrePiso() != null
					&& !intervinientesVAux.getNombrePiso().equals("")) {
				direccionCompletaV.append(" ").append(intervinientesVAux.getNombrePiso());
			}
		} else {
			if (intervinientesVAux.getDireccionNocapv() != null && intervinientesVAux.getDireccionNocapv() != null
					&& !intervinientesVAux.getDireccionNocapv().equals("")) {
				direccionCompletaV.append(intervinientesVAux.getDireccionNocapv());
			} else {
				direccionCompletaV.append(Y41bUtils.trataNull(intervinientesVAux.getDireccionAntigua()));
			}
		}

		plantillaTramiteINSDetalle
				.setEsdireccionEstablecimientoVisitado(Y41bUtils.trataNull(direccionCompletaV.toString()));

		Intervinientes intervinientesRAux = null;
		if (listIntervinientesR.size() > 0) {
			intervinientesRAux = listIntervinientesR.get(0);
		}
		// if (intervinientesRAux == null) {
		// throw new Y41bUDAException("error.inspeccion.nohayresponsable",
		// true, new Exception());
		// }

		if (intervinientesRAux != null) {

			// Creamos el campo direccion del establecimiento
			StringBuffer direccionCompleta = new StringBuffer();

			if (intervinientesRAux.getNombreCalle() != null && !intervinientesRAux.getNombreCalle().equals("")) {
				direccionCompleta.append(intervinientesRAux.getNombreCalle());

				if (intervinientesRAux.getNombrePortal() != null && intervinientesRAux.getNombrePortal() != null
						&& !intervinientesRAux.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(intervinientesRAux.getNombrePortal());
				}
				if (intervinientesRAux.getNombrePiso() != null && intervinientesRAux.getNombrePiso() != null
						&& !intervinientesRAux.getNombrePiso().equals("")) {
					direccionCompleta.append(" ").append(intervinientesRAux.getNombrePiso());
				}
			} else {
				if (intervinientesRAux.getDireccionNocapv() != null && intervinientesRAux.getDireccionNocapv() != null
						&& !intervinientesRAux.getDireccionNocapv().equals("")) {
					direccionCompleta.append(intervinientesRAux.getDireccionNocapv());
				} else {
					direccionCompleta.append(Y41bUtils.trataNull(intervinientesRAux.getDireccionAntigua()));
				}
			}

			plantillaTramiteINSDetalle.setEsnifResponsableProducto(intervinientesRAux.getNif());

			plantillaTramiteINSDetalle.setEsnombreResponsableProducto(intervinientesRAux.getNombre());

			plantillaTramiteINSDetalle
					.setEsdireccionResponsableProducto(Y41bUtils.trataNull(direccionCompleta.toString()));

			plantillaTramiteINSDetalle.setEsnombreMunicipioResponsableProducto(intervinientesRAux.getNombreMunicipio());
			plantillaTramiteINSDetalle.setEsnombreProvinciaResponsableProducto(intervinientesRAux.getNombreProvincia());
			plantillaTramiteINSDetalle.setEsnombreLocalidadResponsableProducto(intervinientesRAux.getNombreLocalidad());

			plantillaTramiteINSDetalle.setEsnombreCpResponsableProducto(intervinientesRAux.getNombreCp());

			plantillaTramiteINSDetalle.setEsnocoResponsableProducto(intervinientesRAux.getEsnoco());

		}

		// fecha de hoy
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
		// Formateamos las fecha a castellano e euskera
		// fecha de hoy texto
		plantillaTramiteINSDetalle.setFechaHoyCas(Y41bUtils.formatearDateToString(todayWithZeroTime,
				Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
		plantillaTramiteINSDetalle.setFechaHoyEus(Y41bUtils.formatearDateToStringEuskera(todayWithZeroTime,
				Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

		// Director
		CensoMonitor censoMonitorDirector = new CensoMonitor();

		try {
			censoMonitorDirector = this.censoMonitorDao.findDirectorInspecciones();
			if (censoMonitorDirector.getMonombre() == null) {
				throw new Y41bUDAException("error.solicitud.tramite.nodirector", true, new Exception());
			}
		} catch (Exception e) {
			censoMonitorDirector = new CensoMonitor();
			throw new Y41bUDAException("error.solicitud.tramite.nodirector", true, new Exception());
		}

		plantillaTramiteINSDetalle.setDirector(censoMonitorDirector.getMonombre());
		// recuperar texto de properties
		plantillaTramiteINSDetalle.setTextoPuestoDirectorCas(
				appMessageSource.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.CASTELLANO)));
		plantillaTramiteINSDetalle.setTextoPuestoDirectorEus(
				appMessageSource.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.EUSKERA)));

		Actdec actdec = new Actdec();
		actdec.setAdcoat(tramiteComun.getIdExpediente());

		actdec = this.actdecDao.findDecisionInspeccion(actdec);

		if (actdec != null) {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(actdec.getAdcoor());
			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			// Coordinador
			CensoMonitor censoMonitorCoordinador = new CensoMonitor();
			try {

				censoMonitorCoordinador.setOrganismo(organismo);

				censoMonitorCoordinador = this.censoMonitorDao.findCoordinadorInspecciones(censoMonitorCoordinador);
				if (censoMonitorCoordinador.getMonombre() == null) {
					throw new Y41bUDAException("error.solicitud.tramite.nocoordinador", true, new Exception());
				}
			} catch (Exception e) {
				censoMonitorCoordinador = new CensoMonitor();
				throw new Y41bUDAException("error.solicitud.tramite.nocoordinador", true, new Exception());
			}

			plantillaTramiteINSDetalle.setCoordinador(censoMonitorCoordinador.getMonombre());

			if (censoMonitorCoordinador.getOrganismo() != null
					&& censoMonitorCoordinador.getOrganismo().getCodOrg() != null) {
				String strTerritorio = censoMonitorCoordinador.getOrganismo().getCodOrg();

				strTerritorio = strTerritorio.substring(0, 2);

				if (censoMonitorCoordinador.getOrganismo().getCodOrg()
						.equalsIgnoreCase(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
					// recuperar texto de properties
					plantillaTramiteINSDetalle.setTextoPuestoCoordinadorCas(appMessageSource.getMessage(
							"plantilla.puestocoordinador01A101", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteINSDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador01A101", null, new Locale(Y41bConstantes.EUSKERA)));
				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_ARABA)) {
					// recuperar texto de properties
					plantillaTramiteINSDetalle.setTextoPuestoCoordinadorCas(appMessageSource
							.getMessage("plantilla.puestocoordinador01", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteINSDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador01", null, new Locale(Y41bConstantes.EUSKERA)));

				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
					// recuperar texto de properties
					plantillaTramiteINSDetalle.setTextoPuestoCoordinadorCas(appMessageSource
							.getMessage("plantilla.puestocoordinador48", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteINSDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador48", null, new Locale(Y41bConstantes.EUSKERA)));

				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)) {
					// recuperar texto de properties
					plantillaTramiteINSDetalle.setTextoPuestoCoordinadorCas(appMessageSource
							.getMessage("plantilla.puestocoordinador20", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteINSDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador20", null, new Locale(Y41bConstantes.EUSKERA)));
				}
			}

			plantillaTramiteINSDetalle.setCodOrg(organismo.getCodOrg());
			plantillaTramiteINSDetalle.setNombreEu(organismo.getNombreEu());
			plantillaTramiteINSDetalle.setNombreEs(organismo.getNombreEs());
			plantillaTramiteINSDetalle.setNombreCalle(organismo.getNombreCalle());
			plantillaTramiteINSDetalle.setNoraCpId(organismo.getNoraCpId());
			plantillaTramiteINSDetalle.setNombreMunicipio(organismo.getNombreMunicipio());
			plantillaTramiteINSDetalle.setNombrePortal(organismo.getNombrePortal());
			plantillaTramiteINSDetalle.setNombrePiso(organismo.getCompleDirec());

			if (organismo.getCodOrg().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
				plantillaTramiteINSDetalle.setTelefonoOrganismo(organismo.getTelefono2());
			} else {
				plantillaTramiteINSDetalle.setTelefonoOrganismo(organismo.getTelefono());
			}

			plantillaTramiteINSDetalle.setFaxOrganismo(organismo.getFax());
			plantillaTramiteINSDetalle.setEmailOrganismo(organismo.getEmail());
			plantillaTramiteINSDetalle.setWebOrganismo(organismo.getUrl());

			// Creamos el campo direccion del organismo conectado
			StringBuffer direccionCompleta = new StringBuffer();

			if (plantillaTramiteINSDetalle.getNombreCalle() != null
					&& !plantillaTramiteINSDetalle.getNombreCalle().equals("")) {
				direccionCompleta.append(plantillaTramiteINSDetalle.getNombreCalle());

				if (plantillaTramiteINSDetalle.getNombrePortal() != null
						&& !plantillaTramiteINSDetalle.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(plantillaTramiteINSDetalle.getNombrePortal());
				}
			}

			plantillaTramiteINSDetalle.setDireccionOrganismo(Y41bUtils.trataNull(direccionCompleta.toString()));

			// Creamos el campo codigo postal y municipio del organismo
			// conectado
			StringBuffer cpMunicipio = new StringBuffer();

			if (plantillaTramiteINSDetalle.getNombreCp() != null
					&& !plantillaTramiteINSDetalle.getNombreCp().equals("")) {
				cpMunicipio.append(plantillaTramiteINSDetalle.getNombreCp());

				if (plantillaTramiteINSDetalle.getNombreMunicipio() != null
						&& !plantillaTramiteINSDetalle.getNombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(plantillaTramiteINSDetalle.getNombreMunicipio());
				}
			} else if (plantillaTramiteINSDetalle.getNombreMunicipio() != null
					&& !plantillaTramiteINSDetalle.getNombreMunicipio().equals("")) {
				cpMunicipio.append(plantillaTramiteINSDetalle.getNombreMunicipio());
			}

			plantillaTramiteINSDetalle.setCpMunicipioOrganismo(Y41bUtils.trataNull(cpMunicipio.toString()));
		}

		// REPRESENTANTE
		Intervinientes intervinientesAux = new Intervinientes();
		intervinientesAux.setIdExpediente(actuacion.getAtcodigo());

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientesAux, null);

		if (listIntervinientes.size() > 1) {
			for (Intervinientes intervinientes : listIntervinientes) {

				if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO)) {
					if (actuacion.getAtdestnotificavisitado() != null && actuacion.getAtdestnotificavisitado()
							.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

						// buscar el representante
						intervinientesAux = new Intervinientes();
						intervinientesAux.setIdExpediente(actuacion.getAtcodigo());
						intervinientesAux.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO);
						intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

						if (intervinientesAux != null && Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {

							StringBuffer nombreCompleto = new StringBuffer();

							nombreCompleto.append(intervinientesAux.getNombre());

							if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
								nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
							}

							if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
								nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
							}

							plantillaTramiteINSDetalle
									.setEsnombreEstablecimientoVisitado(Y41bUtils.trataNull(nombreCompleto.toString()));
							plantillaTramiteINSDetalle.setEsNombreComercialEstablecimientoVisitado(
									Y41bUtils.trataNull(nombreCompleto.toString()));
							plantillaTramiteINSDetalle.setEsnifEstablecimientoVisitado(intervinientesAux.getNif());

							plantillaTramiteINSDetalle.setEsnombreProvinciaEstablecimientoVisitado(
									intervinientesAux.getNombreProvincia());
							plantillaTramiteINSDetalle.setEsnombreMunicipioEstablecimientoVisitado(
									intervinientesAux.getNombreMunicipio());
							plantillaTramiteINSDetalle.setEsnombreLocalidadEstablecimientoVisitado(
									intervinientesAux.getNombreLocalidad());

							plantillaTramiteINSDetalle.setEsCPEstablecimientoVisitado(intervinientesAux.getNombreCp());

							plantillaTramiteINSDetalle
									.setEsTelefonoEstablecimientoVisitado(intervinientesAux.getNrtel());
							plantillaTramiteINSDetalle.setEsFaxEstablecimientoVisitado(intervinientesAux.getNrtel2());
							plantillaTramiteINSDetalle.setEsMailEstablecimientoVisitado(intervinientesAux.getCoem());

							// Creamos el campo direccion del establecimiento
							StringBuffer direccionCompleta = new StringBuffer();

							if (intervinientesAux != null && intervinientesAux.getNombreCalle() != null
									&& !intervinientesAux.getNombreCalle().equals("")) {
								direccionCompleta.append(intervinientesAux.getNombreCalle());

								if (intervinientesAux.getNombrePortal() != null
										&& intervinientesAux.getNombrePortal() != null
										&& !intervinientesAux.getNombrePortal().equals("")) {
									direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
								}
								if (intervinientesAux.getNombrePiso() != null
										&& intervinientesAux.getNombrePiso() != null
										&& !intervinientesAux.getNombrePiso().equals("")) {
									direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
								}
							} else {
								if (intervinientesAux.getDireccionNocapv() != null
										&& intervinientesAux.getDireccionNocapv() != null
										&& !intervinientesAux.getDireccionNocapv().equals("")) {
									direccionCompleta.append(intervinientesAux.getDireccionNocapv());
								} else {
									direccionCompleta
											.append(Y41bUtils.trataNull(intervinientesAux.getDireccionAntigua()));
								}
							}

							plantillaTramiteINSDetalle.setEsdireccionEstablecimientoVisitado(
									Y41bUtils.trataNull(direccionCompleta.toString()));

						} else {
							// buscar el representante
							intervinientesAux = new Intervinientes();
							intervinientesAux.setIdExpediente(actuacion.getAtcodigo());
							intervinientesAux.setTipoInterviniente(
									Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO);
							intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

							if (intervinientesAux != null
									&& Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {

								StringBuffer nombreCompleto = new StringBuffer();

								nombreCompleto.append(intervinientesAux.getNombre());

								if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
								}

								if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
								}

								plantillaTramiteINSDetalle.setEsnombreEstablecimientoVisitado(
										Y41bUtils.trataNull(nombreCompleto.toString()));
								plantillaTramiteINSDetalle.setEsNombreComercialEstablecimientoVisitado(
										Y41bUtils.trataNull(nombreCompleto.toString()));
								plantillaTramiteINSDetalle.setEsnifEstablecimientoVisitado(intervinientesAux.getNif());

								plantillaTramiteINSDetalle.setEsnombreProvinciaEstablecimientoVisitado(
										intervinientesAux.getNombreProvincia());
								plantillaTramiteINSDetalle.setEsnombreMunicipioEstablecimientoVisitado(
										intervinientesAux.getNombreMunicipio());
								plantillaTramiteINSDetalle.setEsnombreLocalidadEstablecimientoVisitado(
										intervinientesAux.getNombreLocalidad());

								plantillaTramiteINSDetalle
										.setEsCPEstablecimientoVisitado(intervinientesAux.getNombreCp());

								plantillaTramiteINSDetalle
										.setEsTelefonoEstablecimientoVisitado(intervinientesAux.getNrtel());
								plantillaTramiteINSDetalle
										.setEsFaxEstablecimientoVisitado(intervinientesAux.getNrtel2());
								plantillaTramiteINSDetalle
										.setEsMailEstablecimientoVisitado(intervinientesAux.getCoem());

								// Creamos el campo direccion del
								// establecimiento
								StringBuffer direccionCompleta = new StringBuffer();

								if (intervinientesAux != null && intervinientesAux.getNombreCalle() != null
										&& !intervinientesAux.getNombreCalle().equals("")) {
									direccionCompleta.append(intervinientesAux.getNombreCalle());

									if (intervinientesAux.getNombrePortal() != null
											&& intervinientesAux.getNombrePortal() != null
											&& !intervinientesAux.getNombrePortal().equals("")) {
										direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
									}
									if (intervinientesAux.getNombrePiso() != null
											&& intervinientesAux.getNombrePiso() != null
											&& !intervinientesAux.getNombrePiso().equals("")) {
										direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
									}
								} else {
									if (intervinientesAux.getDireccionNocapv() != null
											&& intervinientesAux.getDireccionNocapv() != null
											&& !intervinientesAux.getDireccionNocapv().equals("")) {
										direccionCompleta.append(intervinientesAux.getDireccionNocapv());
									} else {
										direccionCompleta
												.append(Y41bUtils.trataNull(intervinientesAux.getDireccionAntigua()));
									}
								}

								plantillaTramiteINSDetalle.setEsdireccionEstablecimientoVisitado(
										Y41bUtils.trataNull(direccionCompleta.toString()));

							}
						}
					}
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)) {
					if (actuacion.getAtdestnotificaresponsable() != null && actuacion.getAtdestnotificaresponsable()
							.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

						// buscar el representante
						intervinientesAux = new Intervinientes();
						intervinientesAux.setIdExpediente(actuacion.getAtcodigo());
						intervinientesAux.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE);
						intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

						if (intervinientesAux != null && Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {

							StringBuffer nombreCompleto = new StringBuffer();

							nombreCompleto.append(intervinientesAux.getNombre());

							if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
								nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
							}

							if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
								nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
							}

							plantillaTramiteINSDetalle
									.setEsnombreResponsableProducto(Y41bUtils.trataNull(nombreCompleto.toString()));
							plantillaTramiteINSDetalle
									.setEsnocoResponsableProducto(Y41bUtils.trataNull(nombreCompleto.toString()));
							plantillaTramiteINSDetalle.setEsnifResponsableProducto(intervinientesAux.getNif());

							plantillaTramiteINSDetalle
									.setEsnombreProvinciaResponsableProducto(intervinientesAux.getNombreProvincia());
							plantillaTramiteINSDetalle
									.setEsnombreMunicipioResponsableProducto(intervinientesAux.getNombreMunicipio());
							plantillaTramiteINSDetalle
									.setEsnombreLocalidadResponsableProducto(intervinientesAux.getNombreLocalidad());

							plantillaTramiteINSDetalle
									.setEsnombreCpResponsableProducto(intervinientesAux.getNombreCp());

							plantillaTramiteINSDetalle.setEsnrtelResponsableProducto(intervinientesAux.getNrtel());
							plantillaTramiteINSDetalle.setEsnrtel2ResponsableProducto(intervinientesAux.getNrtel2());
							plantillaTramiteINSDetalle.setEstecoemResponsableProducto(intervinientesAux.getCoem());

							// Creamos el campo direccion del establecimiento
							StringBuffer direccionCompleta = new StringBuffer();

							if (intervinientesAux != null && intervinientesAux.getNombreCalle() != null
									&& !intervinientesAux.getNombreCalle().equals("")) {
								direccionCompleta.append(intervinientesAux.getNombreCalle());

								if (intervinientesAux.getNombrePortal() != null
										&& intervinientesAux.getNombrePortal() != null
										&& !intervinientesAux.getNombrePortal().equals("")) {
									direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
								}
								if (intervinientesAux.getNombrePiso() != null
										&& intervinientesAux.getNombrePiso() != null
										&& !intervinientesAux.getNombrePiso().equals("")) {
									direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
								}
							} else {
								if (intervinientesAux.getDireccionNocapv() != null
										&& intervinientesAux.getDireccionNocapv() != null
										&& !intervinientesAux.getDireccionNocapv().equals("")) {
									direccionCompleta.append(intervinientesAux.getDireccionNocapv());
								} else {
									direccionCompleta
											.append(Y41bUtils.trataNull(intervinientesAux.getDireccionAntigua()));
								}
							}

							plantillaTramiteINSDetalle.setEsdireccionResponsableProducto(
									Y41bUtils.trataNull(direccionCompleta.toString()));

						} else {
							// buscar el representante
							intervinientesAux = new Intervinientes();
							intervinientesAux.setIdExpediente(actuacion.getAtcodigo());
							intervinientesAux.setTipoInterviniente(
									Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO);
							intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

							if (intervinientesAux != null
									&& Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {

								StringBuffer nombreCompleto = new StringBuffer();

								nombreCompleto.append(intervinientesAux.getNombre());

								if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
								}

								if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
								}

								plantillaTramiteINSDetalle
										.setEsnombreResponsableProducto(Y41bUtils.trataNull(nombreCompleto.toString()));
								plantillaTramiteINSDetalle
										.setEsnocoResponsableProducto(Y41bUtils.trataNull(nombreCompleto.toString()));
								plantillaTramiteINSDetalle.setEsnifResponsableProducto(intervinientesAux.getNif());

								plantillaTramiteINSDetalle.setEsnombreProvinciaResponsableProducto(
										intervinientesAux.getNombreProvincia());
								plantillaTramiteINSDetalle.setEsnombreMunicipioResponsableProducto(
										intervinientesAux.getNombreMunicipio());
								plantillaTramiteINSDetalle.setEsnombreLocalidadResponsableProducto(
										intervinientesAux.getNombreLocalidad());

								plantillaTramiteINSDetalle
										.setEsnombreCpResponsableProducto(intervinientesAux.getNombreCp());

								plantillaTramiteINSDetalle.setEsnrtelResponsableProducto(intervinientesAux.getNrtel());
								plantillaTramiteINSDetalle
										.setEsnrtel2ResponsableProducto(intervinientesAux.getNrtel2());
								plantillaTramiteINSDetalle.setEstecoemResponsableProducto(intervinientesAux.getCoem());

								// Creamos el campo direccion del
								// establecimiento
								StringBuffer direccionCompleta = new StringBuffer();

								if (intervinientesAux != null && intervinientesAux.getNombreCalle() != null
										&& !intervinientesAux.getNombreCalle().equals("")) {
									direccionCompleta.append(intervinientesAux.getNombreCalle());

									if (intervinientesAux.getNombrePortal() != null
											&& intervinientesAux.getNombrePortal() != null
											&& !intervinientesAux.getNombrePortal().equals("")) {
										direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
									}
									if (intervinientesAux.getNombrePiso() != null
											&& intervinientesAux.getNombrePiso() != null
											&& !intervinientesAux.getNombrePiso().equals("")) {
										direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
									}
								} else {
									if (intervinientesAux.getDireccionNocapv() != null
											&& intervinientesAux.getDireccionNocapv() != null
											&& !intervinientesAux.getDireccionNocapv().equals("")) {
										direccionCompleta.append(intervinientesAux.getDireccionNocapv());
									} else {
										direccionCompleta
												.append(Y41bUtils.trataNull(intervinientesAux.getDireccionAntigua()));
									}
								}

								plantillaTramiteINSDetalle.setEsdireccionResponsableProducto(
										Y41bUtils.trataNull(direccionCompleta.toString()));

							}
						}
					}
				}
			}
		}

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(actuacion.getAtcodigo());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO);

		intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientes);

		if (intervinientesAux != null) {
			StringBuffer nombredestinatario = new StringBuffer();
			nombredestinatario.append(intervinientesAux.getNombre());

			if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
				nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
			}

			if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
				nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
			}

			plantillaTramiteINSDetalle
					.setNombreRepresentanteVisitado(Y41bUtils.trataNull(nombredestinatario.toString()));
			plantillaTramiteINSDetalle.setNifRepresentanteVisitado(intervinientesAux.getNif());
		}

		intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(actuacion.getAtcodigo());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE);

		intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientes);

		if (intervinientesAux != null) {
			StringBuffer nombredestinatario = new StringBuffer();
			nombredestinatario.append(intervinientesAux.getNombre());

			if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
				nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
			}

			if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
				nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
			}

			plantillaTramiteINSDetalle
					.setNombreRepresentanteResponsable(Y41bUtils.trataNull(nombredestinatario.toString()));
			plantillaTramiteINSDetalle.setNifRepresentanteResponsable(intervinientesAux.getNif());
		}

		if (tramiteInspeccion != null && tramiteInspeccion.getTiorigenalegacion() != null) {
			if (tramiteInspeccion.getTiorigenalegacion()
					.equals(Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTOVISITADO)) {
				intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(actuacion.getAtcodigo());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

				intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientes);

				if (intervinientesAux != null) {
					StringBuffer nombredestinatario = new StringBuffer();
					nombredestinatario.append(intervinientesAux.getNombre());

					if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
					}

					if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
					}

					plantillaTramiteINSDetalle.setNombreTitular(Y41bUtils.trataNull(nombredestinatario.toString()));
					plantillaTramiteINSDetalle.setNombreComercialTitular("");

					plantillaTramiteINSDetalle.setIdentificacionTitular(intervinientesAux.getNif());
					plantillaTramiteINSDetalle.setNombreProvinciaTitular(intervinientesAux.getNombreProvincia());
					plantillaTramiteINSDetalle.setNombreMunicipioTitular(intervinientesAux.getNombreMunicipio());
					plantillaTramiteINSDetalle.setNombreLocalidadTitular(intervinientesAux.getNombreLocalidad());
					plantillaTramiteINSDetalle.setNombreCalleTitular(intervinientesAux.getNombreCalle());
					plantillaTramiteINSDetalle.setNombreCpTitular(intervinientesAux.getNombreCp());
					plantillaTramiteINSDetalle.setNombrePortalTitular(intervinientesAux.getNombrePortal());
					plantillaTramiteINSDetalle.setNombrePisoTitular(intervinientesAux.getNombrePiso());

					plantillaTramiteINSDetalle.setDireccion_nocapvTitular(intervinientesAux.getDireccionNocapv());

					// Creamos el campo direccion del establecimiento
					StringBuffer direccionCompleta = new StringBuffer();

					if (intervinientesAux.getNombreCalle() != null && !intervinientesAux.getNombreCalle().equals("")) {
						direccionCompleta.append(intervinientesAux.getNombreCalle());

						if (intervinientesAux.getNombrePortal() != null
								&& !intervinientesAux.getNombrePortal().equals("")) {
							direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
						}
						if (intervinientesAux.getNombrePiso() != null
								&& !intervinientesAux.getNombrePiso().equals("")) {
							direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
						}
					} else {
						if (intervinientesAux.getDireccionNocapv() != null
								&& !intervinientesAux.getDireccionNocapv().equals("")) {
							direccionCompleta.append(intervinientesAux.getDireccionNocapv());
						}
					}

					plantillaTramiteINSDetalle.setDireccionTitular(Y41bUtils.trataNull(direccionCompleta.toString()));

					// Creamos el campo codigo postal y municipio del
					// establecimiento
					StringBuffer cpMunicipio = new StringBuffer();

					if (intervinientesAux.getNombreCp() != null && !intervinientesAux.getNombreCp().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreCp());

						if (intervinientesAux.getNombreMunicipio() != null
								&& !intervinientesAux.getNombreMunicipio().equals("")) {
							cpMunicipio.append(" ").append(intervinientesAux.getNombreMunicipio());
						}
					} else if (intervinientesAux.getNombreMunicipio() != null
							&& !intervinientesAux.getNombreMunicipio().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreMunicipio());
					}

					plantillaTramiteINSDetalle.setCpMunicipioTitular(Y41bUtils.trataNull(cpMunicipio.toString()));
				}

				intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
				intervinientes.setTipoInterviniente(
						Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO);

				intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientes);

				if (intervinientesAux != null) {
					StringBuffer nombredestinatario = new StringBuffer();
					nombredestinatario.append(intervinientesAux.getNombre());

					if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
					}

					if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
					}

					plantillaTramiteINSDetalle
							.setNombreRepresentanteNoValidado(Y41bUtils.trataNull(nombredestinatario.toString()));
					plantillaTramiteINSDetalle.setNombreComercialRepresentanteNoValidado("");

					plantillaTramiteINSDetalle.setIdentificacionRepresentanteNoValidado(intervinientesAux.getNif());
					plantillaTramiteINSDetalle
							.setNombreProvinciaRepresentanteNoValidado(intervinientesAux.getNombreProvincia());
					plantillaTramiteINSDetalle
							.setNombreMunicipioRepresentanteNoValidado(intervinientesAux.getNombreMunicipio());
					plantillaTramiteINSDetalle
							.setNombreLocalidadRepresentanteNoValidado(intervinientesAux.getNombreLocalidad());
					plantillaTramiteINSDetalle
							.setNombreCalleRepresentanteNoValidado(intervinientesAux.getNombreCalle());
					plantillaTramiteINSDetalle.setNombreCpRepresentanteNoValidado(intervinientesAux.getNombreCp());
					plantillaTramiteINSDetalle
							.setNombrePortalRepresentanteNoValidado(intervinientesAux.getNombrePortal());
					plantillaTramiteINSDetalle.setNombrePisoRepresentanteNoValidado(intervinientesAux.getNombrePiso());

					plantillaTramiteINSDetalle
							.setDireccion_nocapvRepresentanteNoValidado(intervinientesAux.getDireccionNocapv());

					// Creamos el campo direccion del establecimiento
					StringBuffer direccionCompleta = new StringBuffer();

					if (intervinientesAux.getNombreCalle() != null && !intervinientesAux.getNombreCalle().equals("")) {
						direccionCompleta.append(intervinientesAux.getNombreCalle());

						if (intervinientesAux.getNombrePortal() != null
								&& !intervinientesAux.getNombrePortal().equals("")) {
							direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
						}
						if (intervinientesAux.getNombrePiso() != null
								&& !intervinientesAux.getNombrePiso().equals("")) {
							direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
						}
					} else {
						if (intervinientesAux.getDireccionNocapv() != null
								&& !intervinientesAux.getDireccionNocapv().equals("")) {
							direccionCompleta.append(intervinientesAux.getDireccionNocapv());
						}
					}

					plantillaTramiteINSDetalle
							.setDireccionRepresentanteNoValidado(Y41bUtils.trataNull(direccionCompleta.toString()));

					// Creamos el campo codigo postal y municipio del
					// establecimiento
					StringBuffer cpMunicipio = new StringBuffer();

					if (intervinientesAux.getNombreCp() != null && !intervinientesAux.getNombreCp().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreCp());

						if (intervinientesAux.getNombreMunicipio() != null
								&& !intervinientesAux.getNombreMunicipio().equals("")) {
							cpMunicipio.append(" ").append(intervinientesAux.getNombreMunicipio());
						}
					} else if (intervinientesAux.getNombreMunicipio() != null
							&& !intervinientesAux.getNombreMunicipio().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreMunicipio());
					}

					plantillaTramiteINSDetalle
							.setCpMunicipioRepresentanteNoValidado(Y41bUtils.trataNull(cpMunicipio.toString()));
				}
			} else if (tramiteInspeccion.getTiorigenalegacion()
					.equals(Y41bConstantes.DESTINO_REQUERIMIENTO_ESTABLECIMIENTORESPONSABLE)) {
				intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(actuacion.getAtcodigo());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);

				intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientes);

				if (intervinientesAux != null) {
					StringBuffer nombredestinatario = new StringBuffer();
					nombredestinatario.append(intervinientesAux.getNombre());

					if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
					}

					if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
					}

					plantillaTramiteINSDetalle.setNombreTitular(Y41bUtils.trataNull(nombredestinatario.toString()));
					plantillaTramiteINSDetalle.setNombreComercialTitular("");

					plantillaTramiteINSDetalle.setIdentificacionTitular(intervinientesAux.getNif());
					plantillaTramiteINSDetalle.setNombreProvinciaTitular(intervinientesAux.getNombreProvincia());
					plantillaTramiteINSDetalle.setNombreMunicipioTitular(intervinientesAux.getNombreMunicipio());
					plantillaTramiteINSDetalle.setNombreLocalidadTitular(intervinientesAux.getNombreLocalidad());
					plantillaTramiteINSDetalle.setNombreCalleTitular(intervinientesAux.getNombreCalle());
					plantillaTramiteINSDetalle.setNombreCpTitular(intervinientesAux.getNombreCp());
					plantillaTramiteINSDetalle.setNombrePortalTitular(intervinientesAux.getNombrePortal());
					plantillaTramiteINSDetalle.setNombrePisoTitular(intervinientesAux.getNombrePiso());

					plantillaTramiteINSDetalle.setDireccion_nocapvTitular(intervinientesAux.getDireccionNocapv());

					// Creamos el campo direccion del establecimiento
					StringBuffer direccionCompleta = new StringBuffer();

					if (intervinientesAux.getNombreCalle() != null && !intervinientesAux.getNombreCalle().equals("")) {
						direccionCompleta.append(intervinientesAux.getNombreCalle());

						if (intervinientesAux.getNombrePortal() != null
								&& !intervinientesAux.getNombrePortal().equals("")) {
							direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
						}
						if (intervinientesAux.getNombrePiso() != null
								&& !intervinientesAux.getNombrePiso().equals("")) {
							direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
						}
					} else {
						if (intervinientesAux.getDireccionNocapv() != null
								&& !intervinientesAux.getDireccionNocapv().equals("")) {
							direccionCompleta.append(intervinientesAux.getDireccionNocapv());
						}
					}

					plantillaTramiteINSDetalle.setDireccionTitular(Y41bUtils.trataNull(direccionCompleta.toString()));

					// Creamos el campo codigo postal y municipio del
					// establecimiento
					StringBuffer cpMunicipio = new StringBuffer();

					if (intervinientesAux.getNombreCp() != null && !intervinientesAux.getNombreCp().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreCp());

						if (intervinientesAux.getNombreMunicipio() != null
								&& !intervinientesAux.getNombreMunicipio().equals("")) {
							cpMunicipio.append(" ").append(intervinientesAux.getNombreMunicipio());
						}
					} else if (intervinientesAux.getNombreMunicipio() != null
							&& !intervinientesAux.getNombreMunicipio().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreMunicipio());
					}

					plantillaTramiteINSDetalle.setCpMunicipioTitular(Y41bUtils.trataNull(cpMunicipio.toString()));
				}

				intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
				intervinientes.setTipoInterviniente(
						Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO);

				intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientes);

				if (intervinientesAux != null) {
					StringBuffer nombredestinatario = new StringBuffer();
					nombredestinatario.append(intervinientesAux.getNombre());

					if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido1());
					}

					if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
						nombredestinatario.append(" ").append(intervinientesAux.getApellido2());
					}

					plantillaTramiteINSDetalle
							.setNombreRepresentanteNoValidado(Y41bUtils.trataNull(nombredestinatario.toString()));
					plantillaTramiteINSDetalle.setNombreComercialRepresentanteNoValidado("");

					plantillaTramiteINSDetalle.setIdentificacionRepresentanteNoValidado(intervinientesAux.getNif());
					plantillaTramiteINSDetalle
							.setNombreProvinciaRepresentanteNoValidado(intervinientesAux.getNombreProvincia());
					plantillaTramiteINSDetalle
							.setNombreMunicipioRepresentanteNoValidado(intervinientesAux.getNombreMunicipio());
					plantillaTramiteINSDetalle
							.setNombreLocalidadRepresentanteNoValidado(intervinientesAux.getNombreLocalidad());
					plantillaTramiteINSDetalle
							.setNombreCalleRepresentanteNoValidado(intervinientesAux.getNombreCalle());
					plantillaTramiteINSDetalle.setNombreCpRepresentanteNoValidado(intervinientesAux.getNombreCp());
					plantillaTramiteINSDetalle
							.setNombrePortalRepresentanteNoValidado(intervinientesAux.getNombrePortal());
					plantillaTramiteINSDetalle.setNombrePisoRepresentanteNoValidado(intervinientesAux.getNombrePiso());

					plantillaTramiteINSDetalle
							.setDireccion_nocapvRepresentanteNoValidado(intervinientesAux.getDireccionNocapv());

					// Creamos el campo direccion del establecimiento
					StringBuffer direccionCompleta = new StringBuffer();

					if (intervinientesAux.getNombreCalle() != null && !intervinientesAux.getNombreCalle().equals("")) {
						direccionCompleta.append(intervinientesAux.getNombreCalle());

						if (intervinientesAux.getNombrePortal() != null
								&& !intervinientesAux.getNombrePortal().equals("")) {
							direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
						}
						if (intervinientesAux.getNombrePiso() != null
								&& !intervinientesAux.getNombrePiso().equals("")) {
							direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
						}
					} else {
						if (intervinientesAux.getDireccionNocapv() != null
								&& !intervinientesAux.getDireccionNocapv().equals("")) {
							direccionCompleta.append(intervinientesAux.getDireccionNocapv());
						}
					}

					plantillaTramiteINSDetalle
							.setDireccionRepresentanteNoValidado(Y41bUtils.trataNull(direccionCompleta.toString()));

					// Creamos el campo codigo postal y municipio del
					// establecimiento
					StringBuffer cpMunicipio = new StringBuffer();

					if (intervinientesAux.getNombreCp() != null && !intervinientesAux.getNombreCp().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreCp());

						if (intervinientesAux.getNombreMunicipio() != null
								&& !intervinientesAux.getNombreMunicipio().equals("")) {
							cpMunicipio.append(" ").append(intervinientesAux.getNombreMunicipio());
						}
					} else if (intervinientesAux.getNombreMunicipio() != null
							&& !intervinientesAux.getNombreMunicipio().equals("")) {
						cpMunicipio.append(intervinientesAux.getNombreMunicipio());
					}

					plantillaTramiteINSDetalle
							.setCpMunicipioRepresentanteNoValidado(Y41bUtils.trataNull(cpMunicipio.toString()));
				}
			}
		}

		// ESTABLECIMIENTO SELECCIONADO
		if (tramiteInspeccion != null && plantillaTramite.getTramite() != null
				&& plantillaTramite.getTramite().getTrcodigo() != null && plantillaTramite.getTramite().getTrcodigo()
						.equalsIgnoreCase(Y41bConstantes.TRAMITE_INSPECCIONES_REQUERIMIENTO_POR_ESCRITO)) {
			String nombre = "";
			String direccion = "";
			String cp = "";
			String provincia = "";
			String municipio = "";

			if (tramiteInspeccion.getTiorigenalegacion().equalsIgnoreCase("R")) { // responsable
				nombre = plantillaTramiteINSDetalle.getEsnombreResponsableProducto();
				direccion = plantillaTramiteINSDetalle.getEsdireccionResponsableProducto();
				cp = plantillaTramiteINSDetalle.getEsnombreCpResponsableProducto();
				provincia = plantillaTramiteINSDetalle.getEsnombreProvinciaResponsableProducto();
				municipio = plantillaTramiteINSDetalle.getEsnombreMunicipioResponsableProducto();
			} else if (tramiteInspeccion.getTiorigenalegacion().equalsIgnoreCase("V")) { // visitado
				nombre = plantillaTramiteINSDetalle.getEsnombreEstablecimientoVisitado();
				direccion = plantillaTramiteINSDetalle.getEsdireccionEstablecimientoVisitado();
				cp = plantillaTramiteINSDetalle.getEsCPEstablecimientoVisitado();
				provincia = plantillaTramiteINSDetalle.getEsnombreProvinciaEstablecimientoVisitado();
				municipio = plantillaTramiteINSDetalle.getEsnombreMunicipioEstablecimientoVisitado();
			}

			plantillaTramiteINSDetalle.setEsnombreEstablecimientoSeleccionado(nombre);
			plantillaTramiteINSDetalle.setEsdireccionEstablecimientoSeleccionado(direccion);
			plantillaTramiteINSDetalle.setEsnombreCpEstablecimientoSeleccionado(cp);
			plantillaTramiteINSDetalle.setEsnombreProvinciaEstablecimientoSeleccionado(provincia);
			plantillaTramiteINSDetalle.setEsnombreMunicipioEstablecimientoSeleccionado(municipio);

		}

		// DESTINATARIO
		if (tramiteInspeccion.getTiiddestinatario() != null) {
			Intervinientes intervinienteDest = new Intervinientes();
			intervinienteDest.setIdinterviniente(tramiteInspeccion.getTiiddestinatario());
			List<Intervinientes> listIntervinientesDest = this.intervinientesDao.findAll(intervinienteDest, null);

			if (listIntervinientesDest.size() > 0) {
				intervinienteDest = listIntervinientesDest.get(0);

				StringBuffer nombredestinatario = new StringBuffer();
				nombredestinatario.append(intervinienteDest.getNombre());

				if (Y41bUtils.isFilled(intervinienteDest.getApellido1())) {
					nombredestinatario.append(" ").append(intervinienteDest.getApellido1());
				}

				if (Y41bUtils.isFilled(intervinienteDest.getApellido2())) {
					nombredestinatario.append(" ").append(intervinienteDest.getApellido2());
				}

				plantillaTramiteINSDetalle.setDestNombre(nombredestinatario.toString());

				plantillaTramiteINSDetalle.setDestCodigo(intervinienteDest.getEscodigo());

				plantillaTramiteINSDetalle.setDestNoDir(Y41bUtils.trataNull(intervinienteDest.getNombreCalle()) + ", "
						+ Y41bUtils.trataNull(intervinienteDest.getNombrePortal()) + " - "
						+ Y41bUtils.trataNull(intervinienteDest.getNombrePiso()));
				plantillaTramiteINSDetalle.setDestCP(Y41bUtils.trataNull(intervinienteDest.getNombreCp()));
				plantillaTramiteINSDetalle
						.setDestLocalidad(Y41bUtils.trataNull(intervinienteDest.getNombreLocalidad()));
				plantillaTramiteINSDetalle
						.setDestMunicipio(Y41bUtils.trataNull(intervinienteDest.getNombreMunicipio()));

				plantillaTramiteINSDetalle.setDestEsnoco(intervinienteDest.getEsnoco());

				plantillaTramiteINSDetalle.setDestNif(Y41bUtils.trataNull(intervinienteDest.getNif()));
				plantillaTramiteINSDetalle
						.setDestProvincia(Y41bUtils.trataNull(intervinienteDest.getNombreProvincia()));
			}
		}

		// FECHA COMUNICACION
		if (tramiteInspeccion.getTifechacomunicacion() != null) {
			plantillaTramiteINSDetalle
					.setFechaComunicacionCas(Y41bUtils.formatearDateToString(tramiteInspeccion.getTifechacomunicacion(),
							Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			plantillaTramiteINSDetalle.setFechaComunicacionEus(
					Y41bUtils.formatearDateToStringEuskera(tramiteInspeccion.getTifechacomunicacion(),
							Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIASINA, Y41bConstantes.EUSKERA));
		}

		// Buscar el ultimo TRAMITE_INSPECCIONES_RECEPCION_RECURSO = "IN28";
		TramiteInspeccionDetalle tramiteInspeccionAux = new TramiteInspeccionDetalle();
		tramiteInspeccionAux.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_RECURSO);
		tramiteInspeccionAux.setAtcodigo(actuacion.getAtcodigo());
		try {
			tramiteInspeccionAux = this.tramiteInspeccionDao.findUltimoTramiteHechoPorTipoTramite(tramiteInspeccionAux);
		} catch (Exception e) {
		}
		if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTicodigo() != null) {

			TramiteInspeccion tramiteInspeccionRecurso = new TramiteInspeccion();
			tramiteInspeccionRecurso.setTicodigo(tramiteInspeccionAux.getTicodigo());

			tramiteInspeccionRecurso = this.tramiteInspeccionDao.find(tramiteInspeccionRecurso);

			if (tramiteInspeccionRecurso != null) {
				plantillaTramiteINSDetalle.setFecharecursoCas(Y41bUtils
						.parseDateToString(tramiteInspeccionRecurso.getTifecharecurso(), Y41bConstantes.CASTELLANO));
				plantillaTramiteINSDetalle.setFecharecursoEus(Y41bUtils
						.parseDateToString(tramiteInspeccionRecurso.getTifecharecurso(), Y41bConstantes.EUSKERA));

				plantillaTramiteINSDetalle.setMotivoRecurso(tramiteInspeccionRecurso.getTimotivorecurso());
			}

		}

		tramiteInspeccionAux = new TramiteInspeccionDetalle();
		tramiteInspeccionAux.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_INSPECCION);
		tramiteInspeccionAux.setAtcodigo(actuacion.getAtcodigo());
		try {
			tramiteInspeccionAux = this.tramiteInspeccionDao.findUltimoTramiteHechoPorTipoTramite(tramiteInspeccionAux);
		} catch (Exception e) {
		}
		if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTicodigo() != null) {

			try {
				TramiteInspeccionDetalle miTramiteInspeccionDetalle = new TramiteInspeccionDetalle();
				miTramiteInspeccionDetalle.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION);
				miTramiteInspeccionDetalle.setAtcodigo(actuacion.getAtcodigo());
				miTramiteInspeccionDetalle.setTicodigo(tramiteInspeccionAux.getTicodigo());

				tramiteInspeccionAux = this.tramiteInspeccionDao.findTramiteRelacionado(miTramiteInspeccionDetalle);
			} catch (Exception e) {
			}

			if (tramiteInspeccionAux != null) {
				TramiteInspeccion tramiteComunicacionAux = new TramiteInspeccion();
				tramiteComunicacionAux.setTicodigo(tramiteInspeccionAux.getTicodigo());

				tramiteComunicacionAux = this.tramiteInspeccionDao.find(tramiteComunicacionAux);

				if (tramiteComunicacionAux != null) {
					plantillaTramiteINSDetalle.setFechaComunicacionOrganismoOrigenCas(
							Y41bUtils.formatearDateToString(tramiteComunicacionAux.getTifechacomunicacion(),
									Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
					plantillaTramiteINSDetalle.setFechaComunicacionOrganismoOrigenEus(
							Y41bUtils.formatearDateToStringEuskera(tramiteComunicacionAux.getTifechacomunicacion(),
									Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIASINA, Y41bConstantes.EUSKERA));
				}
			}
		}

		tramiteInspeccionAux = new TramiteInspeccionDetalle();
		tramiteInspeccionAux.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION);
		tramiteInspeccionAux.setAtcodigo(actuacion.getAtcodigo());

		String destino = Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTOVISITADO;

		try {
			tramiteInspeccionAux = this.tramiteInspeccionDao
					.findUltimoTramiteHechoPorTipoTramiteYDestinoTramitado(tramiteInspeccionAux, destino);
		} catch (Exception e) {
		}

		if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTicodigo() != null) {

			TramiteInspeccion tramiteInspeccionRegistroDecision = new TramiteInspeccion();
			tramiteInspeccionRegistroDecision.setTicodigo(tramiteInspeccionAux.getTicodigo());

			tramiteInspeccionRegistroDecision = this.tramiteInspeccionDao.find(tramiteInspeccionRegistroDecision);

			if (tramiteInspeccionRegistroDecision != null) {
				plantillaTramiteINSDetalle.setFechaTramitacionResolucionCas(Y41bUtils.parseDateToString(
						tramiteInspeccionRegistroDecision.getTifecharesolucion(), Y41bConstantes.CASTELLANO));
				plantillaTramiteINSDetalle.setFechaTramitacionResolucionEus(Y41bUtils.parseDateToString(
						tramiteInspeccionRegistroDecision.getTifecharesolucion(), Y41bConstantes.EUSKERA));
			}

		}

		tramiteInspeccionAux = new TramiteInspeccionDetalle();
		tramiteInspeccionAux.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION);
		tramiteInspeccionAux.setAtcodigo(actuacion.getAtcodigo());

		destino = Y41bConstantes.DESTINO_RESOL_ESTABLECIMIENTORESPONSABLE;

		try {
			tramiteInspeccionAux = this.tramiteInspeccionDao
					.findUltimoTramiteHechoPorTipoTramiteYDestinoTramitado(tramiteInspeccionAux, destino);
		} catch (Exception e) {
		}

		if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTicodigo() != null) {

			TramiteInspeccion tramiteInspeccionRegistroDecision = new TramiteInspeccion();
			tramiteInspeccionRegistroDecision.setTicodigo(tramiteInspeccionAux.getTicodigo());

			tramiteInspeccionRegistroDecision = this.tramiteInspeccionDao.find(tramiteInspeccionRegistroDecision);

			if (tramiteInspeccionRegistroDecision != null) {
				plantillaTramiteINSDetalle.setFechaTramitacionResolucionResponsableCas(Y41bUtils.parseDateToString(
						tramiteInspeccionRegistroDecision.getTifecharesolucion(), Y41bConstantes.CASTELLANO));
				plantillaTramiteINSDetalle.setFechaTramitacionResolucionResponsableEus(Y41bUtils.parseDateToString(
						tramiteInspeccionRegistroDecision.getTifecharesolucion(), Y41bConstantes.EUSKERA));
			}

		}

		if (tramiteInspeccion != null && tramiteInspeccion.getTicotee()
				.equals(Y41bConstantes.TRAMITE_INSPECCIONES_RESOLUCION_ACUERDO_INICIO_PROCEDIMIENTO)) {
			tramiteInspeccionAux = new TramiteInspeccionDetalle();
			tramiteInspeccionAux.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);
			tramiteInspeccionAux.setAtcodigo(actuacion.getAtcodigo());
			try {
				tramiteInspeccionAux = this.tramiteInspeccionDao
						.findUltimoTramiteHechoPorTipoTramite(tramiteInspeccionAux);
			} catch (Exception e) {
			}
			if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTicodigo() != null) {

				TramiteInspeccion tramiteInspeccionAIP = new TramiteInspeccion();
				tramiteInspeccionAIP.setTicodigo(tramiteInspeccionAux.getTicodigo());

				tramiteInspeccionAIP = this.tramiteInspeccionDao.find(tramiteInspeccionAIP);

				if (tramiteInspeccionAIP != null) {
					plantillaTramiteINSDetalle
							.setFechaaip(Y41bUtils.formatearDateToString(tramiteInspeccionAIP.getTifecharesolucion(),
									Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				}
			}

			if (tramiteInspeccion != null && tramiteInspeccion.getTramiteInspeccion() != null) {

				ActaNueva actaNueva = new ActaNueva();
				actaNueva.setAncodigo(tramiteInspeccion.getTramiteInspeccion().getTiaccodigo());
				actaNueva = actaNuevaDao.find(actaNueva);

				plantillaTramiteINSDetalle.setNombreActaInmo(actaNueva.getAncodac());
			}

			plantillaTramiteINSDetalle.setUnidadesInmovilizadas(tramiteInspeccion.getTinumdesin());
		}

		if (tramiteInspeccion != null
				&& tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_DESINMOVILIZACION)) {

			tramiteInspeccionAux = new TramiteInspeccionDetalle();
			tramiteInspeccionAux.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_DESINMOVILIZACION);
			tramiteInspeccionAux.setAtcodigo(actuacion.getAtcodigo());
			try {
				tramiteInspeccionAux = this.tramiteInspeccionDao
						.findUltimoTramiteHechoPorTipoTramite(tramiteInspeccionAux);
			} catch (Exception e) {
			}
			if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTicodigo() != null) {

				TramiteInspeccion tramiteInspeccionDesinmovilizacion = new TramiteInspeccion();
				tramiteInspeccionDesinmovilizacion.setTicodigo(tramiteInspeccionAux.getTicodigo());

				tramiteInspeccionDesinmovilizacion = this.tramiteInspeccionDao.find(tramiteInspeccionDesinmovilizacion);

				if (tramiteInspeccionDesinmovilizacion != null) {
					plantillaTramiteINSDetalle.setFechaaip(
							Y41bUtils.formatearDateToString(tramiteInspeccionDesinmovilizacion.getTifechadesin(),
									Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
				}
			}
		}

		// Creamos el campo pie pagina linea1
		StringBuffer piepagina_linea1 = new StringBuffer();

		piepagina_linea1.append(plantillaTramiteINSDetalle.getDireccionOrganismo()).append(" - ")
				.append(plantillaTramiteINSDetalle.getCpMunicipioOrganismo()).append(" / ").append(" Tl. ")
				.append(plantillaTramiteINSDetalle.getTelefonoOrganismo());

		plantillaTramiteINSDetalle.setPiePaginaLinea1(piepagina_linea1.toString());

		// Creamos el campo pie pagina linea1
		StringBuffer piepagina_linea2 = new StringBuffer();

		piepagina_linea2.append("e-mail: ").append(plantillaTramiteINSDetalle.getEmailOrganismo()).append(" / ")
				.append(plantillaTramiteINSDetalle.getWebOrganismo());

		plantillaTramiteINSDetalle.setPiePaginaLinea2(piepagina_linea2.toString());

		// 0154940: Actualizacin de datos explcitos en plantillas a uso de
		// campos combinados
		// // OFICINA CENTRAL

		Organismo organismo = new Organismo();
		organismo.setCodOrg(Y41bConstantes.OFICINA_CENTRAL);
		organismo = this.organismoDao.findOrganismo(organismo);

		if (organismo != null && organismo.getEntidadId() != null) {

			// Creamos el campo central pie pagina linea1
			StringBuffer centralpiepagina_linea1 = new StringBuffer();

			centralpiepagina_linea1.append(organismo.getNombreCalle()).append(" ").append(organismo.getNombrePortal())
					.append(" - ").append(organismo.getNombreCp()).append(" / ").append(" Tl. ")
					.append(organismo.getTelefono());

			plantillaTramiteINSDetalle.setCentralPiePaginaLinea1(centralpiepagina_linea1.toString());

			// Creamos el campo central pie pagina linea2
			StringBuffer centralpiepagina_linea2 = new StringBuffer();

			centralpiepagina_linea2.append("e-mail: ").append(organismo.getEmail()).append(" / ")
					.append(organismo.getUrl());

			plantillaTramiteINSDetalle.setCentralPiePaginaLinea2(centralpiepagina_linea2.toString());

			plantillaTramiteINSDetalle.setCentralMail(organismo.getEmail());

			plantillaTramiteINSDetalle.setCentralTelefono(organismo.getTelefono());
		}

		// 0154940

		// Transformar el documento en castellano
		String plantilla = Y41bUtils.blobToString(plantillaTramite.getPtplantilla());

		StringBuffer rutaPlantilla = new StringBuffer(
				appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word").toString());

		rutaPlantilla.append(Y41bConstantes.NOMBRE_PLANTILLA_INSPECCIONES_XML_TRAMITE_CASTELLANO);

		String ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(rutaPlantilla.toString(),
				plantillaTramiteINSDetalle, plantilla);

		return ficheroGenerado;
	}

	/**
	 * Genera un documento en base a su plantilla.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	private String findPlantillaDecision(PlantillaDecision plantillaDecision, TramiteComun tramiteComun)
			throws Exception {

		// Obtener la plantilla del tramite
		plantillaDecision = this.plantillaDecisionDao.find(plantillaDecision);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteComun.getIdExpediente());
		// Obtener los datos de la comunicacion soivre
		actuacion = this.actuacionDao.find(actuacion);

		PlantillaTramiteINSDecisionDetalle plantillaTramiteINSDecisionDetalle = new PlantillaTramiteINSDecisionDetalle();

		TramiteInspeccionDetalle tramiteInspeccionAux = new TramiteInspeccionDetalle();
		tramiteInspeccionAux.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);
		tramiteInspeccionAux.setAtcodigo(actuacion.getAtcodigo());
		try {
			tramiteInspeccionAux = this.tramiteInspeccionDao.findUltimoTramiteHechoPorTipoTramite(tramiteInspeccionAux);
		} catch (Exception e) {
		}
		if (tramiteInspeccionAux != null && tramiteInspeccionAux.getTicodigo() != null) {

			TramiteInspeccion tramiteInspeccionAIP = new TramiteInspeccion();
			tramiteInspeccionAIP.setTicodigo(tramiteInspeccionAux.getTicodigo());

			tramiteInspeccionAIP = this.tramiteInspeccionDao.find(tramiteInspeccionAIP);

			if (tramiteInspeccionAIP != null) {
				plantillaTramiteINSDecisionDetalle
						.setFechaaip(Y41bUtils.formatearDateToString(tramiteInspeccionAIP.getTifecharesolucion(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			}
		}

		// Producto
		plantillaTramiteINSDecisionDetalle.setNombreProducto(actuacion.getAtnoprse());
		plantillaTramiteINSDecisionDetalle.setMarcaProducto(actuacion.getAtnomaps());
		plantillaTramiteINSDecisionDetalle.setModeloProducto(actuacion.getAtnomops());
		plantillaTramiteINSDecisionDetalle.setLoteProducto(actuacion.getAtnrlops());
		plantillaTramiteINSDecisionDetalle.setCodigoBarrasProducto(actuacion.getAtcodigobarras());

		Producto producto = new Producto();
		producto.setPscodigo(actuacion.getAtcops());
		producto = this.productoService.find(producto);

		plantillaTramiteINSDecisionDetalle.setProductoServicio(producto.getPsnombre());

		// inspeccion
		plantillaTramiteINSDecisionDetalle
				.setExpediente(this.instramexpService.findNumExpedienteActuacion(tramiteComun.getIdExpediente()));

		plantillaTramiteINSDecisionDetalle.setOrigen(this.instramexpService.findOrigenInspeccionPorIdExpediente(
				tramiteComun.getIdExpediente(), new Locale(Y41bConstantes.CASTELLANO)));
		plantillaTramiteINSDecisionDetalle.setOrigenEus(this.instramexpService.findOrigenInspeccionPorIdExpediente(
				tramiteComun.getIdExpediente(), new Locale(Y41bConstantes.EUSKERA)));
		// tramite inspeccion

		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());

		tramiteInspeccion = tramiteInspeccionService.find(tramiteInspeccion);

		if (tramiteInspeccion != null) {

			// emision de informe
			plantillaTramiteINSDecisionDetalle.setNombreCompareciente(
					new StringBuffer().append(Y41bUtils.trataNull(tramiteInspeccion.getTinombreinf())).append(" ")
							.append(Y41bUtils.trataNull(tramiteInspeccion.getTiape1inf())).append(" ")
							.append(Y41bUtils.trataNull(tramiteInspeccion.getTiape2inf())).toString());
			plantillaTramiteINSDecisionDetalle.setDniCompareciente(tramiteInspeccion.getTidniinf());
			plantillaTramiteINSDecisionDetalle.setEnCondicionDeCompareciente(tramiteInspeccion.getTiencondicioninf());

			// cargamos datos de las actas de traslado, apercibimiento
			ActaNueva actaNueva = new ActaNueva();
			if (tramiteInspeccion.getTiancodigo() != null) {
				actaNueva = new ActaNueva();
				actaNueva.setAncodigo(tramiteInspeccion.getTiancodigo());
				List<ActaNueva> listActaNueva = actaNuevaDao.findAll(actaNueva, null);
				if (listActaNueva != null && listActaNueva.size() > 0) {
					actaNueva = listActaNueva.get(0);
					plantillaTramiteINSDecisionDetalle.setNombreActaDecision(actaNueva.getAncodac());
					plantillaTramiteINSDecisionDetalle.setFechaActaDecision(Y41bUtils.formatearDateToString(
							actaNueva.getAnfecha(), Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));
					plantillaTramiteINSDecisionDetalle.setFechaActaDecisionEus(Y41bUtils.formatearDateToString(
							actaNueva.getAnfecha(), Y41bConstantes.FORMATO_FECHA_EU, Y41bConstantes.EUSKERA));
				}

			}

			plantillaTramiteINSDecisionDetalle
					.setJustificacionInfraccion(tramiteInspeccion.getTijustificacioninfraccion());

			// plantillaTramiteINSDecisionDetalle.setActa(actaCodigo);

			CensoMonitor instructorAsignado = new CensoMonitor();
			instructorAsignado.setMocodigo(tramiteInspeccion.getTicomoasignado());

			if (tramiteInspeccion.getTicomoasignado() != null && !tramiteInspeccion.getTicomoasignado().equals("")) {
				instructorAsignado = this.censoMonitorDao.find(instructorAsignado);
			}

			plantillaTramiteINSDecisionDetalle.setInspector(instructorAsignado.getMonombre());

			// cargamos el acta
			if (tramiteInspeccion.getTiaccodigo() != null && !tramiteInspeccion.getTiaccodigo().equals("")) {
				actaNueva = new ActaNueva();

				actaNueva.setAncodigo(tramiteInspeccion.getTiaccodigo());

				List<ActaNueva> listActaNueva = actaNuevaDao.findAllLike(actaNueva, null, false);
				actaNueva = listActaNueva.get(0);
				plantillaTramiteINSDecisionDetalle.setActa(actaNueva.getAncodac());
				plantillaTramiteINSDecisionDetalle.setAnfecha(Y41bUtils.formatearDateToString(actaNueva.getAnfecha(),
						Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));
			}

			// Observaciones

			plantillaTramiteINSDecisionDetalle.setObservaciones(tramiteInspeccion.getTicomentario());
			// organismo destino

			if (tramiteInspeccion.getTicoortraspaso() != null) {

				Organismo organismo = new Organismo();
				organismo.setCodOrg(tramiteInspeccion.getTicoortraspaso());
				organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

				if (organismo != null && organismo.getNoraProvinciaId() != null) {
					T17Provincia t17Provincia = new T17Provincia();

					t17Provincia.setId(organismo.getNoraProvinciaId());

					t17Provincia = t17ProvinciaDao.find(t17Provincia);

					T17Autonomia t17Autonomia = new T17Autonomia();
					t17Autonomia.setId(t17Provincia.getAutonomiaId());

					t17Autonomia = t17AutonomiaDao.find(t17Autonomia);

					plantillaTramiteINSDecisionDetalle.setAutonomiaTraslado(t17Autonomia.getDsO());
				}

				plantillaTramiteINSDecisionDetalle.setCodOrgTraslado(organismo.getCodOrg());
				plantillaTramiteINSDecisionDetalle.setNombreEuTraslado(organismo.getNombreEu());
				plantillaTramiteINSDecisionDetalle.setNombreEsTraslado(organismo.getNombreEs());
				plantillaTramiteINSDecisionDetalle.setNombreCalleTraslado(organismo.getNombreCalle());
				plantillaTramiteINSDecisionDetalle.setNoraCpIdTraslado(organismo.getNoraCpId());
				plantillaTramiteINSDecisionDetalle.setNombreMunicipioTraslado(organismo.getNombreMunicipio());
				plantillaTramiteINSDecisionDetalle.setNombreCpTraslado(organismo.getNombreCp());
				plantillaTramiteINSDecisionDetalle.setNombrePortalTraslado(organismo.getNombrePortal());
				plantillaTramiteINSDecisionDetalle.setNombrePisoTraslado(organismo.getCompleDirec());

				// Creamos el campo direccion del organismo conectado
				StringBuffer direccionCompleta = new StringBuffer();

				if (plantillaTramiteINSDecisionDetalle.getNombreCalleTraslado() != null
						&& !plantillaTramiteINSDecisionDetalle.getNombreCalleTraslado().equals("")) {
					direccionCompleta.append(plantillaTramiteINSDecisionDetalle.getNombreCalleTraslado());

					if (plantillaTramiteINSDecisionDetalle.getNombrePortalTraslado() != null
							&& !plantillaTramiteINSDecisionDetalle.getNombrePortalTraslado().equals("")) {
						direccionCompleta.append(", ")
								.append(plantillaTramiteINSDecisionDetalle.getNombrePortalTraslado());
					}
				}

				plantillaTramiteINSDecisionDetalle
						.setDireccionTraslado(Y41bUtils.trataNull(direccionCompleta.toString()));

				// Creamos el campo codigo postal y municipio del organismo
				// conectado
				StringBuffer cpMunicipio = new StringBuffer();

				if (plantillaTramiteINSDecisionDetalle.getNombreMunicipioTraslado() != null
						&& !plantillaTramiteINSDecisionDetalle.getNombreMunicipioTraslado().equals("")) {
					cpMunicipio.append(plantillaTramiteINSDecisionDetalle.getNombreMunicipioTraslado());
				}

				plantillaTramiteINSDecisionDetalle.setCpMunicipioTraslado(Y41bUtils.trataNull(cpMunicipio.toString()));

			}

			plantillaTramiteINSDecisionDetalle.setInforme(tramiteInspeccion.getTiinforme());
		}

		// lista de infracciones
		StringBuffer sbInfraccionesES = new StringBuffer(120);
		StringBuffer sbInfraccionesEU = new StringBuffer(120);
		List<DetalleInfraccion> detalleInfraccion = this.actaService.findInfracciones(actuacion, null, false);
		for (DetalleInfraccion di : detalleInfraccion) {
			sbInfraccionesES.append("{ ");
			sbInfraccionesES.append(" \\\\pard\\\\sb1 ");
			sbInfraccionesES.append(" \\\\tab - \\\\tab ");
			sbInfraccionesES.append(di.getTtinombre());
			sbInfraccionesES.append(" \\\\line\\\\par ");
			sbInfraccionesES.append("}");

			sbInfraccionesEU.append("{ ");
			sbInfraccionesEU.append(" \\\\pard\\\\sb1 ");
			sbInfraccionesEU.append(" \\\\tab - \\\\tab ");
			sbInfraccionesEU.append(di.getTtinombree());
			sbInfraccionesEU.append(" \\\\line\\\\par ");
			sbInfraccionesEU.append("}");

		}

		plantillaTramiteINSDecisionDetalle.setInfracciones(Y41bUtils.trataNull(sbInfraccionesES.toString()));
		plantillaTramiteINSDecisionDetalle.setInfraccionesEus(Y41bUtils.trataNull(sbInfraccionesEU.toString()));

		Actdec actdec = new Actdec();
		actdec.setAdcoat(tramiteComun.getIdExpediente());

		actdec = this.actdecDao.findDecisionInspeccion(actdec);

		if (actdec != null) {

			// fecha decision

			if (tramiteInspeccion.getTifecharesolucion() != null) {
				// Formateamos las fecha a castellano e euskera
				// fecha de hoy texto
				plantillaTramiteINSDecisionDetalle
						.setFechaDecision(Y41bUtils.formatearDateToString(tramiteInspeccion.getTifecharesolucion(),
								Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));

				plantillaTramiteINSDecisionDetalle.setFechaDecisionEus(
						Y41bUtils.formatearDateToStringEuskera(tramiteInspeccion.getTifecharesolucion(),
								Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));
			}

			Organismo organismo = new Organismo();
			organismo.setCodOrg(actdec.getAdcoor());
			organismo = this.organismoDao.findOrganismoByCodOrg(organismo);

			// Coordinador
			CensoMonitor censoMonitorCoordinador = new CensoMonitor();
			try {

				censoMonitorCoordinador.setOrganismo(organismo);

				censoMonitorCoordinador = this.censoMonitorDao.findCoordinadorInspecciones(censoMonitorCoordinador);
				if (censoMonitorCoordinador.getMonombre() == null) {
					throw new Y41bUDAException("error.solicitud.tramite.nocoordinador", true, new Exception());
				}
			} catch (Exception e) {
				censoMonitorCoordinador = new CensoMonitor();
				throw new Y41bUDAException("error.solicitud.tramite.nocoordinador", true, new Exception());
			}

			plantillaTramiteINSDecisionDetalle.setCoordinador(censoMonitorCoordinador.getMonombre());

			if (censoMonitorCoordinador.getOrganismo() != null
					&& censoMonitorCoordinador.getOrganismo().getCodOrg() != null) {
				String strTerritorio = censoMonitorCoordinador.getOrganismo().getCodOrg();

				strTerritorio = strTerritorio.substring(0, 2);

				if (censoMonitorCoordinador.getOrganismo().getCodOrg()
						.equalsIgnoreCase(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO)) {
					// recuperar texto de properties
					plantillaTramiteINSDecisionDetalle.setTextoPuestoCoordinadorCas(appMessageSource.getMessage(
							"plantilla.puestocoordinador01A101", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteINSDecisionDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador01A101", null, new Locale(Y41bConstantes.EUSKERA)));
				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_ARABA)) {
					// recuperar texto de properties
					plantillaTramiteINSDecisionDetalle.setTextoPuestoCoordinadorCas(appMessageSource
							.getMessage("plantilla.puestocoordinador01", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteINSDecisionDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador01", null, new Locale(Y41bConstantes.EUSKERA)));

				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
					// recuperar texto de properties
					plantillaTramiteINSDecisionDetalle.setTextoPuestoCoordinadorCas(appMessageSource
							.getMessage("plantilla.puestocoordinador48", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteINSDecisionDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador48", null, new Locale(Y41bConstantes.EUSKERA)));

				} else if (strTerritorio.equalsIgnoreCase(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)) {
					// recuperar texto de properties
					plantillaTramiteINSDecisionDetalle.setTextoPuestoCoordinadorCas(appMessageSource
							.getMessage("plantilla.puestocoordinador20", null, new Locale(Y41bConstantes.CASTELLANO)));
					plantillaTramiteINSDecisionDetalle.setTextoPuestoCoordinadorEus(appMessageSource
							.getMessage("plantilla.puestocoordinador20", null, new Locale(Y41bConstantes.EUSKERA)));
				}
			}

			plantillaTramiteINSDecisionDetalle.setCodOrg(organismo.getCodOrg());
			plantillaTramiteINSDecisionDetalle.setNombreEu(organismo.getNombreEu());
			plantillaTramiteINSDecisionDetalle.setNombreEs(organismo.getNombreEs());
			plantillaTramiteINSDecisionDetalle.setNombreCalle(organismo.getNombreCalle());
			plantillaTramiteINSDecisionDetalle.setNombreLocalidad(organismo.getNombreLocalidad());

			plantillaTramiteINSDecisionDetalle.setNoraCpId(organismo.getNoraCpId());
			plantillaTramiteINSDecisionDetalle.setNombreMunicipio(organismo.getNombreMunicipio());
			plantillaTramiteINSDecisionDetalle.setNombrePortal(organismo.getNombrePortal());
			plantillaTramiteINSDecisionDetalle.setNombrePiso(organismo.getCompleDirec());

			if (organismo.getCodOrg().equals(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA)) {
				plantillaTramiteINSDecisionDetalle.setTelefonoOrganismo(organismo.getTelefono2());
			} else {
				plantillaTramiteINSDecisionDetalle.setTelefonoOrganismo(organismo.getTelefono());
			}
			plantillaTramiteINSDecisionDetalle.setFaxOrganismo(organismo.getFax());
			plantillaTramiteINSDecisionDetalle.setEmailOrganismo(organismo.getEmail());
			plantillaTramiteINSDecisionDetalle.setWebOrganismo(organismo.getUrl());

			// Creamos el campo direccion del organismo conectado
			StringBuffer direccionCompleta = new StringBuffer();

			if (plantillaTramiteINSDecisionDetalle.getNombreCalle() != null
					&& !plantillaTramiteINSDecisionDetalle.getNombreCalle().equals("")) {
				direccionCompleta.append(plantillaTramiteINSDecisionDetalle.getNombreCalle());

				if (plantillaTramiteINSDecisionDetalle.getNombrePortal() != null
						&& !plantillaTramiteINSDecisionDetalle.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(plantillaTramiteINSDecisionDetalle.getNombrePortal());
				}
			}

			plantillaTramiteINSDecisionDetalle.setDireccionOrganismo(Y41bUtils.trataNull(direccionCompleta.toString()));

			// Creamos el campo codigo postal y municipio del organismo
			// conectado
			StringBuffer cpMunicipio = new StringBuffer();

			if (plantillaTramiteINSDecisionDetalle.getNombreCp() != null
					&& !plantillaTramiteINSDecisionDetalle.getNombreCp().equals("")) {
				cpMunicipio.append(plantillaTramiteINSDecisionDetalle.getNombreCp());

				if (plantillaTramiteINSDecisionDetalle.getNombreMunicipio() != null
						&& !plantillaTramiteINSDecisionDetalle.getNombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(plantillaTramiteINSDecisionDetalle.getNombreMunicipio());
				}
			} else if (plantillaTramiteINSDecisionDetalle.getNombreMunicipio() != null
					&& !plantillaTramiteINSDecisionDetalle.getNombreMunicipio().equals("")) {
				cpMunicipio.append(plantillaTramiteINSDecisionDetalle.getNombreMunicipio());
			}

			plantillaTramiteINSDecisionDetalle.setCpMunicipioOrganismo(Y41bUtils.trataNull(cpMunicipio.toString()));
		}

		// ESTABLECIMIENTO VISITADO
		Intervinientes intervinientesV = new Intervinientes();
		intervinientesV.setIdExpediente(actuacion.getAtcodigo());
		intervinientesV.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

		List<Intervinientes> listIntervinientesV = this.intervinientesDao.findAll(intervinientesV, null);

		Intervinientes intervinientesVAux = null;
		if (listIntervinientesV.size() > 0) {
			intervinientesVAux = listIntervinientesV.get(0);

			plantillaTramiteINSDecisionDetalle.setEsnifEstablecimientoVisitado(intervinientesVAux.getNif());

			plantillaTramiteINSDecisionDetalle
					.setEsnombreMunicipioEstablecimientoVisitado(intervinientesVAux.getNombreMunicipio());

			plantillaTramiteINSDecisionDetalle
					.setEsnombreProvinciaEstablecimientoVisitado(intervinientesVAux.getNombreProvincia());

			plantillaTramiteINSDecisionDetalle.setEsnombreEstablecimientoVisitado(intervinientesVAux.getNombre());

			plantillaTramiteINSDecisionDetalle.setEsTelefonoEstablecimientoVisitado(intervinientesVAux.getNrtel());

			plantillaTramiteINSDecisionDetalle.setEsFaxEstablecimientoVisitado(intervinientesVAux.getNrtel2());

			plantillaTramiteINSDecisionDetalle.setEsMailEstablecimientoVisitado(intervinientesVAux.getCoem());

			plantillaTramiteINSDecisionDetalle.setEsCPEstablecimientoVisitado(intervinientesVAux.getNombreCp());

			plantillaTramiteINSDecisionDetalle.setEsSectorEstablecimientoVisitado(intervinientesVAux.getSenombre());

			plantillaTramiteINSDecisionDetalle
					.setEsNombreComercialEstablecimientoVisitado(intervinientesVAux.getEsnoco());

		}

		// ESTABLECIMIENTO RESPONSABLE

		Intervinientes intervinientesR = new Intervinientes();
		intervinientesR.setIdExpediente(actuacion.getAtcodigo());

		intervinientesR.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);

		List<Intervinientes> listIntervinientesR = this.intervinientesDao.findAll(intervinientesR, null);

		// Creamos el campo direccion del establecimiento
		StringBuffer direccionCompletaV = new StringBuffer();

		if (intervinientesVAux != null && intervinientesVAux.getNombreCalle() != null
				&& !intervinientesVAux.getNombreCalle().equals("")) {
			direccionCompletaV.append(intervinientesVAux.getNombreCalle());

			if (intervinientesVAux.getNombrePortal() != null && !intervinientesVAux.getNombrePortal().equals("")) {
				direccionCompletaV.append(", ").append(intervinientesVAux.getNombrePortal());
			}
			if (intervinientesVAux.getNombrePiso() != null && !intervinientesVAux.getNombrePiso().equals("")) {
				direccionCompletaV.append(" ").append(intervinientesVAux.getNombrePiso());
			}
		} else {
			if (intervinientesVAux.getDireccionNocapv() != null
					&& !intervinientesVAux.getDireccionNocapv().equals("")) {
				direccionCompletaV.append(intervinientesVAux.getDireccionNocapv());
			} else {
				direccionCompletaV.append(Y41bUtils.trataNull(intervinientesVAux.getDireccionAntigua()));
			}
		}

		plantillaTramiteINSDecisionDetalle
				.setEsdireccionEstablecimientoVisitado(Y41bUtils.trataNull(direccionCompletaV.toString()));

		Intervinientes intervinientesRAux = null;
		if (listIntervinientesR.size() > 0) {
			intervinientesRAux = listIntervinientesR.get(0);
		}

		// if (intervinientesRAux == null) {
		// throw new Y41bUDAException("error.inspeccion.nohayresponsable",
		// true, new Exception());
		// }

		if (intervinientesRAux != null) {

			// Creamos el campo direccion del establecimiento
			StringBuffer direccionCompleta = new StringBuffer();

			if (intervinientesRAux.getNombreCalle() != null && !intervinientesRAux.getNombreCalle().equals("")) {
				direccionCompleta.append(intervinientesRAux.getNombreCalle());

				if (intervinientesRAux.getNombrePortal() != null && !intervinientesRAux.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(intervinientesRAux.getNombrePortal());
				}
				if (intervinientesRAux.getNombrePiso() != null && !intervinientesRAux.getNombrePiso().equals("")) {
					direccionCompleta.append(" ").append(intervinientesRAux.getNombrePiso());
				}
			} else {
				if (intervinientesRAux.getDireccionNocapv() != null
						&& !intervinientesRAux.getDireccionNocapv().equals("")) {
					direccionCompleta.append(intervinientesRAux.getDireccionNocapv());
				} else {
					direccionCompleta.append(Y41bUtils.trataNull(intervinientesRAux.getDireccionAntigua()));
				}
			}

			plantillaTramiteINSDecisionDetalle.setEsnifResponsableProducto(intervinientesRAux.getNif());

			plantillaTramiteINSDecisionDetalle.setEsnombreResponsableProducto(intervinientesRAux.getNombre());

			plantillaTramiteINSDecisionDetalle
					.setEsdireccionResponsableProducto(Y41bUtils.trataNull(direccionCompleta.toString()));

			plantillaTramiteINSDecisionDetalle
					.setEsnombreMunicipioResponsableProducto(intervinientesRAux.getNombreMunicipio());
			plantillaTramiteINSDecisionDetalle
					.setEsnombreProvinciaResponsableProducto(intervinientesRAux.getNombreProvincia());
			plantillaTramiteINSDecisionDetalle
					.setEsnombreLocalidadResponsableProducto(intervinientesRAux.getNombreLocalidad());

			plantillaTramiteINSDecisionDetalle.setEsnombreCpResponsableProducto(intervinientesRAux.getNombreCp());

		}

		// fecha de hoy
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
		// Formateamos las fecha a castellano e euskera
		// fecha de hoy texto
		plantillaTramiteINSDecisionDetalle.setFechaHoyCas(Y41bUtils.formatearDateToString(todayWithZeroTime,
				Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
		plantillaTramiteINSDecisionDetalle.setFechaHoyEus(Y41bUtils.formatearDateToStringEuskera(todayWithZeroTime,
				Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

		// Director
		CensoMonitor censoMonitorDirector = new CensoMonitor();

		try {
			censoMonitorDirector = this.censoMonitorDao.findDirectorInspecciones();
			if (censoMonitorDirector.getMonombre() == null) {
				throw new Y41bUDAException("error.solicitud.tramite.nodirector", true, new Exception());
			}
		} catch (Exception e) {
			censoMonitorDirector = new CensoMonitor();
			throw new Y41bUDAException("error.solicitud.tramite.nodirector", true, new Exception());
		}

		plantillaTramiteINSDecisionDetalle.setDirector(censoMonitorDirector.getMonombre());
		// recuperar texto de properties
		plantillaTramiteINSDecisionDetalle.setTextoPuestoDirectorCas(
				appMessageSource.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.CASTELLANO)));
		plantillaTramiteINSDecisionDetalle.setTextoPuestoDirectorEus(
				appMessageSource.getMessage("plantilla.puestodirector", null, new Locale(Y41bConstantes.EUSKERA)));

		// REPRESENTANTE
		Intervinientes intervinientesAux = new Intervinientes();
		intervinientesAux.setIdExpediente(actuacion.getAtcodigo());

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientesAux, null);

		if (listIntervinientes.size() > 1) {
			for (Intervinientes intervinientes : listIntervinientes) {

				if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO)) {
					if (actuacion.getAtdestnotificavisitado() != null && actuacion.getAtdestnotificavisitado()
							.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

						// buscar el representante
						intervinientesAux = new Intervinientes();
						intervinientesAux.setIdExpediente(actuacion.getAtcodigo());
						intervinientesAux.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO);
						intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

						if (intervinientesAux != null && Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {

							StringBuffer nombreCompleto = new StringBuffer();

							nombreCompleto.append(intervinientesAux.getNombre());

							if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
								nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
							}

							if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
								nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
							}

							plantillaTramiteINSDecisionDetalle
									.setEsnombreEstablecimientoVisitado(Y41bUtils.trataNull(nombreCompleto.toString()));
							plantillaTramiteINSDecisionDetalle.setEsNombreComercialEstablecimientoVisitado(
									Y41bUtils.trataNull(nombreCompleto.toString()));
							plantillaTramiteINSDecisionDetalle
									.setEsnifEstablecimientoVisitado(intervinientesAux.getNif());

							plantillaTramiteINSDecisionDetalle.setEsnombreProvinciaEstablecimientoVisitado(
									intervinientesAux.getNombreProvincia());
							plantillaTramiteINSDecisionDetalle.setEsnombreMunicipioEstablecimientoVisitado(
									intervinientesAux.getNombreMunicipio());

							plantillaTramiteINSDecisionDetalle
									.setEsCPEstablecimientoVisitado(intervinientesAux.getNombreCp());

							plantillaTramiteINSDecisionDetalle
									.setEsTelefonoEstablecimientoVisitado(intervinientesAux.getNrtel());
							plantillaTramiteINSDecisionDetalle
									.setEsFaxEstablecimientoVisitado(intervinientesAux.getNrtel2());
							plantillaTramiteINSDecisionDetalle
									.setEsMailEstablecimientoVisitado(intervinientesAux.getCoem());

							// Creamos el campo direccion del establecimiento
							StringBuffer direccionCompleta = new StringBuffer();

							if (intervinientesAux != null && intervinientesAux.getNombreCalle() != null
									&& !intervinientesAux.getNombreCalle().equals("")) {
								direccionCompleta.append(intervinientesAux.getNombreCalle());

								if (intervinientesAux.getNombrePortal() != null
										&& intervinientesAux.getNombrePortal() != null
										&& !intervinientesAux.getNombrePortal().equals("")) {
									direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
								}
								if (intervinientesAux.getNombrePiso() != null
										&& intervinientesAux.getNombrePiso() != null
										&& !intervinientesAux.getNombrePiso().equals("")) {
									direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
								}
							} else {
								if (intervinientesAux.getDireccionNocapv() != null
										&& intervinientesAux.getDireccionNocapv() != null
										&& !intervinientesAux.getDireccionNocapv().equals("")) {
									direccionCompleta.append(intervinientesAux.getDireccionNocapv());
								} else {
									direccionCompleta
											.append(Y41bUtils.trataNull(intervinientesAux.getDireccionAntigua()));
								}
							}

							plantillaTramiteINSDecisionDetalle.setEsdireccionEstablecimientoVisitado(
									Y41bUtils.trataNull(direccionCompleta.toString()));

						} else {
							// buscar el representante
							intervinientesAux = new Intervinientes();
							intervinientesAux.setIdExpediente(actuacion.getAtcodigo());
							intervinientesAux.setTipoInterviniente(
									Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO);
							intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

							if (intervinientesAux != null
									&& Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {

								StringBuffer nombreCompleto = new StringBuffer();

								nombreCompleto.append(intervinientesAux.getNombre());

								if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
								}

								if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
								}

								plantillaTramiteINSDecisionDetalle.setEsnombreEstablecimientoVisitado(
										Y41bUtils.trataNull(nombreCompleto.toString()));
								plantillaTramiteINSDecisionDetalle.setEsNombreComercialEstablecimientoVisitado(
										Y41bUtils.trataNull(nombreCompleto.toString()));
								plantillaTramiteINSDecisionDetalle
										.setEsnifEstablecimientoVisitado(intervinientesAux.getNif());

								plantillaTramiteINSDecisionDetalle.setEsnombreProvinciaEstablecimientoVisitado(
										intervinientesAux.getNombreProvincia());
								plantillaTramiteINSDecisionDetalle.setEsnombreMunicipioEstablecimientoVisitado(
										intervinientesAux.getNombreMunicipio());

								plantillaTramiteINSDecisionDetalle
										.setEsCPEstablecimientoVisitado(intervinientesAux.getNombreCp());

								plantillaTramiteINSDecisionDetalle
										.setEsTelefonoEstablecimientoVisitado(intervinientesAux.getNrtel());
								plantillaTramiteINSDecisionDetalle
										.setEsFaxEstablecimientoVisitado(intervinientesAux.getNrtel2());
								plantillaTramiteINSDecisionDetalle
										.setEsMailEstablecimientoVisitado(intervinientesAux.getCoem());

								// Creamos el campo direccion del
								// establecimiento
								StringBuffer direccionCompleta = new StringBuffer();

								if (intervinientesAux != null && intervinientesAux.getNombreCalle() != null
										&& !intervinientesAux.getNombreCalle().equals("")) {
									direccionCompleta.append(intervinientesAux.getNombreCalle());

									if (intervinientesAux.getNombrePortal() != null
											&& intervinientesAux.getNombrePortal() != null
											&& !intervinientesAux.getNombrePortal().equals("")) {
										direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
									}
									if (intervinientesAux.getNombrePiso() != null
											&& intervinientesAux.getNombrePiso() != null
											&& !intervinientesAux.getNombrePiso().equals("")) {
										direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
									}
								} else {
									if (intervinientesAux.getDireccionNocapv() != null
											&& intervinientesAux.getDireccionNocapv() != null
											&& !intervinientesAux.getDireccionNocapv().equals("")) {
										direccionCompleta.append(intervinientesAux.getDireccionNocapv());
									} else {
										direccionCompleta
												.append(Y41bUtils.trataNull(intervinientesAux.getDireccionAntigua()));
									}
								}

								plantillaTramiteINSDecisionDetalle.setEsdireccionEstablecimientoVisitado(
										Y41bUtils.trataNull(direccionCompleta.toString()));

							}
						}
					}
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)) {
					if (actuacion.getAtdestnotificaresponsable() != null && actuacion.getAtdestnotificaresponsable()
							.equals(Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE)) {

						// buscar el representante
						intervinientesAux = new Intervinientes();
						intervinientesAux.setIdExpediente(actuacion.getAtcodigo());
						intervinientesAux.setTipoInterviniente(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE);
						intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

						if (intervinientesAux != null && Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {

							StringBuffer nombreCompleto = new StringBuffer();

							nombreCompleto.append(intervinientesAux.getNombre());

							if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
								nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
							}

							if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
								nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
							}

							plantillaTramiteINSDecisionDetalle
									.setEsnombreResponsableProducto(Y41bUtils.trataNull(nombreCompleto.toString()));
							plantillaTramiteINSDecisionDetalle
									.setEsnocoResponsableProducto(Y41bUtils.trataNull(nombreCompleto.toString()));
							plantillaTramiteINSDecisionDetalle.setEsnifResponsableProducto(intervinientesAux.getNif());

							plantillaTramiteINSDecisionDetalle
									.setEsnombreProvinciaResponsableProducto(intervinientesAux.getNombreProvincia());
							plantillaTramiteINSDecisionDetalle
									.setEsnombreMunicipioResponsableProducto(intervinientesAux.getNombreMunicipio());

							plantillaTramiteINSDecisionDetalle
									.setEsnombreCpResponsableProducto(intervinientesAux.getNombreCp());

							plantillaTramiteINSDecisionDetalle
									.setEsnrtelResponsableProducto(intervinientesAux.getNrtel());
							plantillaTramiteINSDecisionDetalle
									.setEsnrtel2ResponsableProducto(intervinientesAux.getNrtel2());
							plantillaTramiteINSDecisionDetalle
									.setEstecoemResponsableProducto(intervinientesAux.getCoem());

							// Creamos el campo direccion del establecimiento
							StringBuffer direccionCompleta = new StringBuffer();

							if (intervinientesAux != null && intervinientesAux.getNombreCalle() != null
									&& !intervinientesAux.getNombreCalle().equals("")) {
								direccionCompleta.append(intervinientesAux.getNombreCalle());

								if (intervinientesAux.getNombrePortal() != null
										&& intervinientesAux.getNombrePortal() != null
										&& !intervinientesAux.getNombrePortal().equals("")) {
									direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
								}
								if (intervinientesAux.getNombrePiso() != null
										&& intervinientesAux.getNombrePiso() != null
										&& !intervinientesAux.getNombrePiso().equals("")) {
									direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
								}
							} else {
								if (intervinientesAux.getDireccionNocapv() != null
										&& intervinientesAux.getDireccionNocapv() != null
										&& !intervinientesAux.getDireccionNocapv().equals("")) {
									direccionCompleta.append(intervinientesAux.getDireccionNocapv());
								} else {
									direccionCompleta
											.append(Y41bUtils.trataNull(intervinientesAux.getDireccionAntigua()));
								}
							}

							plantillaTramiteINSDecisionDetalle.setEsdireccionResponsableProducto(
									Y41bUtils.trataNull(direccionCompleta.toString()));

						} else {
							// buscar el representante
							intervinientesAux = new Intervinientes();
							intervinientesAux.setIdExpediente(actuacion.getAtcodigo());
							intervinientesAux.setTipoInterviniente(
									Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO);
							intervinientesAux = this.intervinientesDao.findIntervinienteTipo(intervinientesAux);

							if (intervinientesAux != null
									&& Y41bUtils.isFilled(intervinientesAux.getIdinterviniente())) {

								StringBuffer nombreCompleto = new StringBuffer();

								nombreCompleto.append(intervinientesAux.getNombre());

								if (Y41bUtils.isFilled(intervinientesAux.getApellido1())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido1());
								}

								if (Y41bUtils.isFilled(intervinientesAux.getApellido2())) {
									nombreCompleto.append(" ").append(intervinientesAux.getApellido2());
								}

								plantillaTramiteINSDecisionDetalle
										.setEsnombreResponsableProducto(Y41bUtils.trataNull(nombreCompleto.toString()));
								plantillaTramiteINSDecisionDetalle
										.setEsnocoResponsableProducto(Y41bUtils.trataNull(nombreCompleto.toString()));
								plantillaTramiteINSDecisionDetalle
										.setEsnifResponsableProducto(intervinientesAux.getNif());

								plantillaTramiteINSDecisionDetalle.setEsnombreProvinciaResponsableProducto(
										intervinientesAux.getNombreProvincia());
								plantillaTramiteINSDecisionDetalle.setEsnombreMunicipioResponsableProducto(
										intervinientesAux.getNombreMunicipio());

								plantillaTramiteINSDecisionDetalle
										.setEsnombreCpResponsableProducto(intervinientesAux.getNombreCp());

								plantillaTramiteINSDecisionDetalle
										.setEsnrtelResponsableProducto(intervinientesAux.getNrtel());
								plantillaTramiteINSDecisionDetalle
										.setEsnrtel2ResponsableProducto(intervinientesAux.getNrtel2());
								plantillaTramiteINSDecisionDetalle
										.setEstecoemResponsableProducto(intervinientesAux.getCoem());

								// Creamos el campo direccion del
								// establecimiento
								StringBuffer direccionCompleta = new StringBuffer();

								if (intervinientesAux != null && intervinientesAux.getNombreCalle() != null
										&& !intervinientesAux.getNombreCalle().equals("")) {
									direccionCompleta.append(intervinientesAux.getNombreCalle());

									if (intervinientesAux.getNombrePortal() != null
											&& intervinientesAux.getNombrePortal() != null
											&& !intervinientesAux.getNombrePortal().equals("")) {
										direccionCompleta.append(", ").append(intervinientesAux.getNombrePortal());
									}
									if (intervinientesAux.getNombrePiso() != null
											&& intervinientesAux.getNombrePiso() != null
											&& !intervinientesAux.getNombrePiso().equals("")) {
										direccionCompleta.append(" ").append(intervinientesAux.getNombrePiso());
									}
								} else {
									if (intervinientesAux.getDireccionNocapv() != null
											&& intervinientesAux.getDireccionNocapv() != null
											&& !intervinientesAux.getDireccionNocapv().equals("")) {
										direccionCompleta.append(intervinientesAux.getDireccionNocapv());
									} else {
										direccionCompleta
												.append(Y41bUtils.trataNull(intervinientesAux.getDireccionAntigua()));
									}
								}

								plantillaTramiteINSDecisionDetalle.setEsdireccionResponsableProducto(
										Y41bUtils.trataNull(direccionCompleta.toString()));

							}
						}
					}
				}
			}
		}

		// Creamos el campo pie pagina linea1
		StringBuffer piepagina_linea1 = new StringBuffer();

		piepagina_linea1.append(plantillaTramiteINSDecisionDetalle.getDireccionOrganismo()).append(" - ")
				.append(plantillaTramiteINSDecisionDetalle.getCpMunicipioOrganismo()).append(" / ").append(" Tl. ")
				.append(plantillaTramiteINSDecisionDetalle.getTelefonoOrganismo());

		plantillaTramiteINSDecisionDetalle.setPiePaginaLinea1(piepagina_linea1.toString());

		// Creamos el campo pie pagina linea1
		StringBuffer piepagina_linea2 = new StringBuffer();

		piepagina_linea2.append("e-mail: ").append(plantillaTramiteINSDecisionDetalle.getEmailOrganismo()).append(" / ")
				.append(plantillaTramiteINSDecisionDetalle.getWebOrganismo());

		plantillaTramiteINSDecisionDetalle.setPiePaginaLinea2(piepagina_linea2.toString());

		// Transformar el documento en castellano
		String plantilla = Y41bUtils.blobToString(plantillaDecision.getPdplantilla());

		StringBuffer rutaPlantilla = new StringBuffer(
				appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word").toString());

		rutaPlantilla.append(Y41bConstantes.NOMBRE_PLANTILLA_INSPECCIONES_XML_DECISION_CASTELLANO);

		String ficheroGenerado = Y41bGenerarDocumento.generarDocumentoWord(rutaPlantilla.toString(),
				plantillaTramiteINSDecisionDetalle, plantilla);

		return ficheroGenerado;
	}

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Intervinientes addInterviniente(Intervinientes intervinientes) {

		Intervinientes intervinientesAux = null;
		if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
				.getTipoInterviniente().equals(Y41bConstantes.TIPO_POSIBLEINTERVINIENTESOL_CONSUMIDOR)) {
			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(intervinientes.getIdinterviniente());

			// Alta de interviniente consumidor
			consumidor = this.consumidorDao.find(consumidor);

			Intervinientes intervinien = new Intervinientes();
			intervinien.setDtcodigo(intervinientes.getIdinterviniente());
			intervinien.setIdExpediente(intervinientes.getIdExpediente());

			try {
				intervinien = this.intervinientesDao.findIntervinienteConsumidor(intervinien);
			} catch (Exception e) {
				intervinien = null;
			}

			if (intervinien == null) {
				intervinientesAux = new Intervinientes(
						Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), consumidor.getDtcodigo(),
						null, null, consumidor.getDtnombre(), consumidor.getDtapellido1(), consumidor.getDtapellido2(),
						null, consumidor.getDtintipid(), consumidor.getDtnif(), consumidor.getRangoEdad().getRancod(),
						consumidor.getDtcosx(), consumidor.getDtcoidco(), null, null, null, consumidor.getDtnrtel(),
						consumidor.getDtnrtel2(), consumidor.getDttecoem(), consumidor.getDtextranjero(),
						consumidor.getDtnoraProvinciaId(), consumidor.getDtnombreProvincia(),
						consumidor.getDtnoraMunicipioId(), consumidor.getDtnombreMunicipio(),
						consumidor.getDtnoraLocalidadId(), consumidor.getDtnombreLocalidad(),
						consumidor.getDtnoraCalleId(), consumidor.getDtnombreCalle(), consumidor.getDtnoraCpId(),
						consumidor.getDtnombreCp(), consumidor.getDtnoraPortalId(), consumidor.getDtnombrePortal(),
						consumidor.getDtnombrePiso(), consumidor.getDtnoraPaisId(), consumidor.getDtnoraPaisNombre(),
						consumidor.getDtdireccion_nocapv(), null, null, null, null, null,
						Y41bConstantes.TIPO_INTERVINIENTESOL_CONSUMIDOR, intervinientes.getIdExpediente(), null,
						consumidor.getDtfemod(), consumidor.getCensoMonitor().getMocodigo(),
						consumidor.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.add(intervinientesAux);
			} else {
				intervinientesAux = new Intervinientes(intervinien.getIdinterviniente(), consumidor.getDtcodigo(), null,
						null, consumidor.getDtnombre(), consumidor.getDtapellido1(), consumidor.getDtapellido2(), null,
						consumidor.getDtintipid(), consumidor.getDtnif(), consumidor.getRangoEdad().getRancod(),
						consumidor.getDtcosx(), consumidor.getDtcoidco(), null, null, null, consumidor.getDtnrtel(),
						consumidor.getDtnrtel2(), consumidor.getDttecoem(), consumidor.getDtextranjero(),
						consumidor.getDtnoraProvinciaId(), consumidor.getDtnombreProvincia(),
						consumidor.getDtnoraMunicipioId(), consumidor.getDtnombreMunicipio(),
						consumidor.getDtnoraLocalidadId(), consumidor.getDtnombreLocalidad(),
						consumidor.getDtnoraCalleId(), consumidor.getDtnombreCalle(), consumidor.getDtnoraCpId(),
						consumidor.getDtnombreCp(), consumidor.getDtnoraPortalId(), consumidor.getDtnombrePortal(),
						consumidor.getDtnombrePiso(), consumidor.getDtnoraPaisId(), consumidor.getDtnoraPaisNombre(),
						consumidor.getDtdireccion_nocapv(), null, null, null, null, null,
						intervinien.getTipoInterviniente(), intervinientes.getIdExpediente(), null,
						consumidor.getDtfemod(), consumidor.getCensoMonitor().getMocodigo(),
						consumidor.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.update(intervinientesAux);
			}
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
				.getTipoInterviniente().equals(Y41bConstantes.TIPO_POSIBLEINTERVINIENTESOL_ESTABLECIMIENTO)) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(intervinientes.getIdinterviniente());

			// Alta interviniente establecimiento
			establecimiento = this.establecimientoDao.find(establecimiento);

			establecimiento = this.tratamientoAnadirIntervinienteEstablecimiento(establecimiento);

			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimiento);

			EstablecimSector establecSector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			try {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);
				if (establecimArbitra != null) {
					if ("A".equals(establecimiento.getEsinadar())) {
						if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
							establecimiento.setEsinadar("L");
						}
					}
				}
			} catch (Exception e) {

			}

			Intervinientes intervinien = new Intervinientes();
			intervinien.setEscodigo(intervinientes.getIdinterviniente());
			intervinien.setIdExpediente(intervinientes.getIdExpediente());
			intervinien.setTipoInterviniente(intervinientes.getTipoInterviniente());// J
																					// 19/12

			try {
				intervinien = this.intervinientesDao.findIntervinienteEstablecimiento(intervinien);
			} catch (Exception e) {
				intervinien = null;
			}

			if (intervinien == null) {
				intervinientesAux = new Intervinientes(
						Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null,
						establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
						establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
						establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
						establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
						establecimiento.getEscoem(), establecimiento.getEsextranjero(),
						establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
						establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
						establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
						establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
						establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
						establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
						establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
						establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
						establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
						establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
						Y41bConstantes.TIPO_INTERVINIENTESOL_ESTABLECIMIENTO, intervinientes.getIdExpediente(), null,
						establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
						establecimiento.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.add(intervinientesAux);
			} else {
				intervinientesAux = new Intervinientes(intervinien.getIdinterviniente(), null,
						establecimiento.getEscodigo(), null, establecimiento.getEsnombre(), null, null,
						establecimiento.getEsnoco(), null, establecimiento.getEsnif(), null, null,
						establecimiento.getEscoidco(), establecimiento.getEsteurl(), establecimiento.getEsnopeco(),
						establecimiento.getEsfeba(), establecimiento.getEsnrtel(), establecimiento.getEsnrtel2(),
						establecimiento.getEscoem(), establecimiento.getEsextranjero(),
						establecimiento.getEsnoraProvinciaId(), establecimiento.getEsnombreProvincia(),
						establecimiento.getEsnoraMunicipioId(), establecimiento.getEsnombreMunicipio(),
						establecimiento.getEsnoraLocalidadId(), establecimiento.getEsnombreLocalidad(),
						establecimiento.getEsnoraCalleId(), establecimiento.getEsnombreCalle(),
						establecimiento.getEsnoraCpId(), establecimiento.getEsnombreCp(),
						establecimiento.getEsnoraPortalId(), establecimiento.getEsnombrePortal(),
						establecimiento.getEsnombrePiso(), establecimiento.getEsnoraPaisId(),
						establecimiento.getEsnoraPaisNombre(), establecimiento.getEsdireccion_nocapv(), null,
						establecimiento.getEsinadar(), establecSector.getSector().getSecodigo(),
						establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
						intervinien.getTipoInterviniente(), intervinientes.getIdExpediente(), null,
						establecimiento.getEsfemod(), establecimiento.getCensoMonitor().getMocodigo(),
						establecimiento.getCensoMonitor().getUsuarioxlnet());

				this.intervinientesDao.update(intervinientesAux);
			}
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_POSIBLEINTERVINIENTESOL_OTROS)) {
			Organismo organismo = new Organismo();
			organismo.setEntidadId(intervinientes.getIdinterviniente());

			// Alta de interviniente consumidor
			organismo = this.organismoDao.findOrganismoById(organismo);

			String esExtranjero = (organismo.getIsnacional().equals("S")) ? "N" : "S";

			Intervinientes intervinien = new Intervinientes();
			intervinien.setEntidadId(intervinientes.getIdinterviniente());
			intervinien.setIdExpediente(intervinientes.getIdExpediente());

			try {
				intervinien = this.intervinientesDao.findIntervinienteEntidad(intervinien);
			} catch (Exception e) {
				intervinien = null;
			}

			if (intervinien == null) {
				intervinientesAux = new Intervinientes(
						Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE), null, null,
						organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(),
						null, null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null,
						organismo.getEmail(), esExtranjero, organismo.getNoraProvinciaId(),
						organismo.getNombreProvincia(), organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(),
						organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(), organismo.getNoraCalleId(),
						organismo.getNombreCalle(), organismo.getNoraCpId(), organismo.getNombreCp(),
						organismo.getNoraPortalId(), organismo.getNombrePortal(), organismo.getCompleDirec(),
						organismo.getNoraPaisId(), organismo.getNombrePais(), organismo.getNombreCalle(), null, null,
						null, null, null, Y41bConstantes.TIPO_INTERVINIENTESOL_OTROS, intervinientes.getIdExpediente(),
						null, null, null, null);

				this.intervinientesDao.add(intervinientesAux);
			} else {
				intervinientesAux = new Intervinientes(intervinien.getIdinterviniente(), null, null,
						organismo.getEntidadId(), organismo.getNombreEs(), null, null, null, null, organismo.getCif(),
						null, null, null, organismo.getUrl(), null, null, organismo.getTelefono(), null,
						organismo.getEmail(), esExtranjero, organismo.getNoraProvinciaId(),
						organismo.getNombreProvincia(), organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(),
						organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(), organismo.getNoraCalleId(),
						organismo.getNombreCalle(), organismo.getNoraCpId(), organismo.getNombreCp(),
						organismo.getNoraPortalId(), organismo.getNombrePortal(), organismo.getCompleDirec(),
						organismo.getNoraPaisId(), organismo.getNombrePais(), organismo.getNombreCalle(), null, null,
						null, null, null, intervinien.getTipoInterviniente(), intervinientes.getIdExpediente(), null,
						null, null, null);

				this.intervinientesDao.update(intervinientesAux);
			}
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && (intervinientes
				.getTipoInterviniente()
				.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO)
				|| intervinientes.getTipoInterviniente().equals(
						Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO))) {

			intervinientes.setIdinterviniente(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			if (intervinientes.getExtranjero().equalsIgnoreCase(Y41bConstantes.NO)) {
				intervinientes.setNoraPaisId(null);
				intervinientes.setNombrePais(null);

				if (intervinientes.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_ARABA)
						|| intervinientes.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)
						|| intervinientes.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
					intervinientes.setDireccionNocapv(null);
				} else {
					intervinientes.setNombreCalle(null);
					intervinientes.setNoraCalleId(null);
					intervinientes.setNoraPortalId(null);
					intervinientes.setNombrePortal(null);
					intervinientes.setNombrePiso(null);
				}
			} else {
				intervinientes.setNoraProvinciaId(null);
				intervinientes.setNombreProvincia(null);
				intervinientes.setNoraMunicipioId(null);
				intervinientes.setNombreMunicipio(null);
				intervinientes.setNoraLocalidadId(null);
				intervinientes.setNombreLocalidad(null);
				intervinientes.setNoraCalleId(null);
				intervinientes.setNombreCalle(null);
				intervinientes.setNoraPortalId(null);
				intervinientes.setNombrePortal(null);
				intervinientes.setNombrePiso(null);
			}

			intervinientesAux = this.intervinientesDao.add(intervinientes);
		}

		return intervinientesAux;
	}

	/**
	 * Deletes a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeInterviniente(Intervinientes intervinientes) {

		try {
			intervinientes = this.intervinientesDao.find(intervinientes);

			// No se puede eliminar a un establecimiento visitado ni a un
			// establecimiento responsable.
			if (intervinientes.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_INS_VISITADO)
					|| intervinientes.getTipoInterviniente()
							.equals(Y41bConstantes.TIPO_INTERVINIENTE_INS_RESPONSABLE)) {
				throw new Y41bUDAException("error.interviniente.InspeccionesDeleteException", true, new Exception());
			}

			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5hdcodigo(intervinientes.getIdExpediente());
			documentoHecho.setQ5idinterviniente(intervinientes.getIdinterviniente());

			Long numdocumentosAportadosInterviniente = this.documentoHechoDao
					.findAllDocumentosAportadosIntervinienteCount(documentoHecho);

			if (numdocumentosAportadosInterviniente > 0) {
				throw new Y41bUDAException("error.interviniente.DeleteAportacionException", true, new Exception());
			}

			this.intervinientesDao.remove(intervinientes);

			if (intervinientes != null && intervinientes.getTipoInterviniente() != null
					&& intervinientes.getTipoInterviniente()
							.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)) {

				Actuacion actuacion = new Actuacion();
				actuacion.setAtcodigo(intervinientes.getIdExpediente());
				actuacion = this.actuacionDao.findByActa(actuacion);

				// Actualizamos la participacoion del establecimiento visitado
				if (actuacion != null && actuacion.getAtenplatea() != null
						&& actuacion.getAtenplatea().equals(Y41bConstantes.VALOR_SI)) {
					TramiteComun tramiteComun = new TramiteComun();
					tramiteComun.setIdExpediente(actuacion.getAtcodigo());

					this.instramexpService.actualizarParticipacionEstablecimientoVisitado(tramiteComun);

				}
			} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
					&& intervinientes.getTipoInterviniente()
							.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)) {
				Actuacion actuacion = new Actuacion();
				actuacion.setAtcodigo(intervinientes.getIdExpediente());
				actuacion = this.actuacionDao.findByActa(actuacion);

				// Actualizamos la participacoion del establecimiento visitado
				if (actuacion != null && actuacion.getAtparticipacionresponsable() != null
						&& actuacion.getAtparticipacionresponsable().equals(Y41bConstantes.VALOR_SI)) {
					TramiteComun tramiteComun = new TramiteComun();
					tramiteComun.setIdExpediente(actuacion.getAtcodigo());

					this.instramexpService.actualizarParticipacionEstablecimientoResponsable(tramiteComun);

				}
			}

		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.interviniente.DataIntegrityViolationException", true, e);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Update a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void eliminarRepresentacion(Intervinientes intervinientes) throws Exception {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(intervinientes.getIdExpediente());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)
						|| intervinientes.getTipoInterviniente().equals(
								Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO))) {

			intervinientes.setTipoInterviniente(
					Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_ANTERIOR);

			this.intervinientesDao.updateTipoInterviniente(intervinientes);

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(intervinientes.getIdExpediente());
			actuacion = this.actuacionDao.findByActa(actuacion);

			// Actualizamos la participacoion del establecimiento visitado
			if (actuacion != null && actuacion.getAtenplatea() != null
					&& actuacion.getAtenplatea().equals(Y41bConstantes.VALOR_SI)) {
				this.instramexpService.actualizarParticipacionEstablecimientoVisitado(tramiteComun);
			}
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && (intervinientes
				.getTipoInterviniente()
				.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)
				|| intervinientes.getTipoInterviniente().equals(
						Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO))) {
			intervinientes.setTipoInterviniente(
					Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_ANTERIOR);

			this.intervinientesDao.updateTipoInterviniente(intervinientes);

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(intervinientes.getIdExpediente());
			actuacion = this.actuacionDao.findByActa(actuacion);

			// Actualizamos la participacoion del establecimiento visitado
			if (actuacion != null && actuacion.getAtparticipacionresponsable() != null
					&& actuacion.getAtparticipacionresponsable().equals(Y41bConstantes.VALOR_SI)) {
				this.instramexpService.actualizarParticipacionEstablecimientoResponsable(tramiteComun);
			}

		}
	}

	/**
	 * Update a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void validarRepresentacion(Intervinientes intervinientes) throws Exception {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(intervinientes.getIdExpediente());

		intervinientes = this.intervinientesDao.find(intervinientes);

		if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente()
						.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO))) {

			intervinientes
					.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO);

			this.intervinientesDao.updateTipoInterviniente(intervinientes);

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(intervinientes.getIdExpediente());
			actuacion = this.actuacionDao.findByActa(actuacion);

			// Actualizamos la participacoion del establecimiento visitado
			if (actuacion != null && actuacion.getAtenplatea() != null
					&& actuacion.getAtenplatea().equals(Y41bConstantes.VALOR_SI)) {
				this.instramexpService.actualizarParticipacionEstablecimientoVisitado(tramiteComun);
			} else {
				throw new Y41bUDAException("error.representante.validarRepresentacionException", true, new Exception());
			}
		} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
				&& (intervinientes.getTipoInterviniente().equals(
						Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO))) {

			intervinientes
					.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE);

			this.intervinientesDao.updateTipoInterviniente(intervinientes);

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(intervinientes.getIdExpediente());
			actuacion = this.actuacionDao.findByActa(actuacion);

			// Actualizamos la participacoion del establecimiento visitado
			if (actuacion != null && actuacion.getAtparticipacionresponsable() != null
					&& actuacion.getAtparticipacionresponsable().equals(Y41bConstantes.VALOR_SI)) {
				this.instramexpService.actualizarParticipacionEstablecimientoResponsable(tramiteComun);
			} else {
				throw new Y41bUDAException("error.representante.validarRepresentacionException", true, new Exception());
			}
		}
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de aportacion de
	 * documentacion realizado
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarMisGestionesAportaciondocumentacion(TramiteInspeccion tramiteinspeccion,
			List<DocumentoHecho> listDocumentoHecho) throws Exception {

		// Obtengo la información del expediente
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteinspeccion.getTiatcodigo());

		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		int establecimientoVisitado = 0;
		int establecimientoResponsable = 0;
		for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
			if (documentoHechoAux.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO) || documentoHechoAux
					.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO)) {
				establecimientoVisitado++;
			} else if (documentoHechoAux.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE)
					|| documentoHechoAux.getQ5origen()
							.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE)) {
				establecimientoResponsable++;
			}
		}

		if (establecimientoVisitado > 0) {
			this.actualizarMisGestionesAportaciondocumentacionEstablecimientoVisitado(tramiteinspeccion, insDetalle,
					listDocumentoHecho);
		}

		if (establecimientoResponsable > 0) {
			this.actualizarMisGestionesAportaciondocumentacionEstablecimientoResponsable(tramiteinspeccion, insDetalle,
					listDocumentoHecho);
		}
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de aportacion de
	 * documentacion realizado por el establecimiento visitado
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @param insDetalle
	 *            InspeccionDetalle
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws Exception
	 *             Exception
	 */
	private void actualizarMisGestionesAportaciondocumentacionEstablecimientoVisitado(
			TramiteInspeccion tramiteinspeccion, InspeccionDetalle insDetalle, List<DocumentoHecho> listDocumentoHecho)
			throws Exception {

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteinspeccion.getTiatcodigo());

		InspeccionDetalle insDetalleAux = this.actaDao.findInspeccion(actuacion);

		List<Documento> listaDocumentosRdo = null;
		Date fechaAportacion = null;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (DocumentoHecho documentoHecho : listDocumentoHecho) {
				if (documentoHecho.getQ5origen() != null
						&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO)
								|| documentoHecho.getQ5origen()
										.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO))) {
					if (fechaAportacion == null) {
						fechaAportacion = documentoHecho.getQ5fechaentrada();
					} else if (documentoHecho.getQ5fechaentrada() != null
							&& documentoHecho.getQ5fechaentrada().after(fechaAportacion)) {
						fechaAportacion = documentoHecho.getQ5fechaentrada();
					}
					documento = new Documento();
					documento.setNombre(documentoHecho.getQ5nofile());
					documento.setDescripcion(documentoHecho.getQ5tedesfile());
					documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
					documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
					listaDocumentosRdo.add(documento);
				}
			}
		}

		if (insDetalleAux != null && insDetalleAux.getAtenplatea() == null) {
			try {
				Calendar aperturaTimestamp = Calendar.getInstance();

				String idioma = LocaleContextHolder.getLocale().getLanguage();

				String fechaAportacionSinHoras = Y41bUtils.parseDateToString(fechaAportacion, idioma);

				String fechaAportacionConHoras = "";

				fechaAportacionConHoras = new StringBuffer().append(fechaAportacionSinHoras).append(" 00:00:00")
						.toString();
				aperturaTimestamp
						.setTime(Y41bUtils.parseDateTime(fechaAportacionConHoras, LocaleContextHolder.getLocale()));

				insDetalleAux.setAperturaTimestamp(aperturaTimestamp);

				this.instramexpService.abrirExpedienteOficioPlatea(insDetalleAux, null);

				// Se actualiza campo ATENPLATE a S (indica que el expediente
				// est
				// abierto en PLATEA)
				this.actuacionDao.updateEnPLATEA(actuacion);
			} catch (Y41bUDAException e) {
				throw e;
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
		}

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

		actualizarMisGestiones.setProcedure(procedure);

		actualizarMisGestiones.setIdParticipacion(insDetalle.getAtidparticipacionvisitado());

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(insDetalle.getEstablecimientoV().getNif());

		StringBuffer nombreCompleto = new StringBuffer();

		nombreCompleto.append(insDetalle.getEstablecimientoV().getNombre());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoV().getApellido1());
		}

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido2())) {
			nombreCompleto.append(" ").append(insDetalle.getEstablecimientoV().getApellido2());
		}

		datosPersona.setNombre(nombreCompleto.toString());

		if (Y41bUtils.isFilled(insDetalle.getEstablecimientoV().getApellido1())) {
			datosPersona.setApellido1(insDetalle.getEstablecimientoV().getApellido1());
		}

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
				.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
				.append(insDetalle.getAtnror());

		actualizarMisGestiones.setEjercicio(insDetalle.getAcnran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		if (Y41bUtils.isFilled(tramiteinspeccion.getTiproceedingsidplatea())) {
			actualizarMisGestiones.setProceedingsID(tramiteinspeccion.getTiproceedingsidplatea());
		} else {
			actualizarMisGestiones.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
		}

		actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

		Calendar aportacionTimestamp = Calendar.getInstance();

		String fechaAportacionSinHoras = Y41bUtils.parseDateToString(fechaAportacion, Y41bConstantes.CASTELLANO);

		String fechaAportacionConHoras = "";

		fechaAportacionConHoras = new StringBuffer().append(fechaAportacionSinHoras).append(" 01:00:00").toString();
		aportacionTimestamp
				.setTime(Y41bUtils.parseDateTime(fechaAportacionConHoras, new Locale(Y41bConstantes.CASTELLANO)));

		actualizarMisGestiones.setAportacionTimestamp(aportacionTimestamp);

		// Los documentos son de origen interesado
		if (listaDocumentosRdo != null && listaDocumentosRdo.size() > 0) {
			actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

			y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);

			tramiteinspeccion.setTiproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.tramiteInspeccionDao.updateProceedingsIdPlatea(tramiteinspeccion);
		}
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de aportacion de
	 * documentacion realizado por el establecimiento responsable
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @param insDetalle
	 *            InspeccionDetalle
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws Exception
	 *             Exception
	 */
	private void actualizarMisGestionesAportaciondocumentacionEstablecimientoResponsable(
			TramiteInspeccion tramiteinspeccion, InspeccionDetalle insDetalle, List<DocumentoHecho> listDocumentoHecho)
			throws Exception {

		tramiteinspeccion = this.tramiteInspeccionDao.find(tramiteinspeccion);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(tramiteinspeccion.getTiatcodigo());

		InspeccionDetalle insDetalleAux = this.actaDao.findInspeccion(actuacion);

		// Si esta en PLATEA la participacin del responsable se escribe en Mi
		// Carpeta
		if (insDetalleAux != null && insDetalleAux.getAtparticipacionresponsable() != null
				&& insDetalleAux.getAtparticipacionresponsable().equals(Y41bConstantes.VALOR_SI)) {

			List<Documento> listaDocumentosRdo = null;
			Date fechaAportacion = null;
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
				listaDocumentosRdo = new ArrayList<Documento>();
				Documento documento = null;
				for (DocumentoHecho documentoHecho : listDocumentoHecho) {
					if (documentoHecho.getQ5origen() != null
							&& (documentoHecho.getQ5origen().equals(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE)
									|| documentoHecho.getQ5origen()
											.equals(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE))) {
						if (fechaAportacion == null) {
							fechaAportacion = documentoHecho.getQ5fechaentrada();
						} else if (documentoHecho.getQ5fechaentrada() != null
								&& documentoHecho.getQ5fechaentrada().after(fechaAportacion)) {
							fechaAportacion = documentoHecho.getQ5fechaentrada();
						}
						documento = new Documento();
						documento.setNombre(documentoHecho.getQ5nofile());
						documento.setDescripcion(documentoHecho.getQ5tedesfile());
						documento.setOidDokusi(documentoHecho.getQ5iddocumentum());
						documento.setTipoDocumental(documentoHecho.getQ5idTipodoc());
						listaDocumentosRdo.add(documento);
					}
				}
			}

			ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);

			actualizarMisGestiones.setProcedure(procedure);

			actualizarMisGestiones.setIdParticipacion(insDetalle.getAtidparticipacionresponsable());

			DatosPersona datosPersona = new DatosPersona();
			datosPersona.setDni(insDetalle.getEstablecimientoR().getNif());

			StringBuffer nombreCompleto = new StringBuffer();

			nombreCompleto.append(insDetalle.getEstablecimientoR().getNombre());

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido1())) {
				nombreCompleto.append(" ").append(insDetalle.getEstablecimientoR().getApellido1());
			}

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido2())) {
				nombreCompleto.append(" ").append(insDetalle.getEstablecimientoR().getApellido2());
			}

			datosPersona.setNombre(nombreCompleto.toString());

			if (Y41bUtils.isFilled(insDetalle.getEstablecimientoR().getApellido1())) {
				datosPersona.setApellido1(insDetalle.getEstablecimientoR().getApellido1());
			}

			actualizarMisGestiones.setSolicitante(datosPersona);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(Y41bConstantes.TIPO_PROC_INSPECCIONES).append("-").append(insDetalle.getAccoor())
					.append("-").append(insDetalle.getAcnror()).append("-").append(insDetalle.getAcnran()).append("-")
					.append(insDetalle.getAtnror());

			actualizarMisGestiones.setEjercicio(insDetalle.getAcnran().toString());

			actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

			if (Y41bUtils.isFilled(tramiteinspeccion.getTiproceedingsidplatea())) {
				actualizarMisGestiones.setProceedingsID(tramiteinspeccion.getTiproceedingsidplatea());
			} else {
				actualizarMisGestiones.setProceedingsID(this.tramiteInspeccionService.getNewEsperaPK().toString());
			}

			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

			Calendar aportacionTimestamp = Calendar.getInstance();

			String fechaAportacionSinHoras = Y41bUtils.parseDateToString(fechaAportacion, Y41bConstantes.CASTELLANO);

			String fechaAportacionConHoras = "";

			fechaAportacionConHoras = new StringBuffer().append(fechaAportacionSinHoras).append(" 01:00:00").toString();
			aportacionTimestamp
					.setTime(Y41bUtils.parseDateTime(fechaAportacionConHoras, new Locale(Y41bConstantes.CASTELLANO)));

			actualizarMisGestiones.setAportacionTimestamp(aportacionTimestamp);

			// Los documentos son de origen interesado
			if (listaDocumentosRdo != null && listaDocumentosRdo.size() > 0) {
				actualizarMisGestiones.setDocumentos(listaDocumentosRdo);

				y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);

				tramiteinspeccion.setTiproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
				this.tramiteInspeccionDao.updateProceedingsIdPlatea(tramiteinspeccion);
			}
		}
	}

	/**
	 * Inserts a single row in the Tramite Inspeccion table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param mensajeAportacionDoc
	 *            MensajeAportacionDocumentacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarTramiteAportacionDocumentacion(InspeccionDetalle inspeccionDetalle,
			MensajeAportacionDocumentacion mensajeAportacionDoc) throws Exception {

		try {
			inspeccionDetalle = this.actaDao.findInspeccionByNumeroExpediente(inspeccionDetalle);

			TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
			tramiteinspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramiteinspeccion.setTiatcodigo(inspeccionDetalle.getAtcodigo());
			tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION);

			tramiteinspeccion.setTifechainicio(new Date());

			tramiteinspeccion.setTiistelematico(Y41bConstantes.VALOR_SI);
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);

			// buscar el interviniente por el DNI
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setNif(mensajeAportacionDoc.getSender());
			intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
			intervinientes = this.intervinientesDao.findIntervinienteByNif(intervinientes);

			List<Documento> listDocumentos = mensajeAportacionDoc.getDocumentosAportados();

			String tipodocumento = "";

			for (Documento documentoAux : listDocumentos) {
				if (Y41bUtils.isFilled(documentoAux.getOidDokusi())) {
					// descargar documentos dokusi
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoAux.getOidDokusi());

					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusiSinDocumento(documento);

					// insertar el documento
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5codocumento(String.valueOf(this.documentoHechoDao.getNewPK().intValue()));
					documentoHecho.setQ5hdcodigo(inspeccionDetalle.getAtcodigo());
					documentoHecho.setQ5nofile(docDokusi.getNombre());
					documentoHecho.setQ5tedesfile(documentoAux.getDescripcion());
					documentoHecho.setQ5iddocumentum(documentoAux.getOidDokusi());
					documentoHecho.setQ5sizefile((int) docDokusi.getLength());
					// Blob blob = new
					// SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
					// documentoHecho.setQ5datafile(blob);
					documentoHecho.setQ5contenttypefile(docDokusi.getContentType());
					documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO);

					if (intervinientes != null && intervinientes.getTipoInterviniente() != null) {
						if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO);
						} else if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO);
						} else if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE);
						} else if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE);
						} else {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_OTROS);
						}
					}

					documentoHecho.setQ5idinterviniente(intervinientes.getIdinterviniente());

					SimpleDateFormat formatterFechaRegistro = new SimpleDateFormat(
							Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT);
					Date dateFechaRegistro = formatterFechaRegistro
							.parse(mensajeAportacionDoc.getRegistro().getRegistryTimestamp());
					documentoHecho.setQ5fecha(dateFechaRegistro);
					documentoHecho.setQ5fechaaportacion(dateFechaRegistro);
					documentoHecho.setQ5tramite(tramiteinspeccion.getTicodigo());

					documentoHecho.setQ5fechaentrada(dateFechaRegistro);
					documentoHecho.setQ5numregistroentrada(mensajeAportacionDoc.getRegistro().getRegistryNumber());

					if (documentoAux.getTipoDocumental() != null) {
						tipodocumento = this.getTipoDocumento(documentoAux.getTipoDocumental());
					}
					documentoHecho.setQ5idTipodoc(tipodocumento);

					this.documentoHechoDao.add(documentoHecho);

					// insertar en la tabla de relacion
					DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
					documentoTramiteHecho.setEhcodigo(tramiteinspeccion.getTicodigo());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);

					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteinspeccion.getTicodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComunAux,
					null);

			this.actualizarMisGestionesAportaciondocumentacion(tramiteinspeccion, listDocumentoHecho);

			BandejaInspecciones bandejaInspecciones = new BandejaInspecciones();
			bandejaInspecciones.setAtcodigo(inspeccionDetalle.getAtcodigo());

			this.bandejaInspeccionesService.updateUltimoTramite(bandejaInspecciones);

		} catch (Y41bUDAException e) {
			logger.error("generarTramiteAportacionDocumentacion ERROR ***** ", e);
			throw e;
		} catch (Exception e_tratamientoAportacionDocumentacion) {
			logger.error("generarTramiteAportacionDocumentacion ERROR ***** ", e_tratamientoAportacionDocumentacion);
			throw new Y41bUDAException("error.platea.invocation", true, e_tratamientoAportacionDocumentacion);
		} finally {
			logger.info("generarTramiteAportacionDocumentacion - Final");
		}

	}

	/**
	 * getTipoDocumento
	 * 
	 * @param roleId
	 *            String
	 * @return String
	 */
	protected String getTipoDocumento(String roleId) {
		StringTokenizer tokCadena = null;
		tokCadena = new StringTokenizer(roleId, ".");
		String tipo = tokCadena.nextToken();
		String subtipo = tokCadena.nextToken();
		if (subtipo != null && !subtipo.equals("0")) {
			tipo = subtipo;
		} else {
			String asuntoDocumental = tokCadena.nextToken();
			if (asuntoDocumental != null && !asuntoDocumental.equals("0")) {
				tipo = roleId;
			}
		}

		return tipo;
	}

	/**
	 * Finds a List of rows in the Inspeccion table.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * 
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<FiltroInspeccion> findAllInspeccionesRelacionar(FiltroInspeccion filtroInspeccion, String atcodigo,
			String relacionados, Pagination pagination) {

		// Control para poder paginar por un campo calculado - numeroExpediente
		// //ASCENDENTE
		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("numExpediente")) {
			pagination.setSort("accoor, acnror, acnran");
		}

		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("numExpediente")) {
			pagination.setSort("accoor DESC, acnror DESC, acnran");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("monombreExpediente")) {
			pagination.setSort("MONOMBRE");
		}

		try {
			List<FiltroInspeccion> listFiltroInspeccion = this.actuacionDao
					.findAllInspeccionesRelacionar(filtroInspeccion, atcodigo, relacionados, pagination);

			for (FiltroInspeccion ins : listFiltroInspeccion) {
				StringBuffer numeroExpediente = new StringBuffer();

				numeroExpediente.append(ins.getAccoor()).append("-").append(ins.getAcnror()).append("-")
						.append(ins.getAcnran()).append("-").append(ins.getAtnror());

				ins.setNumExpediente(numeroExpediente.toString());
			}

			return listFiltroInspeccion;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Counts rows in the Inspeccion table.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @return Long
	 */
	public Long findAllCountInspeccionesRelacionar(FiltroInspeccion filtroInspeccion, String atcodigo,
			String relacionados) {
		return this.actuacionDao.findAllCountInspeccionesRelacionar(filtroInspeccion, atcodigo, relacionados);
	}

	/**
	 * Finds a List of rows in the Inspeccion table.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<FiltroInspeccion> findAllInspeccionesRelacionarNuevaSancion(FiltroInspeccion filtroInspeccion,
			String atcodigo, String relacionados, Pagination pagination) {

		// Control para poder paginar por un campo calculado - numeroExpediente
		// //ASCENDENTE
		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("numExpediente")) {
			pagination.setSort("accoor, acnror, acnran");
		}

		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("numExpediente")) {
			pagination.setSort("accoor DESC, acnror DESC, acnran");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("monombreExpediente")) {
			pagination.setSort("MONOMBRE");
		}

		try {
			List<FiltroInspeccion> listFiltroInspeccion = this.actuacionDao
					.findAllInspeccionesRelacionarNuevaSancion(filtroInspeccion, atcodigo, relacionados, pagination);

			for (FiltroInspeccion ins : listFiltroInspeccion) {
				StringBuffer numeroExpediente = new StringBuffer();

				numeroExpediente.append(ins.getAccoor()).append("-").append(ins.getAcnror()).append("-")
						.append(ins.getAcnran()).append("-").append(ins.getAtnror());

				ins.setNumExpediente(numeroExpediente.toString());
			}

			return listFiltroInspeccion;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Counts rows in the Inspecciones table.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @return Long
	 */
	public Long findAllCountInspeccionesRelacionarNuevaSancion(FiltroInspeccion filtroInspeccion, String atcodigo,
			String relacionados) {
		return this.actuacionDao.findAllCountInspeccionesRelacionarNuevaSancion(filtroInspeccion, atcodigo,
				relacionados);
	}

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return EstablecimientoDetalle
	 */
	public EstablecimientoDetalle findIntervinienteEstablecimientoResponsable(Intervinientes intervinientes) {

		// buscar el interviniente interesado
		Intervinientes intervinientesAux = new Intervinientes();
		intervinientesAux.setIdExpediente(intervinientes.getIdExpediente());
		intervinientesAux.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientesAux, null);

		if (listIntervinientes == null || listIntervinientes.size() > 0) {
			intervinientes.setEscodigo(listIntervinientes.get(0).getEscodigo());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);// J
			// 19/12
		}

		Intervinientes intervinien = this.intervinientesDao.findIntervinienteEstablecimiento(intervinientes);

		EstablecimientoDetalle establecidetalle = new EstablecimientoDetalle(intervinien.getEscodigo(),
				intervinien.getIncozs(), null, intervinien.getUsuarioxlnet(), intervinien.getNombre(), null,
				intervinien.getNif(), null, intervinien.getEsnoco(), null, null, null, intervinien.getNrtel(), null,
				null, null, null, null, intervinien.getInadar(), null, intervinien.getCoem(), null, null,
				intervinien.getNrtel2(), null, intervinien.getEsfeba(), null, null, null, null, null,
				intervinien.getEsnopeco(), null, null, intervinien.getInfemod(), null, null, null, null, null, null,
				intervinien.getEsteurl(), null, null, null, null, null, intervinien.getNoraPaisId(),
				intervinien.getNombrePais(), intervinien.getNoraProvinciaId(), intervinien.getNombreProvincia(),
				intervinien.getNoraMunicipioId(), intervinien.getNombreMunicipio(), intervinien.getNoraLocalidadId(),
				intervinien.getNombreLocalidad(), intervinien.getNoraCalleId(), intervinien.getNombreCalle(),
				intervinien.getNoraCpId(), intervinien.getNombreCp(), intervinien.getNoraPortalId(),
				intervinien.getNombrePortal(), intervinien.getNombrePiso(), intervinien.getDireccionNocapv(),
				intervinien.getDireccionCompleta(), null, null, null, null, null, intervinien.getSecodigo(),
				intervinien.getSenombre(), intervinien.getSenombree(), null, intervinien.getExtranjero(), null);

		// buscar establecimiento
		Establecimiento establecimiento = new Establecimiento();
		establecimiento.setEscodigo(intervinien.getEscodigo());
		Establecimiento estableci = (Establecimiento) this.establecimientoDao.find(establecimiento);

		establecidetalle.setEsfeadar(estableci.getEsfeadar());
		establecidetalle.setEsintiar(estableci.getEsintiar());
		establecidetalle.setEsfeerd(estableci.getEsfeerd());
		establecidetalle.setEssede(estableci.getEssede());
		establecidetalle.setEsteco(estableci.getEsteco());
		establecidetalle.setEstipid(estableci.getEstipid());

		// Mail de avisos
		establecidetalle.setEsmailnotificacion(estableci.getEsmailnotificacion());

		// 0157454 reapertura nota (0209071)
		establecidetalle.setEsfeba(estableci.getEsfeba());
		// Datos aadidos por especificacin en arbitraje
		establecidetalle.setEscooe(estableci.getEscooe());
		establecidetalle.setEsnorep(estableci.getEsnorep());
		establecidetalle.setEsnifrep(estableci.getEsnifrep());

		// Buscar arbitraje
		try {
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.getEstablecimiento().setEscodigo(estableci.getEscodigo());
			establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
			establecidetalle.setAhfeba(establecimArbitra.getAhfeba());
			establecidetalle.setAhtelimi(establecimArbitra.getAhtelimi());
			// Datos aadidos por especificacin en arbitraje
			establecidetalle.setAhcodigo(establecimArbitra.getAhcodigo());
			establecidetalle.setAhcoja(establecimArbitra.getAhcoja());
			establecidetalle.setEsinadar(estableci.getEsinadar());
			establecidetalle.setAhfere(establecimArbitra.getAhfere());
			establecidetalle.setAhindef(establecimArbitra.getAhindef());
			establecidetalle.setAhmedia(establecimArbitra.getAhmedia());
			establecidetalle.setAhnrdi(establecimArbitra.getAhnrdi().toString());
			if ("A".equals(estableci.getEsinadar())) {
				if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
					establecidetalle.setEsinadar("L");
				}
			}
		} catch (Exception e) {

		}

		// Buscar sedes
		// buscar sedes
		if (establecidetalle.getEssede() != null && establecidetalle.getEssede().equals(Y41bConstantes.SI)) {
			Sede sede = new Sede();
			sede.setEscodigo(establecidetalle.getEscodigo());

			List<Sede> listSede = this.sedeDao.findAll(sede, null);
			establecidetalle.setSedes(listSede);
		}

		List<Descriptor> listDescriptor = this.establecimientoDao.findAllEstablecimientoDescriptor(estableci, null);

		StringBuffer strIdsDescriptores = new StringBuffer();
		StringBuffer strDescsDescriptores = new StringBuffer();

		strDescsDescriptores.append("[");

		boolean firstElement = true;

		// se recorre para obtener los ids de etiquetas
		for (Descriptor descriptor : listDescriptor) {
			if (firstElement) {
				strIdsDescriptores.append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(descriptor.getNombre());
				firstElement = false;
			} else {
				strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(",").append(descriptor.getNombre());
			}
		}

		strDescsDescriptores.append("]");

		establecidetalle.setIdsDescriptores(strIdsDescriptores.toString());
		establecidetalle.setDescsDescriptores(strDescsDescriptores.toString());

		return establecidetalle;
	}

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return EstablecimientoDetalle
	 */
	public EstablecimientoDetalle findIntervinienteEstablecimientoVisitado(Intervinientes intervinientes) {

		// buscar el interviniente interesado
		Intervinientes intervinientesAux = new Intervinientes();
		intervinientesAux.setIdExpediente(intervinientes.getIdExpediente());
		intervinientesAux.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

		List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientesAux, null);

		if (listIntervinientes == null || listIntervinientes.size() > 0) {
			intervinientes.setEscodigo(listIntervinientes.get(0).getEscodigo());
			intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);// J
			// 19/12
		}

		Intervinientes intervinien = this.intervinientesDao.findIntervinienteEstablecimiento(intervinientes);

		EstablecimientoDetalle establecidetalle = new EstablecimientoDetalle(intervinien.getEscodigo(),
				intervinien.getIncozs(), null, intervinien.getUsuarioxlnet(), intervinien.getNombre(), null,
				intervinien.getNif(), null, intervinien.getEsnoco(), null, null, null, intervinien.getNrtel(), null,
				null, null, null, null, intervinien.getInadar(), null, intervinien.getCoem(), null, null,
				intervinien.getNrtel2(), null, intervinien.getEsfeba(), null, null, null, null, null,
				intervinien.getEsnopeco(), null, null, intervinien.getInfemod(), null, null, null, null, null, null,
				intervinien.getEsteurl(), null, null, null, null, null, intervinien.getNoraPaisId(),
				intervinien.getNombrePais(), intervinien.getNoraProvinciaId(), intervinien.getNombreProvincia(),
				intervinien.getNoraMunicipioId(), intervinien.getNombreMunicipio(), intervinien.getNoraLocalidadId(),
				intervinien.getNombreLocalidad(), intervinien.getNoraCalleId(), intervinien.getNombreCalle(),
				intervinien.getNoraCpId(), intervinien.getNombreCp(), intervinien.getNoraPortalId(),
				intervinien.getNombrePortal(), intervinien.getNombrePiso(), intervinien.getDireccionNocapv(),
				intervinien.getDireccionCompleta(), null, null, null, null, null, intervinien.getSecodigo(),
				intervinien.getSenombre(), intervinien.getSenombree(), null, intervinien.getExtranjero(), null);

		// buscar establecimiento
		Establecimiento establecimiento = new Establecimiento();
		establecimiento.setEscodigo(intervinien.getEscodigo());
		Establecimiento estableci = (Establecimiento) this.establecimientoDao.find(establecimiento);

		establecidetalle.setEsfeadar(estableci.getEsfeadar());
		establecidetalle.setEsintiar(estableci.getEsintiar());
		establecidetalle.setEsfeerd(estableci.getEsfeerd());
		establecidetalle.setEssede(estableci.getEssede());
		establecidetalle.setEsteco(estableci.getEsteco());
		establecidetalle.setEstipid(estableci.getEstipid());

		// Mail de avisos
		establecidetalle.setEsmailnotificacion(estableci.getEsmailnotificacion());

		// 0157454 reapertura nota (0209071)
		establecidetalle.setEsfeba(estableci.getEsfeba());

		// Datos aadidos por especificacin en arbitraje
		establecidetalle.setEscooe(estableci.getEscooe());
		establecidetalle.setEsnorep(estableci.getEsnorep());
		establecidetalle.setEsnifrep(estableci.getEsnifrep());

		// Buscar arbitraje
		try {
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.getEstablecimiento().setEscodigo(estableci.getEscodigo());
			establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
			establecidetalle.setAhfeba(establecimArbitra.getAhfeba());
			establecidetalle.setAhtelimi(establecimArbitra.getAhtelimi());
			// Datos aadidos por especificacin en arbitraje
			establecidetalle.setAhcodigo(establecimArbitra.getAhcodigo());
			establecidetalle.setAhcoja(establecimArbitra.getAhcoja());
			establecidetalle.setEsinadar(estableci.getEsinadar());
			establecidetalle.setAhfere(establecimArbitra.getAhfere());
			establecidetalle.setAhindef(establecimArbitra.getAhindef());
			establecidetalle.setAhmedia(establecimArbitra.getAhmedia());
			establecidetalle.setAhnrdi(establecimArbitra.getAhnrdi().toString());
			if ("A".equals(estableci.getEsinadar())) {
				if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
					establecidetalle.setEsinadar("L");
				}
			}
		} catch (Exception e) {

		}

		// Buscar sedes
		// buscar sedes
		if (establecidetalle.getEssede() != null && establecidetalle.getEssede().equals(Y41bConstantes.SI)) {
			Sede sede = new Sede();
			sede.setEscodigo(establecidetalle.getEscodigo());

			List<Sede> listSede = this.sedeDao.findAll(sede, null);
			establecidetalle.setSedes(listSede);
		}

		// buscar la inspeccion
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(intervinientes.getIdExpediente());
		InspeccionDetalle insDetalle = this.actaDao.findInspeccion(actuacion);

		if (Y41bConstantes.CASTELLANO.equals(insDetalle.getAtidiomaestablecimientovi())) {
			establecidetalle.setEscoidco(Y41bConstantes.CASTELLANO_CENSO);
		} else if (Y41bConstantes.EUSKERA.equals(insDetalle.getAtidiomaestablecimientovi())) {
			establecidetalle.setEscoidco(Y41bConstantes.EUSKERA_CENSO);
		}

		List<Descriptor> listDescriptor = this.establecimientoDao.findAllEstablecimientoDescriptor(estableci, null);

		StringBuffer strIdsDescriptores = new StringBuffer();
		StringBuffer strDescsDescriptores = new StringBuffer();

		strDescsDescriptores.append("[");

		boolean firstElement = true;

		// se recorre para obtener los ids de etiquetas
		for (Descriptor descriptor : listDescriptor) {
			if (firstElement) {
				strIdsDescriptores.append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(descriptor.getNombre());
				firstElement = false;
			} else {
				strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(",").append(descriptor.getNombre());
			}
		}

		strDescsDescriptores.append("]");

		establecidetalle.setIdsDescriptores(strIdsDescriptores.toString());
		establecidetalle.setDescsDescriptores(strDescsDescriptores.toString());

		return establecidetalle;
	}

	/**
	 * Finds rows in the ProtocoloInspeccion table using like.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipProtocolo> findAllProtocoloInspeccion(ProtocoloInspeccion protocoloInspeccion,
			Pagination pagination) {

		List<TipProtocolo> listTipProtocolo = this.actaDao.findAllProtocoloInspeccion(protocoloInspeccion, pagination);

		Protocol protocol = null;
		StringBuffer preguntascontestadas = null;
		for (TipProtocolo tipProtocoloAux : listTipProtocolo) {

			protocol = new Protocol();
			protocol.setPtcoat(protocoloInspeccion.getAtcodigo());
			protocol.setPtcodigo(tipProtocoloAux.getTpcodigo());
			Long preguntas = this.tipPregProtocDao.preguntasProtocoloInspeccionCount(protocol);

			Long respuestas = this.protocolDao.findAllPreguntasContestadasCount(protocol);
			preguntascontestadas = new StringBuffer();
			preguntascontestadas.append(respuestas).append("/").append(preguntas);

			tipProtocoloAux.setPreguntascontestadas(preguntascontestadas.toString());
		}

		return listTipProtocolo;
	}

	/**
	 * Counts rows in the ProtocoloInspeccion table using like.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @return Long
	 */
	public Long findAllProtocoloInspeccionCount(ProtocoloInspeccion protocoloInspeccion) {
		return this.actaDao.findAllProtocoloInspeccionCount(protocoloInspeccion);
	}

	/**
	 * Inserts a single row in the ProtocoloInspeccion table.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @return ProtocoloInspeccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ProtocoloInspeccion addProtocolosInspeccionesOficio(ProtocoloInspeccion protocoloInspeccion) {
		try {
			ProtocoloInspeccion protocoloInspeccionAux = new ProtocoloInspeccion();
			protocoloInspeccionAux.setAtcodigo(protocoloInspeccion.getAtcodigo());
			Long numProtocolos = this.actaDao.findAllProtocoloInspeccionCount(protocoloInspeccionAux);

			if (numProtocolos > 0) {
				throw new Y41bUDAException("error.inspeccion.numProtocoloException", true, new Exception());
			}
			return this.actaDao.addProtocoloInspeccion(protocoloInspeccion);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException("error.tipoprot.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Deletes a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeProtocolosInspeccionesOficio(ProtocoloInspeccion protocoloInspeccion) {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcoat(protocoloInspeccion.getAtcodigo());
		protocolDao.removeByActuacion(actuacion, protocoloInspeccion.getTpcodigo());
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(protocoloInspeccion.getAtcodigo());
		actaInfraccionDao.removeAllInfraccionesByProtocolo(tramiteComun, protocoloInspeccion.getTpcodigo());

		ActaNueva actaNueva = new ActaNueva();
		actaNueva.setAncodins(protocoloInspeccion.getAtcodigo());
		actaNueva.setAnligadoprotocolo(Y41bConstantes.VALOR_SI);

		Long numActaInfraccionProtocolo = this.actaNuevaDao.findAllActaInfraccionProtocoloTramitadaCount(actaNueva);

		TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
		tramiteInspeccionDetalle.setAtcodigo(protocoloInspeccion.getAtcodigo());
		Long numEmisionInformeProtocolo = this.tramiteInspeccionDao
				.findAllTramiteEmisionInformeProtocoloTramitadoCount(tramiteInspeccionDetalle);

		if ((numActaInfraccionProtocolo != null && numActaInfraccionProtocolo > 0)
				|| (numEmisionInformeProtocolo != null && numEmisionInformeProtocolo > 0)) {

			throw new Y41bUDAException("error.inspecciones.eliminarProtocoloException", true, new Exception());
		}

		this.actaDao.removeProtocoloInspeccion(protocoloInspeccion);
	}

	/**
	 * Graba una inspeccion para movilidad.
	 * 
	 * @param atcodigo
	 *            String
	 * @param idsdocumentosParam
	 *            String
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void grabarMarcajeParaTablet(InspeccionDetalle inspeccionDetalle, String idsdocumentosParam,
			CensoMonitor censoMonitor) {

		// marcaje de la inspeccion
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(inspeccionDetalle.getAtcodigo());
		actuacion = this.actuacionDao.marcarInspeccionParaTablet(actuacion);

		// desmarcar los documentos de la inspeccion
		this.documentoHechoDao.desmarcarDocsParaTablet(inspeccionDetalle.getAtcodigo());

		if (inspeccionDetalle.getAtcocm() != null && !(inspeccionDetalle.getAtcocm().equalsIgnoreCase(""))) {
			this.documentoHechoDao.desmarcarDocsParaTablet(inspeccionDetalle.getAtcocm());
		} else if (inspeccionDetalle.getAtcoal() != null && !(inspeccionDetalle.getAtcoal().equalsIgnoreCase(""))) {
			this.documentoHechoDao.desmarcarDocsParaTablet(inspeccionDetalle.getAtcoal());
		} else if (inspeccionDetalle.getAtidcomunicacionsoivre() != null
				&& !(inspeccionDetalle.getAtidcomunicacionsoivre().equalsIgnoreCase(""))) {
			this.documentoHechoDao.desmarcarDocsParaTablet(inspeccionDetalle.getAtidcomunicacionsoivre());
		} else if (inspeccionDetalle.getAtcohd() != null && !(inspeccionDetalle.getAtcohd().equalsIgnoreCase(""))) {
			this.documentoHechoDao.desmarcarDocsParaTablet(inspeccionDetalle.getAtcohd());
		}
		// marcaje de los documentos
		List<String> idsdocumentosList = Arrays.asList(idsdocumentosParam.split(","));

		this.documentoHechoDao.marcarDocsParaTablet(idsdocumentosList);

		// actualizacion tabla sincronizacion

		if (this.documentoHechoDao.findSincronizacion(censoMonitor) > 0) {
			this.documentoHechoDao.updateTablaSincronizacion(censoMonitor);
		} else {
			this.documentoHechoDao.addTablaSincronizacion(censoMonitor);
		}

	}
}
