package com.ejie.y41b.service;

import java.util.List;
import java.util.Map;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.BusquedaInspeccion;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.FiltroInspeccion;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.ProtocoloInspeccion;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteHechoDetalleKnet;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteInspeccionDetalle;
import com.ejie.y41b.model.platea.MensajeAportacionDocumentacion;

/**
 * InspeccionService  
 * 
 *  
 */
public interface InspeccionService {

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return SolicitudDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionDetalle findNumExpedienteInspeccion(Actuacion actuacion);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return InspeccionDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionDetalle findNumExpedienteInspeccion(InspeccionDetalle inspeccionDetalle);

	/**
	 * Guardar esa informacion en el Hashmap - idTramite + Tramite
	 * 
	 * @param listTramiteInspeccionDetalle
	 *            List<TramiteInspeccionDetalle>
	 * @return Map<String, TramiteInspeccionDetalle>
	 */
	public Map<String, TramiteInspeccionDetalle> creaHashmapTramitacion(
			List<TramiteInspeccionDetalle> listTramiteInspeccionDetalle);

	/**
	 * Aniade una nueva inspeccion.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return inspeccionDetalle InspeccionDetalle
	 * @throws Exception
	 *             Exception
	 */
	InspeccionDetalle addInspeccion(InspeccionDetalle inspeccionDetalle) throws Exception;

	/**
	 * Aniade una nueva inspeccion.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return inspeccionDetalle InspeccionDetalle
	 * @throws Exception
	 *             Exception
	 */
	public InspeccionDetalle addInspeccionMasiva(InspeccionDetalle inspeccionDetalle) throws Exception;

	/**
	 * Actualiza una inspeccion.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return inspeccionDetalle InspeccionDetalle
	 */
	InspeccionDetalle updateInspeccion(InspeccionDetalle inspeccionDetalle);

	/**
	 * Actualiza la fecha de protocolo de una inspeccion.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return inspeccionDetalle InspeccionDetalle
	 */
	public InspeccionDetalle updateFechaProtocolo(InspeccionDetalle inspeccionDetalle);

	/**
	 * Copiar una inspeccion.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return inspeccionDetalle InspeccionDetalle
	 */
	InspeccionDetalle copiarInspeccion(InspeccionDetalle inspeccionDetalle, CensoMonitor censoMonitor);

	/**
	 * Borra una inspeccin
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 */
	void removeInspeccion(InspeccionDetalle inspeccionDetalle);

	/**
	 * Recupera la bandeja de inspecciones.
	 * 
	 * @param filterActa
	 *            Acta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<BusquedaInspeccion> findAllBandejaInspecciones(Acta filterActa, Pagination pagination);

	/**
	 * Recupera el count de la bandeja de inspecciones.
	 * 
	 * @param filterActa
	 *            Acta
	 * @return Long
	 */
	Long findAllBandejaInspeccionesCount(Acta filterActa);

	/**
	 * Recupera los tramites de inspeccion
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @param pagination
	 *            Pagination
	 * @return List<TramiteInspeccionDetalle>
	 */
	List<TramiteInspeccionDetalle> findAllTramiteInspeccion(TramiteInspeccionDetalle tramiteInspeccionDetalle,
			Pagination pagination);

	/**
	 * Recupera los tramites de inspeccion
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	Long findAllTramiteInspeccionCount(TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**************
	 * PLANTILLAS *
	 **************/

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	void addPlantilla(Adjuntardocs adjuntardocs, TramiteComun tramiteComun, String tipodocumento) throws Exception;

	/**
	 * Inserts a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tipodocumento
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addPlantillaDecision(Adjuntardocs adjuntardocs, TramiteComun tramiteComun, String tipodocumento)
			throws Exception;

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes addInterviniente(Intervinientes intervinientes);

	/**
	 * Deletes a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeInterviniente(Intervinientes intervinientes);

	/**
	 * Update a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void eliminarRepresentacion(Intervinientes intervinientes) throws Exception;

	/**
	 * Update a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void validarRepresentacion(Intervinientes intervinientes) throws Exception;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de aportacion de
	 * documentacion realizado
	 * 
	 * @param tramiteinspeccion
	 *            TramiteInspeccion
	 * @param listDocumentoHecho
	 *            List<DocumentoExpediente>
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarMisGestionesAportaciondocumentacion(TramiteInspeccion tramiteinspeccion,
			List<DocumentoHecho> listDocumentoHecho) throws Exception;

	/**
	 * Inserts a single row in the Tramite Inspeccion table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param mensajeAportacionDoc
	 *            MensajeAportacionDocumentacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarTramiteAportacionDocumentacion(InspeccionDetalle inspeccionDetalle,
			MensajeAportacionDocumentacion mensajeAportacionDoc) throws Exception;

	/**
	 * Finds a single row in the tramiteinspeccion table.
	 * 
	 * @param tramiteHechoDetalleKnet
	 *            TramiteHechoDetalleKnet
	 * @return TramiteHechoDetalleKnet
	 */
	public TramiteHechoDetalleKnet findTramiteHecho(TramiteHechoDetalleKnet tramiteHechoDetalleKnet);

	/**
	 * Finds a List of rows in the Inspeccion table.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * 
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<FiltroInspeccion> findAllInspeccionesRelacionar(FiltroInspeccion filtroInspeccion, String atcodigo,
			String relacionados, Pagination pagination);

	/**
	 * Counts rows in the Inspeccion table.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @return Long
	 */
	public Long findAllCountInspeccionesRelacionar(FiltroInspeccion filtroInspeccion, String atcodigo,
			String relacionados);

	/**
	 * Finds a List of rows in the Inspeccion table.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<FiltroInspeccion> findAllInspeccionesRelacionarNuevaSancion(FiltroInspeccion filtroInspeccion,
			String atcodigo, String relacionados, Pagination pagination);

	/**
	 * Counts rows in the Inspecciones table.
	 * 
	 * @param filtroInspeccion
	 *            FiltroInspeccion
	 * @param atcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @return Long
	 */
	public Long findAllCountInspeccionesRelacionarNuevaSancion(FiltroInspeccion filtroInspeccion, String atcodigo,
			String relacionados);

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return EstablecimientoDetalle
	 */
	public EstablecimientoDetalle findIntervinienteEstablecimientoResponsable(Intervinientes intervinientes);

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return EstablecimientoDetalle
	 */
	public EstablecimientoDetalle findIntervinienteEstablecimientoVisitado(Intervinientes intervinientes);

	/**
	 * Finds rows in the ProtocoloInspeccion table using like.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipProtocolo> findAllProtocoloInspeccion(ProtocoloInspeccion protocoloInspeccion,
			Pagination pagination);

	/**
	 * Counts rows in the ProtocoloInspeccion table using like.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @return Long
	 */
	public Long findAllProtocoloInspeccionCount(ProtocoloInspeccion protocoloInspeccion);

	/**
	 * Inserts a single row in the ProtocoloInspeccion table.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @return ProtocoloInspeccion
	 */
	public ProtocoloInspeccion addProtocolosInspeccionesOficio(ProtocoloInspeccion protocoloInspeccion);

	/**
	 * Deletes a single row in the AdjuntarCampanhatipoprot table.
	 * 
	 * @param adjuntarCampanhatipoprot
	 *            AdjuntarCampanhatipoprot
	 * @return
	 */
	public void removeProtocolosInspeccionesOficio(ProtocoloInspeccion protocoloInspeccion);

	/**
	 * Graba una inspeccion para movilidad.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param idsdocumentosParam
	 *            String
	 * @return
	 */
	public void grabarMarcajeParaTablet(InspeccionDetalle inspeccionDetalle, String idsdocumentosParam,
			CensoMonitor censoMonitor);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return InspeccionDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InspeccionDetalle findInspeccionByNumeroExpediente(InspeccionDetalle inspeccionDetalle);
}
