package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.InfraccHechoDenDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.InfraccHechoDen;
import com.ejie.y41b.model.TipReqNormativo;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * InfraccHechoDenServiceImpl  
 * 
 *  
 */

@Service(value = "infraccHechoDenService")
public class InfraccHechoDenServiceImpl implements InfraccHechoDenService {

	@Autowired
	private InfraccHechoDenDao infraccHechoDenDao;

	/**
	 * Inserts a single row in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @return InfraccHechoDen
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InfraccHechoDen add(InfraccHechoDen infraccHechoDen) {
		// Comprobamos que no esta ya insertado en la base de datos.
		List<InfraccHechoDen> enDB = this.infraccHechoDenDao.findAll(
				infraccHechoDen, null);

		if (enDB.size() > 0) {
			throw new Y41bUDAException(
					"error.solicitud.tieneInfraccionException", true,
					new Exception());
		}

		// Generamos los datos necesarios y lo anyadimos.
		infraccHechoDen.setHicodigo(Y41bUIDGenerator.getInstance().generateId(
				Y41bConstantes.PK_SIZE));

		if (infraccHechoDen.getTipReqNormativo() == null
				|| infraccHechoDen.getTipReqNormativo().getTticodigo() == null) {
			infraccHechoDen.setTipReqNormativo(new TipReqNormativo());
		}

		String hiinexii = null;
		if (infraccHechoDen.getTipReqNormativo().getTticodigo() != null
				&& infraccHechoDen.getTipReqNormativo().getTticodigo()
						.indexOf("N0") > -1) {
			// es un articulo
			hiinexii = "S";
		}
		infraccHechoDen.setHiinexii(hiinexii);

		return this.infraccHechoDenDao.add(infraccHechoDen);
	}

	/**
	 * Updates a single row in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @return InfraccHechoDen
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InfraccHechoDen update(InfraccHechoDen infraccHechoDen) {
		return this.infraccHechoDenDao.update(infraccHechoDen);
	}

	/**
	 * Finds a single row in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @return InfraccHechoDen
	 */
	public InfraccHechoDen find(InfraccHechoDen infraccHechoDen) {
		return (InfraccHechoDen) this.infraccHechoDenDao.find(infraccHechoDen);
	}

	/**
	 * Finds a List of rows in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<InfraccHechoDen> findAll(InfraccHechoDen infraccHechoDen,
			Pagination pagination) {

		if ("tipReqNormativo.tticodigo".equals(pagination.getSidx())) {
			pagination.setSidx("t2.tticodigo");
		} else if ("tipReqNormativo.ttinombre".equals(pagination.getSidx())) {
			pagination.setSidx("t2.ttinombre");
		} else if ("tipReqNormativo.ttinombree".equals(pagination.getSidx())) {
			pagination.setSidx("t2.ttinombree");
		}

		return (List<InfraccHechoDen>) this.infraccHechoDenDao.findAll(
				infraccHechoDen, pagination);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.InfraccHechoDenService#findArticulos(java.lang.
	 * String)
	 */
	public List<InfraccHechoDen> findArticulosMaterias(String codigoExpediente,
			Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("tipReqNormativo.tticodigo")) {
				pagination.setSort("TTICODIGO");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("tipReqNormativo.ttinombre")) {
				pagination.setSort("TTINOMBRE");
			}
		}
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort()
							.equals("tipReqNormativo.ttinombreu")) {
				pagination.setSort("TTINOMBREU");
			}
		}

		return (List<InfraccHechoDen>) this.infraccHechoDenDao
				.findArticulosMaterias(codigoExpediente, pagination);
	}

	/**
	 * Counts rows in the InfraccHechoDen table using like.
	 * 
	 * @param excodigo
	 *            String
	 * @return Long
	 */
	public Long findArticulosMateriasCount(String excodigo) {
		return this.infraccHechoDenDao.findArticulosMateriasCount(excodigo);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.InfraccHechoDenService#findArticulos(java.lang.
	 * String)
	 */
	public List<InfraccHechoDen> findArticulos(String codigoExpediente,
			Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("tipReqNormativo.tticodigo")) {
				pagination.setSort("TTICODIGO");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("tipReqNormativo.ttinombre")) {
				pagination.setSort("TTINOMBRE");
			}
		}
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort()
							.equals("tipReqNormativo.ttinombreu")) {
				pagination.setSort("TTINOMBREU");
			}
		}

		return (List<InfraccHechoDen>) this.infraccHechoDenDao.findArticulos(
				codigoExpediente, pagination);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.InfraccHechoDenService#findMaterias(java.lang.String
	 * )
	 */
	public List<InfraccHechoDen> findMaterias(String codigoExpediente,
			Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("tipReqNormativo.tticodigo")) {
				pagination.setSort("TTICODIGO");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("tipReqNormativo.ttinombre")) {
				pagination.setSort("TTINOMBRE");
			}
		}
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort()
							.equals("tipReqNormativo.ttinombreu")) {
				pagination.setSort("TTINOMBREU");
			}
		}
		return (List<InfraccHechoDen>) this.infraccHechoDenDao.findMaterias(
				codigoExpediente, pagination);
	}

	/**
	 * Counts rows in the InfraccHechoDen table using like.
	 * 
	 * @param excodigo
	 *            String
	 * @return Long
	 */
	public Long findMateriasCount(String excodigo) {
		return this.infraccHechoDenDao.findMateriasCount(excodigo);
	}

	/**
	 * Counts rows in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @return Long
	 */
	public Long findAllCount(InfraccHechoDen infraccHechoDen) {
		return this.infraccHechoDenDao.findAllCount(infraccHechoDen);
	}

	/**
	 * Finds rows in the InfraccHechoDen table using like.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<InfraccHechoDen> findAllLike(InfraccHechoDen infraccHechoDen,
			Pagination pagination, Boolean startsWith) {
		return (List<InfraccHechoDen>) this.infraccHechoDenDao.findAllLike(
				infraccHechoDen, pagination, startsWith);
	}

	/**
	 * Counts rows in the InfraccHechoDen table using like.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(InfraccHechoDen infraccHechoDen,
			Boolean startsWith) {
		return this.infraccHechoDenDao.findAllLikeCount(infraccHechoDen,
				startsWith);
	}

	/**
	 * Deletes a single row in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(InfraccHechoDen infraccHechoDen) {
		this.infraccHechoDenDao.remove(infraccHechoDen);
	}

	/**
	 * Deletes multiple rows in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDenList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<InfraccHechoDen> infraccHechoDenList) {
		for (InfraccHechoDen infraccHechoDenAux : infraccHechoDenList) {
			this.infraccHechoDenDao.remove(infraccHechoDenAux);
		}
	}

}
