package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.InfraccHechoDen;

/**
 * InfraccHechoDenService  
 * 
 *  
 */

public interface InfraccHechoDenService {

	/**
	 * Inserts a single row in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @return InfraccHechoDen
	 */
	InfraccHechoDen add(InfraccHechoDen infraccHechoDen);

	/**
	 * Updates a single row in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @return InfraccHechoDen
	 */
	InfraccHechoDen update(InfraccHechoDen infraccHechoDen);

	/**
	 * Finds a single row in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @return InfraccHechoDen
	 */
	InfraccHechoDen find(InfraccHechoDen infraccHechoDen);

	/**
	 * Finds a List of rows in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<InfraccHechoDen> findAll(InfraccHechoDen infraccHechoDen,
			Pagination pagination);

	/**
	 * Find articulos.
	 * 
	 * @param codigoExpediente
	 *            the codigo expediente
	 * @return the list
	 */
	List<InfraccHechoDen> findArticulosMaterias(String codigoExpediente,
			Pagination pagination);

	/**
	 * Find articulos.
	 * 
	 * @param codigoExpediente
	 *            the codigo expediente
	 * @return the list
	 */
	List<InfraccHechoDen> findArticulos(String codigoExpediente,
			Pagination pagination);

	/**
	 * Find materias.
	 * 
	 * @param codigoExpediente
	 *            the codigo expediente
	 * @return the list
	 */
	List<InfraccHechoDen> findMaterias(String codigoExpediente,
			Pagination pagination);

	/**
	 * Counts rows in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @return Long
	 */
	Long findAllCount(InfraccHechoDen infraccHechoDen);

	/**
	 * Finds rows in the InfraccHechoDen table using like.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<InfraccHechoDen> findAllLike(InfraccHechoDen infraccHechoDen,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the InfraccHechoDen table using like.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(InfraccHechoDen infraccHechoDen, Boolean startsWith);

	/**
	 * Deletes a single row in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @return
	 */
	void remove(InfraccHechoDen infraccHechoDen);

	/**
	 * Deletes multiple rows in the InfraccHechoDen table.
	 * 
	 * @param infraccHechoDenList
	 *            List
	 * @return
	 */
	void removeMultiple(List<InfraccHechoDen> infraccHechoDenList);

	/**
	 * @param excodigo
	 * @return
	 */
	Long findArticulosMateriasCount(String excodigo);

	/**
	 * @param excodigo
	 * @return
	 */
	Long findMateriasCount(String excodigo);

}
