package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.InfraccHechoDenExpSancDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.InfraccHechoDenExpSanc;

/**
 * InfraccHechoDenExpSancServiceImpl  
 *  
 */

@Service(value = "infraccHechoDenExpSancService")
public class InfraccHechoDenExpSancServiceImpl implements InfraccHechoDenExpSancService {

	@Autowired
	private InfraccHechoDenExpSancDao infraccHechoDenExpSancDao;

	/**
	 * Inserts a single row in the InfraccHechoDenExpSanc table.
	 *
	 * @param infraccHechoDenExpSanc InfraccHechoDenExpSanc
	 * @return InfraccHechoDenExpSanc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InfraccHechoDenExpSanc add(InfraccHechoDenExpSanc infraccHechoDenExpSanc) {
		return this.infraccHechoDenExpSancDao.add(infraccHechoDenExpSanc);
	}

	/**
	 * Updates a single row in the InfraccHechoDenExpSanc table.
	 *
	 * @param infraccHechoDenExpSanc InfraccHechoDenExpSanc
	 * @return InfraccHechoDenExpSanc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InfraccHechoDenExpSanc update(InfraccHechoDenExpSanc infraccHechoDenExpSanc) {
		return this.infraccHechoDenExpSancDao.update(infraccHechoDenExpSanc);
	 }

	/**
	 * Finds a single row in the InfraccHechoDenExpSanc table.
	 *
	 * @param infraccHechoDenExpSanc InfraccHechoDenExpSanc
	 * @return InfraccHechoDenExpSanc
	 */
	public InfraccHechoDenExpSanc find(InfraccHechoDenExpSanc infraccHechoDenExpSanc) {
		return (InfraccHechoDenExpSanc) this.infraccHechoDenExpSancDao.find(infraccHechoDenExpSanc);
	}

	/**
	 * Finds a List of rows in the InfraccHechoDenExpSanc table.
	 *
	 * @param infraccHechoDenExpSanc InfraccHechoDenExpSanc
	 * @param pagination Pagination
	 * @return List
	 */
	public List<InfraccHechoDenExpSanc> findAll(InfraccHechoDenExpSanc infraccHechoDenExpSanc, Pagination pagination) {
		return (List<InfraccHechoDenExpSanc>) this.infraccHechoDenExpSancDao.findAll(infraccHechoDenExpSanc, pagination);
	}
    
	/**
	 * Counts rows in the InfraccHechoDenExpSanc table.
	 *
	 * @param infraccHechoDenExpSanc InfraccHechoDenExpSanc
	 * @return Long
	 */
	public Long findAllCount(InfraccHechoDenExpSanc infraccHechoDenExpSanc) {        
		return  this.infraccHechoDenExpSancDao.findAllCount(infraccHechoDenExpSanc);
	}

	/**
	 * Finds rows in the InfraccHechoDenExpSanc table using like.
	 *
	 * @param infraccHechoDenExpSanc InfraccHechoDenExpSanc
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<InfraccHechoDenExpSanc> findAllLike(InfraccHechoDenExpSanc infraccHechoDenExpSanc, Pagination pagination, Boolean startsWith) {
		return (List<InfraccHechoDenExpSanc>) this.infraccHechoDenExpSancDao.findAllLike(infraccHechoDenExpSanc, pagination, startsWith);
	}

	/**
	 * Counts rows in the InfraccHechoDenExpSanc table using like.
	 *
	 * @param infraccHechoDenExpSanc InfraccHechoDenExpSanc
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(InfraccHechoDenExpSanc infraccHechoDenExpSanc, Boolean startsWith) {
		return this.infraccHechoDenExpSancDao.findAllLikeCount(infraccHechoDenExpSanc, startsWith);
	}
	    
	/**
	 * Deletes a single row in the InfraccHechoDenExpSanc table.
	 *
	 * @param infraccHechoDenExpSanc InfraccHechoDenExpSanc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(InfraccHechoDenExpSanc infraccHechoDenExpSanc) {
		this.infraccHechoDenExpSancDao.remove(infraccHechoDenExpSanc);
	}
	
	/**
	 * Deletes multiple rows in the InfraccHechoDenExpSanc table.
	 *
	 * @param infraccHechoDenExpSancList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<InfraccHechoDenExpSanc> infraccHechoDenExpSancList) {
		for (InfraccHechoDenExpSanc  infraccHechoDenExpSancAux:infraccHechoDenExpSancList) {
			this.infraccHechoDenExpSancDao.remove(infraccHechoDenExpSancAux);
		}
	}
	
}

