package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.InfraccArbDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.InfraccArb;

/**
 * InfraccArbServiceImpl  
 * 
 *  
 */

@Service(value = "infraccArbService")
public class InfraccArbServiceImpl implements InfraccArbService {

	@Autowired
	private InfraccArbDao infraccArbDao;

	/**
	 * Inserts a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return InfraccArb
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InfraccArb add(InfraccArb infraccArb) {
		return this.infraccArbDao.add(infraccArb);
	}

	/**
	 * Updates a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return InfraccArb
	 */
	@Transactional(rollbackFor = Throwable.class)
	public InfraccArb update(InfraccArb infraccArb) {
		return this.infraccArbDao.update(infraccArb);
	}

	/**
	 * Finds a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return InfraccArb
	 */
	public InfraccArb find(InfraccArb infraccArb) {
		return (InfraccArb) this.infraccArbDao.find(infraccArb);
	}

	/**
	 * Finds a List of rows in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<InfraccArb> findAll(InfraccArb infraccArb, Pagination pagination) {
		return (List<InfraccArb>) this.infraccArbDao.findAll(infraccArb,
				pagination);
	}

	/**
	 * Counts rows in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return Long
	 */
	public Long findAllCount(InfraccArb infraccArb) {
		return this.infraccArbDao.findAllCount(infraccArb);
	}

	/**
	 * Finds rows in the InfraccArb table using like.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<InfraccArb> findAllLike(InfraccArb infraccArb,
			Pagination pagination, Boolean startsWith) {
		return (List<InfraccArb>) this.infraccArbDao.findAllLike(infraccArb,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the InfraccArb table using like.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(InfraccArb infraccArb, Boolean startsWith) {
		return this.infraccArbDao.findAllLikeCount(infraccArb, startsWith);
	}

	/**
	 * Deletes a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(InfraccArb infraccArb) {
		this.infraccArbDao.remove(infraccArb);
	}

	/**
	 * Deletes multiple rows in the InfraccArb table.
	 * 
	 * @param infraccArbList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<InfraccArb> infraccArbList) {
		for (InfraccArb infraccArbAux : infraccArbList) {
			this.infraccArbDao.remove(infraccArbAux);
		}
	}

}
