package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.InfraccArb;

/**
 * InfraccArbService  
 * 
 *  
 */

public interface InfraccArbService {

	/**
	 * Inserts a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return InfraccArb
	 */
	InfraccArb add(InfraccArb infraccArb);

	/**
	 * Updates a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return InfraccArb
	 */
	InfraccArb update(InfraccArb infraccArb);

	/**
	 * Finds a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return InfraccArb
	 */
	InfraccArb find(InfraccArb infraccArb);

	/**
	 * Finds a List of rows in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<InfraccArb> findAll(InfraccArb infraccArb, Pagination pagination);

	/**
	 * Counts rows in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return Long
	 */
	Long findAllCount(InfraccArb infraccArb);

	/**
	 * Finds rows in the InfraccArb table using like.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<InfraccArb> findAllLike(InfraccArb infraccArb, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the InfraccArb table using like.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(InfraccArb infraccArb, Boolean startsWith);

	/**
	 * Deletes a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return
	 */
	void remove(InfraccArb infraccArb);

	/**
	 * Deletes multiple rows in the InfraccArb table.
	 * 
	 * @param infraccArbList
	 *            List
	 * @return
	 */
	void removeMultiple(List<InfraccArb> infraccArbList);

}
