package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.IncDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Inc;

/**
 * IncServiceImpl  
 *  
 */

@Service(value = "incService")
public class IncServiceImpl implements IncService {

	@Autowired
	private IncDao incDao;

	/**
	 * Inserts a single row in the Inc table.
	 *
	 * @param inc Inc
	 * @return Inc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Inc add(Inc inc) {
		return this.incDao.add(inc);
	}

	/**
	 * Updates a single row in the Inc table.
	 *
	 * @param inc Inc
	 * @return Inc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Inc update(Inc inc) {
		return this.incDao.update(inc);
	 }

	/**
	 * Finds a single row in the Inc table.
	 *
	 * @param inc Inc
	 * @return Inc
	 */
	public Inc find(Inc inc) {
		return (Inc) this.incDao.find(inc);
	}

	/**
	 * Finds a List of rows in the Inc table.
	 *
	 * @param inc Inc
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Inc> findAll(Inc inc, Pagination pagination) {
		return (List<Inc>) this.incDao.findAll(inc, pagination);
	}
    
	/**
	 * Counts rows in the Inc table.
	 *
	 * @param inc Inc
	 * @return Long
	 */
	public Long findAllCount(Inc inc) {        
		return  this.incDao.findAllCount(inc);
	}

	/**
	 * Finds rows in the Inc table using like.
	 *
	 * @param inc Inc
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Inc> findAllLike(Inc inc, Pagination pagination, Boolean startsWith) {
		return (List<Inc>) this.incDao.findAllLike(inc, pagination, startsWith);
	}

	/**
	 * Counts rows in the Inc table using like.
	 *
	 * @param inc Inc
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Inc inc, Boolean startsWith) {
		return this.incDao.findAllLikeCount(inc, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Inc table.
	 *
	 * @param inc Inc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Inc inc) {
		this.incDao.remove(inc);
	}
	
	/**
	 * Deletes multiple rows in the Inc table.
	 *
	 * @param incList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Inc> incList) {
		for (Inc  incAux:incList) {
			this.incDao.remove(incAux);
		}
	}
	
}

