package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.HistoricofasesDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Historicofases;

/**
 * HistoricofasesServiceImpl  
 * 
 *  
 */

@Service(value = "historicofasesService")
public class HistoricofasesServiceImpl implements HistoricofasesService {

	@Autowired
	private HistoricofasesDao historicofasesDao;

	/**
	 * Inserts a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return Historicofases
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Historicofases add(Historicofases historicofases) {
		return this.historicofasesDao.add(historicofases);
	}

	/**
	 * Updates a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return Historicofases
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Historicofases update(Historicofases historicofases) {
		return this.historicofasesDao.update(historicofases);
	}

	/**
	 * Updates a single row in the Historicofases table. (Solo fecha fin)
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return Historicofases
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Historicofases updateFechaFin(Historicofases historicofases) {
		return this.historicofasesDao.updateFechaFin(historicofases);
	}

	/**
	 * Finds a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return Historicofases
	 */
	public Historicofases find(Historicofases historicofases) {
		return (Historicofases) this.historicofasesDao.find(historicofases);
	}

	/**
	 * Finds a List of rows in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Historicofases> findAll(Historicofases historicofases,
			Pagination pagination) {
		return (List<Historicofases>) this.historicofasesDao.findAll(
				historicofases, pagination);
	}

	/**
	 * Finds a List of rows in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return List
	 */
	public List<Historicofases> findAllFasesHistoricoAbiertas(
			Historicofases historicofases) {
		return (List<Historicofases>) this.historicofasesDao
				.findAllFasesHistoricoAbiertas(historicofases);
	}

	/**
	 * Counts rows in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return Long
	 */
	public Long findAllCount(Historicofases historicofases) {
		return this.historicofasesDao.findAllCount(historicofases);
	}

	/**
	 * Finds rows in the Historicofases table using like.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Historicofases> findAllLike(Historicofases historicofases,
			Pagination pagination, Boolean startsWith) {
		return (List<Historicofases>) this.historicofasesDao.findAllLike(
				historicofases, pagination, startsWith);
	}

	/**
	 * Counts rows in the Historicofases table using like.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Historicofases historicofases,
			Boolean startsWith) {
		return this.historicofasesDao.findAllLikeCount(historicofases,
				startsWith);
	}

	/**
	 * Deletes a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Historicofases historicofases) {
		this.historicofasesDao.remove(historicofases);
	}

	/**
	 * Deletes a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeHistoricoFasesExpediente(Historicofases historicofases) {
		this.historicofasesDao.removeHistoricoFasesExpediente(historicofases);
	}

	/**
	 * Deletes multiple rows in the Historicofases table.
	 * 
	 * @param historicofasesList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Historicofases> historicofasesList) {
		for (Historicofases historicofasesAux : historicofasesList) {
			this.historicofasesDao.remove(historicofasesAux);
		}
	}

}
