package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Historicofases;

/**
 * HistoricofasesService  
 * 
 *  
 */

public interface HistoricofasesService {

	/**
	 * Inserts a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return Historicofases
	 */
	Historicofases add(Historicofases historicofases);

	/**
	 * Updates a single row in the Historicofases table.(Solo fecha fin)
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return Historicofases
	 */
	Historicofases updateFechaFin(Historicofases historicofases);

	/**
	 * Updates a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return Historicofases
	 */
	Historicofases update(Historicofases historicofases);

	/**
	 * Finds a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return Historicofases
	 */
	Historicofases find(Historicofases historicofases);

	/**
	 * Finds a List of rows in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Historicofases> findAll(Historicofases historicofases,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return List
	 */
	List<Historicofases> findAllFasesHistoricoAbiertas(
			Historicofases historicofases);

	/**
	 * Counts rows in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return Long
	 */
	Long findAllCount(Historicofases historicofases);

	/**
	 * Finds rows in the Historicofases table using like.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Historicofases> findAllLike(Historicofases historicofases,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Historicofases table using like.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Historicofases historicofases, Boolean startsWith);

	/**
	 * Deletes a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return
	 */
	void remove(Historicofases historicofases);

	/**
	 * Deletes a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return
	 */
	public void removeHistoricoFasesExpediente(Historicofases historicofases);

	/**
	 * Deletes multiple rows in the Historicofases table.
	 * 
	 * @param historicofasesList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Historicofases> historicofasesList);

}
