package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.HistoricoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Historico;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * HistoricoServiceImpl  
 * 
 *  
 */

@Service(value = "historicoService")
public class HistoricoServiceImpl implements HistoricoService {

	@Autowired
	private HistoricoDao historicoDao;

	/**
	 * Inserts a single row in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Historico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Historico add(Historico historico) {
		historico.setShcodigo(Y41bUIDGenerator.getInstance().generateId(
				Y41bConstantes.PK_SIZE));
		return this.historicoDao.add(historico);
	}

	/**
	 * Updates a single row in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Historico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Historico update(Historico historico) {
		return this.historicoDao.update(historico);
	}

	/**
	 * Finds a single row in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Historico
	 */
	public Historico find(Historico historico) {
		return (Historico) this.historicoDao.find(historico);
	}

	/**
	 * Finds a List of rows in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Historico> findAll(Historico historico, Pagination pagination) {
		return (List<Historico>) this.historicoDao.findAll(historico,
				pagination);
	}

	/**
	 * Counts rows in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Long
	 */
	public Long findAllCount(Historico historico) {
		return this.historicoDao.findAllCount(historico);
	}

	/**
	 * Finds rows in the Historico table using like.
	 * 
	 * @param historico
	 *            Historico
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Historico> findAllLike(Historico historico,
			Pagination pagination, Boolean startsWith) {
		return (List<Historico>) this.historicoDao.findAllLike(historico,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Historico table using like.
	 * 
	 * @param historico
	 *            Historico
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Historico historico, Boolean startsWith) {
		return this.historicoDao.findAllLikeCount(historico, startsWith);
	}

	/**
	 * Deletes a single row in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Historico historico) {
		this.historicoDao.remove(historico);
	}

	/**
	 * Deletes multiple rows in the Historico table.
	 * 
	 * @param historicoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Historico> historicoList) {
		for (Historico historicoAux : historicoList) {
			this.historicoDao.remove(historicoAux);
		}
	}

}
