package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.HistorialAlertaDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.HistorialAlerta;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * HistorialAlertaServiceImpl  
 * 
 *  
 */

@Service(value = "historialAlertaService")
public class HistorialAlertaServiceImpl implements HistorialAlertaService {

	@Autowired
	private HistorialAlertaDao historialAlertaDao;

	/**
	 * Inserts a single row in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return HistorialAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public HistorialAlerta add(HistorialAlerta historialAlerta) {
		historialAlerta.setIdhistorial(Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));
		return this.historialAlertaDao.add(historialAlerta);
	}

	/**
	 * Updates a single row in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return HistorialAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public HistorialAlerta update(HistorialAlerta historialAlerta) {
		return this.historialAlertaDao.update(historialAlerta);
	}

	/**
	 * Finds a single row in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return HistorialAlerta
	 */
	public HistorialAlerta find(HistorialAlerta historialAlerta) {
		return (HistorialAlerta) this.historialAlertaDao.find(historialAlerta);
	}

	/**
	 * Finds a List of rows in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<HistorialAlerta> findAll(HistorialAlerta historialAlerta,
			Pagination pagination) {
		return (List<HistorialAlerta>) this.historialAlertaDao.findAll(
				historialAlerta, pagination);
	}

	/**
	 * Counts rows in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return Long
	 */
	public Long findAllCount(HistorialAlerta historialAlerta) {
		return this.historialAlertaDao.findAllCount(historialAlerta);
	}

	/**
	 * Finds rows in the HistorialAlerta table using like.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<HistorialAlerta> findAllLike(HistorialAlerta historialAlerta,
			Pagination pagination, Boolean startsWith) {
		return (List<HistorialAlerta>) this.historialAlertaDao.findAllLike(
				historialAlerta, pagination, startsWith);
	}

	/**
	 * Counts rows in the HistorialAlerta table using like.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(HistorialAlerta historialAlerta,
			Boolean startsWith) {
		return this.historialAlertaDao.findAllLikeCount(historialAlerta,
				startsWith);
	}

	/**
	 * Deletes a single row in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(HistorialAlerta historialAlerta) {
		this.historialAlertaDao.remove(historialAlerta);
	}

	/**
	 * Deletes a single row in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeHistorico(HistorialAlerta historialAlerta) {
		HistorialAlerta historialAlertaAux = this.historialAlertaDao
				.find(historialAlerta);
		if (historialAlertaAux != null
				&& historialAlertaAux.getGenerado() != null
				&& historialAlertaAux.getGenerado().equals(
						Y41bConstantes.VALOR_SI)) {
			throw new Y41bUDAException(
					"error.historialalerta.BorradoException", true,
					new Exception());
		}

		this.historialAlertaDao.remove(historialAlerta);
	}

	/**
	 * Deletes multiple rows in the HistorialAlerta table.
	 * 
	 * @param historialAlertaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<HistorialAlerta> historialAlertaList) {
		for (HistorialAlerta historialAlertaAux : historialAlertaList) {
			this.historialAlertaDao.remove(historialAlertaAux);
		}
	}

}
