package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.HistorialAlerta;

/**
 * HistorialAlertaService  
 * 
 *  
 */

public interface HistorialAlertaService {

	/**
	 * Inserts a single row in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return HistorialAlerta
	 */
	HistorialAlerta add(HistorialAlerta historialAlerta);

	/**
	 * Updates a single row in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return HistorialAlerta
	 */
	HistorialAlerta update(HistorialAlerta historialAlerta);

	/**
	 * Finds a single row in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return HistorialAlerta
	 */
	HistorialAlerta find(HistorialAlerta historialAlerta);

	/**
	 * Finds a List of rows in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<HistorialAlerta> findAll(HistorialAlerta historialAlerta,
			Pagination pagination);

	/**
	 * Counts rows in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return Long
	 */
	Long findAllCount(HistorialAlerta historialAlerta);

	/**
	 * Finds rows in the HistorialAlerta table using like.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<HistorialAlerta> findAllLike(HistorialAlerta historialAlerta,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the HistorialAlerta table using like.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(HistorialAlerta historialAlerta, Boolean startsWith);

	/**
	 * Deletes a single row in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return
	 */
	void remove(HistorialAlerta historialAlerta);

	/**
	 * Deletes a single row in the HistorialAlerta table.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return
	 */
	public void removeHistorico(HistorialAlerta historialAlerta);

	/**
	 * Deletes multiple rows in the HistorialAlerta table.
	 * 
	 * @param historialAlertaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<HistorialAlerta> historialAlertaList);

}
