package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.FormasVentaDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.FormasVenta;

/**
 * FormasVentaServiceImpl  
 *  
 */

@Service(value = "formasVentaService")
public class FormasVentaServiceImpl implements FormasVentaService {

	@Autowired
	private FormasVentaDao formasVentaDao;

	/**
	 * Inserts a single row in the FormasVenta table.
	 *
	 * @param formasVenta FormasVenta
	 * @return FormasVenta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public FormasVenta add(FormasVenta formasVenta) {
		return this.formasVentaDao.add(formasVenta);
	}

	/**
	 * Updates a single row in the FormasVenta table.
	 *
	 * @param formasVenta FormasVenta
	 * @return FormasVenta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public FormasVenta update(FormasVenta formasVenta) {
		return this.formasVentaDao.update(formasVenta);
	 }

	/**
	 * Finds a single row in the FormasVenta table.
	 *
	 * @param formasVenta FormasVenta
	 * @return FormasVenta
	 */
	public FormasVenta find(FormasVenta formasVenta) {
		return (FormasVenta) this.formasVentaDao.find(formasVenta);
	}

	/**
	 * Finds a List of rows in the FormasVenta table.
	 *
	 * @param formasVenta FormasVenta
	 * @param pagination Pagination
	 * @return List
	 */
	public List<FormasVenta> findAll(FormasVenta formasVenta, Pagination pagination) {
		return (List<FormasVenta>) this.formasVentaDao.findAll(formasVenta, pagination);
	}
    
	/**
	 * Counts rows in the FormasVenta table.
	 *
	 * @param formasVenta FormasVenta
	 * @return Long
	 */
	public Long findAllCount(FormasVenta formasVenta) {        
		return  this.formasVentaDao.findAllCount(formasVenta);
	}

	/**
	 * Finds rows in the FormasVenta table using like.
	 *
	 * @param formasVenta FormasVenta
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<FormasVenta> findAllLike(FormasVenta formasVenta, Pagination pagination, Boolean startsWith) {
		return (List<FormasVenta>) this.formasVentaDao.findAllLike(formasVenta, pagination, startsWith);
	}

	/**
	 * Counts rows in the FormasVenta table using like.
	 *
	 * @param formasVenta FormasVenta
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(FormasVenta formasVenta, Boolean startsWith) {
		return this.formasVentaDao.findAllLikeCount(formasVenta, startsWith);
	}
	    
	/**
	 * Deletes a single row in the FormasVenta table.
	 *
	 * @param formasVenta FormasVenta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(FormasVenta formasVenta) {
		this.formasVentaDao.remove(formasVenta);
	}
	
	/**
	 * Deletes multiple rows in the FormasVenta table.
	 *
	 * @param formasVentaList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<FormasVenta> formasVentaList) {
		for (FormasVenta  formasVentaAux:formasVentaList) {
			this.formasVentaDao.remove(formasVentaAux);
		}
	}
	
}

