package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.FormaPresentacionDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.FormaPresentacion;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * FormaPresentacionServiceImpl  
 * 
 *  
 */

@Service(value = "formaPresentacionService")
public class FormaPresentacionServiceImpl implements FormaPresentacionService {

	private static final Logger logger = LoggerFactory.getLogger(FormaPresentacionServiceImpl.class);
	@Autowired
	private FormaPresentacionDao formaPresentacionDao;

	/**
	 * Inserts a single row in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return FormaPresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public FormaPresentacion add(FormaPresentacion formaPresentacion) {
		try {
			return this.formaPresentacionDao.add(formaPresentacion);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException("error.formaPresentacion.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Updates a single row in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return FormaPresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public FormaPresentacion update(FormaPresentacion formaPresentacion) {
		return this.formaPresentacionDao.update(formaPresentacion);
	}

	/**
	 * Finds a single row in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return FormaPresentacion
	 */
	public FormaPresentacion find(FormaPresentacion formaPresentacion) {
		return (FormaPresentacion) this.formaPresentacionDao.find(formaPresentacion);
	}

	/**
	 * Finds a List of rows in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<FormaPresentacion> findAll(FormaPresentacion formaPresentacion, Pagination pagination) {
		return (List<FormaPresentacion>) this.formaPresentacionDao.findAll(formaPresentacion, pagination);
	}

	/**
	 * Finds a List of rows in the FormaPresentacion table filtering by
	 * consultas or solicitudes.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param filter
	 *            String 'C' --> consultas 'S' --> solicitudes 'A' -->
	 *            Arbitrajes
	 * @return List
	 */
	public List<FormaPresentacion> findAllConsultasOrSolicitudes(FormaPresentacion formaPresentacion,
			Pagination pagination, String filter) {
		return (List<FormaPresentacion>) this.formaPresentacionDao.findAllConsultasOrSolicitudes(formaPresentacion,
				pagination, filter);
	}

	/**
	 * Finds a List of rows in the FormaPresentacion table filtering by
	 * consultas or solicitudes.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param filter
	 *            String 'C' --> consultas 'S' --> solicitudes
	 * @param sir
	 *            String
	 * @return List
	 */
	public List<FormaPresentacion> findAllConsultasOrSolicitudesSinWeb(FormaPresentacion formaPresentacion,
			Pagination pagination, String filter, String sir) {
		return (List<FormaPresentacion>) this.formaPresentacionDao
				.findAllConsultasOrSolicitudesSinWeb(formaPresentacion, pagination, filter, sir);
	}

	/**
	 * Finds a List of rows in the FormaPresentacion table filtering by
	 * consultas or solicitudes.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param filter
	 *            String 'C' --> consultas 'S' --> solicitudes
	 * @return List
	 */
	public List<FormaPresentacion> findAllConsultasOrSolicitudesAlta(FormaPresentacion formaPresentacion,
			Pagination pagination, String filter) {
		return (List<FormaPresentacion>) this.formaPresentacionDao.findAllConsultasOrSolicitudesAlta(formaPresentacion,
				pagination, filter);
	}

	/**
	 * Finds a List of rows in the FormaPresentacion table filtering by
	 * consultas or solicitudes.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param filter
	 *            String 'C' --> consultas 'S' --> solicitudes
	 * @param sir
	 *            String
	 * @return List
	 */
	public List<FormaPresentacion> findAllConsultasOrSolicitudesAltaSinWeb(FormaPresentacion formaPresentacion,
			Pagination pagination, String filter, String sir) {
		return (List<FormaPresentacion>) this.formaPresentacionDao
				.findAllConsultasOrSolicitudesAltaSinWeb(formaPresentacion, pagination, filter, sir);
	}

	/**
	 * Counts rows in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return Long
	 */
	public Long findAllCount(FormaPresentacion formaPresentacion) {
		return this.formaPresentacionDao.findAllCount(formaPresentacion);
	}

	/**
	 * Finds rows in the FormaPresentacion table using like.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<FormaPresentacion> findAllLike(FormaPresentacion formaPresentacion, Pagination pagination,
			Boolean startsWith) {
		return (List<FormaPresentacion>) this.formaPresentacionDao.findAllLike(formaPresentacion, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(FormaPresentacion formaPresentacion, Boolean startsWith) {
		return this.formaPresentacionDao.findAllLikeCount(formaPresentacion, startsWith);
	}

	/**
	 * Deletes a single row in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(FormaPresentacion formaPresentacion) {
		try {
			this.formaPresentacionDao.remove(formaPresentacion);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.formaPresentacion.DataIntegrityViolationException", true, e);
		}

	}

	/**
	 * Updates a single row in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateFechaBaja(FormaPresentacion formaPresentacion) {
		this.formaPresentacionDao.updateFechaBaja(formaPresentacion);
	}

	/**
	 * Deletes multiple rows in the FormaPresentacion table.
	 * 
	 * @param formaPresentacionList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<FormaPresentacion> formaPresentacionList) {
		for (FormaPresentacion formaPresentacionAux : formaPresentacionList) {
			this.formaPresentacionDao.remove(formaPresentacionAux);
		}
	}

	/**
	 * Getter method for FormaPresentacionDao
	 * 
	 * @return FormaPresentacionDao
	 */
	public FormaPresentacionDao getFormaPresentacionDao() {
		return this.formaPresentacionDao;
	}

	/**
	 * Setter method for FormaPresentacionDao.
	 * 
	 * @param formaPresentacionDao
	 *            FormaPresentacionDao
	 * @return
	 */
	public void setFormaPresentacionDao(FormaPresentacionDao formaPresentacionDao) {
		logger.info("Setting Dependency " + formaPresentacionDao);
		this.formaPresentacionDao = formaPresentacionDao;
	}
}
