package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.FormaPresentacion;

/**
 * * FormaPresentacionService  
 * 
 *  
 */

public interface FormaPresentacionService {

	/**
	 * Inserts a single row in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return FormaPresentacion
	 */
	FormaPresentacion add(FormaPresentacion formaPresentacion);

	/**
	 * Updates a single row in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return FormaPresentacion
	 */
	FormaPresentacion update(FormaPresentacion formaPresentacion);

	/**
	 * Finds a single row in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return FormaPresentacion
	 */
	FormaPresentacion find(FormaPresentacion formaPresentacion);

	/**
	 * Finds a List of rows in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<FormaPresentacion> findAll(FormaPresentacion formaPresentacion, Pagination pagination);

	/**
	 * Finds a List of rows in the FormaPresentacion table filtering by
	 * consultas or solicitudes.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param filter
	 *            String 'S' --> consultas 'N' --> solicitudes
	 * @return List
	 */
	public List<FormaPresentacion> findAllConsultasOrSolicitudes(FormaPresentacion formaPresentacion,
			Pagination pagination, String filter);

	/**
	 * Finds a List of rows in the FormaPresentacion table filtering by
	 * consultas or solicitudes.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param filter
	 *            String 'S' --> consultas 'N' --> solicitudes
	 * @param sir
	 *            String
	 * @return List
	 */
	public List<FormaPresentacion> findAllConsultasOrSolicitudesSinWeb(FormaPresentacion formaPresentacion,
			Pagination pagination, String filter, String sir);

	/**
	 * Finds a List of rows in the FormaPresentacion table filtering by
	 * consultas or solicitudes.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param filter
	 *            String 'S' --> consultas 'N' --> solicitudes
	 * @return List
	 */
	public List<FormaPresentacion> findAllConsultasOrSolicitudesAlta(FormaPresentacion formaPresentacion,
			Pagination pagination, String filter);

	/**
	 * Finds a List of rows in the FormaPresentacion table filtering by
	 * consultas or solicitudes.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param filter
	 *            String 'S' --> consultas 'N' --> solicitudes
	 * @param sir
	 *            String
	 * @return List
	 */
	public List<FormaPresentacion> findAllConsultasOrSolicitudesAltaSinWeb(FormaPresentacion formaPresentacion,
			Pagination pagination, String filter, String sir);

	/**
	 * Counts rows in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return Long
	 */
	Long findAllCount(FormaPresentacion formaPresentacion);

	/**
	 * Finds rows in the FormaPresentacion table using like.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<FormaPresentacion> findAllLike(FormaPresentacion formaPresentacion, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(FormaPresentacion formaPresentacion, Boolean startsWith);

	/**
	 * Deletes a single row in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return
	 */
	void remove(FormaPresentacion formaPresentacion);

	/**
	 * Updates a single row in the FormaPresentacion table.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return FormaPresentacion
	 */
	public void updateFechaBaja(FormaPresentacion formaPresentacion);

	/**
	 * Deletes multiple rows in the FormaPresentacion table.
	 * 
	 * @param formaPresentacionList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<FormaPresentacion> formaPresentacionList);

}
