package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.FaseDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Fase;

/**
 * FaseServiceImpl  
 *  
 */

@Service(value = "faseService")
public class FaseServiceImpl implements FaseService {

	@Autowired
	private FaseDao faseDao;

	/**
	 * Inserts a single row in the Fase table.
	 *
	 * @param fase Fase
	 * @return Fase
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Fase add(Fase fase) {
		return this.faseDao.add(fase);
	}

	/**
	 * Updates a single row in the Fase table.
	 *
	 * @param fase Fase
	 * @return Fase
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Fase update(Fase fase) {
		return this.faseDao.update(fase);
	 }

	/**
	 * Finds a single row in the Fase table.
	 *
	 * @param fase Fase
	 * @return Fase
	 */
	public Fase find(Fase fase) {
		return (Fase) this.faseDao.find(fase);
	}

	/**
	 * Finds a List of rows in the Fase table.
	 *
	 * @param fase Fase
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Fase> findAll(Fase fase, Pagination pagination) {
		return (List<Fase>) this.faseDao.findAll(fase, pagination);
	}
    
	/**
	 * Counts rows in the Fase table.
	 *
	 * @param fase Fase
	 * @return Long
	 */
	public Long findAllCount(Fase fase) {        
		return  this.faseDao.findAllCount(fase);
	}

	/**
	 * Finds rows in the Fase table using like.
	 *
	 * @param fase Fase
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Fase> findAllLike(Fase fase, Pagination pagination, Boolean startsWith) {
		return (List<Fase>) this.faseDao.findAllLike(fase, pagination, startsWith);
	}

	/**
	 * Counts rows in the Fase table using like.
	 *
	 * @param fase Fase
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Fase fase, Boolean startsWith) {
		return this.faseDao.findAllLikeCount(fase, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Fase table.
	 *
	 * @param fase Fase
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Fase fase) {
		this.faseDao.remove(fase);
	}
	
	/**
	 * Deletes multiple rows in the Fase table.
	 *
	 * @param faseList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Fase> faseList) {
		for (Fase  faseAux:faseList) {
			this.faseDao.remove(faseAux);
		}
	}
	
}

