// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActaInfraccionDao;
import com.ejie.y41b.dao.ArbexpDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.EssaDao;
import com.ejie.y41b.dao.EstablecimSectorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.ExpedienDao;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.dao.HistoricofasesDao;
import com.ejie.y41b.dao.InfraccArbDao;
import com.ejie.y41b.dao.InfraccHechoDenDao;
import com.ejie.y41b.dao.InfraccHechoDenExpSancDao;
import com.ejie.y41b.dao.InstructorDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.PagosDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.RecursoDao;
import com.ejie.y41b.dao.SanbandejaDao;
import com.ejie.y41b.dao.SandoctempDao;
import com.ejie.y41b.dao.SanexpDao;
import com.ejie.y41b.dao.SanexprelDao;
import com.ejie.y41b.dao.SanintervDao;
import com.ejie.y41b.dao.SanpropbandejaDao;
import com.ejie.y41b.dao.SantramexpDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.dao.TipReqNormativoDao;
import com.ejie.y41b.model.ActaInfraccion;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Essa;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Estadopago;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.ExpedienKgest;
import com.ejie.y41b.model.FiltroSanciones;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Historicofases;
import com.ejie.y41b.model.InfraccArb;
import com.ejie.y41b.model.InfraccHechoDen;
import com.ejie.y41b.model.InfraccHechoDenExpSanc;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Instructor;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Pagos;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Recurso;
import com.ejie.y41b.model.Sanbandeja;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Sanpropbandeja;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipReqNormativo;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.ActualizarExpediente;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.DatosRegistro;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.Proceedings;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ExpedienServiceImpl  
 * 
 *  
 */

@Service(value = "expedienService")
public class ExpedienServiceImpl implements ExpedienService {
	private final static Logger logger = LoggerFactory.getLogger(ExpedienServiceImpl.class);

	@Autowired()
	private ExpedienDao expedienDao;

	@Autowired()
	private SanexpDao sanexpDao;

	@Autowired()
	private SanexprelDao sanexprelDao;

	@Autowired()
	private SanbandejaDao sanbandejaDao;

	@Autowired()
	private SantramexpDao santramexpDao;

	@Autowired()
	private InstructorDao instructorDao;

	@Autowired()
	private SanintervDao sanintervDao;

	@Autowired()
	private HechoDenunciadoDao hechodenunciadoDao;

	@Autowired()
	private SanpropbandejaDao sanpropbandejaDao;

	@Autowired()
	private InfraccHechoDenDao infraccHechoDenDao;

	@Autowired()
	private InfraccHechoDenExpSancDao infraccHechoDenExpSancDao;

	@Autowired()
	private EstablecimientoDao establecimientoDao;

	@Autowired()
	private ParametrosDao parametrosDao;

	@Autowired()
	private CensoMonitorDao censoMonitorDao;

	@Autowired()
	private PagosDao pagosDao;

	@Autowired()
	private HistoricofasesDao historicoFasesDao;

	@Autowired()
	private RecursoDao recursoDao;

	// @Autowired()
	// private AdjuntardocsDao adjuntardocsDao;

	// @Autowired()
	// private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired()
	private SandoctempDao sandoctempdao;

	// @Autowired()
	// private BandejaFirmaDao bandejaFirmaDao;

	@Autowired()
	private Properties appConfiguration;

	@Resource
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired()
	private SanexpService sanexpService;

	@Autowired()
	private SantramexpService santramexpService;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private IntervinientesDao intervinientesDao;

	@Autowired()
	private EstablecimSectorDao establecimSectorDao;

	@Autowired()
	private InfraccHechoDenService infraccHechoDenService;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;
	@Autowired()
	private SolarbDao solarbDao;
	@Autowired()
	private ArbexpDao arbexpDao;
	@Autowired()
	private ArbintervDao arbintervDao;
	@Autowired()
	private EssaDao essaDao;
	@Autowired()
	private Arbtramexp4Service arbtramexp4Service;
	@Autowired()
	private ArbtramexpService arbtramexpService;
	@Autowired()
	private InfraccArbDao infraccArbDao;
	@Autowired()
	private OrganismoDao organismoDao;

	@Autowired()
	private ActaService actaService;
	@Autowired()
	private ActaInfraccionDao actaInfraccionDao;
	@Autowired()
	private InstramexpService instramexpService;
	@Autowired()
	private TipReqNormativoDao tipReqNormativoDao;

	/**
	 * Inserts a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Expedien
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Expedien add(Expedien expedien) throws Exception {
		return this.add(expedien, null);
	}

	/**
	 * Inserts a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Expedien
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Expedien add(Expedien expedien, Long baprsanid) throws Exception {
		// Se genera la PK
		logger.info("ExpedienteServiceImpl. - Add. Inicio");

		expedien.setExcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		// Se obtiene el organismo del instructor
		Instructor instructor = new Instructor();
		instructor.setItcodigo(expedien.getExcoit());
		expedien.setExcoor(instructorDao.findItcoor(instructor));
		expedien.setExcoit(expedien.getExcoit());

		Date fechaInicioExpediente = expedien.getExfere();
		// Año actual
		expedien.setExnran(new BigDecimal(Calendar.getInstance().get(Calendar.YEAR)));

		// Correlativo dentro del organismo y año
		expedien.setExnror(new BigDecimal(expedienDao.findExnrorSig(expedien)));

		// Establecimiento se hereda del expediente origen
		// Tambien se hereda el hecho denunciado
		Sanexp sanexp = expedien.getSanexp();

		/* CALCULAMOS LA FECHA DE FIN PREVISTA */
		sanexp.setExfecprevfin(this.parametrosDao.devuelvefechaFinPrevista(fechaInicioExpediente));
		sanexp.setExmocodigo(expedien.getExcoit());
		Expedien expedienNuevo = null;
		Establecimiento establecimiento = null;
		Intervinientes interv_establecimiento = null;
		Arbinterv reclamado = null;
		Intervinientes establecimientoInspecciones = null;
		// # INICIO #
		// ADAPTACIONES LEY 39 - BACKOFFICE SANCIONADOR: EXP RELACIONADO
		// TELEMATICA
		// Eliminar la siguiente declaracion
		// String formaNotiEstablecimiento = "";
		// # FIN #
		if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(expedien.getSanexp().getTipoprocOrigen())) {
			HechoDenunciado hechodenunciado = new HechoDenunciado();
			hechodenunciado.setHdcodigo(expedien.getSanexp().getExpedienteOrigen());
			hechodenunciado = hechodenunciadoDao.find(hechodenunciado);
			establecimiento = hechodenunciado.getEstablecimiento();

			interv_establecimiento = new Intervinientes();
			interv_establecimiento.setEscodigo(establecimiento.getEscodigo());
			interv_establecimiento.setIdExpediente(hechodenunciado.getHdcodigo());
			interv_establecimiento.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO); // J
																											// 19/12
			interv_establecimiento = intervinientesDao.findIntervinienteEstablecimiento(interv_establecimiento);

			// Creamos el expediente con el establecimiento
			// del hecho denunciado
			// origen
			expedien.setExcoes(establecimiento.getEscodigo());
			expedienNuevo = this.expedienDao.add(expedien);

			sanexp.setExcodigo(expedienNuevo.getExcodigo());
			sanexp.setExrecurso(Y41bConstantes.NO);
			sanexp.setExorden(Y41bConstantes.NO);
			sanexp.setExcooractual(expedienNuevo.getExcoor());
			sanexp.setPlatea(Y41bConstantes.VALOR_NO);
			sanexp.setExdestnotifsancionado(Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR);

			// 0159290: Acuerdo de incoaccin. Comunicacin al consumidor origen
			sanexp.setExhdformanotiforigen(hechodenunciado.getHdformanotificacion());
			// 0159290: Acuerdo de incoaccin. Comunicacin al consumidor origen
			sanexpDao.add(sanexp);

			// Actualizamos sanexp con el hecho
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(expedien.getSanexp().getExpedienteOrigen());
			solicitudDetalle = this.hechodenunciadoDao.findSolicitud(solicitudDetalle);
			// # INICIO #
			// ADAPTACIONES LEY 39 - BACKOFFICE SANCIONADOR: EXP RELACIONADO
			// TELEMATICA
			// Eliminar la siguiente asignacion
			// formaNotiEstablecimiento = solicitudDetalle
			// .getHdformanotificacionestablecimiento();
			// # FIN #
			sanexp.setTipoProc(Y41bConstantes.TIPO_PROC_SOLICITUDES);

			sanexp.setHechoDenunciado(hechodenunciado);
			if (solicitudDetalle != null) {
				logger.info("add().SolicitudDetalle NO ES NULL.");
				if (solicitudDetalle.getHdcodigo() != null) {
					logger.info("add().SolicitudDetalle HDCODIGO." + solicitudDetalle.getHdcodigo() + ".");
				}
			}

			if (solicitudDetalle.getHdfehd() != null) {
				sanexp.setHdfechd(solicitudDetalle
						.getHdfehd()); /*
										 * fecha de hecho denunciado
										 */

				Date fechaPrescripcion = parametrosDao.devuelvefechaPrescripcion(solicitudDetalle.getHdfehd(),
						Y41bConstantes.SAN_CALIFICACION_LEVE);
				sanexp.setExfecprescr(fechaPrescripcion);
				sanexp.setExcalif(Y41bConstantes.SAN_CALIFICACION_LEVE);

				logger.info("add().SolicitudDetalle Hdfehd." + solicitudDetalle.getHdfehd() + ".");
			} else {
				logger.info("add().SolicitudDetalle no tiene Hdfehd.");
			}
			/** PRODUCTO */
			if (solicitudDetalle.getPscodigo() != null) {
				expedienNuevo.setExcops(solicitudDetalle.getPscodigo());
				expedienDao.update(expedienNuevo);
				sanexp.setProducto(new Producto(solicitudDetalle.getPscodigo()));
				logger.info("add().SolicitudDetalle producto." + solicitudDetalle.getPscodigo() + ".");

			} else {
				logger.info("add().SolicitudDetalle no tiene Pscodigo.");
			}
			/** MOTIVO */
			if (solicitudDetalle.getTircodigo() != null) {
				sanexp.setMotivo(new Motivo(solicitudDetalle.getTircodigo(), null, null));
				logger.info("add().SolicitudDetalle motivo." + solicitudDetalle.getTircodigo() + ".");
			} else {
				logger.info("add().SolicitudDetalle no tiene Tircodigo.");
			}
			solicitudDetalle = this.hechodenunciadoDao.findLobTablaTemporal(solicitudDetalle);
			String textoHecho = solicitudDetalle.getHdte();
			if (solicitudDetalle != null && solicitudDetalle.getHdte() != null) {
				/*
				 * if (solicitudDetalle.getHdte().length() > 4000) { textoHecho
				 * = solicitudDetalle.getHdte().substring(0, 4000); }
				 */
				logger.info("add().SolicitudDetalle getHdte." + solicitudDetalle.getHdte() + ".");
				textoHecho = solicitudDetalle.getHdte();
				sanexp.setHdte(textoHecho);
			} else {
				logger.info("add().SolicitudDetalle no tiene Hdte.");
				sanexp.setHdte("");
			}

			sanexpDao.updateHechoDenunciadoOrigen(sanexp);
		} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(expedien.getSanexp().getTipoprocOrigen())) {
			Solarb solarb = new Solarb(expedien.getSanexp().getExpedienteOrigen());
			solarb = this.solarbDao.find(solarb);
			Arbexp arbexp = new Arbexp(expedien.getSanexp().getExpedienteOrigen());
			HechoDenunciado hechodenunciado = new HechoDenunciado();
			if (this.arbexpDao.findAllCount(arbexp) > 0) {
				arbexp = this.arbexpDao.find(arbexp);
				hechodenunciado.setHdte(arbexp.getHdte());
				hechodenunciado.setHdfehd(arbexp.getHdfechd());
				// Reclamado
				reclamado = this.arbintervDao.dameInterviniente(expedien.getSanexp().getExpedienteOrigen(),
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				expedien.setExcoes(reclamado.getUaescodigo());

			} else {
				if (!Y41bUtils.esNullOCadenaVacia(solarb.getSacohd())) {
					hechodenunciado.setHdcodigo(solarb.getSacohd());
					hechodenunciado = hechodenunciadoDao.find(hechodenunciado);
				}
				// Reclamado
				Essa essa = new Essa();
				essa.setSolarb(solarb);
				List<Essa> lessa = this.essaDao.findAll(essa, null);
				if (lessa != null && lessa.size() > 0) {
					String escodigo = lessa.get(0).getEstablecimiento().getEscodigo();
					expedien.setExcoes(escodigo);
					establecimiento = this.establecimientoDao.find(new Establecimiento(escodigo));
				}
			}
			expedienNuevo = this.expedienDao.add(expedien);

			sanexp.setExcodigo(expedienNuevo.getExcodigo());
			sanexp.setExrecurso(Y41bConstantes.NO);
			sanexp.setExorden(Y41bConstantes.NO);
			sanexp.setExcooractual(expedienNuevo.getExcoor());
			sanexp.setPlatea(Y41bConstantes.VALOR_NO);
			sanexp.setExdestnotifsancionado(Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR);
			sanexpDao.add(sanexp);

			sanexp.setTipoProc(Y41bConstantes.TIPO_PROC_ARBITRAJE);

			if (hechodenunciado.getHdfehd() != null) {
				sanexp.setHdfechd(hechodenunciado.getHdfehd());
				Date fechaPrescripcion = parametrosDao.devuelvefechaPrescripcion(hechodenunciado.getHdfehd(),
						Y41bConstantes.SAN_CALIFICACION_LEVE);
				sanexp.setExfecprescr(fechaPrescripcion);
				sanexp.setExcalif(Y41bConstantes.SAN_CALIFICACION_LEVE);

				logger.info("add().Arbitraje Hdfehd." + hechodenunciado.getHdfehd() + ".");
			} else {
				logger.info("add().Arbitraje no tiene Hdfehd.");
			}
			/** PRODUCTO */
			if (solarb.getSacops() != null) {
				expedienNuevo.setExcops(solarb.getSacops());
				expedienDao.update(expedienNuevo);
				sanexp.setProducto(new Producto(solarb.getSacops()));
				logger.info("add().Arbitraje producto." + solarb.getSacops() + ".");

			} else {
				logger.info("add().Arbitraje no tiene Pscodigo.");
			}
			/** MOTIVO */
			if (solarb.getSacotir() != null) {
				sanexp.setMotivo(new Motivo(solarb.getSacotir(), null, null));
				logger.info("add().Arbitraje motivo." + solarb.getSacotir() + ".");
			} else {
				logger.info("add().Arbitraje no tiene Tircodigo.");
			}

			if (hechodenunciado.getHdte() != null) {
				logger.info("add().SolicitudDetalle getHdte." + hechodenunciado.getHdte() + ".");
				sanexp.setHdte(hechodenunciado.getHdte());
			} else {
				logger.info("add().SolicitudDetalle no tiene Hdte.");
				sanexp.setHdte("");
			}
			sanexpDao.updateHechoDenunciadoOrigen(sanexp);
		} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(expedien.getSanexp().getTipoprocOrigen())) {

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(sanexp.getExpedienteOrigen());

			InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(actuacion, null);
			if (inspeccionDetalle != null) {
				boolean establecimientoResponsable = false;
				if (baprsanid != null) {
					Sanpropbandeja propuesta = new Sanpropbandeja();
					propuesta.setBaprsanid(baprsanid);
					List<Sanpropbandeja> listaPropuestas = sanpropbandejaDao.findAll(propuesta, null);
					if (listaPropuestas != null && listaPropuestas.size() > 0) {
						String baprsansancionado = ((Sanpropbandeja) listaPropuestas.get(0)).getBaprsansancionado();
						if (inspeccionDetalle.getEstablecimientoR() != null && baprsansancionado != null
								&& baprsansancionado
										.equalsIgnoreCase(inspeccionDetalle.getEstablecimientoR().getEscodigo())) {
							establecimientoResponsable = true;
						} else if (inspeccionDetalle.getEstablecimientoV() != null && baprsansancionado != null
								&& baprsansancionado
										.equalsIgnoreCase(inspeccionDetalle.getEstablecimientoV().getEscodigo())) {
							establecimientoResponsable = false;
						} else {
							establecimientoResponsable = false;
						}
					}
				}
				String formaNotificacionEstablecimientoInspecciones = null;
				String idiomaEstablecimientoInspecciones = null;
				if (establecimientoResponsable) {
					establecimientoInspecciones = inspeccionDetalle.getEstablecimientoR();
					formaNotificacionEstablecimientoInspecciones = inspeccionDetalle.getAtformanotifestablecimientore();
					// No existe valor para establecimiento responsable.
					// Castellano por defecto
					idiomaEstablecimientoInspecciones = Y41bConstantes.CASTELLANO;
				} else {
					establecimientoInspecciones = inspeccionDetalle.getEstablecimientoV();
					formaNotificacionEstablecimientoInspecciones = inspeccionDetalle.getAtformanotifestablecimientovi();
					idiomaEstablecimientoInspecciones = inspeccionDetalle.getAtidiomaestablecimientovi();
				}
				expedien.setExcoes(establecimientoInspecciones.getEscodigo());

				expedienNuevo = this.expedienDao.add(expedien);

				if (establecimientoInspecciones != null) {
					establecimiento = new Establecimiento();
					establecimiento.setEscodigo(establecimientoInspecciones.getEscodigo());
					establecimiento = this.establecimientoDao.find(establecimiento);
					establecimiento.setEscoidco(idiomaEstablecimientoInspecciones);
					Intervinientes intervAux = new Intervinientes();
					intervAux.setIdinterviniente(establecimientoInspecciones.getIdinterviniente());
					establecimientoInspecciones = intervinientesDao.find(intervAux);
				}

				expedienNuevo.setFormanotificacion(formaNotificacionEstablecimientoInspecciones);

				/** PRODUCTO */
				if (inspeccionDetalle.getAtcops() != null) {
					expedienNuevo.setExcops(inspeccionDetalle.getAtcops());
					expedienDao.update(expedienNuevo);
					sanexp.setProducto(new Producto(inspeccionDetalle.getAtcops()));
					logger.info("add().Inspeccion producto." + inspeccionDetalle.getAtcops() + ".");
				} else {
					logger.info("add().Inspeccion no tiene Pscodigo.");
				}

			}

			sanexp.setTipoProc(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			sanexp.setExcodigo(expedienNuevo.getExcodigo());
			sanexp.setExrecurso(Y41bConstantes.NO);
			sanexp.setExorden(Y41bConstantes.NO);
			sanexp.setExcooractual(expedienNuevo.getExcoor());
			sanexp.setPlatea(Y41bConstantes.VALOR_NO);
			sanexp.setExdestnotifsancionado(Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR);
			sanexpDao.add(sanexp);
		} else {
			/* HE SELECCIONADO UN ESTABLECIMIENTO */
			establecimiento = new Establecimiento();
			establecimiento.setEscodigo(expedien.getEscodigo());
			establecimiento = establecimientoDao.find(establecimiento);
			expedien.setExcoes(establecimiento.getEscodigo());
			expedienNuevo = this.expedienDao.add(expedien);

			sanexp.setExcodigo(expedienNuevo.getExcodigo());
			sanexp.setExcooractual(expedienNuevo.getExcoor());
			sanexp.setExdestnotifsancionado(Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR);
			sanexpDao.add(sanexp);
		}
		logger.info("ExpedienteServiceImpl. - Add. Insertado sanexp");

		// 2. Guardar el Organismo como Interviniente
		Organismo organismo = new Organismo();
		organismo.setCodOrg(expedienNuevo.getExcoor());
		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);
		// buscar el interviniente interesado
		Saninterv sanintervAux = new Saninterv();
		sanintervAux.setExpedien(new Expedien(expedienNuevo.getExcodigo()));
		sanintervAux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTESAN_OTROS);
		sanintervAux.setUaentidad_id(organismo.getEntidadId());
		List<Saninterv> listIntervinientes = this.sanintervDao.findAll(sanintervAux, null);
		sanintervAux.setExpedien(expedien);
		sanintervAux.setUanombre(organismo.getNombreEs());
		// sanintervAux.setUacoem(establecimiento.getEscoem());
		sanintervAux.setUanif(organismo.getCif());
		sanintervAux.setUanrtel(organismo.getTelefono());
		sanintervAux.setUanrtel2(null);
		sanintervAux.setUaprovId(organismo.getNoraProvinciaId());
		sanintervAux.setUamunId(organismo.getNoraMunicipioId());
		sanintervAux.setUalocId(organismo.getNoraLocalidadId());
		sanintervAux.setUacalleId(organismo.getNoraCalleId());
		// El campo noraCpId no se utiliza. Nora y no nora guarda el cp en
		// nombrecp
		// sanintervAux.setUacpId(organismo.getNoraCpId());
		sanintervAux.setUacpId(organismo.getNombreCp());
		sanintervAux.setUaportalId(organismo.getNoraPortalId());
		if (organismo.getCompleDirec() != null && organismo.getCompleDirec().length() > 40) {
			sanintervAux.setUanombrePiso(organismo.getCompleDirec().substring(0, 40));
		} else {
			sanintervAux.setUanombrePiso(organismo.getCompleDirec());
		}
		if (Y41bUtils.esNullOCadenaVacia(organismo.getNoraProvinciaId())
				|| (!Y41bConstantes.ARABA.equals(organismo.getNoraProvinciaId())
						&& !Y41bConstantes.BIZKAIA.equals(organismo.getNoraProvinciaId())
						&& !Y41bConstantes.GIPUZKOA.equals(organismo.getNoraProvinciaId()))) {
			sanintervAux.setUadireNocapv(organismo.getNombreCalle());
		}
		sanintervAux.setUadireAnt(organismo.getCompleDirec());
		sanintervAux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTESAN_OTROS);
		sanintervAux.setUaentidad_id(organismo.getEntidadId());
		if (Y41bUtils.esNullOCadenaVacia(organismo.getNoraPaisId())) {
			sanintervAux.setUapaisId(Y41bConstantes.COD_PAIS_ESTADO);
		} else {
			sanintervAux.setUapaisId(organismo.getNoraPaisId());
		}
		sanintervAux.setUaurl(organismo.getUrl());
		sanintervAux.setUacoem(organismo.getEmail());
		if (listIntervinientes != null && listIntervinientes.size() > 0) {
			sanintervAux.setUaidinterv(listIntervinientes.get(0).getUaidinterv());
			this.sanintervDao.update(sanintervAux);
		} else {
			this.sanintervDao.add(sanintervAux);
		}

		/* sugerimos y completamos el tramite de apertura */
		CensoMonitor censoMonitor = new CensoMonitor();
		censoMonitor.setMocodigo(sanexp.getExmocodigo());
		String exCodigo = expedien.getExcodigo();
		String descripcionExpediente = sanexp.getExdesces();
		Santramexp santramexp = santramexpDao.generarTramiteAperturaoAutomatico(exCodigo, fechaInicioExpediente,
				censoMonitor, descripcionExpediente);

		Santramexp santramexpAcuerdoIncoacion = santramexpService
				.sugiereTramiteAcuerdoIncoaccionAutomaticamente(santramexp);

		logger.info("ExpedienteServiceImpl. - Add. Insertado en historico fases");
		/* doy de alta la entrada en la nueva fase */
		Historicofases historicoFases = new Historicofases();
		historicoFases.setHffcodigo(Y41bConstantes.FASE_REGISTRO_SANCION);
		historicoFases.setHfexcodigo(expedienNuevo.getExcodigo());
		historicoFases.setHffinicio(new Date());
		historicoFasesDao.add(historicoFases);

		logger.info("ExpedienteServiceImpl. - Add. Se ha generado el tramite de Apertura y Sugerido el de Incoacion.");

		/* actualizamos el expediente con la fase y el ultimo tramite */
		sanexp.setFase(santramexpAcuerdoIncoacion.getFase());
		sanexp.setSantramexp(santramexpAcuerdoIncoacion);
		sanexp.setSantramexpEntidad(santramexpAcuerdoIncoacion);

		Sanexp sanexpAux = sanexpDao.findLobTablaTemporal(sanexp);
		sanexp.setHdte(sanexpAux.getHdte());

		sanexpDao.update(sanexp);

		logger.info("ExpedienteServiceImpl. - Add. sanexpDao. update");

		/* Damos de alta en la bandeja el tramite de apertura */
		// sanbandejaDao.creaTramiteAperturaBandeja(santramexp);
		// actualizamos la bandeja
		this.santramexpService.actualizaBandeja(santramexpAcuerdoIncoacion);

		logger.info("ExpedienteServiceImpl. - Add. He añadido a la bandeja");
		// sanbandejaDao.creaAvisoSegunParametro(expedien, censoMonitor,
		// santramexp,
		// Y41bConstantes.TIPO_AVISO_SANCIONES_APERTURA_PROP_RESOL);
		// sanbandejaDao.creaAvisoSegunParametro(expedien, censoMonitor,
		// santramexp, Y41bConstantes.TIPO_AVISO_SANCIONES_APERTURA_RESOL);

		/* si existe la fecha de hecho denunciado */
		if (expedien.getSanexp().getHdfechd() != null) {
			sanbandejaDao.creaAvisoFechaPrescripcion(expedienNuevo, censoMonitor,
					Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION);
		}

		logger.info("ExpedienteServiceImpl. - Add. He creado avisos en Bandeja. ");
		// guardamos sancionado el establecimiento del hecho denunciado origen o
		// el establecimiento
		if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(expedien.getSanexp().getTipoprocOrigen())
				&& interv_establecimiento != null) {
			Saninterv sancionado = new Saninterv();
			sancionado.setExpedien(expedienNuevo);
			sancionado.setUaescodigo(interv_establecimiento.getEscodigo());
			sancionado.setUanombre(interv_establecimiento.getNombre());
			sancionado.setUanif(interv_establecimiento.getNif());
			sancionado.setUacoem(interv_establecimiento.getCoem());
			sancionado.setUanrtel(interv_establecimiento.getNrtel());
			sancionado.setUanrtel2(interv_establecimiento.getNrtel2());
			sancionado.setUaprovId(interv_establecimiento.getNoraProvinciaId());
			sancionado.setUamunId(interv_establecimiento.getNoraMunicipioId());
			sancionado.setUalocId(interv_establecimiento.getNoraLocalidadId());
			sancionado.setUacalleId(interv_establecimiento.getNoraCalleId());
			sancionado.setUacpId(interv_establecimiento.getNombreCp());
			String pais = "";
			if (Y41bConstantes.SI.equals(interv_establecimiento.getExtranjero())) {
				pais = interv_establecimiento.getNoraPaisId();
			} else {
				pais = Y41bConstantes.COD_PAIS_ESTADO;
			}
			sancionado.setUapaisId(pais);

			sancionado.setUaportalId(interv_establecimiento.getNoraPortalId());
			sancionado.setUanombrePiso(interv_establecimiento.getNombrePiso());
			sancionado.setUanodir(interv_establecimiento.getNombrePiso());
			sancionado.setUadireAnt(interv_establecimiento.getDireccionAntigua());
			sancionado.setUadireNocapv(interv_establecimiento.getDireccionNocapv());
			sancionado.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			sancionado.setUanopeco(interv_establecimiento.getEsnopeco());
			sancionado.setUaurl(interv_establecimiento.getEsteurl());
			sancionado.setUanoco(interv_establecimiento.getEsnoco());
			sancionado.setUasecodigo(interv_establecimiento.getSecodigo());
			sancionado.setUasenombre(interv_establecimiento.getSenombre());
			sancionado.setUasenombree(interv_establecimiento.getSenombree());
			sancionado.setUafecultmod(interv_establecimiento.getInfemod());
			sancionado.setUausuultmod(interv_establecimiento.getIncozs());
			// # INICIO #
			// ADAPTACIONES LEY 39 - BACKOFFICE SANCIONADOR: EXP RELACIONADO
			// TELEMATICA
			// Eliminar el siguiente bloque if-else y dejar la siguiente
			// asignacion en su lugar
			// if (Y41bUtils.esNullOCadenaVacia(formaNotiEstablecimiento)) {
			// sancionado
			// .setUaformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
			// } else {
			// sancionado.setUaformanotificacion(formaNotiEstablecimiento);
			// }
			//
			// # INICIO #
			// EVOLUTIVO 143829 - Si NIF/NIE postal/ordinario, sino telematico
			if (Y41bUtils.isValidNIF(sancionado.getUanif()) || Y41bUtils.isValidNIE(sancionado.getUanif())) {
				sancionado.setUaformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
			} else {
				sancionado.setUaformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA);
			}
			// # FIN #
			// # FIN #

			sancionado.setUaidioma(interv_establecimiento.getCoidco());
			if (sancionado.getUaidioma() == null) {
				sancionado.setUaidioma(Y41bConstantes.CASTELLANO_CENSO);
			}
			sanintervDao.add(sancionado);
			this.sanexpDao.updateEXIDPARTICIPACIONSANCIONADO(sancionado, expedien.getExcodigo());
		} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(expedien.getSanexp().getTipoprocOrigen())
				&& reclamado != null) {
			Saninterv sancionado = new Saninterv();
			sancionado.setExpedien(expedienNuevo);
			sancionado.setUaescodigo(reclamado.getUaescodigo());
			sancionado.setUanombre(reclamado.getUanombre());
			sancionado.setUanif(reclamado.getUanif());
			sancionado.setUacoem(reclamado.getUacoem());
			sancionado.setUanrtel(reclamado.getUanrtel());
			sancionado.setUanrtel2(reclamado.getUanrtel2());
			sancionado.setUaprovId(reclamado.getUaprovId());
			sancionado.setUamunId(reclamado.getUamunId());
			sancionado.setUalocId(reclamado.getUalocId());
			sancionado.setUacalleId(reclamado.getUacalleId());
			sancionado.setUacpId(reclamado.getUacpId());
			sancionado.setUapaisId(reclamado.getUapaisId());
			sancionado.setUaportalId(reclamado.getUaportalId());
			sancionado.setUanombrePiso(reclamado.getUanombrePiso());
			sancionado.setUanodir(reclamado.getUanodir());
			sancionado.setUadireAnt(reclamado.getUadireAnt());
			sancionado.setUadireNocapv(reclamado.getUadireNocapv());
			sancionado.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			sancionado.setUanopeco(reclamado.getUanopeco());
			sancionado.setUaurl(reclamado.getUaurl());
			sancionado.setUanoco(reclamado.getUanoco());
			sancionado.setUasecodigo(reclamado.getUasecodigo());
			sancionado.setUasenombre(reclamado.getUasenombre());
			sancionado.setUasenombree(reclamado.getUasenombree());
			sancionado.setUafecultmod(reclamado.getUafecultmod());
			sancionado.setUausuultmod(reclamado.getUausuultmod());
			sancionado.setUaidioma(reclamado.getUaidioma());
			if (sancionado.getUaidioma() == null) {
				sancionado.setUaidioma(Y41bConstantes.CASTELLANO_CENSO);
			}
			// # INICIO #
			// ADAPTACIONES LEY 39 - BACKOFFICE SANCIONADOR: EXP RELACIONADO
			// TELEMATICA
			// Eliminar la primera asignacin y dejar la segunda en su lugar
			// sancionado.setUaformanotificacion(reclamado.getUaformanotificacion());
			//
			// # INICIO #
			// EVOLUTIVO 143829 - Si NIF/NIE postal/ordinario, sino telematico
			if (Y41bUtils.isValidNIF(sancionado.getUanif()) || Y41bUtils.isValidNIE(sancionado.getUanif())) {
				sancionado.setUaformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
			} else {
				sancionado.setUaformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA);
			}
			// # FIN #
			// # FIN #
			sanintervDao.add(sancionado);
			this.sanexpDao.updateEXIDPARTICIPACIONSANCIONADO(sancionado, expedien.getExcodigo());
		} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(expedien.getSanexp().getTipoprocOrigen())
				&& establecimientoInspecciones != null) {
			Saninterv sancionado = new Saninterv();
			sancionado.setExpedien(expedienNuevo);
			sancionado.setUaescodigo(establecimientoInspecciones.getEscodigo());
			sancionado.setUanombre(establecimientoInspecciones.getNombre());
			sancionado.setUanif(establecimientoInspecciones.getNif());
			sancionado.setUacoem(establecimientoInspecciones.getCoem());
			sancionado.setUanrtel(establecimientoInspecciones.getNrtel());
			sancionado.setUanrtel2(establecimientoInspecciones.getNrtel2());
			sancionado.setUaprovId(establecimientoInspecciones.getNoraProvinciaId());
			sancionado.setUamunId(establecimientoInspecciones.getNoraMunicipioId());
			sancionado.setUalocId(establecimientoInspecciones.getNoraLocalidadId());
			sancionado.setUacalleId(establecimientoInspecciones.getNoraCalleId());
			sancionado.setUacpId(establecimientoInspecciones.getNombreCp());
			String pais = "";
			if (Y41bConstantes.SI.equals(establecimientoInspecciones.getExtranjero())) {
				pais = establecimientoInspecciones.getNoraPaisId();
			} else {
				pais = Y41bConstantes.COD_PAIS_ESTADO;
			}
			sancionado.setUapaisId(pais);

			sancionado.setUaportalId(establecimientoInspecciones.getNoraPortalId());
			sancionado.setUanombrePiso(establecimientoInspecciones.getNombrePiso());
			sancionado.setUanodir(establecimientoInspecciones.getNombrePiso());
			sancionado.setUadireAnt(establecimientoInspecciones.getDireccionAntigua());
			sancionado.setUadireNocapv(establecimientoInspecciones.getDireccionNocapv());
			sancionado.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			sancionado.setUanopeco(establecimientoInspecciones.getEsnopeco());
			sancionado.setUaurl(establecimientoInspecciones.getEsteurl());
			sancionado.setUanoco(establecimientoInspecciones.getEsnoco());
			sancionado.setUasecodigo(establecimientoInspecciones.getSecodigo());
			sancionado.setUasenombre(establecimientoInspecciones.getSenombre());
			sancionado.setUasenombree(establecimientoInspecciones.getSenombree());
			sancionado.setUafecultmod(establecimientoInspecciones.getInfemod());
			sancionado.setUausuultmod(establecimientoInspecciones.getIncozs());
			// # INICIO #
			// ADAPTACIONES LEY 39 - BACKOFFICE SANCIONADOR: EXP RELACIONADO
			// TELEMATICA
			// Eliminar el siguiente bloque if-else y dejar la siguiente
			// asignacion en su lugar
			// if (Y41bUtils.esNullOCadenaVacia(formaNotiEstablecimiento)) {
			// sancionado
			// .setUaformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
			// } else {
			// sancionado.setUaformanotificacion(formaNotiEstablecimiento);
			// }
			//
			// # INICIO #
			// EVOLUTIVO 143829 - Si NIF/NIE postal/ordinario, sino telematico
			if (Y41bUtils.isValidNIF(sancionado.getUanif()) || Y41bUtils.isValidNIE(sancionado.getUanif())) {
				sancionado.setUaformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
			} else {
				sancionado.setUaformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA);
			}
			// # FIN #
			// # FIN #

			sancionado.setUaidioma(establecimientoInspecciones.getCoidco());
			if (sancionado.getUaidioma() == null) {
				sancionado.setUaidioma(Y41bConstantes.CASTELLANO_CENSO);
			}
			sanintervDao.add(sancionado);
			this.sanexpDao.updateEXIDPARTICIPACIONSANCIONADO(sancionado, expedien.getExcodigo());
		} else if (establecimiento != null) {
			establecimiento = this.tratamientoAnyadirIntervinienteSancionado(establecimiento);
			Saninterv sancionado = new Saninterv();
			sancionado.setExpedien(expedienNuevo);
			sancionado.setUaescodigo(establecimiento.getEscodigo());
			sancionado.setUanombre(establecimiento.getEsnombre());
			sancionado.setUanif(establecimiento.getEsnif());
			sancionado.setUacoem(establecimiento.getEscoem());
			sancionado.setUanrtel(establecimiento.getEsnrtel());
			sancionado.setUanrtel2(establecimiento.getEsnrtel2());
			sancionado.setUacoem(establecimiento.getEscoem());
			sancionado.setUaprovId(establecimiento.getEsnoraProvinciaId());
			sancionado.setUamunId(establecimiento.getEsnoraMunicipioId());
			sancionado.setUalocId(establecimiento.getEsnoraLocalidadId());
			sancionado.setUacalleId(establecimiento.getEsnoraCalleId());
			sancionado.setUacpId(establecimiento.getEsnombreCp());
			String pais = "";
			if (Y41bConstantes.SI.equals(establecimiento.getEsextranjero())) {
				pais = establecimiento.getEsnoraPaisId();
			} else {
				pais = Y41bConstantes.COD_PAIS_ESTADO;
			}
			sancionado.setUapaisId(pais);

			sancionado.setUaportalId(establecimiento.getEsnoraPortalId());
			sancionado.setUanombrePiso(establecimiento.getEsnombrePiso());
			sancionado.setUadireNocapv(establecimiento.getEsdireccion_nocapv());
			sancionado.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			sancionado.setUanodir(establecimiento.getEsnombrePiso());
			sancionado.setUadireAnt(establecimiento.getEsnodir());

			sancionado.setUanopeco(establecimiento.getEsnopeco());
			sancionado.setUaurl(establecimiento.getEsteurl());
			sancionado.setUanoco(establecimiento.getEsnoco());

			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEstablecimiento(establecimiento);

			EstablecimSector establecSector = new EstablecimSector();
			Actividad actividad = new Actividad();
			Sector sector = new Sector();
			establecSector.setActividad(actividad);
			establecSector.setSector(sector);

			establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

			sancionado.setUasecodigo(establecSector.getSector().getSecodigo());
			sancionado.setUasenombre(establecSector.getSector().getSenombre());
			sancionado.setUasenombree(establecSector.getSector().getSenombree());
			sancionado.setUafecultmod(establecimiento.getEsfemod());
			sancionado.setUausuultmod(establecimiento.getCensoMonitor().getMocodigo());
			// # INICIO #
			// ADAPTACIONES LEY 39 - BACKOFFICE SANCIONADOR: EXP RELACIONADO
			// TELEMATICA
			// Eliminar el siguiente bloque if-else y dejar la siguiente
			// asignacion en su lugar
			// if (Y41bUtils.esNullOCadenaVacia(formaNotiEstablecimiento)) {
			// sancionado
			// .setUaformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
			// } else {
			// sancionado.setUaformanotificacion(formaNotiEstablecimiento);
			// }
			//
			// # INICIO #
			// EVOLUTIVO 143829 - Si NIF/NIE postal/ordinario, sino telematico
			if (Y41bUtils.isValidNIF(sancionado.getUanif()) || Y41bUtils.isValidNIE(sancionado.getUanif())) {
				sancionado.setUaformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
			} else {
				sancionado.setUaformanotificacion(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA);
			}
			// # FIN #
			// # FIN #

			if (establecimiento.getEscoidco() != null) {
				if (Y41bConstantes.CASTELLANO.equals(establecimiento.getEscoidco().toLowerCase())) {
					sancionado.setUaidioma(Y41bConstantes.CASTELLANO_CENSO);
				} else {
					sancionado.setUaidioma(Y41bConstantes.EUSKERA_CENSO);
				}
			} else {
				sancionado.setUaidioma(Y41bConstantes.CASTELLANO_CENSO);
			}
			sanintervDao.add(sancionado);
			this.sanexpDao.updateEXIDPARTICIPACIONSANCIONADO(sancionado, expedien.getExcodigo());
		}
		/*
		 * Añadimos los consumidores de los expediente origen y el sancionado
		 * del expediente origen seleccionado como establecimiento
		 */

		// ->if (aperturaRelacionada) {<-
		if (!Y41bUtils.esNullOCadenaVacia(expedien.getSanexp().getExcodrel())) {

			Sanexprel sanexprel = new Sanexprel();
			Sanexprel sanexprelsolicitud = new Sanexprel();
			sanexprel.setExpedienByRlexcodigo(expedienNuevo);

			String[] arrayIds = expedien.getSanexp().getExcodrel().split(",");
			// long relacionado = 0;
			String codigo = "";
			String tipoproc = "";
			StringBuffer solicitudes = new StringBuffer("");
			StringBuffer arbitrajes = new StringBuffer("");
			StringBuffer inspecciones = new StringBuffer("");
			TramiteGenerico tramiteGenerico = new TramiteGenerico();
			InfraccHechoDen infraccHechoDen = new InfraccHechoDen();
			InfraccArb infraccArb = new InfraccArb();
			InfraccHechoDen infrrhechoden = new InfraccHechoDen();
			ActaInfraccion actainfraccion = new ActaInfraccion();
			InfraccHechoDenExpSanc infrrhechodensan = new InfraccHechoDenExpSanc();

			for (int i = 0; i < arrayIds.length; i++) {
				codigo = arrayIds[i].split("-")[0];
				tipoproc = arrayIds[i].split("-")[1];

				if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc)) {
					if (solicitudes.length() > 0) {
						solicitudes.append(",");
					}
					solicitudes.append(codigo);
				} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc)) {
					if (arbitrajes.length() > 0) {
						arbitrajes.append(",");
					}
					arbitrajes.append(codigo);
				} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
					if (inspecciones.length() > 0) {
						inspecciones.append(",");
					}
					inspecciones.append(codigo);
				}

				if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc)) {
					sanexprel.setRlhdcodrel(codigo);
					sanexprel.setRlarbcodrel(null);
					sanexprel.setRlexcodrel(null);
					sanexprel.setRlinscodrel(null);
				} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc)) {
					sanexprel.setRlhdcodrel(null);
					sanexprel.setRlarbcodrel(codigo);
					sanexprel.setRlexcodrel(null);
					sanexprel.setRlinscodrel(null);
				} else if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoproc)) {
					sanexprel.setRlhdcodrel(null);
					sanexprel.setRlarbcodrel(null);
					sanexprel.setRlexcodrel(codigo);
					sanexprel.setRlinscodrel(null);
				} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
					sanexprel.setRlhdcodrel(null);
					sanexprel.setRlarbcodrel(null);
					sanexprel.setRlexcodrel(null);
					sanexprel.setRlinscodrel(codigo);
				}

				if (expedien.getSanexp().getExpedienteOrigen().equals(codigo)) {
					sanexprel.setRlesorig(Y41bConstantes.VALOR_SI);
				} else {
					if (!Y41bUtils.esNullOCadenaVacia(tipoproc)
							&& tipoproc.equals(expedien.getSanexp().getTipoprocOrigen())) {
						sanexprel.setRlesorig(Y41bConstantes.TIPO_SAN_EXPREL_ACUMULADO);
					} else {
						sanexprel.setRlesorig(Y41bConstantes.VALOR_NO);
					}
				}
				this.sanexprelDao.add(sanexprel);

				if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc)) {
					/* CREAMOS LA RELACION EN SOLICITUDES */
					/* codigo de la solicitud */
					sanexprelsolicitud.setRlhdcodigo(codigo);
					/* codigo de la sancion */
					sanexprelsolicitud.setRlexcodrel(expedienNuevo.getExcodigo());
					sanexprelsolicitud.setRlarbcodigo(null);
					sanexprelsolicitud.setExpedienByRlexcodigo(null);
					sanexprelsolicitud.setRlinscodigo(null);
					sanexprelsolicitud.setRlesorig(Y41bConstantes.VALOR_NO);
					this.sanexprelDao.add(sanexprelsolicitud);
				} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc)) {
					/* CREAMOS LA RELACION EN ARBITRAJE */
					/* codigo del arbitraje */
					sanexprelsolicitud.setRlarbcodigo(codigo);
					/* codigo de la sancion */
					sanexprelsolicitud.setRlexcodrel(expedienNuevo.getExcodigo());
					sanexprelsolicitud.setRlhdcodigo(null);
					sanexprelsolicitud.setExpedienByRlexcodigo(null);
					sanexprelsolicitud.setRlinscodigo(null);
					sanexprelsolicitud.setRlesorig(Y41bConstantes.VALOR_NO);
					this.sanexprelDao.add(sanexprelsolicitud);
				} else if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoproc)) {
					/* CREAMOS LA RELACION EN EL OTRO SANCIONADOR */
					/* codigo de la sancion */
					sanexprelsolicitud.setExpedienByRlexcodigo(new Expedien(codigo));
					/* codigo de la sancion */
					sanexprelsolicitud.setRlexcodrel(expedienNuevo.getExcodigo());
					sanexprelsolicitud.setRlhdcodigo(null);
					sanexprelsolicitud.setRlarbcodigo(null);
					sanexprelsolicitud.setRlinscodigo(null);
					sanexprelsolicitud.setRlesorig(Y41bConstantes.VALOR_NO);
					this.sanexprelDao.add(sanexprelsolicitud);
				} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
					/* CREAMOS LA RELACION EN INSPECCIONES */
					/* codigo de la inspeccion */
					sanexprelsolicitud.setRlinscodigo(codigo);
					/* codigo de la sancion */
					sanexprelsolicitud.setRlexcodrel(expedienNuevo.getExcodigo());
					sanexprelsolicitud.setRlhdcodigo(null);
					sanexprelsolicitud.setRlarbcodigo(null);
					sanexprelsolicitud.setExpedienByRlexcodigo(null);
					sanexprelsolicitud.setRlesorig(Y41bConstantes.VALOR_NO);
					this.sanexprelDao.add(sanexprelsolicitud);
				}

				// Para cada solicitud relacionada a�ado un tramite generico
				// avisando que es origen/acumulado de una sancion
				if (tipoproc.equals(expedien.getSanexp().getTipoprocOrigen())) {
					if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc)) {
						tramiteGenerico.setIdExpediente(codigo);
						tramiteGenerico.setFechaInicio(Y41bUtils.hoy());
						tramiteGenerico.setInstructorAsignado(censoMonitor);
						tramiteGenerico.setComentario(appMessageSource.getMessage("tramite.aperturaSancionComentario",
								null, LocaleContextHolder.getLocale()) + " ( " + Y41bConstantes.TIPO_PROC_SANCIONES
								+ "-" + expedienNuevo.damecodCompleto() + " )");
						String literalNombreTramite = "tramite.aperturaSancion";
						this.soltramexpService.addTramiteGenericoAutomatico(tramiteGenerico, literalNombreTramite);

						/*
						 * Buscamos las infracciones de todos los expedientes
						 * relacionados
						 */
						infraccHechoDen.setHicodigo(null);
						infraccHechoDen.setHicohd(codigo);
						infraccHechoDen.setTipReqNormativo(null);
						infraccHechoDen.setHiinexii(null);
						infraccHechoDen.setHiifid(null);
						List<InfraccHechoDen> listaInfraccionesExpedienteOrig = infraccHechoDenDao
								.findAll(infraccHechoDen, null);
						// -> InfraccHechoDenExpSanc infraccHechoDenExpSanc =
						// null
						if (listaInfraccionesExpedienteOrig != null) {
							for (int j = 0; j < listaInfraccionesExpedienteOrig.size(); j++) {
								infraccHechoDen = listaInfraccionesExpedienteOrig.get(j);
								// Para evitar articulos repetidos
								if (!infraccHechoDenExpSancDao.existeArticuloMateria(expedienNuevo.getExcodigo(),
										infraccHechoDen.getTipReqNormativo().getTticodigo())) {
									String hiinexiid = null;
									if (infraccHechoDen.getTipReqNormativo().getTticodigo().indexOf("N0") > -1) {
										// es un articulo
										hiinexiid = "S";
									}
									String hicodigo = Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE);
									infrrhechoden.setHicodigo(hicodigo);
									infrrhechoden.setHicohd(null);
									infrrhechoden.setTipReqNormativo(infraccHechoDen.getTipReqNormativo());
									infrrhechoden.setHiinexii(hiinexiid);
									infrrhechoden.setHiifid(null);
									infraccHechoDenDao.add(infrrhechoden);
									infrrhechodensan.setDxcodigo(hicodigo);
									infrrhechodensan.setDxcoex(expedienNuevo.getExcodigo());
									infrrhechodensan.setInfraccHechoDen(infrrhechoden);
									infrrhechodensan.setTipopronunciamento(null);
									infraccHechoDenExpSancDao.add(infrrhechodensan);
								}
							}
						}
					} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc)) {
						tramiteGenerico.setIdExpediente(codigo);
						tramiteGenerico.setFechaInicio(Y41bUtils.hoy());
						tramiteGenerico.setInstructorAsignado(censoMonitor);
						tramiteGenerico.setComentario(appMessageSource.getMessage("tramite.aperturaSancionComentario",
								null, LocaleContextHolder.getLocale()) + " ( " + Y41bConstantes.TIPO_PROC_SANCIONES
								+ "-" + expedienNuevo.damecodCompleto() + " )");
						tramiteGenerico.setNombreTramite(appMessageSource.getMessage("tramite.aperturaSancion", null,
								LocaleContextHolder.getLocale()));
						TramiteComun tramiteComun = new TramiteComun();
						tramiteComun.setIdExpediente(codigo);
						tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_GENERICO);
						tramiteComun.setTipoProcedimiento(new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ARBITRAJE));
						tramiteComun.setIdTramite(arbtramexpService.getNewPK().toString());
						this.arbtramexp4Service.addTramiteGenerico(tramiteGenerico, tramiteComun, "", false,
								Y41bConstantes.MODO_POPUP_ALTA);

						/*
						 * Buscamos las infracciones de todos los expedientes
						 * relacionados
						 */
						infraccArb.setHicodigo(null);
						infraccArb.setHicoarb(codigo);
						infraccArb.setTipReqNormativo(null);
						infraccArb.setHiinexii(null);
						infraccArb.setHiifid(null);
						List<InfraccArb> listaInfraccionesExpedienteOrig = this.infraccArbDao.findAll(infraccArb, null);
						// -> InfraccHechoDenExpSanc infraccHechoDenExpSanc =
						// null
						if (listaInfraccionesExpedienteOrig != null) {
							for (int j = 0; j < listaInfraccionesExpedienteOrig.size(); j++) {
								infraccArb = listaInfraccionesExpedienteOrig.get(j);
								// Para evitar articulos repetidos
								if (!infraccHechoDenExpSancDao.existeArticuloMateria(expedienNuevo.getExcodigo(),
										infraccArb.getTipReqNormativo().getTticodigo())) {
									String hiinexiid = null;
									if (infraccArb.getTipReqNormativo().getTticodigo().indexOf("N0") > -1) {
										// es un articulo
										hiinexiid = "S";
									}
									String hicodigo = Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE);
									infrrhechoden.setHicodigo(hicodigo);
									infrrhechoden.setHicohd(null);
									infrrhechoden.setTipReqNormativo(infraccArb.getTipReqNormativo());
									infrrhechoden.setHiinexii(hiinexiid);
									infrrhechoden.setHiifid(null);
									infraccHechoDenDao.add(infrrhechoden);
									infrrhechodensan.setDxcodigo(hicodigo);
									infrrhechodensan.setDxcoex(expedienNuevo.getExcodigo());
									infrrhechodensan.setInfraccHechoDen(infrrhechoden);
									infrrhechodensan.setTipopronunciamento(null);
									infraccHechoDenExpSancDao.add(infrrhechodensan);
								}
							}
						}
					} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
						tramiteGenerico.setIdExpediente(codigo);
						tramiteGenerico.setFechaInicio(Y41bUtils.hoy());
						tramiteGenerico.setInstructorAsignado(censoMonitor);
						tramiteGenerico.setComentario(appMessageSource.getMessage("tramite.aperturaSancionComentario",
								null, LocaleContextHolder.getLocale()) + " ( " + Y41bConstantes.TIPO_PROC_SANCIONES
								+ "-" + expedienNuevo.damecodCompleto() + " ) "
								+ establecimientoInspecciones.getNombre());
						String literalNombreTramite = "tramite.aperturaSancion";
						this.instramexpService.addTramiteGenericoAutomatico(tramiteGenerico, literalNombreTramite);

						/*
						 * Buscamos las infracciones de todos los expedientes
						 * relacionados
						 */
						actainfraccion.setAicoat(codigo);
						List<ActaInfraccion> listaInfraccionesExpedienteOrig = this.actaInfraccionDao
								.findAll(actainfraccion, null);
						// -> InfraccHechoDenExpSanc infraccHechoDenExpSanc =
						// null
						if (listaInfraccionesExpedienteOrig != null) {
							for (int j = 0; j < listaInfraccionesExpedienteOrig.size(); j++) {
								actainfraccion = listaInfraccionesExpedienteOrig.get(j);
								// Para evitar articulos repetidos
								if (!infraccHechoDenExpSancDao.existeArticuloMateria(expedienNuevo.getExcodigo(),
										actainfraccion.getAicotti())) {
									String hiinexiid = null;
									if (actainfraccion.getAicotti().indexOf("N0") > -1) {
										// es un articulo
										hiinexiid = "S";
									}
									String hicodigo = Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE);
									infrrhechoden.setHicodigo(hicodigo);
									infrrhechoden.setHicohd(null);
									if (infraccHechoDen.getTipReqNormativo() == null) {
										TipReqNormativo tipReqNormativo = new TipReqNormativo();
										tipReqNormativo.setTticodigo(actainfraccion.getAicotti());
										tipReqNormativo = this.tipReqNormativoDao.find(tipReqNormativo);
										infrrhechoden.setTipReqNormativo(tipReqNormativo);
									} else {
										infrrhechoden.setTipReqNormativo(infraccHechoDen.getTipReqNormativo());
									}
									infrrhechoden.setHiinexii(hiinexiid);
									infrrhechoden.setHiifid(null);
									infraccHechoDenDao.add(infrrhechoden);
									infrrhechodensan.setDxcodigo(hicodigo);
									infrrhechodensan.setDxcoex(expedienNuevo.getExcodigo());
									infrrhechodensan.setInfraccHechoDen(infrrhechoden);
									infrrhechodensan.setTipopronunciamento(null);
									infraccHechoDenExpSancDao.add(infrrhechodensan);
								}
							}
						}
						// throw new Exception();
					}
				}

				/*
				 * Borramos el expediente de la bandeja de propuesta de sancion
				 */
				Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
				sanpropbandeja.setBaprsanexcodigo(codigo);
				if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
					sanpropbandeja.setBaprsansancionado(expedien.getExcoes());
					sanpropbandejaDao.removeInspecciones(sanpropbandeja);
				} else {
					sanpropbandejaDao.removeSolicitudes(sanpropbandeja);
				}
			}

			// Añadimos todos los reclamantes como consumidor(origen) de los
			// expediente cuyo
			// tipoproc coincide con el tipo de procedimiento origen
			// el resto como consumidores
			if (!Y41bUtils.esNullOCadenaVacia(solicitudes.toString())
					&& Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(expedien.getSanexp().getTipoprocOrigen())) {
				sanintervDao.aniadirDenunciantes(solicitudes.toString(), expedienNuevo.getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO);
			} else {
				sanintervDao.aniadirDenunciantes(solicitudes.toString(), expedienNuevo.getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR);
			}
			if (!Y41bUtils.esNullOCadenaVacia(arbitrajes.toString())
					&& Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(expedien.getSanexp().getTipoprocOrigen())) {
				sanintervDao.aniadirDenunciantesArb(arbitrajes.toString(), expedienNuevo.getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO);
			} else {
				sanintervDao.aniadirDenunciantesArb(arbitrajes.toString(), expedienNuevo.getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR);
			}
			if (!Y41bUtils.esNullOCadenaVacia(inspecciones.toString())
					&& Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(expedien.getSanexp().getTipoprocOrigen())) {
				sanintervDao.aniadirDenunciantes(inspecciones.toString(), expedienNuevo.getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO);
			} else {
				sanintervDao.aniadirDenunciantes(inspecciones.toString(), expedienNuevo.getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR);
			}
		}

		// Crear un tramite generico
		// Fin Bloque del Test
		logger.info("ExpedienteServiceImpl. - Fin: add");
		return expedienNuevo;

	}

	/**
	 * 
	 * @param expedien
	 *            Expedien
	 * @param actualizarHecho
	 *            String
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void acumular(Expedien expedien, String actualizarHecho) throws Exception {
		// Se genera la PK
		logger.info("ExpedienteServiceImpl. - Add. Inicio");

		// Establecimiento se hereda del expediente origen
		// Tambien se hereda el hecho denunciado
		String nombreEstablecimiento = null;
		Sanexp sanexp = expedien.getSanexp();
		Saninterv sancionado = this.sanintervDao.dameSancionado(expedien.getExcodigo());
		if (Y41bConstantes.VALOR_SI.equals(actualizarHecho)) {
			if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(expedien.getSanexp().getTipoprocOrigen())
					&& expedien.getSanexp().getExpedienteOrigen() != null) {

				HechoDenunciado hechodenunciado = new HechoDenunciado();
				hechodenunciado.setHdcodigo(expedien.getSanexp().getExpedienteOrigen());
				hechodenunciado = hechodenunciadoDao.find(hechodenunciado);
				// Actualizamos sanexp con el hecho
				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(expedien.getSanexp().getExpedienteOrigen());
				solicitudDetalle = this.hechodenunciadoDao.findSolicitud(solicitudDetalle);
				sanexp.setTipoProc(Y41bConstantes.TIPO_PROC_SOLICITUDES);
				sanexp.setHechoDenunciado(hechodenunciado);
				if (solicitudDetalle != null) {
					logger.info("add().SolicitudDetalle NO ES NULL.");
					if (solicitudDetalle.getHdcodigo() != null) {
						logger.info("add().SolicitudDetalle HDCODIGO." + solicitudDetalle.getHdcodigo() + ".");
					}
				}
				if (solicitudDetalle.getHdfehd() != null) {
					sanexp.setHdfechd(solicitudDetalle
							.getHdfehd()); /*
											 * fecha de hecho denunciado
											 */

					Date fechaPrescripcion = parametrosDao.devuelvefechaPrescripcion(solicitudDetalle.getHdfehd(),
							Y41bConstantes.SAN_CALIFICACION_LEVE);
					sanexp.setExfecprescr(fechaPrescripcion);
					sanexp.setExcalif(Y41bConstantes.SAN_CALIFICACION_LEVE);

					logger.info("add().SolicitudDetalle Hdfehd." + solicitudDetalle.getHdfehd() + ".");
				} else {
					logger.info("add().SolicitudDetalle no tiene Hdfehd.");
				}
				/** PRODUCTO */
				if (solicitudDetalle.getPscodigo() != null) {
					expedien.setExcops(solicitudDetalle.getPscodigo());
					expedienDao.updatePS(expedien);
					sanexp.setProducto(new Producto(solicitudDetalle.getPscodigo()));
					logger.info("add().SolicitudDetalle producto." + solicitudDetalle.getPscodigo() + ".");

				} else {
					logger.info("add().SolicitudDetalle no tiene Pscodigo.");
				}
				/** MOTIVO */
				if (solicitudDetalle.getTircodigo() != null) {
					sanexp.setMotivo(new Motivo(solicitudDetalle.getTircodigo(), null, null));
					logger.info("add().SolicitudDetalle motivo." + solicitudDetalle.getTircodigo() + ".");
				} else {
					logger.info("add().SolicitudDetalle no tiene Tircodigo.");
				}
				solicitudDetalle = this.hechodenunciadoDao.findLobTablaTemporal(solicitudDetalle);
				String textoHecho = solicitudDetalle.getHdte();
				if (solicitudDetalle != null && solicitudDetalle.getHdte() != null) {
					/*
					 * if (solicitudDetalle.getHdte().length() > 4000) {
					 * textoHecho = solicitudDetalle.getHdte().substring(0,
					 * 4000); }
					 */
					logger.info("add().SolicitudDetalle getHdte." + solicitudDetalle.getHdte() + ".");
					textoHecho = solicitudDetalle.getHdte();
					sanexp.setHdte(textoHecho);
				} else {
					logger.info("add().SolicitudDetalle no tiene Hdte.");
					sanexp.setHdte("");
				}

				sanexpDao.updateHechoDenunciadoOrigen(sanexp);

				CensoMonitor censoMonitor = new CensoMonitor();
				censoMonitor.setMocodigo(sanexp.getExmocodigo());
				/* si existe la fecha de hecho denunciado */
				if (sanexp.getHdfechd() != null) {
					sanbandejaDao.creaAvisoFechaPrescripcion(expedien, censoMonitor,
							Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION);
				}

			} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(expedien.getSanexp().getTipoprocOrigen())
					&& expedien.getSanexp().getExpedienteOrigen() != null) {
				Solarb solarb = new Solarb(expedien.getSanexp().getExpedienteOrigen());
				solarb = this.solarbDao.find(solarb);
				Arbexp arbexp = new Arbexp(expedien.getSanexp().getExpedienteOrigen());
				HechoDenunciado hechodenunciado = new HechoDenunciado();
				if (this.arbexpDao.findAllCount(arbexp) > 0) {
					arbexp = this.arbexpDao.find(arbexp);
					hechodenunciado.setHdte(arbexp.getHdte());
					hechodenunciado.setHdfehd(arbexp.getHdfechd());
				} else {
					if (!Y41bUtils.esNullOCadenaVacia(solarb.getSacohd())) {
						hechodenunciado.setHdcodigo(solarb.getSacohd());
						hechodenunciado = hechodenunciadoDao.find(hechodenunciado);
					}
					// Reclamado
					Essa essa = new Essa();
					essa.setSolarb(solarb);
					List<Essa> lessa = this.essaDao.findAll(essa, null);
					if (lessa != null && lessa.size() > 0) {
						String escodigo = lessa.get(0).getEstablecimiento().getEscodigo();
						expedien.setExcoes(escodigo);
					}
				}

				sanexp.setTipoProc(Y41bConstantes.TIPO_PROC_ARBITRAJE);

				if (hechodenunciado.getHdfehd() != null) {
					sanexp.setHdfechd(hechodenunciado.getHdfehd());
					Date fechaPrescripcion = parametrosDao.devuelvefechaPrescripcion(hechodenunciado.getHdfehd(),
							Y41bConstantes.SAN_CALIFICACION_LEVE);
					sanexp.setExfecprescr(fechaPrescripcion);
					sanexp.setExcalif(Y41bConstantes.SAN_CALIFICACION_LEVE);

					logger.info("add().Arbitraje Hdfehd." + hechodenunciado.getHdfehd() + ".");
				} else {
					logger.info("add().Arbitraje no tiene Hdfehd.");
				}
				/** PRODUCTO */
				if (solarb.getSacops() != null) {
					expedien.setExcops(solarb.getSacops());
					expedienDao.updatePS(expedien);
					sanexp.setProducto(new Producto(solarb.getSacops()));
					logger.info("add().Arbitraje producto." + solarb.getSacops() + ".");

				} else {
					logger.info("add().Arbitraje no tiene Pscodigo.");
				}
				/** MOTIVO */
				if (solarb.getSacotir() != null) {
					sanexp.setMotivo(new Motivo(solarb.getSacotir(), null, null));
					logger.info("add().Arbitraje motivo." + solarb.getSacotir() + ".");
				} else {
					logger.info("add().Arbitraje no tiene Tircodigo.");
				}

				if (hechodenunciado.getHdte() != null) {
					logger.info("add().SolicitudDetalle getHdte." + hechodenunciado.getHdte() + ".");
					sanexp.setHdte(hechodenunciado.getHdte());
				} else {
					logger.info("add().SolicitudDetalle no tiene Hdte.");
					sanexp.setHdte("");
				}

				sanexpDao.updateHechoDenunciadoOrigen(sanexp);
			} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(expedien.getSanexp().getTipoprocOrigen())
					&& expedien.getSanexp().getExpedienteOrigen() != null) {
				Actuacion actuacion = new Actuacion();
				actuacion.setAtcodigo(sanexp.getExpedienteOrigen());

				InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(actuacion, null);
				sanexp.setTipoProc(Y41bConstantes.TIPO_PROC_INSPECCIONES);

				if (inspeccionDetalle != null) {
					logger.info("add().SolicitudDetalle NO ES NULL.");

					if (inspeccionDetalle.getEstablecimientoV() != null && sancionado != null
							&& sancionado.getUanif() != null && sancionado.getUanif()
									.equalsIgnoreCase(inspeccionDetalle.getEstablecimientoV().getNif())) {
						nombreEstablecimiento = inspeccionDetalle.getEstablecimientoV().getNombre();
					} else if (inspeccionDetalle.getEstablecimientoR() != null && sancionado != null
							&& sancionado.getUanif() != null && sancionado.getUanif()
									.equalsIgnoreCase(inspeccionDetalle.getEstablecimientoR().getNif())) {
						nombreEstablecimiento = inspeccionDetalle.getEstablecimientoR().getNombre();
					} else if (inspeccionDetalle.getEstablecimientoV() != null) {
						nombreEstablecimiento = inspeccionDetalle.getEstablecimientoV().getNombre();
					} else {
						nombreEstablecimiento = null;
					}

				}

				/** PRODUCTO */
				if (inspeccionDetalle != null && inspeccionDetalle.getAtcops() != null) {
					expedien.setExcops(inspeccionDetalle.getAtcops());
					expedienDao.updatePS(expedien);
					sanexp.setProducto(new Producto(inspeccionDetalle.getAtcops()));
					logger.info("add().Inspeccion producto." + inspeccionDetalle.getAtcops() + ".");
				} else {
					logger.info("add().Inspeccion no tiene Pscodigo.");
				}

				sanexpDao.updateHechoDenunciadoOrigen(sanexp);

			}
		}
		logger.info("ExpedienteServiceImpl. - Add. He creado avisos en Bandeja. ");

		/*
		 * Añadimos los consumidores de los expediente origen y el sancionado
		 * del expediente origen seleccionado como establecimiento
		 */

		if (!Y41bUtils.esNullOCadenaVacia(expedien.getSanexp().getExcodrel())) {

			Sanexprel sanexprel = new Sanexprel();
			Sanexprel sanexprelsolicitud = new Sanexprel();
			sanexprel.setExpedienByRlexcodigo(expedien);

			String tipoproc = expedien.getSanexp().getTipoprocOrigen();
			StringBuffer solicitudes = new StringBuffer("");
			StringBuffer arbitrajes = new StringBuffer("");
			StringBuffer inspecciones = new StringBuffer("");
			if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc)) {
				solicitudes.append(expedien.getSanexp().getExcodrel());
			} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc)) {
				arbitrajes.append(expedien.getSanexp().getExcodrel());
			} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
				inspecciones.append(expedien.getSanexp().getExcodrel());
			}

			String[] arrayIds = expedien.getSanexp().getExcodrel().split(",");
			String codigo = "";
			TramiteGenerico tramiteGenerico = new TramiteGenerico();
			InfraccHechoDen infraccHechoDen = new InfraccHechoDen();
			InfraccArb infraccArb = new InfraccArb();
			CensoMonitor censoMonitor = new CensoMonitor();
			InfraccHechoDen infrrhechoden = new InfraccHechoDen();
			InfraccHechoDenExpSanc infrrhechodensan = new InfraccHechoDenExpSanc();
			ActaInfraccion actainfraccion = new ActaInfraccion();

			for (int i = 0; i < arrayIds.length; i++) {
				codigo = arrayIds[i];
				if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc)) {
					sanexprel.setRlhdcodrel(codigo);
					sanexprel.setRlexcodrel(null);
					sanexprel.setRlarbcodrel(null);
					sanexprel.setRlinscodrel(null);
				} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc)) {
					sanexprel.setRlhdcodrel(null);
					sanexprel.setRlexcodrel(null);
					sanexprel.setRlarbcodrel(codigo);
					sanexprel.setRlinscodrel(null);
				} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
					sanexprel.setRlhdcodrel(null);
					sanexprel.setRlexcodrel(null);
					sanexprel.setRlarbcodrel(null);
					sanexprel.setRlinscodrel(codigo);
				}
				if (expedien.getSanexp().getExpedienteOrigen() != null
						&& expedien.getSanexp().getExpedienteOrigen().equals(codigo)) {
					sanexprel.setRlesorig(Y41bConstantes.VALOR_SI);
				} else {
					sanexprel.setRlesorig(Y41bConstantes.TIPO_SAN_EXPREL_ACUMULADO);
				}
				this.sanexprelDao.add(sanexprel);

				if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc)) {
					/* CREAMOS LA RELACION EN SOLICITUDES */
					/* codigo de la solicitud */
					sanexprelsolicitud.setRlhdcodigo(codigo);
					/* codigo de la sancion */
					sanexprelsolicitud.setRlexcodrel(expedien.getExcodigo());
					sanexprel.setRlhdcodrel(null);
					sanexprel.setRlinscodrel(null);
					sanexprel.setRlexcodrel(null);
					sanexprelsolicitud.setRlesorig(Y41bConstantes.VALOR_NO);
					this.sanexprelDao.add(sanexprelsolicitud);
				} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc)) {
					/* CREAMOS LA RELACION EN ARBITRAJE */
					/* codigo del arbitraje */
					sanexprelsolicitud.setRlarbcodigo(codigo);
					/* codigo de la sancion */
					sanexprelsolicitud.setRlexcodrel(expedien.getExcodigo());
					sanexprel.setRlhdcodrel(null);
					sanexprel.setRlinscodrel(null);
					sanexprel.setRlexcodrel(null);
					sanexprelsolicitud.setRlesorig(Y41bConstantes.VALOR_NO);
					this.sanexprelDao.add(sanexprelsolicitud);
				} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
					/* CREAMOS LA RELACION EN INSPECCIONES */
					/* codigo der la inspeccion */
					sanexprelsolicitud.setRlinscodigo(codigo);
					/* codigo de la sancion */
					sanexprelsolicitud.setRlexcodrel(expedien.getExcodigo());
					sanexprel.setRlinscodrel(null);
					sanexprel.setRlhdcodrel(null);
					sanexprel.setRlarbcodrel(null);
					sanexprelsolicitud.setRlesorig(Y41bConstantes.VALOR_NO);
					this.sanexprelDao.add(sanexprelsolicitud);
				}

				// Para cada solicitud relacionada aadimos un tramite generico
				// avisando que es origen/acumulado de una sancion
				if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoproc)) {

					tramiteGenerico.setIdExpediente(codigo);
					tramiteGenerico.setFechaInicio(Y41bUtils.hoy());

					censoMonitor.setMocodigo(sanexp.getExmocodigo());
					tramiteGenerico.setInstructorAsignado(censoMonitor);
					tramiteGenerico.setComentario(appMessageSource.getMessage("tramite.aperturaSancionComentario", null,
							LocaleContextHolder.getLocale()) + " ( " + Y41bConstantes.TIPO_PROC_SANCIONES + "-"
							+ expedien.damecodCompleto() + " )");
					String literalNombreTramite = "tramite.aperturaSancion";
					this.soltramexpService.addTramiteGenericoAutomatico(tramiteGenerico, literalNombreTramite);

					/*
					 * Buscamos las infracciones de todos los expedientes
					 * relacionados
					 */
					infraccHechoDen.setHicodigo(null);
					infraccHechoDen.setHicohd(codigo);
					infraccHechoDen.setTipReqNormativo(null);
					infraccHechoDen.setHiinexii(null);
					infraccHechoDen.setHiifid(null);

					List<InfraccHechoDen> listaInfraccionesExpedienteOrig = infraccHechoDenDao.findAll(infraccHechoDen,
							null);
					// -> InfraccHechoDenExpSanc infraccHechoDenExpSanc = null
					if (listaInfraccionesExpedienteOrig != null) {
						for (int j = 0; j < listaInfraccionesExpedienteOrig.size(); j++) {
							infraccHechoDen = listaInfraccionesExpedienteOrig.get(j);
							// Para evitar articulos repetidos
							if (!infraccHechoDenExpSancDao.existeArticuloMateria(expedien.getExcodigo(),
									infraccHechoDen.getTipReqNormativo().getTticodigo())) {
								String hiinexiid = null;
								if (infraccHechoDen.getTipReqNormativo().getTticodigo().indexOf("N0") > -1) {
									// es un articulo
									hiinexiid = "S";
								}
								String hicodigo = Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE);

								infrrhechoden.setHicodigo(hicodigo);
								infrrhechoden.setHicohd(null);
								infrrhechoden.setTipReqNormativo(infraccHechoDen.getTipReqNormativo());
								infrrhechoden.setHiinexii(hiinexiid);
								infrrhechoden.setHiifid(null);
								infraccHechoDenDao.add(infrrhechoden);
								infrrhechodensan.setDxcodigo(hicodigo);
								infrrhechodensan.setDxcoex(expedien.getExcodigo());
								infrrhechodensan.setInfraccHechoDen(infrrhechoden);
								infrrhechodensan.setTipopronunciamento(null);
								infraccHechoDenExpSancDao.add(infrrhechodensan);
							}
						}
					}
				} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoproc)) {
					tramiteGenerico.setIdExpediente(codigo);
					tramiteGenerico.setFechaInicio(Y41bUtils.hoy());
					tramiteGenerico.setInstructorAsignado(censoMonitor);
					tramiteGenerico.setComentario(appMessageSource.getMessage("tramite.aperturaSancionComentario", null,
							LocaleContextHolder.getLocale()) + " ( " + Y41bConstantes.TIPO_PROC_SANCIONES + "-"
							+ expedien.damecodCompleto() + " )");
					tramiteGenerico.setNombreTramite(appMessageSource.getMessage("tramite.aperturaSancion", null,
							LocaleContextHolder.getLocale()));
					TramiteComun tramiteComun = new TramiteComun();
					tramiteComun.setIdExpediente(codigo);
					tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_GENERICO);
					tramiteComun.setTipoProcedimiento(new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ARBITRAJE));
					tramiteComun.setIdTramite(arbtramexpService.getNewPK().toString());
					this.arbtramexp4Service.addTramiteGenerico(tramiteGenerico, tramiteComun, "", false,
							Y41bConstantes.MODO_POPUP_ALTA);

					/*
					 * Buscamos las infracciones de todos los expedientes
					 * relacionados
					 */
					infraccArb.setHicodigo(null);
					infraccArb.setHicoarb(codigo);
					infraccArb.setTipReqNormativo(null);
					infraccArb.setHiinexii(null);
					infraccArb.setHiifid(null);
					List<InfraccArb> listaInfraccionesExpedienteOrig = this.infraccArbDao.findAll(infraccArb, null);
					// -> InfraccHechoDenExpSanc infraccHechoDenExpSanc = null
					if (listaInfraccionesExpedienteOrig != null) {
						for (int j = 0; j < listaInfraccionesExpedienteOrig.size(); j++) {
							infraccArb = listaInfraccionesExpedienteOrig.get(j);
							// Para evitar articulos repetidos
							if (!infraccHechoDenExpSancDao.existeArticuloMateria(expedien.getExcodigo(),
									infraccArb.getTipReqNormativo().getTticodigo())) {
								String hiinexiid = null;
								if (infraccArb.getTipReqNormativo().getTticodigo().indexOf("N0") > -1) {
									// es un articulo
									hiinexiid = "S";
								}
								String hicodigo = Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE);
								infrrhechoden.setHicodigo(hicodigo);
								infrrhechoden.setHicohd(null);
								infrrhechoden.setTipReqNormativo(infraccArb.getTipReqNormativo());
								infrrhechoden.setHiinexii(hiinexiid);
								infrrhechoden.setHiifid(null);
								infraccHechoDenDao.add(infrrhechoden);
								infrrhechodensan.setDxcodigo(hicodigo);
								infrrhechodensan.setDxcoex(expedien.getExcodigo());
								infrrhechodensan.setInfraccHechoDen(infrrhechoden);
								infrrhechodensan.setTipopronunciamento(null);
								infraccHechoDenExpSancDao.add(infrrhechodensan);
							}
						}
					}
				} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
					tramiteGenerico.setIdExpediente(codigo);
					tramiteGenerico.setFechaInicio(Y41bUtils.hoy());
					tramiteGenerico.setInstructorAsignado(censoMonitor);
					tramiteGenerico.setComentario(appMessageSource.getMessage("tramite.aperturaSancionComentario", null,
							LocaleContextHolder.getLocale()) + " ( " + Y41bConstantes.TIPO_PROC_SANCIONES + "-"
							+ expedien.damecodCompleto() + " )");
					String literalNombreTramite = "tramite.aperturaSancion";
					this.instramexpService.addTramiteGenericoAutomatico(tramiteGenerico, literalNombreTramite,
							nombreEstablecimiento);

					/*
					 * Buscamos las infracciones de todos los expedientes
					 * relacionados
					 */
					actainfraccion.setAicoat(codigo);
					List<ActaInfraccion> listaInfraccionesExpedienteOrig = this.actaInfraccionDao
							.findAll(actainfraccion, null);
					// -> InfraccHechoDenExpSanc infraccHechoDenExpSanc =
					// null
					if (listaInfraccionesExpedienteOrig != null) {
						for (int j = 0; j < listaInfraccionesExpedienteOrig.size(); j++) {
							actainfraccion = listaInfraccionesExpedienteOrig.get(j);
							// Para evitar articulos repetidos
							if (!infraccHechoDenExpSancDao.existeArticuloMateria(expedien.getExcodigo(),
									actainfraccion.getAicotti())) {
								String hiinexiid = null;
								if (actainfraccion.getAicotti().indexOf("N0") > -1) {
									// es un articulo
									hiinexiid = "S";
								}
								String hicodigo = Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE);
								infrrhechoden.setHicodigo(hicodigo);
								infrrhechoden.setHicohd(null);
								if (infraccHechoDen.getTipReqNormativo() == null) {
									TipReqNormativo tipReqNormativo = new TipReqNormativo();
									tipReqNormativo.setTticodigo(actainfraccion.getAicotti());
									tipReqNormativo = this.tipReqNormativoDao.find(tipReqNormativo);
									infrrhechoden.setTipReqNormativo(tipReqNormativo);
								} else {
									infrrhechoden.setTipReqNormativo(infraccHechoDen.getTipReqNormativo());
								}
								infrrhechoden.setHiinexii(hiinexiid);
								infrrhechoden.setHiifid(null);
								infraccHechoDenDao.add(infrrhechoden);
								infrrhechodensan.setDxcodigo(hicodigo);
								infrrhechodensan.setDxcoex(expedien.getExcodigo());
								infrrhechodensan.setInfraccHechoDen(infrrhechoden);
								infrrhechodensan.setTipopronunciamento(null);
								infraccHechoDenExpSancDao.add(infrrhechodensan);
							}
						}
					}
				}

				/*
				 * Borramos el expediente de la bandeja de propuesta de sancion
				 */
				Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
				sanpropbandeja.setBaprsanexcodigo(codigo);
				if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoproc)) {
					// FIXME OSCAR En este punto hay dudas acerca de que este
					// presente el dato de establecimiento sancionado
					sanpropbandeja.setBaprsansancionado(expedien.getExcoes());
					sanpropbandejaDao.removeInspecciones(sanpropbandeja);
				} else {
					sanpropbandejaDao.removeSolicitudes(sanpropbandeja);
				}

			}

			// Anyadimos todos los reclamantes como consumidor(origen) de los
			// expediente cuyo
			// tipoproc coincide con el tipo de procedimiento origen
			// el resto como consumidores
			if (!Y41bUtils.esNullOCadenaVacia(solicitudes.toString())
					&& Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(expedien.getSanexp().getTipoprocOrigen())) {
				sanintervDao.aniadirDenunciantes(solicitudes.toString(), expedien.getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO);
			} else {
				sanintervDao.aniadirDenunciantes(solicitudes.toString(), expedien.getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR);
			}
			if (!Y41bUtils.esNullOCadenaVacia(arbitrajes.toString())
					&& Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(expedien.getSanexp().getTipoprocOrigen())) {
				sanintervDao.aniadirDenunciantesArb(arbitrajes.toString(), expedien.getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO);
			} else {
				sanintervDao.aniadirDenunciantesArb(arbitrajes.toString(), expedien.getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR);
			}
			if (!Y41bUtils.esNullOCadenaVacia(inspecciones.toString())
					&& Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(expedien.getSanexp().getTipoprocOrigen())) {
				sanintervDao.aniadirDenunciantes(inspecciones.toString(), expedien.getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO);
			} else {
				sanintervDao.aniadirDenunciantes(inspecciones.toString(), expedien.getExcodigo(),
						Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR);
			}

		}

	}

	/**
	 * Updates a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param censomonitor
	 *            CensoMonitor
	 * @return Expedien
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Expedien update(Expedien expedien, CensoMonitor censomonitor) throws Exception {
		Expedien expedienAntiguo = this.find(expedien);

		String exmocodigo = expedien.getSanexp().getExmocodigo();

		CensoMonitor censoMonitor = new CensoMonitor();
		censoMonitor.setMocodigo(exmocodigo);

		/* si cambia la fecha del hecho o la calificacion */
		if (expedien.getSanexp().getHdfechd() != null && expedien.getSanexp().getExcalif() != null
				&& !(expedien.getSanexp().getHdfechd()).equals(expedienAntiguo.getSanexp().getHdfechd())
				|| expedien.getSanexp().getHdfechd() != null
						&& !(expedien.getSanexp().getExcalif()).equals(expedienAntiguo.getSanexp().getExcalif())) {
			expedien.getSanexp().setExfecprescr(parametrosDao
					.devuelvefechaPrescripcion(expedien.getSanexp().getHdfechd(), expedien.getSanexp().getExcalif()));
			// Solo creamos el aviso si el acuerdo de incoacin no est
			// tramitado
			Santramexp tramiteAcuerdo = new Santramexp();
			tramiteAcuerdo.setExpedien(new Expedien(expedien.getExcodigo()));
			tramiteAcuerdo.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUERDOINCOACION);
			tramiteAcuerdo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			if (this.santramexpDao.findAllCount(tramiteAcuerdo).longValue() == 0L) {
				sanbandejaDao.creaAvisoFechaPrescripcion(expedien, censoMonitor,
						Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION);
			}
			// if (expedien.getSanexp().getExcalif() != null) {
			// if (expedien.getSanexp().getExcalif()
			// .equals(Y41bConstantes.SAN_CALIFICACION_LEVE)) {
			// sanbandejaDao
			// .creaAvisoFechaPrescripcion(
			// expedien,
			// censoMonitor,
			// Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION_LEVE);
			// } else if (expedien.getSanexp().getExcalif()
			// .equals(Y41bConstantes.SAN_CALIFICACION_GRAVE)) {
			// sanbandejaDao
			// .creaAvisoFechaPrescripcion(
			// expedien,
			// censoMonitor,
			// Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION_GRAVE);
			// } else if (expedien.getSanexp().getExcalif()
			// .equals(Y41bConstantes.SAN_CALIFICACION_MUYGRAVE)) {
			// sanbandejaDao
			// .creaAvisoFechaPrescripcion(
			// expedien,
			// censoMonitor,
			// Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION_MUYGRAVE);
			// }
			// }
		} else if (expedien.getSanexp().getHdfechd() == null || expedien.getSanexp().getExcalif() == null) {
			expedien.getSanexp().setExfecprescr(null);
		} else {
			expedien.getSanexp().setExfecprescr(expedienAntiguo.getSanexp().getExfecprescr());
		}
		if (expedien != null && expedien.getSanexp() != null) {
			if ("on".equals(expedien.getSanexp().getExverifsanc())) {
				expedien.getSanexp().setExverifsanc(Y41bConstantes.SI);
			}
			if ("on".equals(expedien.getSanexp().getExverifinco())) {
				expedien.getSanexp().setExverifinco(Y41bConstantes.SI);
			}
		}

		return actualizaExpediente(expedien, censomonitor);
	}

	/**
	 * Finds a single row in the Expedien table.
	 * 
	 * @param filterExpedien
	 *            Expedien
	 * @return Expedien
	 */
	public Expedien find(Expedien filterExpedien) {
		Expedien expedien = this.expedienDao.find(filterExpedien);
		this.anyadirDescriptores(expedien);

		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(expedien.getExcodigo());
		Sanexp sanexpaux = this.sanexpDao.findLobTablaTemporal(sanexp);
		if (sanexpaux != null) {
			expedien.getSanexp().setHdte(sanexpaux.getHdte());
		}
		return expedien;
	}

	/**
	 * anyadirDescriptores
	 * 
	 * @param expedien
	 *            Expedien
	 */
	private void anyadirDescriptores(Expedien expedien) {
		// descriptores
		List<Descriptor> listDescriptor = this.expedienDao.findAllSancionDescriptor(expedien, null);

		StringBuffer strIdsDescriptores = new StringBuffer();
		StringBuffer strDescsDescriptores = new StringBuffer();

		strDescsDescriptores.append("[");

		boolean firstElement = true;

		// se recorre para obtener los ids de etiquetas
		for (Descriptor descriptor : listDescriptor) {
			if (firstElement) {
				strIdsDescriptores.append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(descriptor.getNombre());
				firstElement = false;
			} else {
				strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(",").append(descriptor.getNombre());
			}
		}
		strDescsDescriptores.append("]");

		expedien.setIdsDescriptores(strIdsDescriptores.toString());
		expedien.setDescsDescriptores(strDescsDescriptores.toString());
	}

	/**
	 * Finds a single row in the Expedien table.
	 * 
	 * @param filterExpedien
	 *            Expedien
	 * @return Expedien
	 */
	public Expedien findSancionByNumeroExpediente(Expedien filterExpedien) {
		Expedien expedien = this.expedienDao.findSancionByNumeroExpediente(filterExpedien);
		if (expedien == null) {
			throw new Y41bUDAException("error.sancion.numExpedienteException", true, new Exception());
		}
		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(expedien.getExcodigo());
		Sanexp sanexpaux = this.sanexpDao.findLobTablaTemporal(sanexp);
		if (sanexpaux != null) {
			expedien.getSanexp().setHdte(sanexpaux.getHdte());
		}

		return expedien;
	}

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param filterExpedien
	 *            ExpedienKgest
	 * @return ExpedienKgest
	 */
	public ExpedienKgest findKgest(ExpedienKgest filterExpedien) {

		Expedien expedien2 = new Expedien();
		expedien2.setExcodigo(filterExpedien.getExcodigo());

		ExpedienKgest expedien = (ExpedienKgest) this.expedienDao.findKgest(filterExpedien);
		Saninterv saninterv = new Saninterv();
		saninterv.setUaescodigo(expedien.getExcoes());
		int numeroExpedientesConRecursos = this.expedientesConRecursos(expedien2, saninterv);
		String respuesta = numeroExpedientesConRecursos + "";
		expedien.setEsTieneSentenciasFirmes(respuesta);

		return expedien;

	}

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return List
	 */
	public List<ExpedienKgest> findPronunciamientoActKgest(ExpedienKgest expedien) {
		return (List<ExpedienKgest>) this.expedienDao.findPronunciamientoActKgest(expedien);
	}

	/**
	 * Counts rows in the table.
	 * 
	 * @param expedienKgest
	 *            ExpedienKgest
	 * @return Long
	 */
	public Long findPronunciamientoActKgestCount(ExpedienKgest expedien) {
		return (Long) this.expedienDao.findPronunciamientoActKgestCount(expedien);
	}

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return List
	 */
	public List<ExpedienKgest> findPronunciamientoReclKgest(ExpedienKgest expedien) {
		return (List<ExpedienKgest>) this.expedienDao.findPronunciamientoReclKgest(expedien);
	}

	/**
	 * Counts rows in the table.
	 * 
	 * @param expedienKgest
	 *            ExpedienKgest
	 * @return Long
	 */
	public Long findPronunciamientoReclKgestCount(ExpedienKgest expedien) {
		return (Long) this.expedienDao.findPronunciamientoReclKgestCount(expedien);

	}

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return List
	 */
	public List<ExpedienKgest> findPronunciamientoOtrasKgest(ExpedienKgest expedien) {
		return (List<ExpedienKgest>) this.expedienDao.findPronunciamientoOtrasKgest(expedien);
	}

	/**
	 * Counts rows in the table.
	 * 
	 * @param expedienKgest
	 *            ExpedienKgest
	 * @return Long
	 */
	public Long findPronunciamientoOtrasKgestCount(ExpedienKgest expedien) {
		return (Long) this.expedienDao.findPronunciamientoOtrasKgestCount(expedien);

	}

	/**
	 * Finds a List of rows in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Expedien> findAll(Expedien expedien, Pagination pagination) {
		return (List<Expedien>) this.expedienDao.findAll(expedien, pagination);
	}

	/**
	 * Counts rows in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Long
	 */
	public Long findAllCount(Expedien expedien) {
		return this.expedienDao.findAllCount(expedien);
	}

	/**
	 * Finds rows in the Expedien table using like.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Expedien> findAllLike(Expedien expedien, Pagination pagination, Boolean startsWith) {
		return (List<Expedien>) this.expedienDao.findAllLike(expedien, pagination, startsWith);
	}

	/**
	 * Counts rows in the Expedien table using like.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Expedien expedien, Boolean startsWith) {
		return this.expedienDao.findAllLikeCount(expedien, startsWith);
	}

	/**
	 * Deletes a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Expedien expedien) {
		this.expedienDao.remove(expedien);
	}

	/**
	 * Deletes multiple rows in the Expedien table.
	 * 
	 * @param expedienList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Expedien> expedienList) {
		for (Expedien expedienAux : expedienList) {
			this.expedienDao.remove(expedienAux);
		}
	}

	/**
	 * METODOS DE BUSQUEDA PARA EL FILTRO/BUSQUEDA DE EXPEDIENTES SANCIONADORES
	 */

	/**
	 * Finds a List of rows in the FiltroSanciones table.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Expedien> findAllSanciones(FiltroSanciones filtroSanciones, Pagination pagination) {
		return (List<Expedien>) this.expedienDao.findAllSanciones(filtroSanciones, pagination);
	}

	/**
	 * Counts rows in the FiltroSanciones table.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return Long
	 */
	public Long findAllCountSanciones(FiltroSanciones filtroSanciones) {
		return this.expedienDao.findAllCountSanciones(filtroSanciones);
	}

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<FiltroSanciones> findAllLikeSanciones(FiltroSanciones filtroSanciones, Pagination pagination,
			Boolean startsWith) {

		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("EXCOOR ASC, EXNRAN ASC, CORRELATIVOPAD ");
		}
		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("EXCOOR DESC, EXNRAN DESC, CORRELATIVOPAD ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("exfecfin")) {
			pagination.setSort("SANEXPEXFECFIN ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("esnombre")) {
			pagination.setSort("establESNOMBRE ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("establecimiento.esnombreMunicipio")) {
			pagination.setSort("NOMBRE_MUNICIPIO ");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("fase.fnombre")) {
			pagination.setSort("fasefnombre");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("fase.fnombree")) {
			pagination.setSort("fasefnombree");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("santramexp.trnomtramCompletoes")) {
			pagination.setSort("tramiteTRNOMBRE");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("santramexp.trnomtramCompletoeu")) {
			pagination.setSort("tramiteTRNOMBREE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("censoMonitor.monombre")) {
			pagination.setSort("monitorMONOMBRE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("sanexp.extipres")) {
			pagination.setSort("SanexpEXTIPRES");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("tctipres.ttrnombre")) {
			pagination.setSort("tctipresTTRNOMBRE");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("tctipres.ttrnombreeu")) {
			pagination.setSort("tctipresTTRNOMBREEU");
		}

		return (List<FiltroSanciones>) this.expedienDao.findAllLikeSanciones(filtroSanciones, pagination, startsWith);
	}

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCountSanciones(FiltroSanciones filtroSanciones, Boolean startsWith) {
		return this.expedienDao.findAllLikeCountSanciones(filtroSanciones, startsWith);
	}

	/**
	 * @param expedien
	 *            Expedien
	 * @param censomonitor
	 *            CensoMonitor
	 * @return Expedien
	 */
	private Expedien actualizaExpediente(Expedien expedien, CensoMonitor censomonitor) throws Exception {

		/* actualizamos sanexp */
		Sanexp sanexpModif = expedien.getSanexp();
		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(expedien.getExcodigo());
		sanexp = sanexpDao.find(sanexp);

		sanexp.setExdesces(sanexpModif.getExdesces());
		sanexp.setEximporte(sanexpModif.getEximporte());
		sanexp.setExfecfin(sanexpModif.getExfecfin());
		sanexp.setExfecprescr(sanexpModif.getExfecprescr());
		sanexp.setExcalif(sanexpModif.getExcalif());
		sanexp.setExtipres(sanexpModif.getExtipres());
		sanexp.setExliqestado(sanexpModif.getExliqestado());
		sanexp.setExliqapremio(sanexpModif.getExliqapremio());
		sanexp.setExcaja1(sanexpModif.getExcaja1());
		sanexp.setExcaja2(sanexpModif.getExcaja2());
		sanexp.setHdte(sanexpModif.getHdte());
		sanexp.setHdfechd(sanexpModif.getHdfechd());
		sanexp.setMotivo(sanexpModif.getMotivo());
		sanexp.setExdestnotifsancionado(sanexpModif.getExdestnotifsancionado());
		sanexp.setExverifsanc(sanexpModif.getExverifsanc());
		sanexp.setExverifinco(sanexpModif.getExverifinco());
		sanexp.setExhdformanotiforigen(sanexpModif.getExhdformanotiforigen());
		sanexpDao.update(sanexp);

		/* actualizamos expedien */
		Expedien expediente = new Expedien();
		expediente.setExcodigo(expedien.getExcodigo());

		expediente = this.find(expediente);
		expediente.setExfere(expedien.getExfere());
		expediente.setExferes(expedien.getExferes());
		expediente.setExcops(expedien.getExcops());
		expediente.setExcoes(expedien.getExcoes());

		Expedien exp = this.expedienDao.update(expediente);

		// Actualizar sancionado
		if (Y41bConstantes.VALOR_SI.equals(expedien.getSancionadoCambio())) {
			Saninterv sanintervBD = this.sanintervDao.dameSancionado(expedien.getExcodigo());
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(expedien.getExcoes());
			establecimiento = establecimientoDao.find(establecimiento);

			if (expedien.getUaidinterv() == null) { // Anadir el sancionado
				establecimiento = this.tratamientoAnyadirIntervinienteSancionado(establecimiento);
			}

			if (establecimiento != null) {
				Saninterv sancionado = new Saninterv();
				sancionado.setExpedien(exp);
				sancionado.setUaescodigo(establecimiento.getEscodigo());
				sancionado.setUanombre(establecimiento.getEsnombre());
				sancionado.setUanif(establecimiento.getEsnif());
				sancionado.setUanrtel(establecimiento.getEsnrtel());
				sancionado.setUanrtel2(establecimiento.getEsnrtel2());
				sancionado.setUacoem(establecimiento.getEscoem());
				sancionado.setUaprovId(establecimiento.getEsnoraProvinciaId());
				sancionado.setUamunId(establecimiento.getEsnoraMunicipioId());
				sancionado.setUalocId(establecimiento.getEsnoraLocalidadId());
				sancionado.setUacalleId(establecimiento.getEsnoraCalleId());
				sancionado.setUacpId(establecimiento.getEsnombreCp());
				sancionado.setUaportalId(establecimiento.getEsnoraPortalId());
				sancionado.setUanombrePiso(establecimiento.getEsnombrePiso());
				sancionado.setUadireNocapv(establecimiento.getEsdireccion_nocapv());
				sancionado.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
				// -> sancionado.setUanodir(establecimiento.getEsnodir())
				sancionado.setUanodir(establecimiento.getEsnombrePiso());
				sancionado.setUadireAnt(establecimiento.getEsnodir());
				String pais = "";
				if (Y41bConstantes.SI.equals(establecimiento.getEsextranjero())) {
					pais = establecimiento.getEsnoraPaisId();
				} else {
					pais = Y41bConstantes.COD_PAIS_ESTADO;
				}
				sancionado.setUapaisId(pais);

				sancionado.setUanopeco(establecimiento.getEsnopeco());
				sancionado.setUaurl(establecimiento.getEsteurl());
				sancionado.setUanoco(establecimiento.getEsnoco());

				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEstablecimiento(establecimiento);

				EstablecimSector establecSector = new EstablecimSector();
				Actividad actividad = new Actividad();
				Sector sector = new Sector();
				establecSector.setActividad(actividad);
				establecSector.setSector(sector);

				establecSector = (EstablecimSector) this.establecimSectorDao
						.findSectorEstablecimiento(establecimSector);

				sancionado.setUasecodigo(establecSector.getSector().getSecodigo());
				sancionado.setUasenombre(establecSector.getSector().getSenombre());
				sancionado.setUasenombree(establecSector.getSector().getSenombree());
				sancionado.setUafecultmod(establecimiento.getEsfemod());
				sancionado.setUausuultmod(establecimiento.getCensoMonitor().getMocodigo());
				sancionado.setUaidioma(expedien.getDenunciado().getUaidioma());

				if (expedien.getUaidinterv() == null) { // Anadir el sancionado
					sanintervDao.add(sancionado);
					this.sanexpDao.updateEXIDPARTICIPACIONSANCIONADO(sancionado, expedien.getExcodigo());
				} else { // Actualizar el sancionado
					sancionado.setUaidinterv(expedien.getUaidinterv());
					sanintervDao.update(sancionado);
				}
				if (Y41bUtils.interactuarConDokusi()) {
					if (Y41bConstantes.VALOR_SI.equals(sanexp.getPlatea())) {
						if (sanintervBD.getUanif().equals(establecimiento.getEsnif())
								|| (!Y41bUtils.isValidCIF(sanintervBD.getUanif())
										&& !Y41bUtils.isValidNIF(sanintervBD.getUanif()))) {
							this.actualizarExpedientePlatea(expedien, sancionado, censomonitor);
						} else {
							throw new Y41bUDAException("error.platea.actualizarTitular", true, null);
						}
					}
				}
			}

		}
		// Actualizamos la forma de notificar al sancionado en el expediente
		sanintervDao.updateFormaNotificacion(expedien.getExcodigo(), expedien.getExcoes(),
				expedien.getFormanotificacion());

		// Actualizamos los descriptores
		this.updateDescriptores(expedien);
		exp.setIdsDescriptores(expedien.getIdsDescriptores());

		return exp;
	}

	/**
	 * updateDescriptores
	 * 
	 * @param expedien
	 *            Expedien
	 */
	private void updateDescriptores(Expedien expedien) {
		// descriptores
		String idsDescriptores = expedien.getIdsDescriptores();

		List<Descriptor> descriptores = new ArrayList<Descriptor>();

		// Generar el listado listado de etiquetas (comun)
		if (null != idsDescriptores && !"".equals(idsDescriptores)) {
			Descriptor descriptor = null;
			for (String id : idsDescriptores.split(",")) {
				descriptor = new Descriptor();
				descriptor.setIdDescriptor(id);
				descriptores.add(descriptor);
			}
		}

		expedien.setDescriptores(descriptores);

		this.expedienDao.removeAllSancionDescriptor(expedien);
		this.expedienDao.addSancionDescriptor(expedien);
	}

	/**
	 * @param expedien
	 * @return
	 */
	private Expedien actualizaExpedienteCambioInstructor(Expedien expedien) {

		/* actualizamos sanexp */
		Sanexp sanexpModif = expedien.getSanexp();

		logger.debug("ACTUALIZAMOS INSTRUCTOR EXPEDIENTE EXMOCODIGO. " + sanexpModif.getExmocodigo() + ".");
		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(expedien.getExcodigo());
		sanexp.setExmocodigo(sanexpModif.getExmocodigo());
		sanexp.setExcooractual(sanexpModif.getExcooractual());
		sanexpDao.updateInstructorOficina(sanexp);

		/* actualizamos expedien */
		Expedien expediente = new Expedien();
		expediente.setExcodigo(expedien.getExcodigo());

		logger.debug("ACTUALIZAMOS INSTRUCTOR EXPEDIENTE EXCOIT. " + expedien.getExcoit() + ".");

		expediente.setExcoit(expedien.getExcoit());

		return this.expedienDao.updateInstructor(expediente);
	}

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<FiltroSanciones> findAllSancionesRelacionar(FiltroSanciones filtroSanciones, String excodigo,
			String relacionados, Pagination pagination) {

		if (pagination.getSort() != null && pagination.getSort().equals("censoMonitor.monombre")) {
			pagination.setSort("monitorMONOMBRE ");
		}

		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("EXCOOR ASC,  CORRELATIVOPAD ASC, EXNRAN  ");
		}
		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("EXCOOR DESC,  CORRELATIVOPAD DESC, EXNRAN ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("sanexp.hdfechd")) {
			pagination.setSort(" sanexpHDFECHD ");
		}
		return (List<FiltroSanciones>) this.expedienDao.findAllSancionesRelacionar(filtroSanciones, excodigo,
				relacionados, pagination);
	}

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllCountSancionesRelacionar(FiltroSanciones filtroSanciones, String excodigo, String relacionados) {
		return this.expedienDao.findAllCountSancionesRelacionar(filtroSanciones, excodigo, relacionados);
	}

	/**
	 * Updates a single row in the Expedien table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor) throws Exception {

		// Actualizar la tabla de expediente sancionador
		Expedien expDetalle = new Expedien();
		expDetalle.setExcodigo(solicitudCambioInstructor.getIdExpediente());
		expDetalle.setSanexp(new Sanexp());

		String codOrg = solicitudCambioInstructor.getOrganismo().getCodOrg();
		String codInstr = solicitudCambioInstructor.getInstructorNuevo().getMocodigo();
		if (Y41bUtils.esNullOCadenaVacia(codInstr)) {
			// Por Javascript se controla que slo sea nulo si cambio de oficina
			// se lo asignamos al coordinador de la oficina seleccionada
			CensoMonitor censomonitor = new CensoMonitor();
			censomonitor.setOrganismo(solicitudCambioInstructor.getOrganismo());
			censomonitor.setPerfilSanciones(new Perfil(Y41bConstantes.PERFIL_COORDINADOR, null, null));
			// No dado de baja
			censomonitor.setMofecbajaDesde(Y41bUtils.formatearDateToString(Y41bUtils.obtenerFechaHoy(), "yyyyMMdd"));
			List<CensoMonitor> censomonitorList = censoMonitorDao.findAll(censomonitor, null);
			if (censomonitorList != null && censomonitorList.size() > 0) {
				censomonitor = censomonitorList.get(0);
				codInstr = censomonitor.getMocodigo();
			}
		}
		expDetalle.getSanexp().setExcooractual(codOrg);
		expDetalle.setExcoit(codInstr);
		expDetalle.getSanexp().setExmocodigo(codInstr);
		this.actualizaExpedienteCambioInstructor(expDetalle);

		CensoMonitor censoMonitor = new CensoMonitor(codInstr, null);
		// buscar tramites con estado "En Tramitacion" en santramexp y modificar
		// el usuario asignado
		Santramexp santramexp = new Santramexp();
		santramexp.setExpedien(new Expedien(solicitudCambioInstructor.getIdExpediente()));
		santramexp.setCensoMonitor(censoMonitor);
		this.santramexpDao.updateCensoMonitorNoTramitados(santramexp);

		// Tratar la bandeja de sanciones (con estado "En Tramitacion")
		Sanbandeja sanbandeja = new Sanbandeja();
		sanbandeja.setExpedien(new Expedien(solicitudCambioInstructor.getIdExpediente()));
		sanbandeja.setMonitor(censoMonitor);
		this.sanbandejaDao.updateCensoMonitorNoTramitados(sanbandeja);

	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateTrasvaseTotalCambioInstructor(SolicitudCambioInstructor solicitudCambioInstructor)
			throws Exception {

		// Actualizar la tabla de expediente sancionador
		String codInstrAnterior = solicitudCambioInstructor.getInstructorActual().getMocodigo();
		String codOrg = solicitudCambioInstructor.getOrganismo().getCodOrg();
		// buscar todos los expedientes sancionadores abiertos del instructor
		// origen
		Sanexp filtroSanciones = new Sanexp();
		filtroSanciones.setExmocodigo(codInstrAnterior);
		filtroSanciones.setExcoor(codOrg);
		filtroSanciones.setExfecfin(new Date());
		List<Sanexp> listSancionesBusqueda = sanexpDao.findAllExcodigo(filtroSanciones, null);
		SolicitudCambioInstructor solicitudCambioInstructorExpdte = new SolicitudCambioInstructor();

		// por cada expediente sancionador abierto, cambiar el instructor
		for (Sanexp sancion : listSancionesBusqueda) {
			solicitudCambioInstructorExpdte.setIdExpediente(sancion.getExcodigo());
			solicitudCambioInstructorExpdte.setInstructorActual(solicitudCambioInstructor.getInstructorActual());
			solicitudCambioInstructorExpdte.setInstructorNuevo(solicitudCambioInstructor.getInstructorNuevo());
			solicitudCambioInstructorExpdte.setOrganismo(solicitudCambioInstructor.getOrganismo());
			try {
				updateCambioInstructor(solicitudCambioInstructorExpdte);
			} catch (Exception e) {
				e.printStackTrace();
				logger.error("Error producido en updateTrasvaseTotalCambioInstructor: " + e.getMessage(), e);
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	}

	/**
	 * Finds a List of rows in the Expedien table.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<FiltroSanciones> findAllLikeSancionesBusquedaCombinada(FiltroSanciones filtroSanciones,
			Pagination pagination, Boolean startsWith) {

		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("EXCOOR ASC,  CORRELATIVOPAD ASC, EXNRAN  ");
		}
		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("EXCOOR DESC,  CORRELATIVOPAD DESC, EXNRAN ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("exfecfin")) {
			pagination.setSort("SANEXPEXFECFIN ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("esnombre")) {
			pagination.setSort("establESNOMBRE ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("establecimiento.esnombreMunicipio")) {
			pagination.setSort("NOMBRE_MUNICIPIO ");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("fase.fnombre")) {
			pagination.setSort("fasefnombre");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("fase.fnombree")) {
			pagination.setSort("fasefnombree");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("santramexp.trnomtramCompletoes")) {
			pagination.setSort("tramiteTRNOMBRE");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("santramexp.trnomtramCompletoeu")) {
			pagination.setSort("tramiteTRNOMBREE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("censoMonitor.monombre")) {
			pagination.setSort("monitorMONOMBRE");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("tctipres.ttrnombre")) {
			pagination.setSort("tctipresttrnombre");
		}

		if (pagination.getSort() != null && pagination.getSort().equals("tctipres.ttrnombreeu")) {
			pagination.setSort("tctipresttrnombreeu");
		}

		return (List<FiltroSanciones>) this.expedienDao.findAllLikeSancionesCombinada(filtroSanciones, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Expedien table.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSancionesBusquedaCombinadaCount(FiltroSanciones filtroSanciones, Boolean startsWith) {
		return this.expedienDao.findAllLikeSancionesBusquedaCombinadaCount(filtroSanciones, startsWith);

	}

	/**
	 * @param expedien
	 * @return
	 */
	public Expedien obtenerEstadoLiquidacion(Expedien expedien) {

		// Si no hay liquidacion mostraremos "Sin liquidacion"
		Santramexp santramexp = new Santramexp();
		santramexp.setExpedien(new Expedien(expedien.getExcodigo()));
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION);
		santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		long numLiquidaciones = santramexpDao.findAllCount(santramexp).longValue();
		if (numLiquidaciones == 0) {
			expedien.getSanexp().setExliqestado("");
			expedien.getSanexp().setExliqapremio("");
		} else {
			FiltroSanciones filtroSanciones = new FiltroSanciones();
			filtroSanciones.setExcodigo(expedien.getExcodigo());
			filtroSanciones = (FiltroSanciones) this.expedienDao.obtenerDatosEstadoLiquidacion(filtroSanciones);

			BigDecimal importePendiente = null;
			if (filtroSanciones != null) {
				if (filtroSanciones.getImportePendiente() != null && filtroSanciones.getExcamure() != null) {
					importePendiente = new BigDecimal(
							filtroSanciones.getImportePendiente().replaceAll("\\.", "").replace(",", "."));
					BigDecimal importePagado = filtroSanciones.getExcamure().subtract(new BigDecimal(
							filtroSanciones.getImportePendiente().replaceAll("\\.", "").replace(",", ".")));
					expedien.getSanexp().setImportePagado(Y41bUtils.formatearAEuros(importePagado));
					if (importePendiente.doubleValue() < filtroSanciones.getExcamure().doubleValue()
							&& importePendiente.doubleValue() > 0) {
						expedien.getSanexp().setExliqestado(Y41bConstantes.SAN_LIQUIDACION_PAGADOPARCIALMENTE);
					} else if (importePendiente.doubleValue() > 0) {
						// Comprobamos si hay alguna liquidacin en estado
						// impagado
						Pagos pagos = new Pagos();
						pagos.setSgidexpediente(expedien.getExcodigo());
						pagos.setEstadopago(new Estadopago(Y41bConstantes.ESTADO_PAGO_IMPAGADO, null, null));
						if (this.pagosDao.findAllCount(pagos).longValue() > 0L) {
							expedien.getSanexp().setExliqestado(Y41bConstantes.SAN_LIQUIDACION_NOPAGADO);
						} else {
							pagos.setEstadopago(
									new Estadopago(Y41bConstantes.ESTADO_PAGO_ANULADO_VENCIMIENTO, null, null));
							if (this.pagosDao.findAllCount(pagos).longValue() > 0L) {
								expedien.getSanexp().setExliqestado(Y41bConstantes.SAN_LIQUIDACION_NOPAGADO);
							} else {
								expedien.getSanexp().setExliqestado(Y41bConstantes.ESTADO_PAGO_PENDIENTE_PAGO);
							}
						}
					} else if (filtroSanciones.getExcamure().doubleValue() == 0
							&& importePendiente.doubleValue() == 0) {
						expedien.getSanexp().setExliqestado(Y41bConstantes.ESTADO_PAGO_PENDIENTE_PAGO);
					} else {
						expedien.getSanexp().setExliqestado(Y41bConstantes.SAN_LIQUIDACION_PAGADO);
					}
				} else {
					expedien.getSanexp().setExliqestado("");
				}
			} else {
				expedien.getSanexp().setExliqestado("");
			}
		}
		return expedien;
	}

	/**
	 * Expedientes con recursos.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param saninterv
	 *            the saninterv
	 * @return the list
	 */
	public int expedientesConRecursos(Expedien expedien, Saninterv saninterv) {
		return this.expedienDao.expedientesConRecursos(expedien, saninterv);
	}

	/**
	 * Expedientes con recursos.
	 * 
	 * @param expedien
	 *            the expedien
	 * @return the list
	 */
	public List<Expedien> listExpedientesConRecursos(Expedien expedien, Saninterv saninterv, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("sanexp.eximporte")) {
				pagination.setSort(" T2.EXIMPORTE ");
			}
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("sanexp.eximporte")) {
				pagination.setSort(" T2.EXIMPORTE ");
			}
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("codCompleto")) {
				pagination.setSort("T1.EXCOOR ASC,  CORRELATIVOPAD ASC, T1.EXNRAN  ");
			}
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("codCompleto")) {
				pagination.setSort("T1.EXCOOR DESC,  CORRELATIVOPAD DESC, T1.EXNRAN  ");
			}

		}

		List<Expedien> expedientes = this.expedienDao.listExpedientesConRecursos(expedien, saninterv, pagination);
		if (expedientes != null) {
			Expedien expedienAux = null;
			Recurso recurso = new Recurso();
			List<InfraccHechoDen> articulos = new ArrayList<InfraccHechoDen>();
			List<InfraccHechoDen> materias = new ArrayList<InfraccHechoDen>();
			for (int i = 0; i < expedientes.size(); i++) {

				expedienAux = expedientes.get(i);
				recurso.setExpedien(expedienAux);
				List<Recurso> recursos = recursoDao.findAll(recurso, null);
				if (recursos != null && recursos.size() > 0) {
					recurso = recursos.get(0);
					expedienAux.setRecurso(recurso);
				}

				List<InfraccHechoDen> lista = infraccHechoDenService.findArticulosMaterias(expedienAux.getExcodigo(),
						null);
				articulos.clear();
				materias.clear();
				if (lista != null) {
					for (int j = 0; j < lista.size(); j++) {
						InfraccHechoDen elemento = (InfraccHechoDen) lista.get(j);
						if (elemento != null && elemento.getTipReqNormativo() != null) {
							if (Y41bConstantes.TIPO_INFRACCION_SANCIONES_MATERIA.equals(elemento.getTipo())) {
								// if (materias.length() > 0) {
								// materias.append(", ");
								// }
								// materias.append(elemento.getTipReqNormativo()
								// .getTtinombre());
								// materiasEu.append(elemento.getTipReqNormativo()
								// .getTtinombree());
								materias.add(elemento);
							} else {
								// if (articulos.length() > 0) {
								// articulos.append(", ");
								// }
								// articulos.append(elemento.getTipReqNormativo()
								// .getTtinombre());
								// articulosEu.append(elemento.getTipReqNormativo()
								// .getTtinombree());
								articulos.add(elemento);
							}
						}
					}
				}
				expedienAux.setArticulos(articulos);
				expedienAux.setMaterias(materias);
			}

		}
		return expedientes;
	}

	// /**
	// * Actualiza el documento en BBDD despues de insertar el localizador.
	// *
	// * @param documentohecho
	// * DocumentoHecho
	// * @return Long
	// * @throws Exception
	// * Exception
	// */
	// @Transactional(rollbackFor = Throwable.class)
	// public Long actualizarDocumentoLocalizadorBBDD(Sandoctemp documentoU5)
	// throws Exception {
	//
	// try {
	// int numRowsUpdated = 0;
	// Documento docDokusi = null;
	// List<Sandoctemp> listaDocumentos = this.sandoctempdao.findAll(
	// documentoU5, null);
	// if (listaDocumentos != null && listaDocumentos.size() > 0) {
	//
	// Documento documento = new Documento();
	// User user = new User();
	// user.setNombre(Y41bConstantes.COD_APLICACION);
	// user.setDni(Y41bConstantes.COD_APLICACION);
	// documento.setUser(user);
	// Procedure procedure = new Procedure();
	// procedure
	// .setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
	// documento.setProcedure(procedure);
	// documento.setOidDokusi(documentoU5.getU5iddocumentum());
	//
	// docDokusi = y41bDokusiAdapterService
	// .descargarDocumentoDokusi(documento);
	//
	// Sandoctemp documentohechoAux = new Sandoctemp();
	// documentohechoAux.setU5nofile(docDokusi.getNombre());
	// documentohechoAux.setU5iddocumentum(documentoU5
	// .getU5iddocumentum());
	// documentohechoAux.setU5sizefile((int) docDokusi.getLength());
	// Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi
	// .getBytes()));
	// documentohechoAux.setU5datafile(blob);
	// documentohechoAux.setU5conttype(docDokusi.getContentType());
	//
	// numRowsUpdated = this.sandoctempdao
	// .updateSanDocTemp(documentohechoAux);
	//
	// this.adjuntardocsDao.updateSanDocTemp(documentohechoAux);
	//
	// logger.debug("###################################ExpedienServiceImpl.actualizarDocumentoLocalizadorBBDD
	// DOID: ["
	// + listaDocumentos.get(0).getU5codocumento() + "]");
	//
	// }
	// logger.debug("###################################ExpedienServiceImpl.actualizarDocumentoLocalizadorBBDD
	// numRowsUpdated ["
	// + numRowsUpdated + "]");
	//
	// if (numRowsUpdated == 1) {
	// BandejaFirma bandejafirma = new BandejaFirma();
	// bandejafirma.setNofile(docDokusi.getNombre());
	// bandejafirma.setIddocumentum(documentoU5.getU5iddocumentum());
	// this.bandejaFirmaDao.updateDocumentoBandejaFirma(bandejafirma);
	// return new Long(1);
	// } else {
	// return new Long(0);
	// }
	// } catch (Exception e) {
	// return new Long(0);
	// }
	// }

	/**
	 * Method 'getCreateFormDetalleConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            the desde
	 * @param accesoPest2
	 *            the acceso pest2
	 * @param excodigo
	 *            String
	 * @param httpRequest
	 *            the http request
	 * @return String
	 */
	public ModelAndView getFichaExpedienteSanciones(Model model, String desde, String accesoPest2,
			@PathVariable String excodigo, HttpServletRequest httpRequest) {
		return this.getFichaExpedienteSanciones(model, desde, accesoPest2, false, excodigo, httpRequest);
	}

	/**
	 * Method 'getCreateFormDetalleConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            the desde
	 * @param accesoPest2
	 *            the acceso pest2
	 * @param sinCabecera
	 *            boolean
	 * @param excodigo
	 *            String
	 * @param httpRequest
	 *            the http request
	 * @return String
	 */
	public ModelAndView getFichaExpedienteSanciones(Model model, String desde, String accesoPest2, boolean sinCabecera,
			@PathVariable String excodigo, HttpServletRequest httpRequest) {

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		model.addAttribute("accesoPest2", accesoPest2);

		Expedien expedien = new Expedien();
		expedien.setExcodigo(excodigo);
		expedien = this.expedienDao.find(expedien);

		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(excodigo);
		sanexp = this.sanexpService.find(sanexp);

		if (sanexp != null) {
			Sanexp sanexpaux = this.sanexpDao.findLobTablaTemporal(sanexp);
			if (sanexpaux != null) {
				sanexp.setHdte(sanexpaux.getHdte());
				expedien.getSanexp().setHdte(sanexpaux.getHdte());
			}
			model.addAttribute("idOrganismo", sanexp.getExcooractual());
		} else {
			model.addAttribute("idOrganismo", expedien.getExcoor());
		}

		model.addAttribute("exCodigo", excodigo);

		httpRequest.getSession().setAttribute(Y41bConstantes.SESSION_NUMEXP, excodigo);

		httpRequest.getSession().setAttribute(Y41bConstantes.CTE_TIPO_PROC, Y41bConstantes.TIPO_PROC_SANCIONES);

		httpRequest.getSession().setAttribute("desde", desde);

		model.addAttribute("codCompleto", expedien.damecodCompleto());
		model.addAttribute(Y41bConstantes.CTE_TIPO_PROC, Y41bConstantes.TIPO_PROC_SANCIONES);

		try {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(expedien.getExcodigo());
			this.denunciaService.actualizarDocumentosLocalizados(solicitudDetalle);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

		if (!sinCabecera) {
			if (null == sanexp) {
				return new ModelAndView("fichaExpedienteHistoricoSancion", "model", model);
			} else {
				return new ModelAndView("fichaExpedienteSancion", "model", model);
			}
		} else {
			if (null == sanexp) {
				return new ModelAndView("fichaExpedienteHistoricoSancionSinCabecera", "model", model);
			} else {
				return new ModelAndView("fichaExpedienteSancionSinCabecera", "model", model);
			}
		}

	}

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<FiltroSanciones> findAllSancionesViaApremio(FiltroSanciones filtroSanciones, Pagination pagination) {

		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("EXCOOR ASC,  CORRELATIVOPAD ASC, EXNRAN  ");
		}
		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("codCompleto")) {
			pagination.setSort("EXCOOR DESC,  CORRELATIVOPAD DESC, EXNRAN ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("establecimiento.esnombre")) {
			pagination.setSort("UANOMBRE ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("establecimiento.esnif")) {
			pagination.setSort("UANIF ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("fechaEnvioReso")) {
			pagination.setSort("RESOLUCIONENFECENVIO ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("fechaNotiReso")) {
			pagination.setSort("RESOLUCIONENFECACUSE ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("fechaPresentacionRA")) {
			pagination.setSort("RECURSOALZADAFECENVIO ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("fechaNotiRA")) {
			pagination.setSort("ORDENCONSEJEROENFECACUSE ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("sinLiqFirme")) {
			pagination.setSort("SINLIQFIRME ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("resolucionRA")) {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			if (Y41bConstantes.EUSKERA.equals(idioma)) {
				pagination.setSort("ORDENCONSEJERODENOMBREE ");
			} else {
				pagination.setSort("ORDENCONSEJERODENOMBRE ");
			}
		}
		List<FiltroSanciones> listaSanciones = (List<FiltroSanciones>) this.expedienDao
				.findAllSancionesViaApremio(filtroSanciones, pagination);
		boolean hayLiquidacionPE = false;
		boolean hayLiquidacionFP = false;
		FiltroSanciones sanciones = null;
		Pagos pagos = new Pagos();
		Estadopago estadopago = new Estadopago();
		for (int i = 0; i < listaSanciones.size(); i++) {
			sanciones = listaSanciones.get(i);
			pagos.setSgidexpediente(sanciones.getExcodigo());
			estadopago.setSacodigo(Y41bConstantes.ESTADO_PAGO_PENDIENTE_ENVIO);
			pagos.setEstadopago(estadopago);
			hayLiquidacionPE = pagosDao.findAllCount(pagos) > 0;
			estadopago.setSacodigo(Y41bConstantes.ESTADO_PAGO_SOLICITUD_FRACCIONAMIENTO);
			pagos.setEstadopago(estadopago);
			hayLiquidacionFP = pagosDao.findAllCount(pagos) > 0;
			sanciones.setHayLiquidacionesPE(hayLiquidacionPE || hayLiquidacionFP);
		}
		return listaSanciones;
	}

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones Boolean
	 * @return Long
	 */
	public Long findAllCountSancionesViaApremio(FiltroSanciones filtroSanciones) {
		return this.expedienDao.findAllCountSancionesViaApremio(filtroSanciones);
	}

	/**
	 * Actualizar expediente
	 * 
	 * @param expedien
	 *            Expedien
	 * @param saninterv
	 *            Saninterv
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	public void actualizarExpedientePlatea(Expedien expedien, Saninterv saninterv, CensoMonitor censoMonitor) {

		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(expedien.getExcodigo());

		sanexp = this.sanexpDao.find(sanexp);

		// actualizar expediente
		ActualizarExpediente actualizarExpediente = new ActualizarExpediente();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
		actualizarExpediente.setProcedure(procedure);

		// Sancionado
		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(saninterv.getUanif().trim());
		datosPersona.setNombre(saninterv.getUanombre());

		if (Y41bUtils.isFilled(saninterv.getUaapellido1())) {
			datosPersona.setApellido1(new StringBuffer(saninterv.getUaapellido1()).toString());

			if (Y41bUtils.isFilled(saninterv.getUaapellido2())) {
				datosPersona.setApellido1(new StringBuffer(saninterv.getUaapellido1()).append(" ")
						.append(saninterv.getUaapellido2()).toString());
			}
		}

		datosPersona.setMail(saninterv.getUacoem());
		datosPersona.setTelefono(saninterv.getUanrtel());

		// En actualizarExpediente el solicitante es el titular, en nuestro caso
		// el sancionado
		actualizarExpediente.setSolicitante(datosPersona);
		actualizarExpediente.setIdParticipacion(sanexp.getExidparticipacionsancionado());

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_SANCIONES).append("-").append(expedien.getExcoor()).append("-")
				.append(expedien.getExnror()).append("-").append(expedien.getExnran());

		actualizarExpediente.setEjercicio(expedien.getExnran().toString());

		actualizarExpediente.setNumeroExpediente(numeroExpediente.toString());

		actualizarExpediente.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		DatosPersona sender = new DatosPersona();
		sender.setDni(censoMonitor.getModni());
		sender.setNombre(censoMonitor.getMonombre());
		actualizarExpediente.setSender(sender);

		DatosRegistro datosRegistro = new DatosRegistro();
		try {
			datosRegistro.setRegistryNumber(
					Y41bUtils.formatearDateToString(expedien.getExfere(), Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
			datosRegistro.setRegistryTimestamp(
					Y41bUtils.formatearDateToString(expedien.getExfere(), Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
		} catch (Exception e) {
		}

		actualizarExpediente.setDatosRegistro(datosRegistro);

		Calendar cal = Calendar.getInstance();
		try {
			if (expedien != null && expedien.getExfere() != null) {
				cal.setTime(expedien.getExfere());
			} else {
				cal.setTime(new Date());
			}
			actualizarExpediente.setStartTimestamp(cal);
		} catch (Exception e) {
			e.printStackTrace();
			ExpedienServiceImpl.logger.error("Error producido al realizar el setTime sobre Calendar con valor "
					+ expedien.getExfere() + e.getMessage(), e);
		}

		// Tramites Expediente
		// Buscar tramite de registro de apertura y sus documentos (en principio
		// no tiene)
		Santramexp santramexp = new Santramexp();
		santramexp.setExpedien(expedien);
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_APERTURA);
		try {
			santramexp = this.santramexpDao.findUltimoTramiteExpedientePorTipoTramite(santramexp);
		} catch (Exception e) {
		}

		List<Proceedings> listProceedings = new ArrayList<Proceedings>();

		Proceedings proceedings = new Proceedings();
		proceedings.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);
		proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APERTURA_OFICIO_ES);
		proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APERTURA_OFICIO_EU);
		cal = Calendar.getInstance();
		cal.setTime(santramexp.getTrfecfin());
		proceedings.setTimestamp(cal);
		listProceedings.add(proceedings);

		// buscar los tramites de aportacin de documentacin
		santramexp = new Santramexp();
		santramexp.setExpedien(new Expedien(expedien.getExcodigo()));
		santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION);
		List<Santramexp> listTramiteExpediente = this.santramexpDao.findAll(santramexp, null);
		if (listTramiteExpediente != null && listTramiteExpediente.size() > 0) {
			TramiteComun tramiteComunAux = new TramiteComun();
			Documento documento = new Documento();
			ArrayList<Documento> documentos = new ArrayList<Documento>();
			for (int i = 0; i < listTramiteExpediente.size(); i++) {
				santramexp = listTramiteExpediente.get(i);

				tramiteComunAux.setIdTramite(santramexp.getTrid().toString());
				List<Sandoctemp> listDocumentosAporta = this.sandoctempdao.findAllDocumentosTramite(tramiteComunAux,
						null);
				if (listDocumentosAporta != null && listDocumentosAporta.size() > 0) {
					Sandoctemp sandoctemp = null;
					boolean aportadoReclamado = false;
					for (int j = 0; j < listDocumentosAporta.size(); j++) {
						sandoctemp = listDocumentosAporta.get(j);
						if (sandoctemp.getU5origen() != null
								&& (sandoctemp.getU5origen().equals(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO)
										|| sandoctemp.getU5origen()
												.equals(Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO))
								&& sandoctemp.getU5iddocumentum() != null && !sandoctemp.getU5iddocumentum().equals("")
								&& sandoctemp.getU5numregistroentrada() != null
								&& sandoctemp.getU5numregistroentrada().contains("RTE")) {
							aportadoReclamado = true;
							break;
						}
					}
					if (aportadoReclamado) {
						proceedings.setProceedingsID(this.expedienDao.getNewEsperaPK().toString());
						proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
						proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);
						cal = Calendar.getInstance();
						cal.setTime(santramexp.getTrfecfin());
						proceedings.setTimestamp(cal);

						documentos.clear();
						if (listDocumentosAporta != null && listDocumentosAporta.size() > 0) {
							for (int k = 0; k < listDocumentosAporta.size(); k++) {
								sandoctemp = listDocumentosAporta.get(k);

								if (sandoctemp.getU5iddocumentum() != null
										&& !sandoctemp.getU5iddocumentum().equals("")) {
									documento.setOidDokusi(sandoctemp.getU5iddocumentum());
									documento.setNombre(sandoctemp.getU5nofile());
									documento.setDescripcion(sandoctemp.getU5tedesfile());
									documentos.add(documento);
								}
							}
						}

						proceedings.setDocumentos(documentos);

						listProceedings.add(proceedings);

					}
				}
			}
		}
		actualizarExpediente.setProceedings(listProceedings);

		this.y41bPlateaAdapterService.actualizarExpediente(actualizarExpediente);
	}

	/**
	 * Finds a List of rows in the SancionDescriptor table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllSancionDescriptor(Expedien expedien, Pagination pagination) {
		return (List<Descriptor>) this.expedienDao.findAllSancionDescriptor(expedien, pagination);
	}

	private Establecimiento tratamientoAnyadirIntervinienteSancionado(Establecimiento establecimiento) {
		// Cuando se vaya a aadir un sancionado a un expediente, se mirar
		// el nuevo campo identificacin. Si tiene valor 1 (CIF), se insertara
		// en el expediente como ahora utilizando el CIF del establecimiento. Si
		// tiene valor 2 (Otros), se mira si el campo CIF est relleno, si est
		// relleno se insertar el establecimiento con ese CIF, si no est
		// relleno el campo CIF, se utilizar como CIF la clave de BBDD de ese
		// establecimiento (ESCODIGO), que es un campo nico.
		if (establecimiento != null && establecimiento.getEstipid() != null
				&& establecimiento.getEstipid().equals(Y41bConstantes.OTROS)) {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		} else {
			if (!Y41bUtils.isFilled(establecimiento.getEsnif())) {
				establecimiento.setEsnif(establecimiento.getEscodigo());
			}
		}

		return establecimiento;
	}

}
