/*
 * 
 */
package com.ejie.y41b.service;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.ui.Model;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.ExpedienKgest;
import com.ejie.y41b.model.FiltroSanciones;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.SolicitudCambioInstructor;

/**
 * ExpedienService  
 * 
 *  
 */

public interface ExpedienService {

	/**
	 * Inserts a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Expedien
	 * @throws Exception
	 *             Exception
	 */
	Expedien add(Expedien expedien) throws Exception;

	/**
	 * Inserts a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param baprsanid
	 *            Long
	 * @return Expedien
	 * @throws Exception
	 *             Exception
	 */
	Expedien add(Expedien expedien, Long baprsanid) throws Exception;

	/**
	 * 
	 * @param expedien
	 *            Expedien
	 * @param actualizarHecho
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	void acumular(Expedien expedien, String actualizarHecho) throws Exception;

	/**
	 * Updates a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param censomonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             Exception
	 * @return Expedien
	 */
	Expedien update(Expedien expedien, CensoMonitor censomonitor)
			throws Exception;

	/**
	 * Finds a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Expedien
	 */
	Expedien find(Expedien expedien);

	/**
	 * Finds a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Expedien
	 */
	public Expedien findSancionByNumeroExpediente(Expedien expedien);

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return ExpedienKgest
	 */
	ExpedienKgest findKgest(ExpedienKgest expedien);

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return List
	 */
	List<ExpedienKgest> findPronunciamientoActKgest(ExpedienKgest expedien);

	/**
	 * Counts rows in the table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return Long
	 */
	Long findPronunciamientoActKgestCount(ExpedienKgest expedien);

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return List
	 */
	List<ExpedienKgest> findPronunciamientoReclKgest(ExpedienKgest expedien);

	/**
	 * Counts rows in the table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return Long
	 */
	Long findPronunciamientoReclKgestCount(ExpedienKgest expedien);

	/**
	 * Finds a single row in the ExpedienKgest table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return List
	 */
	List<ExpedienKgest> findPronunciamientoOtrasKgest(ExpedienKgest expedien);

	/**
	 * Counts rows in the table.
	 * 
	 * @param expedien
	 *            ExpedienKgest
	 * @return Long
	 */
	Long findPronunciamientoOtrasKgestCount(ExpedienKgest expedien);

	/**
	 * Finds a List of rows in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Expedien> findAll(Expedien expedien, Pagination pagination);

	/**
	 * Counts rows in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Long
	 */
	Long findAllCount(Expedien expedien);

	/**
	 * Finds rows in the Expedien table using like.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Expedien> findAllLike(Expedien expedien, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Expedien table using like.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Expedien expedien, Boolean startsWith);

	/**
	 * Deletes a single row in the Expedien table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return
	 */
	void remove(Expedien expedien);

	/**
	 * Deletes multiple rows in the Expedien table.
	 * 
	 * @param expedienList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Expedien> expedienList);

	/**
	 * METODOS DE BUSQUEDA PARA EL FILTRO/BUSQUEDA DE EXPEDIENTES SANCIONADORES
	 */

	/**
	 * Finds a List of rows in the FiltroSanciones table.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Expedien> findAllSanciones(FiltroSanciones filtroSanciones,
			Pagination pagination);

	/**
	 * Counts rows in the FiltroSanciones table.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return Long
	 */
	Long findAllCountSanciones(FiltroSanciones filtroSanciones);

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<FiltroSanciones> findAllLikeSanciones(FiltroSanciones filtroSanciones,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCountSanciones(FiltroSanciones filtroSanciones,
			Boolean startsWith);

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param excodigo
	 *            the excodigo
	 * @param relacionados
	 *            the relacionados
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<FiltroSanciones> findAllSancionesRelacionar(
			FiltroSanciones filtroSanciones, String excodigo,
			String relacionados, Pagination pagination);

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param excodigo
	 *            the excodigo
	 * @param relacionados
	 *            the relacionados
	 * @return Long
	 */
	Long findAllCountSancionesRelacionar(FiltroSanciones filtroSanciones,
			String excodigo, String relacionados);

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @throws Exception
	 *             Exception
	 */
	void updateCambioInstructor(
			SolicitudCambioInstructor solicitudCambioInstructor)
			throws Exception;

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @throws Exception
	 *             the exception
	 */
	void updateTrasvaseTotalCambioInstructor(
			SolicitudCambioInstructor solicitudCambioInstructor)
			throws Exception;

	/**
	 * Finds a List of rows in the Expedien table.
	 * 
	 * @param filtroSanciones
	 *            the filtro sanciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<FiltroSanciones> findAllLikeSancionesBusquedaCombinada(
			FiltroSanciones filtroSanciones, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Expedien table.
	 * 
	 * @param filtroSanciones
	 *            the filtro sanciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeSancionesBusquedaCombinadaCount(
			FiltroSanciones filtroSanciones, Boolean startsWith);

	/**
	 * Obtener estado liquidacion.
	 * 
	 * @param expedien
	 *            the expedien
	 * @return the expedien
	 */
	Expedien obtenerEstadoLiquidacion(Expedien expedien);

	/**
	 * Expedientes con recursos.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param saninterv
	 *            the saninterv
	 * @return the list
	 */
	int expedientesConRecursos(Expedien expedien, Saninterv saninterv);

	/**
	 * Expedientes con recursos.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param saninterv
	 *            the saninterv
	 * @param pagination
	 *            the pagination
	 * @return the list
	 */
	List<Expedien> listExpedientesConRecursos(Expedien expedien,
			Saninterv saninterv, Pagination pagination);

	// /**
	// * Actualiza el documento en BBDD despues de insertar el localizador.
	// *
	// * @param documento
	// * Sandoctemp
	// * @return Long
	// * @throws Exception
	// * Exception
	// */
	// Long actualizarDocumentoLocalizadorBBDD(Sandoctemp documento)
	// throws Exception;

	/**
	 * Method 'getCreateFormDetalleConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            the desde
	 * @param accesoPest2
	 *            the acceso pest2
	 * @param excodigo
	 *            String
	 * @param httpRequest
	 *            the http request
	 * @return String
	 */
	ModelAndView getFichaExpedienteSanciones(Model model, String desde,
			String accesoPest2, String excodigo, HttpServletRequest httpRequest);

	/**
	 * Method 'getCreateFormDetalleConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            the desde
	 * @param accesoPest2
	 *            the acceso pest2
	 * @param sinCabecera
	 *            boolean
	 * @param excodigo
	 *            String
	 * @param httpRequest
	 *            the http request
	 * @return String
	 */
	ModelAndView getFichaExpedienteSanciones(Model model, String desde,
			String accesoPest2, boolean sinCabecera, String excodigo,
			HttpServletRequest httpRequest);

	/**
	 * Finds rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<FiltroSanciones> findAllSancionesViaApremio(
			FiltroSanciones filtroSanciones, Pagination pagination);

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return Long
	 */
	Long findAllCountSancionesViaApremio(FiltroSanciones filtroSanciones);

	/**
	 * Actualizar expediente
	 * 
	 * @param expedien
	 *            Expedien
	 * @param saninterv
	 *            Saninterv
	 * @param censoMonitor
	 *            CensoMonitor
	 */
	void actualizarExpedientePlatea(Expedien expedien, Saninterv saninterv,
			CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the SancionDescriptor table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllSancionDescriptor(Expedien expedien,
			Pagination pagination);
}
