package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.EstadopagoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Estadopago;

/**
 * EstadopagoServiceImpl  
 *  
 */

@Service(value = "estadopagoService")
public class EstadopagoServiceImpl implements EstadopagoService {

	@Autowired
	private EstadopagoDao estadopagoDao;

	/**
	 * Inserts a single row in the Estadopago table.
	 *
	 * @param estadopago Estadopago
	 * @return Estadopago
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Estadopago add(Estadopago estadopago) {
		return this.estadopagoDao.add(estadopago);
	}

	/**
	 * Updates a single row in the Estadopago table.
	 *
	 * @param estadopago Estadopago
	 * @return Estadopago
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Estadopago update(Estadopago estadopago) {
		return this.estadopagoDao.update(estadopago);
	 }

	/**
	 * Finds a single row in the Estadopago table.
	 *
	 * @param estadopago Estadopago
	 * @return Estadopago
	 */
	public Estadopago find(Estadopago estadopago) {
		return (Estadopago) this.estadopagoDao.find(estadopago);
	}

	/**
	 * Finds a List of rows in the Estadopago table.
	 *
	 * @param estadopago Estadopago
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Estadopago> findAll(Estadopago estadopago, Pagination pagination) {
		return (List<Estadopago>) this.estadopagoDao.findAll(estadopago, pagination);
	}
    
	/**
	 * Counts rows in the Estadopago table.
	 *
	 * @param estadopago Estadopago
	 * @return Long
	 */
	public Long findAllCount(Estadopago estadopago) {        
		return  this.estadopagoDao.findAllCount(estadopago);
	}

	/**
	 * Finds rows in the Estadopago table using like.
	 *
	 * @param estadopago Estadopago
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Estadopago> findAllLike(Estadopago estadopago, Pagination pagination, Boolean startsWith) {
		return (List<Estadopago>) this.estadopagoDao.findAllLike(estadopago, pagination, startsWith);
	}

	/**
	 * Counts rows in the Estadopago table using like.
	 *
	 * @param estadopago Estadopago
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Estadopago estadopago, Boolean startsWith) {
		return this.estadopagoDao.findAllLikeCount(estadopago, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Estadopago table.
	 *
	 * @param estadopago Estadopago
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Estadopago estadopago) {
		this.estadopagoDao.remove(estadopago);
	}
	
	/**
	 * Deletes multiple rows in the Estadopago table.
	 *
	 * @param estadopagoList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Estadopago> estadopagoList) {
		for (Estadopago  estadopagoAux:estadopagoList) {
			this.estadopagoDao.remove(estadopagoAux);
		}
	}
	
}

