package com.ejie.y41b.service;

//import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.EstablecimientoWSDao;

import java.io.StringWriter;
import java.util.List;
//import java.util.Locale;

//import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.y41b.model.arbitrajeWS.Consulta;
import com.ejie.y41b.model.arbitrajeWS.DatosConsulta;
import com.ejie.y41b.model.arbitrajeWS.DatosEspecificos;
import com.ejie.y41b.model.arbitrajeWS.DatosEstablecimiento;
import com.ejie.y41b.model.arbitrajeWS.DatosEstablecimientos;
import com.ejie.y41b.model.arbitrajeWS.EstablecimientoWS;
import com.ejie.y41b.model.arbitrajeWS.Estado;
import com.ejie.y41b.model.arbitrajeWS.Retorno;

//import org.springframework.context.support.ReloadableResourceBundleMessageSource;

/**
 * EstablecimientoWSServiceImpl  
 * 
 *  
 */

@Service(value = "establecimientoWSService")
public class EstablecimientoWSServiceImpl implements EstablecimientoWSService {

	// @Resource()
	// private ReloadableResourceBundleMessageSource appMessageSource;

	private static final int LONGITUD_MINIMA_CIF = 4;
	private static final int LONGITUD_MINIMA_NOMBRE = 5;

	private static final String OPERACION_REALIZADA_CORRECTAMENTE = "1";
	private static final String ERROR = "0";

	private static final String ERROR_ES = "Excepcin al ejecutar la operacin";
	private static final String ERROR_EU = "Errorea sortu da operazioa egitean";

	private static final String ERROR_LONGITUD_MINIMA_CIF_ES = "El valor de filtro de CIF debe tener una longitud mnima de "
			+ EstablecimientoWSServiceImpl.LONGITUD_MINIMA_CIF + " caracteres";
	private static final String ERROR_LONGITUD_MINIMA_CIF_EU = "CIF iragazkiaren balioa ezin da izan "
			+ EstablecimientoWSServiceImpl.LONGITUD_MINIMA_CIF
			+ " karakteretik beherakoa";

	private static final String ERROR_LONGITUD_MINIMA_NOMBRE_ES = "El valor de filtro de nombre debe tener una longitud mnima de "
			+ EstablecimientoWSServiceImpl.LONGITUD_MINIMA_NOMBRE
			+ " caracteres";
	private static final String ERROR_LONGITUD_MINIMA_NOMBRE_EU = "Izen iragazkiaren balioa ezin da izan "
			+ EstablecimientoWSServiceImpl.LONGITUD_MINIMA_NOMBRE
			+ " karakteretik beherakoa";

	@Autowired()
	private EstablecimientoWSDao establecimientoWSDao;

	/**
	 * Finds rows in the EstablecimientoWS table using like.
	 * 
	 * @param establecimientoWS
	 *            EstablecimientoWS
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	private List<DatosEstablecimiento> findAllLike(
			EstablecimientoWS establecimientoWS, Boolean startsWith) {
		return (List<DatosEstablecimiento>) this.establecimientoWSDao
				.findAllLike(establecimientoWS, startsWith);
	}

	/**
	 * Metodo recuperar los datos de los establecimientos en base a un filtro de
	 * cif
	 * 
	 * @param cif
	 *            String
	 * @return String
	 * @throws Exception
	 *             e
	 */
	public String buscarEstablecimientosPorCif(String cif) throws Exception {
		DatosEspecificos resultado = new DatosEspecificos();
		Consulta consulta = new Consulta();
		DatosConsulta datosConsulta = new DatosConsulta();
		datosConsulta.setCif(cif);
		consulta.setDatosConsulta(datosConsulta);
		resultado.setConsulta(consulta);
		Retorno retorno = new Retorno();
		Estado estado = new Estado();
		retorno.setEstado(estado);
		resultado.setRetorno(retorno);
		if (cif == null
				|| cif.length() < EstablecimientoWSServiceImpl.LONGITUD_MINIMA_CIF) {
			estado.setCodigo(EstablecimientoWSServiceImpl.ERROR);
			// Object[] args = new Object[] {
			// EstablecimientoWSServiceImpl.LONGITUD_MINIMA_CIF };
			// estado.setDescripcion(this.appMessageSource.getMessage(
			// "arbitraje.ws.longitudMinimaCif", args, new Locale(
			// Y41bConstantes.CASTELLANO)));
			// estado.setDescripcionEus(this.appMessageSource.getMessage(
			// "arbitraje.ws.longitudMinimaCif", args, new Locale(
			// Y41bConstantes.EUSKERA)));
			estado.setDescripcion(EstablecimientoWSServiceImpl.ERROR_LONGITUD_MINIMA_CIF_ES);
			estado.setDescripcionEus(EstablecimientoWSServiceImpl.ERROR_LONGITUD_MINIMA_CIF_EU);
		} else {
			EstablecimientoWS establecimientoWS = new EstablecimientoWS();
			establecimientoWS.setCif(cif);
			try {
				List<DatosEstablecimiento> listaDatosEstablecimiento = this
						.findAllLike(establecimientoWS, false);
				DatosEstablecimientos datosEstablecimientos = new DatosEstablecimientos();
				datosEstablecimientos
						.setDatosEstablecimiento(listaDatosEstablecimiento);
				retorno.setDatosEstablecimientos(datosEstablecimientos);
				estado.setCodigo(EstablecimientoWSServiceImpl.OPERACION_REALIZADA_CORRECTAMENTE);
			} catch (Exception e) {
				estado.setCodigo(EstablecimientoWSServiceImpl.ERROR);
				// estado.setDescripcion(this.appMessageSource.getMessage(
				// "arbitraje.ws.excepcion", null, new Locale(
				// Y41bConstantes.CASTELLANO)));
				// estado.setDescripcionEus(this.appMessageSource.getMessage(
				// "arbitraje.ws.excepcion", null, new Locale(
				// Y41bConstantes.EUSKERA)));
				estado.setDescripcion(EstablecimientoWSServiceImpl.ERROR_ES);
				estado.setDescripcionEus(EstablecimientoWSServiceImpl.ERROR_EU);
			}
		}
		return this.obtenerXML(resultado);
	}

	/**
	 * Metodo recuperar los datos de los establecimientos en base a un filtro de
	 * nombre
	 * 
	 * @param nombre
	 *            String
	 * @return String
	 * @throws Exception
	 *             e
	 */
	public String buscarEstablecimientosPorNombre(String nombre)
			throws Exception {

		DatosEspecificos resultado = new DatosEspecificos();
		Consulta consulta = new Consulta();
		DatosConsulta datosConsulta = new DatosConsulta();
		datosConsulta.setNombre(nombre);
		consulta.setDatosConsulta(datosConsulta);
		resultado.setConsulta(consulta);
		Retorno retorno = new Retorno();
		Estado estado = new Estado();
		retorno.setEstado(estado);
		resultado.setRetorno(retorno);
		if (nombre == null
				|| nombre.length() < EstablecimientoWSServiceImpl.LONGITUD_MINIMA_NOMBRE) {
			estado.setCodigo(EstablecimientoWSServiceImpl.ERROR);
			// Object[] args = new Object[] {
			// EstablecimientoWSServiceImpl.LONGITUD_MINIMA_NOMBRE };
			// estado.setDescripcion(this.appMessageSource.getMessage(
			// "arbitraje.ws.longitudMinimaNombre", args, new Locale(
			// Y41bConstantes.CASTELLANO)));
			// estado.setDescripcionEus(this.appMessageSource.getMessage(
			// "arbitraje.ws.longitudMinimaNombre", args, new Locale(
			// Y41bConstantes.EUSKERA)));
			estado.setDescripcion(EstablecimientoWSServiceImpl.ERROR_LONGITUD_MINIMA_NOMBRE_ES);
			estado.setDescripcionEus(EstablecimientoWSServiceImpl.ERROR_LONGITUD_MINIMA_NOMBRE_EU);
		} else {
			EstablecimientoWS establecimientoWS = new EstablecimientoWS();
			establecimientoWS.setRazonSocial(nombre);
			try {
				List<DatosEstablecimiento> listaDatosEstablecimiento = this
						.findAllLike(establecimientoWS, false);
				DatosEstablecimientos datosEstablecimientos = new DatosEstablecimientos();
				datosEstablecimientos
						.setDatosEstablecimiento(listaDatosEstablecimiento);
				retorno.setDatosEstablecimientos(datosEstablecimientos);
				estado.setCodigo(EstablecimientoWSServiceImpl.OPERACION_REALIZADA_CORRECTAMENTE);
			} catch (Exception e) {
				estado.setCodigo(EstablecimientoWSServiceImpl.ERROR);
				// estado.setDescripcion(this.appMessageSource.getMessage(
				// "arbitraje.ws.excepcion", null, new Locale(
				// Y41bConstantes.CASTELLANO)));
				// estado.setDescripcionEus(this.appMessageSource.getMessage(
				// "arbitraje.ws.excepcion", null, new Locale(
				// Y41bConstantes.EUSKERA)));
				estado.setDescripcion(EstablecimientoWSServiceImpl.ERROR_ES);
				estado.setDescripcionEus(EstablecimientoWSServiceImpl.ERROR_EU);
			}
		}
		return this.obtenerXML(resultado);
	}

	/**
	 * obtenerXML
	 * 
	 * @param datosEspecificos
	 *            DatosEspecificos
	 * @return String
	 * @throws Exception
	 *             e
	 */
	private String obtenerXML(DatosEspecificos datosEspecificos)
			throws Exception {
		JAXBContext jaxbContext = JAXBContext
				.newInstance(DatosEspecificos.class);
		Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
		jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT,
				Boolean.TRUE);
		StringWriter sw = new StringWriter();

		jaxbMarshaller.marshal(datosEspecificos, sw);
		return sw.toString();
	}

}
