package com.ejie.y41b.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActaDao;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.AdjunDatosMailEstablecDao;
import com.ejie.y41b.dao.AdjunDatosMailSedeDao;
import com.ejie.y41b.dao.AlertaDao;
import com.ejie.y41b.dao.ArbadhintervDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.ArbnumadhreuDao;
import com.ejie.y41b.dao.ArbpropbandejaDao;
import com.ejie.y41b.dao.DatosMailEstablecimientoDao;
import com.ejie.y41b.dao.DatosMailSedeDao;
import com.ejie.y41b.dao.EsCanalPrioritarioDao;
import com.ejie.y41b.dao.EssaDao;
import com.ejie.y41b.dao.EstablecimArbitraDao;
import com.ejie.y41b.dao.EstablecimSectorDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.dao.ExpedienDao;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.dao.HistoricoDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.PagosDao;
import com.ejie.y41b.dao.SanintervDao;
import com.ejie.y41b.dao.SanpropbandejaDao;
import com.ejie.y41b.dao.SedeDao;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjunDatosAvisosEstablec;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.AlertaDetalle;
import com.ejie.y41b.model.Arbnumadhreu;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.EsCanalPrioritario;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDecisionAnyo;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.EstablecimientoReclamacionesAnyo;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Ooee;
import com.ejie.y41b.model.PlantillaEstablecimientoDetalle;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * EstablecimientoServiceImpl  
 * 
 *  
 */

@Service(value = "establecimientoService")
public class EstablecimientoServiceImpl implements EstablecimientoService {

	private static final Logger logger = LoggerFactory.getLogger(EstablecimientoServiceImpl.class);
	@Autowired
	private EstablecimientoDao establecimientoDao;
	@Autowired
	private EstablecimSectorDao establecimSectorDao;
	@Autowired
	private HechoDenunciadoDao hechoDenunciadoDao;
	@Autowired
	private ActuacionDao actuacionDao;
	@Autowired
	private ActaDao actaDao;
	@Autowired
	private AlertaDao alertaDao;
	@Autowired
	private EstablecimArbitraDao establecimArbitraDao;
	@Autowired
	private SedeDao sedeDao;
	@Autowired
	private IntervinientesDao intervinientesDao;
	@Autowired
	private SanintervDao sanintervDao;
	@Autowired
	private SanpropbandejaDao sanpropbandejaDao;
	@Autowired
	private ExpedienDao expedienDao;
	@Autowired
	private PagosDao pagosDao;
	@Autowired
	private HistoricoDao historicoDao;

	@Autowired
	private AdjunDatosMailEstablecDao adjunDatosMailEstablecDao;
	@Autowired
	private DatosMailEstablecimientoDao datosMailEstablecimientoDao;
	@Autowired
	private AdjunDatosMailSedeDao adjunDatosMailSedeDao;
	@Autowired
	private DatosMailSedeDao datosMailSedeDao;
	@Autowired
	private ArbpropbandejaDao arbpropbandejaDao;
	@Autowired
	private ArbintervDao arbintervDao;
	@Autowired
	private ArbadhintervDao arbadhintervDao;
	@Autowired
	private EssaDao essaDao;
	@Autowired
	private ArbnumadhreuService arbnumadhreuService;
	@Autowired
	private ArbnumadhreuDao arbnumadhreuDao;

	@Autowired()
	private OoeeService ooeeService;

	@Autowired
	private EsCanalPrioritarioDao esCanalPrioritarioDao;

	@Autowired
	private AdjunDatosAvisosEstablecService adjunDatosAvisosEstablecService;

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Establecimiento add(Establecimiento establecimiento) {
		establecimiento.setEscodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		return this.establecimientoDao.add(establecimiento);
	}

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @param establecimSector
	 *            EstablecimSector
	 * @param sedeAux
	 *            Sede
	 * @return Establecimiento
	 * @throws Exception
	 *             e
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Establecimiento addEstablecimiento(Establecimiento establecimiento, EstablecimArbitra establecimArbitra,
			EstablecimSector establecimSector, Sede sedeAux, CensoMonitor censoMonitor) throws Exception {
		// validacion del cif
		if (establecimiento != null && establecimiento.getEstipid() != null
				&& establecimiento.getEstipid().equals(Y41bConstantes.OTROS)) {
			if (Y41bUtils.isValidCIF(establecimiento.getEsnif()) || Y41bUtils.isValidNIF(establecimiento.getEsnif())) {
				throw new Y41bUDAException("error.establecimiento.cifValidoException", true, new Exception());
			}
		}

		boolean usadoNuevoNumeroAdhesion = false;
		int[] nuevoNumeroAdhesion = { 0, 1 };
		try {
			Establecimiento establecimientoAux = new Establecimiento();
			establecimientoAux.setEsnif(establecimiento.getEsnif());

			if (Y41bUtils.isFilled(establecimiento.getEsnif())) {
				if (establecimiento.getEssede() != null && establecimiento.getEssede().equals(Y41bConstantes.SI)) {
					List<Establecimiento> listEstablecimiento = this.establecimientoDao
							.findAllLikeEstablecimiento(establecimientoAux, null, null, false);
					if (listEstablecimiento.size() > 0) {
						boolean existeSede = false;
						String idEstablecimientoSede = null;
						for (Establecimiento estaAux : listEstablecimiento) {
							if (estaAux.getEssede() != null && estaAux.getEssede().equals(Y41bConstantes.SI)) {
								existeSede = true;
								idEstablecimientoSede = estaAux.getEscodigo();
								break;
							}
						}

						if (existeSede) {
							Establecimiento estaAux = new Establecimiento();
							estaAux.setEscodigo(idEstablecimientoSede);
							estaAux.setEssede(Y41bConstantes.NO);

							// update sede antigua como no sede
							this.establecimientoDao.updateSede(estaAux);

							this.datosMailSedeDao.removeAllDatosMailSede(estaAux);

							// eliminar sus sedes establecimiento anterior como
							// sede
							this.sedeDao.removeAllSedes(estaAux);
						}
					}
				}
			}
			if (establecimiento.getEsfeadar() != null) {
				establecimiento.setEsinadar(Y41bConstantes.VALOR_SI);
			} else {
				establecimiento.setEsinadar(Y41bConstantes.VALOR_NO);
			}
			this.establecimientoDao.add(establecimiento);

			// esCanalPrioritario
			if (censoMonitor != null && ((censoMonitor.getPerfilSolicitudes() != null
					&& censoMonitor.getPerfilSolicitudes().getIdPerfil() != null
					&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) ||

					(censoMonitor.getPerfilArbitraje() != null
							&& censoMonitor.getPerfilArbitraje().getIdPerfil() != null && censoMonitor
									.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)))) {

				EsCanalPrioritario esCanalPrioritario = new EsCanalPrioritario();
				esCanalPrioritario.setYgcif(establecimiento.getEsnif());

				long numEsCanalPrioritario = this.esCanalPrioritarioDao
						.findAllLikeEsCanalPrioritarioCount(esCanalPrioritario, false);

				if (numEsCanalPrioritario == Y41bConstantes.NUM_0) {
					EsCanalPrioritario esCanalPrioritarioAux = new EsCanalPrioritario();
					esCanalPrioritarioAux
							.setYgidcanal(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					esCanalPrioritarioAux.setYgcif(establecimiento.getEsnif());
					esCanalPrioritarioAux.setYgcanal(establecimiento.getEsCanalPrioritario());

					esCanalPrioritarioAux = this.esCanalPrioritarioDao.addEsCanalPrioritario(esCanalPrioritarioAux);
				} else {
					esCanalPrioritario = this.esCanalPrioritarioDao.findEsCanalPrioritario(esCanalPrioritario);
					if (esCanalPrioritario.getYgcanal() == null
							|| (esCanalPrioritario.getYgcanal() != null && !esCanalPrioritario.getYgcanal()
									.equalsIgnoreCase(establecimiento.getEsCanalPrioritario()))) {
						esCanalPrioritario.setYgcanal(establecimiento.getEsCanalPrioritario());
						this.esCanalPrioritarioDao.updateEsCanalPrioritario(esCanalPrioritario);
					}
				}
				//
				// if (esCanalPrioritario != null) {
				//
				// if
				// (!esCanalPrioritario.getYgcanal().equalsIgnoreCase(establecimiento.getEsCanalPrioritario()))
				// {
				// esCanalPrioritario.setYgidcanal(establecimiento.getEsCanalPrioritario());
				// this.esCanalPrioritarioDao.updateEsCanalPrioritario(esCanalPrioritario);
				// }
				//
				// } else {
				// EsCanalPrioritario esCanalPrioritarioAux = new
				// EsCanalPrioritario();
				// esCanalPrioritarioAux
				// .setYgidcanal(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				// esCanalPrioritarioAux.setYgcif(establecimiento.getEsnif());
				// esCanalPrioritarioAux.setYgcanal(establecimiento.getEsCanalPrioritario());
				//
				// esCanalPrioritarioAux =
				// this.esCanalPrioritarioDao.addEsCanalPrioritario(esCanalPrioritarioAux);
				// }

				// esCanalPrioritario.setYgidcanal(establecimiento.getEsCanalPrioritario());
				// if (numEsCanalPrioritario == Y41bConstantes.NUM_0) {
				// esCanalPrioritario.setYgidcanal(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				// esCanalPrioritario =
				// this.esCanalPrioritarioDao.addEsCanalPrioritario(esCanalPrioritario);
				// } else {
				// this.esCanalPrioritarioDao.updateEsCanalPrioritario(esCanalPrioritario);
				// }
			}

			if (establecimiento.getEsfeadar() != null) {
				establecimArbitra.setEstablecimiento(establecimiento);
				establecimArbitra.setAhcodigo(establecimiento.getEscodigo());
				nuevoNumeroAdhesion = this.arbnumadhreuDao.obtenerNumeroAdhesion();
				usadoNuevoNumeroAdhesion = true;
				establecimArbitra.setAhnrdi(Integer.valueOf(nuevoNumeroAdhesion[0]));
				if (establecimArbitra.getAhfeba() != null) {
					establecimArbitra.setAhindef(Y41bConstantes.NO);
					establecimArbitra
							.setAhfeba(Y41bUtils.addDays(establecimArbitra.getAhfere(), Y41bConstantes.NUM_30));
					establecimArbitra.setAhfere(establecimArbitra.getAhfere());
				} else {
					establecimArbitra.setAhindef(Y41bConstantes.SI);
					establecimArbitra.setAhfere(null);
					establecimArbitra.setAhfeba(null);
				}
				this.establecimArbitraDao.add(establecimArbitra);
			}

			establecimSector.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
			establecimSector.setEacodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			this.establecimSectorDao.add(establecimSector);

			this.establecimientoDao.addEstablecimientoDescriptor(establecimiento);

			this.datosMailEstablecimientoDao.addDatosMailEstablecAdjunDatos(establecimiento);

			this.adjunDatosMailEstablecDao.removeAllAdjunDatosMailEstablec(establecimiento);

			AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
			adjunDatosAvisosEstablec.setYiescif(establecimiento.getEsnif());
			this.adjunDatosAvisosEstablecService.guardarAvisosMultiple(adjunDatosAvisosEstablec);

			if (establecimiento.getEssede() != null && establecimiento.getEssede().equals(Y41bConstantes.SI)) {
				this.datosMailSedeDao.removeAllDatosMailSede(establecimiento);
				this.sedeDao.removeAllSedes(establecimiento);

				for (Sede sede : establecimiento.getSedes()) {
					sede.setEscodigo(establecimiento.getEscodigo());
					sede.setIdDatosede(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

					if (sede.getExtranjero().equalsIgnoreCase(Y41bConstantes.NO)) {
						sede.setNoraPaisId(null);
						sede.setNoraPaisNombre(null);

						if (sede.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_ARABA)
								|| sede.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)
								|| sede.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
							sede.setDireccionNocapv(null);
						} else {
							sede.setNombreCalle(null);
							sede.setNoraCalleId(null);
							sede.setNoraPortalId(null);
							sede.setNombrePortal(null);
							sede.setNombrePiso(null);
						}
					} else {
						sede.setNoraProvinciaId(null);
						sede.setNombreProvincia(null);
						sede.setNoraMunicipioId(null);
						sede.setNombreMunicipio(null);
						sede.setNoraLocalidadId(null);
						sede.setNombreLocalidad(null);
						sede.setNoraCalleId(null);
						sede.setNombreCalle(null);
						sede.setNoraPortalId(null);
						sede.setNombrePortal(null);
						sede.setNombrePiso(null);
					}

					this.sedeDao.add(sede);

					this.datosMailSedeDao.addDatosMailSedeAdjunDatos(sede, sedeAux);
				}
				this.adjunDatosMailSedeDao.removeAllAdjunDatosMailEstablecSede(sedeAux);
			} else {
				this.sedeDao.removeAllSedes(establecimiento);
			}
		} catch (Exception e) {
			if (usadoNuevoNumeroAdhesion && nuevoNumeroAdhesion[1] == 0 && nuevoNumeroAdhesion[0] != 0) {
				this.reutilizarNumeroAdhesion(new BigDecimal(nuevoNumeroAdhesion[0]));
			}
			throw e;
		}

		return establecimiento;
	}

	/**
	 * Devuelve true si existe una sede, y false si no existe para ese CIF
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return boolean
	 */
	public boolean existeSede(Establecimiento establecimiento) {
		boolean existeSede = false;

		List<Establecimiento> listEstablecimiento = this.establecimientoDao.findAllLikeEstablecimiento(establecimiento,
				null, null, false);
		if (listEstablecimiento.size() > 0) {
			for (Establecimiento estaAux : listEstablecimiento) {
				if (estaAux.getEssede() != null && estaAux.getEssede().equals(Y41bConstantes.SI)) {
					existeSede = true;
					break;
				}
			}
		}

		return existeSede;
	}

	/**
	 * Devuelve los datos del establecimiento que es sede
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	public Establecimiento obtenerEstablecimientoSede(Establecimiento establecimiento) {
		List<Establecimiento> listEstablecimiento = this.establecimientoDao.findAllLikeEstablecimiento(establecimiento,
				null, null, false);
		if (listEstablecimiento.size() > 0) {
			for (Establecimiento estaAux : listEstablecimiento) {
				if (estaAux.getEssede() != null && estaAux.getEssede().equals(Y41bConstantes.SI)) {
					return estaAux;
				}
			}
		}
		// No se ha encontrado sede
		return null;
	}

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimientoBueno
	 *            Establecimiento
	 * @param establecimientosListABorrar
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void fusionEstablecimientos(Establecimiento establecimientoBueno,
			ArrayList<Establecimiento> establecimientosListABorrar) {
		for (Establecimiento establecimientoAux : establecimientosListABorrar) {

			// Hechos Denunciados
			HechoDenunciado hechodenunciado = new HechoDenunciado();
			hechodenunciado.setEstablecimiento(establecimientoAux);

			List<HechoDenunciado> listHechoDenunciado = this.hechoDenunciadoDao
					.findAllHechosEstablecimiento(hechodenunciado, null);

			for (HechoDenunciado hechoDenunciadoAux : listHechoDenunciado) {

				hechoDenunciadoAux.getEstablecimiento().setEscodigo(establecimientoBueno.getEscodigo());
				this.hechoDenunciadoDao.updateEstablecimiento(hechoDenunciadoAux);
			}

			// Intervinientes Solicitudes
			this.intervinientesDao.updateEstablecimiento(establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Expediente sanciones
			this.expedienDao.updateEstablecimiento(establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Intervinientes Sanciones
			this.sanintervDao.updateEstablecimiento(establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Bandeja Propuestas Sanciones
			this.sanpropbandejaDao.updateEstablecimiento(establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Bandeja Propuestas Arbitraje
			this.arbpropbandejaDao.updateEstablecimiento(establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Pagos
			this.pagosDao.updateEstablecimiento(establecimientoBueno.getEscodigo(), establecimientoAux.getEscodigo());

			// Historico
			this.historicoDao.updateEstablecimiento(establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Actas
			Acta acta = new Acta();
			acta.setEstablecimiento(establecimientoAux);

			List<Acta> listActa = this.actaDao.findAllActaEstablecimiento(acta, null);

			for (Acta actaAux : listActa) {

				actaAux.getEstablecimiento().setEscodigo(establecimientoBueno.getEscodigo());
				this.actaDao.updateEstablecimiento(actaAux);
			}

			// Visitas
			Actuacion actuacion = new Actuacion();
			actuacion.setEstablecimiento(establecimientoAux);

			List<Actuacion> listActuacion = this.actuacionDao.findAllActuacionEstablecimiento(actuacion, null);

			for (Actuacion actuacionAux : listActuacion) {

				actuacionAux.getEstablecimiento().setEscodigo(establecimientoBueno.getEscodigo());
				this.actuacionDao.updateEstablecimiento(actuacionAux);
			}

			// Alertas
			Alerta alerta = new Alerta();
			Establecimiento establecimientoAlerta = new Establecimiento();
			establecimientoAlerta.setEscodigo(establecimientoAux.getEscodigo());
			alerta.setEstablecimiento(establecimientoAlerta);

			List<AlertaDetalle> listAlertaDetalle = this.alertaDao.findAllAlertaEstablecimiento(alerta, null);

			for (AlertaDetalle alertaDetalleAux : listAlertaDetalle) {

				alertaDetalleAux.setEscodigo(establecimientoBueno.getEscodigo());
				this.alertaDao.updateEstablecimiento(alertaDetalleAux);
			}

			EstablecimSector establecimsector = new EstablecimSector();
			establecimsector.setEstablecimiento(establecimientoAux);

			// Solicitud Arbitraje
			this.establecimArbitraDao.updateEstablecimiento(establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Intervinientes Arbitraje
			this.arbintervDao.updateEstablecimiento(establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			// Intervinientes Adhesiones
			this.arbadhintervDao.updateEstablecimiento(establecimientoBueno.getEscodigo(),
					establecimientoAux.getEscodigo());

			this.datosMailEstablecimientoDao.removeAllDatosMailEstablec(establecimientoAux);
			this.datosMailSedeDao.removeAllDatosMailSede(establecimientoAux);

			this.sedeDao.removeAllSedes(establecimientoAux);
			this.establecimientoDao.removeAllEstablecimientoDescriptor(establecimientoAux);

			this.establecimSectorDao.removeSectorEstablecimiento(establecimsector);
			this.establecimientoDao.remove(establecimientoAux);
		}
	}

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Establecimiento update(Establecimiento establecimiento) {
		return this.establecimientoDao.update(establecimiento);
	}

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @param establecimSector
	 *            EstablecimSector
	 * @param sedeAux
	 *            Sede
	 * @return Establecimiento
	 * @throws Exception
	 *             e
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Establecimiento updateEstablecimiento(Establecimiento establecimiento, EstablecimArbitra establecimArbitra,
			EstablecimSector establecimSector, Sede sedeAux, CensoMonitor censoMonitor) throws Exception {
		// validacion del cif
		if (establecimiento != null && establecimiento.getEstipid() != null
				&& establecimiento.getEstipid().equals(Y41bConstantes.OTROS)) {
			if (Y41bUtils.isValidCIF(establecimiento.getEsnif()) || Y41bUtils.isValidNIF(establecimiento.getEsnif())) {
				throw new Y41bUDAException("error.establecimiento.cifValidoException", true, new Exception());
			}
		}

		boolean usadoNuevoNumeroAdhesion = false;
		int[] nuevoNumeroAdhesion = { 0, 1 };
		try {
			if (Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhcodigo())) {
				if (establecimiento.getEsfeadar() != null) {
					establecimArbitra.setEstablecimiento(establecimiento);
					establecimArbitra.setAhcodigo(establecimiento.getEscodigo());
					nuevoNumeroAdhesion = this.arbnumadhreuDao.obtenerNumeroAdhesion();
					usadoNuevoNumeroAdhesion = true;
					establecimArbitra.setAhnrdi(Integer.valueOf(nuevoNumeroAdhesion[0]));
					this.establecimArbitraDao.add(establecimArbitra);
					establecimiento.setEsinadar(Y41bConstantes.VALOR_SI);
				} else {
					establecimiento.setEsinadar(Y41bConstantes.VALOR_NO);
				}
			} else {
				EstablecimArbitra establecimArbitraBD = this.establecimArbitraDao.find(establecimArbitra);
				establecimArbitraBD.setAhcoja(establecimArbitra.getAhcoja());
				establecimArbitraBD.setAhtelimi(establecimArbitra.getAhtelimi());
				establecimArbitraBD.setAhpetact(establecimArbitra.getAhpetact());
				establecimArbitraBD.setAhmedia(establecimArbitra.getAhmedia());
				if (establecimArbitra.getAhfeba() != null) {
					establecimArbitraBD.setAhindef(Y41bConstantes.NO);
					establecimArbitraBD.setAhfeba(establecimArbitra.getAhfeba());
					establecimArbitraBD.setAhfere(establecimArbitra.getAhfere());
				} else {
					establecimArbitraBD.setAhindef(Y41bConstantes.SI);
					establecimArbitraBD.setAhfere(null);
					establecimArbitraBD.setAhfeba(null);
				}
				if (establecimiento.getEsfeadar() != null) {
					this.establecimArbitraDao.update(establecimArbitraBD);
					establecimiento.setEsinadar(Y41bConstantes.VALOR_SI);
				} else {
					this.establecimArbitraDao.remove(establecimArbitraBD);
					establecimiento.setEsinadar(Y41bConstantes.VALOR_NO);
				}
			}
			this.establecimientoDao.update(establecimiento);

			// esCanalPrioritario
			if (censoMonitor != null && ((censoMonitor.getPerfilSolicitudes() != null
					&& censoMonitor.getPerfilSolicitudes().getIdPerfil() != null
					&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) ||

					(censoMonitor.getPerfilArbitraje() != null
							&& censoMonitor.getPerfilArbitraje().getIdPerfil() != null && censoMonitor
									.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)))) {

				EsCanalPrioritario esCanalPrioritario = new EsCanalPrioritario();
				esCanalPrioritario.setYgcif(establecimiento.getEsnif());

				long numEsCanalPrioritario = this.esCanalPrioritarioDao
						.findAllLikeEsCanalPrioritarioCount(esCanalPrioritario, false);

				if (numEsCanalPrioritario == Y41bConstantes.NUM_0) {
					EsCanalPrioritario esCanalPrioritarioAux = new EsCanalPrioritario();
					esCanalPrioritarioAux
							.setYgidcanal(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					esCanalPrioritarioAux.setYgcif(establecimiento.getEsnif());
					esCanalPrioritarioAux.setYgcanal(establecimiento.getEsCanalPrioritario());

					esCanalPrioritarioAux = this.esCanalPrioritarioDao.addEsCanalPrioritario(esCanalPrioritarioAux);
				} else {
					esCanalPrioritario = this.esCanalPrioritarioDao.findEsCanalPrioritario(esCanalPrioritario);
					if (esCanalPrioritario.getYgcanal() == null
							|| (esCanalPrioritario.getYgcanal() != null && !esCanalPrioritario.getYgcanal()
									.equalsIgnoreCase(establecimiento.getEsCanalPrioritario()))) {
						esCanalPrioritario.setYgcanal(establecimiento.getEsCanalPrioritario());
						this.esCanalPrioritarioDao.updateEsCanalPrioritario(esCanalPrioritario);
					}
				}
			}
			//

			Establecimiento establecimientoAux = new Establecimiento();
			establecimientoAux.setEsnif(establecimiento.getEsnif());

			if (Y41bUtils.isFilled(establecimiento.getEsnif())) {
				if (establecimiento.getEssede() != null && establecimiento.getEssede().equals(Y41bConstantes.SI)) {
					List<Establecimiento> listEstablecimiento = this.establecimientoDao
							.findAllLikeEstablecimiento(establecimientoAux, null, null, false);
					if (listEstablecimiento.size() > 0) {
						boolean existeSede = false;
						String idEstablecimientoSede = null;
						for (Establecimiento estaAux : listEstablecimiento) {
							if (estaAux.getEssede() != null && estaAux.getEssede().equals(Y41bConstantes.SI)) {
								if (!estaAux.getEscodigo().equals(establecimiento.getEscodigo())) {
									existeSede = true;
									idEstablecimientoSede = estaAux.getEscodigo();
									break;
								}
							}
						}

						if (existeSede) {
							Establecimiento estaAux = new Establecimiento();
							estaAux.setEscodigo(idEstablecimientoSede);
							estaAux.setEssede(Y41bConstantes.NO);

							// update sede antigua como no sede
							this.establecimientoDao.updateSede(estaAux);

							this.datosMailSedeDao.removeAllDatosMailSede(estaAux);

							// eliminar sus sedes establecimiento anterior como
							// sede
							this.sedeDao.removeAllSedes(estaAux);
						}
					}
				}
			}

			EstablecimSector establecSectorAux = (EstablecimSector) this.establecimSectorDao
					.findSectorEstablecimiento(establecimSector);

			if (Y41bUtils.isFilled(establecSectorAux.getEacodigo())) {
				this.establecimSectorDao.update(establecimSector);
			} else {
				establecimSector.setEacodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

				this.establecimSectorDao.add(establecimSector);
			}

			// Descriptores
			this.establecimientoDao.removeAllEstablecimientoDescriptor(establecimiento);
			this.establecimientoDao.addEstablecimientoDescriptor(establecimiento);

			this.datosMailEstablecimientoDao.removeAllDatosMailEstablec(establecimiento);

			this.datosMailEstablecimientoDao.addDatosMailEstablecAdjunDatos(establecimiento);

			this.adjunDatosMailEstablecDao.removeAllAdjunDatosMailEstablec(establecimiento);

			AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
			adjunDatosAvisosEstablec.setYiescif(establecimiento.getEsnif());
			this.adjunDatosAvisosEstablecService.guardarAvisosMultiple(adjunDatosAvisosEstablec);

			if (establecimiento.getEssede() != null && establecimiento.getEssede().equals(Y41bConstantes.SI)) {
				this.datosMailSedeDao.removeAllDatosMailSede(establecimiento);
				this.sedeDao.removeAllSedes(establecimiento);

				for (Sede sede : establecimiento.getSedes()) {
					sede.setEscodigo(establecimiento.getEscodigo());
					sede.setIdDatosede(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

					if (sede.getExtranjero().equalsIgnoreCase(Y41bConstantes.NO)) {
						sede.setNoraPaisId(null);
						sede.setNoraPaisNombre(null);

						if (sede.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_ARABA)
								|| sede.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)
								|| sede.getNoraProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
							sede.setDireccionNocapv(null);
						} else {
							sede.setNombreCalle(null);
							sede.setNoraCalleId(null);
							sede.setNoraPortalId(null);
							sede.setNombrePortal(null);
							sede.setNombrePiso(null);
						}
					} else {
						sede.setNoraProvinciaId(null);
						sede.setNombreProvincia(null);
						sede.setNoraMunicipioId(null);
						sede.setNombreMunicipio(null);
						sede.setNoraLocalidadId(null);
						sede.setNombreLocalidad(null);
						sede.setNoraCalleId(null);
						sede.setNombreCalle(null);
						sede.setNoraPortalId(null);
						sede.setNombrePortal(null);
						sede.setNombrePiso(null);
					}

					this.sedeDao.add(sede);

					this.datosMailSedeDao.addDatosMailSedeAdjunDatos(sede, sedeAux);
				}
				this.adjunDatosMailSedeDao.removeAllAdjunDatosMailEstablecSede(sedeAux);
			} else {
				this.datosMailSedeDao.removeAllDatosMailSede(establecimiento);
				this.sedeDao.removeAllSedes(establecimiento);
			}
		} catch (Exception e) {
			if (usadoNuevoNumeroAdhesion && nuevoNumeroAdhesion[1] == 0 && nuevoNumeroAdhesion[0] != 0) {
				this.reutilizarNumeroAdhesion(new BigDecimal(nuevoNumeroAdhesion[0]));
			}
			throw e;
		}

		return establecimiento;
	}

	/**
	 * Reutilizar numero adhesion.
	 * 
	 * @param numero
	 *            BigDecimal
	 */
	private void reutilizarNumeroAdhesion(BigDecimal numero) {
		this.arbnumadhreuService.add(new Arbnumadhreu(numero));
	}

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	public Establecimiento find(Establecimiento establecimiento) {
		Establecimiento estableci = (Establecimiento) this.establecimientoDao.find(establecimiento);

		return estableci;
	}

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return EstablecimientoDetalle
	 */
	public EstablecimientoDetalle findEstablecimiento(Establecimiento establecimiento) {
		Establecimiento estableci = (Establecimiento) this.establecimientoDao.find(establecimiento);

		StringBuffer direccionCompleta = new StringBuffer();

		if (estableci.getEsnombreCalle() != null && !estableci.getEsnombreCalle().equals("")) {
			direccionCompleta.append(estableci.getEsnombreCalle());

			if (estableci.getEsnombrePortal() != null && !estableci.getEsnombrePortal().equals("")) {
				direccionCompleta.append(", ").append(estableci.getEsnombrePortal());
			}

			if (estableci.getEsnombrePiso() != null && !estableci.getEsnombrePiso().equals("")) {
				direccionCompleta.append(" ").append(estableci.getEsnombrePiso());
			}

			if (estableci.getEsnombreMunicipio() != null && !estableci.getEsnombreMunicipio().equals("")) {
				direccionCompleta.append(" ").append(estableci.getEsnombreMunicipio());
			}

			if (estableci.getEsnombreProvincia() != null && !estableci.getEsnombreProvincia().equals("")) {
				direccionCompleta.append(" ").append(estableci.getEsnombreProvincia());
			}
		} else if (estableci.getEsdireccion_nocapv() != null && !estableci.getEsdireccion_nocapv().equals("")) {
			direccionCompleta.append(estableci.getEsdireccion_nocapv());
			if (estableci.getEsnombreMunicipio() != null && !estableci.getEsnombreMunicipio().equals("")) {
				direccionCompleta.append(" ").append(estableci.getEsnombreMunicipio());
			}
			if (estableci.getEsnombreProvincia() != null && !estableci.getEsnombreProvincia().equals("")) {
				direccionCompleta.append(" ").append(estableci.getEsnombreProvincia());
			}
		}

		estableci.setEsdireccionCompleta(direccionCompleta.toString());

		EstablecimSector establecimSector = new EstablecimSector();
		establecimSector.setEstablecimiento(estableci);
		// establecimSector.getEstablecimiento().setEscodigo(
		// estableci.getEscodigo());

		EstablecimSector establecSector = new EstablecimSector();
		Actividad actividad = new Actividad();
		Sector sector = new Sector();
		establecSector.setActividad(actividad);
		establecSector.setSector(sector);

		establecSector = (EstablecimSector) this.establecimSectorDao.findSectorEstablecimiento(establecimSector);

		EstablecimientoDetalle establecidetalle = new EstablecimientoDetalle(estableci.getEscodigo(),
				estableci.getCensoMonitor().getMocodigo(), estableci.getCensoMonitor().getMonombre(),
				estableci.getCensoMonitor().getUsuarioxlnet(), estableci.getEsnombre(), estableci.getEstipid(),
				estableci.getEsnif(), estableci.getEsnoan(), estableci.getEsnoco(), estableci.getEsnodir(),
				estableci.getEscolo(), estableci.getEsnrcopo(), estableci.getEsnrtel(), estableci.getEsnrfax(),
				estableci.getEscopa(), estableci.getEsincapr(), estableci.getEsindemp(), estableci.getEsteco(),
				estableci.getEsinadar(), estableci.getEsfeadar(), estableci.getEscoem(),
				estableci.getEsmailnotificacion(), estableci.getEsinempr(), estableci.getEsnrtel2(),
				estableci.getEsinfeba(), estableci.getEsfeba(), estableci.getEsnoap1(), estableci.getEsnoap2(),
				estableci.getEsnolo(), estableci.getEscomapv(), estableci.getEscoca(), estableci.getEsnopeco(),
				estableci.getEscoidco(), estableci.getEsinreco(), estableci.getEsfemod(), estableci.getEsinesco(),
				estableci.getEsnomu(), estableci.getEsnorep(), estableci.getEsnifrep(), estableci.getDtteemr(),
				estableci.getEscarep(), estableci.getEsteurl(), estableci.getEscooe(), estableci.getEsnodeco(),
				estableci.getEsintiar(), estableci.getEsfeplad(), estableci.getEsindeme(), estableci.getEsnoraPaisId(),
				estableci.getEsnoraPaisNombre(), estableci.getEsnoraProvinciaId(), estableci.getEsnombreProvincia(),
				estableci.getEsnoraMunicipioId(), estableci.getEsnombreMunicipio(), estableci.getEsnoraLocalidadId(),
				estableci.getEsnombreLocalidad(), estableci.getEsnoraCalleId(), estableci.getEsnombreCalle(),
				estableci.getEsnoraCpId(), estableci.getEsnombreCp(), estableci.getEsnoraPortalId(),
				estableci.getEsnombrePortal(), estableci.getEsnombrePiso(), estableci.getEsdireccion_nocapv(),
				estableci.getEsdireccionCompleta(), estableci.getEsexpedientesAbiertos(), establecSector.getEacodigo(),
				establecSector.getActividad().getAvcodigo(), establecSector.getActividad().getAvnombre(),
				establecSector.getActividad().getAvnombree(), establecSector.getSector().getSecodigo(),
				establecSector.getSector().getSenombre(), establecSector.getSector().getSenombree(),
				establecSector.getEainprse(), estableci.getEsextranjero(), estableci.getEssede());

		establecidetalle.setEsfeerd(estableci.getEsfeerd());

		// 0149469
		establecidetalle.setEsilocalizable(estableci.getEsilocalizable());
		establecidetalle.setEsnocolabora(estableci.getEsnocolabora());
		// 0149469

		HechoDenunciado hechodenunciado = new HechoDenunciado();
		Establecimiento establecimientoAux = new Establecimiento();
		establecimientoAux.setEscodigo(establecimiento.getEscodigo());
		hechodenunciado.setEstablecimiento(establecimientoAux);

		Long numReclamaciones = this.hechoDenunciadoDao.findAllCount(hechodenunciado);
		establecidetalle.setEsnumReclamaciones(numReclamaciones.toString());

		StringBuffer direccionAntiguaCompleta = new StringBuffer();

		String escomapv = (estableci.getEscomapv() == null) ? "" : estableci.getEscomapv();
		String esnomu = (estableci.getEsnomu() == null) ? "" : estableci.getEsnomu();
		String esnolo = (estableci.getEsnolo() == null) ? "" : estableci.getEsnolo();
		String esnodir = (estableci.getEsnodir() == null) ? "" : estableci.getEsnodir();
		String esnrcopo = (estableci.getEsnrcopo() == null) ? "" : estableci.getEsnrcopo();

		direccionAntiguaCompleta.append(escomapv).append(" ").append(esnomu).append(" ").append(esnolo).append(" ")
				.append(esnodir).append(" ").append(esnrcopo);

		establecidetalle.setDireccionAntiguaCompleta(direccionAntiguaCompleta.toString());

		String esinadar = "";
		try {
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.getEstablecimiento().setEscodigo(estableci.getEscodigo());
			establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
			if (establecimArbitra != null) {
				establecidetalle.setAhcodigo(establecimArbitra.getAhcodigo());
				establecidetalle.setAhfeba(establecimArbitra.getAhfeba());
				establecidetalle.setAhfere(establecimArbitra.getAhfere());
				establecidetalle.setAhtelimi(establecimArbitra.getAhtelimi());
				establecidetalle.setAhcoja(establecimArbitra.getAhcoja());
				establecidetalle.setEsinadar(estableci.getEsinadar());
				establecidetalle.setAhindef(establecimArbitra.getAhindef());
				establecidetalle.setAhmedia(establecimArbitra.getAhmedia());
				establecidetalle.setAhnrdi(establecimArbitra.getAhnrdi().toString());

				// 0153887 aniadimos caso 'S' cuando este cerrado para que
				// no saque icono
				if (estableci.getEsfeba() != null) {
					esinadar = "S";
				} else if (establecimArbitra.getAhfeba() == null || new Date().before(establecimArbitra.getAhfeba())) {
					if (establecimArbitra.getAhtelimi() != null) {
						esinadar = "L";
					} else {
						esinadar = "A";
					}
				} else if (new Date().equals(establecimArbitra.getAhfeba())
						|| new Date().after(establecimArbitra.getAhfeba())) {
					esinadar = "B";
				}

			}
		} catch (Exception e) {

		}
		establecidetalle.setEsinadar(esinadar);

		// buscar sedes
		if (establecidetalle.getEssede() != null && establecidetalle.getEssede().equals(Y41bConstantes.SI)) {
			Sede sede = new Sede();
			sede.setEscodigo(establecidetalle.getEscodigo());

			List<Sede> listSede = this.sedeDao.findAll(sede, null);
			establecidetalle.setSedes(listSede);
		}

		List<Descriptor> listDescriptor = this.establecimientoDao.findAllEstablecimientoDescriptor(establecimiento,
				null);

		StringBuffer strIdsDescriptores = new StringBuffer();
		StringBuffer strDescsDescriptores = new StringBuffer();

		strDescsDescriptores.append("[");

		boolean firstElement = true;

		// se recorre para obtener los ids de etiquetas
		for (Descriptor descriptor : listDescriptor) {
			if (firstElement) {
				strIdsDescriptores.append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(descriptor.getNombre());
				firstElement = false;
			} else {
				strIdsDescriptores.append(",").append(descriptor.getIdDescriptor());
				strDescsDescriptores.append(",").append(descriptor.getNombre());
			}
		}
		strDescsDescriptores.append("]");

		establecidetalle.setIdsDescriptores(strIdsDescriptores.toString());
		establecidetalle.setDescsDescriptores(strDescsDescriptores.toString());

		// 0157454: Incluir literal Establecimiento cerrado en la pestaa hecho
		// de los expedientes
		establecidetalle.setEstablecimientoCerrado(this.estadoCerradoEstablecimientoCenso(estableci.getEscodigo()));
		// 0157454: Incluir literal Establecimiento cerrado en la pestaa hecho
		// de los expedientes

		EsCanalPrioritario esCanalPrioritario = new EsCanalPrioritario();
		esCanalPrioritario.setYgcif(estableci.getEsnif());
		esCanalPrioritario = this.esCanalPrioritarioDao.findEsCanalPrioritario(esCanalPrioritario);

		if (esCanalPrioritario != null && esCanalPrioritario.getYgcanal() != null) {
			establecidetalle.setEsCanalPrioritario(esCanalPrioritario.getYgcanal());
		}

		return establecidetalle;
	}

	/**
	 * Finds a List of rows in the EstablecimientoDescriptor table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllEstablecimientoDescriptor(Establecimiento establecimiento, Pagination pagination) {
		return (List<Descriptor>) this.establecimientoDao.findAllEstablecimientoDescriptor(establecimiento, pagination);
	}

	/**
	 * Finds all sedes establecimiento.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return List
	 */
	public List<Sede> findAllEstablecimientoAnteriorSedes(Establecimiento establecimiento) {

		String idEstablecimientoSede = null;
		// buscar la sede
		List<Establecimiento> listEstablecimiento = this.establecimientoDao.findAllLikeEstablecimiento(establecimiento,
				null, null, false);
		if (listEstablecimiento.size() > 0) {
			for (Establecimiento estaAux : listEstablecimiento) {
				if (estaAux.getEssede() != null && estaAux.getEssede().equals(Y41bConstantes.SI)) {
					idEstablecimientoSede = estaAux.getEscodigo();
					break;
				}
			}
		}

		// obtener todas las sedes
		List<Sede> listSede = null;
		if (idEstablecimientoSede != null) {
			Sede sede = new Sede();
			sede.setEscodigo(idEstablecimientoSede);

			listSede = this.sedeDao.findAll(sede, null);
		}

		// devolver las sedes
		return listSede;
	}

	/**
	 * Finds a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	public Sede findEstablecimientoSede(Sede sede) {
		List<Sede> listSede = this.sedeDao.findAll(sede, null);
		Sede sedeAux = null;
		if (listSede != null && listSede.size() > 0) {
			sedeAux = new Sede(listSede.get(0).getIdDatosede(), listSede.get(0).getEscodigo(),
					listSede.get(0).getPcodigo(), listSede.get(0).getExtranjero(), listSede.get(0).getNoraPaisId(),
					listSede.get(0).getNoraPaisNombre(), listSede.get(0).getNoraProvinciaId(),
					listSede.get(0).getNombreProvincia(), listSede.get(0).getNoraMunicipioId(),
					listSede.get(0).getNombreMunicipio(), listSede.get(0).getNoraLocalidadId(),
					listSede.get(0).getNombreLocalidad(), listSede.get(0).getNoraCalleId(),
					listSede.get(0).getNombreCalle(), listSede.get(0).getNoraCpId(), listSede.get(0).getNombreCp(),
					listSede.get(0).getNoraPortalId(), listSede.get(0).getNombrePortal(),
					listSede.get(0).getNombrePiso(), listSede.get(0).getDireccionNocapv(), listSede.get(0).getEmail(),
					listSede.get(0).getContacto(), listSede.get(0).getNrtel1(), listSede.get(0).getNrtel2());

			StringBuffer direccionCompleta = new StringBuffer();

			if (sedeAux.getNombreCalle() != null && !sedeAux.getNombreCalle().equals("")) {
				direccionCompleta.append(sedeAux.getNombreCalle());

				if (sedeAux.getNombrePortal() != null && !sedeAux.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(sedeAux.getNombrePortal());
				}

				if (sedeAux.getNombrePiso() != null && !sedeAux.getNombrePiso().equals("")) {
					direccionCompleta.append(" ").append(sedeAux.getNombrePiso());
				}

				if (sedeAux.getNombreMunicipio() != null && !sedeAux.getNombreMunicipio().equals("")) {
					direccionCompleta.append(" ").append(sedeAux.getNombreMunicipio());
				}

			} else if (sedeAux.getDireccionNocapv() != null && !sedeAux.getDireccionNocapv().equals("")) {
				direccionCompleta.append(sedeAux.getDireccionNocapv());
				if (sedeAux.getNombreMunicipio() != null && !sedeAux.getNombreMunicipio().equals("")) {
					direccionCompleta.append(" ").append(sedeAux.getNombreMunicipio());
				}
				if (sedeAux.getNoraPaisNombre() != null && !sedeAux.getNoraPaisNombre().equals("")) {
					direccionCompleta.append(" ").append(sedeAux.getNoraPaisNombre());
				}
			}

			sedeAux.setDireccionCompleta(direccionCompleta.toString());

			if (listSede.get(0).getEmail() != null && !listSede.get(0).getEmail().equals("")) {
				sedeAux.setEmail(listSede.get(0).getEmail());
			} else {
				sedeAux.setEmail("");
			}

		} else {
			sedeAux = new Sede();
			sedeAux.setPcodigo(sede.getPcodigo());
			sedeAux.setEscodigo(sede.getEscodigo());
			sedeAux.setDireccionCompleta("");
			sedeAux.setEmail("");
		}

		return sedeAux;
	}

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Establecimiento> findAll(Establecimiento establecimiento, Pagination pagination) {
		return (List<Establecimiento>) this.establecimientoDao.findAll(establecimiento, pagination);
	}

	/**
	 * Counts rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	public Long findAllCount(Establecimiento establecimiento) {
		return this.establecimientoDao.findAllCount(establecimiento);
	}

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Establecimiento> findAllLike(Establecimiento establecimiento, Pagination pagination,
			Boolean startsWith) {
		return (List<Establecimiento>) this.establecimientoDao.findAllLike(establecimiento, pagination, startsWith);
	}

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Establecimiento> findAllLikeEstablecimiento(Establecimiento establecimiento,
			EstablecimSector establecimSector, Pagination pagination, Boolean startsWith) {

		// Control para poder paginar por un campo calculado - numeroConsulta
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("esdireccionCompleta")) {
				pagination.setSort("ESNOMBRE_CALLE, ESNOMBRE_PORTAL, ESNODIR ");
			}
		}

		List<Establecimiento> listEstablecimiento = this.establecimientoDao.findAllLikeEstablecimiento(establecimiento,
				establecimSector, pagination, startsWith);

		for (Establecimiento establec : listEstablecimiento) {
			// Limitaciones
			if ("A".equals(establec.getEsinadar())) {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establec.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
				if (establecimArbitra != null) {
					if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
						establec.setEsinadar("L");
					}
				}

			}
			StringBuffer direccionCompleta = new StringBuffer();

			if (establec.getEsnombreCalle() != null && !establec.getEsnombreCalle().equals("")) {
				direccionCompleta.append(establec.getEsnombreCalle());

				if (establec.getEsnombrePortal() != null && !establec.getEsnombrePortal().equals("")) {
					direccionCompleta.append(", ").append(establec.getEsnombrePortal());
				}
			} else if (establec.getEsdireccion_nocapv() != null && !establec.getEsdireccion_nocapv().equals("")) {
				direccionCompleta.append(establec.getEsdireccion_nocapv());
			} else if (establec.getEsnodir() != null && !establec.getEsnodir().equals("")) {
				direccionCompleta.append(establec.getEsnodir());
			}

			establec.setEsdireccionCompleta(direccionCompleta.toString());
		}

		return listEstablecimiento;
	}

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<EstablecimientoDetalle> findAllLikeEstablecimientoExtendido(Establecimiento establecimiento,
			EstablecimSector establecimSector, Pagination pagination, Boolean startsWith) {

		// Control para poder paginar por un campo calculado - numeroConsulta
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("esdireccionCompleta")) {
				pagination.setSort("ESNOMBRE_CALLE, ESNOMBRE_PORTAL, ESNODIR ");
			}
		}

		List<EstablecimientoDetalle> listEstablecimiento = this.establecimientoDao
				.findAllLikeEstablecimientoExtendido(establecimiento, establecimSector, pagination, startsWith);

		for (EstablecimientoDetalle establec : listEstablecimiento) {
			if (establec.getEsinadar() != null) {
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.getEstablecimiento().setEscodigo(establec.getEscodigo());
				establecimArbitra = this.establecimArbitraDao.findArbitrajeSinExcepcion(establecimArbitra);

				// Limitaciones
				if (establecimArbitra != null) {
					if (!Y41bUtils.esNullOCadenaVacia(establecimArbitra.getAhtelimi())) {
						establec.setEsinadar("L");
					}
					if (establecimArbitra.getAhnrdi() != null) {
						establec.setAhnrdi(establecimArbitra.getAhnrdi().toString());
					}
					if (establecimArbitra.getAhmedia() != null) {
						establec.setAhmedia(establecimArbitra.getAhmedia().toString());
					}
					if (establecimArbitra.getAhfeba() != null) {
						establec.setAhfeba(establecimArbitra.getAhfeba());
					}
					if (establecimArbitra.getAhfere() != null) {
						establec.setAhfere(establecimArbitra.getAhfere());
					}
				}
			}

			StringBuffer direccionCompleta = new StringBuffer();

			if (establec.getCalleId_label() != null && !establec.getCalleId_label().equals("")) {
				direccionCompleta.append(establec.getCalleId_label());

				if (establec.getEsnombrePortal() != null && !establec.getEsnombrePortal().equals("")) {
					direccionCompleta.append(", ").append(establec.getEsnombrePortal());
				}
			} else if (establec.getEsdireccion_nocapv() != null && !establec.getEsdireccion_nocapv().equals("")) {
				direccionCompleta.append(establec.getEsdireccion_nocapv());
			} else if (establec.getEsnodir() != null && !establec.getEsnodir().equals("")) {
				direccionCompleta.append(establec.getEsnodir());
			}

			establec.setEsdireccionCompleta(direccionCompleta.toString());
		}

		return listEstablecimiento;
	}

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeEstablecimientoCount(Establecimiento establecimiento, EstablecimSector establecimSector,
			Boolean startsWith) {
		return this.establecimientoDao.findAllLikeEstablecimientoCount(establecimiento, establecimSector, startsWith);
	}

	/**
	 * Deletes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Establecimiento establecimiento) {
		this.establecimientoDao.remove(establecimiento);
	}

	/**
	 * Deletes multiple rows in the Establecimiento table.
	 * 
	 * @param establecimientoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Establecimiento> establecimientoList) {
		for (Establecimiento establecimientoAux : establecimientoList) {
			this.establecimientoDao.remove(establecimientoAux);
		}
	}

	/**
	 * Deletes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeEstablecimiento(Establecimiento establecimiento, EstablecimSector establecimSector) {

		try {
			HechoDenunciado hechodenunciado = new HechoDenunciado();
			Establecimiento establecimientoAux = new Establecimiento();
			establecimientoAux.setEscodigo(establecimiento.getEscodigo());
			hechodenunciado.setEstablecimiento(establecimientoAux);

			Long numExpedientesAbiertos = this.hechoDenunciadoDao.findAllExpedientesAbiertosCount(hechodenunciado);

			if (numExpedientesAbiertos > 0) {
				throw new Y41bUDAException("error.establecimientos.ExpedientesAbiertosException", true,
						new Exception());
			}

			this.datosMailEstablecimientoDao.removeAllDatosMailEstablec(establecimiento);
			this.datosMailSedeDao.removeAllDatosMailSede(establecimiento);

			// Descriptores
			this.establecimientoDao.removeAllEstablecimientoDescriptor(establecimiento);
			this.sedeDao.removeAllSedes(establecimiento);

			this.establecimSectorDao.removeSectorEstablecimiento(establecimSector);

			Establecimiento estabecimientoAux2 = new Establecimiento();
			estabecimientoAux2.setEscodigo(establecimiento.getEscodigo());
			estabecimientoAux2 = this.establecimientoDao.find(establecimientoAux);

			this.establecimientoDao.remove(establecimiento);

			Establecimiento estabecimientoAux3 = new Establecimiento();
			estabecimientoAux3.setEsnif(estabecimientoAux2.getEsnif());
			long numEstablecimientos = this.establecimientoDao.findAllLikeEstablecimientoCount(estabecimientoAux3,
					establecimSector, false);
			if (numEstablecimientos == Y41bConstantes.NUM_0) {
				EsCanalPrioritario esCanalPrioritario = new EsCanalPrioritario();
				esCanalPrioritario.setYgcif(estabecimientoAux3.getEsnif());
				this.esCanalPrioritarioDao.remove(esCanalPrioritario);
			}

		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.establecimientos.DataIntegrityViolationException", true, e);
		}
	}

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por año.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EstablecimientoReclamacionesAnyo> findAllEstablecimientoReclamacionesAnyo(
			Establecimiento establecimiento, Pagination pagination) {
		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setEstablecimiento(establecimiento);
		return (List<EstablecimientoReclamacionesAnyo>) this.hechoDenunciadoDao
				.findAllEstablecimientoReclamacionesAnyo(hechoDenunciado, pagination);
	}

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	public Long findAllEstablecimientoReclamacionesAnyoCount(Establecimiento establecimiento) {
		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setEstablecimiento(establecimiento);
		return this.hechoDenunciadoDao.findAllEstablecimientoReclamacionesAnyoCount(hechoDenunciado);
	}

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por decision y por año.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EstablecimientoDecisionAnyo> findAllEstablecimientoDecisionAnyo(Establecimiento establecimiento,
			Pagination pagination) {
		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setEstablecimiento(establecimiento);
		return (List<EstablecimientoDecisionAnyo>) this.hechoDenunciadoDao
				.findAllEstablecimientoDecisionAnyo(hechoDenunciado, pagination);
	}

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	public Long findAllEstablecimientoDecisionAnyoCount(Establecimiento establecimiento) {
		HechoDenunciado hechoDenunciado = new HechoDenunciado();
		hechoDenunciado.setEstablecimiento(establecimiento);
		return this.hechoDenunciadoDao.findAllEstablecimientoDecisionAnyoCount(hechoDenunciado);
	}

	/**
	 * Getter method for EstablecimientoDao
	 * 
	 * @return EstablecimientoDao
	 */
	public EstablecimientoDao getEstablecimientoDao() {
		return this.establecimientoDao;
	}

	/**
	 * Setter method for EstablecimientoDao.
	 * 
	 * @param establecimientoDao
	 *            EstablecimientoDao
	 * @return
	 */
	public void setEstablecimientoDao(EstablecimientoDao establecimientoDao) {
		logger.info("Setting Dependency " + establecimientoDao);
		this.establecimientoDao = establecimientoDao;
	}

	/**
	 * Inserta los mails en la tabla temporal de adjuntar mails
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addAdjunDatosMailEstablecTableTemporal(Establecimiento establecimiento) {
		this.adjunDatosMailEstablecDao.removeAllAdjunDatosMailEstablec(establecimiento);
		this.datosMailEstablecimientoDao.addAdjunDatosMailEstablec(establecimiento);
	}

	/**
	 * Inserta los mails en la tabla temporal de adjuntar mails
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param sedeAux
	 *            Sede
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addAdjunDatosMailEstablecSedeTableTemporal(Establecimiento establecimiento, Sede sedeAux) {
		this.adjunDatosMailSedeDao.removeAllAdjunDatosMailEstablecSede(establecimiento);
		this.datosMailSedeDao.addAdjunDatosMailEstablecSede(establecimiento, sedeAux);
	}

	/**
	 * Elimina los mails en la tabla temporal para sede
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param sedeAux
	 *            Sede
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void resetMailEstablecimientoSede(Establecimiento establecimiento, Sede sedeAux) {
		this.adjunDatosMailSedeDao.removeAllAdjunDatosMailEstablecSede(sedeAux);
		this.datosMailSedeDao.addAdjunDatosMailEstablecSede(establecimiento, sedeAux);
	}

	/**
	 * 
	 * @param relacionadosArb
	 *            String
	 * @param relacionadosSol
	 *            String
	 * @param relacionadosSan
	 *            String
	 * @param relacionadosIns
	 *            String
	 * @param seleccionados
	 *            String
	 * @param tipoproc
	 *            String
	 * @return boolean
	 */
	public boolean comprobarEstablecimiento(String relacionadosArb, String relacionadosSol, String relacionadosSan,
			String relacionadosIns, String seleccionados, String tipoproc) {
		List<Establecimiento> lista = this.establecimientoDao.findAllEstablecimiento(relacionadosArb, relacionadosSol,
				relacionadosSan, relacionadosIns, seleccionados, tipoproc);
		boolean mismoEstablecimiento = false;
		// Contabilizamos aquellos que no tienen establecimiento o tienen cif
		// nulo
		if (lista != null && lista.size() == 1) {
			// Si solo hay un establecimiento pero cif nulo
			if (Y41bUtils.esNullOCadenaVacia(((Establecimiento) lista.get(0)).getEsnif())) {
				// si solo he seleccionado uno, aunque tenga el cif vacio le
				// dejo seguir, en el acuerdo de incoacion luego si que se
				// comprueba que tenga que existir cif
				if (!"".equals(seleccionados)) {
					String[] arrayValores = seleccionados.split(",");
					if (arrayValores.length == 1) {
						mismoEstablecimiento = true;
					} else {
						mismoEstablecimiento = false;
					}
				}
			} else {
				mismoEstablecimiento = true;
			}
		} else {
			// Si hay mas de un establecimiento
			if (lista != null) {
				for (int i = 0; i < lista.size(); i++) {
					Establecimiento establecimiento = (Establecimiento) lista.get(i);
					if (establecimiento != null) {
						if (establecimiento.getEsnif() != null) {
							logger.debug("ESTABLECIMIENTO ACUMULADO: " + establecimiento.getEsnif() + ".");
						} else {
							logger.debug("ESTABLECIMIENTO ACUMULADO CON NIF NULO");
						}
					} else {
						logger.debug("ESTABLECIMIENTO ACUMULADO NULO");
					}
				}
			} else {
				logger.debug("ESTABLECIMIENTO ACUMULADO CON NIF NULO. caso 2.");
			}
			mismoEstablecimiento = false;
		}
		return mismoEstablecimiento;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.EstablecimientoService#findPetActDatos(java.lang
	 * .String, java.lang.String)
	 */
	@Override
	public List<Establecimiento> findAllPetActDatos(String numPetActEst, String mesesPetActEst) {
		return this.establecimientoDao.findAllPetActDatos(numPetActEst, mesesPetActEst);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.EstablecimientoService#findPetActDatos(java.lang
	 * .String, java.lang.String)
	 */
	@Override
	public Long findAllCountPetActDatos(String mesesPetActEst) {
		return this.establecimientoDao.findAllCountPetActDatos(mesesPetActEst);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.EstablecimientoService#updatePetActDatos(java.lang
	 * .String)
	 */
	@Override
	public void updatePetActDatos(String escodigo) {
		this.establecimientoDao.updatePetActDatos(escodigo);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.EstablecimientoService#findMailingIconoWeb(java.
	 * lang .String, java.lang.String)
	 */
	@Override
	public List<Establecimiento> findAllMailingIconoWeb(String numMailsIconoWeb, String mesesMailsIconoWeb) {
		return this.establecimientoDao.findAllMailingIconoWeb(numMailsIconoWeb, mesesMailsIconoWeb);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.EstablecimientoService#findMailingIconoWeb(java.
	 * lang .String, java.lang.String)
	 */
	@Override
	public Long findAllCountMailingIconoWeb(String mesesMailsIconoWeb) {
		return this.establecimientoDao.findAllCountMailingIconoWeb(mesesMailsIconoWeb);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.EstablecimientoService#updateMailingIconoWeb(java.
	 * lang .String)
	 */
	@Override
	public void updateMailingIconoWeb(String escodigo) {
		this.establecimientoDao.updateMailingIconoWeb(escodigo);
	}

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return PlantillaEstablecimientoDetalle
	 */
	public PlantillaEstablecimientoDetalle findPlantillaEstablecimientoDetalle(Establecimiento establecimiento) {

		EstablecimientoDetalle establecimientoDetalle = this.findEstablecimiento(establecimiento);

		PlantillaEstablecimientoDetalle plantillaEstablecimientoDetalle = new PlantillaEstablecimientoDetalle();

		plantillaEstablecimientoDetalle.setEscodigo(establecimientoDetalle.getEscodigo());
		plantillaEstablecimientoDetalle.setEsnombre(establecimientoDetalle.getEsnombre());
		plantillaEstablecimientoDetalle.setEsnif(establecimientoDetalle.getEsnif());
		plantillaEstablecimientoDetalle.setEsnoco(establecimientoDetalle.getEsnoco());

		// Creamos el campo direccion del establecimiento
		StringBuffer direccionCompleta = new StringBuffer();

		if (establecimientoDetalle.getCalleId_label() != null
				&& !establecimientoDetalle.getCalleId_label().equals("")) {
			direccionCompleta.append(establecimientoDetalle.getCalleId_label());

			if (establecimientoDetalle.getEsnombrePortal() != null
					&& !establecimientoDetalle.getEsnombrePortal().equals("")) {
				direccionCompleta.append(", ").append(establecimientoDetalle.getEsnombrePortal());
			}
			if (establecimientoDetalle.getEsnombrePiso() != null
					&& !establecimientoDetalle.getEsnombrePiso().equals("")) {
				direccionCompleta.append(" ").append(establecimientoDetalle.getEsnombrePiso());
			}
		} else {
			if (establecimientoDetalle.getEsdireccion_nocapv() != null
					&& !establecimientoDetalle.getEsdireccion_nocapv().equals("")) {
				direccionCompleta.append(establecimientoDetalle.getEsdireccion_nocapv());

				if (establecimientoDetalle.getEsnoraPaisNombre() != null
						&& !establecimientoDetalle.getEsnoraPaisNombre().equals("")) {
					direccionCompleta.append(" ").append(establecimientoDetalle.getEsnoraPaisNombre());
				}
			} else {
				direccionCompleta.append(establecimientoDetalle.getEsnodir());
			}
		}

		plantillaEstablecimientoDetalle.setEsdireccion(direccionCompleta.toString());
		plantillaEstablecimientoDetalle.setEsnombreLocalidad(establecimientoDetalle.getEsnombreLocalidad());
		plantillaEstablecimientoDetalle.setEsnombreMunicipio(establecimientoDetalle.getEsnombreMunicipio());
		plantillaEstablecimientoDetalle.setEsnombreProvincia(establecimientoDetalle.getEsnombreProvincia());
		plantillaEstablecimientoDetalle.setEsnombreCp(establecimientoDetalle.getEsnombreCp());

		plantillaEstablecimientoDetalle.setEsnrtel(establecimientoDetalle.getEsnrtel());
		plantillaEstablecimientoDetalle.setEsnrtel2(establecimientoDetalle.getEsnrtel2());
		plantillaEstablecimientoDetalle.setEscoem(establecimientoDetalle.getEscoem());
		plantillaEstablecimientoDetalle.setEsteurl(establecimientoDetalle.getEsteurl());

		plantillaEstablecimientoDetalle.setEsnorep(establecimientoDetalle.getEsnorep());
		plantillaEstablecimientoDetalle.setEsnifrep(establecimientoDetalle.getEsnifrep());

		if (establecimientoDetalle.getAhcodigo() != null && (establecimientoDetalle.getAhfeba() == null
				|| (establecimientoDetalle.getAhfeba() != null && (establecimientoDetalle.getAhfeba().after(new Date())
						|| establecimientoDetalle.getAhfeba().equals(new Date()))))) {
			plantillaEstablecimientoDetalle.setEsinadar(Y41bConstantes.VALOR_SI);
		} else {
			plantillaEstablecimientoDetalle.setEsinadar(Y41bConstantes.VALOR_NO);
		}

		plantillaEstablecimientoDetalle.setAhnrdi(establecimientoDetalle.getAhnrdi());
		plantillaEstablecimientoDetalle.setEsfeadar(establecimientoDetalle.getEsfeadar());

		plantillaEstablecimientoDetalle.setSecodigo(establecimientoDetalle.getSecodigo());
		plantillaEstablecimientoDetalle.setSenombre(establecimientoDetalle.getSenombre());

		plantillaEstablecimientoDetalle.setCooe(establecimientoDetalle.getEscooe());

		if (Y41bUtils.isFilled(establecimientoDetalle.getEscooe())) {
			Ooee ooee = new Ooee();
			ooee.setOecodigo(establecimientoDetalle.getEscooe());
			ooee = this.ooeeService.find(ooee);

			if (ooee != null && ooee.getOrganismo() != null) {
				plantillaEstablecimientoDetalle.setOenombre(ooee.getOrganismo().getNombreEs());
			}
		}

		// Devolvemos el objeto
		return plantillaEstablecimientoDetalle;

	}

	/**
	 * estadoAdhesionEstablecimientoCenso
	 * 
	 * @param codigoEstablecimiento
	 *            String
	 * @return String
	 */
	public String estadoAdhesionEstablecimientoCenso(String codigoEstablecimiento) {
		String resultado = "";
		if (!Y41bUtils.esNullOCadenaVacia(codigoEstablecimiento)) {
			Establecimiento establecimiento = new Establecimiento();

			establecimiento.setEscodigo(codigoEstablecimiento);
			try {
				List<Establecimiento> listaEstablecimiento = this.establecimientoDao.findAll(establecimiento, null);
				if (!listaEstablecimiento.isEmpty()) {
					establecimiento = listaEstablecimiento.get(0);
					if (establecimiento.getEsfeadar() != null) {
						EstablecimArbitra establecimArbitra = new EstablecimArbitra();
						establecimArbitra.setEstablecimiento(new Establecimiento());
						establecimArbitra.getEstablecimiento().setEscodigo(establecimiento.getEscodigo());
						establecimArbitra = this.establecimArbitraDao.findArbitraje(establecimArbitra);
						// 0153887 aniadimos caso 'S' cuando este cerrado para
						// que
						// no saque icono
						if (establecimiento.getEsfeba() != null) {
							resultado = "S";
						} else if (establecimArbitra.getAhfeba() == null

								|| new Date().before(establecimArbitra.getAhfeba())) {
							if (establecimArbitra.getAhtelimi() != null) {
								resultado = "L";
							} else {
								resultado = "A";
							}
						} else if (new Date().equals(establecimArbitra.getAhfeba())
								|| new Date().after(establecimArbitra.getAhfeba())) {
							resultado = "B";
						}
					}
				}
			} catch (Exception e) {
				resultado = "";
			}
		}
		return resultado;
	}

	// 0157454: Incluir literal Establecimiento cerrado en la pestaa hecho de
	// los expedientes
	/**
	 * estadoAdhesionEstablecimientoCenso
	 * 
	 * @param codigoEstablecimiento
	 *            String
	 * @return String
	 */
	public String estadoCerradoEstablecimientoCenso(String codigoEstablecimiento) {
		String resultado = "";
		Establecimiento establecimiento = new Establecimiento();
		establecimiento.setEscodigo(codigoEstablecimiento);
		try {
			List<Establecimiento> listaEstablecimiento = this.establecimientoDao.findAll(establecimiento, null);
			if (!listaEstablecimiento.isEmpty()) {
				establecimiento = listaEstablecimiento.get(0);
				if (establecimiento.getEsfeba() != null && establecimiento.getEsfeba().before(Y41bUtils.hoy())) {
					resultado = Y41bConstantes.SI;
				}
			}
		} catch (Exception e) {
			resultado = "";
		}
		return resultado;
	}
	// 0157454: Incluir literal Establecimiento cerrado en la pestaa hecho de
	// los expedientes
}
