package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDecisionAnyo;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.EstablecimientoReclamacionesAnyo;
import com.ejie.y41b.model.PlantillaEstablecimientoDetalle;
import com.ejie.y41b.model.Sede;

/**
 * * EstablecimientoService  
 * 
 *  
 */

public interface EstablecimientoService {

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento add(Establecimiento establecimiento);

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @param establecimSector
	 *            EstablecimSector
	 * @param sedeAux
	 *            Sede
	 * @return Establecimiento
	 */
	public Establecimiento addEstablecimiento(Establecimiento establecimiento, EstablecimArbitra establecimArbitra,
			EstablecimSector establecimSector, Sede sedeAux, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimientoBueno
	 *            Establecimiento
	 * @param establecimientosListABorrar
	 *            ArrayList
	 * @return
	 */
	void fusionEstablecimientos(Establecimiento establecimientoBueno,
			ArrayList<Establecimiento> establecimientosListABorrar);

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento update(Establecimiento establecimiento);

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @param establecimSector
	 *            EstablecimSector
	 * @param sedeAux
	 *            Sede
	 * @return Establecimiento
	 */
	public Establecimiento updateEstablecimiento(Establecimiento establecimiento, EstablecimArbitra establecimArbitra,
			EstablecimSector establecimSector, Sede sedeAux, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Devuelve true si existe una sede, y false si no existe para ese CIF
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return boolean
	 */
	public boolean existeSede(Establecimiento establecimiento);

	/**
	 * Devuelve los datos del establecimiento que es sede
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	public Establecimiento obtenerEstablecimientoSede(Establecimiento establecimiento);

	/**
	 * Finds a List of rows in the EstablecimientoDescriptor table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllEstablecimientoDescriptor(Establecimiento establecimiento, Pagination pagination);

	/**
	 * Finds all sedes establecimiento.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return List
	 */
	public List<Sede> findAllEstablecimientoAnteriorSedes(Establecimiento establecimiento);

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento find(Establecimiento establecimiento);

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return EstablecimientoDetalle
	 */
	EstablecimientoDetalle findEstablecimiento(Establecimiento establecimiento);

	/**
	 * Finds a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	public Sede findEstablecimientoSede(Sede sede);

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Establecimiento> findAll(Establecimiento establecimiento, Pagination pagination);

	/**
	 * Counts rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	Long findAllCount(Establecimiento establecimiento);

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Establecimiento> findAllLike(Establecimiento establecimiento, Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Establecimiento> findAllLikeEstablecimiento(Establecimiento establecimiento, EstablecimSector establecimSector,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<EstablecimientoDetalle> findAllLikeEstablecimientoExtendido(Establecimiento establecimiento,
			EstablecimSector establecimSector, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeEstablecimientoCount(Establecimiento establecimiento, EstablecimSector establecimSector,
			Boolean startsWith);

	/**
	 * Deletes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	void remove(Establecimiento establecimiento);

	/**
	 * Deletes multiple rows in the Establecimiento table.
	 * 
	 * @param establecimientoList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Establecimiento> establecimientoList);

	/**
	 * Deletes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return
	 */
	void removeEstablecimiento(Establecimiento establecimiento, EstablecimSector establecimSector);

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por año.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstablecimientoReclamacionesAnyo> findAllEstablecimientoReclamacionesAnyo(Establecimiento establecimiento,
			Pagination pagination);

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	Long findAllEstablecimientoReclamacionesAnyoCount(Establecimiento establecimiento);

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por decision y por año.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstablecimientoDecisionAnyo> findAllEstablecimientoDecisionAnyo(Establecimiento establecimiento,
			Pagination pagination);

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	Long findAllEstablecimientoDecisionAnyoCount(Establecimiento establecimiento);

	/**
	 * Inserta los mails en la tabla temporal de adjuntar mails
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 */
	public void addAdjunDatosMailEstablecTableTemporal(Establecimiento establecimiento);

	/**
	 * Inserta los mails en la tabla temporal de adjuntar mails
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param sedeAux
	 *            Sede
	 */
	public void addAdjunDatosMailEstablecSedeTableTemporal(Establecimiento establecimiento, Sede sedeAux);

	/**
	 * Elimina los mails en la tabla temporal para sede
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param sedeAux
	 *            Sede
	 */
	public void resetMailEstablecimientoSede(Establecimiento establecimiento, Sede sedeAux);

	/**
	 * 
	 * @param relacionadosArb
	 *            String
	 * @param relacionadosSol
	 *            String
	 * @param relacionadosSan
	 *            String
	 * @param relacionadosIns
	 *            String
	 * @param seleccionados
	 *            String
	 * @param tipoproc
	 *            String
	 * @return boolean
	 */
	public boolean comprobarEstablecimiento(String relacionadosArb, String relacionadosSol, String relacionadosSan,
			String relacionadosIns, String seleccionados, String tipoproc);

	/**
	 * @param numPetActEst
	 * @param mesesPetActEst
	 * @return
	 */
	List<Establecimiento> findAllPetActDatos(String numPetActEst, String mesesPetActEst);

	/**
	 * @param mesesPetActEst
	 * @return
	 */
	Long findAllCountPetActDatos(String mesesPetActEst);

	/**
	 * @param escodigo
	 * @return
	 */
	void updatePetActDatos(String escodigo);

	/**
	 * @param numMailsIconoWeb
	 * @param mesesMailsIconoWeb
	 * @return
	 */
	List<Establecimiento> findAllMailingIconoWeb(String numMailsIconoWeb, String mesesMailsIconoWeb);

	/**
	 * @param mesesMailsIconoWeb
	 * @return
	 */
	Long findAllCountMailingIconoWeb(String mesesMailsIconoWeb);

	/**
	 * @param escodigo
	 * @return
	 */
	void updateMailingIconoWeb(String escodigo);

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return PlantillaEstablecimientoDetalle
	 */
	public PlantillaEstablecimientoDetalle findPlantillaEstablecimientoDetalle(Establecimiento establecimiento);

	/**
	 * estadoAdhesionEstablecimientoCenso
	 * 
	 * @param codigoEstablecimiento
	 *            String
	 * @return String
	 */
	public String estadoAdhesionEstablecimientoCenso(String codigoEstablecimiento);

	/**
	 * estadoAdhesionEstablecimientoCenso
	 * 
	 * @param codigoEstablecimiento
	 *            String
	 * @return String
	 */
	public String estadoCerradoEstablecimientoCenso(String codigoEstablecimiento);
}
