package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.EstablecimSectorDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.EstablecimSector;

/**
 * EstablecimSectorServiceImpl  
 * 
 *  
 */

@Service(value = "EstablecimSectorService")
public class EstablecimSectorServiceImpl implements EstablecimSectorService {

	@Autowired
	private EstablecimSectorDao EstablecimSectorDao;

	/**
	 * Inserts a single row in the EstablecimSector table.
	 * 
	 * @param EstablecimSector
	 *            EstablecimSector
	 * @return EstablecimSector
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EstablecimSector add(EstablecimSector EstablecimSector) {
		return this.EstablecimSectorDao.add(EstablecimSector);
	}

	/**
	 * Updates a single row in the EstablecimSector table.
	 * 
	 * @param EstablecimSector
	 *            EstablecimSector
	 * @return EstablecimSector
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EstablecimSector update(EstablecimSector EstablecimSector) {
		return this.EstablecimSectorDao.update(EstablecimSector);
	}

	/**
	 * Finds a single row in the EstablecimSector table.
	 * 
	 * @param EstablecimSector
	 *            EstablecimSector
	 * @return EstablecimSector
	 */
	public EstablecimSector find(EstablecimSector EstablecimSector) {
		return (EstablecimSector) this.EstablecimSectorDao
				.find(EstablecimSector);
	}

	/**
	 * Finds a List of rows in the EstablecimSector table.
	 * 
	 * @param EstablecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EstablecimSector> findAll(EstablecimSector EstablecimSector,
			Pagination pagination) {
		return (List<EstablecimSector>) this.EstablecimSectorDao.findAll(
				EstablecimSector, pagination);
	}

	/**
	 * Counts rows in the EstablecimSector table.
	 * 
	 * @param EstablecimSector
	 *            EstablecimSector
	 * @return Long
	 */
	public Long findAllCount(EstablecimSector EstablecimSector) {
		return this.EstablecimSectorDao.findAllCount(EstablecimSector);
	}

	/**
	 * Finds rows in the EstablecimSector table using like.
	 * 
	 * @param EstablecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<EstablecimSector> findAllLike(
			EstablecimSector EstablecimSector, Pagination pagination,
			Boolean startsWith) {
		return (List<EstablecimSector>) this.EstablecimSectorDao.findAllLike(
				EstablecimSector, pagination, startsWith);
	}

	// /**
	// * Counts rows in the EstablecimSector table using like.
	// *
	// * @param EstablecimSector
	// * EstablecimSector
	// * @param startsWith
	// * Boolean
	// * @return Long
	// */
	// public Long findAllLikeCount(EstablecimSector EstablecimSector,
	// Boolean startsWith) {
	// return this.EstablecimSectorDao.findAllLikeCount(EstablecimSector);
	// }

	/**
	 * Deletes a single row in the EstablecimSector table.
	 * 
	 * @param EstablecimSector
	 *            EstablecimSector
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EstablecimSector EstablecimSector) {
		this.EstablecimSectorDao.remove(EstablecimSector);
	}

	/**
	 * Deletes multiple rows in the EstablecimSector table.
	 * 
	 * @param EstablecimSectorList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<EstablecimSector> EstablecimSectorList) {
		for (EstablecimSector EstablecimSectorAux : EstablecimSectorList) {
			this.EstablecimSectorDao.remove(EstablecimSectorAux);
		}
	}

}
