package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.EstablecimArbitraDao;
import com.ejie.y41b.model.EstablecimArbitra;

/**
 * * EstablecimArbitraServiceImpl  
 * 
 *  
 */

@Service(value = "establecimArbitraService")
public class EstablecimArbitraServiceImpl implements EstablecimArbitraService {

	private static final Logger logger = LoggerFactory
			.getLogger(EstablecimArbitraServiceImpl.class);

	@Autowired()
	private EstablecimArbitraDao establecimArbitraDao;

	/**
	 * Inserts a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EstablecimArbitra add(EstablecimArbitra establecimArbitra) {
		return this.establecimArbitraDao.add(establecimArbitra);
	}

	/**
	 * Updates a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EstablecimArbitra update(EstablecimArbitra establecimArbitra) {
		return this.establecimArbitraDao.update(establecimArbitra);
	}

	/**
	 * Finds a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	public EstablecimArbitra find(EstablecimArbitra establecimArbitra) {
		return (EstablecimArbitra) this.establecimArbitraDao
				.find(establecimArbitra);
	}

	/**
	 * Finds a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	public EstablecimArbitra findArbitraje(EstablecimArbitra establecimArbitra) {
		return (EstablecimArbitra) this.establecimArbitraDao
				.findArbitraje(establecimArbitra);
	}

	/**
	 * Finds a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	public EstablecimArbitra findArbitrajeSinExcepcion(
			EstablecimArbitra establecimArbitra) {
		EstablecimArbitra resultado = null;
		try {
			resultado = (EstablecimArbitra) this.establecimArbitraDao
					.findArbitrajeSinExcepcion(establecimArbitra);
		} catch (Exception e) {
			resultado = null;
		}
		return resultado;
	}

	/**
	 * Finds a List of rows in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EstablecimArbitra> findAll(EstablecimArbitra establecimArbitra,
			Pagination pagination) {
		return (List<EstablecimArbitra>) this.establecimArbitraDao.findAll(
				establecimArbitra, pagination);
	}

	/**
	 * Counts rows in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return Long
	 */
	public Long findAllCount(EstablecimArbitra establecimArbitra) {
		return this.establecimArbitraDao.findAllCount(establecimArbitra);
	}

	/**
	 * Finds rows in the EstablecimArbitra table using like.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<EstablecimArbitra> findAllLike(
			EstablecimArbitra establecimArbitra, Pagination pagination,
			Boolean startsWith) {
		return (List<EstablecimArbitra>) this.establecimArbitraDao.findAllLike(
				establecimArbitra, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EstablecimArbitra establecimArbitra) {
		this.establecimArbitraDao.remove(establecimArbitra);
	}

	/**
	 * Deletes multiple rows in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitraList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			ArrayList<EstablecimArbitra> establecimArbitraList) {
		for (EstablecimArbitra establecimArbitraAux : establecimArbitraList) {
			this.establecimArbitraDao.remove(establecimArbitraAux);
		}
	}

	/**
	 * Getter method for EstablecimArbitraDao
	 * 
	 * @return EstablecimArbitraDao
	 */
	public EstablecimArbitraDao getEstablecimArbitraDao() {
		return this.establecimArbitraDao;
	}

	/**
	 * Setter method for EstablecimArbitraDao.
	 * 
	 * @param establecimArbitraDao
	 *            EstablecimArbitraDao
	 * @return
	 */
	public void setEstablecimArbitraDao(
			EstablecimArbitraDao establecimArbitraDao) {
		EstablecimArbitraServiceImpl.logger.info("Setting Dependency "
				+ establecimArbitraDao);
		this.establecimArbitraDao = establecimArbitraDao;
	}
}
