package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y41b.model.EstablecimArbitra;

/**
 * * EstablecimArbitraService  
 * 
 *  
 */

public interface EstablecimArbitraService {

	/**
	 * Inserts a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	EstablecimArbitra add(EstablecimArbitra establecimArbitra);

	/**
	 * Updates a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	EstablecimArbitra update(EstablecimArbitra establecimArbitra);

	/**
	 * Finds a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	EstablecimArbitra find(EstablecimArbitra establecimArbitra);

	/**
	 * Finds a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	EstablecimArbitra findArbitraje(EstablecimArbitra establecimArbitra);

	/**
	 * Finds a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	EstablecimArbitra findArbitrajeSinExcepcion(
			EstablecimArbitra establecimArbitra);

	/**
	 * Finds a List of rows in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstablecimArbitra> findAll(EstablecimArbitra establecimArbitra,
			Pagination pagination);

	/**
	 * Counts rows in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return Long
	 */
	Long findAllCount(EstablecimArbitra establecimArbitra);

	/**
	 * Finds rows in the EstablecimArbitra table using like.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<EstablecimArbitra> findAllLike(EstablecimArbitra establecimArbitra,
			Pagination pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return
	 */
	void remove(EstablecimArbitra establecimArbitra);

	/**
	 * Deletes multiple rows in the EstablecimArbitra table.
	 * 
	 * @param establecimArbitraList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<EstablecimArbitra> establecimArbitraList);

}
