package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.EssaDao;
import com.ejie.y41b.dao.EstablecimientoDao;
import com.ejie.y41b.model.Essa;
import com.ejie.y41b.model.Establecimiento;

/**
 * EssaServiceImpl  
 * 
 *  
 */

@Service(value = "essaService")
public class EssaServiceImpl implements EssaService {

	@Autowired
	private EssaDao essaDao;
	@Autowired
	private EstablecimientoDao establecimientoDao;

	/**
	 * Inserts a single row in the Essa table.
	 * 
	 * @param essa
	 *            Essa
	 * @return Essa
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Essa add(Essa essa) {
		return this.essaDao.add(essa);
	}

	/**
	 * Updates a single row in the Essa table.
	 * 
	 * @param essa
	 *            Essa
	 * @return Essa
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Essa update(Essa essa) {
		return this.essaDao.update(essa);
	}

	/**
	 * Finds a single row in the Essa table.
	 * 
	 * @param essa
	 *            Essa
	 * @return Essa
	 */
	public Essa find(Essa essa) {
		return (Essa) this.essaDao.find(essa);
	}

	/**
	 * Finds a List of rows in the Essa table.
	 * 
	 * @param essa
	 *            Essa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Essa> findAll(Essa essa, Pagination pagination) {
		List<Essa> lessa = (List<Essa>) this.essaDao.findAll(essa, pagination);
		if (lessa != null && lessa.size() > 0) {
			Establecimiento establecimiento = null;
			for (int i = 0; i < lessa.size(); i++) {
				establecimiento = lessa.get(i).getEstablecimiento();
				establecimiento = this.establecimientoDao.find(establecimiento);
				lessa.get(i).setEstablecimiento(establecimiento);
			}
		}
		return lessa;
	}

	/**
	 * Counts rows in the Essa table.
	 * 
	 * @param essa
	 *            Essa
	 * @return Long
	 */
	public Long findAllCount(Essa essa) {
		return this.essaDao.findAllCount(essa);
	}

	/**
	 * Finds rows in the Essa table using like.
	 * 
	 * @param essa
	 *            Essa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Essa> findAllLike(Essa essa, Pagination pagination,
			Boolean startsWith) {
		return (List<Essa>) this.essaDao.findAllLike(essa, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Essa table using like.
	 * 
	 * @param essa
	 *            Essa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Essa essa, Boolean startsWith) {
		return this.essaDao.findAllLikeCount(essa, startsWith);
	}

	/**
	 * Deletes a single row in the Essa table.
	 * 
	 * @param essa
	 *            Essa
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Essa essa) {
		this.essaDao.remove(essa);
	}

	/**
	 * Deletes multiple rows in the Essa table.
	 * 
	 * @param essaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Essa> essaList) {
		for (Essa essaAux : essaList) {
			this.essaDao.remove(essaAux);
		}
	}

}
